/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */

// Google Tests
#include <gtest/gtest.h>

// Standard Library
#include <string>

// Media Scanner
#include "mediascanner/glibutils.h"
#include "mediascanner/utilities.h"

// Test Suite
#include "testlib/testutils.h"

namespace mediascanner {

TEST(GlibUtilsTest, ErrorString) {
    const GQuark error_domain = g_quark_from_static_string("test-error");
    const std::string error_message("This is a test");
    const int error_code = 42;

    Wrapper<GError> error;

    g_set_error_literal(error.out_param(), error_domain,
                        error_code, error_message.c_str());

    EXPECT_EQ(error_domain, error->domain);
    EXPECT_EQ(error_code, error->code);
    EXPECT_EQ(error_message, safe_string(error->message));
    EXPECT_EQ("test-error(42): This is a test", to_string(error));
}

} // namespace mediascanner

int main(int argc, char *argv[]) {
    mediascanner::InitTests(&argc, argv);
    return RUN_ALL_TESTS();
}
