# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class PolyDataPlaneCutter(PolyDataAlgorithm):
    r"""
    PolyDataPlaneCutter - threaded (high-performance) cutting of a
    PolyData with a plane
    
    Superclass: PolyDataAlgorithm
    
    PolyDataPlaneCutter cuts an input PolyData with a plane to
    produce an output PolyData. (Here cutting means slicing through
    the polydata to generates lines of intersection.) The input
    PolyData must consist of convex polygons - vertices, lines, and
    triangle strips are ignored. (Note: use TriangleFilter to
    triangulate non-convex input polygons if necessary. If the input
    cells are non-convex, then the cutting operation will likely produce
    erroneous results.)
    
    The main difference between this filter and other cutting filters is
    that PolyDataPlaneCutter is tuned for performance on PolyData
    with convex polygonal cells.
    
    @warning
    The method can_fully_process_data_object() is available to see whether
    the input data can be successully processed by this filter. Use this
    method sparingly because it can be slow.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    PlaneCutter Cutter PolyDataPlaneClipper
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPolyDataPlaneCutter, obj, update, **traits)
    
    compute_normals = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get the computation of normals. The normal generated is
        simply the cut plane normal. The normals are associated with the
        output points. By default the computation of normals is disabled.
        """
    )

    def _compute_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeNormals,
                        self.compute_normals_)

    interpolate_attributes = tvtk_base.true_bool_trait(desc=\
        r"""
        Indicate whether to interpolate attribute data. By default this
        is enabled. Note that both cell data and point data is
        interpolated and output.
        """
    )

    def _interpolate_attributes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolateAttributes,
                        self.interpolate_attributes_)

    batch_size = traits.Trait(10000, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the number of input cells in a batch, where a batch
        defines a subset of the input cells operated on during threaded
        execution. Generally this is only used for debugging or
        performance studies (since batch size affects the thread
        workload). By default, the batch size is 10,000 cells.
        """
    )

    def _batch_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBatchSize,
                        self.batch_size)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get the desired precision for the output points type. See the
        documentation for the Algorithm::DesiredOutputPrecision enum
        for an explanation of the available precision settings.
        output_points_precision is DEFAULT_PRECISION by default.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    def _get_plane(self):
        return wrap_vtk(self._vtk_obj.GetPlane())
    def _set_plane(self, arg):
        old_val = self._get_plane()
        self._wrap_call(self._vtk_obj.SetPlane,
                        deref_vtk(arg))
        self.trait_property_changed('plane', old_val, arg)
    plane = traits.Property(_get_plane, _set_plane, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def can_fully_process_data_object(self, *args):
        """
        can_fully_process_data_object(object:DataObject) -> bool
        C++: static bool can_fully_process_data_object(DataObject *object)
        This helper method can be used to determine the if the input
        PolyData contains convex polygonal cells, and therefore is
        suitable for processing by this filter. (The name of the method
        is consistent with other filters that perform similar
        operations.) This method returns true when the input contains
        only polygons (i.e., no verts, lines, or triangle strips); and
        each polygon is convex. It returns false otherwise.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CanFullyProcessDataObject, *my_args)
        return ret

    _updateable_traits_ = \
    (('compute_normals', 'GetComputeNormals'), ('interpolate_attributes',
    'GetInterpolateAttributes'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('batch_size',
    'GetBatchSize'), ('output_points_precision',
    'GetOutputPointsPrecision'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_normals', 'debug',
    'global_warning_display', 'interpolate_attributes',
    'release_data_flag', 'batch_size', 'object_name',
    'output_points_precision', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PolyDataPlaneCutter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PolyDataPlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_normals', 'interpolate_attributes'], [],
            ['batch_size', 'object_name', 'output_points_precision']),
            title='Edit PolyDataPlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PolyDataPlaneCutter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

