
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileWindAttributes.h
    \brief Definition of Wind Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef WindAttributes_H
#define WindAttributes_H

#include "magics.h"
#include "WindPlotting.h"
namespace magics {

class XmlNode;
class WindAttributes 
{
public:
//  --  constructor
    WindAttributes();
    
//  --  destructor
    virtual ~WindAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const WindAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string thinning_method_;
	double thinning_factor_;
	bool thinning_debug_;
	string setting_;
	string predefined_;
	string library_path_;
	unique_ptr<WindPlotting> type_;
	 

private:
	friend ostream& operator<<(ostream& s,const WindAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

