#!/bin/sh

echo -n "Checking Code Coverage of unit tests"
DATE=$( date +%Y%m%d%H%M%S )

if [ -d .svn ]; then
	REV=`LANG=C svn info | grep Revision | cut -c 11-`
	echo " for SVN Revision: $REV"
	TITLE="libsyncml_SVN"$REV"_"$DATE
else
	echo ":"
	TITLE="libsyncml_"$DATE
fi	
echo $TITLE

if ! [ -d ${CMAKE_BINARY_DIR}/coverage/html ]; then
	mkdir -p ${CMAKE_BINARY_DIR}/coverage/html
fi

## compile tests
RESULT=`find ${CMAKE_CURRENT_BINARY_DIR} -name "*.o" -print | wc -l`
if [ "$RESULT" == "0" ]; then
	make
fi

## create gcda files
RESULT=`find ${CMAKE_CURRENT_BINARY_DIR} -name "*.gcda" -print | wc -l`
if [ "$RESULT" == "0" ]; then
	ctest -R .
fi

## analyze statistics
lcov \
	--test-name "$TITLE" \
	--base-directory ${CMAKE_SOURCE_DIR} \
	--directory ${CMAKE_BINARY_DIR} \
	--quiet \
	--capture \
	--output-file ${CMAKE_BINARY_DIR}/coverage/$TITLE.info
genhtml --legend -t "$TITLE" -o ${CMAKE_BINARY_DIR}/coverage/html/$TITLE ${CMAKE_BINARY_DIR}/coverage/$TITLE.info &> /dev/null

cd ${CMAKE_BINARY_DIR}/coverage/html/
if [ -e LATEST ]; then rm -f LATEST; fi
ln -s $TITLE LATEST
cd ${CMAKE_BINARY_DIR}

## cleanup gcda files
#lcov \
#	--test-name "$TITLE" \
#	--base-directory ${CMAKE_SOURCE_DIR} \
#	--directory ${CMAKE_BINARY_DIR} \
#	--quiet \
#	--zerocounters \
#	--output-file coverage/$TITLE.info

echo -n "Code Coverage is: "
grep " %</td>" coverage/html/$TITLE/index.html | sed -e "s/^[^>]*>//g" -e "s/<[^>]*>//g"
echo -n ""
echo -e "\nTroubleshooting:\n If the Code Coverage number is quite low (less then 51%):"
echo -e "\t-Did you run any unit tests before $0?"
echo -e "\t-Did you build with enable_profiling=1?"
echo -e "\t-Run ALL available unit tests!"
echo -e "\t-Check if testcases in unit test are disabled!"
echo -e "\t-Fix unit tests and their test cases!"
echo -e "\t-Write new and more test cases!"
exit 0
