#include "osl/rating/feature/pattern.h"
#include "osl/record/csaRecord.h"
#include "osl/record/csaString.h"
#include "osl/state/numEffectState.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class PatternLongTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(PatternLongTest);
  CPPUNIT_TEST(testNextPieceOrEnd);
  CPPUNIT_TEST_SUITE_END();
public:
  void testNextPieceOrEnd();
};


CPPUNIT_TEST_SUITE_REGISTRATION(PatternLongTest);

using namespace osl;
using namespace osl::rating;

void PatternLongTest::testNextPieceOrEnd() 
{
  NumEffectState state(CsaString(
			 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
			 "P2 * -HI *  *  *  *  * -KA * \n"
			 "P3-FU-FU-FU-FU-FU-FU * -FU-FU\n"
			 "P4 *  *  *  *  *  * -FU *  * \n"
			 "P5 *  *  *  *  *  *  *  *  * \n"
			 "P6 *  * +FU *  *  *  *  *  * \n"
			 "P7+FU+FU * +FU+FU+FU+FU+FU+FU\n"
			 "P8 * +KA *  *  *  *  * +HI * \n"
			 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
			 "+\n").getInitialState());
  const Piece piece 
    = PatternLong::nextPieceOrEnd(state, Square(6,6), 
				  Board_Table.getShortOffset(Offset32(Square(6,6), Square(2,2)))).first;
  CPPUNIT_ASSERT_EQUAL(state.pieceOnBoard(Square(8,8)), piece);
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
