/* ####################### src/openshot.i (libopenshot) ########################
# @brief SWIG configuration for libopenshot (to generate Ruby SWIG bindings)
# @author Jonathan Thomas <jonathan@openshot.org>
#
# @section LICENSE
#
# Copyright (c) 2008-2019 OpenShot Studios, LLC
# <http://www.openshotstudios.com/>. This file is part of
# OpenShot Library (libopenshot), an open-source project dedicated to
# delivering high quality video editing and animation solutions to the
# world. For more information visit <http://www.openshot.org/>.
#
# OpenShot Library (libopenshot) is free software: you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# OpenShot Library (libopenshot) is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with OpenShot Library. If not, see <http://www.gnu.org/licenses/>.
################################################################################ */


%module openshot

/* Suppress warnings about ignored operator= */
%warnfilter(362);

/* Don't generate multiple wrappers for functions with default args */
%feature("compactdefaultargs", "1");

/* Enable inline documentation */
%feature("autodoc", "1");

/* Include various SWIG helpers */
%include "typemaps.i"
%include "std_string.i"
%include "std_list.i"
%include "std_vector.i"
%include "std_map.i"

/* Unhandled STL Exception Handling */
%include <std_except.i>

namespace std {
  template<class T> class shared_ptr {
  public:
    T *operator->();
  };
}

/* Mark these classes as shared_ptr classes */
#ifdef USE_IMAGEMAGICK
	%template(SPtrImage) std::shared_ptr<Magick::Image>;
#endif
%template(SPtrAudioBuffer) std::shared_ptr<juce::AudioSampleBuffer>;
%template(SPtrOpenFrame) std::shared_ptr<openshot::Frame>;

%{
/* Ruby and FFmpeg define competing RSHIFT macros,
 * so we move Ruby's out of the way for now. We'll
 * restore it after dealing with FFmpeg's
 */
#ifdef RSHIFT
  #define RB_RSHIFT(a, b) RSHIFT(a, b)
  #undef RSHIFT
#endif
#include "OpenShotVersion.h"
#include "../../../include/ReaderBase.h"
#include "../../../include/WriterBase.h"
#include "../../../include/CacheBase.h"
#include "../../../include/CacheDisk.h"
#include "../../../include/CacheMemory.h"
#include "../../../include/ChannelLayouts.h"
#include "../../../include/ChunkReader.h"
#include "../../../include/ChunkWriter.h"
#include "../../../include/ClipBase.h"
#include "../../../include/Clip.h"
#include "../../../include/Coordinate.h"
#include "../../../include/Color.h"
#include "../../../include/DummyReader.h"
#include "../../../include/EffectBase.h"
#include "../../../include/Effects.h"
#include "../../../include/EffectInfo.h"
#include "../../../include/Enums.h"
#include "../../../include/Exceptions.h"
#include "../../../include/FFmpegReader.h"
#include "../../../include/FFmpegWriter.h"
#include "../../../include/Fraction.h"
#include "../../../include/Frame.h"
#include "../../../include/FrameMapper.h"
#include "../../../include/PlayerBase.h"
#include "../../../include/Point.h"
#include "../../../include/Profiles.h"
#include "../../../include/QtHtmlReader.h"
#include "../../../include/QtImageReader.h"
#include "../../../include/QtPlayer.h"
#include "../../../include/QtTextReader.h"
#include "../../../include/KeyFrame.h"
#include "../../../include/RendererBase.h"
#include "../../../include/Settings.h"
#include "../../../include/Timeline.h"
#include "../../../include/ZmqLogger.h"
#include "../../../include/AudioDeviceInfo.h"

/* Move FFmpeg's RSHIFT to FF_RSHIFT, if present */
#ifdef RSHIFT
  #define FF_RSHIFT(a, b) RSHIFT(a, b)
  #undef RSHIFT
#endif
/* And restore Ruby's RSHIFT, if we captured it */
#ifdef RB_RSHIFT
  #define RSHIFT(a, b) RB_RSHIFT(a, b)
#endif
%}

#ifdef USE_BLACKMAGIC
	%{
		#include "../../../include/DecklinkReader.h"
		#include "../../../include/DecklinkWriter.h"
	%}
#endif

#ifdef USE_IMAGEMAGICK
	%{
		#include "../../../include/ImageReader.h"
		#include "../../../include/ImageWriter.h"
		#include "../../../include/TextReader.h"
	%}
#endif

%include "OpenShotVersion.h"
%include "../../../include/ReaderBase.h"
%include "../../../include/WriterBase.h"
%include "../../../include/CacheBase.h"
%include "../../../include/CacheDisk.h"
%include "../../../include/CacheMemory.h"
%include "../../../include/ChannelLayouts.h"
%include "../../../include/ChunkReader.h"
%include "../../../include/ChunkWriter.h"
%include "../../../include/ClipBase.h"
%include "../../../include/Clip.h"
%include "../../../include/Coordinate.h"
%include "../../../include/Color.h"
#ifdef USE_BLACKMAGIC
	%include "../../../include/DecklinkReader.h"
	%include "../../../include/DecklinkWriter.h"
#endif
%include "../../../include/DummyReader.h"
%include "../../../include/EffectBase.h"
%include "../../../include/Effects.h"
%include "../../../include/EffectInfo.h"
%include "../../../include/Enums.h"
%include "../../../include/Exceptions.h"

/* Ruby and FFmpeg define competing RSHIFT macros,
 * so we move Ruby's out of the way for now. We'll
 * restore it after dealing with FFmpeg's
 */
#ifdef RSHIFT
  #define RB_RSHIFT(a, b) RSHIFT(a, b)
  #undef RSHIFT
#endif

%include "../../../include/FFmpegReader.h"
%include "../../../include/FFmpegWriter.h"

/* Move FFmpeg's RSHIFT to FF_RSHIFT, if present */
#ifdef RSHIFT
  #define FF_RSHIFT(a, b) RSHIFT(a, b)
  #undef RSHIFT
#endif
/* And restore Ruby's RSHIFT, if we captured it */
#ifdef RB_RSHIFT
  #define RSHIFT(a, b) RB_RSHIFT(a, b)
#endif

%include "../../../include/Fraction.h"
%include "../../../include/Frame.h"
%include "../../../include/FrameMapper.h"
%include "../../../include/PlayerBase.h"
%include "../../../include/Point.h"
%include "../../../include/Profiles.h"
%include "../../../include/QtHtmlReader.h"
%include "../../../include/QtImageReader.h"
%include "../../../include/QtPlayer.h"
%include "../../../include/QtTextReader.h"
%include "../../../include/KeyFrame.h"
%include "../../../include/RendererBase.h"
%include "../../../include/Settings.h"
%include "../../../include/Timeline.h"
%include "../../../include/ZmqLogger.h"
%include "../../../include/AudioDeviceInfo.h"

#ifdef USE_IMAGEMAGICK
	%include "../../../include/ImageReader.h"
	%include "../../../include/ImageWriter.h"
	%include "../../../include/TextReader.h"
#endif


/* Effects */
%include "../../../include/effects/Bars.h"
%include "../../../include/effects/Blur.h"
%include "../../../include/effects/Brightness.h"
%include "../../../include/effects/ChromaKey.h"
%include "../../../include/effects/ColorShift.h"
%include "../../../include/effects/Crop.h"
%include "../../../include/effects/Deinterlace.h"
%include "../../../include/effects/Hue.h"
%include "../../../include/effects/Mask.h"
%include "../../../include/effects/Negate.h"
%include "../../../include/effects/Pixelate.h"
%include "../../../include/effects/Saturation.h"
%include "../../../include/effects/Shift.h"
%include "../../../include/effects/Wave.h"


/* Wrap std templates (list, vector, etc...) */
%template(ClipList) std::list<openshot::Clip *>;
%template(EffectBaseList) std::list<openshot::EffectBase *>;
%template(CoordinateVector) std::vector<openshot::Coordinate>;
%template(PointsVector) std::vector<openshot::Point>;
%template(FieldVector) std::vector<openshot::Field>;
%template(MappedFrameVector) std::vector<openshot::MappedFrame>;
%template(MappedMetadata) std::map<std::string, std::string>;
%template(AudioDeviceInfoVector) std::vector<openshot::AudioDeviceInfo>;
