/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.maven.configurations;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;

/**
 *
 * @author  mkleint
 */
public class NewConfigurationPanel extends javax.swing.JPanel implements DocumentListener {

    private DialogDescriptor descriptor;

    public String getConfigurationId() {
        return txtId.getText().trim();
    }

    public void setConfigurationId(String configurationId) {
        txtId.setText(configurationId);
        txtId.setEditable(false);
        txtId.setEnabled(false);
    }

    public boolean isShared() {
        return !cbPrivate.isSelected();
    }

    public void setShared(boolean shared) {
        cbPrivate.setSelected(!shared);
    }
    /** Creates new form NewConfigurationPanel */
    @SuppressWarnings("LeakingThisInConstructor")
    public NewConfigurationPanel() {
        initComponents();

        txtId.getDocument().addDocumentListener(this);
    }
    
    public void setProfiles(List<String> profiles) {
        String val = ""; //NOI18N
        if (profiles != null) {
            for (String prf : profiles) {
                val = val + prf + " ";
            }
        }
        txtActivate.setText(val);
    }

    public List<String> getProfiles() {
        return split(txtActivate.getText().trim());
    }
    
    static List<String> split(String profiles) {
        String val = profiles;
        String[] splitted = val.split("[ ,]"); //NOI18N
        List<String> toRet = new ArrayList<String>();
        for (String s : splitted) {
            if (s.trim().length() > 0) {
                toRet.add(s.trim());
            }
        }
        return toRet;
    }
    
    public void setProperties(String props) {
        epProperties.setText(props);
    }
    
    public String getProperties() {
        return epProperties.getText();
    }

    void attachDescriptor(DialogDescriptor dd) {
        this.descriptor = dd;
        check();
    }

    private void check() {
        if (descriptor != null) {
            descriptor.setValid(!txtId.getText().trim().isEmpty() && txtId.getText().indexOf('/') == -1);
        }
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblId = new javax.swing.JLabel();
        txtId = new javax.swing.JTextField();
        cbPrivate = new javax.swing.JCheckBox();
        lblActivate = new javax.swing.JLabel();
        lblHint = new javax.swing.JLabel();
        txtActivate = new javax.swing.JTextField();
        lblProperties = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        epProperties = new javax.swing.JEditorPane();

        lblId.setLabelFor(txtId);
        org.openide.awt.Mnemonics.setLocalizedText(lblId, org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.lblId.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbPrivate, org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.cbPrivate.text")); // NOI18N

        lblActivate.setLabelFor(txtActivate);
        org.openide.awt.Mnemonics.setLocalizedText(lblActivate, org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.lblActivate.text")); // NOI18N

        lblHint.setText(org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.lblHint.text")); // NOI18N
        lblHint.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        lblProperties.setLabelFor(epProperties);
        org.openide.awt.Mnemonics.setLocalizedText(lblProperties, org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.lblProperties.text")); // NOI18N

        epProperties.setContentType("text/x-properties"); // NOI18N
        jScrollPane1.setViewportView(epProperties);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(lblId)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(cbPrivate)
                            .addComponent(txtId)))
                    .addComponent(lblHint, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 450, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblActivate)
                            .addComponent(lblProperties))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(txtActivate)
                            .addComponent(jScrollPane1))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblId)
                    .addComponent(txtId, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(cbPrivate)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblActivate)
                    .addComponent(txtActivate, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblProperties)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblHint, javax.swing.GroupLayout.DEFAULT_SIZE, 41, Short.MAX_VALUE)
                .addContainerGap())
        );

        txtId.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.txtId.AccessibleContext.accessibleDescription")); // NOI18N
        cbPrivate.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.cbPrivate.AccessibleContext.accessibleDescription")); // NOI18N
        txtActivate.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.txtActivate.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbPrivate;
    private javax.swing.JEditorPane epProperties;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblActivate;
    private javax.swing.JLabel lblHint;
    private javax.swing.JLabel lblId;
    private javax.swing.JLabel lblProperties;
    private javax.swing.JTextField txtActivate;
    private javax.swing.JTextField txtId;
    // End of variables declaration//GEN-END:variables

    @Override
    public void insertUpdate(DocumentEvent e) {
        check();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        check();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        check();
    }

}
