/*
 * @(#)IClassMetaDataReader.java
 *
 * Copyright (C) 2002,2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.datastore;

import java.io.IOException;


/**
 * Knows how to read class meta-data from the repository.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:26 $
 * @since     December 15, 2002
 */
public interface IClassMetaDataReader
{
    /**
     * Returns the class record for the class with this particular signature.
     *
     * @param classSignature the class signature requested for reading in
     *      the class record.
     * @return the record corresponding to this class, or <tt>null</tt> if
     *      there is no such class signature known.
     * @exception IOException if there is an underlying error during the read,
     *      or if the reader has been closed.
     */
    public ClassRecord readClass( String classSignature )
            throws IOException;
    
    
    /**
     * Returns all classes known for this particular data set.
     *
     * @return the list of all class signatures that can be read by
     *      <tt>readClass( String )</tt>, but never <tt>null</tt>.
     * @exception IOException if there was an underlying read error, or if
     *      the reader has been closed.
     */
    public String[] getClassSignatures()
            throws IOException;
    
    
    /**
     * Closes off the reader's connection to the store.
     *
     * @exception IOException if there was an underlying read error, or if
     *      the reader has already been closed.
     */
    public void close()
            throws IOException;
}

