with Queries;               use Queries;
with ORM_Database;          use ORM_Database;
with GNATCOLL.SQL.Exec;     use GNATCOLL.SQL.Exec;
with GNATCOLL.SQL.Sessions; use GNATCOLL.SQL.Sessions;
with GNATCOLL.SQL.Sqlite;
with GNATCOLL.Traces;
with Ada.Text_IO;           use Ada.Text_IO;

procedure Main is
   Session : Session_Type;
   Id      : Integer;
begin
   GNATCOLL.Traces.Parse_Config_File ("gnatdebug");

   Setup
     (GNATCOLL.SQL.Sqlite.Setup ("test.db", Cache_Support => True),
      Store_Unmodified => True,
      Weak_Cache => False,
      Max_Sessions => 4);

   Session := Get_New_Session;

   declare
      S : Detached_Staff'Class := New_Staff;
   begin
      S.Set_Active (True);
      S.Set_Name ("foo");

      Session.Persist (S);

      Session.Insert_Or_Update (S);
      Put_Line ("Id" & S.Id'Img);

      Session.Commit;

      Id := S.Id;
   end;

   Session := Get_New_Session;

   for J in Boolean loop
      --  First iteration load staff row into cache, second iteration take the
      --  row from cache.

      declare
         S : constant Detached_Staff'Class := Get_Staff (Session, Id => Id);
      begin
         Put_Line (S.Id'Img & " " & S.Name);
      end;
   end loop;

   declare
      M : constant Staff_Managers := Filter (All_Staff, Name => "foo");
      L : constant Staff_List := M.Get (Session);
      S : constant Queries.Staff'Class := L.Element;
   begin
      Put_Line (S.Id'Img & " " & S.Name);
   end;

   declare
      M : constant Active_Staff_Managers :=
         Filter (All_Active_Staff, Name => "foo");
      L : constant Active_Staff_List := M.Get (Session);
      S : constant Queries.Active_Staff'Class := L.Element;
   begin
      Put_Line (S.Id'Img & " " & S.Name);
   end;
end Main;
