#!/bin/bash

export PATH=`pwd`/install/bin:/usr/bin:/bin

echo "gnatls="`which gnatls 2>/dev/null | grep -v "no gnatls"`
echo "arm-eabi-gnatls="`which arm-eabi-gnatls`

expect() {
   prj=$1;
   echo "==== '$j' '' '' ====="
   rm -f auto.cgpr
   ./main $prj

   echo "==== '$j' 'zfp' 'arm-eabi' ====="
   rm -f auto.cgpr
   ./main $prj zfp arm-eabi

   echo "==== '$j' '' 'arm-eabi' ====="
   rm -f auto.cgpr
   ./main $prj '' arm-eabi
}

for j in d?.gpr; do
  expect $j
done
