# Stefan Achatz 2012
#
# Tries to find libgdk_pixbuf-2.0 and sets following variables according to found capabilities:
#
# GDK_PIXBUF2_FOUND
# GDK_PIXBUF2_INCLUDE_DIRS
# GDK_PIXBUF2_LIBRARIES

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_GDK_PIXBUF2 gdk-pixbuf-2.0)

FIND_PATH(GDK_PIXBUF2_INCLUDE_DIRS gdk-pixbuf/gdk-pixbuf.h
  HINTS
    ${PKG_GDK_PIXBUF2_INCLUDE_DIRS}
    ${PKG_GDK_PIXBUF2_INCLUDEDIR}
  PATH_SUFFIXES gtk-2.0
)

FIND_LIBRARY(GDK_PIXBUF2_LIBRARIES gdk_pixbuf-2.0
  HINTS ${PKG_GDK_PIXBUF2_LIBRARY_DIRS}
)

IF(GDK_PIXBUF2_LIBRARIES AND GDK_PIXBUF2_INCLUDE_DIRS)
  SET(GDK_PIXBUF2_FOUND true)
ENDIF()

IF(GDK_PIXBUF2_FIND_REQUIRED AND NOT GDK_PIXBUF2_FOUND)
  MESSAGE(FATAL_ERROR "Could not find GDK_PIXBUF2")
ENDIF()
