/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

/**
 * Stores the characters of a XML comment.
 * There may be many instances of this object per Element.
 *
 * @version 1.0
 * @author Elias Ross
 */
public class Comment 
	implements Node
{
	private XmlCharArrayWriter w;

	/**
	 * Constructs an empty comment.
	 * Append data using the {@link #getWriter} method.
	 */
	public Comment() {
		w = new XmlCharArrayWriter();
	}

	/**
	 * Returns the underlying <code>XmlCharArrayWriter</code> object.
	 */
	public XmlCharArrayWriter getWriter() {
		return w;
	}

	/**
	 * Returns the value <code>COMMENT_NODE</code>.
	 */
	public short getNodeType() {
		return COMMENT_NODE;
	}

	/**
	 * Returns a newly constructed <code>String</code>
	 * containing the comment data.
	 */
	public String getData() {
		return w.toString();
	}

	/**
	 * Returns a string representation of this object, including the
	 * comment tags &lt;!-- and --&gt;.
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer(w.size() + 12);
		sb.append(XmlTags.COMMENT_BEGIN);
		sb.append(w.getBuffer(), 0, w.size());
		sb.append(XmlTags.COMMENT_END);
		return sb.toString();
	}
}

