#!/usr/bin/python
import getpass, os, subprocess, sys, socket
from weblive import WebLive

# NXML template
nxml_template="""
<!DOCTYPE NXClientLibSettings>
<NXClientLibSettings>
<option key="Connection Name" value="WL_NAME"></option>
<option key="Server Hostname" value="WL_SERVER"></option>
<option key="Server Port" value="WL_PORT"></option>
<option key="Session Type" value="unix-application"></option>
<option key="Custom Session Command" value="WL_COMMAND"></option>
<option key="Disk Cache" value="64"></option>
<option key="Image Cache" value="16"></option>
<option key="Link Type" value="adsl"></option>
<option key="Use Render Extension" value="True"></option>
<option key="Image Compression Method" value="JPEG"></option>
<option key="JPEG Compression Level" value="9"></option>
<option key="Desktop Geometry" value=""></option>
<option key="Keyboard Layout" value="defkeymap"></option>
<option key="Keyboard Type" value="pc102/defkeymap"></option>
<option key="Media" value="False"></option>
<option key="Agent Server" value=""></option>
<option key="Agent User" value=""></option>
<option key="CUPS Port" value="0"></option>
<option key="Authentication Key" value=""></option>
<option key="Use SSL Tunnelling" value="True"></option>
<option key="Enable Fullscreen Desktop" value="False"></option>
</NXClientLibSettings>
"""

# Check for QTNX
if not os.path.exists("/usr/bin/qtnx"):
    print "Sorry, you need qtnx (/usr/bin/qtnx) installed."
    sys.exit(1)

# Get a weblive object
weblive=WebLive("https://weblive.stgraber.org/weblive/json")

# List all the available servers
servers=weblive.list_servers()

if len(servers) == 0:
    print "Sorry, there's no server available at this time."
    sys.exit(0)

# Show a readable list of servers
for server in servers:
    attributes=servers[server]
    print "== %s ==" % server
    for attribute in attributes:
        print " * %s: %s" % (attribute,attributes[attribute])
    print ""

# If first parameter is "auto", then pick up the first server and connect
if len(sys.argv) > 1 and sys.argv[1] == "auto":
    serverid=servers.keys()[0]
    username="%s%s" % (os.environ['USER'],socket.gethostname())
    fullname="WebLive User"
    password=socket.gethostname()   # Yes, the hostname is the password ;)
    session='desktop';
else:
    serverid=raw_input("Server (ex. %s): " % servers.keys()[0])
    username=raw_input("Username: ")
    fullname=raw_input("Fullname: ")
    password=getpass.getpass("Password: ")
    session=raw_input("Session (ex. 'desktop' or valid executable): ")

# Create the user
locale=os.environ.get("LANG","None").replace("UTF-8","utf8")
connection=weblive.create_user(serverid,username,fullname,password,session,locale)

# Start QTNX
if not os.path.expanduser('~/.qtnx'):
    os.mkdir(os.path.expanduser('~/.qtnx'))

filename=os.path.expanduser('~/.qtnx/%s-%s-%s.nxml') % (connection[0],connection[1],session)
nxml=open(filename,"w+")
config=nxml_template
config=config.replace("WL_NAME","%s-%s-%s" % (connection[0],connection[1],session))
config=config.replace("WL_SERVER",connection[0])
config=config.replace("WL_PORT",str(connection[1]))
config=config.replace("WL_COMMAND","weblive-session %s" % session)
nxml.write(config)
nxml.close()

qtnx=subprocess.Popen(['/usr/bin/qtnx','%s-%s-%s' % (connection[0],connection[1],session),username,password])
qtnx.wait()
os.remove(filename)
