; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -guard-widening-widen-branch-guards=true -guard-widening < %s        | FileCheck %s
; RUN: opt -S -guard-widening-widen-branch-guards=true -passes=guard-widening < %s | FileCheck %s

; Interaction between intrinsic and widenable condition guards.

declare void @llvm.experimental.guard(i1,...)

declare void @llvm.experimental.deoptimize.isVoid(...)

; Function Attrs: inaccessiblememonly nounwind
declare i1 @llvm.experimental.widenable.condition() #0

; Widen condition of intrinsic guard with a condition from widenable branch.
define void @test_01(i1 %cond_0, i1 %cond_1) {
; CHECK-LABEL: @test_01(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[WIDE_CHK:%.*]] = and i1 [[COND_0:%.*]], [[COND_1:%.*]]
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[WIDE_CHK]]) [ "deopt"() ]
; CHECK-NEXT:    [[WIDENABLE_COND3:%.*]] = call i1 @llvm.experimental.widenable.condition()
; CHECK-NEXT:    [[EXIPLICIT_GUARD_COND4:%.*]] = and i1 [[COND_1]], [[WIDENABLE_COND3]]
; CHECK-NEXT:    br i1 true, label [[GUARDED1:%.*]], label [[DEOPT2:%.*]], !prof [[PROF0:![0-9]+]]
; CHECK:       deopt2:
; CHECK-NEXT:    call void (...) @llvm.experimental.deoptimize.isVoid() [ "deopt"() ]
; CHECK-NEXT:    ret void
; CHECK:       guarded1:
; CHECK-NEXT:    ret void
;
entry:
  call void (i1, ...) @llvm.experimental.guard(i1 %cond_0) [ "deopt"() ]
  %widenable_cond3 = call i1 @llvm.experimental.widenable.condition()
  %exiplicit_guard_cond4 = and i1 %cond_1, %widenable_cond3
  br i1 %exiplicit_guard_cond4, label %guarded1, label %deopt2, !prof !0

deopt2:                                           ; preds = %guarded
  call void (...) @llvm.experimental.deoptimize.isVoid() [ "deopt"() ]
  ret void

guarded1:                                         ; preds = %guarded
  ret void
}

; Widen condition of widenable condition guard with a condition from intrinsic.
define void @test_02(i1 %cond_0, i1 %cond_1) {
; CHECK-LABEL: @test_02(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[WIDENABLE_COND:%.*]] = call i1 @llvm.experimental.widenable.condition()
; CHECK-NEXT:    [[WIDE_CHK:%.*]] = and i1 [[COND_0:%.*]], [[COND_1:%.*]]
; CHECK-NEXT:    [[EXIPLICIT_GUARD_COND:%.*]] = and i1 [[WIDE_CHK]], [[WIDENABLE_COND]]
; CHECK-NEXT:    br i1 [[EXIPLICIT_GUARD_COND]], label [[GUARDED:%.*]], label [[DEOPT:%.*]], !prof [[PROF0]]
; CHECK:       deopt:
; CHECK-NEXT:    call void (...) @llvm.experimental.deoptimize.isVoid() [ "deopt"() ]
; CHECK-NEXT:    ret void
; CHECK:       guarded:
; CHECK-NEXT:    ret void
;
entry:
  %widenable_cond = call i1 @llvm.experimental.widenable.condition()
  %exiplicit_guard_cond = and i1 %cond_0, %widenable_cond
  br i1 %exiplicit_guard_cond, label %guarded, label %deopt, !prof !0

deopt:                                            ; preds = %entry
  call void (...) @llvm.experimental.deoptimize.isVoid() [ "deopt"() ]
  ret void

guarded:                                          ; preds = %entry
  call void (i1, ...) @llvm.experimental.guard(i1 %cond_1) [ "deopt"() ]
  ret void
}

attributes #0 = { inaccessiblememonly nounwind }

!0 = !{!"branch_weights", i32 1048576, i32 1}
