# RUN: llvm-mc -triple mips64el-unknown-linux -show-encoding -print-imm-hex %s | FileCheck %s

  .text
text_label:
# CHECK: text_label:
  add $4, -0x80000000
# CHECK-NEXT: lui    $1, 0x8000              # encoding: [0x00,0x80,0x01,0x3c]
# CHECK-NEXT: add    $4, $4, $1              # encoding: [0x20,0x20,0x81,0x00]
  add $4, -0x8001
# CHECK-NEXT: lui    $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: ori    $1, $1, 0x7fff          # encoding: [0xff,0x7f,0x21,0x34]
# CHECK-NEXT: add    $4, $4, $1              # encoding: [0x20,0x20,0x81,0x00]
  add $4, -0x8000
# CHECK-NEXT: addi   $4, $4, -0x8000         # encoding: [0x00,0x80,0x84,0x20]
  add $4, 0
# CHECK-NEXT: addi   $4, $4, 0x0             # encoding: [0x00,0x00,0x84,0x20]
  add $4, 0xFFFF
# CHECK-NEXT: ori    $1, $zero, 0xffff       # encoding: [0xff,0xff,0x01,0x34]
# CHECK-NEXT: add    $4, $4, $1              # encoding: [0x20,0x20,0x81,0x00]
  add $4, 0x10000
# CHECK-NEXT: lui    $1, 0x1                 # encoding: [0x01,0x00,0x01,0x3c]
# CHECK-NEXT: add    $4, $4, $1              # encoding: [0x20,0x20,0x81,0x00]
  add $4, 0xFFFFFFFF # This should be sign-extended because it's a 32-bit add
# CHECK-NEXT: addi   $4, $4, -0x1            # encoding: [0xff,0xff,0x84,0x20]
  add $4, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: lui    $1, 0xff                # encoding: [0xff,0x00,0x01,0x3c]
# CHECK-NEXT: ori    $1, $1, 0xff0f          # encoding: [0x0f,0xff,0x21,0x34]
# CHECK-NEXT: add $4, $4, $1                 # encoding: [0x20,0x20,0x81,0x00]

  add $4, $5, -0x80000000
# CHECK:      lui    $4, 0x8000              # encoding: [0x00,0x80,0x04,0x3c]
# CHECK-NEXT: add    $4, $4, $5              # encoding: [0x20,0x20,0x85,0x00]
  add $4, $5, -0x8001
# CHECK-NEXT: lui    $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: ori    $4, $4, 0x7fff          # encoding: [0xff,0x7f,0x84,0x34]
# CHECK-NEXT: add    $4, $4, $5              # encoding: [0x20,0x20,0x85,0x00]
  add $4, $5, -0x8000
# CHECK-NEXT: addi   $4, $5, -0x8000         # encoding: [0x00,0x80,0xa4,0x20]
  add $4, $5, 0
# CHECK-NEXT: addi   $4, $5, 0x0             # encoding: [0x00,0x00,0xa4,0x20]
  add $4, $5, 0xFFFF
# CHECK-NEXT: ori    $4, $zero, 0xffff       # encoding: [0xff,0xff,0x04,0x34]
# CHECK-NEXT: add    $4, $4, $5              # encoding: [0x20,0x20,0x85,0x00]
  add $4, $5, 0x10000
# CHECK-NEXT: lui    $4, 0x1                 # encoding: [0x01,0x00,0x04,0x3c]
# CHECK-NEXT: add    $4, $4, $5              # encoding: [0x20,0x20,0x85,0x00]
  add $4, $5, 0xFFFFFFFF # This should be sign-extended because it's a 32-bit addi
# CHECK-NEXT: addi   $4, $5, -0x1            # encoding: [0xff,0xff,0xa4,0x20]
  add $4, $5, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: lui     $4, 0xff                # encoding: [0xff,0x00,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xff0f          # encoding: [0x0f,0xff,0x84,0x34]
# CHECK-NEXT: add     $4, $4, $5              # encoding: [0x20,0x20,0x85,0x00]


  addu $4, -0x80000000
# CHECK:      lui    $1, 0x8000              # encoding: [0x00,0x80,0x01,0x3c]
# CHECK-NEXT: addu   $4, $4, $1              # encoding: [0x21,0x20,0x81,0x00]
  addu $4, -0x8001
# CHECK-NEXT: lui    $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: ori    $1, $1, 0x7fff          # encoding: [0xff,0x7f,0x21,0x34]
# CHECK-NEXT: addu   $4, $4, $1              # encoding: [0x21,0x20,0x81,0x00]
  addu $4, -0x8000
# CHECK-NEXT: addiu  $4, $4, -0x8000         # encoding: [0x00,0x80,0x84,0x24]
  addu $4, 0
# CHECK-NEXT: addiu  $4, $4, 0x0             # encoding: [0x00,0x00,0x84,0x24]
  addu $4, 0xFFFF
# CHECK-NEXT: ori    $1, $zero, 0xffff       # encoding: [0xff,0xff,0x01,0x34]
# CHECK-NEXT: addu   $4, $4, $1              # encoding: [0x21,0x20,0x81,0x00]
  addu $4, 0x10000
# CHECK-NEXT: lui    $1, 0x1                 # encoding: [0x01,0x00,0x01,0x3c]
# CHECK-NEXT: addu   $4, $4, $1              # encoding: [0x21,0x20,0x81,0x00]
  addu $4, 0xFFFFFFFF # This should be sign-extended because it's a 32-bit add
# CHECK-NEXT: addiu  $4, $4, -0x1            # encoding: [0xff,0xff,0x84,0x24]
  addu $4, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: lui    $1, 0xff                # encoding: [0xff,0x00,0x01,0x3c]
# CHECK-NEXT: ori    $1, $1, 0xff0f          # encoding: [0x0f,0xff,0x21,0x34]
# CHECK-NEXT: addu   $4, $4, $1              # encoding: [0x21,0x20,0x81,0x00]

  addu $4, $5, -0x80000000
# CHECK:      lui    $4, 0x8000              # encoding: [0x00,0x80,0x04,0x3c]
# CHECK-NEXT: addu   $4, $4, $5              # encoding: [0x21,0x20,0x85,0x00]
  addu $4, $5, -0x8001
# CHECK-NEXT: lui    $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: ori    $4, $4, 0x7fff          # encoding: [0xff,0x7f,0x84,0x34]
# CHECK-NEXT: addu   $4, $4, $5              # encoding: [0x21,0x20,0x85,0x00]
  addu $4, $5, -0x8000
# CHECK-NEXT: addiu  $4, $5, -0x8000         # encoding: [0x00,0x80,0xa4,0x24]
  addu $4, $5, 0
# CHECK-NEXT: addiu  $4, $5, 0x0             # encoding: [0x00,0x00,0xa4,0x24]
  addu $4, $5, 0xFFFF
# CHECK-NEXT: ori    $4, $zero, 0xffff       # encoding: [0xff,0xff,0x04,0x34]
# CHECK-NEXT: addu   $4, $4, $5              # encoding: [0x21,0x20,0x85,0x00]
  addu $4, $5, 0x10000
# CHECK-NEXT: lui    $4, 0x1                 # encoding: [0x01,0x00,0x04,0x3c]
# CHECK-NEXT: addu   $4, $4, $5              # encoding: [0x21,0x20,0x85,0x00]
  addu $4, $5, 0xFFFFFFFF # This should be sign-extended because it's a 32-bit add
# CHECK-NEXT: addiu  $4, $5, -0x1              # encoding: [0xff,0xff,0xa4,0x24]
  addu $4, $5, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: lui     $4, 0xff                # encoding: [0xff,0x00,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xff0f          # encoding: [0x0f,0xff,0x84,0x34]
# CHECK-NEXT: addu    $4, $4, $5              # encoding: [0x21,0x20,0x85,0x00]


  and $4, -0x80000000
# CHECK:      lui    $1, 0x8000              # encoding: [0x00,0x80,0x01,0x3c]
# CHECK-NEXT: and    $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, -0x8001
# CHECK-NEXT: lui    $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: ori    $1, $1, 0x7fff          # encoding: [0xff,0x7f,0x21,0x34]
# CHECK-NEXT: and    $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, -0x8000
# CHECK-NEXT: addiu   $1, $zero, -0x8000     # encoding: [0x00,0x80,0x01,0x24]
# CHECK-NEXT: and     $4, $4, $1             # encoding: [0x24,0x20,0x81,0x00]
  and $4, 0
# CHECK-NEXT: andi   $4, $4, 0x0             # encoding: [0x00,0x00,0x84,0x30]
  and $4, 0xFFFF
# CHECK-NEXT: andi   $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x30]
  and $4, 0x10000
# CHECK-NEXT: lui    $1, 0x1                 # encoding: [0x01,0x00,0x01,0x3c]
# CHECK-NEXT: and    $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, 0xFFFFFFFF
# CHECK-NEXT: lui     $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: dsrl32  $1, $1, 0x0             # encoding: [0x3e,0x08,0x01,0x00]
# CHECK-NEXT: and     $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, 0xF0000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: and     $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, 0x7FFFFFFF
# CHECK-NEXT: lui     $1, 0x7fff              # encoding: [0xff,0x7f,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: and     $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, 0x7FFFFFFFFFFFFFFF
# CHECK-NEXT: lui     $1, 0x7fff              # encoding: [0xff,0x7f,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: and     $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: addiu   $1, $zero, -0x1         # encoding: [0xff,0xff,0x01,0x24]
# CHECK-NEXT: and     $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, 0xF000000000000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x30            # encoding: [0x3c,0x0c,0x01,0x00]
# CHECK-NEXT: and     $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $1, $zero, -0x1         # encoding: [0xff,0xff,0x01,0x24]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xff            # encoding: [0xff,0x00,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xff0f          # encoding: [0x0f,0xff,0x21,0x34]
# CHECK-NEXT: and     $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]

  and $4, $5, -0x80000000
# CHECK:      lui    $4, 0x8000              # encoding: [0x00,0x80,0x04,0x3c]
# CHECK-NEXT: and    $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, -0x8001
# CHECK-NEXT: lui     $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0x7fff          # encoding: [0xff,0x7f,0x84,0x34]
# CHECK-NEXT: and     $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, -0x8000
# CHECK-NEXT: addiu   $4, $zero, -0x8000      # encoding: [0x00,0x80,0x04,0x24]
# CHECK-NEXT: and     $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, 0
# CHECK-NEXT: andi    $4, $5, 0x0             # encoding: [0x00,0x00,0xa4,0x30]
  and $4, $5, 0xFFFF
# CHECK-NEXT: andi    $4, $5, 0xffff          # encoding: [0xff,0xff,0xa4,0x30]
  and $4, $5, 0x10000
# CHECK-NEXT: lui     $4, 0x1                 # encoding: [0x01,0x00,0x04,0x3c]
# CHECK-NEXT: and     $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, 0xFFFFFFFF
# CHECK-NEXT: lui     $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: dsrl32  $4, $4, 0x0             # encoding: [0x3e,0x20,0x04,0x00]
# CHECK-NEXT: and     $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, 0xF0000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: and     $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, 0x7FFFFFFF
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: and     $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, 0x7FFFFFFFFFFFFFFF
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: and     $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: addiu   $4, $zero, -0x1         # encoding: [0xff,0xff,0x04,0x24]
# CHECK-NEXT: and     $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, 0xF000000000000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x30            # encoding: [0x3c,0x24,0x04,0x00]
# CHECK-NEXT: and     $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $4, $zero, -0x1         # encoding: [0xff,0xff,0x04,0x24]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff            # encoding: [0xff,0x00,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff0f          # encoding: [0x0f,0xff,0x84,0x34]
# CHECK-NEXT: and     $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]

  or $4, -0x80000000
# CHECK:      lui     $1, 0x8000              # encoding: [0x00,0x80,0x01,0x3c]
# CHECK-NEXT: or      $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, -0x8001
# CHECK-NEXT: lui     $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0x7fff          # encoding: [0xff,0x7f,0x21,0x34]
# CHECK-NEXT: or      $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, -0x8000
# CHECK-NEXT: addiu   $1, $zero, -0x8000      # encoding: [0x00,0x80,0x01,0x24]
# CHECK-NEXT: or      $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, 0
# CHECK-NEXT: ori     $4, $4, 0x0             # encoding: [0x00,0x00,0x84,0x34]
  or $4, 0xFFFF
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
  or $4, 0x10000
# CHECK-NEXT: lui     $1, 0x1                 # encoding: [0x01,0x00,0x01,0x3c]
# CHECK-NEXT: or      $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, 0xFFFFFFFF
# CHECK-NEXT: lui     $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: dsrl32  $1, $1, 0x0             # encoding: [0x3e,0x08,0x01,0x00]
# CHECK-NEXT: or      $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, 0xF0000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: or      $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, 0x7FFFFFFF
# CHECK-NEXT: lui     $1, 0x7fff              # encoding: [0xff,0x7f,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: or      $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, 0x7FFFFFFFFFFFFFFF
# CHECK-NEXT: lui     $1, 0x7fff              # encoding: [0xff,0x7f,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: or      $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: addiu   $1, $zero, -0x1         # encoding: [0xff,0xff,0x01,0x24]
# CHECK-NEXT: or      $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, 0xF000000000000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x30            # encoding: [0x3c,0x0c,0x01,0x00]
# CHECK-NEXT: or      $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, $5, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $4, $zero, -0x1         # encoding: [0xff,0xff,0x04,0x24]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff            # encoding: [0xff,0x00,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff0f          # encoding: [0x0f,0xff,0x84,0x34]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]

  or $4, $5, -0x80000000
# CHECK:      lui     $4, 0x8000              # encoding: [0x00,0x80,0x04,0x3c]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, -0x8001
# CHECK-NEXT: lui     $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0x7fff          # encoding: [0xff,0x7f,0x84,0x34]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, -0x8000
# CHECK-NEXT: addiu   $4, $zero, -0x8000      # encoding: [0x00,0x80,0x04,0x24]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, 0
# CHECK-NEXT: ori     $4, $5, 0x0             # encoding: [0x00,0x00,0xa4,0x34]
  or $4, $5, 0xFFFF
# CHECK-NEXT: ori     $4, $5, 0xffff          # encoding: [0xff,0xff,0xa4,0x34]
  or $4, $5, 0x10000
# CHECK-NEXT: lui     $4, 0x1                 # encoding: [0x01,0x00,0x04,0x3c]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, 0xFFFFFFFF
# CHECK-NEXT: lui     $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: dsrl32  $4, $4, 0x0             # encoding: [0x3e,0x20,0x04,0x00]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, 0xF0000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, 0x7FFFFFFF
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, 0x7FFFFFFFFFFFFFFF
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: addiu   $4, $zero, -0x1         # encoding: [0xff,0xff,0x04,0x24]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, 0xF000000000000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x30            # encoding: [0x3c,0x24,0x04,0x00]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $4, $zero, -0x1         # encoding: [0xff,0xff,0x04,0x24]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff            # encoding: [0xff,0x00,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff0f          # encoding: [0x0f,0xff,0x84,0x34]
# CHECK-NEXT: or      $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]

  xor $4, -0x80000000
# CHECK:      lui     $1, 0x8000              # encoding: [0x00,0x80,0x01,0x3c]
# CHECK-NEXT: xor     $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, -0x8001
# CHECK-NEXT: lui     $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0x7fff          # encoding: [0xff,0x7f,0x21,0x34]
# CHECK-NEXT: xor     $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, -0x8000
# CHECK-NEXT: addiu   $1, $zero, -0x8000      # encoding: [0x00,0x80,0x01,0x24]
# CHECK-NEXT: xor     $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, 0
# CHECK-NEXT: xori    $4, $4, 0x0             # encoding: [0x00,0x00,0x84,0x38]
  xor $4, 0xFFFF
# CHECK-NEXT: xori    $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x38]
  xor $4, 0x10000
# CHECK-NEXT: lui     $1, 0x1                 # encoding: [0x01,0x00,0x01,0x3c]
# CHECK-NEXT: xor     $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, 0xFFFFFFFF
# CHECK-NEXT: lui     $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: dsrl32  $1, $1, 0x0             # encoding: [0x3e,0x08,0x01,0x00]
# CHECK-NEXT: xor     $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, 0xF0000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: xor     $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00
  xor $4, 0x7FFFFFFF
# CHECK-NEXT: lui     $1, 0x7fff              # encoding: [0xff,0x7f,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: xor     $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, 0x7FFFFFFFFFFFFFFF
# CHECK-NEXT: lui     $1, 0x7fff              # encoding: [0xff,0x7f,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: xor     $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: addiu   $1, $zero, -0x1         # encoding: [0xff,0xff,0x01,0x24]
# CHECK-NEXT: xor     $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, 0xF000000000000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x30            # encoding: [0x3c,0x0c,0x01,0x00]
# CHECK-NEXT: xor     $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $1, $zero, -0x1         # encoding: [0xff,0xff,0x01,0x24]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xff            # encoding: [0xff,0x00,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xff0f          # encoding: [0x0f,0xff,0x21,0x34]
# CHECK-NEXT: xor     $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]

  xor $4, $5, -0x80000000
# CHECK:      lui     $4, 0x8000              # encoding: [0x00,0x80,0x04,0x3c]
# CHECK-NEXT: xor     $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, -0x8001
# CHECK-NEXT: lui     $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0x7fff          # encoding: [0xff,0x7f,0x84,0x34]
# CHECK-NEXT: xor     $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, -0x8000
# CHECK-NEXT: addiu   $4, $zero, -0x8000      # encoding: [0x00,0x80,0x04,0x24]
# CHECK-NEXT: xor     $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, 0
# CHECK-NEXT: xori    $4, $5, 0x0             # encoding: [0x00,0x00,0xa4,0x38]
  xor $4, $5, 0xFFFF
# CHECK-NEXT: xori    $4, $5, 0xffff          # encoding: [0xff,0xff,0xa4,0x38]
  xor $4, $5, 0x10000
# CHECK-NEXT: lui     $4, 0x1                 # encoding: [0x01,0x00,0x04,0x3c]
# CHECK-NEXT: xor     $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, 0xFFFFFFFF
# CHECK-NEXT: lui     $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: dsrl32  $4, $4, 0x0             # encoding: [0x3e,0x20,0x04,0x00]
# CHECK-NEXT: xor     $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, 0xF0000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: xor     $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, 0x7FFFFFFF
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: xor     $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, 0x7FFFFFFFFFFFFFFF
# FIXME: this is awfully inefficient...
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: xor     $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: addiu   $4, $zero, -0x1         # encoding: [0xff,0xff,0x04,0x24]
# CHECK-NEXT: xor     $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, 0xF000000000000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x30            # encoding: [0x3c,0x24,0x04,0x00]
# CHECK-NEXT: xor     $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $4, $zero, -0x1         # encoding: [0xff,0xff,0x04,0x24]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff            # encoding: [0xff,0x00,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff0f          # encoding: [0x0f,0xff,0x84,0x34]
# CHECK-NEXT: xor     $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]

  nor $4, 0
# CHECK:      addiu   $1, $zero, 0x0          # encoding: [0x00,0x00,0x01,0x24]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, 1
# CHECK-NEXT: addiu   $1, $zero, 0x1          # encoding: [0x01,0x00,0x01,0x24]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, 0x8000
# CHECK-NEXT: ori     $1, $zero, 0x8000       # encoding: [0x00,0x80,0x01,0x34]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, -0x8000
# CHECK-NEXT: addiu   $1, $zero, -0x8000      # encoding: [0x00,0x80,0x01,0x24]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, 0x10000
# CHECK-NEXT: lui     $1, 0x1                 # encoding: [0x01,0x00,0x01,0x3c]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, 0x1a5a5
# CHECK-NEXT: lui     $1, 0x1                 # encoding: [0x01,0x00,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xa5a5          # encoding: [0xa5,0xa5,0x21,0x34]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, 0xFFFFFFFF
# CHECK-NEXT: lui     $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: dsrl32  $1, $1, 0x0             # encoding: [0x3e,0x08,0x01,0x00]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, 0xF0000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, 0x7FFFFFFF
# CHECK-NEXT: lui     $1, 0x7fff              # encoding: [0xff,0x7f,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, 0x7FFFFFFFFFFFFFF
# CHECK-NEXT: lui     $1, 0x7ff               # encoding: [0xff,0x07,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: addiu   $1, $zero, -0x1         # encoding: [0xff,0xff,0x01,0x24]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, 0xF000000000000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x30            # encoding: [0x3c,0x0c,0x01,0x00]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $1, $zero, -0x1         # encoding: [0xff,0xff,0x01,0x24]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xff            # encoding: [0xff,0x00,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xff0f          # encoding: [0x0f,0xff,0x21,0x34]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]
  nor $4, 0xff00ff00
# CHECK-NEXT: ori     $1, $zero, 0xff00       # encoding: [0x00,0xff,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xff00          # encoding: [0x00,0xff,0x21,0x34]
# CHECK-NEXT: nor     $4, $4, $1              # encoding: [0x27,0x20,0x81,0x00]

  nor $4, $5, 0
# CHECK:      addiu   $4, $zero, 0x0          # encoding: [0x00,0x00,0x04,0x24]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 1
# CHECK-NEXT: addiu   $4, $zero, 0x1          # encoding: [0x01,0x00,0x04,0x24]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0x8000
# CHECK-NEXT: ori     $4, $zero, 0x8000       # encoding: [0x00,0x80,0x04,0x34]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, -0x8000
# CHECK-NEXT: addiu   $4, $zero, -0x8000      # encoding: [0x00,0x80,0x04,0x24]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0x10000
# CHECK-NEXT: lui     $4, 0x1                 # encoding: [0x01,0x00,0x04,0x3c]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0x1a5a5
# CHECK-NEXT: lui     $4, 0x1                 # encoding: [0x01,0x00,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xa5a5          # encoding: [0xa5,0xa5,0x84,0x34]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0xFFFFFFFF
# CHECK-NEXT: lui     $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: dsrl32  $4, $4, 0x0             # encoding: [0x3e,0x20,0x04,0x00]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0xF0000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0x7FFFFFFF
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0x7FFFFFFFFFFFFFFF
# FIXME: this is awfully inefficient...
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: addiu   $4, $zero, -0x1         # encoding: [0xff,0xff,0x04,0x24]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0xF000000000000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x30            # encoding: [0x3c,0x24,0x04,0x00]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $4, $zero, -0x1         # encoding: [0xff,0xff,0x04,0x24]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff            # encoding: [0xff,0x00,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff0f          # encoding: [0x0f,0xff,0x84,0x34]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0xff00ff00
# CHECK-NEXT: ori     $4, $zero, 0xff00       # encoding: [0x00,0xff,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff00          # encoding: [0x00,0xff,0x84,0x34]
# CHECK-NEXT: nor     $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]


  slt $4, -0x80000000
# CHECK:      lui     $1, 0x8000              # encoding: [0x00,0x80,0x01,0x3c]
# CHECK-NEXT: slt     $4, $4, $1              # encoding: [0x2a,0x20,0x81,0x00]
  slt $4, -0x8001
# CHECK-NEXT: lui     $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0x7fff          # encoding: [0xff,0x7f,0x21,0x34]
# CHECK-NEXT: slt     $4, $4, $1              # encoding: [0x2a,0x20,0x81,0x00]
  slt $4, -0x8000
# CHECK-NEXT: slti    $4, $4, -0x8000         # encoding: [0x00,0x80,0x84,0x28]
  slt $4, 0
# CHECK-NEXT: slti    $4, $4, 0x0             # encoding: [0x00,0x00,0x84,0x28]
  slt $4, 0xFFFF
# CHECK-NEXT: ori     $1, $zero, 0xffff       # encoding: [0xff,0xff,0x01,0x34]
# CHECK-NEXT: slt     $4, $4, $1              # encoding: [0x2a,0x20,0x81,0x00]
  slt $4, 0x10000
# CHECK-NEXT: lui     $1, 0x1                 # encoding: [0x01,0x00,0x01,0x3c]
# CHECK-NEXT: slt     $4, $4, $1              # encoding: [0x2a,0x20,0x81,0x00]
  slt $4, 0xFFFFFFFF
# CHECK-NEXT: lui     $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: dsrl32  $1, $1, 0x0             # encoding: [0x3e,0x08,0x01,0x00]
# CHECK-NEXT: slt     $4, $4, $1              # encoding: [0x2a,0x20,0x81,0x00]
  slt $4, 0xF0000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: slt     $4, $4, $1              # encoding: [0x2a,0x20,0x81,0x00]
  slt $4, 0x7FFFFFFF
# CHECK-NEXT: lui     $1, 0x7fff              # encoding: [0xff,0x7f,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: slt     $4, $4, $1              # encoding: [0x2a,0x20,0x81,0x00]
  slt $4, 0x7FFFFFFFFFFFFFFF
# CHECK-NEXT: lui     $1, 0x7fff              # encoding: [0xff,0x7f,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: slt     $4, $4, $1              # encoding: [0x2a,0x20,0x81,0x00]
  slt $4, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: slti    $4, $4, -0x1            # encoding: [0xff,0xff,0x84,0x28]
  slt $4, 0xF000000000000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x30            # encoding: [0x3c,0x0c,0x01,0x00]
# CHECK-NEXT: slt     $4, $4, $1              # encoding: [0x2a,0x20,0x81,0x00]
  slt $4, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $1, $zero, -0x1         # encoding: [0xff,0xff,0x01,0x24]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xff            # encoding: [0xff,0x00,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xff0f          # encoding: [0x0f,0xff,0x21,0x34]
# CHECK-NEXT: slt     $4, $4, $1              # encoding: [0x2a,0x20,0x81,0x00]

  slt $4, $5, -0x80000000
# CHECK:      lui     $4, 0x8000              # encoding: [0x00,0x80,0x04,0x3c]
# CHECK-NEXT: slt     $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, -0x8001
# CHECK-NEXT: lui     $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0x7fff          # encoding: [0xff,0x7f,0x84,0x34]
# CHECK-NEXT: slt     $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, -0x8000
# CHECK-NEXT: slti    $4, $5, -0x8000         # encoding: [0x00,0x80,0xa4,0x28]
  slt $4, $5, 0
# CHECK-NEXT: slti    $4, $5, 0x0             # encoding: [0x00,0x00,0xa4,0x28]
  slt $4, $5, 0xFFFF
# CHECK-NEXT: ori     $4, $zero, 0xffff       # encoding: [0xff,0xff,0x04,0x34]
# CHECK-NEXT: slt     $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, 0x10000
# CHECK-NEXT: lui     $4, 0x1                 # encoding: [0x01,0x00,0x04,0x3c]
# CHECK-NEXT: slt     $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, 0xFFFFFFFF
# CHECK-NEXT: lui     $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: dsrl32  $4, $4, 0x0             # encoding: [0x3e,0x20,0x04,0x00]
# CHECK-NEXT: slt     $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, 0xF0000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: slt     $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, 0x7FFFFFFF
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: slt     $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, 0x7FFFFFFFFFFFFFFF
# FIXME: this is awfully inefficient...
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: slt     $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: slti    $4, $5, -0x1            # encoding: [0xff,0xff,0xa4,0x28]
  slt $4, $5, 0xF000000000000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x30            # encoding: [0x3c,0x24,0x04,0x00]
# CHECK-NEXT: slt $4, $4, $5                  # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $4, $zero, -0x1         # encoding: [0xff,0xff,0x04,0x24]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff            # encoding: [0xff,0x00,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff0f          # encoding: [0x0f,0xff,0x84,0x34]
# CHECK-NEXT: slt     $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]

  sltu $4, -0x80000000
# CHECK:      lui     $1, 0x8000              # encoding: [0x00,0x80,0x01,0x3c]
# CHECK-NEXT: sltu    $4, $4, $1              # encoding: [0x2b,0x20,0x81,0x00]
  sltu $4, -0x8001
# CHECK-NEXT: lui     $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0x7fff          # encoding: [0xff,0x7f,0x21,0x34]
# CHECK-NEXT: sltu    $4, $4, $1              # encoding: [0x2b,0x20,0x81,0x00]
  sltu $4, -0x8000
# CHECK-NEXT:   sltiu   $4, $4, -0x8000       # encoding: [0x00,0x80,0x84,0x2c]
  sltu $4, 0
# CHECK-NEXT: sltiu $4, $4, 0x0               # encoding: [0x00,0x00,0x84,0x2c]
  sltu $4, 0xFFFF
# CHECK-NEXT: ori     $1, $zero, 0xffff       # encoding: [0xff,0xff,0x01,0x34]
# CHECK-NEXT: sltu    $4, $4, $1              # encoding: [0x2b,0x20,0x81,0x00]
  sltu $4, 0x10000
# CHECK-NEXT: lui     $1, 0x1                 # encoding: [0x01,0x00,0x01,0x3c]
# CHECK-NEXT: sltu    $4, $4, $1              # encoding: [0x2b,0x20,0x81,0x00]
  sltu $4, 0xFFFFFFFF
# CHECK-NEXT: lui     $1, 0xffff              # encoding: [0xff,0xff,0x01,0x3c]
# CHECK-NEXT: dsrl32  $1, $1, 0x0             # encoding: [0x3e,0x08,0x01,0x00]
# CHECK-NEXT: sltu    $4, $4, $1              # encoding: [0x2b,0x20,0x81,0x00]
  sltu $4, 0xF0000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: sltu    $4, $4, $1              # encoding: [0x2b,0x20,0x81,0x00]
  sltu $4, 0x7FFFFFFF
# CHECK-NEXT: lui     $1, 0x7fff              # encoding: [0xff,0x7f,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: sltu    $4, $4, $1              # encoding: [0x2b,0x20,0x81,0x00]
  sltu $4, 0x7FFFFFFFFFFFFFFF
# CHECK-NEXT: lui     $1, 0x7fff              # encoding: [0xff,0x7f,0x01,0x3c]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xffff          # encoding: [0xff,0xff,0x21,0x34]
# CHECK-NEXT: sltu    $4, $4, $1              # encoding: [0x2b,0x20,0x81,0x00]
  sltu $4, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: sltiu   $4, $4, -0x1            # encoding: [0xff,0xff,0x84,0x2c]
  sltu $4, 0xF000000000000000
# CHECK-NEXT: ori     $1, $zero, 0xf000       # encoding: [0x00,0xf0,0x01,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x30            # encoding: [0x3c,0x0c,0x01,0x00]
# CHECK-NEXT: sltu    $4, $4, $1              # encoding: [0x2b,0x20,0x81,0x00]
  sltu $4, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $1, $zero, -0x1         # encoding: [0xff,0xff,0x01,0x24]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xff            # encoding: [0xff,0x00,0x21,0x34]
# CHECK-NEXT: dsll    $1, $1, 0x10            # encoding: [0x38,0x0c,0x01,0x00]
# CHECK-NEXT: ori     $1, $1, 0xff0f          # encoding: [0x0f,0xff,0x21,0x34]
# CHECK-NEXT: sltu    $4, $4, $1              # encoding: [0x2b,0x20,0x81,0x00]

  sltu $4, $5, -0x80000000
# CHECK:      lui     $4, 0x8000              # encoding: [0x00,0x80,0x04,0x3c]
# CHECK-NEXT: sltu    $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, -0x8001
# CHECK-NEXT: lui     $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0x7fff          # encoding: [0xff,0x7f,0x84,0x34]
# CHECK-NEXT: sltu    $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, -0x8000
# CHECK-NEXT: sltiu   $4, $5, -0x8000         # encoding: [0x00,0x80,0xa4,0x2c]
  sltu $4, $5, 0
# CHECK-NEXT: sltiu   $4, $5, 0x0             # encoding: [0x00,0x00,0xa4,0x2c]
  sltu $4, $5, 0xFFFF
# CHECK-NEXT: ori     $4, $zero, 0xffff       # encoding: [0xff,0xff,0x04,0x34]
# CHECK-NEXT: sltu    $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, 0x10000
# CHECK-NEXT: lui     $4, 0x1                 # encoding: [0x01,0x00,0x04,0x3c]
# CHECK-NEXT: sltu    $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, 0xFFFFFFFF
# CHECK-NEXT: lui     $4, 0xffff              # encoding: [0xff,0xff,0x04,0x3c]
# CHECK-NEXT: dsrl32  $4, $4, 0x0             # encoding: [0x3e,0x20,0x04,0x00]
# CHECK-NEXT: sltu    $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, 0xF0000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: sltu    $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, 0x7FFFFFFF
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: sltu    $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, 0x7FFFFFFFFFFFFFFF
# FIXME: this is awfully inefficient...
# CHECK-NEXT: lui     $4, 0x7fff              # encoding: [0xff,0x7f,0x04,0x3c]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xffff          # encoding: [0xff,0xff,0x84,0x34]
# CHECK-NEXT: sltu    $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, 0xFFFFFFFFFFFFFFFF
# CHECK-NEXT: sltiu   $4, $5, -0x1            # encoding: [0xff,0xff,0xa4,0x2c]
  sltu $4, $5, 0xF000000000000000
# CHECK-NEXT: ori     $4, $zero, 0xf000       # encoding: [0x00,0xf0,0x04,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x30            # encoding: [0x3c,0x24,0x04,0x00]
# CHECK-NEXT: sltu    $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, ~(0xf0000000|0x0f000000|0x000000f0)
# CHECK-NEXT: addiu   $4, $zero, -0x1         # encoding: [0xff,0xff,0x04,0x24]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff            # encoding: [0xff,0x00,0x84,0x34]
# CHECK-NEXT: dsll    $4, $4, 0x10            # encoding: [0x38,0x24,0x04,0x00]
# CHECK-NEXT: ori     $4, $4, 0xff0f          # encoding: [0x0f,0xff,0x84,0x34]
# CHECK-NEXT: sltu    $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
