; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 < %s | FileCheck %s --check-prefix=CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 < %s | FileCheck %s --check-prefix=CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -mattr=-altivec < %s | FileCheck %s \
; RUN:     --check-prefix=CHECK-P9-NOALTIVEC
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr8 < %s | FileCheck %s --check-prefix=CHECK-P8

define <4 x i32> @test_vextsh2w(<4 x i32> %m) {
; CHECK-P9-LABEL: test_vextsh2w:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    vextsh2w 2, 2
; CHECK-P9-NEXT:    blr
;
; CHECK-P9-NOALTIVEC-LABEL: test_vextsh2w:
; CHECK-P9-NOALTIVEC:       # %bb.0: # %entry
; CHECK-P9-NOALTIVEC-NEXT:    extsh 6, 6
; CHECK-P9-NOALTIVEC-NEXT:    extsh 5, 5
; CHECK-P9-NOALTIVEC-NEXT:    extsh 4, 4
; CHECK-P9-NOALTIVEC-NEXT:    extsh 3, 3
; CHECK-P9-NOALTIVEC-NEXT:    blr
;
; CHECK-P8-LABEL: test_vextsh2w:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    vspltisw 3, 8
; CHECK-P8-NEXT:    vadduwm 3, 3, 3
; CHECK-P8-NEXT:    vslw 2, 2, 3
; CHECK-P8-NEXT:    vsraw 2, 2, 3
; CHECK-P8-NEXT:    blr
entry:
  %shl = shl <4 x i32> %m, <i32 16, i32 16, i32 16, i32 16>
  %shr = ashr exact <4 x i32> %shl, <i32 16, i32 16, i32 16, i32 16>
  ret <4 x i32> %shr
}

define <4 x i32> @test_vextsb2w(<4 x i32> %m) {
; CHECK-P9-LABEL: test_vextsb2w:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    vextsb2w 2, 2
; CHECK-P9-NEXT:    blr
;
; CHECK-P9-NOALTIVEC-LABEL: test_vextsb2w:
; CHECK-P9-NOALTIVEC:       # %bb.0: # %entry
; CHECK-P9-NOALTIVEC-NEXT:    extsb 6, 6
; CHECK-P9-NOALTIVEC-NEXT:    extsb 5, 5
; CHECK-P9-NOALTIVEC-NEXT:    extsb 4, 4
; CHECK-P9-NOALTIVEC-NEXT:    extsb 3, 3
; CHECK-P9-NOALTIVEC-NEXT:    blr
;
; CHECK-P8-LABEL: test_vextsb2w:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    vspltisw 3, 12
; CHECK-P8-NEXT:    vadduwm 3, 3, 3
; CHECK-P8-NEXT:    vslw 2, 2, 3
; CHECK-P8-NEXT:    vsraw 2, 2, 3
; CHECK-P8-NEXT:    blr
entry:
  %shl = shl <4 x i32> %m, <i32 24, i32 24, i32 24, i32 24>
  %shr = ashr exact <4 x i32> %shl, <i32 24, i32 24, i32 24, i32 24>
  ret <4 x i32> %shr
}

define <2 x i64> @test_vextsb2d(<2 x i64> %m) {
; CHECK-P9-LABEL: test_vextsb2d:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    vextsb2d 2, 2
; CHECK-P9-NEXT:    blr
;
; CHECK-P9-NOALTIVEC-LABEL: test_vextsb2d:
; CHECK-P9-NOALTIVEC:       # %bb.0: # %entry
; CHECK-P9-NOALTIVEC-NEXT:    extsb 3, 3
; CHECK-P9-NOALTIVEC-NEXT:    extsb 4, 4
; CHECK-P9-NOALTIVEC-NEXT:    blr
;
; CHECK-P8-LABEL: test_vextsb2d:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; CHECK-P8-NEXT:    addi 3, 3, .LCPI2_0@toc@l
; CHECK-P8-NEXT:    lxvd2x 0, 0, 3
; CHECK-P8-NEXT:    xxswapd 35, 0
; CHECK-P8-NEXT:    vsld 2, 2, 3
; CHECK-P8-NEXT:    vsrad 2, 2, 3
; CHECK-P8-NEXT:    blr
entry:
  %shl = shl <2 x i64> %m, <i64 56, i64 56>
  %shr = ashr exact <2 x i64> %shl, <i64 56, i64 56>
  ret <2 x i64> %shr
}

define <2 x i64> @test_vextsh2d(<2 x i64> %m) {
; CHECK-P9-LABEL: test_vextsh2d:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    vextsh2d 2, 2
; CHECK-P9-NEXT:    blr
;
; CHECK-P9-NOALTIVEC-LABEL: test_vextsh2d:
; CHECK-P9-NOALTIVEC:       # %bb.0: # %entry
; CHECK-P9-NOALTIVEC-NEXT:    extsh 3, 3
; CHECK-P9-NOALTIVEC-NEXT:    extsh 4, 4
; CHECK-P9-NOALTIVEC-NEXT:    blr
;
; CHECK-P8-LABEL: test_vextsh2d:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis 3, 2, .LCPI3_0@toc@ha
; CHECK-P8-NEXT:    addi 3, 3, .LCPI3_0@toc@l
; CHECK-P8-NEXT:    lxvd2x 0, 0, 3
; CHECK-P8-NEXT:    xxswapd 35, 0
; CHECK-P8-NEXT:    vsld 2, 2, 3
; CHECK-P8-NEXT:    vsrad 2, 2, 3
; CHECK-P8-NEXT:    blr
entry:
  %shl = shl <2 x i64> %m, <i64 48, i64 48>
  %shr = ashr exact <2 x i64> %shl, <i64 48, i64 48>
  ret <2 x i64> %shr
}

define <2 x i64> @test_vextsw2d(<2 x i64> %m) {
; CHECK-P9-LABEL: test_vextsw2d:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    vextsw2d 2, 2
; CHECK-P9-NEXT:    blr
;
; CHECK-P9-NOALTIVEC-LABEL: test_vextsw2d:
; CHECK-P9-NOALTIVEC:       # %bb.0: # %entry
; CHECK-P9-NOALTIVEC-NEXT:    extsw 3, 3
; CHECK-P9-NOALTIVEC-NEXT:    extsw 4, 4
; CHECK-P9-NOALTIVEC-NEXT:    blr
;
; CHECK-P8-LABEL: test_vextsw2d:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis 3, 2, .LCPI4_0@toc@ha
; CHECK-P8-NEXT:    addi 3, 3, .LCPI4_0@toc@l
; CHECK-P8-NEXT:    lxvd2x 0, 0, 3
; CHECK-P8-NEXT:    xxswapd 35, 0
; CHECK-P8-NEXT:    vsld 2, 2, 3
; CHECK-P8-NEXT:    vsrad 2, 2, 3
; CHECK-P8-NEXT:    blr
entry:
  %shl = shl <2 x i64> %m, <i64 32, i64 32>
  %shr = ashr exact <2 x i64> %shl, <i64 32, i64 32>
  ret <2 x i64> %shr
}

define <2 x i64> @test_none(<2 x i64> %m) {
; CHECK-P9-LABEL: test_none:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis 3, 2, .LCPI5_0@toc@ha
; CHECK-P9-NEXT:    addi 3, 3, .LCPI5_0@toc@l
; CHECK-P9-NEXT:    lxvx 35, 0, 3
; CHECK-P9-NEXT:    vsld 2, 2, 3
; CHECK-P9-NEXT:    vsrad 2, 2, 3
; CHECK-P9-NEXT:    blr
;
; CHECK-P9-NOALTIVEC-LABEL: test_none:
; CHECK-P9-NOALTIVEC:       # %bb.0: # %entry
; CHECK-P9-NOALTIVEC-NEXT:    sldi 3, 3, 16
; CHECK-P9-NOALTIVEC-NEXT:    sldi 4, 4, 16
; CHECK-P9-NOALTIVEC-NEXT:    sradi 3, 3, 16
; CHECK-P9-NOALTIVEC-NEXT:    sradi 4, 4, 16
; CHECK-P9-NOALTIVEC-NEXT:    blr
;
; CHECK-P8-LABEL: test_none:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis 3, 2, .LCPI5_0@toc@ha
; CHECK-P8-NEXT:    addi 3, 3, .LCPI5_0@toc@l
; CHECK-P8-NEXT:    lxvd2x 0, 0, 3
; CHECK-P8-NEXT:    xxswapd 35, 0
; CHECK-P8-NEXT:    vsld 2, 2, 3
; CHECK-P8-NEXT:    vsrad 2, 2, 3
; CHECK-P8-NEXT:    blr
entry:
  %shl = shl <2 x i64> %m, <i64 16, i64 16>
  %shr = ashr exact <2 x i64> %shl, <i64 16, i64 16>
  ret <2 x i64> %shr
}
