/**
 * SECTION:security-info
 * @short_description: Package security information
 * 
 * <para>This class stores data which can be used to display meaningful information about the security level of a 3rd-party software package. It provides information about the state of the package signature.</para>
 */
/**
 * LISTALLER_IPK_TYPE_SECURITY_INFO:
 * 
 * The type for <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link>.
 */
/**
 * listaller_ipk_security_info_get_level:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance
 * 
 * Returns a human-readable general security level, which was determined for the associated package.
 */
/**
 * listaller_ipk_security_info_get_level_as_sentence:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance
 * 
 * Get a sentence describing the security status of a package.
 */
/**
 * listaller_ipk_security_info_get_level_as_string:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance
 * 
 * Get a simple workd (such as &quot;high&quot; or &quot;low&quot;) which describes the security status of a package.
 */
/**
 * ListallerIPKSecurityInfo:signature-status:
 */
/**
 * listaller_ipk_security_info_get_signature_status:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerIPKSecurityInfo--signature-status"><type>"signature-status"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerIPKSecurityInfo--signature-status"><type>"signature-status"</type></link> property
 */
/**
 * listaller_ipk_security_info_set_signature_status:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerIPKSecurityInfo--signature-status"><type>"signature-status"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerIPKSecurityInfo--signature-status"><type>"signature-status"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerIPKSecurityInfo:signature-trustlevel:
 */
/**
 * listaller_ipk_security_info_get_signature_trustlevel:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerIPKSecurityInfo--signature-trustlevel"><type>"signature-trustlevel"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerIPKSecurityInfo--signature-trustlevel"><type>"signature-trustlevel"</type></link> property
 */
/**
 * listaller_ipk_security_info_set_signature_trustlevel:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerIPKSecurityInfo--signature-trustlevel"><type>"signature-trustlevel"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerIPKSecurityInfo--signature-trustlevel"><type>"signature-trustlevel"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerIPKSecurityInfo:user-names:
 */
/**
 * listaller_ipk_security_info_get_user_names:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerIPKSecurityInfo--user-names"><type>"user-names"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerIPKSecurityInfo--user-names"><type>"user-names"</type></link> property
 */
/**
 * listaller_ipk_security_info_set_user_names:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerIPKSecurityInfo--user-names"><type>"user-names"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerIPKSecurityInfo--user-names"><type>"user-names"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerIPKSecurityInfo:key-fpr:
 */
/**
 * listaller_ipk_security_info_get_key_fpr:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerIPKSecurityInfo--key-fpr"><type>"key-fpr"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerIPKSecurityInfo--key-fpr"><type>"key-fpr"</type></link> property
 */
/**
 * listaller_ipk_security_info_set_key_fpr:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerIPKSecurityInfo--key-fpr"><type>"key-fpr"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerIPKSecurityInfo--key-fpr"><type>"key-fpr"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerIPKSecurityInfo:trust-reason:
 */
/**
 * listaller_ipk_security_info_get_trust_reason:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerIPKSecurityInfo--trust-reason"><type>"trust-reason"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerIPKSecurityInfo--trust-reason"><type>"trust-reason"</type></link> property
 */
/**
 * listaller_ipk_security_info_set_trust_reason:
 * @self: the <link linkend="ListallerIPKSecurityInfo"><type>ListallerIPKSecurityInfo</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerIPKSecurityInfo--trust-reason"><type>"trust-reason"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerIPKSecurityInfo--trust-reason"><type>"trust-reason"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerIPKSecurityInfo:
 * 
 * Package security information
 * 
 * <para>This class stores data which can be used to display meaningful information about the security level of a 3rd-party software package. It provides information about the state of the package signature.</para>
 */
/**
 * ListallerIPKSecurityInfoClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="LISTALLER-IPK-TYPE-SECURITY-INFO:CAPS"><literal>LISTALLER_IPK_TYPE_SECURITY_INFO</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * listaller_security_level_to_string:
 * @self: the <link linkend="ListallerSecurityLevel"><type>ListallerSecurityLevel</type></link> instance
 */
/**
 * listaller_security_level_from_string:
 * @str: &nbsp;
 */
/**
 * ListallerSecurityLevel:
 * 
 * Simple indicator of package security
 */
/**
 * listaller_sign_status_to_string:
 * @self: the <link linkend="ListallerSignStatus"><type>ListallerSignStatus</type></link> instance
 */
/**
 * ListallerSignStatus:
 * 
 * Status of a package signature
 */
/**
 * listaller_sign_trust_to_string:
 * @self: the <link linkend="ListallerSignTrust"><type>ListallerSignTrust</type></link> instance
 */
/**
 * ListallerSignTrust:
 * 
 * Trust level of a signature
 */
