%{
/*
 * The Termprocessor Kimwitu
 *
 * Copyright (c) 1991 University of Twente, Dept TIOS.
 * All rights reserved.
 *
 */
%}
%{
/*
 * kimwl.l
 */
#if ! (defined(lint) || defined(SABER) || defined(CODECENTER))
static char kimwl_lAccesSid[] = "@(#)$Id: kimwl.l,v 2.36 1998/01/29 18:04:21 belinfan Rel $";
#endif
%}
%{
/* comments to suppress known `errors' */
/*SUPPRESS 529*/ /* statement cannot be reached */
/*SUPPRESS  25*/ /* creating a bad pointer during initialization */
#if (defined(SABER) || defined(CODECENTER))
# define lint
#endif
%}
%{
/* WARNING: YYLMAX should be at least 500
 * (because some people write real specs ...)
 * use the BUFSIZ that is defined in <stdio.h> as #define BUFSIZ 1024
 * this is a no-op on a sun: sun's lex already defines #define YYLMAX BUFSIZ
 * however, on a hp we get problems: YYLMAX is defined as #define YYLMAX 200
 * first get rid of old value: #undef YYLMAX before #define YYLMAX 'our-value'
 */
#undef YYLMAX
#define YYLMAX BUFSIZ

/* WARNING: some lexers (like (some versions of?) flex) #define yywrap
 * which causes problems if we try to define a function for it.
 * So, we undef it if defined.
 */
#ifdef yywrap
# undef yywrap
#endif

/* For windows (NT at least) we need to redifine fileno and isatty */
#if defined(_WIN32) && ! defined (__GNUC__)
# define fileno _fileno
# define isatty _isatty
#endif
%}

%{
#define count(x) counter(x)
%}

%{
/***************************************************************************/
/*
 * Name conventions: tokens and states are in CAPITALS
 * operators are capitalized
 *
 */
%}

%start NORMAL INCL INCLSTART CEXPR CEXPRDQ CEXPRSQ C
%{
/* define our own macro if we have a 'standard' (ansi) C(++) compiler */
#ifndef KC_NO_STDC
# if defined(__STDC__) || defined(__cplusplus) || defined(_WIN32)
#  define KC_STDC
# endif
#endif
#ifdef KC_STDC
# include <stdlib.h>
#endif
#include <string.h>

#include "k.h"
#include "kimwy.h"

static int cinit_paren_nesting =0;
static int cinit_array_nesting =0;
static void reset_nestcount KC__P(());

static int eat_comment KC__P(( casestring ));
static void counter KC__P(( int ));
%}

alpha   [a-zA-Z]
digit   [0-9]
special [\_]
ident   (({alpha}|{special})({alpha}|{digit}|{special})*)
nonident [^a-zA-Z0-9\_]
int     ({digit}+)
exp     ([Ee][-+]?{digit}+)
float   ([-+]?{digit}+\.?{digit}*)
ws		[\ \n\t\v\f]

%%
<NORMAL>{ws}			 	{ count(0); }
<NORMAL>^\%view				{ count(1); return T_PERCENTUVIEW; }
<NORMAL>^\%uview			{ count(1); return T_PERCENTUVIEW; }
<NORMAL>^\%rview			{ count(1); return T_PERCENTRVIEW; }
<NORMAL>^\%storageclass		{ count(1); return T_PERCENTSTORAGECLASS; }
<NORMAL>^\%\{[ \t]*			{ count(1); BEGIN INCLSTART; return T_INCLUDESTART; }
<INCLSTART>{ident}			{ count(1);	 yylval.yt_casestring = mkcasestring(yytext); return T_ID;}
<INCLSTART>[ \t]			{ count(0); }
<INCLSTART>\n				{ count(1); BEGIN INCL; }
<INCL>[^%\n]+				{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_INCLUDE; }
<INCL>\%					{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_INCLUDE; }
<INCL>\n					{ count(1); return yytext[0]; }
<INCL>^\%\}\n				{ count(1); BEGIN NORMAL; return T_INCLUDEEND; }
<C,CEXPR>\/\*				{ int no_of_newlines; count(1); no_of_newlines = eat_comment(pg_filename);
					          yylval.yt_int = no_of_newlines; return T_CNEWLINES;
					    	}
<NORMAL,INCL,INCLSTART>\/\*	{ count(1); eat_comment(pg_filename); }
<NORMAL>\-\>				{ count(1); return T_ARROW; }
<NORMAL>default				{ count(1); return T_DEFAULT; }
<NORMAL>\-?{int}			{ count(1); yylval.yt_int = atoi(yytext); return T_INT; }
<NORMAL>list				{ count(1); return T_LIST; }
<NORMAL>static				{ count(1); return T_STATIC; }
<NORMAL>auto				{ count(1); return T_AUTO; }
<NORMAL>register			{ count(1); return T_REGISTER; }
<NORMAL>extern				{ count(1); return T_EXTERN; }
<NORMAL>typedef				{ count(1); return T_TYPEDEF; }
<NORMAL>const				{ count(1); return T_CONST; }
<NORMAL>volatile			{ count(1); return T_VOLATILE; }
<NORMAL>\.\.\.				{ count(1); return T_DOTDOTDOT; }
<NORMAL>{ident}	 			{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_ID ; }
<CEXPR>[^\n\\"';,\(\)\[\]$]+	{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_CEXPRESSION; }
<NORMAL,CEXPR>\${int}		{ count(1); yylval.yt_int = atoi(yytext+1); return T_DOLLARVAR; }
<NORMAL>\$\{				{ count(1); return T_UNPBLOCKSTART; }
<NORMAL>\$\}				{ count(1); return T_UNPBLOCKEND; }
<CEXPR>\$					{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_CEXPRESSION; }
<CEXPR,CEXPRDQ,CEXPRSQ,C>\n	{ count(1); return yytext[0]; }
<CEXPR,CEXPRDQ,CEXPRSQ>\\	{ count(1); yylval.yt_casestring = mkcasestring("\\"); return T_CEXPRESSION; }
<CEXPR,CEXPRDQ,CEXPRSQ>\\\\	{ count(1); yylval.yt_casestring = mkcasestring("\\\\"); return T_CEXPRESSION; }
<NORMAL,C,CEXPR>\"			{ count(1); BEGIN CEXPRDQ; return yytext[0]; }
<NORMAL,C,CEXPR>'			{ count(1); BEGIN CEXPRSQ; return yytext[0]; }
<CEXPR>;					{ count(1); BEGIN NORMAL; reset_nestcount(); return yytext[0]; }
<CEXPR>\,					{ count(1); return yytext[0]; }
<CEXPR>\(					{ count(1); cinit_paren_nesting++;  yylval.yt_casestring = mkcasestring("(");  return yytext[0]; }
<CEXPR>\)					{ count(1); if (cinit_paren_nesting == 0) {
						      BEGIN NORMAL; reset_nestcount(); return yytext[0];
								} else {
						      cinit_paren_nesting--; yylval.yt_casestring = mkcasestring(")");  return yytext[0]; }
							}
<CEXPR>\[					{ count(1); cinit_array_nesting++;  yylval.yt_casestring = mkcasestring("[");  return yytext[0]; }
<CEXPR>\]					{ count(1); if (cinit_array_nesting == 0) {
						      BEGIN NORMAL; reset_nestcount(); return yytext[0];
								} else {
						      cinit_array_nesting--; yylval.yt_casestring = mkcasestring("]");  return yytext[0]; }
							}
<CEXPRDQ>[^\n\\"]+			{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_CEXPRESSION; }
<CEXPRDQ>\"					{ count(1); BEGIN CEXPR; return yytext[0]; }
<CEXPRDQ>\\\"				{ count(1); yylval.yt_casestring = mkcasestring("\\\""); return T_CEXPRESSION; }
<CEXPRSQ>'					{ count(1); BEGIN CEXPR; return yytext[0]; }
<CEXPRSQ>\\'				{ count(1); yylval.yt_casestring = mkcasestring("\\'"); return T_CEXPRESSION; }
<CEXPRSQ>[^\n\\']+			{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_CEXPRESSION; }
<C>\$\$						{ count(1); yylval.yt_casestring = mkcasestring("$"); return T_CLINE; }
<C>\\\\						{ count(1); yylval.yt_casestring = mkcasestring("\\\\"); return T_CLINE; }
<C>\\						{ count(1); yylval.yt_casestring = mkcasestring("\\"); return T_CLINE ; }
<C>\$\{						{ count(1); yylval.yt_casestring = mkcasestring("{"); /*WARNING-NO LONGER SUPPORTED*/ return T_CLINE ; }
<C>\$\}						{ count(1); yylval.yt_casestring = mkcasestring("}"); /*WARNING-NO LONGER SUPPORTED*/ return T_CLINE ; }
<C>\$[0-9]*					{ count(1); if (strcmp(yytext, "$") == 0)
					 		     return yytext[0];
							  yylval.yt_int = atoi(yytext+1);
							  return T_DOLLARVAR;
							}
<C>{ws}*afterforeach/{nonident}	{
							  count(1);
							  return T_FOREACH_AFTER;
							}
<C>{ident}					{ count(1); if (strcmp(yytext, "foreach") ==0) {
							      return T_FOREACH;
							  } else if (strcmp(yytext, "afterforeach") ==0) {
							      return T_FOREACH_AFTER;
							  } else if (strcmp(yytext, "with") ==0) {
							      return T_WITH;
							  } else {
							      yylval.yt_casestring = mkcasestring(yytext);
							      return T_CLINE ;
							  }
							}
<C>[^\n{}w/"'a-zA-Z_\$\\]+	{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_CLINE; }
<C>\/						{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_CLINE; }
<C>\/\*[ \t]*EMPTY[ \t]*\*\/	{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_CLINE; }
<C>\/\*[ \t]*NOTREACHED[ \t]*\*\/	{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_CLINE; }
<C>\/\*[ \t]*SUPPRESS[ \t]*[0-9]+[ \t]*\*\/		{ count(1); yylval.yt_casestring = mkcasestring(yytext); return T_CLINE; }
.							{ count(1); return yytext[0]; }

%%

static void reset_nestcount()
{
	/* WARNING if these are not == 0 */
	if (cinit_paren_nesting != 0) {
		v_report( NonFatal( PosNoFileLine(), Problem1S( "opening parenthesis '(' was not closed" )));
	}
	if (cinit_array_nesting != 0) {
		v_report( NonFatal( PosNoFileLine(), Problem1S( "opening bracket '[' was not closed" )));
	}
	cinit_paren_nesting = 0;
	cinit_array_nesting = 0;
}

void do_NORMAL()	{ BEGIN NORMAL; reset_nestcount(); }
void do_CEXPR()		{ BEGIN CEXPR; }
void do_CEXPRDQ()	{ BEGIN CEXPRDQ; }
void do_CEXPRSQ()	{ BEGIN CEXPRSQ; }
void do_C()			{ BEGIN C; }

int yywrap()		{ return 1; }

#ifdef __cplusplus
#  define myinput yyinput
#else
#  define myinput input
#endif

static int eat_comment
#ifdef KC_USE_PROTOTYPES
 (casestring start_filename)
#else
 (start_filename)
  casestring start_filename;
#endif
{
	char c1, c2;		/* comment string */
	int nest;
	int no_of_newlines = 0;
	int start_lineno = pg_lineno;
					
	for(nest=1, c2 = ' ';;){
		c1 = c2;
		c2 = myinput();
		if (c2 == '\n') {
			pg_lineno++;
			pg_column = 0;
			pg_charpos ++;
		} else if (c2 == '\t') {
			pg_column += 8	- (pg_column %	8);
			pg_charpos += 8	- (pg_charpos %	8);
		} else if (c2 == 0) {
			v_report( Fatal( FileLine( start_filename, start_lineno ), Problem1S( "start of comment containing unexpected eof" )));
		} else {
			pg_column++;
			pg_charpos ++;
		}
		if (c1 == '/' && c2 == '*')
			nest++;
		else if (c1 == '*' && c2 == '/')
			nest--;
		if (nest <= 0)
			break;
	}
	no_of_newlines = pg_lineno - start_lineno;
	return no_of_newlines;
}

/*ARGSUSED*/
static void counter
#ifdef KC_USE_PROTOTYPES
 (int notwhite)
#else
 (notwhite)
  int notwhite;
#endif
{
	register char *s;

#ifdef MYLEXDEBUG
	if (notwhite)
		printf ("symbol	found: %s\n", yytext);
#endif
	for	(s = yytext; *s; s++)
		if (*s == '\n')	{
			pg_column = 0;
			pg_lineno++;
			pg_charpos ++;
		} else if	(*s	== '\t') {
			pg_column += 8	- (pg_column %	8);
			pg_charpos += 8	- (pg_charpos %	8);
		} else {
			pg_column++;
			pg_charpos ++;
		}
}

/*
 *****************************
 * Parse error (and recovery)
 *****************************
 */

#include "error.h"
extern int yychar;
void yyerror
#ifdef KC_USE_PROTOTYPES
 (char *s)
#else
 (s)
  char *s;
#endif
{
	if (strlen(yytext) > 0) {
		v_report( NonFatal( PosNoFileLine(), Problem4S( s, "\n\ttoken last read was: `", yytext, "'")));
	} else {
		v_report( NonFatal( PosNoFileLine(), Problem1S( s )));
	}
	/* v_report( NonFatal( NoFileLine(), Problem3S1int1S( "yytext=`", yytext, "'; symbol was (", yychar, ")" ))); */
}

void yyrecovermsg
#ifdef KC_USE_PROTOTYPES
 (char *msg)
#else
 (msg) char *msg;
#endif
{
	v_report( NonFatal( NoFileLine(), Problem2S( "Parsing Recovery:", msg )));
}


#ifndef FLEX_SCANNER
void yyrestart
#ifdef KC_USE_PROTOTYPES
 (FILE *input_file)
#else
 ( input_file ) FILE *input_file;
#endif
{}
#endif
