typedef struct phone_t phone_t;
struct phone_t {
    unsigned int index;
    unsigned int number;
    union {
        const char* string;
        char** member;
    } candidate;
};
const int phone_length = 1413;
phone_t phone_table[] = {
    {1, 1, "ㄅ"},
    {2, 1, "ㄆ"},
    {3, 1, "ㄇ"},
    {4, 1, "ㄈ"},
    {5, 1, "ㄉ"},
    {6, 1, "ㄊ"},
    {7, 1, "ㄋ"},
    {8, 1, "ㄌ"},
    {9, 1, "ㄍ"},
    {10, 1, "ㄎ"},
    {11, 1, "ㄏ"},
    {12, 1, "ㄐ"},
    {13, 2, "ㄑ 胠"},
    {14, 1, "ㄒ"},
    {15, 52, "之 知 隻 織 支 枝 汁 只 吱 芝 脂 肢 蜘 祇 梔 祗 氏 枳 ㄓ 胝 鴟 卮 搘 秖 跖 鳷 汥 秪 榰 胑 衼 椥 氐 芰 衹 庋 疧 栺 鬾 謢 攵 巵 栀 秓 祬 綕 馶 㯄 鼅 倁 疷 鴲"},
    {16, 36, "吃 蚩 癡 痴 嗤 喫 ㄔ 郗 魑 笞 絺 鴟 媸 摛 瓻 螭 眵 齝 离 貾 誺 瞝 齹 黐 麶 盵 哧 妛 粚 脪 訵 噄 鵄 彲 呞 卨"},
    {17, 39, "失 施 師 詩 溼 濕 獅 屍 ㄕ 蝨 虱 尸 迉 蓍 葹 鳲 邿 湤 絁 鰤 溮 鶳 箷 褷 襹 螄 拾 隰 韅 釃 鸍 师 釶 瑡 蒒 鳾 鍦 魳 鯴"},
    {18, 1, "ㄖ"},
    {19, 69, "資 茲 滋 吱 姿 咨 孜 諮 貲 玆 ㄗ 輜 淄 齜 緇 孳 粢 髭 嵫 菑 鎡 鼒 孖 澬 甾 鄑 鯔 錙 趑 椔 鈭 鶅 齍 栥 紎 崰 秶 蠀 仔 次 恣 訾 齊 茬 絘 觜 薋 齐 亝 斉 姕 兹 赼 嗞 孶 葘 趦 鍿 頿 茊 斊 湽 稵 䨏 頾 鰦 鷀 禌 輺"},
    {20, 13, "疵 庛 雌 ㄘ 差 趀 骴 恣 呲 跐 鈭 蠀 髊"},
    {21, 51, "司 思 斯 絲 私 撕 廝 鷥 嘶 ㄙ 澌 緦 偲 罳 颸 禠 虒 楒 鍶 凘 泀 蕬 鉰 俬 覗 榹 禗 蜤 磃 謕 蟴 鼶 糸 葸 螄 諰 簁 厶 㺨 恖 媤 愢 厮 簛 蟖 騦 籭 㴲 䔮 䰄 鐁"},
    {256, 48, "一 壹 衣 依 醫 伊 揖 噫 漪 猗 咿 ㄧ 禕 繄 黟 曀 銥 泆 鷖 欹 郼 圪 溰 稦 燚 洢 陭 蛜 嫛 瑿 檹 毉 黳 嶬 她 椅 翳 弌 医 壱 㛄 㳖 悘 嬄 夁 䫑 譩 鎄"},
    {257, 9, "逼 屄 偪 稫 豍 皀 毴 悂 螕"},
    {258, 43, "批 披 匹 劈 霹 砒 被 丕 坯 坏 伾 狉 紕 秠 鈹 鴄 怌 翍 釽 憵 銔 駓 髬 胚 帔 邳 鎞 妚 阫 抷 炋 狓 肧 秛 耚 㓻 豾 鈈 鉟 磇 悂 䤵 鮍"},
    {259, 2, "咪 瞇"},
    {261, 21, "低 滴 氐 羝 鞮 彽 磾 鍉 袛 菂 墑 熵 堤 提 隄 嫡 埞 趆 仾 奃 𩑾"},
    {262, 5, "梯 踢 剔 焍 掦"},
    {264, 1, "哩"},
    {268, 106, "機 基 積 績 蹟 激 跡 姬 雞 饑 肌 稽 飢 奇 畸 碁 箕 磯 譏 羈 几 机 乩 屐 躋 璣 幾 嘰 畿 嵇 犄 齎 其 期 居 唧 勣 禨 欚 癘 羇 虀 觭 霙 蛣 銈 枅 丌 尐 簊 虮 鐖 櫅 稘 毄 樍 諅 鞿 鑇 齏 笄 剞 隮 鸄 癪 圾 棋 刉 咭 惎 敧 憿 獥 錤 濝 穖 齌 魕 凥 卟 㚻 竒 迹 㥍 喞 嵆 朞 棊 筓 鳮 槣 賫 躸 賷 櫀 檱 韲 鷄 覉 覊 㞓 嗘 僟 耭 㼄 鑙"},
    {269, 50, "七 妻 欺 戚 漆 棲 悽 淒 柒 萋 慼 溪 沏 諆 郪 娸 鸂 嘁 悊 榿 磎 倛 咠 栖 谿 凄 唭 徛 桼 僛 緀 磩 霋 魌 鶈 攲 崎 期 緝 抾 傶 豯 鼜 捿 朞 嵠 慽 豀 紪 䗩"},
    {270, 157, "西 希 吸 攜 嘻 犧 稀 悉 溪 析 蟋 熙 禧 膝 棲 釐 嬉 兮 犀 晰 羲 畦 曦 僖 蜥 扱 熹 奚 盻 觿 譆 晞 欷 蹊 樨 巇 淅 皙 唏 烯 傒 徯 恓 窸 粞 豨 醯 鼷 氥 浠 潝 燨 瓗 疧 酅 媐 巂 悕 睎 硒 蠵 鑴 榽 歖 爔 琋 螇 俙 徆 怷 娭 屖 谿 莃 菥 僁 橀 螝 豯 貕 鵗 騱 驨 郋 桸 惁 凞 誒 礂 屎 訢 萋 墀 撕 璽 恄 栖 狶 茜 梊 瓻 慀 磎 螅 蟢 孈 鸂 忚 吚 忾 㛓 牺 胿 捿 焁 焈 晳 焬 厀 嵠 携 熈 噏 嬆 蔳 㩗 擕 暿 熻 熺 壐 瞦 䁯 豀 㩦 黊 鏭 儶 㼇 隵 㰕 讗 卤 怸 玺 𠴭 唽 㓾 㗭 燍 㬢 繥 觹 鬹 觽 𢹂 𡾞"},
    {512, 41, "屋 烏 污 汙 圬 誣 嗚 巫 鎢 鄔 洿 歍 ㄨ 惡 於 杇 陓 剭 窏 腛 鴮 螐 喔 匢 釫 覡 汚 扵 悪 媉 誈 隖 僫 弙 匫 箼 鼿 䵦 䖚 鰞 䶍"},
    {513, 9, "逋 晡 餔 峬 鵏 不 鯆 庯 陠"},
    {514, 16, "撲 仆 鋪 噗 扑 痡 抪 瞨 駇 舖 鋍 攴 炇 陠 豧 擈"},
    {516, 46, "夫 膚 敷 孵 伕 麩 跗 趺 柎 砆 鄜 鈇 箙 罦 衭 稃 邞 泭 怤 尃 荴 綒 鳺 姇 糐 璷 紨 不 孚 芙 枹 胕 荂 蚨 呋 玞 肤 旉 粰 麬 麱 妋 㠸 娐 筟 懯"},
    {517, 7, "都 督 嘟 闍 醏 裻 錖"},
    {518, 10, "禿 凸 鵚 涋 捸 嶀 廜 秃 庩 痜"},
    {520, 2, "嚕 氌"},
    {521, 41, "姑 孤 辜 咕 沽 估 菇 菰 呱 蛄 痼 箍 鴣 觚 酤 泒 罛 箛 鈷 鮕 夃 柧 鈲 軱 家 嫴 橭 枯 骨 轂 怙 胍 蛌 跍 哌 苽 唂 笟 軲 嗗 磆"},
    {522, 20, "哭 枯 窟 骷 跍 挎 桍 刳 顝 胐 橭 窋 堀 箍 郀 笟 軲 圐 鮬 崫"},
    {523, 45, "忽 呼 乎 惚 滹 戲 猢 欻 膴 虖 吰 虍 幠 寣 昒 歑 烼 垀 曶 啒 峘 淴 謼 匢 淲 糊 芴 雽 罅 鏬 戏 泘 苸 唿 軤 嘑 雐 戯 戱 歘 恗 烀 匫 䓤 鍃"},
    {527, 37, "珠 朱 諸 株 豬 蛛 茱 硃 誅 銖 侏 洙 瀦 邾 櫫 櫧 祩 藷 絑 袾 觰 鴸 蠩 蝫 鮢 跦 姝 㧣 猪 敱 潴 駯 鼄 劯 橥 蕏 鯺"},
    {528, 10, "出 初 齣 貙 趉 趎 犓 岀 摢 誳"},
    {529, 37, "書 輸 殊 舒 梳 疏 蔬 樞 紓 抒 攄 姝 樗 摴 殳 杸 陎 綀 橾 祋 軗 鵨 藲 疋 叔 俞 荼 洙 悆 毹 忬 枢 俆 兪 疎 毺 踈"},
    {531, 2, "租 蒩"},
    {532, 6, "粗 麤 觕 麆 麁 麄"},
    {533, 17, "蘇 甦 酥 穌 囌 櫯 疏 蔬 薊 姀 鉌 鞂 龢 疎 踈 鯂 蘓"},
    {768, 18, "淤 迂 瘀 紆 ㄩ 毹 箊 扜 穻 盓 汙 污 胠 陓 唹 汚 虶 迃"},
    {780, 46, "居 拘 駒 沮 疽 蛆 狙 俱 車 据 鋸 裾 苴 趄 罝 菹 娵 椐 腒 崌 痀 琚 雎 涺 葅 鮈 鶋 斪 揟 蜛 踙 輋 且 咀 倨 砠 踞 齟 岨 凥 抅 俥 倶 婮 鴡 眗"},
    {781, 60, "區 屈 驅 趨 軀 嶇 曲 蛆 瞿 袪 敺 蛐 佉 砠 胠 岨 祛 呿 凵 抾 阹 镼 魼 鶌 鱋 紶 髷 屆 疽 崛 樞 毆 麴 沏 浀 啒 淈 詘 趄 摳 貙 区 伹 届 岴 枢 殴 唿 躯 筁 趋 憈 誳 駈 麯 鰸 䖦 駆 𨧱 𡲬"},
    {782, 47, "須 需 虛 鬚 噓 墟 戌 胥 訏 吁 歔 盱 嬃 繻 殈 旴 呴 楈 嬬 鑐 欨 倠 稰 縃 蝑 蕦 驉 魖 晇 幁 揟 糈 于 嘔 樨 謣 覷 鱋 亏 扝 偦 虚 虗 嘘 覰 譃 覻"},
    {65536, 5, "阿 啊 ㄚ 腌 吖"},
    {65537, 26, "八 捌 巴 吧 疤 芭 笆 粑 叭 扒 豝 仈 朳 葩 岊 峇 舥 蚆 玌 岜 哵 羓 釟 㺩 䰾 䶕"},
    {65538, 9, "趴 葩 啪 蚆 舥 夿 妑 皅 𥐙"},
    {65539, 7, "媽 嗎 嬤 摩 螞 嬷 㕰"},
    {65540, 11, "發 伐 瞂 法 筏 閥 栰 彂 灋 佱 傠"},
    {65541, 11, "搭 褡 答 撘 瘩 躂 咑 耷 荅 畣 溚"},
    {65542, 18, "它 他 她 牠 塌 褟 祂 禢 灺 趿 搨 鉈 靸 禤 炨 炧 溻 鉇"},
    {65544, 10, "拉 啦 喇 柆 邋 鞡 翋 菈 剌 磖"},
    {65545, 5, "嘎 旮 軋 戛 戞"},
    {65546, 6, "咖 喀 哈 咔 鉲 刮"},
    {65547, 4, "哈 鉿 𨉣 鉿"},
    {65551, 21, "渣 扎 喳 楂 查 齇 柤 皻 抯 挓 樝 謯 眨 奓 觰 譇 査 揸 偧 摣 齄"},
    {65552, 22, "差 插 叉 喳 艖 嗏 扠 杈 偛 疀 鎈 臿 溠 槎 鍤 芆 挿 訍 揷 肞 銟 餷"},
    {65553, 32, "殺 沙 紗 砂 莎 剎 煞 鯊 裟 杉 痧 鎩 魦 樧 猀 帴 摋 蔱 硰 唦 挲 桫 逤 閷 繺 挱 粆 桬 榝 檆 鯋 髿"},
    {65555, 12, "紮 匝 咂 唼 嘁 抸 鉔 臢 帀 沞 迊 紥"},
    {65556, 4, "擦 搽 嚓 䃰"},
    {65557, 4, "撒 仨 三 弎"},
    {65792, 19, "呀 壓 鴉 鴨 押 丫 椏 孲 啞 雅 劜 压 庘 俹 瘂 鵶 圧 曱 唖"},
    {65804, 34, "家 加 嘉 佳 傢 迦 枷 袈 痂 笳 珈 跏 茄 葭 豭 耞 麚 泇 毠 鎵 鴐 猳 幏 犌 貑 夾 伽 咖 拁 腵 鉫 擮 䕒 宊"},
    {65805, 3, "掐 葜 㤉"},
    {65806, 15, "瞎 蝦 岈 颬 鍜 呀 嗐 磍 谺 㗇 閕 鰕 豄 傄 敮"},
    {66048, 25, "哇 蛙 挖 窪 呱 媧 洼 穵 溛 窊 窐 漥 凹 汙 畦 汚 哌 畖 嗗 搲 䵷 鼃 攨 徍 劸"},
    {66057, 36, "瓜 括 刮 蝸 颳 呱 聒 鴰 栝 适 騧 胍 腡 筈 葀 劀 瘑 緺 懖 趏 膼 佸 泒 咶 蛌 萿 鈲 髺 匃 哌 䒷 桰 歄 諣 踻 銽"},
    {66058, 15, "誇 夸 姱 荂 晇 侉 舿 咼 挎 桍 綔 銙 咵 叧 恗"},
    {66059, 10, "花 華 嘩 鷨 錵 化 荂 蘤 芲 蕐"},
    {66063, 6, "抓 撾 髽 檛 膼 簻"},
    {66064, 2, "欻 歘"},
    {66065, 4, "刷 唰 鮛 涮"},
    {131072, 4, "喔 ㄛ 呵 啊"},
    {131073, 28, "玻 撥 剝 菠 缽 嶓 砵 播 般 碆 袚 襏 鱍 啵 柭 蹳 岥 波 餑 癶 肑 剥 盋 紴 鉢 鮁 㿺 驋"},
    {131074, 12, "波 潑 坡 陂 鏺 癹 翍 頗 沷 汖 昁 鉕"},
    {131075, 1, "摸"},
    {131328, 2, "唷 喲"},
    {131584, 12, "窩 倭 渦 萵 猧 踒 媧 蝸 齷 覣 唩 涹"},
    {131589, 8, "多 朵 哆 柁 茤 跢 崜 夛"},
    {131590, 33, "脫 拖 托 託 堶 侂 挩 扥 矺 沰 馲 侻 詑 魠 他 它 佗 牠 扡 灺 虴 袘 飥 汑 杔 拕 炨 炧 捝 脱 涶 咃 驝"},
    {131592, 3, "囉 捋 寽"},
    {131593, 29, "郭 鍋 蟈 堝 嘓 崞 埻 墎 濄 渦 過 蝸 撾 咼 剮 漷 瘑 緺 鞷 檛 懖 霩 过 鈛 鞟 櫎 叧 冎 㗻"},
    {131595, 1, "豁"},
    {131599, 9, "捉 桌 涿 棹 穛 卓 槕 𥼚 㑁"},
    {131600, 1, "戳"},
    {131601, 3, "說 説 哾"},
    {131603, 1, "嘬"},
    {131604, 13, "搓 撮 磋 蹉 蒫 遳 髊 差 莏 傞 瑳 醝 齹"},
    {131605, 22, "縮 梭 莎 唆 娑 簑 嗦 傞 挲 蓑 桫 蹜 莏 趖 摍 嗾 莤 㛖 挱 桬 鮻 䔋"},
    {196608, 12, "阿 婀 痾 ㄜ 屙 峉 錒 歞 妿 妸 疴 娿"},
    {196615, 1, "呢"},
    {196617, 26, "哥 歌 割 鴿 擱 胳 戈 肐 疙 渮 牁 菏 滒 麧 咯 紇 隔 閣 蠽 戓 戨 鴚 謌 牫 牱 鎶"},
    {196618, 35, "科 柯 刻 棵 顆 苛 瞌 磕 蚵 蝌 軻 稞 窠 珂 砢 簻 薖 峇 鈳 樖 犐 嵙 嗑 溘 髁 嵑 酠 搕 頦 魺 濭 胢 萪 礚 窼"},
    {196619, 12, "喝 呵 訶 嗬 峆 堨 嵑 毼 鍻 騔 抲 㰰"},
    {196623, 6, "遮 螫 晢 嫬 折 嗻"},
    {196624, 6, "車 硨 莗 俥 唓 蛼"},
    {196625, 11, "奢 賒 奓 檨 譇 畬 撦 偖 畭 賖 畲"},
    {262144, 1, "ㄝ"},
    {262400, 4, "耶 噎 蠮 掖"},
    {262401, 8, "憋 鱉 虌 癟 鷩 鼈 㿜 龞"},
    {262402, 7, "瞥 撇 氕 潎 蟞 撆 𢳂"},
    {262403, 3, "咩 乜 羋"},
    {262405, 2, "爹 嗲"},
    {262406, 3, "貼 帖 怗"},
    {262407, 5, "捏 踗 鑈 捻 揑"},
    {262408, 1, "咧"},
    {262412, 35, "街 接 皆 階 揭 偕 嗟 喈 幯 結 湝 薢 啑 椄 菨 蝔 鶛 隔 諧 勓 痎 瑎 踥 癤 龤 掲 堦 媘 脻 嫅 煯 擑 䕸 𣶏 䃈"},
    {262413, 2, "切 聺"},
    {262414, 18, "些 歇 蠍 蝎 猲 褉 嗋 楔 碣 羯 燮 偈 堨 揳 毼 㱔 礍 爕"},
    {262912, 5, "約 曰 噦 箹 焥"},
    {262924, 3, "噘 嗟 撅"},
    {262925, 4, "缺 闕 蒛 炔"},
    {262926, 10, "薛 靴 噱 嶨 吙 辥 嚯 鞾 㖸 㗾"},
    {327680, 7, "挨 哀 埃 唉 哎 ㄞ 欸"},
    {327681, 2, "掰 搿"},
    {327682, 3, "拍 啪 𢫦"},
    {327685, 5, "呆 待 獃 鮘 懛"},
    {327686, 6, "胎 苔 台 囼 孡 𧉟"},
    {327689, 26, "該 垓 陔 賅 荄 侅 峐 胲 祴 絯 豥 賌 隑 欬 烗 喈 湝 瑎 輆 蝔 鶛 炌 姟 郂 晐 畡"},
    {327690, 5, "開 揩 痎 侅 奒"},
    {327691, 4, "咳 嗨 咍 欬"},
    {327695, 16, "摘 齋 齊 捚 霽 齐 亝 斉 夈 斋 斎 膪 䔝 斊 榸 𩱳"},
    {327696, 5, "拆 釵 差 偨 靫"},
    {327697, 2, "篩 㴓"},
    {327699, 9, "災 栽 哉 渽 賳 菑 灾 烖 睵"},
    {327700, 1, "猜"},
    {327701, 13, "塞 鰓 腮 毢 揌 思 偲 毸 恖 愢 噻 顋 䚡"},
    {328192, 2, "歪 竵"},
    {328201, 1, "乖"},
    {328202, 4, "咼 喎 擓 叧"},
    {328207, 1, "拽"},
    {328209, 5, "摔 衰 縗 孈 榱"},
    {393216, 2, "ㄟ 欸"},
    {393217, 26, "背 杯 悲 卑 碑 俾 揹 偝 盃 裨 萆 桮 椑 伓 綼 鵯 藣 埤 坏 婢 庳 捭 錍 阫 錃 䎱"},
    {393218, 15, "胚 呸 坏 醅 柸 岯 垺 衃 丕 披 坯 怌 妚 抷 肧"},
    {393220, 23, "非 飛 菲 扉 啡 妃 緋 霏 馡 騑 騛 婓 裶 斐 腓 蜚 餥 婔 渄 猆 靟 䬠 飝"},
    {393224, 1, "勒"},
    {393227, 5, "黑 嘿 潶 黒 㱄"},
    {393237, 1, "塞"},
    {393728, 37, "威 崴 偎 煨 葳 隈 萎 委 逶 烓 椳 渨 碨 愄 揋 葨 隇 溾 詴 蝛 覣 燰 危 倭 微 薇 喡 溦 蜲 踒 喴 媙 鰄 㙎 嵔 楲 鰃"},
    {393733, 13, "堆 頧 痽 追 敦 鐓 垖 塠 磓 鐜 嵟 䔻 䭔"},
    {393734, 7, "推 蓷 藬 太 蘈 㷟 煺"},
    {393737, 47, "歸 規 龜 瑰 閨 圭 珪 皈 傀 媯 槻 鮭 槼 邽 窐 溈 嫢 摫 洼 烓 茥 硅 筀 楏 煃 觟 銈 瞡 鍷 蘣 蘳 蘬 归 帰 胿 亀 槣 蓕 嬀 潙 炔 璝 膭 瓌 郌 鬹 䲅"},
    {393738, 15, "虧 窺 盔 闚 刲 悝 鍷 茥 藈 噅 巋 蘬 楏 聧 蝰"},
    {393739, 50, "灰 揮 輝 恢 詼 暉 麾 徽 墮 褌 撝 隳 挼 煇 翬 豗 褘 洃 隓 顪 鰴 拻 噅 禈 虺 盔 戲 黴 倠 楎 諢 鍕 戏 灳 咴 烣 婎 媈 㡓 裩 戯 䘗 戱 瀈 㿗 㷇 幑 睳 𦑩 噕"},
    {393743, 11, "追 錐 椎 隹 騅 鵻 腄 鴭 碓 娺 䳡"},
    {393744, 4, "吹 炊 磓 龡"},
    {393747, 12, "厜 羧 嶉 纗 朘 脧 嗺 欈 垖 塠 樶 蟕"},
    {393748, 13, "摧 催 崔 嗺 墔 磪 榱 衰 凗 膗 縗 獕 槯"},
    {393749, 23, "雖 綏 濉 睢 荽 毸 眭 浽 哸 娞 荾 滖 尿 葰 雎 夊 芕 虽 奞 熣 鴡 䕑 鞖"},
    {458752, 10, "凹 ㄠ 坳 柪 熬 爊 㘭 軪 㕭 垇"},
    {458753, 22, "包 胞 苞 褒 枹 笣 蕔 孢 炮 剝 皰 褻 鞄 褎 齙 剥 靤 裦 闁 襃 礮 礟"},
    {458754, 4, "拋 脬 泡 抛"},
    {458755, 3, "貓 摸 猫"},
    {458757, 12, "刀 叨 忉 舠 氘 幍 魛 灱 朷 灲 釖 刂"},
    {458758, 31, "掏 濤 滔 饕 韜 弢 絛 縚 搯 慆 槄 幍 翢 嫍 蜪 叨 挑 夲 涛 瑫 飸 縧 謟 轁 䤾 饀 鞱 夵 㫞 䄻 詜"},
    {458759, 4, "峱 撓 孬 嶩"},
    {458760, 3, "撈 嘮 哰"},
    {458761, 48, "高 糕 膏 篙 羔 皋 櫜 睪 鼛 槔 睾 滜 韟 咎 臬 嗥 蒿 嗃 塙 暠 皞 碻 禚 翯 髜 髇 鰝 鷎 桕 皐 臯 獆 噑 暤 獔 嘷 墧 暭 槹 獋 曍 橰 皡 皥 餻 髙 㟸 鷱"},
    {458762, 4, "尻 訄 嵪 髛"},
    {458763, 3, "蒿 嚆 薅"},
    {458767, 22, "朝 招 昭 召 著 嘲 釗 駋 鉊 晁 盄 鍣 妱 抓 迢 弨 怊 佋 巶 着 謿 窼"},
    {458768, 12, "抄 鈔 超 勦 弨 怊 訬 剿 罺 摷 欩 䫿"},
    {458769, 17, "燒 稍 梢 艄 捎 弰 蛸 莦 筲 旓 髾 輎 鮹 蕱 杪 娋 颵"},
    {458771, 8, "遭 糟 蹧 傮 慒 鰽 㷮 醩"},
    {458772, 9, "操 糙 鄵 喿 劋 幧 矂 鐰 撡"},
    {458773, 16, "艘 騷 繅 搔 臊 慅 溞 颾 鱢 橾 璅 瘙 糔 繰 鰺 鰠"},
    {459008, 22, "要 腰 夭 妖 邀 么 吆 喲 喓 祅 葽 訞 凹 宎 殀 芺 徼 幺 枖 梎 楆 鴁"},
    {459009, 41, "標 彪 鑣 鏢 飆 膘 熛 麃 嘌 杓 滮 瀌 猋 瘭 穮 颮 驫 摽 儦 臕 颩 髟 謤 墂 贆 蔈 爂 藨 僄 虨 颷 飈 飊 飇 䮽 飍 脿 幖 徱 磦 𢖐"},
    {459010, 18, "飄 漂 慓 螵 薸 僄 旚 翲 魒 票 嫖 縹 嘌 彯 暼 麅 闝 飃"},
    {459011, 1, "喵"},
    {459013, 23, "雕 凋 刁 貂 鵰 碉 叼 彫 瞗 琱 鯛 扚 蛁 鳭 虭 殦 蜩 錭 刟 奝 弴 鮉 鼦"},
    {459014, 12, "挑 祧 恌 庣 鮡 佻 趒 蓨 旫 聎 蓚 䄻"},
    {459016, 1, "撩"},
    {459020, 75, "教 交 膠 驕 焦 嬌 郊 跤 澆 蛟 蕉 礁 椒 茭 姣 鮫 僬 憍 艽 鷦 燋 詨 鱎 鐎 鵁 鷮 嘄 憿 膲 穚 蟂 鷍 嶕 蟭 咬 皎 喬 鉸 憔 恔 挍 洨 俶 珓 琡 筊 劁 摎 嫶 樛 潐 頝 嬓 徼 燆 犞 穛 簥 趭 譥 鸄 乔 晈 胶 敎 敫 誟 嶣 癄 譤 顦 齩 䶧 茮 虠"},
    {459021, 31, "敲 鍬 橇 撬 蹺 磽 蹻 墝 幧 繑 髜 鐰 鏒 塙 鄡 墽 骹 庨 郻 頝 俏 悄 雀 鄗 誚 毃 敺 趬 鄥 鍫 嵪"},
    {459022, 77, "消 銷 蕭 瀟 宵 逍 囂 簫 削 硝 霄 哮 驍 梟 蠨 枵 魈 鴞 嘵 綃 嘐 歊 潚 烋 獢 虓 蛸 痚 憢 灱 呺 穘 洨 涍 痟 萷 踃 膮 藃 櫹 髇 毊 虈 庨 啋 窙 顤 謼 肖 屑 猇 揱 翛 榍 鄡 箾 橚 熽 蟂 髐 灲 侾 奞 婋 焇 硣 嘋 鄥 撨 䲷 簘 鴵 蟰 嚻 宯 彇 㩋"},
    {524288, 23, "歐 甌 毆 嘔 謳 鷗 ㄡ 慪 區 熰 蓲 櫙 漚 敺 藲 鏂 区 欧 瓯 塸 膒 瞘 䥲"},
    {524290, 3, "剖 吥 娝"},
    {524292, 1, "不"},
    {524293, 11, "都 兜 郖 唗 吺 侸 剅 兠 篼 㨮 蔸"},
    {524294, 5, "偷 媮 偸 婾 鍮"},
    {524296, 2, "摟 瞜"},
    {524297, 25, "句 溝 勾 鉤 枸 泃 篝 緱 构 芶 耩 佝 區 搆 袧 斠 簼 韝 齁 区 沟 鈎 鞲 褠 䵶"},
    {524298, 8, "摳 彄 芤 袧 鏂 剾 眗 䁱"},
    {524299, 2, "齁 呴"},
    {524303, 32, "周 週 州 洲 舟 粥 賙 啁 盩 譸 輈 喌 騆 鵃 洀 淍 銂 珘 徟 輖 侜 婤 倜 睭 詶 㖄 烐 郮 䓟 霌 矪 嚋"},
    {524304, 10, "抽 瘳 搊 篘 犨 婤 紬 搐 㨨 犫"},
    {524305, 3, "收 荍 収"},
    {524307, 21, "鄒 謅 鄹 諏 啁 掫 菆 陬 騶 鯫 棸 緅 棷 郰 媰 黀 齱 齺 娵 邹 箃"},
    {524309, 23, "搜 颼 鄋 蒐 廋 溲 餿 獀 醙 嗖 鎪 騪 叟 艘 叜 捒 捜 傁 廀 摗 蓃 撨 螋"},
    {524544, 23, "優 憂 幽 悠 呦 攸 耰 麀 櫌 鄾 懮 怮 嚘 瀀 纋 蚴 黝 优 泑 筱 忧 䥳 妋"},
    {524547, 1, "唒"},
    {524549, 4, "丟 銩 丢 厾"},
    {524551, 1, "妞"},
    {524552, 3, "溜 蹓 澑"},
    {524556, 28, "糾 揪 啾 鳩 轇 湫 樛 揫 勼 朻 牞 觓 揂 萛 鬮 灸 究 虯 釓 蝤 糺 虬 湬 噍 丩 芁 稵 鬏"},
    {524557, 39, "秋 邱 丘 蚯 鞦 鰍 鶖 楸 坵 萩 偢 緧 媝 蓲 趥 龜 恘 蝵 蟗 蠤 啾 愀 揪 鍬 揫 煍 瞅 踿 丠 㚱 㳋 亀 噍 篍 鍫 矁 龝 鞧 鱃"},
    {524558, 27, "修 休 羞 脩 咻 庥 貅 髹 饈 鵂 滫 樇 臹 茠 銝 蓨 鎀 潃 恘 烌 蓚 髤 鏅 飍 俢 㳜 鱃"},
    {589824, 35, "安 鞍 鮟 庵 諳 氨 銨 胺 ㄢ 鵪 媕 侒 盦 峖 痷 腤 萻 垵 陰 菴 厂 闇 鴳 阴 侌 隂 葊 誝 蓭 鞌 嬜 盫 鶕 厈 阥"},
    {589825, 16, "班 般 搬 斑 頒 扳 瘢 虨 斒 攽 褩 朌 肦 㻞 辬 螌"},
    {589826, 8, "潘 攀 眅 扳 拚 番 㐴 畨"},
    {589828, 24, "番 翻 蕃 繙 幡 帆 旛 籓 僠 嬏 轓 鱕 反 藩 柉 皤 仮 㠶 忛 畨 憣 飜 噃 䑺"},
    {589829, 38, "單 擔 丹 耽 簞 鄲 眈 聃 酖 砃 甔 襌 匰 聸 勯 嚪 湛 憚 旃 栴 儋 鴅 殫 癉 鄿 鷤 妉 单 担 䒟 単 耼 惮 躭 媅 頕 旜 㴷"},
    {589830, 15, "貪 灘 攤 癱 坍 怹 抩 舑 緂 探 嘽 橝 滩 噒 擹"},
    {589831, 1, "囡"},
    {589833, 57, "乾 甘 干 竿 肝 尷 柑 坩 泔 咁 疳 玕 杆 矸 虷 筸 蜬 鳱 嵅 訐 蚶 酣 扞 犴 旰 姏 拑 皯 盰 玵 哻 涆 酐 紺 釬 閈 詌 靬 頇 甝 雸 馯 骭 漧 魽 忓 佄 乹 苷 粓 亁 尶 魐 攼 芉 迀 凲"},
    {589834, 14, "刊 堪 勘 戡 看 龕 嵁 嵌 歁 墈 磡 刋 栞 盫"},
    {589835, 14, "酣 鼾 蚶 憨 頇 魽 唅 甝 谽 嫨 姏 酐 佄 馠"},
    {589839, 42, "詹 沾 瞻 氈 霑 旃 譫 鱣 覘 邅 栴 鸇 驙 占 呫 饘 鉆 詀 薝 譠 佔 玷 贍 怗 枮 粘 蛅 惉 颭 幨 餰 襜 魙 毡 趈 閚 噡 嶦 氊 旜 讝 厃"},
    {589840, 14, "摻 攙 梴 襜 辿 鋓 惉 嬓 裧 幨 掺 袩 撡 脠"},
    {589841, 43, "山 扇 衫 杉 刪 珊 羶 舢 煽 潸 跚 姍 芟 苫 搧 縿 穇 挻 烻 狦 笘 剼 摻 奾 屾 氙 埏 膻 襂 邓 邖 删 姗 掺 嘇 撡 檆 羴 鯅 㰑 䀐 傓 澘"},
    {589843, 7, "簪 鐕 撍 簮 鐟 兂 䐶"},
    {589844, 19, "參 餐 驂 縿 墋 毿 磣 襂 贂 鏒 鬖 叁 参 飡 叅 湌 傪 曑 䱗"},
    {589845, 16, "三 參 毿 鬖 仨 槮 襂 弎 叁 参 叄 叅 椮 犙 曑 謲"},
    {590080, 47, "煙 焉 淹 殷 醃 咽 胭 奄 湮 菸 嫣 燕 蔫 閹 厭 崦 臙 鄢 漹 猒 珚 偣 嬮 酀 腌 垔 凐 殗 傿 歅 嘕 禋 嬐 諲 閼 懨 黫 烟 陻 硽 嶖 㷼 篶 㤿 㥼 䅧 懕"},
    {590081, 21, "邊 編 鞭 蝙 砭 籩 箯 稨 猵 甂 柉 楄 煸 揙 边 牑 獱 鍽 邉 鯾 鯿"},
    {590082, 11, "篇 偏 扁 翩 萹 媥 貵 頨 鶣 片 犏"},
    {590085, 19, "顛 巔 癲 滇 拈 掂 傎 瘨 敁 蹎 槙 齻 厧 闐 嵮 巓 攧 槇 顚"},
    {590086, 12, "天 添 倎 屇 酟 婖 兲 沗 詽 靝 訮 黇"},
    {590092, 98, "間 監 堅 尖 兼 肩 艱 奸 姦 煎 緘 濺 漸 箋 殲 菅 戔 鞬 牋 椷 縑 湔 熸 蒹 鶼 廌 犍 籛 豜 韉 鬋 鈃 鑯 鰹 鰜 櫼 熞 蕑 揃 搛 幵 菺 靬 葌 鳽 餰 礛 騝 鵳 瀸 虃 惤 猏 麉 訐 淺 閒 尷 鏗 犴 掮 傔 堿 媊 慊 硻 葴 慳 槏 蒧 蜸 鋻 豏 襉 馦 鰔 鼸 姧 浅 飦 碊 豣 睷 銒 䊕 尶 鍳 馢 瀐 魐 譼 韀 礷 开 冿 黬 囏 凲"},
    {590093, 89, "千 鉛 遷 簽 牽 謙 籤 嵌 仟 阡 韆 騫 愆 僉 慳 搴 褰 粁 岍 汧 縴 芊 掔 扦 檶 鐱 婜 羥 攐 攓 顩 奷 忏 顅 麉 櫏 虔 縑 殲 纖 讖 寋 鈆 雃 僊 嗛 舝 鋟 褼 謇 韱 藆 孅 瀸 櫼 鶼 鶱 躚 襳 虃 鑯 圱 圲 汘 杄 迁 茾 拪 䊹 摼 撁 熑 艌 厱 諐 韯 燫 瀐 覵 鵮 攑 籖 纎 臤 蚈 孯 蹮 鬜 谸"},
    {590094, 59, "先 仙 掀 鮮 纖 暹 姍 孅 憸 躚 銛 秈 韱 枮 氙 馦 嬐 仚 屳 奾 杴 忺 澖 灦 祆 僊 嘕 蓒 褼 廯 襳 珗 屾 佡 侁 胘 赻 筅 綅 詵 錟 駪 薟 攕 鶱 虃 彡 姗 欦 籼 苮 箲 韯 嬜 纎 鱻 酰 銽 蹮"},
    {590336, 14, "灣 彎 豌 剜 莞 蜿 刓 潫 眢 婠 弯 帵 湾 萖"},
    {590341, 7, "端 耑 偳 剬 媏 鍴 褍"},
    {590342, 6, "湍 煓 貒 遄 猯 䝎"},
    {590345, 28, "官 關 觀 冠 棺 矜 鰥 綸 倌 莞 瘝 毌 鱞 婠 悺 涫 逭 痯 錧 矝 萖 窤 蒄 関 癏 観 闗 輨"},
    {590346, 4, "寬 髖 臗 寛"},
    {590347, 18, "歡 驩 讙 獾 犿 懽 酄 鴅 豲 嚾 虇 鱹 欢 覌 歓 㹕 鵍 貛"},
    {590351, 18, "專 磚 耑 顓 塼 鄟 鱄 剸 嫥 瑼 篿 鷒 膞 蟤 蓴 蒓 甎 叀"},
    {590352, 9, "穿 川 鐉 氚 瑏 釧 圌 灥 巛"},
    {590353, 3, "栓 閂 拴"},
    {590355, 4, "鑽 躦 劗 鑚"},
    {590356, 5, "攛 躥 鋑 汆 鑹"},
    {590357, 3, "酸 痠 狻"},
    {590592, 34, "冤 淵 鴛 鳶 宛 眢 蜎 鵷 肙 鋺 惌 棩 蒬 裷 鼘 葾 蜵 裫 駌 嬽 灁 怨 妴 奫 潫 囦 剈 寃 渆 渊 渁 鼝 㾓 䡝"},
    {590604, 29, "捐 娟 鵑 涓 鐫 圈 蠲 朘 身 脧 裐 狷 絹 悁 梋 焆 琄 睊 蜎 鋗 鋑 鞙 駽 姢 剶 圏 瓹 鎸 勬"},
    {590605, 9, "圈 悛 棬 弮 絟 惓 峜 圏 箞"},
    {590606, 51, "宣 軒 喧 瑄 萱 暄 壎 儇 諼 塤 嬛 揎 翾 諠 愃 晅 鍹 梋 煖 萲 愋 佡 昍 鋗 媗 禤 蝖 蠉 矎 渲 暖 仚 搟 楦 蓒 懁 駽 坃 㘣 弲 煊 煗 睻 箮 翧 蕿 藼 蘐 壦 暅 譞"},
    {655360, 4, "恩 嗯 ㄣ 蒽"},
    {655361, 9, "奔 賁 錛 泍 渀 卉 犇 倴 𩣺"},
    {655362, 5, "噴 歕 賁 濆 喯"},
    {655363, 2, "悶 燜"},
    {655364, 27, "分 紛 芬 氛 吩 棻 玢 酚 雰 昐 鈖 砏 翂 衯 饙 梤 鳻 汾 邠 錀 岎 帉 㤋 訜 䭻 朆 餴"},
    {655369, 3, "跟 根 蛝"},
    {655375, 70, "真 針 珍 貞 偵 禎 斟 箴 砧 甄 臻 楨 榛 診 蓁 獉 溱 碪 胗 鍼 鱵 媜 駗 薽 禛 樼 潧 瑊 遉 寊 蒧 轃 籈 鷏 堻 唇 振 疹 幀 殄 桭 紾 湞 軫 鄄 椹 葴 磡 赬 鍖 鍞 瀙 珎 帪 栕 眞 酙 嫃 搸 鉁 靕 蒖 緽 澵 錱 頳 殝 儬 㡧 㖘"},
    {655376, 13, "嗔 琛 瞋 郴 賝 棽 謓 諃 搷 堔 抻 捵 綝"},
    {655377, 50, "身 深 伸 申 紳 呻 信 參 蔘 娠 莘 甡 侁 籸 葠 詵 駪 燊 砷 柛 氠 屾 珅 胂 阠 妽 峷 眒 琛 兟 棽 幓 銵 篸 鯓 㕥 扟 叁 参 籶 訫 叅 鉮 曑 敒 訷 瘮 鵢 裑 甧"},
    {655380, 7, "參 嵾 梫 叁 参 叅 曑"},
    {655381, 8, "森 槮 罧 襂 幓 篸 穼 椮"},
    {655616, 52, "因 音 陰 姻 殷 茵 慇 氤 瘖 喑 堙 湮 愔 禋 絪 裀 闉 駰 銦 蒑 諲 垔 韾 洇 凐 歅 噾 霠 黫 摿 欭 珚 偣 湆 霒 阴 侌 栶 婣 䄄 秵 筃 陻 隂 溵 潱 緸 鞇 囙 阥 㧢 磤"},
    {655617, 43, "賓 濱 彬 檳 儐 斌 繽 豳 瀕 邠 璸 蠙 鑌 豩 汃 椕 霦 驞 份 稟 嬪 殯 鬢 攽 玢 砏 郴 虨 娦 浜 梹 滨 㻞 禀 殡 賔 髩 濵 鬂 穦 顮 馪 𠚼"},
    {655618, 4, "拼 姘 礗 涄"},
    {655628, 45, "今 金 禁 津 斤 巾 筋 襟 矜 浸 觔 衿 祲 瑧 菳 珒 埐 紟 嶜 惍 沂 鈐 伒 坅 岒 庈 忴 扲 昑 肣 蚙 軡 堻 靳 靲 鬿 斳 鳹 矝 黅 鵭 兓 荕 濅 䃸"},
    {655629, 25, "親 侵 欽 衾 駸 嶔 綅 瀙 鋟 撳 唚 梫 寑 菳 廞 顉 儭 亲 媇 搇 誛 澵 儬 鮼 寴"},
    {655630, 35, "心 新 辛 薪 欣 鋅 馨 鑫 莘 炘 歆 芯 昕 訢 鈊 盺 兟 廞 忻 妡 噷 掀 伈 伒 忥 杺 斪 惢 焮 騂 邤 俽 惞 忄 㣺"},
    {655872, 20, "溫 瘟 轀 塭 馧 瞃 豱 殟 媼 嗢 膃 褞 昷 媪 温 腽 瑥 輼 鰛 鰮"},
    {655877, 19, "敦 蹲 墩 惇 礅 驐 蜳 撉 鐓 噸 憝 橔 弴 墪 憞 撴 䃦 鐜 犜"},
    {655878, 10, "吞 暾 啍 涒 旽 昋 呑 噋 黗 朜"},
    {655880, 2, "掄 輪"},
    {655882, 27, "昆 崑 坤 琨 錕 焜 褌 晜 鯤 菎 騉 髡 惃 猑 混 倱 緄 堃 崐 㡓 髠 蜫 裩 髨 瑻 醌 罤"},
    {655883, 14, "婚 昏 葷 閽 惛 睯 殙 棔 涽 敯 睧 諙 昬 惽"},
    {655887, 9, "諄 屯 肫 窀 迍 宒 訰 炖 衠"},
    {655888, 14, "春 椿 杶 輴 焞 鰆 媋 暙 鶞 湷 橁 旾 萅 櫄"},
    {655890, 1, "犉"},
    {655891, 13, "尊 遵 樽 墫 鐏 嶟 繜 鷷 壿 燇 譐 鱒 罇"},
    {655892, 6, "村 皴 踆 邨 澊 竴"},
    {655893, 9, "孫 飧 蓀 猻 搎 槂 薞 蕵 飱"},
    {656128, 11, "暈 氳 縕 贇 奫 蝹 涒 氲 蒀 蒕 緼"},
    {656140, 41, "軍 君 均 鈞 皸 囷 麇 莙 鮶 桾 蚐 袀 頵 龜 碅 裙 呁 枃 峮 捃 焄 珺 赹 憌 鍕 鵘 鼲 㚬 汮 帬 亀 裠 皹 銁 銞 攈 鵾 麕 攟 覠 麏"},
    {656141, 6, "逡 踆 峮 碅 蜠 輑"},
    {656142, 26, "勳 薰 燻 熏 醺 峋 曛 焄 獯 纁 臐 蔒 勛 矄 勣 葷 壎 塤 窨 坃 姰 勲 薫 爋 蘍 壦"},
    {720896, 3, "骯 腌 ㄤ"},
    {720897, 13, "幫 邦 傍 梆 鞤 縍 垹 沯 帮 邫 幇 幚 峀"},
    {720898, 9, "乓 磅 滂 膀 汸 胮 膖 髈 霶"},
    {720900, 16, "方 芳 坊 枋 邡 淓 鈁 匚 汸 妨 肪 舫 閍 牥 蚄 趽"},
    {720901, 11, "當 噹 鐺 襠 璫 簹 儅 澢 艡 嵣 当"},
    {720902, 9, "湯 鏜 鼞 蹚 蝪 薚 鐋 䠀 鞺"},
    {720904, 1, "啷"},
    {720905, 36, "剛 鋼 缸 崗 綱 岡 肛 扛 杠 罡 疘 釭 堽 碙 棡 笐 堈 犅 亢 缶 韁 仜 妅 灴 玒 瓨 矼 豇 魟 玜 娂 掆 缻 罁 鎠 繮"},
    {720906, 14, "康 慷 糠 鏮 漮 嫝 鱇 忼 粇 嵻 穅 躿 㝩 䆲"},
    {720907, 1, "夯"},
    {720911, 23, "張 章 彰 漳 樟 璋 獐 嫜 暲 鄣 蟑 鱆 慞 傽 墇 騿 遧 粻 蔁 麞 𢕎 𢕔 餦"},
    {720912, 17, "昌 倡 猖 娼 閶 菖 鯧 倀 鼚 錩 淐 琩 裮 晿 䮖 䱽 鱂"},
    {720913, 17, "商 傷 殤 觴 湯 漡 蔏 螪 謪 鬺 裳 愓 熵 薚 墒 慯 滳"},
    {720914, 1, "嚷"},
    {720915, 9, "髒 贓 臢 牂 臧 賍 贜 匨 羘"},
    {720916, 14, "蒼 倉 滄 艙 傖 鶬 凔 嵢 愴 瑲 謒 蹌 仺 篬"},
    {720917, 5, "喪 桑 縔 桒 槡"},
    {721152, 21, "央 秧 殃 鴦 鞅 泱 坱 胦 柍 佒 姎 紻 鉠 雵 抰 咉 眏 䄃 楧 鍈 䱀"},
    {721164, 28, "將 江 疆 僵 漿 姜 薑 豇 殭 韁 螿 橿 茳 礓 瓨 翞 鏘 矼 墏 嶈 将 畕 畺 葁 摪 壃 繮 疅"},
    {721165, 31, "槍 腔 鎗 羌 嗆 搶 鏘 鏹 蜣 蹌 斨 瑲 椌 蹡 錆 矼 嶈 將 牄 謒 唴 戧 錓 将 羗 啌 猐 溬 摤 篬 羫"},
    {721166, 28, "鄉 相 香 箱 湘 襄 鑲 廂 驤 緗 薌 瓖 纕 欀 葙 忀 曩 舡 萫 曏 膷 勷 皀 啌 郷 鄊 鄕 麘"},
    {721408, 6, "汪 尪 尢 尫 尣 尩"},
    {721417, 21, "光 胱 洸 桄 珖 炚 茪 銧 垙 烡 絖 灮 侊 咣 姯 輄 僙 黆 炗 炛 硄"},
    {721418, 15, "匡 框 筐 誆 劻 恇 洭 眶 哐 邼 㑌 匩 䒰 硄 軭"},
    {721419, 7, "荒 慌 肓 衁 巟 嚝 塃"},
    {721423, 15, "裝 莊 樁 妝 粧 庄 梉 妀 籹 妆 庒 疞 娤 荘 糚"},
    {721424, 19, "窗 創 瘡 囪 憃 戧 摐 愴 刱 瑲 刅 囱 剏 剙 窓 牎 牕 窻 刽"},
    {721425, 16, "雙 霜 孀 艭 驦 鷞 孇 礵 瀧 双 滝 騻 欆 鸘 䉶 䝄"},
    {786432, 2, "鞥 ㄥ"},
    {786433, 12, "崩 繃 伻 弸 祊 閍 塴 絣 痭 嵭 綳 奟"},
    {786434, 22, "砰 烹 抨 怦 漰 澎 匉 閛 恲 軯 駍 磞 亨 硼 泙 淜 㛁 胓 㧸 硑 嘭 梈"},
    {786435, 1, "矇"},
    {786436, 46, "風 蜂 封 豐 瘋 峰 鋒 丰 烽 楓 諷 酆 葑 灃 犎 捀 桻 妦 檒 偑 崶 蘴 飌 麷 猦 豊 仹 凨 凬 盽 㛔 峯 堼 湗 碸 僼 熢 鄷 鏠 㒥 寷 蠭 凮 䒠 篈 靊"},
    {786437, 12, "登 燈 鐙 簦 豋 璒 嬁 墱 撜 灯 噔 竳"},
    {786441, 19, "更 耕 庚 粳 羹 賡 浭 緪 鶊 菮 揯 挭 刯 畊 秔 稉 絚 羮 𨁈"},
    {786442, 24, "坑 硜 鏗 牼 吭 阬 硻 銵 娙 挳 鍞 傾 囥 邟 笐 慳 誙 妔 砊 揁 摼 䃘 劥 殸"},
    {786443, 5, "亨 哼 脝 諻 悙"},
    {786447, 48, "爭 征 蒸 睜 徵 掙 箏 正 怔 猙 錚 崢 諍 癥 鉦 烝 篜 姃 炡 埩 聇 丁 眐 鯖 玎 糽 凈 脀 棦 琤 澂 㣔 争 佂 峥 䒱 䋊 徴 鴊 瀓 鬇 鏳 𡈼 挣 睁 㬹 𨜓 徰"},
    {786448, 35, "稱 撐 瞠 蟶 偁 檉 赬 琤 橕 鏿 浾 埥 棦 牚 竀 崝 饓 槍 鎗 鐺 噌 樘 㣔 泟 阷 称 㛵 僜 憆 撑 緽 頳 穪 鏳 爯"},
    {786449, 29, "生 聲 勝 升 牲 昇 甥 笙 陞 泩 鉎 鼪 呏 狌 湦 焺 鵿 胜 貹 髜 声 阩 珄 苼 陹 鍟 斘 殸 殅"},
    {786450, 2, "扔 仍"},
    {786451, 17, "曾 增 憎 罾 繒 矰 橧 磳 驓 璔 僧 噌 潧 鬙 増 熷 譄"},
    {786452, 1, "噌"},
    {786453, 3, "僧 鬙 䒏"},
    {786688, 52, "應 英 鷹 嬰 鶯 櫻 膺 瑛 鸚 嚶 罌 纓 攖 瓔 嫈 甖 罃 煐 韺 甇 霙 碤 礯 朠 蝧 渶 褮 偀 霒 蘡 譻 蠳 鶧 薨 贗 賏 瀴 応 偐 啨 媖 䊔 噟 贋 鶑 孆 孾 譍 鑍 鸎 䣐 鷪"},
    {786689, 13, "兵 冰 掤 栟 并 屏 檳 仌 氷 幷 屛 梹 幈"},
    {786690, 11, "乒 娉 砯 頩 覮 砰 甹 俜 艵 硑 聠"},
    {786693, 16, "丁 釘 叮 疔 酊 盯 仃 玎 帄 靪 虰 汀 町 糽 飣 𠆤"},
    {786694, 15, "聽 廳 汀 桯 艼 耵 听 朾 綎 庁 鞓 聴 廰 聼 耓"},
    {786696, 2, "拎 昤"},
    {786700, 63, "經 精 京 驚 睛 莖 晶 菁 更 兢 涇 鯨 荊 旌 粳 黥 箐 鶄 巠 婛 旍 鵛 鶁 鼱 麠 仱 惊 青 耕 痙 弳 挳 婧 桱 殌 牼 硜 羥 蛵 翞 蒯 誙 鋞 坕 靑 亰 畊 秔 茎 婙 寈 経 稉 腈 荆 葏 摾 䃘 薓 猄 聙 鹶 麖"},
    {786701, 38, "清 青 輕 傾 卿 氫 蜻 頃 鯖 圊 氰 狅 郬 菁 請 凊 埥 崝 掅 烴 棈 碃 羥 箐 綪 漀 輤 錆 蹞 鶄 鼱 鑋 靑 婙 寈 淸 軽 䨝"},
    {786702, 23, "興 星 猩 腥 馨 惺 騂 煋 瑆 胜 垶 蛵 觲 馫 醒 狌 觪 鮏 曐 嬹 鯹 篂 皨"},
    {786944, 9, "翁 嗡 螉 鶲 霐 蓊 鎓 䩺 䱵"},
    {786949, 23, "東 冬 咚 鼕 苳 蝀 埬 崠 氡 炵 涷 菄 鶇 㚵 昸 倲 娻 崬 笗 氭 鯟 𤷆 𩂓"},
    {786950, 9, "通 恫 蓪 痌 炵 熥 狪 囲 樋"},
    {786953, 46, "工 公 功 供 攻 宮 恭 躬 弓 蚣 紅 龔 肱 觥 疘 釭 篢 塨 愩 匑 共 幊 仜 妅 玒 昮 羾 舼 蛬 鈆 輁 杛 侊 玜 糿 糼 咣 娂 宫 躳 匔 髸 觵 碽 䳍 龏"},
    {786954, 15, "空 崆 倥 箜 悾 硿 涳 錓 焢 谾 曌 鞚 㚚 埪 鵼"},
    {786955, 18, "轟 哄 烘 薨 訇 吽 揈 渹 哅 輷 谾 鍧 焢 魟 薧 叿 𧥺 𩐠"},
    {786959, 31, "中 鐘 終 忠 鍾 衷 忪 盅 螽 伀 妐 蔠 柊 煄 彸 舯 炂 籦 鼨 汷 刣 㕬 泈 衳 幒 徸 銿 鴤 𦬕 蹱 𩅞"},
    {786960, 17, "充 衝 沖 舂 忡 憧 珫 茺 浺 蹖 祌 翀 憃 罿 冲 嘃 摏"},
    {786963, 46, "宗 蹤 縱 綜 棕 鬃 豵 騣 鬷 翪 熧 倧 惾 猣 稯 艐 嵕 蝬 從 淙 琮 朡 嵷 賨 鍐 从 従 嵏 椶 嵸 賩 踪 踨 磫 縦 騌 鬉 鯮 鯼 苁 㚇 堫 葼 㙡 䁓 緃"},
    {786964, 44, "匆 聰 從 囪 璁 瑽 樅 驄 蓯 鏦 熜 棇 暰 蔥 瞛 蟌 鍐 叢 囟 濍 从 匇 囱 忩 怱 従 悤 楤 葱 漗 聡 樬 緫 聪 聦 樷 繱 鏓 顖 騘 枞 苁 篵 鍯"},
    {786965, 19, "松 鬆 淞 嵩 忪 菘 娀 崧 濍 倯 硹 蜙 枀 柗 凇 庺 梥 憽 檧"},
    {787200, 26, "傭 庸 雍 擁 壅 癰 臃 墉 鏞 慵 饔 邕 廱 雝 嗈 灉 鄘 噰 澭 蕹 滽 郺 㴩 牅 㿈 癕"},
    {787212, 8, "扃 坰 駉 冂 垧 埛 駫 䮐"},
    {787213, 7, "芎 穹 銎 桏 宆 焪 熍"},
    {787214, 16, "兄 兇 胸 凶 匈 洶 忷 哅 恟 酗 勳 芎 汹 胷 訩 詾"},
    {851968, 3, "ㄦ 兒 児"},
    {16777216, 1, "ˊ"},
    {16777231, 64, "直 職 質 值 植 執 殖 擲 姪 侄 蹠 蟄 躑 埴 稙 摭 縶 柣 犆 秷 擿 馽 慹 樴 膱 懫 蟙 褁 瓡 嬂 蘵 拓 蛭 戢 摯 躓 挃 烢 跖 戠 蓻 謺 贄 蹢 櫍 礩 騺 鷙 鑕 执 坧 妷 値 聀 釞 貭 禃 綕 墌 漐 𡸜 㨁 瓆 軄"},
    {16777232, 45, "持 池 遲 馳 匙 弛 墀 坻 踟 箎 茬 蚳 篪 蚔 茌 痄 忯 汦 荎 栘 歭 耛 貾 趍 箈 徲 謘 徥 尺 治 泜 痴 彽 阺 乿 跢 鍉 坘 岻 竾 俿 赿 筂 遅 遟"},
    {16777233, 32, "十 什 石 時 實 食 拾 蝕 碩 射 提 蒔 湜 鰣 塒 祏 鼫 鉐 榯 湁 溡 鼭 寔 籵 姼 时 实 実 炻 遈 旹 宲"},
    {16777236, 31, "詞 辭 慈 磁 瓷 雌 祠 疵 茨 粢 餈 柌 嬨 濨 呲 飺 薋 茲 茈 鈶 鶿 珁 䛐 辝 辞 甆 糍 辤 礠 鴜 鷀"},
    {16777472, 108, "遺 疑 移 宜 怡 姨 儀 夷 一 誼 胰 貽 飴 咦 詒 沂 頤 彞 迤 椸 痍 蛇 圯 嶷 笫 桋 匜 宧 洟 簃 訑 貤 迻 杝 柂 袲 酏 峓 眱 羠 鈶 寲 侇 珆 衪 銕 呲 恞 萓 沶 栘 瓵 袘 羡 蛦 暆 跠 歋 熪 箷 螔 顊 謻 觺 鸃 彝 台 圻 迆 益 熙 懿 圮 狋 祂 拸 眙 荑 詑 溰 磑 擨 鏔 弌 冝 狏 虵 迱 扅 眤 焈 竩 熈 㦉 彛 乁 宐 沵 巸 弬 㺿 頉 頥 鮧 鴺 㦤 㰘 讉"},
    {16777473, 3, "鼻 荸 鼽"},
    {16777474, 55, "皮 疲 脾 琵 枇 裨 啤 毗 埤 沘 貔 陂 羆 罷 紕 郫 陴 鼙 鈹 膍 毘 阰 蚽 蜱 玭 笓 鈚 錍 魾 螷 犤 毞 猈 蠯 比 芘 蚍 崥 椑 痹 髀 夶 肶 罢 渒 豼 焷 鈈 鉟 壀 篺 㓟 魮 隦 朇"},
    {16777475, 37, "迷 彌 謎 瀰 靡 糜 麋 縻 獼 蘼 冞 麛 醚 醾 檷 蘪 攠 瓕 爢 麊 鸍 獮 禰 弥 怽 罙 祢 詸 擟 籋 戂 醿 釄 猕 蒾 镾 狝"},
    {16777477, 52, "的 敵 迪 狄 笛 滌 翟 荻 嫡 嘀 鏑 蹢 糴 覿 篴 蔋 靮 梑 潪 苖 嚁 鸐 藋 藡 岫 抵 條 逖 適 濯 櫂 謫 扺 魡 樀 甋 鍉 蠗 条 廸 拞 籴 唙 逷 頔 樤 豴 讁 䑲 蔐 䨤 𢕚"},
    {16777478, 49, "題 提 啼 堤 蹄 醍 禔 稊 緹 荑 騠 隄 鶗 惿 厗 鍗 偍 趧 謕 鶙 崹 睼 蝭 蕛 鷤 鯷 鵜 珶 媞 蛦 綈 褆 鍉 鷈 鼶 埞 嗁 瑅 遆 碮 漽 蹏 禵 罤 䬫 䔶 鴺 鮷 鷉"},
    {16777479, 40, "泥 尼 妮 倪 霓 怩 猊 蜺 輗 郳 麑 鯢 齯 臡 秜 狋 觬 婗 淣 呢 狔 屔 跜 鈮 兒 旎 擬 堄 鬩 麛 児 㞾 拟 埿 棿 腝 貎 䦧 蚭 䛏"},
    {16777480, 84, "離 璃 黎 梨 籬 釐 犛 罹 貍 驪 犁 漓 灕 狸 藜 蜊 蠡 鸝 釃 斄 嫠 褵 黧 梩 漦 縭 蔾 氂 厘 蘺 剺 喱 篱 醨 鱺 劙 孋 廲 騹 孷 樆 謧 鯬 鵹 攡 麗 菞 鑗 粍 麶 俚 魑 霾 离 詈 筣 螭 蠫 刕 丽 剓 婯 悡 梸 荲 棃 犂 㴝 睝 鋫 錅 蟍 嚟 瓈 蟸 鏫 彲 穲 卨 猍 艃 盠 邌 㦒"},
    {16777484, 141, "及 級 極 即 集 急 擊 疾 籍 吉 寂 輯 脊 圾 唧 嫉 汲 亟 吃 棘 藉 瘠 楫 岌 笈 鶺 戢 殛 蹐 伋 蒺 耤 芨 蕺 踖 鈒 佶 堲 姞 濈 襋 墼 潗 鴶 嶯 洁 忣 湒 极 銡 狤 鏶 蝍 衱 偮 庴 莋 塉 槉 漃 膌 蓻 橶 蕀 轚 霵 彶 揤 楖 秸 鞊 螏 觙 戕 革 戟 勣 詰 劇 緝 積 髻 擷 蹟 鯽 丮 岋 扱 昅 咭 茍 咠 恄 砐 迼 唶 硈 聐 蛣 趌 毄 憰 撠 墽 諿 鮚 蟿 鰿 鷑 躤 亼 皀 卽 垐 㘹 郆 剧 㭲 淁 焏 喞 㦸 愱 稭 撃 箿 䔛 瘷 檝 鍓 艥 雦 雧 皍 卙 脨 㗊 㗱 趞 㘍 䳭"},
    {16777485, 122, "其 期 齊 奇 旗 騎 祈 棋 祺 碁 祁 崎 琦 岐 歧 琪 麒 鰭 畦 臍 祇 耆 淇 跂 枝 綦 騏 衹 蘄 圻 錡 旂 萁 蜞 埼 蠐 頎 懠 艩 蚔 軝 藄 鄿 鯕 鬐 蚑 錤 掑 岓 碕 翗 釮 亓 蚚 稘 鬿 踑 鮨 鶀 鵸 玂 麡 濝 示 沂 俟 畸 畿 儕 薺 霽 忯 肵 倛 剞 唭 娸 婍 徛 惎 攲 敧 搘 榰 鬾 觭 諆 諅 踦 櫅 璾 齌 懻 鑇 齮 齐 亝 斉 芪 竒 帺 㥍 朞 棊 竢 粸 綨 蜝 褀 璂 禥 櫀 檱 弜 剘 斊 萕 愭 㓾 綥 䳢 猉"},
    {16777486, 57, "習 昔 息 席 惜 媳 錫 襲 熄 蓆 褶 檄 覡 濕 隰 裼 嶍 螅 鰼 腊 槢 焟 謵 鎴 欯 棤 蒠 瘜 獥 薂 霫 飁 騽 蝷 夕 汐 矽 悉 憩 郋 唶 庴 釸 僁 慴 緆 踖 褯 雭 漝 蒵 趘 憇 齚 怸 椺 趞"},
    {16777728, 42, "無 吳 吾 梧 巫 蕪 唔 蜈 誣 毋 亡 膴 鼯 郚 鋘 鋙 峿 浯 珸 俉 鯃 莁 鷡 洖 瞴 圄 齬 曶 亾 兦 无 吴 呉 芜 娪 茣 銐 墲 鵐 璑 禑 蟱"},
    {16777729, 2, "不 醭"},
    {16777730, 30, "僕 樸 葡 蒲 菩 朴 蹼 脯 濮 璞 匍 莆 蒱 襆 酺 釙 鏷 轐 纀 墣 瞨 醭 圤 㺪 箁 幞 檏 襥 穙 菐"},
    {16777731, 6, "模 氁 毪 墲 橅 恈"},
    {16777732, 107, "服 福 扶 浮 符 伏 彿 縛 幅 俘 拂 苻 弗 孚 袱 芙 輻 蝠 匐 蜉 罘 涪 夫 郛 莩 怫 蚨 桴 紼 茯 菔 紱 咈 洑 綍 艴 芾 茀 艀 刜 帗 笰 葍 袚 氟 棴 澓 烰 枹 玸 岪 枎 垘 昲 柫 琈 虙 踾 鳧 巿 沷 祓 翇 韍 諨 鴔 黻 鵩 鶝 佛 沸 趺 孵 敷 冹 坲 宓 泭 狒 垺 罦 萉 榑 箙 仏 呋 炥 畉 畐 郍 鳬 哹 畗 旉 鉜 箁 酻 髴 鮄 鞴 乀 甶 栿 絥 鉘 颫 韛"},
    {16777733, 38, "讀 獨 毒 牘 纛 瀆 犢 髑 讟 黷 櫝 儥 碡 殰 蝳 贕 韇 韥 皾 督 頓 篤 蠹 豰 襩 韣 独 螙 凟 匵 嬻 瓄 蠧 鑟 𧰵 𡂝 騳 𡱰"},
    {16777734, 53, "圖 途 突 徒 塗 屠 凸 荼 涂 余 酴 瘏 稌 腯 峹 葖 捈 怢 鍎 跿 梌 湥 筡 蒤 瑹 駼 鶟 鷋 鼵 嵞 廜 潳 鷵 陡 徙 菟 唋 悇 蓗 鵌 図 阧 凃 鈯 圗 摕 宊 㻌 堗 揬 䣝 䠈 馟"},
    {16777735, 10, "奴 駑 孥 笯 蒘 呶 帑 弩 拏 伖"},
    {16777736, 32, "盧 蘆 廬 臚 爐 顱 瀘 鱸 轤 壚 鸕 玈 罏 艫 鑪 籚 櫨 嚧 攎 蠦 纑 璷 庐 炉 芦 魲 瓐 矑 髗 皶 獹 黸"},
    {16777737, 2, "骨 豰"},
    {16777739, 57, "胡 湖 壺 蝴 糊 狐 弧 葫 鬍 瑚 餬 斛 鵠 囫 縠 衚 觳 醐 猢 搰 鶘 槲 媩 抇 鰗 焀 魱 螜 瀫 楜 嘝 鶦 乎 和 核 泒 胍 壼 鈲 鶻 咊 瓳 壷 喖 惒 絗 蔛 頶 鍸 鱯 隺 𠴱 𤌍 箶 䁫 㗅 㿥"},
    {16777743, 39, "竹 築 逐 燭 蠋 筑 竺 朮 躅 舳 軸 窋 蓫 笁 趉 鱁 灟 蠾 茿 篫 妯 柚 泏 瓨 怷 瘃 蒆 孎 斸 欘 术 炢 烛 劚 曯 爥 薥 䟉 𦸇"},
    {16777744, 34, "除 儲 廚 鋤 櫥 雛 芻 躇 滁 躕 篨 耡 蜍 鉏 蒢 跦 鶵 幮 貙 趎 犓 屠 媰 藸 耝 䟞 厨 豠 㕑 蒭 橱 蹰 雏 蕏"},
    {16777745, 22, "叔 熟 淑 塾 贖 孰 菽 秫 襡 埱 焂 跾 鸀 虪 朱 椒 婌 鮛 掓 蒣 璹 尗"},
    {16777746, 41, "如 儒 孺 茹 蠕 嚅 濡 袽 襦 鴽 筎 臑 醹 挐 薷 銣 曘 燸 帤 蕠 需 懦 侞 洳 蒘 蝡 壖 嬬 擩 檽 瓀 繻 邚 桇 偄 愞 渪 瑌 顬 鱬 鴑"},
    {16777747, 21, "足 族 卒 嗾 捽 崒 踿 哫 傶 踤 鏃 娖 珿 蓗 踀 鷟 卆 崪 鎐 稡 鉃"},
    {16777748, 3, "殂 徂 鼀"},
    {16777749, 1, "俗"},
    {16777984, 134, "於 愉 魚 娛 餘 于 漁 予 愚 余 竽 榆 逾 虞 俞 輿 瑜 渝 隅 臾 腴 盂 諛 踰 伃 舁 圩 歟 覦 畬 萸 嵎 窬 妤 揄 歈 禺 轝 隃 雩 杅 楰 玗 緰 羭 蝓 褕 瘐 艅 狳 邘 璵 硢 籅 釪 崳 湡 鄃 腧 睮 雓 澞 蕍 螸 謣 鮽 蘛 鸆 衧 唹 堣 堬 雽 歶 旟 鰅 齵 吁 汙 污 吾 邪 訏 喻 菸 衙 與 譽 亍 与 佘 芧 悇 趶 悆 喁 棜 毹 蜍 虡 顒 亏 伃 汚 兪 娱 娯 桙 衺 酑 喩 媀 嵛 惥 畭 祦 楡 毺 萮 慂 嬩 懙 鍝 簴 騟 䱷 㚥 欤 茰 畲 骬 䰻 㦛 鷠"},
    {16777992, 14, "驢 閭 櫚 藘 慺 氀 膢 婁 娄 馿 爈 曥 㠠 䕡"},
    {16777996, 60, "局 鞠 菊 橘 掬 跼 桔 挶 鞫 侷 匊 踘 鋦 鵙 鶪 椈 焗 淗 驧 狊 梮 郹 犑 輂 箤 趜 鵴 蘜 鼳 陱 駶 拘 鴃 譎 麴 佢 扃 匑 湨 憰 潏 閰 璚 輷 瞲 鐍 抅 毩 婅 鄓 粷 諊 躹 鴂 匔 麯 蹫 巈 泦 毱"},
    {16777997, 43, "渠 劬 麴 衢 蟝 瞿 籧 璩 氍 蘧 磲 蕖 朐 軥 鴝 翑 葋 豦 懅 螶 鼩 匷 灈 欋 臞 蠷 躣 胊 斪 淭 菃 翵 蛐 絇 蚼 跔 璖 麯 忂 戵 癯 鑺 鸜"},
    {16777998, 6, "徐 余 邪 俆 衺 蒣"},
    {16842752, 1, "嗄"},
    {16842753, 22, "拔 跋 鈸 魃 茇 鼥 軷 犮 菝 胈 詙 帗 柭 祓 袚 抜 秡 墢 坺 炦 颰 鮁"},
    {16842754, 9, "爬 扒 琶 耙 杷 跁 筢 欛 潖"},
    {16842755, 10, "麻 痲 嘛 麼 蟆 犘 尛 麽 蔴 蟇"},
    {16842756, 21, "乏 伐 罰 閥 筏 砝 茷 法 疺 藅 眨 窆 瞂 姂 垡 栰 罸 橃 灋 佱 坺"},
    {16842757, 35, "答 達 韃 靼 瘩 怛 繨 噠 妲 笪 荅 薘 褟 鐽 匒 呾 畣 炟 鎝 打 撻 躂 疊 榙 劄 譗 达 迏 剳 詚 叠 曡 蟽 疉 𦖿"},
    {16842759, 7, "拿 挐 拏 誽 南 掔 詉"},
    {16842760, 6, "剌 邋 旯 拉 喇 揦"},
    {16842761, 5, "軋 噶 釓 嘎 錷"},
    {16842763, 3, "蛤 蝦 鰕"},
    {16842767, 19, "扎 札 紮 閘 炸 霅 鍘 哳 劄 蚻 譗 蠿 癿 煠 紥 剳 牐 耫 𨰉"},
    {16842768, 22, "查 察 茶 搽 槎 鍤 碴 臿 垞 秅 叉 岔 楂 蹅 嚓 査 詧 摖 檫 櫒 褨 䠡"},
    {16842769, 1, "啥"},
    {16842771, 16, "雜 咱 砸 偺 雥 磼 拶 喒 嘁 巀 㑑 雑 嶻 襍 韴 囐"},
    {16843008, 23, "牙 芽 涯 衙 蚜 押 枒 犽 齖 伢 堐 崖 睚 岈 颬 厓 崕 猚 谺 漄 豄 笌 㾏"},
    {16843015, 3, "娘 孃 嬢"},
    {16843020, 43, "夾 挾 頰 蛺 莢 浹 戛 郟 恝 袷 筴 裌 鋏 梜 跲 舺 唊 硈 扴 鞂 鞈 鵊 狎 俠 頡 祫 秸 脥 猰 硤 翜 鴶 圿 忦 侠 挟 埉 戞 㮖 稭 浃 䛟 餄"},
    {16843022, 55, "暇 峽 轄 霞 俠 狹 挾 匣 呷 遐 硤 狎 瑕 斜 黠 柙 祫 洽 舝 碬 騢 搳 烚 冾 笚 縖 珨 陜 磍 赮 魻 蕸 邪 恰 陝 愜 脥 鍜 侠 叚 峡 挟 炠 狭 衺 捾 㭱 陿 睱 縀 鎋 䕸 陕 翈 筪"},
    {16843264, 2, "娃 挖"},
    {16843275, 37, "華 滑 划 猾 譁 嘩 驊 鏵 豁 劃 崋 釫 螖 曄 姡 尳 搳 嬅 澕 燁 縎 骹 鷨 㕲 秳 㠏 㦊 磆 劐 曅 曗 䅿 㒯 爗 敌 蕐 䱻"},
    {16908288, 1, "哦"},
    {16908289, 91, "伯 博 柏 泊 勃 搏 渤 駁 白 薄 脖 帛 舶 箔 荸 蔔 膊 鈸 餑 鉑 欂 鵓 踣 浡 襮 踄 鎛 駮 僰 餺 髆 桲 謈 馞 胉 挬 猼 葧 鋍 懪 簙 礡 鑮 郣 鸔 糪 百 孛 佰 洎 悖 缽 菠 菔 貊 雹 爆 簿 犮 瓝 菝 軷 摶 濼 襏 叐 犻 妭 敀 洦 苩 栢 盋 湐 貃 愽 鉢 煿 艊 髉 侼 㫲 㶿 㼎 愂 牔 䭯 䗚 鮊 㩧 馛"},
    {16908290, 11, "婆 鄱 皤 櫇 番 幡 繁 碆 畨 嘙 蔢"},
    {16908291, 29, "模 磨 摩 膜 糢 魔 摹 謨 蘑 劘 嫫 藦 髍 無 摸 麼 嬤 饃 无 尛 麽 橅 嬷 謩 戂 䃺 饝 嚩 擵"},
    {16908292, 3, "佛 坲 仏"},
    {16908805, 23, "奪 鐸 多 掇 裰 剟 敪 椯 剫 敓 莌 毲 腏 鮵 襗 喥 檡 鵽 敚 敠 痥 凙 夛"},
    {16908806, 36, "駝 陀 馱 沱 佗 鴕 跎 橐 坨 紽 酡 砣 阤 鮀 岮 碢 鞁 驒 鼉 鉈 袉 飥 柁 堶 詑 沲 陁 砤 槖 䭾 駄 駞 踻 鼧 彵 鉇"},
    {16908807, 9, "挪 娜 儺 捼 梛 那 難 挼 郍"},
    {16908808, 28, "羅 螺 蘿 鑼 邏 籮 騾 囉 玀 儸 覶 摞 欏 蔂 鏍 鸁 剆 漯 縲 腡 蠃 逻 頱 覼 攞 驘 纝 饠"},
    {16908809, 22, "國 幗 虢 馘 摑 聝 膕 漍 慖 簂 蟈 嘓 槶 蔮 囯 国 囻 囶 圀 讗 䆐 腘"},
    {16908811, 5, "活 佸 鈥 萿 秮"},
    {16908815, 89, "卓 茁 濁 拙 濯 酌 灼 著 啄 鐲 擢 琢 諑 倬 斲 斮 梲 椓 焯 蝃 踔 鷟 彴 汋 斫 禚 篧 浞 棳 謶 錣 啅 罬 斀 蠗 圴 剢 灂 涿 絀 黜 繳 胐 婥 烼 腏 詘 畷 噣 嬥 穛 櫡 籗 鸐 蠿 叕 坧 妰 泎 炪 娺 棁 烵 着 聉 晫 琸 硺 窡 墌 擆 撯 誳 斵 仢 犳 丵 㧻 䖦 𢽴 斱 鉵 劅 䮓 鐯 𥇍 𤏸 𨧧 𢂚"},
    {16908819, 15, "昨 作 椊 筰 稓 葃 撮 岝 苲 捽 莋 繓 岞 秨 鈼"},
    {16908820, 12, "瘥 矬 鹺 痤 醝 嵯 蔖 蒫 虘 睉 嵖 嵳"},
    {16908821, 1, "索"},
    {16973824, 33, "額 訛 鵝 娥 哦 蛾 峨 莪 俄 囮 吪 硪 蚵 鋨 迗 珴 涐 皒 睋 魤 枙 峉 匎 峩 鈋 誐 頟 騀 鵞 譌 䄉 㘥 鰪"},
    {16973829, 9, "得 德 淂 恴 惪 悳 徳 𢔨 𢔶"},
    {16973831, 2, "哪 㖠"},
    {16973833, 56, "格 革 隔 閣 葛 骼 蛤 咯 膈 轕 嗝 搿 郃 韐 塥 觡 鬲 閤 挌 佮 輵 鮯 敆 茖 愅 獦 鎘 齃 各 緙 頜 噶 翮 佫 搹 滆 煂 蒚 鞈 鬳 鶷 呄 敋 詥 槅 諽 臈 鞟 鬴 韚 匌 㭘 臵 蛒 裓 鰪"},
    {16973834, 7, "咳 殼 欬 頦 壳 殻 揢"},
    {16973835, 90, "何 合 和 河 荷 核 盒 禾 褐 劾 闔 閤 曷 龢 涸 盍 覈 蓋 貉 閡 紇 滆 翮 蝎 嗑 齕 郃 餲 鶡 鉌 魺 鞨 菏 姀 毼 熆 蒚 篕 螛 礉 盉 廅 楁 澕 趷 匣 苛 害 蚵 渴 翕 赫 佮 峇 峆 敆 渮 袷 酠 圔 滒 鞂 樖 鞈 韐 鮯 鶷 齃 乢 咊 柇 狢 盇 釛 啝 㭱 渇 盖 惒 翖 萂 訸 葢 詥 貈 爀 鶮 哬 耠 䞦"},
    {16973839, 50, "折 哲 摺 懾 褶 謫 輒 摘 轍 慴 蜇 磔 乇 讋 晢 鮿 耴 悊 砓 謺 虴 鸅 讘 瓋 浙 翟 鏑 囁 焎 皙 裚 馲 蟄 扸 籷 埑 晣 烲 喆 棏 輙 銸 嚞 礋 䕪 讁 厇 歽 啠 襵"},
    {16973841, 17, "蛇 舌 甚 佘 什 揲 鉈 折 咶 輋 闍 譇 虵 釶 鍦 蛥 鉇"},
    {16973843, 42, "則 責 擇 澤 嘖 窄 舴 咋 幘 笮 賾 迮 齰 崱 萴 謮 蠌 賊 蠈 柞 磧 伬 岝 捑 樍 檡 簀 鍘 鸅 岅 択 沢 岞 飵 嫧 耫 鰂 鱡 戝 溭 皟 瞔"},
    {17039616, 16, "爺 耶 椰 琊 揶 擨 邪 斜 峫 捓 衺 㖿 釾 瑘 鋣 鎁"},
    {17039617, 12, "別 蹩 咇 徶 襒 蟞 彆 蛂 别 吡 㧙 莂"},
    {17039621, 60, "跌 蝶 諜 碟 疊 迭 牒 喋 瓞 耋 絰 咥 垤 堞 蜨 蹀 鰈 跕 昳 峌 挕 胅 苵 眣 聑 臷 詄 镻 艓 褋 惵 楪 嶀 凸 趺 褶 柣 媟 揲 渫 墆 嵽 屧 螲 鞢 呋 恎 耊 眰 䏲 屟 趃 叠 殜 㻡 曡 疉 戜 𣶏 褺"},
    {17039623, 1, "苶"},
    {17039624, 1, "咧"},
    {17039628, 110, "節 潔 傑 捷 竭 劫 截 結 杰 頡 詰 桀 睫 訐 拮 羯 櫛 桔 孑 癤 絜 偈 擷 倢 劼 婕 楬 碣 鮚 岊 榤 犵 袺 嵑 栨 騔 滐 鉣 鐑 衱 迼 崨 嵥 楶 趌 踕 擳 瀄 鍻 蠽 昅 揤 緁 巀 緳 舛 揭 渴 隔 泲 疌 狤 勍 栔 洯 荈 啑 梜 楖 萐 蛣 袷 蝍 裌 朅 箑 蜨 磔 鋏 幯 謋 鵖 卩 刧 刦 刼 偼 掲 渇 莭 媫 㨗 魝 蓵 誱 嶻 擮 櫭 礍 蠘 㔾 卪 厇 㛃 蜐 㘉 蠞 𠲵 𡩣 𦵴"},
    {17039629, 3, "茄 伽 癿"},
    {17039630, 53, "協 鞋 斜 脅 諧 邪 偕 頡 挾 絜 攜 擷 勰 纈 襭 脥 慀 劦 蝢 垥 拹 籺 奊 龤 愶 搚 瑎 熁 燲 頁 鮭 蠍 姭 嗋 緳 叶 协 旪 恊 挟 峫 脇 衺 翓 携 綊 綇 㩗 擕 㩦 鞵 膎 𦳃"},
    {17040140, 125, "決 覺 絕 爵 掘 嚼 訣 厥 獗 蹶 蕨 崛 攫 倔 炔 抉 噱 矍 觖 角 孓 玨 劂 橛 爝 譎 屩 觼 玦 腳 臄 蕝 躩 戄 桷 潏 鴃 貜 趹 鱖 傕 嵑 瘚 蠼 鐍 钁 玃 捔 芵 焆 鈌 蚗 谻 赽 僪 憰 蟨 彏 鱊 鷢 堀 殌 穱 袂 較 夬 吷 埆 矞 駃 噘 嶡 撅 璚 瞲 鵙 蹻 鶪 皭 灚 釂 亅 决 刔 妜 弡 挗 珏 疦 砄 欮 斍 脚 焳 絶 覚 逫 勪 瑴 踋 撧 熦 觮 鴂 橜 蟩 嚯 屫 蹷 爑 髉 鞽 欔 鱥 龣 孒 叏 氒 覐 㖸 爴 憠 鐝 矡 崫"},
    {17040141, 1, "瘸"},
    {17040142, 16, "學 穴 鷽 觷 踅 燢 澩 壆 尋 嶨 斈 斅 雤 乴 学 㶅"},
    {17104896, 18, "捱 皚 騃 敳 呆 挨 崖 癌 啀 堐 隑 獃 磑 厓 崕 凒 敱 嘊"},
    {17104897, 1, "白"},
    {17104898, 9, "排 牌 徘 俳 簰 棑 箄 輫 猅"},
    {17104899, 4, "埋 霾 薶 㜥"},
    {17104902, 29, "台 臺 抬 颱 苔 邰 跆 檯 薹 炱 駘 鮐 儓 嬯 籉 旲 秮 殆 笞 鈶 齝 坮 枱 炲 菭 擡 呞 䔶 㘆"},
    {17104903, 5, "孻 摨 腉 搱 熋"},
    {17104904, 22, "來 萊 徠 淶 騋 箂 崍 郲 錸 鯠 棶 庲 鶆 唻 賚 倈 婡 琜 逨 来 顂 麳"},
    {17104907, 11, "還 孩 骸 頦 咳 鞋 陔 豥 还 畡 鞵"},
    {17104911, 7, "宅 翟 擇 垞 挓 烢 択"},
    {17104912, 9, "柴 豺 儕 祡 喍 茈 砦 釮 犲"},
    {17104916, 7, "才 財 材 裁 纔 釮 溨"},
    {17105152, 7, "崖 睚 啀 娾 厓 崕 嘊"},
    {17105419, 18, "懷 淮 徊 槐 踝 佪 怀 褢 褱 櫰 瀤 獲 倠 蘹 获 懐 耲 㜳"},
    {17105424, 1, "膗"},
    {17170434, 19, "培 賠 陪 裴 邳 碚 毰 陫 荖 坏 斐 焙 蓓 坯 岯 踣 醅 阫 裵"},
    {17170435, 39, "沒 煤 眉 枚 梅 媒 莓 霉 玫 黴 酶 楣 湄 嵋 苺 禖 郿 堳 瑂 脢 鋂 呅 腜 塺 徾 攗 糜 没 脄 珻 湈 猸 睂 楳 葿 槑 䉠 鶥 𪑛"},
    {17170436, 5, "肥 淝 腓 萉 蜰"},
    {17170440, 26, "雷 累 纍 擂 嫘 鐳 羸 縲 罍 檑 畾 櫑 瓃 蠝 轠 壨 蔂 蘲 虆 㵢 靁 錑 攂 鑘 纝 鼺"},
    {17170449, 1, "誰"},
    {17170451, 2, "賊 戝"},
    {17170944, 60, "為 圍 微 危 唯 維 惟 違 韋 薇 巍 桅 闈 濰 帷 嵬 幃 囗 湋 溦 鄬 鍏 鮠 潿 洈 覹 醀 霺 瀢 濻 癓 欈 圩 葦 魏 佹 垝 姽 峗 峞 祪 噅 媯 撝 溈 蛫 觤 磑 蓶 蟡 犩 媁 爲 琟 嬀 潙 矀 䉠 陒 㵟"},
    {17170950, 14, "頹 穨 隤 魋 橔 僓 蹪 弚 墤 頺 頽 謉 㿗 尵"},
    {17170954, 25, "魁 睽 奎 揆 葵 逵 戣 夔 騤 暌 鄈 頯 聧 楏 櫆 湀 馗 楑 犪 躨 眭 鍷 晆 鍨 虁"},
    {17170955, 22, "回 迴 蛔 茴 蚘 洄 痐 恛 藱 徊 佪 烠 囘 冋 囬 㢠 廻 廽 逥 蛕 蜖 鮰"},
    {17170960, 24, "垂 鎚 槌 搥 椎 陲 錘 捶 棰 箠 圌 湷 倕 菙 綞 娷 腄 甀 厜 硾 諈 埀 桘 顀"},
    {17170961, 2, "誰 脽"},
    {17170962, 5, "蕤 緌 婑 甤 䬐"},
    {17170964, 2, "凗 慛"},
    {17170965, 11, "隨 隋 雟 綏 遂 雖 陏 虽 遀 随 瓍"},
    {17235968, 31, "熬 敖 遨 翱 嗷 螯 鰲 鼇 鏖 驁 廒 獒 璈 聱 鏊 滶 磝 隞 摮 蔜 簢 謷 爊 厫 嗸 煾 獓 翶 翺 嶅 鷔"},
    {17235969, 6, "雹 薄 窇 瓝 箔 瓟"},
    {17235970, 21, "袍 咆 刨 匏 庖 麃 炰 齙 鞄 炮 瓟 跑 鉋 袌 颮 狍 爮 軳 麅 礮 礟"},
    {17235971, 31, "毛 茅 矛 髦 錨 旄 蟊 芼 蝥 髳 媌 堥 罞 酕 嫹 鶜 枆 軞 渵 耄 犛 麾 乇 毠 毼 雺 氂 牦 嵍 緢 𨥨"},
    {17235973, 1, "捯"},
    {17235974, 30, "逃 桃 陶 萄 淘 濤 啕 洮 燾 檮 匋 咷 綯 鞀 醄 騊 錭 駣 祹 鋾 掏 滔 蜪 翿 迯 涛 裪 鞉 饀 鼗"},
    {17235975, 20, "撓 鐃 橈 呶 猱 怓 譊 嶩 獶 繷 獿 夒 蟯 驍 峱 硇 詉 憹 巎 巙"},
    {17235976, 22, "勞 牢 癆 澇 嘮 醪 浶 簩 蟧 嶗 犖 撈 僗 轑 顟 労 劳 窂 哰 磱 髝 憥"},
    {17235979, 31, "號 毫 豪 壕 濠 蠔 貉 嚎 鶴 蚵 嗥 籇 諕 勂 譹 麾 呺 蚝 檺 号 狢 椃 獆 貈 噑 獔 嘷 獋 儫 㩝 鸖"},
    {17235983, 2, "著 着"},
    {17235984, 17, "朝 潮 巢 嘲 晁 樔 轈 鄛 啁 剿 勦 漅 璅 巣 鼂 謿 䄻"},
    {17235985, 10, "杓 韶 芍 勺 玿 圴 牊 招 枃 柖"},
    {17235986, 9, "饒 蕘 嬈 橈 蟯 襓 撓 鐃 驍"},
    {17235987, 1, "鑿"},
    {17235988, 11, "曹 槽 嘈 漕 螬 艚 嶆 鰽 蓸 褿 鏪"},
    {17236224, 63, "搖 謠 堯 遙 姚 洮 瑤 僥 淆 餚 颻 傜 繇 嶢 徭 殽 猺 軺 爻 垚 崤 銚 珧 柼 猇 鰩 肴 媱 烑 窯 嗂 愮 榣 顤 陶 驍 郩 揄 筊 隃 嘵 墝 憢 膮 穘 倄 窑 䚻 摇 暚 瑶 餆 嶤 窰 㠙 鎐 䬙 蘨 鑃 揺 㑾 䔄 訤"},
    {17236226, 6, "瓢 嫖 淲 薸 闝 朴"},
    {17236227, 9, "苗 描 瞄 鱙 錨 媌 㑤 㚹 鶓"},
    {17236230, 28, "條 調 笤 佻 迢 蜩 髫 岧 苕 齠 鰷 鞗 芀 鎥 趒 祒 窕 絛 滌 篠 朷 条 岹 㨄 萔 樤 鋚 縧"},
    {17236232, 46, "聊 寮 遼 療 寥 撩 僚 燎 潦 嘹 繚 鐐 嫽 獠 鷯 屪 膋 漻 摎 豂 嵺 憀 嶚 敹 窷 膫 簝 镽 飂 飉 顟 佬 窌 翏 憭 蟟 醪 尞 嶛 熮 竂 蹘 髎 璙 廫 賿"},
    {17236236, 1, "嚼"},
    {17236237, 45, "橋 瞧 僑 喬 樵 翹 憔 蕎 礄 譙 簥 趫 燆 劁 嘺 憍 嫶 敿 招 蕉 荍 嶕 嶠 撟 潐 獢 犞 磽 穚 繑 蟜 譑 趭 毊 鱎 乔 嶣 癄 䎗 藮 鐈 顦 槗 㝯 䀉"},
    {17236238, 12, "學 洨 笅 郩 爻 肴 餚 斈 胶 誵 斅 学"},
    {17301504, 2, "吽 齵"},
    {17301506, 7, "掊 裒 抔 捊 抙 箁 錇"},
    {17301507, 18, "謀 眸 繆 牟 侔 蝥 鍪 蛑 麰 洠 鉾 鴾 譕 呣 哞 堥 鞪 劺"},
    {17301508, 6, "罘 芣 紑 剻 浮 鴀"},
    {17301510, 8, "頭 投 牏 酘 骰 緰 头 坄"},
    {17301511, 3, "羺 獳 譨"},
    {17301512, 31, "樓 嘍 婁 螻 髏 僂 蔞 廔 漊 耬 熡 謱 艛 鞻 鷜 瞜 摟 鏤 寠 慺 窶 貗 剅 娄 偻 楼 遱 瘻 軁 蝼 䝏"},
    {17301515, 21, "猴 侯 喉 篌 鍭 餱 瘊 銗 翭 鯸 葔 堠 鄇 緱 翵 矦 睺 糇 㤧 骺 帿"},
    {17301519, 4, "軸 妯 岫 舳"},
    {17301520, 40, "愁 仇 籌 綢 酬 稠 紬 躊 疇 惆 裯 儔 讎 幬 鯈 薵 嬦 椆 絒 菗 懤 詶 雔 燽 栦 圳 鯛 氿 犰 朹 釚 僽 鼽 皗 筹 酧 鮋 鮉 醻 讐"},
    {17301521, 1, "熟"},
    {17301522, 25, "柔 揉 韖 蹂 輮 楺 禸 葇 鍒 鞣 鶔 媃 蝚 鰇 厹 煣 糅 㕤 叴 渘 瑈 腬 䐓 瓇 脜"},
    {17301760, 58, "由 游 遊 尤 油 郵 猶 猷 鈾 輶 疣 蚰 蕕 斿 蝣 訧 逌 楢 魷 优 沋 浟 偤 秞 莤 酋 鯈 冘 囮 怞 苬 紌 崷 揄 煪 遒 緧 繇 蠤 㕱 犹 肬 怣 峳 逎 逰 滺 駀 鮋 鰌 櫾 邮 䣭 輏 醔 鞧 㘥 邎"},
    {17301767, 2, "牛 汼"},
    {17301768, 53, "劉 流 留 硫 琉 榴 瀏 瘤 遛 旒 騮 鏐 飀 鶹 懰 鎏 鎦 媹 嬼 嵧 藰 裗 麍 鷎 蓅 鰡 巰 餾 塯 摎 橀 蟉 刘 沠 畄 畱 瑬 瑠 蒥 磂 駠 橊 璢 疁 癅 駵 嚠 鐂 驑 旈 綂 𩗩 䶉"},
    {17301773, 66, "求 球 囚 仇 酋 裘 遒 毬 泅 鰽 逑 俅 厹 璆 絿 艽 虯 蝤 觩 賕 盚 銶 頄 鼽 訄 犰 朹 梂 釚 煪 苬 紌 脙 莍 崷 僋 蛷 鮂 鯄 殏 猷 觓 唒 捄 偤 揂 趥 輶 㕤 叴 扏 汓 肍 虬 訅 浗 逎 渞 湭 皳 鰌 玐 䊵 㞗 輏 醔"},
    {17367040, 3, "雸 玵 啽"},
    {17367042, 22, "盤 磐 蟠 般 胖 槃 蹣 磻 踫 鞶 幋 縏 柈 瀊 蒰 媻 搫 跘 弁 樊 顢 鎜"},
    {17367043, 29, "蠻 饅 瞞 蹣 漫 顢 謾 鰻 璊 悗 慲 槾 鬘 鬗 埋 蔓 姏 樠 鞔 蛮 摱 澷 蟎 䕕 䅼 𨃟 㒼 𥲑 𧜞"},
    {17367044, 46, "凡 煩 繁 帆 蕃 礬 藩 樊 蘩 璠 籵 墦 燔 膰 蠜 蹯 颿 笲 釩 瀿 鐇 勫 橎 薠 羳 鷭 杋 柉 瀪 氾 梵 幡 芃 袢 旛 凢 凣 㠶 忛 匥 舤 舧 棥 襎 䑺 䪤"},
    {17367046, 42, "談 彈 痰 潭 譚 檀 壇 曇 罈 覃 郯 錟 餤 鐔 倓 醰 貚 婒 憛 藫 橝 鷤 澹 惔 嘾 曋 燂 蕁 瞫 邅 皽 蟫 饘 鷣 弹 聅 弾 墵 墰 醈 壜 罎"},
    {17367047, 17, "南 男 難 喃 楠 柟 暔 諵 奻 萳 莮 抩 蝻 攮 枏 畘 侽"},
    {17367048, 37, "蘭 籃 藍 欄 攔 瀾 襤 婪 嵐 闌 鑭 襴 讕 斕 籣 欗 糷 灆 灡 譋 躝 瑯 欖 惏 灠 啉 葻 厱 儖 懢 璼 繿 蘫 囒 襽 韊 㜮"},
    {17367051, 31, "寒 含 函 涵 韓 邯 汗 邗 榦 琀 梒 鋡 焓 幹 箴 肣 虷 唅 菡 蜬 谽 顄 汵 凾 圅 娢 㖤 崡 晗 㮀 𢔈"},
    {17367056, 48, "纏 蟬 禪 饞 讒 潺 蟾 巉 嬋 單 澶 廛 孱 劖 毚 瀍 瀺 躔 鑱 磛 艬 僝 棎 湹 鋋 煘 獑 繵 酁 嶄 厘 儃 樼 虥 蟺 轏 欃 单 単 婵 嶃 潹 緾 蟮 鄽 鏩 纒 誗"},
    {17367058, 15, "然 燃 髯 蛅 蚺 袡 呥 舑 肰 蚦 衻 髥 嘫 䔳 繎"},
    {17367059, 5, "咱 偺 糌 喒 㑑"},
    {17367060, 13, "殘 蠶 慚 嬠 帴 蛬 魙 残 蝅 慙 嬱 㨻 蠺"},
    {17367296, 87, "研 言 顏 嚴 延 沿 炎 癌 鹽 岩 筵 簷 閻 妍 蜒 檐 埏 喦 揅 碞 綖 郔 巖 孍 楌 礹 閰 娮 鈆 狿 虤 顃 壛 麙 壧 莚 嵒 焰 鉛 釅 厂 岍 汧 宕 阽 狺 唌 砦 豜 趼 閆 欻 琰 鈃 裧 誾 鳽 燅 燚 錟 鋋 盬 玁 炏 姸 娫 琂 硏 嵓 塩 詽 豣 膁 銒 蔅 歘 厳 顔 巌 櫩 巗 麣 厃 开 厈 昖 訮"},
    {17367298, 14, "便 胼 駢 諞 蹁 楩 骿 褊 楄 跰 緶 腁 騈 賆"},
    {17367299, 15, "棉 綿 眠 媔 婂 蝒 櫋 矊 矏 宀 緜 嬵 檰 芇 臱"},
    {17367302, 22, "田 甜 填 恬 闐 畋 窴 沺 盷 湉 菾 磌 佃 滇 鈿 屇 搷 鷏 胋 甛 塡 璳"},
    {17367303, 12, "年 黏 粘 姩 哖 拈 撚 溓 鯰 秊 秥 䴴"},
    {17367304, 57, "連 聯 憐 廉 蓮 漣 簾 鐮 鰱 奩 璉 帘 褳 嗹 鎌 鬑 溓 蠊 槤 縺 謰 覝 磏 鏀 濂 翴 薕 蹥 譧 奱 嬚 零 殮 瞼 怜 轋 蘞 亷 匲 慩 熑 劆 匳 嫾 聨 聫 濓 聮 螊 霗 燫 櫣 蘝 䥥 籢 䙺 臁"},
    {17367309, 55, "前 錢 乾 潛 黔 鉗 虔 箝 鈐 掮 媊 揵 燂 拑 灊 黚 忴 扲 岒 漧 葥 鳹 騚 鰬 仱 姏 蚙 軡 榩 柑 湔 僭 赶 揃 雂 瑐 墘 嶜 糋 羬 熸 鬋 乹 歬 偂 亁 碊 銭 撍 潜 橬 濳 鵭 䐶 䕭"},
    {17367310, 69, "賢 閒 嫌 咸 鹹 弦 銜 絃 嫻 嫺 涎 啣 舷 閑 癇 諴 蚿 憪 鷴 娹 葴 胘 蛝 羬 燅 礥 鷳 唌 玄 炫 眩 鉉 僩 箴 伭 妶 泫 昡 玹 惤 袨 嵅 嗛 瑊 撊 澖 誸 襉 顑 鰔 麙 痃 婱 衘 詽 僴 甉 㯗 㵪 輱 醎 癎 簚 藖 贒 鷼 臤 訮 稴"},
    {17367552, 24, "完 玩 頑 丸 汍 紈 芄 烷 婠 岏 抏 梡 刓 妧 肒 垸 捖 睆 筦 羦 鋎 貦 鯶 鰀"},
    {17367558, 15, "團 摶 糰 漙 剸 慱 鏄 鷻 槫 湍 剬 篿 鷒 団 檲"},
    {17367560, 19, "巒 鑾 鸞 孿 灤 臠 圞 欒 曫 羉 癵 孌 峦 栾 脔 滦 銮 圝 灓"},
    {17367563, 48, "還 環 桓 圜 繯 鬟 鍰 鐶 寰 闤 梡 洹 瓛 貆 澴 荁 萑 肒 捖 羦 懁 豲 嬛 狟 雈 垣 峘 垸 烜 楥 儇 噮 彋 擐 獧 雚 攌 翾 蠉 鱞 环 还 絙 萈 寏 䦡 糫 𢕼"},
    {17367568, 14, "傳 船 遄 椽 歂 諯 暷 輲 猭 椯 縳 餯 舩 篅"},
    {17367570, 3, "堧 壖 撋"},
    {17367572, 7, "攢 巑 劗 欑 攅 櫕 穳"},
    {17367808, 78, "原 元 員 園 圓 緣 源 援 媛 袁 猿 垣 沅 轅 爰 圜 黿 嫄 櫞 芫 湲 騵 笎 羱 蝯 邧 蝝 妧 萲 螈 蚖 杬 榞 溒 媴 猭 獂 榬 蒝 鎱 邍 鶢 京 洹 苑 晅 喙 隕 姮 峘 狟 掾 椽 瑗 貆 禒 禐 瞏 縓 謜 豲 円 园 亰 貟 圎 猨 塬 睘 磒 縁 䲮 薗 鶰 厡 㟲 暅 魭"},
    {17367816, 7, "攣 孿 癵 孪 挛 虊 癴"},
    {17367821, 51, "全 權 泉 詮 拳 銓 痊 顴 蜷 筌 卷 荃 鬈 牷 輇 佺 犬 踡 醛 恮 婘 犈 觠 駩 巏 齤 蠸 姾 瑔 跧 縓 灥 豢 烇 牶 惓 絟 蟤 鐉 虇 㒰 巻 洤 硂 湶 搼 葲 権 騡 孉 鰁"},
    {17367822, 32, "玄 旋 懸 漩 璇 璿 伭 妶 琁 玹 嫙 誸 還 縣 蜁 弦 絃 舷 盷 胘 娹 惤 蚿 蔙 縼 还 婱 暶 䁢 檈 䲂 䴉"},
    {17432578, 5, "盆 湓 葐 瓫 㖹"},
    {17432579, 14, "門 們 捫 樠 鍆 穈 菛 亹 虋 璊 斖 玧 閅 㻊"},
    {17432580, 34, "墳 焚 汾 枌 棼 蚡 豶 鼖 幩 濆 轒 鼢 妢 炃 羒 蒶 黂 弅 蕡 鐼 秎 梤 僨 鳻 橨 羵 坟 坆 蚠 馚 燌 燓 隫 馩"},
    {17432585, 1, "哏"},
    {17432587, 5, "痕 拫 鞎 含 噙"},
    {17432592, 49, "陳 沉 晨 臣 塵 辰 娠 忱 沈 宸 諶 煁 茞 蔯 樄 莐 愖 鈂 螴 麎 鷐 伔 敶 脤 蜃 橙 岒 抌 侲 挋 桭 梣 臦 蜄 誫 鋠 燛 尘 牨 迧 栕 莀 訦 軙 瘎 曟 敐 薼 霃"},
    {17432593, 2, "神 甚"},
    {17432594, 19, "人 任 仁 壬 紝 儿 芢 銋 妊 軠 鵀 朲 忎 姙 絍 鈓 忈 秂 魜"},
    {17432596, 8, "岑 涔 梣 笒 埁 侺 汵 筨"},
    {17432832, 44, "銀 吟 寅 淫 鄞 齦 霪 垠 夤 狺 嚚 崟 誾 蟫 婬 冘 苂 釿 圁 烎 凐 荶 殥 蔩 檭 鷣 鏔 言 粌 齗 犾 垦 泿 㖗 珢 崯 訡 滛 碒 噖 璌 峾 訔 鈝"},
    {17432834, 16, "貧 瀕 頻 顰 嬪 嚬 矉 濱 蘋 玭 娦 浜 琕 滨 濵 薲"},
    {17432835, 35, "民 岷 玟 緡 痻 苠 忞 旻 鈱 旼 錉 罠 閺 怋 崏 暋 泯 閔 閩 呡 睯 忟 姄 珉 盿 砇 捪 琘 瑉 碈 緍 䪸 賯 鍲 冺"},
    {17432839, 5, "您 恁 忹 䋻 囜"},
    {17432840, 52, "林 臨 鄰 淋 鱗 麟 霖 磷 琳 遴 嶙 燐 璘 粼 轔 潾 痳 疄 瞵 惏 暽 罧 驎 碄 箖 甐 繗 僯 翷 蹸 壣 鏻 藺 亃 榃 吅 玪 崊 晽 粦 隣 麐 瀶 躙 轥 厸 杮 枾 㔂 獜 斴 魿"},
    {17432845, 43, "勤 琴 秦 禽 擒 芹 檎 覃 噙 懃 芩 螓 鈙 嫀 斳 耹 靲 澿 庈 肣 蚙 軡 雂 鈐 黔 覲 衾 慬 瑧 蓁 嶜 縥 轃 珡 捦 䓅 琹 菦 嗪 懄 㩒 䥅 蠄"},
    {17432846, 6, "尋 鄩 杺 攳 襑 鬵"},
    {17433088, 36, "文 聞 紋 蚊 玟 雯 閿 炆 芠 琝 閺 闅 鼤 駇 魰 鳼 抆 汶 畋 妏 顐 彣 珉 砇 蚉 渂 珳 琘 瑉 碈 馼 鴍 螡 鴖 蟁 瘒"},
    {17433094, 25, "屯 囤 豚 飩 臀 軘 魨 忳 芚 吨 拵 肫 坉 庉 杶 炖 烼 棆 遯 豘 踲 霕 櫄 䐁 臋"},
    {17433095, 1, "黁"},
    {17433096, 23, "倫 論 輪 淪 崙 侖 綸 掄 圇 碖 錀 惀 陯 菕 踚 棆 蜦 埨 婨 崘 㷍 腀 鯩"},
    {17433099, 16, "魂 渾 餛 混 琿 楎 餫 棞 顐 鼲 繉 轋 忶 俒 堚 䮝"},
    {17433104, 20, "純 唇 醇 淳 蓴 鶉 漘 錞 韕 脣 憌 鯙 屯 焞 浱 陙 湻 滣 蒓 醕"},
    {17433106, 1, "犉"},
    {17433108, 7, "存 袸 蹲 拵 洊 栫 珔"},
    {17433344, 37, "雲 云 勻 昀 耘 芸 紜 熅 筠 溳 澐 畇 篔 沄 熉 鋆 蕓 妘 伝 縜 荺 鄖 枃 眃 員 呁 盷 笉 匀 囩 秐 貟 愪 煴 蒷 橒 耺"},
    {17433357, 10, "群 裙 宭 峮 麇 帬 羣 裠 麕 麏"},
    {17433358, 45, "尋 巡 詢 循 旬 馴 潯 珣 蟳 洵 荀 徇 恂 峋 栒 燖 璿 紃 郇 鱘 槆 撏 枔 咰 璕 橁 蕁 噚 殉 攳 燅 燂 襑 灥 伨 廵 杊 狥 毥 偱 樳 駨 鱏 畃 㵌"},
    {17498112, 5, "昂 卬 䒢 昻 岇"},
    {17498114, 18, "旁 龐 膀 螃 徬 蒡 厖 尨 雱 逄 庬 篣 舽 彷 傍 嫎 龎 髈"},
    {17498115, 29, "忙 芒 茫 盲 氓 尨 硭 邙 哤 奀 杗 盳 鋩 娏 牻 痝 蛖 駹 蘉 笀 肓 汒 厖 庬 恾 浝 朚 吂 釯"},
    {17498116, 8, "房 防 妨 肪 坊 魴 埅 鰟"},
    {17498118, 46, "堂 糖 唐 塘 膛 螳 棠 醣 搪 鏜 溏 螗 瑭 赯 榶 樘 漟 煻 鎕 闛 橖 蓎 磄 踼 薚 鶶 瞠 嵣 餳 坣 傏 啺 㭻 㑽 㜍 鄌 憆 禟 糃 糛 餹 饄 摚 膅 隚 篖"},
    {17498119, 4, "囊 搑 欜 乪"},
    {17498120, 30, "郎 狼 廊 螂 瑯 琅 榔 稂 莨 蜋 桹 筤 鋃 俍 崀 欴 浪 羹 硠 踉 駺 哴 郞 嫏 蓈 躴 羮 勆 艆 樃"},
    {17498122, 1, "扛"},
    {17498123, 20, "行 航 杭 吭 頏 桁 迒 苀 肮 蚢 斻 貥 雽 魧 沆 胻 絎 筕 䘕 𨁈"},
    {17498128, 23, "長 常 場 嘗 裳 償 腸 嫦 鱨 徜 嚐 萇 鋿 粻 仧 甞 塲 瑺 膓 鏛 兏 镸 瓺"},
    {17498130, 10, "攘 禳 穰 勷 瀼 瓤 儴 獽 蘘 鬤"},
    {17498132, 4, "藏 鑶 蔵 匨"},
    {17498368, 41, "楊 陽 揚 洋 羊 佯 烊 瘍 鍚 徉 颺 暘 煬 垟 昜 禓 蛘 瑒 珜 鐊 崵 鸉 眻 婸 吀 阦 阳 氜 羏 哶 样 敭 輰 霷 𦍌 𦍋 𢒑 鰑 劷 𦭵 𤋁"},
    {17498375, 4, "娘 孃 釀 嬢"},
    {17498376, 23, "良 梁 量 糧 涼 粱 樑 椋 綡 輬 踉 駺 亮 螂 諒 俍 惊 莨 蜋 凉 粮 槺 墚"},
    {17498381, 23, "強 牆 薔 戕 墻 嬙 檣 爿 漒 蘠 廧 彊 繈 嵹 膙 糨 襁 謽 强 蔃 糡 繦 艢"},
    {17498382, 15, "詳 祥 降 翔 庠 羊 吀 夅 佭 哶 栙 絴 跭 鴹 䜶"},
    {17498624, 8, "王 亡 忘 莣 亾 兦 蚟 彺"},
    {17498634, 8, "狂 誑 鵟 狅 俇 仼 抂 軖"},
    {17498635, 45, "黃 徨 惶 簧 璜 磺 蝗 煌 皇 凰 湟 遑 隍 潢 篁 喤 艎 鍠 熿 韹 鰉 堭 蟥 偟 穔 鷬 媓 騜 崲 葟 餭 撗 獚 趪 揘 楻 彉 諻 黄 瑝 墴 彍 鐄 鱑 癀"},
    {17498640, 8, "床 幢 撞 橦 疒 牀 漴 噇"},
    {17563649, 2, "甭 甮"},
    {17563650, 41, "朋 彭 澎 蓬 膨 硼 棚 鵬 篷 蟛 芃 淜 鬅 痭 錋 倗 輣 傰 韸 髼 憉 樥 鑝 逢 堋 磞 竼 浲 塜 稝 塳 漨 槰 蟚 韼 騯 纄 蘕 鬔 㦀 䮾"},
    {17563651, 44, "蒙 盟 萌 矇 朦 濛 檬 懵 幪 甍 瞢 艨 虻 曚 甿 礞 氋 雺 莔 儚 蕄 鄳 鄸 饛 鸏 氓 尨 罞 嫇 懞 霿 冡 䀄 蝱 橗 懜 㩚 鯍 靀 顭 溕 𡁏 獴 矒"},
    {17563652, 15, "逢 縫 馮 夆 渢 堸 艂 摓 捀 浲 莑 綘 葻 漨 㵯"},
    {17563654, 16, "疼 騰 藤 籐 謄 滕 螣 縢 邆 漛 駦 儯 籘 驣 幐 鰧"},
    {17563655, 6, "能 薴 儜 膿 嬣 癑"},
    {17563656, 13, "稜 崚 棱 薐 蔆 倰 楞 碐 祾 蓤 䔖 掕 塄"},
    {17563659, 24, "橫 恆 衡 恒 珩 蘅 桁 鴴 姮 鑅 楻 誙 諻 揘 佷 亨 韹 堩 揯 彉 緪 絚 横 彍"},
    {17563664, 58, "成 程 承 盛 乘 誠 呈 城 懲 澄 橙 丞 澂 棖 酲 宬 晟 裎 郕 埕 掁 湞 珵 荿 騬 脀 脭 揨 峸 鋮 塍 崢 傖 氶 巹 浧 崝 臹 溗 撜 卺 乗 娍 峥 洆 挰 晠 珹 窚 堘 惩 椉 筬 絾 塖 憕 瀓 畻"},
    {17563665, 7, "繩 澠 憴 譝 鱦 溗 縄"},
    {17563666, 7, "仍 礽 陾 扔 艿 㺱 辸"},
    {17563668, 7, "曾 層 嶒 鄫 碀 驓 竲"},
    {17563904, 46, "營 迎 蠅 螢 贏 盈 瑩 縈 瀛 滎 嬴 塋 熒 楹 瀅 瀠 籯 瀯 謍 攍 巆 廮 藀 犖 嫈 禜 罃 褮 濴 覮 醟 鎣 㕲 盁 僌 萾 蝇 䋼 濙 濚 㶈 櫿 籝 耺 㜲 営"},
    {17563906, 49, "平 瓶 憑 評 屏 蘋 萍 坪 枰 泙 帡 洴 缾 軿 俜 玶 甹 苹 郱 呯 竮 艵 蛢 馮 荓 蓱 炾 抨 秤 摒 栟 銔 鵧 凭 胓 㺸 㻂 屛 帲 蚲 幈 甁 凴 箳 輧 鮃 簈 薲 慿"},
    {17563907, 27, "明 名 鳴 銘 螟 冥 瞑 暝 茗 酩 溟 蓂 鄍 洺 榠 嫇 覭 詺 熐 萌 盟 眳 佲 朙 眀 䫤 猽"},
    {17563910, 24, "停 庭 廷 亭 蜓 霆 婷 渟 莛 朾 筳 蝏 聤 葶 鼮 楟 榳 閮 嵉 綎 邒 㨩 葕 諪"},
    {17563911, 20, "寧 凝 獰 嚀 檸 甯 擰 鸋 鑏 寍 聹 嬣 冰 薴 仌 氷 寕 寜 寗 鬡"},
    {17563912, 87, "零 玲 靈 鈴 齡 陵 凌 菱 聆 羚 苓 伶 綾 淩 翎 鴒 囹 蛉 瓴 泠 舲 酃 軨 錂 櫺 柃 欞 睖 砱 詅 輘 霝 鯪 醽 岭 昤 澪 呬 坽 夌 姈 狑 皊 呤 琌 笭 裬 蘦 怜 婈 駖 蕶 爧 堎 令 稷 蔆 磷 仱 彾 耹 灵 岺 朎 秢 竛 紷 跉 祾 蓤 䔖 霊 霗 燯 霛 䕘 麢 龗 刢 掕 衑 閝 魿 孁 䴇 䖅 鹷"},
    {17563917, 20, "情 晴 擎 傾 檠 勍 殑 樈 殌 請 鯨 狅 葝 擏 黥 啨 暒 㯳 夝 甠"},
    {17563918, 24, "行 形 型 刑 邢 陘 硎 鉶 餳 侀 烆 洐 胻 鋞 濴 娙 絎 鈃 雃 滎 坓 郉 銒 糃"},
    {17564166, 57, "同 童 銅 桐 潼 瞳 砼 彤 佟 僮 峒 侗 艟 曈 膧 穜 罿 硐 橦 氃 獞 茼 烔 浵 鉖 餇 仝 酮 迵 粡 絧 朣 犝 蕫 鮦 鼨 爞 哃 詷 洞 胴 筒 炵 戙 筩 赨 庝 峝 晍 蚒 秱 勭 燑 眮 硧 鉵 㼿"},
    {17564167, 18, "農 濃 膿 儂 噥 穠 襛 醲 齈 鬞 擃 辳 憹 檂 癑 禯 欁 蕽"},
    {17564168, 45, "龍 隆 籠 嚨 聾 瓏 朧 窿 瀧 癃 櫳 礱 曨 巃 矓 蘢 躘 豅 鏧 鑨 靇 蠪 襱 鸗 儱 龒 蠬 壟 攏 屸 竜 湰 滝 嶐 漋 篭 壠 巄 㰍 爖 霳 礲 龓 驡 㡣"},
    {17564171, 57, "紅 洪 宏 鴻 虹 弘 泓 訌 鋐 閎 黌 竑 紘 翃 浤 鞃 灴 葒 耾 仜 汯 竤 鈜 霟 妅 玒 谹 渱 舼 触 谼 篊 彋 瓨 苰 肱 嶸 吰 羾 魟 霐 鍙 㢬 宖 垬 娂 峵 紭 粠 嵤 綋 翝 葓 潂 䉺 硡 𨌆"},
    {17564176, 17, "重 崇 虫 蟲 种 翀 蝩 隀 茧 痋 蠱 嫞 爞 烛 崈 漴 蛊"},
    {17564178, 50, "容 榮 融 溶 絨 熔 戎 蓉 鎔 茸 榕 羢 嶸 瑢 肜 毧 狨 瀜 茙 烿 蠑 爃 媶 榵 褣 駥 髶 鰫 鷛 頌 娀 傛 軵 嵱 葺 濴 鑅 荣 峵 䇯 搑 穁 縙 螎 嬫 濚 曧 鱅 𪃾 栄"},
    {17564180, 27, "從 叢 淙 琮 悰 潀 漎 賨 錝 婃 孮 徖 慒 摐 蓯 藂 欉 从 従 碂 誴 賩 樷 灇 爜 苁 潨"},
    {17564181, 1, "悚"},
    {17564416, 19, "傭 喁 顒 傛 槦 嫆 嵱 嫞 庸 慵 鄘 墉 滽 鏞 鷛 搈 鱅 㣑 牅"},
    {17564429, 35, "窮 瓊 芎 穹 跫 蛩 惸 邛 璚 藭 瞏 煢 筇 輁 藑 桏 赹 笻 橩 蒆 觼 舼 敻 嬛 矎 讂 卭 宆 棾 焭 琼 䤝 睘 儝 竆"},
    {17564430, 4, "雄 熊 赨 熋"},
    {17629184, 28, "兒 而 洏 耏 胹 輀 侕 栭 陑 鮞 檽 聏 荋 唲 鴯 峏 恧 婼 臑 鬩 児 㖇 袻 腝 䦧 髵 隭 轜"},
    {33554432, 1, "ˇ"},
    {33554447, 51, "只 指 紙 止 旨 址 徵 祇 趾 祉 咫 枳 酯 恉 沚 阯 芷 黹 軹 疻 晊 厎 坁 藢 栺 淽 滍 抵 砥 詣 忯 扺 汦 秖 蚚 軝 鮨 夂 帋 抧 拞 杫 砋 䇛 祬 茝 訨 筫 徴 襧 劧"},
    {33554448, 31, "尺 齒 恥 呎 侈 褫 欼 搋 蚇 恀 拸 姼 傂 誃 鉹 伬 咫 豉 奓 胣 趍 擨 肔 垑 䊼 耻 歯 誀 裭 㶴 袳"},
    {33554449, 13, "使 始 史 駛 矢 屎 豕 弛 乨 纚 笶 兘 鉂"},
    {33554451, 26, "子 仔 紫 梓 籽 滓 耔 訾 笫 秭 胏 茈 吇 杍 芓 呰 矷 釨 訿 姊 㺭 姉 秄 虸 啙 榟"},
    {33554452, 6, "此 佌 泚 玼 跐 皉"},
    {33554453, 1, "死"},
    {33554688, 55, "以 已 乙 倚 椅 矣 蟻 尾 艤 迤 苡 偯 扆 旖 螘 扡 酏 鳦 釔 齮 顗 檥 鉯 迆 胣 礒 掜 陭 崺 晲 轙 蛾 佁 衪 娭 猗 銥 踦 嶬 燨 肔 庡 苢 迱 笖 旑 鈘 裿 輢 嬟 䧧 䭲 攺 逘 鎄"},
    {33554689, 31, "比 筆 彼 鄙 匕 沘 秕 屄 蚍 妣 疕 潷 柀 朼 貏 仳 毗 媲 壁 貔 夶 佊 㚰 笔 粃 舭 啚 袐 豼 魮 滗"},
    {33554690, 19, "否 匹 疋 痞 嚭 苤 仳 庀 圮 崥 諀 毗 劈 癖 苉 脴 嶏 噽 䫌"},
    {33554691, 27, "米 靡 弭 敉 眯 銤 渳 葞 蔝 濔 灖 羋 彌 糜 麋 瀰 蝆 縻 獼 蘼 侎 弥 洣 眫 孊 猕 㝥"},
    {33554693, 27, "底 抵 邸 詆 牴 砥 氐 坻 柢 弤 觝 呧 阺 聜 菧 軧 扺 厎 汦 秖 蚔 蚳 貾 坘 拞 茋 掋"},
    {33554694, 7, "體 体 綈 挮 躰 骵 軆"},
    {33554695, 32, "你 妳 擬 禰 儗 旎 昵 坭 柅 薿 檷 抳 苨 馜 隬 譺 尼 泥 狔 掜 薾 鑈 伲 伱 拟 祢 埿 孴 聻 䛏 鉨 㘈"},
    {33554696, 29, "李 里 裡 理 禮 裏 哩 浬 鯉 娌 俚 澧 邐 醴 蠡 鱧 鋰 粴 豊 峛 欚 履 悝 捚 褁 礼 峢 蟸 峲"},
    {33554700, 34, "幾 給 己 擠 脊 戟 濟 几 麂 庋 蟣 剞 掎 泲 踦 魕 丮 穖 妀 撠 紀 机 邔 芑 枳 鳧 橶 鞿 犱 鳬 済 㦸 嵴 魢"},
    {33554701, 40, "起 啟 豈 乞 綺 杞 稽 綮 屺 棨 敧 芑 婍 邔 芞 呇 企 覬 刉 忔 犵 盵 釳 隑 暟 榿 麧 颽 启 玘 盀 唘 啔 啓 䄎 裿 諬 晵 袳 闙"},
    {33554702, 42, "喜 洗 徙 璽 鰓 屣 蓰 囍 枲 蟢 縰 蹝 匚 狶 諰 簁 葸 漇 敼 僖 嬉 禧 譆 洒 歖 礂 褷 鍌 饎 匸 杫 愢 葈 憘 憙 壐 簛 糦 籭 躧 玺 鉩"},
    {33554944, 40, "五 午 武 舞 侮 伍 鵡 憮 嫵 潕 廡 仵 忤 嘸 碔 甒 摀 啎 捂 嵨 玝 倵 橆 躌 撫 汻 迕 埡 牾 幠 膴 旿 娬 捬 珷 遌 瑦 儛 抚 㵲"},
    {33554945, 9, "補 捕 埔 哺 卜 鳪 獛 訃 轐"},
    {33554946, 17, "普 浦 埔 譜 圃 溥 烳 氆 鐠 潽 誧 哺 樸 賻 暜 諩 檏"},
    {33554947, 18, "母 畝 牡 姆 拇 牳 鉧 姥 峔 砪 踇 畂 畆 胟 娒 畞 畮 𧿹"},
    {33554948, 47, "府 腐 撫 輔 甫 斧 俯 釜 脯 腑 莆 滏 嘸 拊 黼 簠 頫 郙 弣 鯆 暊 冹 蜅 蚥 軵 父 阜 哺 腹 嫵 膚 俛 逋 幠 黻 㕶 肤 俌 凂 娬 捬 焤 盙 秿 跔 抚 呒"},
    {33554949, 15, "賭 堵 睹 篤 肚 錖 裻 帾 蠹 媎 覿 琽 覩 螙 蠧"},
    {33554950, 6, "土 吐 釷 芏 唋 圡"},
    {33554951, 7, "努 弩 砮 駑 夯 孥 伮"},
    {33554952, 16, "魯 虜 擄 滷 鹵 櫓 艣 磠 鐪 蓾 擼 塷 樐 瀂 艪 鑥"},
    {33554953, 59, "股 古 鼓 骨 谷 穀 賈 凸 蠱 汩 牯 滑 罟 嘏 詁 轂 鵠 瞽 臌 盬 羖 蛌 扢 鈷 杚 淈 狜 唃 尳 榖 蓇 濲 瀔 愲 縎 薣 估 骰 抇 岵 祜 焀 跍 榾 谽 縠 螖 鮕 瀫 顝 鶻 鼜 淿 鼔 皷 糓 餶 蛊 䶜"},
    {33554954, 3, "苦 楛 瘔"},
    {33554955, 16, "虎 琥 滸 唬 許 汻 虍 虓 箎 覤 諕 篪 竾 筂 萀 虝"},
    {33554959, 34, "主 屬 煮 囑 貯 渚 矚 著 麈 拄 瘃 砫 陼 孎 壴 罜 欘 泞 眝 枓 鬻 灟 蠾 丶 宔 俼 属 詝 煑 嘱 濐 瞩 𠰍 𪐴"},
    {33554960, 19, "處 楚 儲 礎 杵 褚 楮 濋 檚 貯 泞 儊 处 椘 禇 憷 齼 柠 齭"},
    {33554961, 26, "數 鼠 屬 暑 署 薯 蜀 黍 癙 潻 藷 钃 婌 襩 糬 曙 襡 孎 灟 鸀 蠾 属 数 暏 㻿 薥"},
    {33554962, 10, "乳 汝 辱 擩 女 侞 入 儒 肗 㨎"},
    {33554963, 22, "組 祖 阻 俎 詛 珇 靻 咀 沮 狙 砠 齟 岨 抯 柤 苴 袓 菹 跙 麆 爼 䔃"},
    {33555200, 56, "與 語 雨 予 羽 嶼 宇 禹 庾 齬 噢 圄 圉 窳 傴 俁 敔 噳 楀 瑀 与 萭 貐 偊 祤 斞 鄅 寙 篽 蘌 斔 螤 齲 珝 欳 堣 翗 瘐 趐 嫮 蝺 頨 踽 翵 璵 藇 麌 鱮 俣 㝢 萮 魣 懙 伛 匬 㦛"},
    {33555207, 3, "女 籹 釹"},
    {33555208, 37, "呂 旅 履 侶 鋁 屢 縷 褸 婁 膂 漊 穭 梠 郘 挔 絽 儢 祣 莒 閭 櫚 鏤 捋 筥 寠 貗 吕 寽 侣 娄 捛 屡 鋶 褛 㜢 膐 稆"},
    {33555212, 30, "舉 矩 咀 莒 沮 齟 櫸 筥 踽 蒟 椇 柜 竘 袓 跙 蝺 佝 狙 枸 砠 苴 菹 趄 萭 籧 弆 挙 榘 聥 擧"},
    {33555213, 11, "取 曲 娶 齲 浀 紶 娵 跔 竬 㾀 詓"},
    {33555214, 24, "許 栩 煦 咻 詡 冔 姁 湑 諝 醑 鄦 珝 喣 休 呴 沀 昫 祤 滸 糈 偦 綇 繏 盨"},
    {33619968, 1, "阿"},
    {33619969, 3, "把 靶 鈀"},
    {33619971, 10, "馬 螞 碼 瑪 溤 嗎 鎷 鷌 嘜 鰢"},
    {33619972, 9, "法 髮 砝 琺 珐 髪 鍅 灋 佱"},
    {33619973, 1, "打"},
    {33619974, 8, "塔 榙 鎝 獺 嗒 溚 墖 㗳"},
    {33619975, 4, "那 哪 雫 㖠"},
    {33619976, 3, "喇 藞 拉"},
    {33619977, 1, "玍"},
    {33619978, 6, "卡 咳 佧 咔 鉲 拤"},
    {33619979, 1, "哈"},
    {33619983, 14, "眨 渣 鮓 厏 苲 扎 砟 詐 扠 搩 䕢 㴙 䃎 踷"},
    {33619984, 3, "蹅 叉 鑔"},
    {33619985, 5, "傻 繌 儍 緵 訯"},
    {33619987, 1, "鮺"},
    {33619988, 1, "礤"},
    {33619989, 4, "灑 撒 靸 洒"},
    {33620224, 17, "亞 啞 雅 掗 厊 庌 蕥 雃 疋 鴉 埡 錏 亜 瘂 鵶 鐚 唖"},
    {33620232, 2, "倆 俩"},
    {33620236, 34, "假 甲 賈 鉀 岬 胛 斝 榎 瘕 檟 婽 玾 徦 椵 夏 柙 瑕 笚 舺 猳 犌 嘏 碬 貑 赮 魻 鍜 騢 麚 叚 疨 斚 䘥 夓"},
    {33620237, 3, "卡 酠 跒"},
    {33620238, 1, "閜"},
    {33620480, 8, "瓦 佤 瓨 瓻 齀 咓 邷 攨"},
    {33620489, 4, "寡 剮 䈑 冎"},
    {33620490, 6, "垮 侉 銙 刳 挎 桍"},
    {33620495, 2, "爪 爫"},
    {33620496, 1, "抓"},
    {33620497, 1, "耍"},
    {33685504, 1, "嚄"},
    {33685505, 3, "跛 簸 蚾"},
    {33685506, 8, "頗 剖 叵 笸 尀 鉕 駊 箥"},
    {33685507, 3, "抹 秣 懡"},
    {33686016, 4, "我 婐 捰 婑"},
    {33686021, 19, "躲 朵 埵 垛 嚲 鬌 痑 趓 綞 朶 哚 垜 挅 躱 軃 袳 䤪 挆 𧊶"},
    {33686022, 13, "妥 橢 撱 庹 嫷 脫 脱 媠 楕 鋖 鵎 㨊 鰖"},
    {33686023, 2, "橠 娜"},
    {33686024, 15, "裸 瘰 臝 蠃 蓏 鎯 卵 虜 擄 砢 祼 倮 躶 攞 曪"},
    {33686025, 21, "果 裹 槨 蜾 輠 粿 猓 淉 惈 鐹 錁 杲 踝 堁 婐 捰 敤 椁 菓 楇 綶"},
    {33686026, 1, "擃"},
    {33686027, 9, "火 伙 夥 鈥 吙 炚 邩 灬 炛"},
    {33686035, 4, "左 佐 繓 撮"},
    {33686036, 4, "瑳 脞 縒 硰"},
    {33686037, 16, "所 索 鎖 瑣 璅 嗩 摵 鎍 鏼 惢 溑 鎻 鏁 暛 褨 擌"},
    {33751040, 12, "噁 我 婀 惡 婐 猗 閜 硪 悪 頋 僫 騀"},
    {33751049, 17, "葛 哿 舸 擖 魺 騔 笴 合 蓋 褐 峆 嶱 鍻 齃 乢 盖 葢"},
    {33751050, 14, "可 渴 哿 坷 岢 堁 敤 嶱 閜 顆 酠 㞹 炣 渇"},
    {33751055, 5, "者 赭 鍺 摺 遮"},
    {33751056, 7, "扯 撦 奲 尺 哆 拸 偖"},
    {33751057, 4, "捨 舍 舎 䬷"},
    {33751058, 4, "惹 喏 若 叒"},
    {33751059, 1, "怎"},
    {33816832, 6, "也 野 冶 埜 漜 壄"},
    {33816833, 3, "癟 蛂 㿜"},
    {33816834, 5, "撇 苤 丿 撆 鐅"},
    {33816838, 6, "鐵 帖 驖 僣 銕 鉄"},
    {33816840, 2, "咧 忚"},
    {33816844, 11, "姐 解 姊 檞 媎 薢 繲 姉 毑 觧 飷"},
    {33816845, 2, "且 怚"},
    {33816846, 8, "寫 血 蟹 舄 写 舃 藛 蠏"},
    {33817356, 3, "蹶 袦 蹷"},
    {33817358, 2, "雪 鱈"},
    {33882112, 13, "矮 藹 靄 欸 毐 昹 佁 乃 噯 娾 暟 藒 躷"},
    {33882113, 13, "百 擺 佰 襬 粨 捭 絔 伯 把 柏 陌 栢 摆"},
    {33882114, 3, "俖 排 㧳"},
    {33882115, 4, "買 嘪 鷶 蕒"},
    {33882117, 7, "歹 逮 得 炱 傣 歺 炲"},
    {33882119, 14, "乃 奶 迺 氖 嬭 奈 氝 釢 艿 尕 妳 鼐 疓 廼"},
    {33882120, 1, "攋"},
    {33882121, 4, "改 妀 絠 忋"},
    {33882122, 24, "凱 慨 楷 愷 剴 豈 鎧 塏 闓 鍇 颽 暟 輆 覬 喈 湝 瑎 磑 蝔 顗 鶛 嵦 䁗 蒈"},
    {33882123, 6, "海 醢 烸 嗨 醯 酼"},
    {33882127, 4, "窄 岝 鉙 䍉"},
    {33882128, 4, "冊 册 茝 笧"},
    {33882129, 3, "骰 繺 色"},
    {33882131, 8, "仔 宰 崽 載 縡 滓 儎 䏁"},
    {33882132, 14, "採 彩 采 睬 踩 綵 跴 寀 棌 婇 釆 啋 跐 倸"},
    {33882624, 2, "舀 歪"},
    {33882633, 4, "拐 柺 枴 箉"},
    {33882634, 2, "蒯 舀"},
    {33882639, 1, "跩"},
    {33882640, 1, "揣"},
    {33882641, 1, "甩"},
    {33947649, 2, "北 邶"},
    {33947650, 2, "琣 昢"},
    {33947651, 16, "美 每 鎂 浼 媺 渼 媄 挴 燘 毎 凂 羙 嵄 嬍 黣 䆀"},
    {33947652, 21, "匪 翡 斐 蜚 誹 悱 菲 朏 棐 榧 篚 奜 餥 非 扉 裴 昢 棑 緋 裵 蕜"},
    {33947653, 2, "得 𢔶"},
    {33947655, 8, "餒 哪 腇 那 娞 㖠 鮾 鯘"},
    {33947656, 38, "累 壘 儡 漯 耒 磊 蕾 誄 藟 樏 癗 礌 絫 磥 鑸 瘣 櫑 櫐 礨 灅 讄 鸓 頛 礧 蘲 嫘 羸 蜼 儽 欙 垒 洡 腂 傫 蕌 蘽 厽 㵽"},
    {33947657, 1, "給"},
    {33947659, 2, "黑 黒"},
    {33948160, 66, "委 尾 偉 緯 萎 諉 葦 痿 猥 煒 亹 隗 娓 韙 寪 洧 瑋 薳 蘤 韡 鮪 磈 蒍 頠 暐 痏 骫 椲 浘 艉 芛 鍡 峗 壝 喡 徫 腲 蜲 儰 蓶 崣 硊 踓 斖 韋 偽 唯 逶 違 諱 婑 郼 緌 覣 梶 荱 愇 骩 僞 㬙 蔿 膸 颹 厃 骪 韑"},
    {33948165, 4, "謉 㨃 䇏 𦞙"},
    {33948166, 7, "腿 俀 僓 聉 脮 蹆 骽"},
    {33948169, 37, "鬼 軌 詭 癸 匭 晷 宄 簋 佹 垝 氿 姽 蟡 庪 祪 蛫 觤 厬 葵 睽 闋 庋 湀 廆 溾 粿 螝 藈 藱 騩 恑 攱 謉 孂 陒 䤥 䤆"},
    {33948170, 10, "傀 跬 頍 煃 蹞 峞 揆 磈 尯 猤"},
    {33948171, 17, "會 悔 誨 毀 燬 賄 虺 虫 烠 毇 檓 譭 珛 烸 会 毁 泋"},
    {33948175, 1, "沝"},
    {33948177, 1, "水"},
    {33948178, 8, "蕊 橤 繠 惢 桵 蕋 蘂 蘃"},
    {33948179, 8, "嘴 璻 觜 嶊 噿 濢 嶉 臎"},
    {33948180, 8, "璀 趡 漼 洒 踓 鏙 熣 皠"},
    {33948181, 8, "髓 嶲 瀡 巂 靃 雟 膸 髄"},
    {34013184, 12, "襖 媼 芺 镺 夭 拗 郩 抝 袄 媪 鴁 狕"},
    {34013185, 25, "保 寶 飽 堡 褓 葆 鴇 怉 駂 鳵 媬 褒 煲 宝 珤 堢 寚 緥 裦 賲 闁 襃 寳 䴐 宲"},
    {34013186, 1, "跑"},
    {34013187, 8, "卯 昴 泖 茆 鉚 窌 戼 峁"},
    {34013189, 15, "倒 島 導 禱 搗 擣 壔 禂 蹈 嶋 嶌 隝 嶹 隯 祷"},
    {34013190, 2, "討 䵚"},
    {34013191, 11, "腦 惱 瑙 恼 娚 悩 嫐 碯 憹 垴 匘"},
    {34013192, 18, "老 姥 佬 鐒 栳 狫 轑 咾 橑 銠 恅 荖 耋 潦 㧯 耊 䇭 蛯"},
    {34013193, 36, "稿 攪 搞 槁 縞 杲 暠 檺 筶 皋 睪 鄗 閣 鎬 嗃 塙 滈 睾 皜 碻 嚆 謞 髇 鰝 夰 皐 臯 菒 槀 墧 撹 稾 藁 瀥 藳 稁"},
    {34013194, 10, "考 烤 拷 栲 攷 薧 洘 熇 燺 丂"},
    {34013195, 4, "好 郝 㚼 㝀"},
    {34013199, 6, "找 沼 爪 菬 瑵 爫"},
    {34013200, 9, "吵 炒 眧 赻 粆 煼 巐 㥮 麨"},
    {34013201, 2, "少 尐"},
    {34013202, 4, "擾 嬈 撓 遶"},
    {34013203, 16, "早 棗 澡 藻 蚤 璪 繰 慅 溞 瑵 璅 瘙 糔 鄵 枣 薻"},
    {34013204, 7, "草 懆 騲 艸 慅 愺 艹"},
    {34013205, 3, "掃 嫂 埽"},
    {34013440, 29, "咬 窈 舀 夭 殀 杳 窅 窔 鷕 宎 抭 苭 眑 偠 溔 榚 騕 岆 嫍 蓔 嬈 柼 穾 仸 婹 崾 闄 齩 䶧"},
    {34013441, 8, "表 錶 婊 裱 俵 褾 檦 諘"},
    {34013442, 13, "漂 莩 縹 瞟 殍 皫 摽 醥 犥 剽 篻 顠 勡"},
    {34013443, 14, "秒 渺 藐 邈 緲 杳 眇 淼 杪 篎 沓 仦 仯 劰"},
    {34013445, 3, "屌 鳥 扚"},
    {34013446, 8, "挑 窕 誂 宨 嬥 窱 晀 䠷"},
    {34013447, 9, "鳥 裊 嬲 嬝 嫋 蔦 褭 樢 茮"},
    {34013448, 14, "了 瞭 蓼 憭 釕 暸 鄝 蟟 燎 繚 镽 尞 嘞 爒"},
    {34013452, 71, "腳 角 繳 攪 勦 矯 絞 姣 佼 餃 皎 僥 剿 較 鉸 狡 皦 儌 筊 蟜 摷 撟 捁 灚 曒 漅 劋 譑 煍 檄 鮫 覺 唃 捔 桷 湫 确 憢 皛 噭 墽 嬓 徼 憿 撽 敿 獥 礉 覈 蹻 觷 譥 躈 鱎 㭂 晈 烄 斍 脚 覚 湬 踋 撹 璬 孂 譤 臫 覐 㡑 暞 賋"},
    {34013453, 8, "巧 悄 愀 鵲 雀 燋 頝 釥"},
    {34013454, 7, "小 曉 筱 篠 謏 暁 皢"},
    {34078720, 14, "偶 藕 嘔 耦 吘 湡 腢 蕅 隅 歐 藒 饇 㒖 髃"},
    {34078722, 12, "剖 瓿 棓 婄 叵 培 掊 咅 勏 犃 箁 哣"},
    {34078723, 10, "某 冇 踇 牡 畝 畂 畆 畞 畮 𦳑"},
    {34078724, 8, "否 缶 殕 缹 鴀 不 缻 雬"},
    {34078725, 8, "斗 抖 陡 蚪 枓 唗 敨 阧"},
    {34078726, 8, "黈 妵 紏 鈄 蘣 敨 斢 飳"},
    {34078727, 1, "啂"},
    {34078728, 7, "簍 摟 塿 嶁 嘍 甊 㪹"},
    {34078729, 12, "狗 岣 枸 笱 耇 茩 蚼 怐 耈 豿 䔛 耉"},
    {34078730, 2, "口 劶"},
    {34078731, 3, "吼 呍 犼"},
    {34078735, 7, "帚 肘 睭 鯞 疛 晭 箒"},
    {34078736, 12, "丑 醜 瞅 杻 杽 吜 莥 偢 矁 魗 丒 䪮"},
    {34078737, 8, "手 首 守 掱 艏 狩 垨 扌"},
    {34078738, 5, "糅 鍕 粈 煣 韖"},
    {34078739, 2, "走 赱"},
    {34078741, 14, "叟 嗾 藪 擻 瞍 謏 籔 廋 溲 叜 傁 廀 蓃 櫢"},
    {34078976, 30, "有 友 酉 莠 牖 黝 羑 泑 銪 岰 庮 蒏 苃 聈 槱 卣 唒 栯 眑 莤 蚴 懮 㶭 梄 湵 禉 牗 丣 羐 蜏"},
    {34078983, 10, "紐 扭 鈕 忸 狃 炄 莥 杻 沑 靵"},
    {34078984, 11, "柳 綹 罶 飹 珋 嬼 栁 桺 熮 橮 羀"},
    {34078988, 33, "九 久 酒 玖 赳 灸 韭 糾 炙 疚 柩 愀 勼 虯 觓 釓 韰 薤 齏 乆 乣 奺 糺 虬 柾 紤 韮 熫 韲 匶 匛 舏 镹"},
    {34078989, 3, "糗 螑 搝"},
    {34078990, 8, "朽 宿 糔 休 枵 滫 潃 鴞"},
    {34144256, 13, "俺 唵 晻 堷 匼 噾 馣 黤 黭 埯 揞 隌 罯"},
    {34144257, 12, "板 版 闆 阪 舨 昄 鈑 粄 蝂 魬 坂 瓪"},
    {34144258, 1, "坢"},
    {34144259, 9, "滿 屘 矕 懣 蹣 顢 満 鏋 𨃟"},
    {34144260, 7, "反 返 魬 皈 橎 仮 㽹"},
    {34144261, 18, "膽 疸 撢 亶 紞 刐 撣 玬 衴 黵 丼 澸 黕 瓭 胆 馾 䪴 㔊"},
    {34144262, 23, "坦 毯 袒 襢 忐 禫 菼 嗿 膻 憳 醓 裧 怛 氈 緂 儃 黮 氍 毡 憻 氊 璮 䏙"},
    {34144263, 8, "赧 戁 蝻 湳 腩 揇 萳 罱"},
    {34144264, 25, "覽 懶 攬 欖 纜 壈 爦 灠 醂 嬾 顲 浨 卵 嵐 濫 㛦 覧 㩜 燣 擥 攋 孄 孏 漤 䌫"},
    {34144265, 25, "敢 感 趕 桿 橄 稈 澉 皯 盰 赶 瞰 矸 噉 撖 憨 簳 譀 豃 轗 矙 仠 秆 擀 饏 鱤"},
    {34144266, 22, "砍 侃 坎 崁 嵌 莰 檻 欿 轗 歁 歞 埳 凵 顑 堿 竷 闞 偘 塪 㙳 惂 輡"},
    {34144267, 14, "喊 罕 厂 蔊 豃 嚂 闞 鬫 欦 浫 㙳 㘚 厈 𣛴"},
    {34144271, 23, "展 斬 盞 輾 搌 嶄 琖 魙 醆 颭 樿 皽 蹍 嫸 榐 橏 獑 槧 㠭 㜊 㔊 𨃨 𧬆"},
    {34144272, 25, "產 鏟 闡 剷 蕆 嘽 囅 丳 嵼 燀 諂 驏 幝 繟 滻 簅 灛 旵 譂 剗 産 摌 閳 讇 醦"},
    {34144273, 11, "閃 陝 睒 晱 覢 摻 陜 掺 撡 䀹 㜣"},
    {34144274, 14, "染 冉 髯 苒 珃 橪 呥 姌 嫨 聃 冄 耼 媣 蹨"},
    {34144275, 15, "拶 攢 寁 昝 禶 喒 儹 揝 礸 噆 趲 㳫 撍 儧 攅"},
    {34144276, 6, "慘 憯 朁 噆 黲 惨"},
    {34144277, 15, "散 傘 繖 糝 鏾 槮 鏒 椮 嘇 潵 糂 糣 仐 糤 饊"},
    {34144512, 78, "眼 演 掩 衍 郾 偃 兗 齞 甗 儼 魘 剡 弇 罨 沇 巘 扊 揜 渰 蝘 黶 姶 戭 棪 鰋 鼴 琰 匽 厴 椼 抁 龑 酓 嵃 愝 萒 隒 裺 褗 鶠 黤 曮 惔 躽 馣 奄 堰 愆 縯 崦 郯 媕 晻 羡 馻 蔩 噞 餰 顩 齴 广 兖 埯 隌 隁 硽 遃 墕 嬊 嶖 諐 鮎 檿 鼹 夵 乵 渷 巚"},
    {34144513, 15, "扁 貶 匾 褊 窆 萹 惼 碥 砭 蝙 揙 稨 鴘 糄 藊"},
    {34144514, 3, "貵 諞 覑"},
    {34144515, 29, "免 勉 緬 冕 娩 靦 湎 沔 偭 眄 絻 丏 俛 愐 喕 鮸 浼 脕 媔 葂 汅 凂 㝃 勔 覥 鰵 厸 莬 㨠"},
    {34144517, 13, "點 典 碘 錪 婰 琠 蕇 腆 痶 奌 点 㙉 敟"},
    {34144518, 24, "舔 忝 殄 腆 靦 淟 餂 賟 悿 蚕 晪 痶 恬 倎 琠 跈 銛 錪 㙉 睓 覥 鍩 㥏 銽"},
    {34144519, 19, "捻 撚 攆 拈 輦 碾 輾 涊 簐 跈 躎 稔 淰 棯 腍 諗 蹍 菍 蹨"},
    {34144520, 13, "臉 鄻 膦 摙 僆 羷 斂 溓 槤 璉 㯬 稴 醶"},
    {34144524, 57, "簡 撿 剪 減 檢 揀 繭 儉 鹼 柬 筧 翦 謇 戩 蹇 譾 趼 堿 囝 鰔 挸 湕 瞼 寋 藆 襺 暕 瑐 件 錢 鐧 騫 帴 媊 揃 僉 噞 嬐 憸 襉 攓 鐱 鑳 倹 减 梘 検 詃 絸 戬 碱 銭 謭 瀽 蠒 鹻 弿"},
    {34144525, 23, "遣 淺 譴 繾 槏 撖 忏 蜸 嵌 潛 嗛 隒 諓 輚 醆 鼸 欦 浅 膁 潜 濳 㹂 嵰"},
    {34144526, 46, "險 顯 鮮 癬 蘚 銑 燹 跣 嶮 蜆 姺 尟 譣 幰 獫 獮 玁 筅 韅 毨 烍 鍌 搟 鼸 齴 赻 攇 禒 洗 冼 暹 洒 珗 兟 鋧 廯 灦 㧥 㭠 尠 箲 礆 顕 鱻 㬎 䥪"},
    {34144768, 57, "晚 碗 挽 宛 婉 娩 皖 輓 莞 浣 蜿 畹 菀 琬 鞔 綰 晼 綩 倇 脕 睕 鋄 睌 葂 剜 梡 腕 豌 妴 捖 婠 捥 晥 涴 脘 羦 踠 鋎 鋺 鵷 唍 㝃 盌 埦 梚 晩 椀 萖 鋔 䥑 鯶 鰀 箢 䘼 䛷 鎫 錽"},
    {34144773, 1, "短"},
    {34144774, 2, "畽 疃"},
    {34144775, 6, "暖 餪 煖 渜 煊 煗"},
    {34144776, 1, "卵"},
    {34144777, 16, "管 館 莞 琯 筦 脘 痯 錧 菅 斡 綰 朊 嵈 萖 舘 輨"},
    {34144778, 6, "款 窾 梡 欵 歀 窽"},
    {34144779, 9, "緩 皖 澣 睆 輐 諼 鍰 浣 愋"},
    {34144783, 4, "轉 囀 竱 孨"},
    {34144784, 9, "喘 舛 荈 揣 踹 踳 堾 僢 蝽"},
    {34144786, 20, "軟 阮 蠕 耎 蝡 瓀 緛 礝 朊 卵 需 堧 偄 媆 瑌 腝 輭 㮕 䓴 碝"},
    {34144787, 7, "纂 鑽 纘 籫 篹 纉 鑚"},
    {34144789, 2, "匴 篹"},
    {34145024, 6, "遠 妴 鋺 薳 盶 齳"},
    {34145032, 3, "孌 臠 脔"},
    {34145036, 20, "捲 卷 埢 菤 臇 蜷 踡 婘 惓 犈 腃 綣 蔨 錈 鬈 巻 埍 㷷 孉 奆"},
    {34145037, 12, "犬 綣 甽 畎 琄 虇 汱 圈 烇 裷 呟 犭"},
    {34145038, 5, "選 咺 烜 癬 选"},
    {34209792, 1, "峎"},
    {34209793, 7, "本 畚 苯 泍 夲 楍 奙"},
    {34209794, 3, "呠 翸 翉"},
    {34209795, 1, "暪"},
    {34209796, 2, "粉 黺"},
    {34209801, 1, "艮"},
    {34209802, 12, "肯 啃 墾 懇 齦 豤 錹 掯 硍 肎 恳 貇"},
    {34209803, 9, "很 狠 佷 拫 硍 蛝 豤 鞎 詪"},
    {34209807, 35, "診 枕 疹 軫 畛 袗 縝 稹 紾 鬒 眕 黰 辴 抮 抌 笉 絼 祳 晸 縥 黕 賑 餮 胗 裖 駗 姫 昣 屒 聄 弫 敐 䪴 飻 覙"},
    {34209808, 12, "捵 磣 鍖 裖 墋 踸 贂 祳 趻 硶 夦 謲"},
    {34209809, 23, "沈 審 嬸 瀋 諗 讅 矧 哂 寀 瞫 邥 覾 沉 淰 曋 吲 弞 宷 訠 魫 鯅 矤 頣"},
    {34209810, 11, "忍 稔 荏 腍 棯 栠 荵 栣 秹 菍 䏰"},
    {34209811, 1, "怎"},
    {34210048, 35, "引 飲 隱 尹 癮 蚓 听 靷 紖 縯 讔 趛 螾 馻 鈏 檃 濦 蘟 粌 殷 戭 廴 吲 弞 赺 淾 隠 嶾 濥 檼 櫽 䘆 乚 磤 㶏"},
    {34210049, 3, "稟 禀 癛"},
    {34210050, 3, "品 煰 嘂"},
    {34210051, 26, "敏 憫 閔 閩 抿 泯 皿 湣 愍 黽 澠 笢 敃 刡 僶 簢 敯 潣 怋 暋 黾 勄 慜 冺 㥸 𧁋"},
    {34210055, 1, "拰"},
    {34210056, 18, "凜 懍 廩 檁 菻 亃 綝 榃 稟 僯 顲 禀 凛 撛 廪 澟 癛 㨆"},
    {34210060, 29, "緊 僅 錦 謹 儘 覲 瑾 饉 槿 墐 殣 堇 慬 菫 巹 婜 掔 廑 蓳 瘽 嚍 螼 騹 卺 厪 嫤 漌 懄 䐶"},
    {34210061, 11, "寢 昑 寑 曋 螼 坅 顉 侵 鋟 赾 寝"},
    {34210062, 1, "伈"},
    {34210304, 13, "穩 吻 刎 呡 桽 昒 曶 勽 伆 肳 脗 䦟 穏"},
    {34210309, 3, "盹 躉 𣎴"},
    {34210310, 4, "汆 吨 畽 疃"},
    {34210312, 2, "稐 耣"},
    {34210313, 17, "滾 袞 鯀 緄 輥 掍 蔉 混 渾 袬 緷 丨 衮 滚 蓘 鮌 䙛"},
    {34210314, 14, "捆 綑 悃 梱 閫 壼 稛 硱 裍 齫 棞 祵 稇 閸"},
    {34210315, 3, "混 睔 掍"},
    {34210319, 8, "準 准 隼 埻 綧 純 凖 鶽"},
    {34210320, 11, "蠢 惷 踳 偆 萶 㖺 堾 僢 睶 蝽 箺"},
    {34210321, 5, "盾 楯 吮 揗 賰"},
    {34210323, 6, "撙 噂 墫 僔 譐 䔿"},
    {34210324, 2, "忖 刌"},
    {34210325, 11, "損 筍 榫 簨 鎨 隕 芛 塤 笋 磒 箰"},
    {34210560, 31, "允 隕 殞 狁 霣 褞 抎 賱 輑 鈗 阭 吮 抁 沇 荺 塤 熉 馻 薀 夽 玧 㽙 喗 䤞 腪 磒 蕰 䨶 运 傊 渷"},
    {34210572, 2, "窘 蜠"},
    {34275328, 2, "軮 雵"},
    {34275329, 10, "榜 綁 牓 膀 螃 搒 㧍 挷 騯 髈"},
    {34275330, 3, "嗙 耪 覫"},
    {34275331, 10, "莽 蟒 漭 汒 庬 硥 茻 壾 蠎 莾"},
    {34275332, 18, "訪 彷 仿 紡 倣 舫 昉 瓬 髣 鶭 坊 妨 放 㕫 昘 旊 眆 鴋"},
    {34275333, 14, "檔 黨 擋 讜 攩 欓 党 當 襠 儻 当 挡 譡 灙"},
    {34275334, 16, "倘 躺 儻 淌 帑 惝 钂 鎲 戃 曭 爣 矘 徜 伖 偒 耥"},
    {34275335, 4, "曩 攮 灢 搑"},
    {34275336, 12, "朗 閬 硠 峎 悢 誏 烺 塱 崀 朖 朤 㫰"},
    {34275337, 5, "港 崗 岡 奋 㽘"},
    {34275338, 3, "慷 骯 忼"},
    {34275339, 1, "酐"},
    {34275343, 9, "長 掌 漲 仉 鞝 仧 涱 兏 镸"},
    {34275344, 10, "場 廠 敞 氅 昶 鋹 惝 僘 厰 塲"},
    {34275345, 5, "賞 晌 上 償 丄"},
    {34275346, 7, "嚷 壤 攘 爙 穰 蠰 躟"},
    {34275347, 3, "駔 髒 驡"},
    {34275348, 1, "駔"},
    {34275349, 6, "嗓 顙 搡 磉 鎟 褬"},
    {34275584, 23, "養 仰 氧 癢 鞅 卬 攁 岟 炴 抰 痒 懩 蝆 坱 蛘 瀁 慃 氱 駚 傟 詇 䬬 勜"},
    {34275592, 13, "兩 倆 魎 緉 裲 啢 両 两 蜽 魉 俩 掚 脼"},
    {34275596, 11, "講 獎 蔣 槳 顜 膙 傋 耩 奨 奬 鞲"},
    {34275597, 13, "強 搶 襁 磢 傸 墏 繈 彊 鏹 强 摤 繦 勥"},
    {34275598, 17, "想 響 享 餉 饗 鯗 饟 晑 晌 嚮 崞 亯 响 銄 鮝 鑜 鱶"},
    {34275840, 22, "往 網 枉 罔 惘 魍 輞 瀇 网 暀 菵 臦 俇 仼 徃 棢 誷 冈 罒 䒽 蛧 迬"},
    {34275849, 14, "廣 獷 迋 臩 嚝 懭 瀇 鄺 爌 穬 纊 広 兤 黋"},
    {34275850, 3, "俇 儣 懬"},
    {34275851, 16, "謊 恍 晃 幌 洸 怳 榥 熀 鎤 滉 皝 晄 奛 詤 皩 宺"},
    {34275855, 1, "奘"},
    {34275856, 6, "闖 搶 漺 傸 磢 摤"},
    {34275857, 11, "爽 塽 樉 漺 慡 縔 傸 磢 鷞 逺 鸘"},
    {34340865, 12, "菶 玤 琫 埲 誁 繃 琣 浲 漨 綳 鞛 䭰"},
    {34340866, 3, "捧 皏 淎"},
    {34340867, 14, "猛 蜢 艋 錳 懵 鼆 蠓 懞 瓾 幪 勐 顭 鯭 𢕙"},
    {34340868, 4, "唪 覂 泛 諷"},
    {34340869, 2, "等 戥"},
    {34340871, 1, "𠹌"},
    {34340872, 2, "冷 泠"},
    {34340873, 15, "梗 耿 哽 綆 鯁 埂 骾 郠 挭 炚 褧 峺 莄 炛 㹴"},
    {34340874, 3, "挳 肯 肎"},
    {34340879, 9, "整 拯 氶 撜 糽 掟 晸 抍 愸"},
    {34340880, 11, "逞 騁 悜 庱 塣 懲 梬 侱 徎 惩 睈"},
    {34340881, 5, "省 眚 冼 箵 偗"},
    {34340882, 1, "扔"},
    {34340884, 1, "噌"},
    {34341120, 16, "影 景 穎 潁 癭 郢 瀴 矨 梬 浧 熲 顈 廮 頴 巊 鐛"},
    {34341121, 30, "餅 丙 稟 柄 秉 炳 昺 邴 怲 鞞 鉼 蛃 陃 苪 窉 屏 庰 迸 芮 抦 昞 眪 屛 幈 棅 逬 禀 餠 餜 鈵"},
    {34341122, 1, "絣"},
    {34341123, 9, "眳 姳 慏 皿 茗 酩 瞑 佲 凕"},
    {34341125, 10, "頂 鼎 酊 嵿 濎 薡 鼏 奵 檙 鼑"},
    {34341126, 16, "挺 艇 町 梃 頲 珽 脡 鋌 烶 圢 侹 娗 侱 涏 誔 𡈼"},
    {34341127, 3, "擰 橣 矃"},
    {34341128, 6, "領 嶺 彾 阾 袊 𦊓"},
    {34341132, 27, "景 警 井 頸 阱 儆 璟 憬 剄 璥 丼 肼 憼 暻 蟼 燛 境 擎 汫 幜 澋 鵛 汬 穽 頚 璄 䜘"},
    {34341133, 11, "請 頃 廎 傾 掅 綪 輤 錆 苘 㷫 檾"},
    {34341134, 6, "省 醒 擤 渻 惺 睲"},
    {34341376, 10, "蓊 滃 暡 浻 瞈 聬 塕 奣 䐥 嵡"},
    {34341381, 9, "懂 董 嬞 墥 蕫 諌 箽 𣿅 𢤦"},
    {34341382, 7, "統 筒 桶 捅 垌 筩 姛"},
    {34341383, 2, "擃 繷"},
    {34341384, 13, "隴 攏 壟 龍 籠 儱 竜 篭 壠 竉 龓 䡁 㡣"},
    {34341385, 18, "鞏 拱 汞 共 珙 礦 栱 廾 拲 蛬 穬 龔 銾 鋛 鑛 孒 巩 㧬"},
    {34341386, 5, "恐 孔 倥 吼 悾"},
    {34341387, 3, "哄 嗊 晎"},
    {34341391, 8, "種 腫 塚 踵 冢 种 喠 歱"},
    {34341392, 2, "寵 埫"},
    {34341394, 10, "冗 茸 氄 傇 軵 宂 坈 搑 縙 𢫨"},
    {34341395, 20, "總 摠 傯 熜 朡 蓗 縱 偬 捴 惣 愡 焧 㷓 憁 総 縂 縦 燪 㧾 揔"},
    {34341396, 2, "衳 幒"},
    {34341397, 11, "聳 慫 悚 竦 傱 愯 嵷 駷 捒 摗 㩳"},
    {34341632, 31, "永 泳 詠 勇 擁 踴 湧 蛹 甬 壅 恿 臃 俑 踊 埇 塎 禜 涌 悀 銢 臾 咏 惥 愑 彮 慂 鯒 勈 柡 硧 愹"},
    {34341644, 33, "窘 迥 煚 泂 炅 絅 褧 冏 熲 囧 皛 炯 幜 顈 坰 炚 扃 浻 迵 駉 冂 垧 埛 逈 烱 䢛 綗 煛 駫 䮐 蘏 炛 僒"},
    {34341645, 2, "褧 顈"},
    {34406400, 17, "爾 耳 洱 餌 邇 珥 駬 薾 鉺 峏 尒 栮 茸 尔 迩 儞 尓"},
    {50331648, 1, "ˋ"},
    {50331663, 134, "至 制 治 志 製 致 置 智 秩 誌 稚 質 峙 緻 幟 滯 摯 窒 炙 痔 雉 識 懥 痣 輊 騭 帙 陟 知 寘 忮 桎 躓 蛭 贄 鷙 厔 鑕 豸 庤 彘 猘 畤 疐 紩 觶 郅 銍 偫 跱 遰 鋕 櫍 袟 騺 淛 狾 胵 膣 挃 洷 覟 庢 鴙 迣 翐 臸 駤 祑 觢 鴩 灸 值 掣 絰 耋 熾 遲 伿 咥 垤 晊 罝 荎 秷 窐 廌 滍 瘈 嬂 潪 薙 懫 垁 斦 洔 値 娡 徏 耊 秲 袠 貭 赿 崻 搱 筫 腟 遅 遟 熫 㻰 稺 儨 穉 隲 豑 芖 徝 㨁 觗 㨖 䎺 旘 璏 䭁 劕 𨑨 𢙺 𡍶 𢕞 憄 𦤹 驇"},
    {50331664, 61, "赤 翅 斥 飭 叱 熾 啻 傺 敕 眙 抶 饎 栻 遫 彳 跮 踅 鷘 乿 瘛 鉓 哧 淔 痸 懘 戠 摰 吒 柝 赫 幟 乇 虴 捇 湁 觢 赩 趐 鶒 杘 灻 卶 呹 勅 咤 恜 勑 翄 烾 痓 雴 慗 憏 慸 爀 糦 趩 侙 卙 旘 翤"},
    {50331665, 101, "市 是 事 世 士 勢 識 室 示 試 視 式 氏 適 釋 飾 侍 誓 逝 嗜 恃 仕 柿 使 螫 弒 噬 拭 豉 媞 筮 舐 軾 諡 貰 芔 奭 戺 澨 諟 襫 鈰 揓 鉽 唑 翨 銴 謚 遾 簭 齛 跩 烒 崼 徥 詍 戠 褆 始 紲 巿 忕 伳 茌 迣 倳 剚 栻 疶 埶 畤 跇 睼 僿 醍 擿 乨 卋 忲 势 呩 柹 冟 昰 眎 眡 絉 弑 舓 緤 䤭 餙 嬕 餝 丗 叓 𨑬 兘 眂 啇 睗"},
    {50331666, 7, "日 衵 馹 鈤 入 囸 釰"},
    {50331667, 18, "自 字 恣 漬 眥 孳 剚 胔 胾 扻 倳 牸 磧 芓 絘 茡 㹀 眦"},
    {50331668, 15, "次 刺 賜 廁 伺 佽 蛓 莿 朿 栨 蚝 絘 庛 厠 螆"},
    {50331669, 50, "四 似 賜 嗣 飼 寺 肆 祀 食 俟 伺 泗 巳 耜 儩 姒 笥 駟 兕 涘 柶 汜 肂 貄 蕼 洍 思 廁 圮 怬 羠 鈶 佀 孠 杫 泤 牭 恖 厠 釲 竢 鈻 禩 瀃 亖 攺 㹭 逘 𥒲 娰"},
    {50331904, 215, "意 義 易 議 亦 益 異 藝 億 憶 譯 液 役 翼 疫 毅 逸 邑 抑 肄 一 誼 繹 溢 縊 軼 詣 屹 佚 翌 羿 驛 掖 懿 裔 臆 曳 奕 蜴 腋 衣 刈 翳 挹 鎰 囈 弈 佾 乂 弋 艾 懌 劓 圛 斁 薏 悒 瘞 仡 勩 埸 嶧 帟 曀 杙 枻 殪 浥 熠 艗 襼 饐 黓 亄 唈 燡 藙 豷 寱 阣 熤 劮 檍 嗌 廙 鐿 醳 醷 翊 肊 异 枍 伿 浂 澺 芅 熼 玴 抴 蘙 俋 焲 燱 晹 垼 釴 捙 欭 埶 羛 隿 殔 跇 裛 嫕 緆 膉 靾 槷 潩 蓺 墿 瘱 謚 繶 瀷 帠 槸 霬 鷾 齸 泄 疙 施 洩 食 射 睪 噫 圪 泆 昳 栺 詍 詄 鳦 馹 蓻 誽 燚 鴩 燨 贀 鶂 鷁 鷊 鸅 义 阝 弌 㐹 伇 曵 呭 怈 㳑 炈 秇 洂 栧 浳 袣 訲 豛 幆 敡 棭 湙 萟 蛡 鈠 竩 䇼 榏 㦉 撎 嬟 嬑 㵩 瞖 穓 曎 歝 褹 貖 鯣 鶃 虉 讛 㧒 悥 殹 䓃 豙 㴒 痬 骮 螠 㘈 癔 䱛 㦤 䭞 鷧 㑊"},
    {50331905, 149, "必 敝 畢 壁 避 璧 閉 鄙 臂 幣 弊 婢 斃 碧 泌 祕 俾 蔽 庇 嗶 愎 辟 弼 裨 陛 埤 箄 篦 畀 比 嬖 睥 賁 贔 襞 毖 蓽 蹕 髀 怭 庳 愊 楅 湢 狴 獘 篳 苾 薜 觱 詖 躄 邲 閟 柲 梐 珌 痺 飶 馝 駜 鎞 鷩 皕 堛 鉍 痹 腷 骳 坒 滭 熚 疪 妼 鏎 鷝 柫 佖 蜌 彃 箅 蓖 鄪 罼 鮅 襒 鵖 襣 驆 鼊 芘 粊 稗 嫳 獙 廦 鄨 縪 佛 拂 秘 費 跛 逼 擘 謐 咇 毘 胇 萆 稫 綼 髲 踾 貔 繴 仏 夶 吡 怶 畁 啚 豼 閇 弻 貱 煏 睤 箆 聛 壀 孹 嚊 躃 鞸 魓 㧙 枈 䏟 虑 㻫 䠋 饆 韠 鰏 鐴 鐾 𢕾 朇"},
    {50331906, 25, "譬 闢 僻 媲 屁 辟 癖 甓 擗 澼 濞 淠 揊 潎 鷿 髲 礔 副 埤 堛 廦 壀 礕 疈 鸊"},
    {50331907, 37, "密 蜜 秘 祕 覓 泌 汨 謐 宓 冪 塓 幦 鼏 羃 幎 漞 糸 峚 榓 滵 蔤 蠠 嘧 日 謎 冖 囸 宻 淧 覔 幂 詸 樒 濗 櫁 藌 鑖"},
    {50331909, 64, "地 第 弟 帝 遞 蒂 的 締 諦 娣 睇 棣 杕 玓 禘 蔕 螮 踶 楴 渧 碲 虳 釱 樀 旳 軑 梊 焍 馰 墆 嵽 珶 甋 悌 啻 逮 褫 晜 搋 蝃 墬 遰 篪 坔 竾 苐 埊 偙 递 逓 媂 祶 筂 腣 摕 裭 骶 嶳 怟 啇 䟡 僀 䐭 𨮹"},
    {50331910, 43, "替 惕 涕 屜 悌 剃 銻 嚏 倜 薙 殢 裼 揥 籊 鬄 悐 褅 逖 弟 娣 啻 棣 迖 俶 睇 疐 懥 擿 趯 戻 达 屉 迏 惖 逷 髢 歒 䞶 鬀 嚔 鐟 髰 䶑"},
    {50331911, 32, "逆 溺 匿 膩 泥 睨 暱 惄 嫟 縌 迡 堄 慝 昵 衵 掜 搦 鈮 糑 嶷 氼 胒 埿 掿 搻 懝 嬺 屰 孨 痆 愵 䁥"},
    {50331912, 151, "力 立 利 麗 歷 壢 例 曆 莉 厲 勵 礪 粒 蒞 靂 瀝 儷 隸 礫 吏 荔 栗 慄 俐 痢 癘 笠 戾 唳 酈 琍 詈 嚦 溧 蠣 櫪 沴 糲 櫟 轢 瓅 鬁 猁 盭 篥 苙 唎 屴 躒 釙 鬲 皪 秝 瑮 轣 岦 朸 欐 禲 赲 鴗 砅 濿 砬 悷 蚸 厤 筣 綟 蜧 磿 犡 藶 蠫 鷅 麜 攦 觻 鷑 攭 鱳 靋 栵 浰 塛 搮 蝷 儮 曞 讈 瓥 鱱 娳 叻 捩 棣 蜊 罹 鎘 邐 仂 夯 牞 蒚 擽 齂 襹 鸝 历 厉 丽 㕸 悧 栛 涖 珕 茘 婯 莅 傈 凓 鉝 鳨 暦 歴 䔉 㷴 隷 檪 鬴 巁 攊 櫔 爄 蠇 爏 瓑 癧 礰 纅 囇 励 沵 㾐 粝 棙 䓞 蛠 厯 㻺 矖"},
    {50331916, 124, "計 記 既 紀 際 繼 季 寄 技 妓 濟 劑 繫 悸 祭 忌 暨 冀 騎 鯽 稷 躋 薺 驥 霽 薊 髻 罽 覬 伎 洎 瘈 跽 嚌 塈 惎 漈 穧 芰 蔇 痵 癠 穄 鮆 鱭 鯚 鰶 旡 刉 臮 裚 穊 誋 鬾 瞡 檕 璾 鵋 齌 懻 瀱 鱀 蘮 蘻 即 其 寂 廄 揖 齊 儕 邔 庪 紒 茤 偈 徛 漃 暩 瘵 黖 謖 齍 艩 羇 麡 彐 彑 齐 坖 亝 斉 卽 垍 峑 剤 帺 㥍 旣 梞 済 㻑 兾 厩 継 魝 墍 廐 廏 稩 褀 禝 曁 襀 櫭 檵 聻 斊 皍 萕 葪 縘 鯯 蘎"},
    {50331917, 84, "企 氣 器 汽 棄 契 砌 泣 迄 訖 汔 憩 緝 亟 葺 磧 栔 愒 妻 蟿 鏚 盵 蚑 忔 湆 气 諿 湇 甈 鼜 乞 屹 紇 戚 揭 隙 囂 仡 犵 阣 沏 芞 咠 籺 恝 趷 偰 唭 跂 釳 揳 湒 蛪 滊 熂 瘈 禊 褉 鎎 餼 齕 㐹 呚 弃 矵 炁 洓 欫 掲 焏 硆 摖 隟 噐 憇 磜 礘 嚻 呮 㞓 敌 䞘 暣 夡"},
    {50331918, 84, "細 戲 係 系 繫 夕 汐 隙 歙 鬩 翕 穸 咥 衋 屭 綌 肸 鄎 醯 餼 滊 褉 潟 舄 矽 鑴 卌 怬 釸 鎎 釳 赩 郤 熂 覤 蕮 黖 謑 虩 忥 恄 摡 禊 齂 愾 扢 妎 呬 盻 籺 傒 塈 慀 緆 獡 罊 霫 闟 蘻 戏 欪 郄 屓 赥 椞 翖 舃 嘅 墍 犔 蒵 隟 戯 戱 䦧 嚊 韢 霼 肹 稧 縘 磶 䮎 嚱"},
    {50332160, 77, "勿 物 務 惡 誤 悟 晤 霧 戊 鎢 塢 兀 兀 騖 寤 軏 杌 婺 鶩 沕 迕 遻 鋈 屼 扤 煟 卼 焐 靰 阢 粅 矹 芴 埡 逜 痦 齀 蘁 岉 噁 蓩 毋 汙 污 沃 捂 梧 匢 昒 曶 矻 俉 眓 啎 寣 殟 鋘 汚 敄 悮 悞 悪 嵍 奦 榅 溩 遌 隖 僫 榲 熃 銐 霚 忢 匫 窹 䜑"},
    {50332161, 30, "不 部 布 步 怖 佈 簿 埠 鈽 蔀 篰 捗 咘 阜 哺 捕 抪 陟 餔 歨 歩 㳍 柨 徏 陠 荹 餢 廍 悑 郶"},
    {50332162, 9, "暴 鋪 瀑 曝 舖 堡 昢 堢 曓"},
    {50332163, 34, "木 目 幕 牧 慕 墓 募 穆 睦 暮 沐 苜 鶩 楘 霂 鉬 炑 坶 毣 蚞 幙 莯 莫 冪 繆 驀 慔 冖 朷 狇 幂 雮 㜈 樢"},
    {50332164, 65, "父 負 婦 付 附 富 復 副 傅 覆 複 腹 咐 赴 賦 駙 阜 訃 馥 賻 蝮 鮒 祔 偩 輹 鰒 鍑 榑 复 胕 蚹 萯 蝜 褔 姇 峊 蛗 緮 蕧 仆 愎 怀 洑 紨 嬔 仅 坿 冨 婏 陚 媍 詂 雬 椱 稪 嬎 鍢 㤔 竎 袝 㷆 圑 癁 疈 䪖"},
    {50332165, 20, "度 渡 肚 妒 鍍 杜 蠹 秺 喥 踱 斁 妬 靯 螙 歝 蠧 簬 荰 𪐞 殬"},
    {50332166, 8, "兔 吐 菟 鵵 堍 唾 兎 迌"},
    {50332167, 3, "怒 詉 搙"},
    {50332168, 87, "路 陸 錄 鹿 露 賂 祿 碌 氯 麓 鷺 戮 轆 蓼 逯 漉 輅 僇 潞 籙 璐 甪 稑 穋 簏 醁 騄 淥 琭 盝 磟 彔 菉 蔍 錴 垏 鏕 鯥 摝 硉 睩 廘 熝 踛 蕗 螰 鵱 淕 塶 蹗 六 角 綠 坴 翏 觻 侓 录 峍 勎 娽 渌 椂 禄 剹 勠 箓 緑 樚 膔 觮 趢 録 簵 鵦 鏴 騼 虂 龣 圥 䐂 粶 䟿 㯝 鴼 簶 䱚"},
    {50332169, 25, "故 固 顧 雇 僱 錮 告 估 痼 梏 榾 牿 堌 崮 凅 棝 稒 涸 婟 吿 崓 鳸 怘 祻 鯝"},
    {50332170, 14, "庫 褲 酷 嚳 矻 瘔 趶 厙 硞 俈 秙 絝 袴 焅"},
    {50332171, 55, "護 戶 互 滬 扈 瓠 怙 祜 笏 冱 戽 楛 沍 岵 鄠 頀 枑 槴 昈 嫭 婟 嫮 熩 豰 綔 謢 蔰 亙 斛 糊 穫 芐 嘝 寣 摦 熇 麧 槬 槲 魱 瓁 臒 韄 户 戸 亘 冴 沪 摢 嚛 燺 耯 鱯 帍 簄"},
    {50332175, 54, "住 著 助 注 祝 駐 註 柱 蛀 鑄 炷 苧 佇 箸 杼 紵 翥 宁 柷 羜 馵 疰 莇 鉒 紸 嵀 跓 軴 樦 麆 櫡 殶 諔 粥 芧 壴 怷 炾 眝 砫 罜 謯 鬻 宔 拀 俼 竚 着 筯 飳 嗻 鋳 霔 坾"},
    {50332176, 37, "處 觸 畜 絀 矗 黜 俶 怵 搐 歜 詘 鄐 斶 亍 豖 泏 琡 踀 滀 儊 臅 敊 怷 眝 触 諔 擉 蠲 处 竌 炪 㙇 笜 傗 誳 閦 嘼"},
    {50332177, 50, "術 數 樹 束 述 署 豎 疏 恕 庶 曙 墅 漱 倏 戍 澍 翛 沭 裋 鉥 尌 儵 鏣 鶐 嗽 摭 鯈 焂 訹 鈙 腧 嫬 籔 侸 倐 捒 荗 庻 疎 数 暏 㴻 竪 潄 踈 瘶 錰 濖 䉀 蒁"},
    {50332178, 18, "入 辱 褥 孺 茹 洳 縟 蓐 溽 鄏 媷 嗕 肉 耨 銣 擩 宍 傉"},
    {50332179, 2, "駔 錊"},
    {50332180, 38, "促 醋 簇 蹴 蔟 蹙 猝 卒 錯 趣 趨 鏃 瘯 踧 槭 梀 噈 殧 鼀 厝 戚 數 岨 唶 酢 碏 踀 憱 顣 卆 趋 数 誎 趗 縬 蹵 齚 鉃"},
    {50332181, 63, "訴 速 素 肅 宿 塑 夙 粟 溯 餗 愬 蓿 縮 觫 愫 膆 謖 嗉 橚 泝 涑 潚 簌 蔌 樕 遫 驌 鱐 鷫 嫊 玊 榡 洬 栜 傃 溹 憟 鋉 縤 藗 僳 窣 數 稷 摍 熽 蹜 颽 珟 殐 粛 塐 㨞 数 溸 趚 遡 樎 㯈 潥 璛 碿 㩋"},
    {50332416, 164, "育 遇 預 玉 欲 域 喻 愈 譽 獄 慾 浴 裕 煜 寓 禦 與 鈺 豫 御 鬱 籲 諭 癒 郁 馭 昱 毓 芋 尉 熨 俞 峪 聿 嫗 彧 飫 鬻 谷 鷸 燠 蜮 堉 語 瘉 棫 澦 矞 禺 罭 蕷 遹 閾 隩 鵒 棜 淢 燏 獝 繘 魊 薁 驈 悆 鴥 鋊 淯 黦 栯 砡 礜 欥 軉 輍 悇 稢 蒮 噊 鳿 醧 饇 爩 灪 戫 袬 緎 蓹 錥 王 卸 拗 玨 盂 雨 苑 娛 雩 愉 粥 奧 逾 蔚 澳 与 汩 掝 焀 郩 菀 綌 嫮 鄠 踰 閼 儥 礐 鬵 蘛 鱊 鸒 抝 芌 兪 哊 珏 秗 俼 娱 娯 茟 惐 棛 淿 喅 喩 媀 㷉 庽 焴 琙 㽣 䋭 萮 瑴 銉 鴪 鴧 礇 霱 鐭 籞 欝 龥 鬰 缷 㧒 逳 喐 奥 蜟 稶 穥 櫲 㣃"},
    {50332423, 9, "忸 恧 衄 朒 女 聏 沑 衂 䶊"},
    {50332424, 20, "律 綠 率 慮 濾 氯 嵂 膟 鑢 菉 葎 勴 壘 珒 繂 緑 爈 箻 櫖 卛"},
    {50332428, 105, "據 句 具 巨 劇 聚 俱 拒 距 鋸 懼 鉅 炬 詎 遽 倨 瞿 踞 颶 泃 苣 窶 醵 屨 秬 虡 寠 鐻 佢 据 粔 姖 怚 絇 足 耟 岠 埧 蚷 駏 澽 貗 躆 洰 焣 壉 犋 叵 沮 噱 璩 怐 朐 柜 狊 耇 胊 痀 竘 崌 涺 翑 蚼 袓 椐 椇 琚 腒 菃 跙 軥 郹 犑 豦 裾 懅 鮈 臄 螶 鼩 鶪 鼳 坥 怇 拠 邭 昛 歫 倶 冣 剧 埾 惧 耈 鄓 愳 勮 璖 鮔 㵵 嚯 簴 耉 㖸 檋"},
    {50332429, 27, "去 趣 娶 漆 覷 闃 湨 麮 刞 鼁 且 佉 呿 抾 阹 胠 祛 紶 袪 鉣 魼 厷 厺 覰 覻 閴 黢"},
    {50332430, 67, "序 續 蓄 緒 敘 絮 旭 恤 卹 酗 婿 畜 洫 旮 侐 慉 漵 藚 頊 芧 藇 魆 勖 勗 訹 鱮 烅 怴 垿 窢 瞲 銊 沀 昫 瞁 戌 煦 殈 淢 揟 欻 鈙 獝 馘 伵 汿 叙 䘏 欰 珬 惐 敍 壻 賉 槒 潊 盢 聟 稸 緖 魣 歘 肷 㖅 溆 㜅 嘼"},
    {50397184, 2, "阿 錒"},
    {50397185, 17, "罷 爸 霸 壩 耙 弝 灞 伯 猈 把 跁 矲 垻 罢 覇 皅 䎱"},
    {50397186, 8, "怕 帕 帊 袙 汃 袹 帞 絈"},
    {50397187, 10, "罵 禡 傌 榪 螞 鬕 閁 獁 駡 睰"},
    {50397188, 5, "法 琺 珐 灋 佱"},
    {50397189, 2, "大 亣"},
    {50397190, 56, "踏 榻 蹋 塌 獺 搨 遢 嚃 躂 沓 嗒 撻 遝 闥 鎉 闒 錔 鞜 鞳 鰨 羍 涾 傝 毾 誻 鑉 漯 迖 濌 龘 拓 達 呇 褟 闟 达 迏 狧 崉 㳫 㭼 㒓 澾 橽 鮙 爡 躢 眔 𠴲 㛥 䂿 㿹 蹹 譶 龖 𪘁"},
    {50397191, 25, "那 納 吶 訥 鈉 捺 娜 肭 衲 軜 妠 豽 魶 笝 內 汭 枘 蚋 貀 内 呐 靹 蒳 蜹 䟜"},
    {50397192, 25, "臘 蠟 鑞 辣 剌 腊 落 鬎 瘌 揧 楋 喇 棘 菈 搚 擸 襋 辢 臈 攋 瓎 鯻 蝲 爉 鱲"},
    {50397193, 2, "尬 魀"},
    {50397194, 2, "喀 髂"},
    {50397199, 28, "榨 柵 炸 詐 乍 搾 蚱 咋 蜡 吒 溠 砟 醡 鮓 痄 簎 笮 閘 酢 灹 咤 栅 䄍 齚 宱 䖳 𢕮 𧨊"},
    {50397200, 16, "詫 岔 剎 差 汊 衩 蜡 侘 奼 紁 杈 刹 姹 訍 仛 䟕"},
    {50397201, 18, "煞 霎 廈 嗄 歃 箑 翣 萐 喢 唼 啑 翜 樧 刹 帹 厦 榝 閯"},
    {50397204, 3, "囃 攃 遪"},
    {50397205, 13, "薩 卅 趿 颯 攃 馺 隡 蔡 摋 鎝 躠 蕯 櫒"},
    {50397440, 30, "亞 訝 迓 砑 氬 婭 揠 錏 聐 軋 圠 襾 玡 猰 窫 齾 御 穵 岈 掗 椏 圔 亜 俹 谺 稏 鐚 豄 鼼 䰲"},
    {50397452, 14, "價 假 架 駕 嫁 賈 稼 价 甲 夾 幏 鴐 価 榢"},
    {50397453, 14, "恰 洽 帢 愘 殎 冾 垥 烚 珨 楬 跲 圶 胢 㓤"},
    {50397454, 23, "下 夏 嚇 廈 暇 煆 罅 芐 欱 鏬 鶷 磍 諕 縖 丅 吓 㙈 厦 睱 疜 㰰 懗 夓"},
    {50397696, 11, "襪 嗢 膃 凹 瓦 殟 聉 袜 腽 韈 韤"},
    {50397705, 11, "掛 卦 褂 罫 罣 絓 詿 挂 髺 袿 坬"},
    {50397706, 8, "跨 胯 骻 垮 姱 晇 銙 㐄"},
    {50397707, 28, "話 化 畫 劃 樺 華 嫿 摦 崋 嬅 杹 觟 槬 繣 澅 踝 沎 罫 蘳 驊 画 婳 諣 舙 黊 譮 畵 蕐"},
    {50397713, 2, "刷 誜"},
    {50462721, 18, "播 擘 簸 亳 薜 譒 薄 檗 蘗 挀 北 畚 鄱 孹 檘 襎 奙 蔢"},
    {50462722, 24, "破 迫 魄 珀 泊 朴 粕 醱 岶 烞 蒪 扑 拍 釙 胉 哱 濼 廹 狛 洦 砶 奤 湐 屰"},
    {50462723, 88, "末 莫 默 漠 沒 膜 寞 陌 歿 脈 沫 秣 茉 驀 墨 貊 磨 嘿 瘼 靺 歾 鄚 纆 霢 嚜 眽 瞙 藦 暯 枺 爅 妺 万 銆 鏌 貘 粖 蛨 袹 嗼 塻 慔 蟔 鬕 莈 覛 縸 嘜 佰 抹 沬 冒 苜 麥 貉 幕 嘿 蟆 砓 塺 圽 麦 没 冐 帓 殁 昩 狢 脉 眿 袜 衇 貃 貈 獏 嫼 瞐 魩 頮 蟇 䃺 𤣻 皌 㱄 黙 霡 䘃 耱"},
    {50463232, 23, "握 臥 沃 渥 斡 齷 幄 涴 偓 濣 焥 喔 腛 鋈 雘 矱 蠖 肟 枂 卧 捾 楃 嬒"},
    {50463237, 33, "惰 墮 舵 跺 剁 咄 踱 馱 垛 墯 嶞 柮 陏 陊 度 袉 貀 鵽 灺 柁 痑 刴 垜 炨 炧 笜 飿 㻧 䭾 駄 憜 嚉 㨊"},
    {50463238, 13, "拓 唾 柝 籜 蘀 跅 毻 毤 魄 沰 柘 莌 袥"},
    {50463239, 21, "諾 懦 糯 搦 逽 懧 糑 那 偌 需 喏 愞 掿 搙 搻 榒 稬 蹃 鍩 穤 糥"},
    {50463240, 27, "落 駱 洛 絡 雒 烙 酪 濼 犖 咯 珞 纙 袼 硌 鮥 鵅 峈 貉 賂 輅 躒 鱳 狢 洜 貈 笿 嗠"},
    {50463241, 5, "過 瘑 薖 鐹 过"},
    {50463242, 18, "括 擴 闊 廓 鞹 漷 蛞 姡 霩 籗 适 萿 鬠 拡 挄 頢 濶 鞟"},
    {50463243, 69, "或 穫 獲 和 惑 禍 霍 貨 豁 壑 蠖 嚄 藿 鑊 矱 檴 濩 砉 雘 擭 湱 騞 謋 捇 沎 眓 掝 嗀 嗀 瓁 臒 攉 瀖 曤 矐 靃 笏 窢 聝 彉 濊 馘 霩 臛 礭 咊 㕷 咟 俰 剨 获 惒 旤 㕡 劐 彍 礊 矆 耯 癨 彠 閄 蒦 㗲 奯 艧 嚿 鸌 𦑌"},
    {50463247, 1, "㧳"},
    {50463248, 36, "綽 輟 齪 婼 啜 惙 歠 醊 婥 畷 逴 娖 吷 珿 磭 腏 趠 擉 嚽 娕 焯 錣 餟 辵 竐 涰 䓎 酫 諁 鋜 繛 蠚 鑡 辶 㲋 遬"},
    {50463249, 23, "朔 碩 爍 數 鑠 嗍 率 蟀 帥 搠 妁 槊 箾 蒴 勺 欶 揱 獡 鎙 芍 矟 数 卛"},
    {50463250, 17, "若 弱 箬 偌 爇 鄀 篛 蒻 楉 鶸 婼 渃 搦 叒 掿 焫 搻"},
    {50463251, 20, "做 作 嘬 坐 座 酢 祚 鑿 柞 怍 胙 阼 葄 夎 醋 迮 袏 飵 糳 䟭"},
    {50463252, 20, "錯 措 挫 銼 撮 剉 厝 莝 侳 剒 蓌 昔 蕞 庴 棤 碏 縒 莡 逪 襊"},
    {50463253, 8, "逤 些 塑 溯 㱔 塐 蜶 遡"},
    {50528256, 82, "惡 餓 俄 鄂 厄 遏 鍔 扼 鱷 顎 呃 愕 噩 軛 阨 鶚 堊 諤 萼 咢 啞 崿 搤 詻 閼 頞 堨 齶 枙 堮 岋 鑩 櫮 砐 砨 蚅 豟 軶 圔 搹 蝁 嶭 餩 蘁 歹 隘 額 仴 姶 唈 嫮 遻 齃 戹 歺 咹 偔 悪 㗁 湂 㮙 琧 瘂 腭 僫 磀 頟 擜 蕚 鰐 讍 𣎴 𠱥 屵 呝 苊 阸 唖 卾 㷈 覨 囐"},
    {50528262, 11, "特 慝 忒 忑 鋱 貣 蟘 貸 螣 蚮 脦"},
    {50528263, 5, "吶 那 訥 呐 抐"},
    {50528264, 31, "樂 垃 勒 肋 泐 埒 叻 仂 捋 扐 阞 砳 鰳 氻 哷 竻 落 牞 礐 礜 忇 玏 艻 寽 楽 㦡 埓 㿭 韷 簕 皬"},
    {50528265, 12, "個 各 鉻 虼 箇 詻 佫 硌 个 亇 狢 貈"},
    {50528266, 34, "客 課 刻 克 剋 喀 溘 恪 嗑 可 榼 緙 髁 氪 騍 搕 厒 勀 蚵 佫 殑 愘 楁 錁 髂 勊 娔 尅 愙 碦 礊 醘 䶗 衉"},
    {50528267, 33, "賀 和 鶴 喝 荷 嚇 赫 郝 暍 嗃 熇 猲 翯 佫 煂 愒 黑 豁 吓 咊 垎 焃 袔 黒 惒 碋 㵑 燺 爀 蠚 鸖 隺 癋"},
    {50528271, 15, "這 浙 蔗 鷓 柘 宅 檡 烢 蟅 挓 跖 这 嗻 樜 䗪"},
    {50528272, 17, "徹 澈 轍 撤 掣 坼 屮 迠 硩 拆 呫 鮿 頙 爡 㿭 瞮 勶"},
    {50528273, 31, "社 設 射 涉 舍 攝 赦 歙 麝 厙 猞 灄 蔎 韘 騇 拾 葉 捑 蠂 色 庫 聶 懾 躡 涻 舎 渉 䜓 欇 弽 蹑"},
    {50528274, 4, "熱 渃 爇 焫"},
    {50528275, 12, "仄 側 昃 庂 稄 唶 崱 汄 昗 諎 夨 歵"},
    {50528276, 26, "冊 策 測 側 廁 惻 筴 畟 茦 粣 拺 矠 憡 蓛 簎 鍘 册 厠 萗 筞 墄 嫧 箣 㩞 敇 笧"},
    {50528277, 28, "色 塞 瑟 圾 嗇 澀 穡 濇 轖 譅 銫 璱 翜 犞 飋 濏 摵 鏼 歮 趇 雭 澁 懎 繬 穯 渋 歰 瀒"},
    {50593792, 1, "誒"},
    {50594048, 70, "業 葉 頁 夜 咽 謁 拽 靨 鄴 燁 瞱 擫 射 曄 饁 煠 鍱 鐷 澲 鎑 偞 殗 嶪 擛 曳 掖 液 喝 腋 暍 噎 抴 焲 絏 楪 痷 裛 蝢 顉 韘 蠂 黦 譺 曵 亱 枼 洂 啘 殜 僷 墷 嶫 曅 餣 曗 皣 㒯 擪 瞸 鵺 爗 驜 鸈 枽 㖡 弽 牃 㗼 嚈 礏"},
    {50594049, 3, "彆 縪 蹩"},
    {50594050, 1, "嫳"},
    {50594051, 18, "滅 蔑 衊 篾 蠛 幭 覕 搣 薎 懱 瀎 礣 鱴 烕 鴓 櫗 鑖 眜"},
    {50594054, 4, "帖 餮 蛈 飻"},
    {50594055, 57, "孽 鎳 躡 聶 鑷 涅 囁 囓 臬 乜 嚙 臲 闑 隉 齧 敜 顳 糱 蘗 疌 嵲 踂 篞 櫱 蠥 钀 巕 業 懾 攝 羍 嘄 摰 槷 甈 踙 嶭 鷍 讘 圼 枿 埝 惗 鈢 暬 錜 褹 孼 籋 蘖 糵 痆 鉩 蹑 囐 䯀 帇"},
    {50594056, 38, "列 烈 劣 裂 獵 捩 冽 鬣 躐 洌 茢 睙 擸 趔 姴 迾 脟 蛚 蛶 颲 儠 鮤 鴷 犣 戾 唳 邋 浖 烮 猎 煭 聗 巤 巁 爄 劽 挒 鬛"},
    {50594060, 52, "界 借 介 戒 藉 屆 疥 芥 誡 解 唶 喈 玠 蚧 犗 褯 吤 岕 价 砎 悈 紒 祴 躤 繲 尬 械 嗟 隔 妎 扴 昦 祄 骱 廨 臩 駴 齘 届 畍 衸 堺 楐 琾 觧 魀 諎 丯 庎 徣 㾏 魪"},
    {50594061, 39, "切 竊 妾 怯 愜 挈 篋 鍥 契 朅 踥 鯜 蛪 緀 藒 洯 砌 灱 沏 唼 菨 趄 媐 慊 緁 灲 矵 匧 窃 帹 㤲 淁 笡 磜 悏 㾀 㰰 穕 䟙"},
    {50594062, 76, "謝 械 洩 屑 瀉 懈 卸 泄 蟹 解 屜 褻 榭 契 駭 廨 渫 邂 燮 楔 絏 薤 紲 媟 嶰 澥 瀣 獬 躞 灺 疶 鞢 骱 駴 偰 檞 齘 伳 妎 祄 榍 韰 屧 焎 揳 齥 脅 寫 潟 嗋 愶 熁 燲 薢 齛 写 斺 炨 炧 脇 衸 烲 屟 絬 㻡 觧 暬 緤 噧 爕 蠏 譮 缷 徢 碿 糏"},
    {50594560, 64, "月 越 樂 悅 閱 粵 躍 岳 嶽 耀 鑰 曜 藥 鉞 說 囝 刖 瀹 籥 樾 爚 礿 禴 趯 軏 鸑 龠 狘 玥 戉 泧 鈅 抈 蚎 蘥 鸙 兌 眓 葯 魆 燿 龤 兊 兑 岄 悦 蚏 捳 跀 粤 楽 説 熭 閲 嬳 薬 㜰 爠 恱 哾 籰 篗 籆 跃"},
    {50594567, 5, "虐 瘧 謔 逽 硸"},
    {50594568, 11, "略 掠 鋝 撂 擽 婛 弶 剠 畧 摾 鋢"},
    {50594572, 2, "倔 𠄌"},
    {50594573, 49, "卻 確 鵲 雀 怯 闕 榷 搉 恪 殼 闋 愨 騥 埆 确 碏 碻 礐 硞 皵 毃 礭 佉 抾 阹 胠 砳 祛 郤 紶 袪 谻 傕 塙 鉣 魼 礜 却 壳 郄 殻 愙 墧 慤 燩 灍 隺 魥 㲉"},
    {50594574, 17, "血 雪 穴 削 趐 泬 謞 岤 袕 屑 吷 狘 穸 箾 桖 㕰 坹"},
    {50659328, 39, "愛 礙 艾 曖 璦 隘 噯 乂 靉 僾 堨 嬡 鑀 賹 濭 鴱 譪 薆 阨 砨 嗌 餀 壒 餲 戹 砈 硋 碍 䔽 懝 瞹 馤 饚 𣎴 伌 阸 塧 䅬 皧"},
    {50659329, 9, "敗 拜 唄 粺 稗 庍 湃 拝 贁"},
    {50659330, 4, "派 湃 鎃 蒎"},
    {50659331, 14, "賣 麥 邁 脈 勱 蝐 眽 佅 売 麦 脉 眿 衇 𪄳"},
    {50659333, 47, "代 帶 待 袋 戴 怠 殆 黛 貸 迨 大 玳 岱 逮 襶 埭 靆 紿 廗 汏 忕 瀻 軩 跢 艜 蹛 柋 酨 軑 釱 駘 亣 㐲 侢 帒 隶 帯 㻖 瑇 鉪 㯂 緿 鴏 簤 霴 黱 軚"},
    {50659334, 20, "太 態 泰 汰 鈦 燤 溙 呔 肽 酞 大 忕 釱 亣 忲 鉪 曃 冭 夳 舦"},
    {50659335, 10, "耐 奈 褦 鼐 柰 倷 螚 渿 錼 萘"},
    {50659336, 22, "賴 癩 瀨 籟 睞 賚 藾 娕 來 徠 厲 獺 誺 厉 倈 頼 鵣 攋 瀬 櫴 来 襰"},
    {50659337, 25, "概 蓋 丐 鈣 溉 戤 摡 瓂 芥 盍 闔 丏 杚 廅 熆 篕 鑉 乢 匄 盇 盖 葢 漑 槪 槩"},
    {50659338, 16, "慨 愾 愒 咳 欬 烗 勓 壒 概 濭 忾 炌 幆 嘅 槪 槩"},
    {50659339, 20, "害 亥 駭 嗨 氦 嗐 絯 餀 劾 咳 賅 痎 搳 犗 磍 縖 螛 鶷 饚 㧡"},
    {50659343, 7, "債 寨 祭 責 瘵 砦 柴"},
    {50659344, 5, "蠆 袃 囆 瘥 訍"},
    {50659345, 5, "曬 晒 閷 殺 鎩"},
    {50659347, 7, "在 再 載 饡 扗 洅 儎"},
    {50659348, 6, "蔡 菜 埰 采 縩 寀"},
    {50659349, 4, "賽 塞 僿 簺"},
    {50659840, 1, "外"},
    {50659849, 10, "怪 旝 夬 廥 癐 壞 圣 恠 壊 叏"},
    {50659850, 28, "快 塊 會 筷 檜 劊 鄶 澮 膾 噲 獪 儈 鱠 駃 鬠 欳 炔 蒯 瘣 廥 璯 癐 瞺 旝 会 块 巜 凷"},
    {50659851, 9, "壞 坏 諙 孬 咶 蘾 褱 瀤 壊"},
    {50659855, 2, "拽 顡"},
    {50659856, 3, "踹 嘬 欼"},
    {50659857, 6, "率 帥 蟀 咰 繂 卛"},
    {50724864, 1, "欸"},
    {50724865, 47, "被 備 背 貝 輩 倍 臂 狽 憊 悖 孛 焙 蓓 褙 邶 琲 誖 鋇 哱 糒 梖 珼 鄁 牬 郥 犕 奰 北 婢 僻 避 昢 唄 偝 碚 鞁 鼰 俻 㛝 偹 旇 僃 㻗 蛽 㫲 軰 愂"},
    {50724866, 24, "配 佩 沛 珮 霈 帔 旆 浿 轡 姵 翇 伂 妃 肺 朏 淠 琲 昁 斾 苝 㻗 馷 嶏 笩"},
    {50724867, 22, "妹 媚 寐 昧 眛 魅 瑁 沬 袂 痗 韎 煝 蝞 謎 蝐 抺 祙 跊 詸 鬽 睸 篃"},
    {50724868, 38, "廢 費 肺 沸 吠 痱 怫 疿 芾 屝 剕 狒 砩 濷 癈 昲 胇 俷 厞 曊 鼣 櫠 蟦 鐨 菲 陫 琲 鯡 黂 㻗 墢 橃 蕟 靅 䀟 㹃 䤵 廃"},
    {50724871, 6, "內 那 汭 氝 内 㐻"},
    {50724872, 24, "類 淚 累 擂 纇 酹 銇 儽 蘱 禷 肋 戾 唳 捩 礌 礧 泪 类 涙 頪 錑 䢮 攂 䉪"},
    {50724879, 2, "這 这"},
    {50725376, 71, "為 位 未 魏 衛 味 偽 謂 胃 喂 慰 餵 尉 渭 畏 蔚 蘶 蝟 犩 遺 霨 磑 罻 褽 薉 媦 蜼 藯 鏏 菋 犚 餧 贀 讆 躗 穌 鮇 徻 沬 偎 穢 噅 媯 撝 溈 煟 蔧 蟡 濊 薈 鍡 瓗 㷉 爲 猬 僞 嬀 潙 熭 緭 嬒 懀 衞 錗 螱 轊 㼇 䲁 軎 苿 叞"},
    {50725381, 26, "對 隊 兌 碓 懟 譈 濧 薱 轛 濻 瀩 憝 敦 祋 莌 錞 鐓 对 兊 兑 対 陮 綐 憞 鐜 譵"},
    {50725382, 10, "退 蛻 駾 螁 褪 裉 裞 蜕 褃 娧"},
    {50725385, 39, "貴 桂 櫃 跪 劌 溎 鱖 昋 炔 筀 柜 嶡 襘 暩 會 匱 瑰 劊 檜 炅 嘳 圚 撌 槶 蔮 瞡 瞶 禬 鐀 闠 会 刏 璝 瓌 鑎 鱥 㙺 鞼 攰"},
    {50725386, 34, "愧 潰 匱 饋 餽 喟 簣 媿 聵 憒 簀 蕢 瞶 槶 樻 鐀 嘳 撌 騩 硊 蔮 歸 腃 归 帰 胿 謉 籄 鑎 殨 聭 䙡 䰎 糩"},
    {50725387, 91, "會 惠 匯 繪 慧 彙 穢 誨 賄 晦 彗 諱 潰 卉 蕙 濊 燴 喙 恚 薈 翽 闠 嘒 槥 篲 繢 繐 蟪 璯 嬇 憓 潓 瞺 譓 譿 鏸 橞 廆 詴 圚 蔧 獩 餯 鐬 饖 芔 禬 膾 彖 烠 瘣 噦 噲 廥 澮 獪 螝 鄶 薉 繣 鏏 顪 鬠 鱠 会 恵 湏 絵 彚 滙 詯 僡 暳 䧥 膭 嚖 懳 櫘 儶 譮 靧 𠱥 𡜦 寭 殨 䙡 䎚 鞼 㥣 𢕺 𦒄"},
    {50725391, 16, "綴 墜 贅 縋 惴 餟 硾 膇 鑆 掇 甀 裰 錣 笍 礈 𠄌"},
    {50725392, 4, "吹 炊 諈 龡"},
    {50725393, 15, "說 睡 稅 蛻 帨 涗 裞 挩 娷 捝 涚 祱 税 蜕 説"},
    {50725394, 18, "瑞 銳 芮 睿 蚋 叡 枘 汭 壑 濬 㕡 蜹 鋭 𤀹 㪫 䄲 𨧨 壡"},
    {50725395, 22, "最 罪 醉 檇 蕞 晬 檌 絊 祽 鋷 墬 嶵 撮 嘬 蕝 繓 欈 栬 酔 辠 酻 錊"},
    {50725396, 35, "翠 脆 粹 悴 瘁 萃 啐 淬 倅 毳 焠 竁 膬 綷 膵 脺 濢 碎 椊 嶉 噿 璻 伜 忰 砕 粋 翆 脃 琗 顇 臎 襊 韢 紣 啛"},
    {50725397, 43, "歲 遂 碎 穗 隧 祟 燧 誶 睟 穟 璲 檖 襚 鐩 邃 埣 賥 檅 繀 禭 旞 繸 鐆 術 箤 劌 薉 繐 鏏 鐬 饖 顪 亗 砕 嵗 歳 煫 穂 嬘 澻 譢 韢 疩"},
    {50790400, 28, "傲 澳 奧 懊 墺 奡 扷 擙 拗 詏 嶴 敖 燠 坳 柪 镺 隩 謷 鏊 驁 㑃 抝 嫯 㜜 慠 謸 圫 奥"},
    {50790401, 27, "報 抱 暴 爆 豹 鮑 刨 趵 鉋 虣 鑤 儤 菢 煲 袌 嚗 犦 忁 匏 雹 瀑 謈 勽 报 煿 骲 曓"},
    {50790402, 11, "泡 砲 炮 皰 奅 麭 髱 疱 靤 礮 礟"},
    {50790403, 27, "帽 冒 貌 貿 茂 瑁 懋 旄 耄 媢 楙 眊 瞀 芼 袤 毷 艒 萺 鄮 毣 蓩 皃 冐 柕 覒 暓 冃"},
    {50790405, 25, "到 道 倒 稻 盜 蹈 悼 導 纛 翿 檤 菿 瓙 燾 韜 箌 幬 盗 稲 衜 衟 轁 鞱 噵 軇"},
    {50790406, 1, "套"},
    {50790407, 5, "鬧 淖 臑 腝 閙"},
    {50790408, 19, "勞 絡 烙 酪 嫪 軂 橯 僗 落 樂 潦 澇 醪 労 劳 楽 憦 耮 髝"},
    {50790409, 21, "告 誥 郜 鋯 祰 煰 窖 膏 鵠 勂 哠 悎 捁 梏 牿 硞 筶 吿 叝 祮 禞"},
    {50790410, 6, "靠 銬 犒 鯌 焅 鮳"},
    {50790411, 42, "號 耗 浩 皓 鎬 涸 昊 好 灝 澔 皜 顥 鄗 秏 淏 滈 皞 哠 悎 鰝 昦 薃 饕 狊 藃 号 㚪 㝀 侴 恏 晧 暤 飸 暭 曍 皡 皥 瀥 峼 傐 聕 㵆"},
    {50790415, 38, "照 趙 召 罩 兆 肇 詔 晁 笊 櫂 炤 雿 狣 棹 箌 鵫 垗 旐 曌 頫 妱 淖 鉊 銚 髫 繉 鮡 㨄 燳 瞾 鑃 籱 枛 䍮 䑲 羄 肁 肈"},
    {50790416, 7, "耖 鈔 趠 仦 仯 觘 䮓"},
    {50790417, 14, "少 紹 哨 邵 召 卲 劭 袑 睄 潲 捎 稍 娋 綤"},
    {50790418, 3, "繞 遶 隢"},
    {50790419, 24, "造 皂 燥 噪 慥 譟 灶 躁 皁 趮 矂 漕 糙 喿 劋 幧 懆 氉 簉 鐰 艁 謲 竈 唕"},
    {50790420, 8, "糙 操 肏 襙 造 慥 鄵 艁"},
    {50790421, 6, "掃 臊 氉 瘙 埽 髞"},
    {50790656, 33, "要 藥 耀 曜 鑰 樂 鷂 燿 袎 靿 艞 覞 穾 筄 葯 獟 趭 虐 腰 瘧 躍 瀹 爚 抝 敫 楽 熎 薬 矅 纅 爠 讑 鼼"},
    {50790657, 2, "鰾 摽"},
    {50790658, 13, "票 漂 剽 驃 彯 篻 蔈 縹 鰾 僄 慓 勡 徱"},
    {50790659, 7, "妙 廟 繆 玅 謬 庙 庿"},
    {50790660, 1, "覅"},
    {50790661, 24, "調 掉 釣 吊 弔 窵 蓧 誂 伄 魡 悼 帣 淖 銚 藋 訋 莜 銱 鋽 鑃 㪕 竨 瘹 鈟"},
    {50790662, 13, "跳 眺 糶 朓 覜 頫 絩 窱 脁 佻 趒 艞 粜"},
    {50790663, 4, "尿 溺 氼 脲"},
    {50790664, 17, "廖 料 瞭 燎 尥 撂 炓 蟉 窲 療 釕 鄝 璆 瘳 鐐 尞 爒"},
    {50790668, 46, "教 叫 校 較 覺 轎 窖 皭 醮 徼 噭 嶠 挍 斠 珓 釂 滘 窌 嘂 潐 譥 窟 酵 嚼 蘸 窔 嘺 撟 嬓 犞 礄 趭 蹻 灂 呌 泎 訆 敎 斍 覚 敫 嘦 譤 叽 覐 漖"},
    {50790669, 24, "翹 竅 俏 峭 鞘 誚 撬 蹺 殼 帩 撽 躈 譙 獟 礉 壳 殻 䇌 髚 韒 鞩 㚁 陗 僺"},
    {50790670, 27, "校 笑 孝 效 酵 嘯 肖 傚 恔 熽 踍 哮 挍 庨 涍 痚 窙 効 咲 俲 㗛 嘨 撨 歗 关 娎 藠"},
    {50855936, 5, "嘔 漚 噢 慪 醧"},
    {50855939, 8, "茂 貿 懋 袤 楙 瞀 柕 愗"},
    {50855940, 2, "復 复"},
    {50855941, 26, "鬥 豆 逗 痘 竇 荳 脰 餖 鋀 梪 浢 讀 郖 裋 鬩 狵 毭 鬦 䦧 闘 鬪 鬬 𢭃 𥥷 斣 鬭"},
    {50855942, 2, "透 斢"},
    {50855943, 11, "耨 鎒 嗕 弄 獳 挵 搙 槈 鐞 挊 譳"},
    {50855944, 6, "漏 陋 露 鏤 瘺 屚"},
    {50855945, 29, "夠 購 垢 構 媾 彀 搆 詬 遘 覯 冓 姤 雊 傋 瞉 簼 唦 勾 句 逅 构 鷇 坸 玽 够 訽 撀 鞲 煹"},
    {50855946, 20, "扣 寇 叩 蔻 釦 鷇 筘 佝 怐 滱 瞉 簆 抇 傴 敂 冦 宼 伛 窛 蔲"},
    {50855947, 22, "後 候 厚 后 逅 鱟 垕 堠 郈 鄇 缿 洉 姤 葔 銗 緱 翭 鯸 豞 睺 𢔏 鮜"},
    {50855951, 26, "晝 皺 宙 紂 縐 冑 咒 繇 甃 籀 咮 酎 僽 怞 胄 噣 駎 軸 伷 呪 昼 詋 葤 籕 㑳 籒"},
    {50855952, 9, "臭 簉 溴 殠 憱 狊 糗 遚 臰"},
    {50855953, 20, "受 售 壽 獸 授 瘦 狩 綬 守 燾 譸 寿 垨 涭 膄 璹 嘼 䛵 嚋 鏉"},
    {50855954, 3, "肉 月 宍"},
    {50855955, 5, "奏 驟 揍 楱 㵵"},
    {50855956, 5, "湊 輳 腠 楱 凑"},
    {50855957, 10, "嗽 漱 擻 欶 廋 瘐 凁 廀 潄 瘶"},
    {50856192, 36, "又 右 幼 誘 佑 柚 釉 祐 有 莠 宥 侑 囿 鼬 卣 姷 狖 峟 貁 鴢 扰 牰 迶 岫 鈾 柪 珛 聈 袎 靿 褎 叹 唀 櫾 亴 酭"},
    {50856195, 3, "謬 繆 摎"},
    {50856199, 8, "拗 謬 粈 衄 糅 抝 衂 䋴"},
    {50856200, 19, "六 陸 溜 餾 霤 坴 翏 雡 廇 塯 蹓 遛 窌 飂 飉 鷚 澑 鬸 䄂"},
    {50856204, 33, "就 究 救 舊 舅 臼 柩 疚 咎 僦 鷲 廄 捄 慦 鯦 麔 晷 宄 閰 旧 柾 倃 粙 媨 厩 廐 廏 匶 匛 玐 䊆 齨 匓"},
    {50856206, 25, "秀 繡 鏽 袖 嗅 宿 臭 銹 琇 溴 岫 珛 玊 殠 褎 螑 綉 璓 褏 繍 鏅 鏥 齅 臰 嘼"},
    {50921472, 27, "暗 案 岸 按 黯 菴 闇 犴 豻 匼 桉 洝 荌 錌 匎 婩 儑 矸 晻 湆 噾 韽 垾 隌 遃 貋 䮗"},
    {50921473, 17, "半 辦 伴 扮 拌 絆 姅 瓣 爿 怑 湴 鉡 靽 畔 办 㫠 秚"},
    {50921474, 20, "判 叛 盼 畔 拚 袢 泮 襻 詊 頄 溿 沜 牉 頖 拌 盻 冸 炍 鑻 鋬"},
    {50921475, 25, "慢 漫 曼 蔓 幔 嫚 鏝 縵 墁 熳 澫 僈 獌 屘 饅 鰻 鄤 槾 蟃 謾 摱 蔄 澷 䕕 𤅎"},
    {50921476, 27, "範 范 犯 氾 汎 飯 販 泛 梵 畈 笵 鄤 奿 軓 軬 滼 嬔 反 汛 皈 汳 仮 盕 飰 輽 㽹 訉"},
    {50921477, 63, "但 旦 淡 蛋 誕 擔 彈 憚 氮 啖 澹 憺 儋 啗 噉 石 癉 窞 僤 贉 幨 霮 髧 萏 鉭 暺 柦 帎 潬 沊 狚 觛 啿 舕 蜑 嘾 鴠 癚 殫 灗 泹 怛 靼 妲 欻 嘽 餤 膻 嚪 繵 担 弹 惮 弾 腅 㗖 馾 醈 歘 駳 䨵 臽 䪴"},
    {50921478, 15, "探 嘆 歎 碳 炭 賧 埮 湠 羰 撢 舕 憛 䑙 舚 䗊"},
    {50921479, 3, "難 婻 戁"},
    {50921480, 19, "爛 濫 纜 爁 壏 婪 亂 瀾 僋 嚂 糷 乱 釠 瓓 爤 钄 㜮 燗 䌫"},
    {50921481, 26, "幹 贛 凎 淦 紺 旰 骭 詌 榦 灨 涻 嵅 盰 矸 涆 惍 菳 澣 螒 雗 鶾 汵 衦 倝 檊 贑"},
    {50921482, 10, "看 瞰 勘 闞 矙 磡 衎 墈 碪 譀"},
    {50921483, 61, "和 漢 汗 旱 焊 憾 翰 撼 悍 頷 扞 瀚 閈 捍 暵 熯 晥 犴 睅 菡 豻 銲 釬 駻 哻 涆 淊 馯 蜭 頜 螒 顄 雗 攌 譀 鋎 鶾 含 感 琀 筸 嫨 咊 浛 猂 莟 惒 皔 傼 蛿 睻 澏 蘫 屽 㢨 娨 晘 貋 㺖 𤳉 𦜆"},
    {50921487, 33, "佔 戰 站 暫 占 棧 顫 湛 綻 蹔 蘸 虥 轏 輚 偡 襢 枮 迠 蛅 鉆 辴 譧 驏 战 䋎 菚 椾 碊 嶘 覱 戦 𩥇 虦"},
    {50921488, 9, "懺 羼 儳 顫 讖 丳 嚵 硟 韂"},
    {50921489, 54, "善 扇 汕 擅 膳 繕 鄯 煽 訕 單 贍 疝 鱔 騸 禪 墠 嬗 掞 摲 謆 墡 釤 蟺 赸 儃 柵 奾 抎 氙 剡 搧 煔 嫸 撣 樿 橏 灗 鱣 单 単 栅 炶 銏 僐 熌 嶦 䱇 磰 蟮 譱 饍 鱓 㣌 傓"},
    {50921491, 22, "贊 暫 讚 鏨 瓚 酇 灒 囋 臢 劗 禶 賛 濽 鄼 櫕 瓉 鏩 讃 穳 襸 㔆 㜺"},
    {50921492, 12, "燦 孱 璨 粲 澯 摻 澶 掺 嘇 撡 薒 謲"},
    {50921493, 7, "散 閐 三 霰 鏾 弎 俕"},
    {50921728, 94, "驗 燕 厭 晏 雁 宴 淹 豔 燄 彥 堰 硯 咽 嚥 唁 饜 研 讌 諺 沿 讞 焱 釅 贗 喭 灩 爓 閆 鷃 嬿 鴳 醼 焰 牪 姲 鷰 椻 曣 婩 傿 鴈 噞 騴 觾 艷 驠 莚 敥 俺 涎 郾 筵 靨 魘 鹽 掞 淊 嵃 烻 猒 羡 楌 赩 靘 嬮 擫 酀 齴 妟 彦 偐 硏 隁 塩 鳫 墕 暥 嬊 㵪 㷼 曕 擪 騐 艶 贋 㬫 灔 灧 豓 覎 㷳 䢭 懕 囐"},
    {50921729, 27, "便 變 遍 辨 辯 汴 辮 忭 弁 釆 抃 緶 艑 卞 揙 汳 鴘 閞 犿 玣 苄 変 徧 辡 辧 昪 覍"},
    {50921730, 5, "片 騙 遍 徧 騗"},
    {50921731, 8, "面 麵 瞑 靣 牑 糆 麫 麪"},
    {50921733, 35, "電 店 殿 甸 奠 墊 澱 惦 靛 佃 淀 玷 鈿 簟 坫 痁 癜 磹 阽 扂 婝 踮 壂 唸 臀 掂 驔 埝 琔 頕 橂 𤩱 𠶧 𢕯 蜔"},
    {50921734, 6, "掭 煔 瑱 蚺 蚦 㐁"},
    {50921735, 8, "念 唸 淰 廿 鼰 廾 卄 埝"},
    {50921736, 30, "練 鍊 戀 煉 鏈 殮 斂 瀲 楝 襝 湅 澰 蘞 歛 薟 萰 堜 攣 僆 恋 挛 媡 㜃 瑓 錬 㶑 鰊 蘝 纞 稴"},
    {50921740, 93, "見 建 健 漸 件 間 監 鍵 鑑 箭 劍 艦 鑒 賤 踐 諫 毽 薦 餞 腱 濺 僭 檻 閒 洊 俴 牮 栫 楗 珔 瀳 澗 瞷 荐 諓 榗 糋 鰎 蔪 鋻 螹 襉 糮 鑳 峴 莧 筧 儉 韉 俔 娊 挸 涀 揵 湕 睍 廌 煡 犍 粯 葥 僣 摲 壏 覮 鞬 騝 轞 侟 倹 剣 悓 臶 㨴 劎 㵎 趝 劔 瞯 鍳 擶 繝 鏩 鐗 鐧 譼 韀 鑬 徤 旔 劒 踺 礀"},
    {50921741, 36, "欠 歉 倩 慊 茜 塹 芡 傔 嗛 槧 縴 篟 綪 棈 蒨 輤 嵌 謙 忺 咁 杴 欥 俔 婧 箐 靚 悓 婙 皘 艌 蔳 壍 嬱 肷 㟻 儙"},
    {50921742, 66, "縣 現 線 限 憲 獻 羨 陷 腺 餡 莧 霰 俔 僩 峴 晛 睍 豏 轞 涀 瀗 粯 娊 撊 錎 姭 先 見 賢 埳 淊 硍 羡 萏 窞 蜭 幰 攇 甗 巘 瓛 讞 咞 哯 垷 悓 軐 唺 絤 塪 献 蛿 䧟 僴 綫 膁 誢 橌 懢 麲 臔 藖 贒 臽 䱤 櫶"},
    {50921984, 25, "萬 玩 腕 惋 卍 翫 忨 仴 綄 万 蟃 捥 踠 曼 蔓 躉 杬 獌 輐 薍 卐 貦 䕕 贃 贎"},
    {50921989, 15, "段 斷 緞 鍛 毈 腶 籪 椴 葮 碫 躖 断 煅 瑖 塅"},
    {50921990, 3, "彖 褖 湪"},
    {50921992, 5, "亂 薍 乱 釠 灓"},
    {50921993, 31, "慣 貫 灌 罐 摜 盥 鸛 冠 觀 丱 爟 瓘 祼 矔 鑵 涫 悺 悹 雚 鱹 毌 懽 卝 泴 㮡 樌 罆 観 鏆 潅 遦"},
    {50921995, 36, "換 喚 宦 患 幻 煥 奐 渙 瘓 豢 梡 逭 擐 漶 垸 轘 瑍 觨 瞣 肒 圂 鋎 澣 鯇 攌 繯 梙 喛 愌 藧 鯶 鰀 烉 槵 𠈄 𤃬"},
    {50921999, 20, "傳 賺 篆 撰 譔 饌 轉 僎 瑑 縳 腞 篹 蟤 鐉 灷 堟 瑃 蒃 襈 籑"},
    {50922000, 7, "串 釧 玔 汌 夼 賗 腨"},
    {50922001, 3, "涮 諼 踹"},
    {50922003, 6, "賺 鑽 攥 揝 櫕 鑚"},
    {50922004, 9, "竄 篡 爨 篹 纂 攥 熶 簒 殩"},
    {50922005, 6, "算 蒜 筭 萛 匴 祘"},
    {50922240, 24, "院 願 怨 苑 遠 媛 瑗 愿 掾 褑 夗 謜 禐 噮 原 緣 妴 菀 夘 衏 縁 褤 厡 傆"},
    {50922252, 45, "倦 卷 眷 絹 雋 悁 狷 圈 獧 睊 睠 罥 鄄 帣 錈 腃 韏 鬳 弮 悛 牶 絭 菤 楗 臇 蠵 觿 鑴 驨 劵 巻 隽 淃 圏 瓹 飬 慻 㷷 襈 桊 䣺 餋 羂 觹 觽"},
    {50922253, 11, "勸 券 牶 烇 絭 圈 劝 勌 圏 勧 箞"},
    {50922254, 30, "炫 絢 漩 眩 泫 渲 旋 眴 楦 敻 鉉 衒 蔙 駽 鞙 鏇 昡 楥 袨 縼 讂 贙 陷 琄 怰 姰 䧟 夐 駨 繏"},
    {50987008, 1, "摁"},
    {50987009, 12, "笨 体 坌 奔 泍 捹 桳 犇 逩 撪 𦯀 獖"},
    {50987010, 3, "噴 歕 喯"},
    {50987011, 3, "悶 燜 懣"},
    {50987012, 31, "份 忿 奮 憤 分 糞 僨 瀵 坋 秎 魵 橨 膹 羵 拚 氛 焚 噴 墳 弅 幩 歕 坟 坆 奋 喯 燌 燓 隫 鱝 獖"},
    {50987013, 1, "㩐"},
    {50987015, 3, "嫩 腝 嫰"},
    {50987017, 6, "亙 艮 茛 閬 亘 珢"},
    {50987018, 5, "掯 硍 裉 啃 褃"},
    {50987019, 2, "恨 拫"},
    {50987023, 29, "鎮 陣 振 震 賑 朕 枕 鴆 揕 酖 眹 娠 侲 挋 栚 蜄 桭 誫 敶 陳 紖 瑱 迧 栕 軙 塦 鎭 䟴 𨦸"},
    {50987024, 16, "趁 稱 襯 櫬 讖 疢 齔 嚫 藽 儭 闖 称 趂 䚀 齓 穪"},
    {50987025, 24, "慎 腎 滲 甚 蜃 沁 葚 椹 脤 抻 侺 鋠 諶 偡 堔 煁 踸 鍖 昚 涁 眘 渗 趻 愼"},
    {50987026, 32, "任 認 刃 飪 賃 軔 衽 紉 妊 恁 仞 訒 韌 牣 鵀 屻 肕 軠 壬 紝 葚 銋 刄 忹 杒 姙 梕 絍 袵 鈓 靭 餁"},
    {50987027, 1, "譖"},
    {50987264, 33, "印 飲 隱 蔭 胤 廕 窨 憖 湚 垽 猌 朄 酳 音 陰 暈 阴 侌 洕 淾 隂 隠 憗 懚 鮣 乚 币 阥 茚 㥼 慭 䕃 癊"},
    {50987265, 12, "殯 鬢 儐 擯 臏 髕 鶣 賓 殡 賔 髩 鬂"},
    {50987266, 3, "聘 牝 騁"},
    {50987272, 16, "吝 躪 藺 賃 橉 閵 焛 淋 痳 遴 磷 臨 甐 鏻 恡 悋"},
    {50987276, 64, "進 近 盡 禁 晉 儘 浸 勁 覲 燼 廑 噤 靳 縉 僅 藎 妗 贐 寖 搢 肵 璡 賮 嬧 榗 僸 蓳 瘽 嚍 濜 璶 伒 溍 瑾 饉 坅 昑 枃 肣 埐 蚙 堇 祲 葝 鄑 靲 墐 戩 殣 澿 尽 晋 唫 厪 嫤 戬 瑨 馸 凚 歏 㯲 劤 濅 齽"},
    {50987277, 11, "沁 撳 唚 菣 嚫 吣 吢 㤈 抋 搇 臤"},
    {50987278, 19, "信 釁 芯 焮 舋 膷 囟 妡 煡 阠 蕈 庍 杋 訄 衅 訫 馸 顖 卂"},
    {50987520, 21, "問 聞 紊 文 汶 抆 免 搵 璺 妏 醞 蘊 脕 絻 鼤 顐 彣 渂 揾 醖 藴"},
    {50987525, 29, "頓 噸 盾 鈍 遁 盹 燉 沌 囤 遯 炖 坉 扽 伅 庉 潡 崸 鶨 腞 敦 飩 扥 楯 瞃 輴 鐓 踲 鐜 逇"},
    {50987526, 2, "褪 螁"},
    {50987527, 2, "嫩 嫰"},
    {50987528, 4, "論 溣 惀 碖"},
    {50987529, 6, "棍 璭 掍 睔 睴 謴"},
    {50987530, 9, "困 睏 涃 梱 悃 硱 碅 裍 㫻"},
    {50987531, 12, "混 渾 溷 諢 圂 慁 倱 梡 觨 緷 俒 焝"},
    {50987535, 2, "稕 訰"},
    {50987537, 9, "順 舜 瞬 蕣 鬊 瞚 馴 橓 瞤"},
    {50987538, 4, "潤 閏 橍 撋"},
    {50987539, 14, "俊 圳 捘 鱒 銌 燇 甽 晙 焌 畯 餕 㑺 儁 鵕"},
    {50987540, 3, "寸 吋 籿"},
    {50987541, 9, "潠 愻 孫 巽 遜 噀 巺 摌 顨"},
    {50987776, 36, "運 韻 孕 熨 蘊 慍 醞 惲 暈 韞 鄆 薀 枟 緷 鶤 員 均 熅 縕 賱 璭 餫 韗 貟 愠 煴 腪 韵 緼 蕰 醖 藴 鵾 运 䲰 鞰"},
    {50987788, 53, "俊 菌 郡 峻 竣 雋 濬 駿 蕈 浚 珺 畯 焌 捃 餕 箘 寯 晙 呁 鵘 葰 蔨 甽 璿 紃 朘 脧 莙 逡 踆 鵔 夋 侰 埈 陖 隽 㑺 睃 䇹 箟 儁 懏 𤀹 䕑 鵕 攈 攟 㖥 㕙 𣽊 𤩅 觹 觽"},
    {50987790, 28, "訊 訓 迅 遜 殉 馴 徇 巽 汛 蕈 噀 侚 潠 迿 孫 丮 阠 熏 伨 巺 狥 訙 奞 殾 賐 爋 顨 鑂"},
    {51052544, 4, "盎 醠 枊 㼜"},
    {51052545, 20, "棒 磅 謗 蚌 傍 鎊 旁 甏 塝 艕 徬 膀 玤 棓 蒡 蚄 嫎 髈 稖 蜯"},
    {51052546, 4, "胖 㕩 炐 肨"},
    {51052548, 1, "放"},
    {51052549, 28, "當 蕩 擋 盪 碭 宕 菪 逿 璗 愓 瓽 礑 簜 闣 檔 蟷 婸 崵 嵣 氹 圵 当 挡 偒 雼 瞊 趤 蘯"},
    {51052550, 5, "趟 燙 摥 盪 䠀"},
    {51052551, 2, "齉 儾"},
    {51052552, 5, "浪 埌 蒗 莨 閬"},
    {51052553, 7, "槓 杠 虹 摃 戇 焵 戅"},
    {51052554, 22, "亢 抗 炕 伉 匟 囥 犺 閌 邟 鈧 吭 沆 阬 斻 肮 苀 迒 笐 蚢 貥 魧 砊"},
    {51052555, 4, "行 沆 桁 苀"},
    {51052559, 24, "丈 仗 帳 障 賬 脹 杖 漲 長 幛 瘴 嶂 扙 瞕 粀 張 悵 仧 涱 痮 瘬 兏 镸 𢕔"},
    {51052560, 9, "唱 倡 暢 悵 鬯 韔 瑒 誯 畼"},
    {51052561, 8, "上 尚 爙 姠 仩 蠰 丄 尙"},
    {51052562, 4, "讓 懹 誏 瀼"},
    {51052563, 7, "藏 臟 葬 奘 塟 蔵 銺"},
    {51052564, 2, "䅮 賶"},
    {51052565, 1, "喪"},
    {51052800, 11, "樣 養 恙 漾 怏 煬 瀁 羕 様 諹 詇"},
    {51052807, 1, "釀"},
    {51052808, 16, "量 亮 諒 輛 喨 晾 涼 啢 踉 湸 悢 兩 倞 両 两 凉"},
    {51052812, 27, "降 匠 醬 強 將 絳 糨 洚 謽 嵹 彊 弶 袶 虹 漿 嶈 鏹 匞 夅 将 强 摾 滰 蔃 糡 弜 犟"},
    {51052813, 8, "嗆 羻 唴 熗 蹌 戧 蹡 摪"},
    {51052814, 36, "巷 向 相 像 項 象 橡 嚮 曏 蠁 萫 闀 蟓 襐 鐌 鄉 恦 潒 鱌 餉 樣 姠 晑 缿 銗 澒 珦 郷 鄊 鄕 銄 嶑 様 闂 鑜 勨"},
    {51053056, 9, "忘 妄 望 旺 王 朢 迋 莣 䤑"},
    {51053065, 6, "逛 桄 臩 臦 矌 櫎"},
    {51053066, 23, "況 礦 曠 框 眶 鄺 貺 壙 纊 絖 懭 爌 彉 怳 紖 軦 矌 况 眖 鋛 兤 鑛 黋"},
    {51053067, 12, "晃 軦 幌 榥 熀 鎤 晄 愰 㨪 櫎 岲 曂"},
    {51053071, 11, "狀 壯 撞 戇 焋 獞 壮 状 壵 漴 戅"},
    {51053072, 9, "創 闖 愴 刱 獊 凔 剏 剙 刽"},
    {51053073, 3, "灀 雙 双"},
    {51118081, 20, "蹦 搒 洴 迸 跰 泵 蚌 榜 磅 繃 堋 埲 塴 㧍 沯 埄 挷 逬 綳 蜯"},
    {51118082, 6, "碰 堋 掽 椪 踫 甏"},
    {51118083, 9, "夢 孟 霥 艋 梦 夣 懜 䓝 䁅"},
    {51118084, 16, "奉 鳳 俸 諷 縫 賵 焨 風 凤 凨 凬 煈 綘 鳯 鴌 凮"},
    {51118085, 17, "鄧 瞪 蹬 凳 嶝 磴 墱 邆 霯 澄 鐙 邓 僜 憕 隥 櫈 覴"},
    {51118087, 5, "濘 弄 挵 挊 𤀑"},
    {51118088, 5, "愣 踜 楞 怔 佂"},
    {51118089, 9, "更 亙 堩 埂 挭 浭 綆 亘 䱭"},
    {51118091, 6, "橫 啈 澋 絎 撔 横"},
    {51118095, 24, "鄭 正 證 政 証 症 掙 幀 諍 姃 炡 眐 罡 聇 晸 徎 憕 鋥 鴊 挣 䂻 䈣 㡧 𩏠"},
    {51118096, 7, "稱 秤 偁 牚 称 穪 靗"},
    {51118097, 22, "勝 盛 聖 剩 嵊 乘 賸 圣 貹 晟 檉 蟶 乗 晠 剰 椉 琞 墭 膡 蕂 垩 榺"},
    {51118098, 2, "扔 芿"},
    {51118099, 4, "贈 甑 繒 罾"},
    {51118100, 1, "蹭"},
    {51118336, 16, "應 硬 映 媵 瀅 鎣 摬 賏 迎 瀴 応 暎 膡 噟 譍 鞕"},
    {51118337, 26, "並 病 併 并 摒 寎 鵧 偋 柄 幵 庰 窉 㓈 幷 抦 倂 栤 竝 棅 逬 鈵 靐 开 傡 鮩 𢔧"},
    {51118338, 1, "聘"},
    {51118339, 3, "命 暝 詺"},
    {51118341, 20, "定 訂 釘 錠 碇 飣 娗 椗 掟 碠 顁 萣 啶 綻 靛 鋌 忊 矴 䋎 磸"},
    {51118342, 4, "聽 庭 聴 聼"},
    {51118343, 10, "濘 佞 寧 擰 獰 甯 寕 寜 寗 䗿"},
    {51118344, 6, "令 另 炩 旌 櫺 旍"},
    {51118348, 61, "敬 竟 鏡 靜 境 淨 競 逕 徑 靖 勁 凊 脛 痙 獍 倞 靚 竫 婧 桱 俓 凈 葝 擏 弳 莖 兢 請 檠 汫 肵 剄 挳 殌 牼 硜 羥 摬 誙 儆 樈 憼 璥 蟼 妌 径 浄 茎 梷 竧 傹 滰 誩 踁 静 䃘 曔 㯳 瀞 竸 净"},
    {51118349, 21, "慶 罄 親 凊 綮 謦 磬 漀 汫 鑋 靘 掅 碃 罊 請 蟿 羻 亲 媇 濪 殸"},
    {51118350, 17, "行 興 性 幸 姓 杏 倖 悻 荇 婞 莕 涬 啈 矎 緈 嬹 臖"},
    {51118592, 4, "甕 瓮 齆 罋"},
    {51118596, 1, "甮"},
    {51118597, 22, "動 洞 凍 棟 恫 胴 挏 戙 駧 霘 峒 湩 慟 姛 迵 詷 蝀 动 峝 働 勭 憅"},
    {51118598, 6, "痛 衕 慟 蘳 疼 憅"},
    {51118599, 3, "弄 挵 挊"},
    {51118600, 11, "衖 哢 徿 梇 弄 咔 挵 硦 贚 挊 㟖"},
    {51118601, 16, "共 供 貢 羾 摃 贛 烡 珙 舼 嗊 幊 愩 輁 輂 觨 篢"},
    {51118602, 4, "空 控 鞚 羫"},
    {51118603, 9, "鬨 汞 澒 蕻 鍙 訌 澋 閧 闂"},
    {51118607, 29, "中 種 重 仲 眾 尰 湩 狆 衶 偅 堹 緟 粽 祌 种 潀 众 蚛 媑 筗 衆 糉 諥 灇 乑 妕 茽 潨 褈"},
    {51118608, 5, "衝 銃 揰 尰 瘇"},
    {51118610, 1, "縙"},
    {51118611, 16, "縱 粽 綜 從 瘲 昮 錝 从 従 碂 糉 縦 苁 倊 猔 䝋"},
    {51118612, 3, "欉 藂 謥"},
    {51118613, 7, "送 宋 頌 訟 誦 㕬 餸"},
    {51118848, 6, "用 佣 醟 傭 禜 苚"},
    {51118860, 1, "澃"},
    {51118862, 4, "敻 詗 焸 夐"},
    {51183616, 15, "二 貳 佴 刵 咡 樲 聏 毦 眲 衈 鉺 弍 㛅 貮 誀"},
    {67108864, 1, "˙"},
    {67108877, 1, "啐"},
    {67108881, 2, "匙 實"},
    {67108883, 1, "子"},
    {67109125, 1, "弟"},
    {67109128, 3, "哩 裡 娌"},
    {67109134, 1, "西"},
    {67109377, 1, "不"},
    {67109384, 1, "蘆"},
    {67109392, 1, "出"},
    {67109393, 1, "叔"},
    {67109645, 1, "去"},
    {67174400, 1, "啊"},
    {67174401, 7, "吧 罷 琶 杷 罢 欛 爸"},
    {67174402, 3, "杷 琶 欛"},
    {67174403, 9, "嘛 嗎 媽 嬤 蟆 麼 尛 麽 蟇"},
    {67174405, 5, "疸 瘩 咑 打 繨"},
    {67174406, 1, "遢"},
    {67174407, 3, "那 哪 㖠"},
    {67174408, 3, "啦 藍 瘌"},
    {67174409, 2, "價 価"},
    {67174415, 1, "蚱"},
    {67174421, 3, "挲 薩 挱"},
    {67174656, 1, "呀"},
    {67174912, 1, "哇"},
    {67239937, 5, "伯 菔 蔔 啵 膊"},
    {67239939, 1, "麼"},
    {67239944, 1, "咯"},
    {67240192, 1, "嚛"},
    {67240457, 2, "過 过"},
    {67240459, 4, "和 午 咊 惒"},
    {67305475, 4, "麼 嚜 尛 麽"},
    {67305477, 10, "的 得 地 底 襶 坔 埊 嶳 𢔨 𢔶"},
    {67305479, 1, "呢"},
    {67305480, 2, "了 嘞"},
    {67305481, 4, "個 箇 个 亇"},
    {67305487, 5, "著 遮 晢 嫬 着"},
    {67371264, 1, "吔"},
    {67371269, 1, "爹"},
    {67371276, 1, "姊"},
    {67371278, 1, "謝"},
    {67436563, 1, "在"},
    {67502081, 1, "唄"},
    {67502083, 1, "妹"},
    {67567622, 1, "萄"},
    {67633158, 2, "頭 头"},
    {67633160, 1, "嘍"},
    {67633163, 1, "候"},
    {67633416, 3, "溜 榴 橊"},
    {67633420, 1, "舅"},
    {67764227, 1, "們"},
    {67764241, 1, "嬸"},
    {67829764, 1, "坊"},
    {67829765, 1, "噹"},
    {67829767, 1, "囔"},
    {67829768, 1, "螂"},
    {67829777, 1, "裳"},
    {67830016, 1, "樣"},
    {67830283, 1, "慌"},
    {67895307, 1, "慌"},
    {67895815, 1, "弄"}
};
