//*****************************************************************************
//                               CmdGnuCapTR.hpp                              *
//                              -----------------                             *
// Description : This class contains values associated with the GNU-Cap       *
//               TRANSIENT command. It inherits from the class CmdBase.       *
// Started     : 07/03/2008                                                   *
// Last Update : 24/12/2010                                                   *
// Copyright   : (C) 2008 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDGCPTR_HPP
#define CMDGCPTR_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "ngspice/commands/CmdNgSpiceTR.hpp"
#include "utility/ConvertType.hpp"

struct CmdNgSpiceTR;

// Local Macro and Constant Declarations


//*****************************************************************************

struct CmdGnuCapTR : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    wxString    m_osStart;  // The sweep start value
    wxString    m_osStop;   // The sweep stop  value
    wxString    m_osStep;   // The sweep step  value
    eInitCType  m_eInitC;   // The sweep scale type
    wxString    m_osTempC;  // The analysis temperature

              CmdGnuCapTR( void );
    virtual  ~CmdGnuCapTR( );

    virtual  bool  bSetDefaults( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    CmdGnuCapTR & operator = ( const CmdNgSpiceTR & roCmdTR );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDGCPTR_HPP
