// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/dialogflow/v2/participant.proto

package dialogflow

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/anypb"
	_ "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enumeration of the roles a participant can play in a conversation.
type Participant_Role int32

const (
	// Participant role not set.
	Participant_ROLE_UNSPECIFIED Participant_Role = 0
	// Participant is a human agent.
	Participant_HUMAN_AGENT Participant_Role = 1
	// Participant is an automated agent, such as a Dialogflow agent.
	Participant_AUTOMATED_AGENT Participant_Role = 2
	// Participant is an end user that has called or chatted with
	// Dialogflow services.
	Participant_END_USER Participant_Role = 3
)

// Enum value maps for Participant_Role.
var (
	Participant_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "HUMAN_AGENT",
		2: "AUTOMATED_AGENT",
		3: "END_USER",
	}
	Participant_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"HUMAN_AGENT":      1,
		"AUTOMATED_AGENT":  2,
		"END_USER":         3,
	}
)

func (x Participant_Role) Enum() *Participant_Role {
	p := new(Participant_Role)
	*p = x
	return p
}

func (x Participant_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Participant_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_participant_proto_enumTypes[0].Descriptor()
}

func (Participant_Role) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_participant_proto_enumTypes[0]
}

func (x Participant_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Participant_Role.Descriptor instead.
func (Participant_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{0, 0}
}

// Represents different automated agent reply types.
type AutomatedAgentReply_AutomatedAgentReplyType int32

const (
	// Not specified. This should never happen.
	AutomatedAgentReply_AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED AutomatedAgentReply_AutomatedAgentReplyType = 0
	// Partial reply. e.g. Aggregated responses in a `Fulfillment` that enables
	// `return_partial_response` can be returned as partial reply.
	// WARNING: partial reply is not eligible for barge-in.
	AutomatedAgentReply_PARTIAL AutomatedAgentReply_AutomatedAgentReplyType = 1
	// Final reply.
	AutomatedAgentReply_FINAL AutomatedAgentReply_AutomatedAgentReplyType = 2
)

// Enum value maps for AutomatedAgentReply_AutomatedAgentReplyType.
var (
	AutomatedAgentReply_AutomatedAgentReplyType_name = map[int32]string{
		0: "AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED",
		1: "PARTIAL",
		2: "FINAL",
	}
	AutomatedAgentReply_AutomatedAgentReplyType_value = map[string]int32{
		"AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED": 0,
		"PARTIAL":                                1,
		"FINAL":                                  2,
	}
)

func (x AutomatedAgentReply_AutomatedAgentReplyType) Enum() *AutomatedAgentReply_AutomatedAgentReplyType {
	p := new(AutomatedAgentReply_AutomatedAgentReplyType)
	*p = x
	return p
}

func (x AutomatedAgentReply_AutomatedAgentReplyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutomatedAgentReply_AutomatedAgentReplyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_participant_proto_enumTypes[1].Descriptor()
}

func (AutomatedAgentReply_AutomatedAgentReplyType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_participant_proto_enumTypes[1]
}

func (x AutomatedAgentReply_AutomatedAgentReplyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutomatedAgentReply_AutomatedAgentReplyType.Descriptor instead.
func (AutomatedAgentReply_AutomatedAgentReplyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{15, 0}
}

// Represents a conversation participant (human agent, virtual agent, end-user).
type Participant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of this participant.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The role this participant plays in the conversation. This field must be set
	// during participant creation and is then immutable.
	Role Participant_Role `protobuf:"varint,2,opt,name=role,proto3,enum=google.cloud.dialogflow.v2.Participant_Role" json:"role,omitempty"`
	// Optional. Label applied to streams representing this participant in SIPREC
	// XML metadata and SDP. This is used to assign transcriptions from that
	// media stream to this participant. This field can be updated.
	SipRecordingMediaLabel string `protobuf:"bytes,6,opt,name=sip_recording_media_label,json=sipRecordingMediaLabel,proto3" json:"sip_recording_media_label,omitempty"`
}

func (x *Participant) Reset() {
	*x = Participant{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Participant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Participant) ProtoMessage() {}

func (x *Participant) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Participant.ProtoReflect.Descriptor instead.
func (*Participant) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{0}
}

func (x *Participant) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Participant) GetRole() Participant_Role {
	if x != nil {
		return x.Role
	}
	return Participant_ROLE_UNSPECIFIED
}

func (x *Participant) GetSipRecordingMediaLabel() string {
	if x != nil {
		return x.SipRecordingMediaLabel
	}
	return ""
}

// Represents a message posted into a conversation.
type Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the message.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The message content.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Optional. The message language.
	// This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
	// language tag. Example: "en-US".
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Output only. The participant that sends this message.
	Participant string `protobuf:"bytes,4,opt,name=participant,proto3" json:"participant,omitempty"`
	// Output only. The role of the participant.
	ParticipantRole Participant_Role `protobuf:"varint,5,opt,name=participant_role,json=participantRole,proto3,enum=google.cloud.dialogflow.v2.Participant_Role" json:"participant_role,omitempty"`
	// Output only. The time when the message was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The annotation for the message.
	MessageAnnotation *MessageAnnotation `protobuf:"bytes,7,opt,name=message_annotation,json=messageAnnotation,proto3" json:"message_annotation,omitempty"`
}

func (x *Message) Reset() {
	*x = Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Message) ProtoMessage() {}

func (x *Message) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Message.ProtoReflect.Descriptor instead.
func (*Message) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{1}
}

func (x *Message) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Message) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *Message) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Message) GetParticipant() string {
	if x != nil {
		return x.Participant
	}
	return ""
}

func (x *Message) GetParticipantRole() Participant_Role {
	if x != nil {
		return x.ParticipantRole
	}
	return Participant_ROLE_UNSPECIFIED
}

func (x *Message) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Message) GetMessageAnnotation() *MessageAnnotation {
	if x != nil {
		return x.MessageAnnotation
	}
	return nil
}

// The request message for [Participants.CreateParticipant][google.cloud.dialogflow.v2.Participants.CreateParticipant].
type CreateParticipantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource identifier of the conversation adding the participant.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The participant to create.
	Participant *Participant `protobuf:"bytes,2,opt,name=participant,proto3" json:"participant,omitempty"`
}

func (x *CreateParticipantRequest) Reset() {
	*x = CreateParticipantRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateParticipantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateParticipantRequest) ProtoMessage() {}

func (x *CreateParticipantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateParticipantRequest.ProtoReflect.Descriptor instead.
func (*CreateParticipantRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{2}
}

func (x *CreateParticipantRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateParticipantRequest) GetParticipant() *Participant {
	if x != nil {
		return x.Participant
	}
	return nil
}

// The request message for [Participants.GetParticipant][google.cloud.dialogflow.v2.Participants.GetParticipant].
type GetParticipantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant. Format:
	// `projects/<Project ID>/locations/<Location ID>/conversations/<Conversation
	// ID>/participants/<Participant ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetParticipantRequest) Reset() {
	*x = GetParticipantRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetParticipantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetParticipantRequest) ProtoMessage() {}

func (x *GetParticipantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetParticipantRequest.ProtoReflect.Descriptor instead.
func (*GetParticipantRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{3}
}

func (x *GetParticipantRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for [Participants.ListParticipants][google.cloud.dialogflow.v2.Participants.ListParticipants].
type ListParticipantsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation to list all participants from.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListParticipantsRequest) Reset() {
	*x = ListParticipantsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListParticipantsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListParticipantsRequest) ProtoMessage() {}

func (x *ListParticipantsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListParticipantsRequest.ProtoReflect.Descriptor instead.
func (*ListParticipantsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{4}
}

func (x *ListParticipantsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListParticipantsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListParticipantsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for [Participants.ListParticipants][google.cloud.dialogflow.v2.Participants.ListParticipants].
type ListParticipantsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of participants. There is a maximum number of items
	// returned based on the page_size field in the request.
	Participants []*Participant `protobuf:"bytes,1,rep,name=participants,proto3" json:"participants,omitempty"`
	// Token to retrieve the next page of results or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListParticipantsResponse) Reset() {
	*x = ListParticipantsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListParticipantsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListParticipantsResponse) ProtoMessage() {}

func (x *ListParticipantsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListParticipantsResponse.ProtoReflect.Descriptor instead.
func (*ListParticipantsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{5}
}

func (x *ListParticipantsResponse) GetParticipants() []*Participant {
	if x != nil {
		return x.Participants
	}
	return nil
}

func (x *ListParticipantsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for [Participants.UpdateParticipant][google.cloud.dialogflow.v2.Participants.UpdateParticipant].
type UpdateParticipantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The participant to update.
	Participant *Participant `protobuf:"bytes,1,opt,name=participant,proto3" json:"participant,omitempty"`
	// Required. The mask to specify which fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateParticipantRequest) Reset() {
	*x = UpdateParticipantRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateParticipantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateParticipantRequest) ProtoMessage() {}

func (x *UpdateParticipantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateParticipantRequest.ProtoReflect.Descriptor instead.
func (*UpdateParticipantRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateParticipantRequest) GetParticipant() *Participant {
	if x != nil {
		return x.Participant
	}
	return nil
}

func (x *UpdateParticipantRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for [Participants.AnalyzeContent][google.cloud.dialogflow.v2.Participants.AnalyzeContent].
type AnalyzeContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant this text comes from.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Participant string `protobuf:"bytes,1,opt,name=participant,proto3" json:"participant,omitempty"`
	// Required. The input content.
	//
	// Types that are assignable to Input:
	//	*AnalyzeContentRequest_TextInput
	//	*AnalyzeContentRequest_EventInput
	Input isAnalyzeContentRequest_Input `protobuf_oneof:"input"`
	// Speech synthesis configuration.
	// The speech synthesis settings for a virtual agent that may be configured
	// for the associated conversation profile are not used when calling
	// AnalyzeContent. If this configuration is not supplied, speech synthesis
	// is disabled.
	ReplyAudioConfig *OutputAudioConfig `protobuf:"bytes,5,opt,name=reply_audio_config,json=replyAudioConfig,proto3" json:"reply_audio_config,omitempty"`
	// Parameters for a Dialogflow virtual-agent query.
	QueryParams *QueryParameters `protobuf:"bytes,9,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// A unique identifier for this request. Restricted to 36 ASCII characters.
	// A random UUID is recommended.
	// This request is only idempotent if a `request_id` is provided.
	RequestId string `protobuf:"bytes,11,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *AnalyzeContentRequest) Reset() {
	*x = AnalyzeContentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeContentRequest) ProtoMessage() {}

func (x *AnalyzeContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeContentRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeContentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{7}
}

func (x *AnalyzeContentRequest) GetParticipant() string {
	if x != nil {
		return x.Participant
	}
	return ""
}

func (m *AnalyzeContentRequest) GetInput() isAnalyzeContentRequest_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (x *AnalyzeContentRequest) GetTextInput() *TextInput {
	if x, ok := x.GetInput().(*AnalyzeContentRequest_TextInput); ok {
		return x.TextInput
	}
	return nil
}

func (x *AnalyzeContentRequest) GetEventInput() *EventInput {
	if x, ok := x.GetInput().(*AnalyzeContentRequest_EventInput); ok {
		return x.EventInput
	}
	return nil
}

func (x *AnalyzeContentRequest) GetReplyAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.ReplyAudioConfig
	}
	return nil
}

func (x *AnalyzeContentRequest) GetQueryParams() *QueryParameters {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *AnalyzeContentRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

type isAnalyzeContentRequest_Input interface {
	isAnalyzeContentRequest_Input()
}

type AnalyzeContentRequest_TextInput struct {
	// The natural language text to be processed.
	TextInput *TextInput `protobuf:"bytes,6,opt,name=text_input,json=textInput,proto3,oneof"`
}

type AnalyzeContentRequest_EventInput struct {
	// An input event to send to Dialogflow.
	EventInput *EventInput `protobuf:"bytes,8,opt,name=event_input,json=eventInput,proto3,oneof"`
}

func (*AnalyzeContentRequest_TextInput) isAnalyzeContentRequest_Input() {}

func (*AnalyzeContentRequest_EventInput) isAnalyzeContentRequest_Input() {}

// The message in the response that indicates the parameters of DTMF.
type DtmfParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether DTMF input can be handled in the next request.
	AcceptsDtmfInput bool `protobuf:"varint,1,opt,name=accepts_dtmf_input,json=acceptsDtmfInput,proto3" json:"accepts_dtmf_input,omitempty"`
}

func (x *DtmfParameters) Reset() {
	*x = DtmfParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DtmfParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DtmfParameters) ProtoMessage() {}

func (x *DtmfParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DtmfParameters.ProtoReflect.Descriptor instead.
func (*DtmfParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{8}
}

func (x *DtmfParameters) GetAcceptsDtmfInput() bool {
	if x != nil {
		return x.AcceptsDtmfInput
	}
	return false
}

// The response message for [Participants.AnalyzeContent][google.cloud.dialogflow.v2.Participants.AnalyzeContent].
type AnalyzeContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output text content.
	// This field is set if the automated agent responded with text to show to
	// the user.
	ReplyText string `protobuf:"bytes,1,opt,name=reply_text,json=replyText,proto3" json:"reply_text,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// This field is set if:
	//
	//  - `reply_audio_config` was specified in the request, or
	//  - The automated agent responded with audio to play to the user. In such
	//    case, `reply_audio.config` contains settings used to synthesize the
	//    speech.
	//
	// In some scenarios, multiple output audio fields may be present in the
	// response structure. In these cases, only the top-most-level audio output
	// has content.
	ReplyAudio *OutputAudio `protobuf:"bytes,2,opt,name=reply_audio,json=replyAudio,proto3" json:"reply_audio,omitempty"`
	// Only set if a Dialogflow automated agent has responded.
	// Note that: [AutomatedAgentReply.detect_intent_response.output_audio][]
	// and [AutomatedAgentReply.detect_intent_response.output_audio_config][]
	// are always empty, use [reply_audio][google.cloud.dialogflow.v2.AnalyzeContentResponse.reply_audio] instead.
	AutomatedAgentReply *AutomatedAgentReply `protobuf:"bytes,3,opt,name=automated_agent_reply,json=automatedAgentReply,proto3" json:"automated_agent_reply,omitempty"`
	// Message analyzed by CCAI.
	Message *Message `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	// The suggestions for most recent human agent. The order is the same as
	// [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionConfig.feature_configs] of
	// [HumanAgentAssistantConfig.human_agent_suggestion_config][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.human_agent_suggestion_config].
	HumanAgentSuggestionResults []*SuggestionResult `protobuf:"bytes,6,rep,name=human_agent_suggestion_results,json=humanAgentSuggestionResults,proto3" json:"human_agent_suggestion_results,omitempty"`
	// The suggestions for end user. The order is the same as
	// [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionConfig.feature_configs] of
	// [HumanAgentAssistantConfig.end_user_suggestion_config][google.cloud.dialogflow.v2.HumanAgentAssistantConfig.end_user_suggestion_config].
	EndUserSuggestionResults []*SuggestionResult `protobuf:"bytes,7,rep,name=end_user_suggestion_results,json=endUserSuggestionResults,proto3" json:"end_user_suggestion_results,omitempty"`
	// Indicates the parameters of DTMF.
	DtmfParameters *DtmfParameters `protobuf:"bytes,9,opt,name=dtmf_parameters,json=dtmfParameters,proto3" json:"dtmf_parameters,omitempty"`
}

func (x *AnalyzeContentResponse) Reset() {
	*x = AnalyzeContentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeContentResponse) ProtoMessage() {}

func (x *AnalyzeContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeContentResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeContentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{9}
}

func (x *AnalyzeContentResponse) GetReplyText() string {
	if x != nil {
		return x.ReplyText
	}
	return ""
}

func (x *AnalyzeContentResponse) GetReplyAudio() *OutputAudio {
	if x != nil {
		return x.ReplyAudio
	}
	return nil
}

func (x *AnalyzeContentResponse) GetAutomatedAgentReply() *AutomatedAgentReply {
	if x != nil {
		return x.AutomatedAgentReply
	}
	return nil
}

func (x *AnalyzeContentResponse) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *AnalyzeContentResponse) GetHumanAgentSuggestionResults() []*SuggestionResult {
	if x != nil {
		return x.HumanAgentSuggestionResults
	}
	return nil
}

func (x *AnalyzeContentResponse) GetEndUserSuggestionResults() []*SuggestionResult {
	if x != nil {
		return x.EndUserSuggestionResults
	}
	return nil
}

func (x *AnalyzeContentResponse) GetDtmfParameters() *DtmfParameters {
	if x != nil {
		return x.DtmfParameters
	}
	return nil
}

// The request message for [Participants.SuggestArticles][google.cloud.dialogflow.v2.Participants.SuggestArticles].
type SuggestArticlesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant to fetch suggestion for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The name of the latest conversation message to compile suggestion
	// for. If empty, it will be the latest message of the conversation.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Max number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2.SuggestArticlesRequest.latest_message] to use as context
	// when compiling the suggestion. By default 20 and at most 50.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *SuggestArticlesRequest) Reset() {
	*x = SuggestArticlesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuggestArticlesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestArticlesRequest) ProtoMessage() {}

func (x *SuggestArticlesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestArticlesRequest.ProtoReflect.Descriptor instead.
func (*SuggestArticlesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{10}
}

func (x *SuggestArticlesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SuggestArticlesRequest) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestArticlesRequest) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// The response message for [Participants.SuggestArticles][google.cloud.dialogflow.v2.Participants.SuggestArticles].
type SuggestArticlesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Articles ordered by score in descending order.
	ArticleAnswers []*ArticleAnswer `protobuf:"bytes,1,rep,name=article_answers,json=articleAnswers,proto3" json:"article_answers,omitempty"`
	// The name of the latest conversation message used to compile
	// suggestion for.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2.SuggestArticlesResponse.latest_message] to compile the
	// suggestion. It may be smaller than the
	// [SuggestArticlesRequest.context_size][google.cloud.dialogflow.v2.SuggestArticlesRequest.context_size] field in the request if there
	// aren't that many messages in the conversation.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *SuggestArticlesResponse) Reset() {
	*x = SuggestArticlesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuggestArticlesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestArticlesResponse) ProtoMessage() {}

func (x *SuggestArticlesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestArticlesResponse.ProtoReflect.Descriptor instead.
func (*SuggestArticlesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{11}
}

func (x *SuggestArticlesResponse) GetArticleAnswers() []*ArticleAnswer {
	if x != nil {
		return x.ArticleAnswers
	}
	return nil
}

func (x *SuggestArticlesResponse) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestArticlesResponse) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// The request message for [Participants.SuggestFaqAnswers][google.cloud.dialogflow.v2.Participants.SuggestFaqAnswers].
type SuggestFaqAnswersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant to fetch suggestion for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The name of the latest conversation message to compile suggestion
	// for. If empty, it will be the latest message of the conversation.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Max number of messages prior to and including
	// [latest_message] to use as context when compiling the
	// suggestion. By default 20 and at most 50.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *SuggestFaqAnswersRequest) Reset() {
	*x = SuggestFaqAnswersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuggestFaqAnswersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestFaqAnswersRequest) ProtoMessage() {}

func (x *SuggestFaqAnswersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestFaqAnswersRequest.ProtoReflect.Descriptor instead.
func (*SuggestFaqAnswersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{12}
}

func (x *SuggestFaqAnswersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SuggestFaqAnswersRequest) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestFaqAnswersRequest) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// The request message for [Participants.SuggestFaqAnswers][google.cloud.dialogflow.v2.Participants.SuggestFaqAnswers].
type SuggestFaqAnswersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Answers extracted from FAQ documents.
	FaqAnswers []*FaqAnswer `protobuf:"bytes,1,rep,name=faq_answers,json=faqAnswers,proto3" json:"faq_answers,omitempty"`
	// The name of the latest conversation message used to compile
	// suggestion for.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.latest_message] to compile the
	// suggestion. It may be smaller than the
	// [SuggestFaqAnswersRequest.context_size][google.cloud.dialogflow.v2.SuggestFaqAnswersRequest.context_size] field in the request if there
	// aren't that many messages in the conversation.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *SuggestFaqAnswersResponse) Reset() {
	*x = SuggestFaqAnswersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuggestFaqAnswersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestFaqAnswersResponse) ProtoMessage() {}

func (x *SuggestFaqAnswersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestFaqAnswersResponse.ProtoReflect.Descriptor instead.
func (*SuggestFaqAnswersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{13}
}

func (x *SuggestFaqAnswersResponse) GetFaqAnswers() []*FaqAnswer {
	if x != nil {
		return x.FaqAnswers
	}
	return nil
}

func (x *SuggestFaqAnswersResponse) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestFaqAnswersResponse) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// Represents the natural language speech audio to be played to the end user.
type OutputAudio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instructs the speech synthesizer how to generate the speech
	// audio.
	Config *OutputAudioConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// The natural language speech audio.
	Audio []byte `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
}

func (x *OutputAudio) Reset() {
	*x = OutputAudio{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputAudio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputAudio) ProtoMessage() {}

func (x *OutputAudio) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputAudio.ProtoReflect.Descriptor instead.
func (*OutputAudio) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{14}
}

func (x *OutputAudio) GetConfig() *OutputAudioConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *OutputAudio) GetAudio() []byte {
	if x != nil {
		return x.Audio
	}
	return nil
}

// Represents a response from an automated agent.
type AutomatedAgentReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Response of the Dialogflow [Sessions.DetectIntent][google.cloud.dialogflow.v2.Sessions.DetectIntent] call.
	DetectIntentResponse *DetectIntentResponse `protobuf:"bytes,1,opt,name=detect_intent_response,json=detectIntentResponse,proto3" json:"detect_intent_response,omitempty"`
	// AutomatedAgentReply type.
	AutomatedAgentReplyType AutomatedAgentReply_AutomatedAgentReplyType `protobuf:"varint,7,opt,name=automated_agent_reply_type,json=automatedAgentReplyType,proto3,enum=google.cloud.dialogflow.v2.AutomatedAgentReply_AutomatedAgentReplyType" json:"automated_agent_reply_type,omitempty"`
	// Indicates whether the partial automated agent reply is interruptible when a
	// later reply message arrives. e.g. if the agent specified some music as
	// partial response, it can be cancelled.
	AllowCancellation bool `protobuf:"varint,8,opt,name=allow_cancellation,json=allowCancellation,proto3" json:"allow_cancellation,omitempty"`
}

func (x *AutomatedAgentReply) Reset() {
	*x = AutomatedAgentReply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutomatedAgentReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomatedAgentReply) ProtoMessage() {}

func (x *AutomatedAgentReply) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomatedAgentReply.ProtoReflect.Descriptor instead.
func (*AutomatedAgentReply) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{15}
}

func (x *AutomatedAgentReply) GetDetectIntentResponse() *DetectIntentResponse {
	if x != nil {
		return x.DetectIntentResponse
	}
	return nil
}

func (x *AutomatedAgentReply) GetAutomatedAgentReplyType() AutomatedAgentReply_AutomatedAgentReplyType {
	if x != nil {
		return x.AutomatedAgentReplyType
	}
	return AutomatedAgentReply_AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED
}

func (x *AutomatedAgentReply) GetAllowCancellation() bool {
	if x != nil {
		return x.AllowCancellation
	}
	return false
}

// Represents article answer.
type ArticleAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The article title.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// The article URI.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Article snippets.
	Snippets []string `protobuf:"bytes,3,rep,name=snippets,proto3" json:"snippets,omitempty"`
	// Article match confidence.
	// The system's confidence score that this article is a good match for this
	// conversation, as a value from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// A map that contains metadata about the answer and the
	// document from which it originates.
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of answer record, in the format of
	// "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer Record
	// ID>"
	AnswerRecord string `protobuf:"bytes,6,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *ArticleAnswer) Reset() {
	*x = ArticleAnswer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArticleAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArticleAnswer) ProtoMessage() {}

func (x *ArticleAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArticleAnswer.ProtoReflect.Descriptor instead.
func (*ArticleAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{16}
}

func (x *ArticleAnswer) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *ArticleAnswer) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ArticleAnswer) GetSnippets() []string {
	if x != nil {
		return x.Snippets
	}
	return nil
}

func (x *ArticleAnswer) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *ArticleAnswer) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ArticleAnswer) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

// Represents answer from "frequently asked questions".
type FaqAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The piece of text from the `source` knowledge base document.
	Answer string `protobuf:"bytes,1,opt,name=answer,proto3" json:"answer,omitempty"`
	// The system's confidence score that this Knowledge answer is a good match
	// for this conversational query, range from 0.0 (completely uncertain)
	// to 1.0 (completely certain).
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// The corresponding FAQ question.
	Question string `protobuf:"bytes,3,opt,name=question,proto3" json:"question,omitempty"`
	// Indicates which Knowledge Document this answer was extracted
	// from.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/agent/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`.
	Source string `protobuf:"bytes,4,opt,name=source,proto3" json:"source,omitempty"`
	// A map that contains metadata about the answer and the
	// document from which it originates.
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of answer record, in the format of
	// "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer Record
	// ID>"
	AnswerRecord string `protobuf:"bytes,6,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *FaqAnswer) Reset() {
	*x = FaqAnswer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FaqAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaqAnswer) ProtoMessage() {}

func (x *FaqAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaqAnswer.ProtoReflect.Descriptor instead.
func (*FaqAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{17}
}

func (x *FaqAnswer) GetAnswer() string {
	if x != nil {
		return x.Answer
	}
	return ""
}

func (x *FaqAnswer) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *FaqAnswer) GetQuestion() string {
	if x != nil {
		return x.Question
	}
	return ""
}

func (x *FaqAnswer) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *FaqAnswer) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *FaqAnswer) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

// One response of different type of suggestion response which is used in
// the response of [Participants.AnalyzeContent][google.cloud.dialogflow.v2.Participants.AnalyzeContent] and
// [Participants.AnalyzeContent][google.cloud.dialogflow.v2.Participants.AnalyzeContent], as well as [HumanAgentAssistantEvent][google.cloud.dialogflow.v2.HumanAgentAssistantEvent].
type SuggestionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Different type of suggestion response.
	//
	// Types that are assignable to SuggestionResponse:
	//	*SuggestionResult_Error
	//	*SuggestionResult_SuggestArticlesResponse
	//	*SuggestionResult_SuggestFaqAnswersResponse
	SuggestionResponse isSuggestionResult_SuggestionResponse `protobuf_oneof:"suggestion_response"`
}

func (x *SuggestionResult) Reset() {
	*x = SuggestionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuggestionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestionResult) ProtoMessage() {}

func (x *SuggestionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestionResult.ProtoReflect.Descriptor instead.
func (*SuggestionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{18}
}

func (m *SuggestionResult) GetSuggestionResponse() isSuggestionResult_SuggestionResponse {
	if m != nil {
		return m.SuggestionResponse
	}
	return nil
}

func (x *SuggestionResult) GetError() *status.Status {
	if x, ok := x.GetSuggestionResponse().(*SuggestionResult_Error); ok {
		return x.Error
	}
	return nil
}

func (x *SuggestionResult) GetSuggestArticlesResponse() *SuggestArticlesResponse {
	if x, ok := x.GetSuggestionResponse().(*SuggestionResult_SuggestArticlesResponse); ok {
		return x.SuggestArticlesResponse
	}
	return nil
}

func (x *SuggestionResult) GetSuggestFaqAnswersResponse() *SuggestFaqAnswersResponse {
	if x, ok := x.GetSuggestionResponse().(*SuggestionResult_SuggestFaqAnswersResponse); ok {
		return x.SuggestFaqAnswersResponse
	}
	return nil
}

type isSuggestionResult_SuggestionResponse interface {
	isSuggestionResult_SuggestionResponse()
}

type SuggestionResult_Error struct {
	// Error status if the request failed.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type SuggestionResult_SuggestArticlesResponse struct {
	// SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
	SuggestArticlesResponse *SuggestArticlesResponse `protobuf:"bytes,2,opt,name=suggest_articles_response,json=suggestArticlesResponse,proto3,oneof"`
}

type SuggestionResult_SuggestFaqAnswersResponse struct {
	// SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
	SuggestFaqAnswersResponse *SuggestFaqAnswersResponse `protobuf:"bytes,3,opt,name=suggest_faq_answers_response,json=suggestFaqAnswersResponse,proto3,oneof"`
}

func (*SuggestionResult_Error) isSuggestionResult_SuggestionResponse() {}

func (*SuggestionResult_SuggestArticlesResponse) isSuggestionResult_SuggestionResponse() {}

func (*SuggestionResult_SuggestFaqAnswersResponse) isSuggestionResult_SuggestionResponse() {}

// Represents a part of a message possibly annotated with an entity. The part
// can be an entity or purely a part of the message between two entities or
// message start/end.
type AnnotatedMessagePart struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A part of a message possibly annotated with an entity.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The [Dialogflow system entity
	// type](https://cloud.google.com/dialogflow/docs/reference/system-entities)
	// of this message part. If this is empty, Dialogflow could not annotate the
	// phrase part with a system entity.
	EntityType string `protobuf:"bytes,2,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// The [Dialogflow system entity formatted value
	// ](https://cloud.google.com/dialogflow/docs/reference/system-entities) of
	// this message part. For example for a system entity of type
	// `@sys.unit-currency`, this may contain:
	// <pre>
	// {
	//   "amount": 5,
	//   "currency": "USD"
	// }
	// </pre>
	FormattedValue *structpb.Value `protobuf:"bytes,3,opt,name=formatted_value,json=formattedValue,proto3" json:"formatted_value,omitempty"`
}

func (x *AnnotatedMessagePart) Reset() {
	*x = AnnotatedMessagePart{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotatedMessagePart) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotatedMessagePart) ProtoMessage() {}

func (x *AnnotatedMessagePart) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotatedMessagePart.ProtoReflect.Descriptor instead.
func (*AnnotatedMessagePart) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{19}
}

func (x *AnnotatedMessagePart) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *AnnotatedMessagePart) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

func (x *AnnotatedMessagePart) GetFormattedValue() *structpb.Value {
	if x != nil {
		return x.FormattedValue
	}
	return nil
}

// Represents the result of annotation for the message.
type MessageAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The collection of annotated message parts ordered by their
	// position in the message. You can recover the annotated message by
	// concatenating [AnnotatedMessagePart.text].
	Parts []*AnnotatedMessagePart `protobuf:"bytes,1,rep,name=parts,proto3" json:"parts,omitempty"`
	// Indicates whether the text message contains entities.
	ContainEntities bool `protobuf:"varint,2,opt,name=contain_entities,json=containEntities,proto3" json:"contain_entities,omitempty"`
}

func (x *MessageAnnotation) Reset() {
	*x = MessageAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageAnnotation) ProtoMessage() {}

func (x *MessageAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_participant_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageAnnotation.ProtoReflect.Descriptor instead.
func (*MessageAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP(), []int{20}
}

func (x *MessageAnnotation) GetParts() []*AnnotatedMessagePart {
	if x != nil {
		return x.Parts
	}
	return nil
}

func (x *MessageAnnotation) GetContainEntities() bool {
	if x != nil {
		return x.ContainEntities
	}
	return false
}

var File_google_cloud_dialogflow_v2_participant_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2_participant_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xda, 0x03, 0x0a, 0x0b,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x3e, 0x0a, 0x19, 0x73,
	0x69, 0x70, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x16, 0x73, 0x69, 0x70, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x50, 0x0a, 0x04, 0x52,
	0x6f, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x55, 0x4d,
	0x41, 0x4e, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x55,
	0x54, 0x4f, 0x4d, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x44, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x03, 0x3a, 0xd8, 0x01,
	0xea, 0x41, 0xd4, 0x01, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x4a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x7d, 0x12, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x7d, 0x22, 0xd7, 0x04, 0x0a, 0x07, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x25, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x5c, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x12, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0xc4, 0x01, 0xea, 0x41,
	0xc0, 0x01, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x42, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2f,
	0x7b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x7d, 0x12, 0x57, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x7d, 0x22, 0xb1, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x22, 0x5a, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8f, 0x01, 0x0a, 0x18,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xac, 0x01,
	0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0b, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xd0, 0x03, 0x0a,
	0x15, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x48, 0x00, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12,
	0x49, 0x0a, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x0a,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x5b, 0x0a, 0x12, 0x72, 0x65,
	0x70, 0x6c, 0x79, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x42, 0x07, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x22,
	0x3e, 0x0a, 0x0e, 0x44, 0x74, 0x6d, 0x66, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x5f, 0x64, 0x74, 0x6d,
	0x66, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x61,
	0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x44, 0x74, 0x6d, 0x66, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x22,
	0xda, 0x04, 0x0a, 0x16, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65,
	0x70, 0x6c, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x72, 0x65, 0x70, 0x6c, 0x79, 0x54, 0x65, 0x78, 0x74, 0x12, 0x48, 0x0a, 0x0b, 0x72, 0x65, 0x70,
	0x6c, 0x79, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x12, 0x63, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x70, 0x6c, 0x79, 0x52, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x3d, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x71, 0x0a, 0x1e, 0x68, 0x75, 0x6d, 0x61, 0x6e,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x1b, 0x68,
	0x75, 0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x6b, 0x0a, 0x1b, 0x65, 0x6e,
	0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x18, 0x65,
	0x6e, 0x64, 0x55, 0x73, 0x65, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x53, 0x0a, 0x0f, 0x64, 0x74, 0x6d, 0x66, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x74,
	0x6d, 0x66, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0e, 0x64, 0x74,
	0x6d, 0x66, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xd1, 0x01, 0x0a,
	0x16, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a,
	0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4d,
	0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65,
	0x22, 0xb7, 0x01, 0x0a, 0x17, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69,
	0x63, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0f,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x52, 0x0e, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73,
	0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xd3, 0x01, 0x0a, 0x18, 0x53,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a,
	0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4d,
	0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65,
	0x22, 0xad, 0x01, 0x0a, 0x19, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46,
	0x0a, 0x0b, 0x66, 0x61, 0x71, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x0a, 0x66, 0x61, 0x71, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65,
	0x22, 0x6a, 0x0a, 0x0b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12,
	0x45, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x22, 0x92, 0x03, 0x0a,
	0x13, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x70, 0x6c, 0x79, 0x12, 0x66, 0x0a, 0x16, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x14, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x84, 0x01, 0x0a,
	0x1a, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x79, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x17, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x5d, 0x0a, 0x17, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a,
	0x26, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54,
	0x5f, 0x52, 0x45, 0x50, 0x4c, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x41, 0x52,
	0x54, 0x49, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x49, 0x4e, 0x41, 0x4c, 0x10,
	0x02, 0x22, 0xaa, 0x02, 0x0a, 0x0d, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x73,
	0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x73,
	0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a, 0x0d,
	0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xaa,
	0x02, 0x0a, 0x09, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06,
	0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4f, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x1a, 0x3b,
	0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc2, 0x02, 0x0a, 0x10,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x71, 0x0a, 0x19,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73,
	0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x17, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41,
	0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x78, 0x0a, 0x1c, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x66, 0x61, 0x71, 0x5f, 0x61,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x19,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x73, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x8c, 0x01, 0x0a, 0x14, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x72, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3f,
	0x0a, 0x0f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x86, 0x01, 0x0a, 0x11, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x50, 0x61, 0x72, 0x74, 0x52, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73, 0x12, 0x29, 0x0a,
	0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x32, 0xff, 0x11, 0x0a, 0x0c, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12, 0xa5, 0x02, 0x0a, 0x11, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x22, 0xb0,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x94, 0x01, 0x22, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x3a, 0x0b,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5a, 0x4f, 0x22, 0x40, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x3a,
	0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0xda, 0x41, 0x12, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x12, 0xf6, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x22, 0x87, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7a, 0x12, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a,
	0x42, 0x12, 0x40, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x89, 0x02, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x89, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x7a, 0x12, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x5a, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc2, 0x02, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x22, 0xcd, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0xac, 0x01, 0x32, 0x40, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x5a, 0x5b, 0x32, 0x4c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xe0, 0x02, 0x0a, 0x0e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xe6, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xac, 0x01, 0x22,
	0x4a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x5b,
	0x22, 0x56, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x16, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2c, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x2c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0xc9,
	0x02, 0x0a, 0x0f, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c,
	0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xcc, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0xbc, 0x01, 0x22, 0x52, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x63, 0x22, 0x5e,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd3, 0x02, 0x0a, 0x11, 0x53,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73,
	0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xd0, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc0, 0x01, 0x22, 0x54, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x3a, 0x01, 0x2a,
	0x5a, 0x65, 0x22, 0x60, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x9f, 0x01, 0x0a, 0x1e, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x42, 0x10, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x3b, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa,
	0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2_participant_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2_participant_proto_rawDescData = file_google_cloud_dialogflow_v2_participant_proto_rawDesc
)

func file_google_cloud_dialogflow_v2_participant_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2_participant_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2_participant_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2_participant_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2_participant_proto_rawDescData
}

var file_google_cloud_dialogflow_v2_participant_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dialogflow_v2_participant_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_cloud_dialogflow_v2_participant_proto_goTypes = []interface{}{
	(Participant_Role)(0),                            // 0: google.cloud.dialogflow.v2.Participant.Role
	(AutomatedAgentReply_AutomatedAgentReplyType)(0), // 1: google.cloud.dialogflow.v2.AutomatedAgentReply.AutomatedAgentReplyType
	(*Participant)(nil),                              // 2: google.cloud.dialogflow.v2.Participant
	(*Message)(nil),                                  // 3: google.cloud.dialogflow.v2.Message
	(*CreateParticipantRequest)(nil),                 // 4: google.cloud.dialogflow.v2.CreateParticipantRequest
	(*GetParticipantRequest)(nil),                    // 5: google.cloud.dialogflow.v2.GetParticipantRequest
	(*ListParticipantsRequest)(nil),                  // 6: google.cloud.dialogflow.v2.ListParticipantsRequest
	(*ListParticipantsResponse)(nil),                 // 7: google.cloud.dialogflow.v2.ListParticipantsResponse
	(*UpdateParticipantRequest)(nil),                 // 8: google.cloud.dialogflow.v2.UpdateParticipantRequest
	(*AnalyzeContentRequest)(nil),                    // 9: google.cloud.dialogflow.v2.AnalyzeContentRequest
	(*DtmfParameters)(nil),                           // 10: google.cloud.dialogflow.v2.DtmfParameters
	(*AnalyzeContentResponse)(nil),                   // 11: google.cloud.dialogflow.v2.AnalyzeContentResponse
	(*SuggestArticlesRequest)(nil),                   // 12: google.cloud.dialogflow.v2.SuggestArticlesRequest
	(*SuggestArticlesResponse)(nil),                  // 13: google.cloud.dialogflow.v2.SuggestArticlesResponse
	(*SuggestFaqAnswersRequest)(nil),                 // 14: google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
	(*SuggestFaqAnswersResponse)(nil),                // 15: google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
	(*OutputAudio)(nil),                              // 16: google.cloud.dialogflow.v2.OutputAudio
	(*AutomatedAgentReply)(nil),                      // 17: google.cloud.dialogflow.v2.AutomatedAgentReply
	(*ArticleAnswer)(nil),                            // 18: google.cloud.dialogflow.v2.ArticleAnswer
	(*FaqAnswer)(nil),                                // 19: google.cloud.dialogflow.v2.FaqAnswer
	(*SuggestionResult)(nil),                         // 20: google.cloud.dialogflow.v2.SuggestionResult
	(*AnnotatedMessagePart)(nil),                     // 21: google.cloud.dialogflow.v2.AnnotatedMessagePart
	(*MessageAnnotation)(nil),                        // 22: google.cloud.dialogflow.v2.MessageAnnotation
	nil,                                              // 23: google.cloud.dialogflow.v2.ArticleAnswer.MetadataEntry
	nil,                                              // 24: google.cloud.dialogflow.v2.FaqAnswer.MetadataEntry
	(*timestamppb.Timestamp)(nil),                    // 25: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                    // 26: google.protobuf.FieldMask
	(*TextInput)(nil),                                // 27: google.cloud.dialogflow.v2.TextInput
	(*EventInput)(nil),                               // 28: google.cloud.dialogflow.v2.EventInput
	(*OutputAudioConfig)(nil),                        // 29: google.cloud.dialogflow.v2.OutputAudioConfig
	(*QueryParameters)(nil),                          // 30: google.cloud.dialogflow.v2.QueryParameters
	(*DetectIntentResponse)(nil),                     // 31: google.cloud.dialogflow.v2.DetectIntentResponse
	(*status.Status)(nil),                            // 32: google.rpc.Status
	(*structpb.Value)(nil),                           // 33: google.protobuf.Value
}
var file_google_cloud_dialogflow_v2_participant_proto_depIdxs = []int32{
	0,  // 0: google.cloud.dialogflow.v2.Participant.role:type_name -> google.cloud.dialogflow.v2.Participant.Role
	0,  // 1: google.cloud.dialogflow.v2.Message.participant_role:type_name -> google.cloud.dialogflow.v2.Participant.Role
	25, // 2: google.cloud.dialogflow.v2.Message.create_time:type_name -> google.protobuf.Timestamp
	22, // 3: google.cloud.dialogflow.v2.Message.message_annotation:type_name -> google.cloud.dialogflow.v2.MessageAnnotation
	2,  // 4: google.cloud.dialogflow.v2.CreateParticipantRequest.participant:type_name -> google.cloud.dialogflow.v2.Participant
	2,  // 5: google.cloud.dialogflow.v2.ListParticipantsResponse.participants:type_name -> google.cloud.dialogflow.v2.Participant
	2,  // 6: google.cloud.dialogflow.v2.UpdateParticipantRequest.participant:type_name -> google.cloud.dialogflow.v2.Participant
	26, // 7: google.cloud.dialogflow.v2.UpdateParticipantRequest.update_mask:type_name -> google.protobuf.FieldMask
	27, // 8: google.cloud.dialogflow.v2.AnalyzeContentRequest.text_input:type_name -> google.cloud.dialogflow.v2.TextInput
	28, // 9: google.cloud.dialogflow.v2.AnalyzeContentRequest.event_input:type_name -> google.cloud.dialogflow.v2.EventInput
	29, // 10: google.cloud.dialogflow.v2.AnalyzeContentRequest.reply_audio_config:type_name -> google.cloud.dialogflow.v2.OutputAudioConfig
	30, // 11: google.cloud.dialogflow.v2.AnalyzeContentRequest.query_params:type_name -> google.cloud.dialogflow.v2.QueryParameters
	16, // 12: google.cloud.dialogflow.v2.AnalyzeContentResponse.reply_audio:type_name -> google.cloud.dialogflow.v2.OutputAudio
	17, // 13: google.cloud.dialogflow.v2.AnalyzeContentResponse.automated_agent_reply:type_name -> google.cloud.dialogflow.v2.AutomatedAgentReply
	3,  // 14: google.cloud.dialogflow.v2.AnalyzeContentResponse.message:type_name -> google.cloud.dialogflow.v2.Message
	20, // 15: google.cloud.dialogflow.v2.AnalyzeContentResponse.human_agent_suggestion_results:type_name -> google.cloud.dialogflow.v2.SuggestionResult
	20, // 16: google.cloud.dialogflow.v2.AnalyzeContentResponse.end_user_suggestion_results:type_name -> google.cloud.dialogflow.v2.SuggestionResult
	10, // 17: google.cloud.dialogflow.v2.AnalyzeContentResponse.dtmf_parameters:type_name -> google.cloud.dialogflow.v2.DtmfParameters
	18, // 18: google.cloud.dialogflow.v2.SuggestArticlesResponse.article_answers:type_name -> google.cloud.dialogflow.v2.ArticleAnswer
	19, // 19: google.cloud.dialogflow.v2.SuggestFaqAnswersResponse.faq_answers:type_name -> google.cloud.dialogflow.v2.FaqAnswer
	29, // 20: google.cloud.dialogflow.v2.OutputAudio.config:type_name -> google.cloud.dialogflow.v2.OutputAudioConfig
	31, // 21: google.cloud.dialogflow.v2.AutomatedAgentReply.detect_intent_response:type_name -> google.cloud.dialogflow.v2.DetectIntentResponse
	1,  // 22: google.cloud.dialogflow.v2.AutomatedAgentReply.automated_agent_reply_type:type_name -> google.cloud.dialogflow.v2.AutomatedAgentReply.AutomatedAgentReplyType
	23, // 23: google.cloud.dialogflow.v2.ArticleAnswer.metadata:type_name -> google.cloud.dialogflow.v2.ArticleAnswer.MetadataEntry
	24, // 24: google.cloud.dialogflow.v2.FaqAnswer.metadata:type_name -> google.cloud.dialogflow.v2.FaqAnswer.MetadataEntry
	32, // 25: google.cloud.dialogflow.v2.SuggestionResult.error:type_name -> google.rpc.Status
	13, // 26: google.cloud.dialogflow.v2.SuggestionResult.suggest_articles_response:type_name -> google.cloud.dialogflow.v2.SuggestArticlesResponse
	15, // 27: google.cloud.dialogflow.v2.SuggestionResult.suggest_faq_answers_response:type_name -> google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
	33, // 28: google.cloud.dialogflow.v2.AnnotatedMessagePart.formatted_value:type_name -> google.protobuf.Value
	21, // 29: google.cloud.dialogflow.v2.MessageAnnotation.parts:type_name -> google.cloud.dialogflow.v2.AnnotatedMessagePart
	4,  // 30: google.cloud.dialogflow.v2.Participants.CreateParticipant:input_type -> google.cloud.dialogflow.v2.CreateParticipantRequest
	5,  // 31: google.cloud.dialogflow.v2.Participants.GetParticipant:input_type -> google.cloud.dialogflow.v2.GetParticipantRequest
	6,  // 32: google.cloud.dialogflow.v2.Participants.ListParticipants:input_type -> google.cloud.dialogflow.v2.ListParticipantsRequest
	8,  // 33: google.cloud.dialogflow.v2.Participants.UpdateParticipant:input_type -> google.cloud.dialogflow.v2.UpdateParticipantRequest
	9,  // 34: google.cloud.dialogflow.v2.Participants.AnalyzeContent:input_type -> google.cloud.dialogflow.v2.AnalyzeContentRequest
	12, // 35: google.cloud.dialogflow.v2.Participants.SuggestArticles:input_type -> google.cloud.dialogflow.v2.SuggestArticlesRequest
	14, // 36: google.cloud.dialogflow.v2.Participants.SuggestFaqAnswers:input_type -> google.cloud.dialogflow.v2.SuggestFaqAnswersRequest
	2,  // 37: google.cloud.dialogflow.v2.Participants.CreateParticipant:output_type -> google.cloud.dialogflow.v2.Participant
	2,  // 38: google.cloud.dialogflow.v2.Participants.GetParticipant:output_type -> google.cloud.dialogflow.v2.Participant
	7,  // 39: google.cloud.dialogflow.v2.Participants.ListParticipants:output_type -> google.cloud.dialogflow.v2.ListParticipantsResponse
	2,  // 40: google.cloud.dialogflow.v2.Participants.UpdateParticipant:output_type -> google.cloud.dialogflow.v2.Participant
	11, // 41: google.cloud.dialogflow.v2.Participants.AnalyzeContent:output_type -> google.cloud.dialogflow.v2.AnalyzeContentResponse
	13, // 42: google.cloud.dialogflow.v2.Participants.SuggestArticles:output_type -> google.cloud.dialogflow.v2.SuggestArticlesResponse
	15, // 43: google.cloud.dialogflow.v2.Participants.SuggestFaqAnswers:output_type -> google.cloud.dialogflow.v2.SuggestFaqAnswersResponse
	37, // [37:44] is the sub-list for method output_type
	30, // [30:37] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2_participant_proto_init() }
func file_google_cloud_dialogflow_v2_participant_proto_init() {
	if File_google_cloud_dialogflow_v2_participant_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2_audio_config_proto_init()
	file_google_cloud_dialogflow_v2_session_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Participant); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateParticipantRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetParticipantRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListParticipantsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListParticipantsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateParticipantRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeContentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DtmfParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeContentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuggestArticlesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuggestArticlesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuggestFaqAnswersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuggestFaqAnswersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputAudio); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AutomatedAgentReply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArticleAnswer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FaqAnswer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuggestionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotatedMessagePart); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_participant_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_v2_participant_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*AnalyzeContentRequest_TextInput)(nil),
		(*AnalyzeContentRequest_EventInput)(nil),
	}
	file_google_cloud_dialogflow_v2_participant_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*SuggestionResult_Error)(nil),
		(*SuggestionResult_SuggestArticlesResponse)(nil),
		(*SuggestionResult_SuggestFaqAnswersResponse)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2_participant_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2_participant_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2_participant_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2_participant_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2_participant_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2_participant_proto = out.File
	file_google_cloud_dialogflow_v2_participant_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2_participant_proto_goTypes = nil
	file_google_cloud_dialogflow_v2_participant_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ParticipantsClient is the client API for Participants service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ParticipantsClient interface {
	// Creates a new participant in a conversation.
	CreateParticipant(ctx context.Context, in *CreateParticipantRequest, opts ...grpc.CallOption) (*Participant, error)
	// Retrieves a conversation participant.
	GetParticipant(ctx context.Context, in *GetParticipantRequest, opts ...grpc.CallOption) (*Participant, error)
	// Returns the list of all participants in the specified conversation.
	ListParticipants(ctx context.Context, in *ListParticipantsRequest, opts ...grpc.CallOption) (*ListParticipantsResponse, error)
	// Updates the specified participant.
	UpdateParticipant(ctx context.Context, in *UpdateParticipantRequest, opts ...grpc.CallOption) (*Participant, error)
	// Adds a text (chat, for example), or audio (phone recording, for example)
	// message from a participant into the conversation.
	//
	// Note: Always use agent versions for production traffic
	// sent to virtual agents. See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	AnalyzeContent(ctx context.Context, in *AnalyzeContentRequest, opts ...grpc.CallOption) (*AnalyzeContentResponse, error)
	// Gets suggested articles for a participant based on specific historical
	// messages.
	SuggestArticles(ctx context.Context, in *SuggestArticlesRequest, opts ...grpc.CallOption) (*SuggestArticlesResponse, error)
	// Gets suggested faq answers for a participant based on specific historical
	// messages.
	SuggestFaqAnswers(ctx context.Context, in *SuggestFaqAnswersRequest, opts ...grpc.CallOption) (*SuggestFaqAnswersResponse, error)
}

type participantsClient struct {
	cc grpc.ClientConnInterface
}

func NewParticipantsClient(cc grpc.ClientConnInterface) ParticipantsClient {
	return &participantsClient{cc}
}

func (c *participantsClient) CreateParticipant(ctx context.Context, in *CreateParticipantRequest, opts ...grpc.CallOption) (*Participant, error) {
	out := new(Participant)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Participants/CreateParticipant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) GetParticipant(ctx context.Context, in *GetParticipantRequest, opts ...grpc.CallOption) (*Participant, error) {
	out := new(Participant)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Participants/GetParticipant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) ListParticipants(ctx context.Context, in *ListParticipantsRequest, opts ...grpc.CallOption) (*ListParticipantsResponse, error) {
	out := new(ListParticipantsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Participants/ListParticipants", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) UpdateParticipant(ctx context.Context, in *UpdateParticipantRequest, opts ...grpc.CallOption) (*Participant, error) {
	out := new(Participant)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Participants/UpdateParticipant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) AnalyzeContent(ctx context.Context, in *AnalyzeContentRequest, opts ...grpc.CallOption) (*AnalyzeContentResponse, error) {
	out := new(AnalyzeContentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Participants/AnalyzeContent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) SuggestArticles(ctx context.Context, in *SuggestArticlesRequest, opts ...grpc.CallOption) (*SuggestArticlesResponse, error) {
	out := new(SuggestArticlesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Participants/SuggestArticles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *participantsClient) SuggestFaqAnswers(ctx context.Context, in *SuggestFaqAnswersRequest, opts ...grpc.CallOption) (*SuggestFaqAnswersResponse, error) {
	out := new(SuggestFaqAnswersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Participants/SuggestFaqAnswers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ParticipantsServer is the server API for Participants service.
type ParticipantsServer interface {
	// Creates a new participant in a conversation.
	CreateParticipant(context.Context, *CreateParticipantRequest) (*Participant, error)
	// Retrieves a conversation participant.
	GetParticipant(context.Context, *GetParticipantRequest) (*Participant, error)
	// Returns the list of all participants in the specified conversation.
	ListParticipants(context.Context, *ListParticipantsRequest) (*ListParticipantsResponse, error)
	// Updates the specified participant.
	UpdateParticipant(context.Context, *UpdateParticipantRequest) (*Participant, error)
	// Adds a text (chat, for example), or audio (phone recording, for example)
	// message from a participant into the conversation.
	//
	// Note: Always use agent versions for production traffic
	// sent to virtual agents. See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	AnalyzeContent(context.Context, *AnalyzeContentRequest) (*AnalyzeContentResponse, error)
	// Gets suggested articles for a participant based on specific historical
	// messages.
	SuggestArticles(context.Context, *SuggestArticlesRequest) (*SuggestArticlesResponse, error)
	// Gets suggested faq answers for a participant based on specific historical
	// messages.
	SuggestFaqAnswers(context.Context, *SuggestFaqAnswersRequest) (*SuggestFaqAnswersResponse, error)
}

// UnimplementedParticipantsServer can be embedded to have forward compatible implementations.
type UnimplementedParticipantsServer struct {
}

func (*UnimplementedParticipantsServer) CreateParticipant(context.Context, *CreateParticipantRequest) (*Participant, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateParticipant not implemented")
}
func (*UnimplementedParticipantsServer) GetParticipant(context.Context, *GetParticipantRequest) (*Participant, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetParticipant not implemented")
}
func (*UnimplementedParticipantsServer) ListParticipants(context.Context, *ListParticipantsRequest) (*ListParticipantsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListParticipants not implemented")
}
func (*UnimplementedParticipantsServer) UpdateParticipant(context.Context, *UpdateParticipantRequest) (*Participant, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateParticipant not implemented")
}
func (*UnimplementedParticipantsServer) AnalyzeContent(context.Context, *AnalyzeContentRequest) (*AnalyzeContentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeContent not implemented")
}
func (*UnimplementedParticipantsServer) SuggestArticles(context.Context, *SuggestArticlesRequest) (*SuggestArticlesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SuggestArticles not implemented")
}
func (*UnimplementedParticipantsServer) SuggestFaqAnswers(context.Context, *SuggestFaqAnswersRequest) (*SuggestFaqAnswersResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SuggestFaqAnswers not implemented")
}

func RegisterParticipantsServer(s *grpc.Server, srv ParticipantsServer) {
	s.RegisterService(&_Participants_serviceDesc, srv)
}

func _Participants_CreateParticipant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateParticipantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).CreateParticipant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Participants/CreateParticipant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).CreateParticipant(ctx, req.(*CreateParticipantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_GetParticipant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetParticipantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).GetParticipant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Participants/GetParticipant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).GetParticipant(ctx, req.(*GetParticipantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_ListParticipants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListParticipantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).ListParticipants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Participants/ListParticipants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).ListParticipants(ctx, req.(*ListParticipantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_UpdateParticipant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateParticipantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).UpdateParticipant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Participants/UpdateParticipant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).UpdateParticipant(ctx, req.(*UpdateParticipantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_AnalyzeContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).AnalyzeContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Participants/AnalyzeContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).AnalyzeContent(ctx, req.(*AnalyzeContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_SuggestArticles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuggestArticlesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).SuggestArticles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Participants/SuggestArticles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).SuggestArticles(ctx, req.(*SuggestArticlesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Participants_SuggestFaqAnswers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuggestFaqAnswersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ParticipantsServer).SuggestFaqAnswers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Participants/SuggestFaqAnswers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ParticipantsServer).SuggestFaqAnswers(ctx, req.(*SuggestFaqAnswersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Participants_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Participants",
	HandlerType: (*ParticipantsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateParticipant",
			Handler:    _Participants_CreateParticipant_Handler,
		},
		{
			MethodName: "GetParticipant",
			Handler:    _Participants_GetParticipant_Handler,
		},
		{
			MethodName: "ListParticipants",
			Handler:    _Participants_ListParticipants_Handler,
		},
		{
			MethodName: "UpdateParticipant",
			Handler:    _Participants_UpdateParticipant_Handler,
		},
		{
			MethodName: "AnalyzeContent",
			Handler:    _Participants_AnalyzeContent_Handler,
		},
		{
			MethodName: "SuggestArticles",
			Handler:    _Participants_SuggestArticles_Handler,
		},
		{
			MethodName: "SuggestFaqAnswers",
			Handler:    _Participants_SuggestFaqAnswers_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/participant.proto",
}
