package batch

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/batch/mgmt/2021-06-01/batch"

// Account contains information about an Azure Batch account.
type Account struct {
	autorest.Response `json:"-"`
	// AccountProperties - The properties associated with the account.
	*AccountProperties `json:"properties,omitempty"`
	// Identity - The identity of the Batch account.
	Identity *AccountIdentity `json:"identity,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "identity":
			if v != nil {
				var identity AccountIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				a.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		}
	}

	return nil
}

// AccountCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountClient) (Account, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountCreateFuture.Result.
func (future *AccountCreateFuture) result(client AccountClient) (a Account, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.AccountCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batch.AccountCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batch.AccountCreateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountCreateParameters parameters supplied to the Create operation.
type AccountCreateParameters struct {
	// Location - The region in which to create the account.
	Location *string `json:"location,omitempty"`
	// Tags - The user-specified tags associated with the account.
	Tags map[string]*string `json:"tags"`
	// AccountCreateProperties - The properties of the Batch account.
	*AccountCreateProperties `json:"properties,omitempty"`
	// Identity - The identity of the Batch account.
	Identity *AccountIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountCreateParameters.
func (acp AccountCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acp.Location != nil {
		objectMap["location"] = acp.Location
	}
	if acp.Tags != nil {
		objectMap["tags"] = acp.Tags
	}
	if acp.AccountCreateProperties != nil {
		objectMap["properties"] = acp.AccountCreateProperties
	}
	if acp.Identity != nil {
		objectMap["identity"] = acp.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountCreateParameters struct.
func (acp *AccountCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				acp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				acp.Tags = tags
			}
		case "properties":
			if v != nil {
				var accountCreateProperties AccountCreateProperties
				err = json.Unmarshal(*v, &accountCreateProperties)
				if err != nil {
					return err
				}
				acp.AccountCreateProperties = &accountCreateProperties
			}
		case "identity":
			if v != nil {
				var identity AccountIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				acp.Identity = &identity
			}
		}
	}

	return nil
}

// AccountCreateProperties the properties of a Batch account.
type AccountCreateProperties struct {
	// AutoStorage - The properties related to the auto-storage account.
	AutoStorage *AutoStorageBaseProperties `json:"autoStorage,omitempty"`
	// PoolAllocationMode - The pool allocation mode also affects how clients may authenticate to the Batch Service API. If the mode is BatchService, clients may authenticate using access keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active Directory. The default is BatchService. Possible values include: 'PoolAllocationModeBatchService', 'PoolAllocationModeUserSubscription'
	PoolAllocationMode PoolAllocationMode `json:"poolAllocationMode,omitempty"`
	// KeyVaultReference - A reference to the Azure key vault associated with the Batch account.
	KeyVaultReference *KeyVaultReference `json:"keyVaultReference,omitempty"`
	// PublicNetworkAccess - If not specified, the default value is 'enabled'. Possible values include: 'PublicNetworkAccessTypeEnabled', 'PublicNetworkAccessTypeDisabled'
	PublicNetworkAccess PublicNetworkAccessType `json:"publicNetworkAccess,omitempty"`
	// Encryption - Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
	Encryption *EncryptionProperties `json:"encryption,omitempty"`
	// AllowedAuthenticationModes - List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
	AllowedAuthenticationModes *[]AuthenticationMode `json:"allowedAuthenticationModes,omitempty"`
}

// AccountDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AccountClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AccountDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AccountDeleteFuture.Result.
func (future *AccountDeleteFuture) result(client AccountClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.AccountDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batch.AccountDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AccountIdentity the identity of the Batch account, if configured. This is used when the user specifies
// 'Microsoft.KeyVault' as their Batch account encryption configuration or when `ManagedIdentity` is
// selected as the auto-storage authentication mode.
type AccountIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of the Batch account. This property will only be provided for a system assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id associated with the Batch account. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the Batch account. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the Batch account.
	UserAssignedIdentities map[string]*UserAssignedIdentities `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for AccountIdentity.
func (ai AccountIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ai.Type != "" {
		objectMap["type"] = ai.Type
	}
	if ai.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = ai.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// AccountKeys a set of Azure Batch account keys.
type AccountKeys struct {
	autorest.Response `json:"-"`
	// AccountName - READ-ONLY; The Batch account name.
	AccountName *string `json:"accountName,omitempty"`
	// Primary - READ-ONLY; The primary key associated with the account.
	Primary *string `json:"primary,omitempty"`
	// Secondary - READ-ONLY; The secondary key associated with the account.
	Secondary *string `json:"secondary,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountKeys.
func (ak AccountKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AccountListResult values returned by the List operation.
type AccountListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of Batch accounts returned by the listing operation.
	Value *[]Account `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// AccountListResultIterator provides access to a complete listing of Account values.
type AccountListResultIterator struct {
	i    int
	page AccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListResultIterator) Response() AccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListResultIterator) Value() Account {
	if !iter.page.NotDone() {
		return Account{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListResultIterator type.
func NewAccountListResultIterator(page AccountListResultPage) AccountListResultIterator {
	return AccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AccountListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AccountListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// accountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AccountListResult) accountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AccountListResultPage contains a page of Account values.
type AccountListResultPage struct {
	fn  func(context.Context, AccountListResult) (AccountListResult, error)
	alr AccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListResultPage) Response() AccountListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListResultPage) Values() []Account {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AccountListResultPage type.
func NewAccountListResultPage(cur AccountListResult, getNextPage func(context.Context, AccountListResult) (AccountListResult, error)) AccountListResultPage {
	return AccountListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AccountProperties account specific properties.
type AccountProperties struct {
	// AccountEndpoint - READ-ONLY; The account endpoint used to interact with the Batch service.
	AccountEndpoint *string `json:"accountEndpoint,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioned state of the resource. Possible values include: 'ProvisioningStateInvalid', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCancelled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// PoolAllocationMode - READ-ONLY; Possible values include: 'PoolAllocationModeBatchService', 'PoolAllocationModeUserSubscription'
	PoolAllocationMode PoolAllocationMode `json:"poolAllocationMode,omitempty"`
	// KeyVaultReference - READ-ONLY
	KeyVaultReference *KeyVaultReference `json:"keyVaultReference,omitempty"`
	// PublicNetworkAccess - READ-ONLY; If not specified, the default value is 'enabled'. Possible values include: 'PublicNetworkAccessTypeEnabled', 'PublicNetworkAccessTypeDisabled'
	PublicNetworkAccess PublicNetworkAccessType `json:"publicNetworkAccess,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections associated with the Batch account
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// AutoStorage - READ-ONLY
	AutoStorage *AutoStorageProperties `json:"autoStorage,omitempty"`
	// Encryption - READ-ONLY; Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
	Encryption *EncryptionProperties `json:"encryption,omitempty"`
	// DedicatedCoreQuota - READ-ONLY; For accounts with PoolAllocationMode set to UserSubscription, quota is managed on the subscription so this value is not returned.
	DedicatedCoreQuota *int32 `json:"dedicatedCoreQuota,omitempty"`
	// LowPriorityCoreQuota - READ-ONLY; For accounts with PoolAllocationMode set to UserSubscription, quota is managed on the subscription so this value is not returned.
	LowPriorityCoreQuota *int32 `json:"lowPriorityCoreQuota,omitempty"`
	// DedicatedCoreQuotaPerVMFamily - READ-ONLY; A list of the dedicated core quota per Virtual Machine family for the Batch account. For accounts with PoolAllocationMode set to UserSubscription, quota is managed on the subscription so this value is not returned.
	DedicatedCoreQuotaPerVMFamily *[]VirtualMachineFamilyCoreQuota `json:"dedicatedCoreQuotaPerVMFamily,omitempty"`
	// DedicatedCoreQuotaPerVMFamilyEnforced - READ-ONLY; Batch is transitioning its core quota system for dedicated cores to be enforced per Virtual Machine family. During this transitional phase, the dedicated core quota per Virtual Machine family may not yet be enforced. If this flag is false, dedicated core quota is enforced via the old dedicatedCoreQuota property on the account and does not consider Virtual Machine family. If this flag is true, dedicated core quota is enforced via the dedicatedCoreQuotaPerVMFamily property on the account, and the old dedicatedCoreQuota does not apply.
	DedicatedCoreQuotaPerVMFamilyEnforced *bool `json:"dedicatedCoreQuotaPerVMFamilyEnforced,omitempty"`
	// PoolQuota - READ-ONLY
	PoolQuota *int32 `json:"poolQuota,omitempty"`
	// ActiveJobAndJobScheduleQuota - READ-ONLY
	ActiveJobAndJobScheduleQuota *int32 `json:"activeJobAndJobScheduleQuota,omitempty"`
	// AllowedAuthenticationModes - READ-ONLY; List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
	AllowedAuthenticationModes *[]AuthenticationMode `json:"allowedAuthenticationModes,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountProperties.
func (ap AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AccountRegenerateKeyParameters parameters supplied to the RegenerateKey operation.
type AccountRegenerateKeyParameters struct {
	// KeyName - The type of account key to regenerate. Possible values include: 'AccountKeyTypePrimary', 'AccountKeyTypeSecondary'
	KeyName AccountKeyType `json:"keyName,omitempty"`
}

// AccountUpdateParameters parameters for updating an Azure Batch account.
type AccountUpdateParameters struct {
	// Tags - The user-specified tags associated with the account.
	Tags map[string]*string `json:"tags"`
	// AccountUpdateProperties - The properties of the account.
	*AccountUpdateProperties `json:"properties,omitempty"`
	// Identity - The identity of the Batch account.
	Identity *AccountIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountUpdateParameters.
func (aup AccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aup.Tags != nil {
		objectMap["tags"] = aup.Tags
	}
	if aup.AccountUpdateProperties != nil {
		objectMap["properties"] = aup.AccountUpdateProperties
	}
	if aup.Identity != nil {
		objectMap["identity"] = aup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountUpdateParameters struct.
func (aup *AccountUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aup.Tags = tags
			}
		case "properties":
			if v != nil {
				var accountUpdateProperties AccountUpdateProperties
				err = json.Unmarshal(*v, &accountUpdateProperties)
				if err != nil {
					return err
				}
				aup.AccountUpdateProperties = &accountUpdateProperties
			}
		case "identity":
			if v != nil {
				var identity AccountIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				aup.Identity = &identity
			}
		}
	}

	return nil
}

// AccountUpdateProperties the properties of a Batch account.
type AccountUpdateProperties struct {
	// AutoStorage - The properties related to the auto-storage account.
	AutoStorage *AutoStorageBaseProperties `json:"autoStorage,omitempty"`
	// Encryption - Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
	Encryption *EncryptionProperties `json:"encryption,omitempty"`
	// AllowedAuthenticationModes - List of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
	AllowedAuthenticationModes *[]AuthenticationMode `json:"allowedAuthenticationModes,omitempty"`
}

// ActivateApplicationPackageParameters parameters for an activating an application package.
type ActivateApplicationPackageParameters struct {
	// Format - The format of the application package binary file.
	Format *string `json:"format,omitempty"`
}

// Application contains information about an application in a Batch account.
type Application struct {
	autorest.Response `json:"-"`
	// ApplicationProperties - The properties associated with the Application.
	*ApplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ApplicationProperties != nil {
		objectMap["properties"] = a.ApplicationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Application struct.
func (a *Application) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationProperties ApplicationProperties
				err = json.Unmarshal(*v, &applicationProperties)
				if err != nil {
					return err
				}
				a.ApplicationProperties = &applicationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				a.Etag = &etag
			}
		}
	}

	return nil
}

// ApplicationPackage an application package which represents a particular version of an application.
type ApplicationPackage struct {
	autorest.Response `json:"-"`
	// ApplicationPackageProperties - The properties associated with the Application Package.
	*ApplicationPackageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationPackage.
func (ap ApplicationPackage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ApplicationPackageProperties != nil {
		objectMap["properties"] = ap.ApplicationPackageProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationPackage struct.
func (ap *ApplicationPackage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationPackageProperties ApplicationPackageProperties
				err = json.Unmarshal(*v, &applicationPackageProperties)
				if err != nil {
					return err
				}
				ap.ApplicationPackageProperties = &applicationPackageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ap.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ap.Etag = &etag
			}
		}
	}

	return nil
}

// ApplicationPackageProperties properties of an application package
type ApplicationPackageProperties struct {
	// State - READ-ONLY; The current state of the application package. Possible values include: 'PackageStatePending', 'PackageStateActive'
	State PackageState `json:"state,omitempty"`
	// Format - READ-ONLY; The format of the application package, if the package is active.
	Format *string `json:"format,omitempty"`
	// StorageURL - READ-ONLY; The URL for the application package in Azure Storage.
	StorageURL *string `json:"storageUrl,omitempty"`
	// StorageURLExpiry - READ-ONLY; The UTC time at which the Azure Storage URL will expire.
	StorageURLExpiry *date.Time `json:"storageUrlExpiry,omitempty"`
	// LastActivationTime - READ-ONLY; The time at which the package was last activated, if the package is active.
	LastActivationTime *date.Time `json:"lastActivationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationPackageProperties.
func (app ApplicationPackageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplicationPackageReference ...
type ApplicationPackageReference struct {
	ID *string `json:"id,omitempty"`
	// Version - If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
	Version *string `json:"version,omitempty"`
}

// ApplicationProperties the properties associated with the Application.
type ApplicationProperties struct {
	// DisplayName - The display name for the application.
	DisplayName *string `json:"displayName,omitempty"`
	// AllowUpdates - A value indicating whether packages within the application may be overwritten using the same version string.
	AllowUpdates *bool `json:"allowUpdates,omitempty"`
	// DefaultVersion - The package to use if a client requests the application but does not specify a version. This property can only be set to the name of an existing package.
	DefaultVersion *string `json:"defaultVersion,omitempty"`
}

// AutoScaleRun ...
type AutoScaleRun struct {
	EvaluationTime *date.Time `json:"evaluationTime,omitempty"`
	// Results - Each variable value is returned in the form $variable=value, and variables are separated by semicolons.
	Results *string            `json:"results,omitempty"`
	Error   *AutoScaleRunError `json:"error,omitempty"`
}

// AutoScaleRunError ...
type AutoScaleRunError struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string              `json:"message,omitempty"`
	Details *[]AutoScaleRunError `json:"details,omitempty"`
}

// AutoScaleSettings ...
type AutoScaleSettings struct {
	Formula *string `json:"formula,omitempty"`
	// EvaluationInterval - If omitted, the default value is 15 minutes (PT15M).
	EvaluationInterval *string `json:"evaluationInterval,omitempty"`
}

// AutoStorageBaseProperties the properties related to the auto-storage account.
type AutoStorageBaseProperties struct {
	// StorageAccountID - The resource ID of the storage account to be used for auto-storage account.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// AuthenticationMode - The authentication mode which the Batch service will use to manage the auto-storage account. Possible values include: 'AutoStorageAuthenticationModeStorageKeys', 'AutoStorageAuthenticationModeBatchAccountManagedIdentity'
	AuthenticationMode AutoStorageAuthenticationMode `json:"authenticationMode,omitempty"`
	// NodeIdentityReference - The identity referenced here must be assigned to pools which have compute nodes that need access to auto-storage.
	NodeIdentityReference *ComputeNodeIdentityReference `json:"nodeIdentityReference,omitempty"`
}

// AutoStorageProperties contains information about the auto-storage account associated with a Batch
// account.
type AutoStorageProperties struct {
	// LastKeySync - The UTC time at which storage keys were last synchronized with the Batch account.
	LastKeySync *date.Time `json:"lastKeySync,omitempty"`
	// StorageAccountID - The resource ID of the storage account to be used for auto-storage account.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// AuthenticationMode - The authentication mode which the Batch service will use to manage the auto-storage account. Possible values include: 'AutoStorageAuthenticationModeStorageKeys', 'AutoStorageAuthenticationModeBatchAccountManagedIdentity'
	AuthenticationMode AutoStorageAuthenticationMode `json:"authenticationMode,omitempty"`
	// NodeIdentityReference - The identity referenced here must be assigned to pools which have compute nodes that need access to auto-storage.
	NodeIdentityReference *ComputeNodeIdentityReference `json:"nodeIdentityReference,omitempty"`
}

// AutoUserSpecification ...
type AutoUserSpecification struct {
	// Scope - The default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks. Possible values include: 'AutoUserScopeTask', 'AutoUserScopePool'
	Scope AutoUserScope `json:"scope,omitempty"`
	// ElevationLevel - The default value is nonAdmin. Possible values include: 'ElevationLevelNonAdmin', 'ElevationLevelAdmin'
	ElevationLevel ElevationLevel `json:"elevationLevel,omitempty"`
}

// AzureBlobFileSystemConfiguration ...
type AzureBlobFileSystemConfiguration struct {
	AccountName   *string `json:"accountName,omitempty"`
	ContainerName *string `json:"containerName,omitempty"`
	// AccountKey - This property is mutually exclusive with both sasKey and identity; exactly one must be specified.
	AccountKey *string `json:"accountKey,omitempty"`
	// SasKey - This property is mutually exclusive with both accountKey and identity; exactly one must be specified.
	SasKey *string `json:"sasKey,omitempty"`
	// BlobfuseOptions - These are 'net use' options in Windows and 'mount' options in Linux.
	BlobfuseOptions *string `json:"blobfuseOptions,omitempty"`
	// RelativeMountPath - All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	// IdentityReference - This property is mutually exclusive with both accountKey and sasKey; exactly one must be specified.
	IdentityReference *ComputeNodeIdentityReference `json:"identityReference,omitempty"`
}

// AzureFileShareConfiguration ...
type AzureFileShareConfiguration struct {
	AccountName *string `json:"accountName,omitempty"`
	// AzureFileURL - This is of the form 'https://{account}.file.core.windows.net/'.
	AzureFileURL *string `json:"azureFileUrl,omitempty"`
	AccountKey   *string `json:"accountKey,omitempty"`
	// RelativeMountPath - All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	// MountOptions - These are 'net use' options in Windows and 'mount' options in Linux.
	MountOptions *string `json:"mountOptions,omitempty"`
}

// Certificate contains information about a certificate.
type Certificate struct {
	autorest.Response `json:"-"`
	// CertificateProperties - The properties associated with the certificate.
	*CertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Certificate.
func (c Certificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CertificateProperties != nil {
		objectMap["properties"] = c.CertificateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Certificate struct.
func (c *Certificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateProperties CertificateProperties
				err = json.Unmarshal(*v, &certificateProperties)
				if err != nil {
					return err
				}
				c.CertificateProperties = &certificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				c.Etag = &etag
			}
		}
	}

	return nil
}

// CertificateBaseProperties base certificate properties.
type CertificateBaseProperties struct {
	// ThumbprintAlgorithm - This must match the first portion of the certificate name. Currently required to be 'SHA1'.
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	// Thumbprint - This must match the thumbprint from the name.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Format - The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx. Possible values include: 'CertificateFormatPfx', 'CertificateFormatCer'
	Format CertificateFormat `json:"format,omitempty"`
}

// CertificateCreateOrUpdateParameters contains information about a certificate.
type CertificateCreateOrUpdateParameters struct {
	// CertificateCreateOrUpdateProperties - The properties associated with the certificate.
	*CertificateCreateOrUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateCreateOrUpdateParameters.
func (ccoup CertificateCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccoup.CertificateCreateOrUpdateProperties != nil {
		objectMap["properties"] = ccoup.CertificateCreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateCreateOrUpdateParameters struct.
func (ccoup *CertificateCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateCreateOrUpdateProperties CertificateCreateOrUpdateProperties
				err = json.Unmarshal(*v, &certificateCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				ccoup.CertificateCreateOrUpdateProperties = &certificateCreateOrUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ccoup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccoup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ccoup.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ccoup.Etag = &etag
			}
		}
	}

	return nil
}

// CertificateCreateOrUpdateProperties certificate properties for create operations
type CertificateCreateOrUpdateProperties struct {
	// Data - The maximum size is 10KB.
	Data *string `json:"data,omitempty"`
	// Password - This must not be specified if the certificate format is Cer.
	Password *string `json:"password,omitempty"`
	// ThumbprintAlgorithm - This must match the first portion of the certificate name. Currently required to be 'SHA1'.
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	// Thumbprint - This must match the thumbprint from the name.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Format - The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx. Possible values include: 'CertificateFormatPfx', 'CertificateFormatCer'
	Format CertificateFormat `json:"format,omitempty"`
}

// CertificateDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CertificateDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CertificateClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CertificateDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CertificateDeleteFuture.Result.
func (future *CertificateDeleteFuture) result(client CertificateClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.CertificateDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batch.CertificateDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CertificateProperties certificate properties.
type CertificateProperties struct {
	// ProvisioningState - READ-ONLY; Possible values include: 'CertificateProvisioningStateSucceeded', 'CertificateProvisioningStateDeleting', 'CertificateProvisioningStateFailed'
	ProvisioningState CertificateProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningStateTransitionTime - READ-ONLY
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
	// PreviousProvisioningState - READ-ONLY; The previous provisioned state of the resource. Possible values include: 'CertificateProvisioningStateSucceeded', 'CertificateProvisioningStateDeleting', 'CertificateProvisioningStateFailed'
	PreviousProvisioningState CertificateProvisioningState `json:"previousProvisioningState,omitempty"`
	// PreviousProvisioningStateTransitionTime - READ-ONLY
	PreviousProvisioningStateTransitionTime *date.Time `json:"previousProvisioningStateTransitionTime,omitempty"`
	// PublicData - READ-ONLY; The public key of the certificate.
	PublicData *string `json:"publicData,omitempty"`
	// DeleteCertificateError - READ-ONLY; This is only returned when the certificate provisioningState is 'Failed'.
	DeleteCertificateError *DeleteCertificateError `json:"deleteCertificateError,omitempty"`
	// ThumbprintAlgorithm - This must match the first portion of the certificate name. Currently required to be 'SHA1'.
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	// Thumbprint - This must match the thumbprint from the name.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Format - The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx. Possible values include: 'CertificateFormatPfx', 'CertificateFormatCer'
	Format CertificateFormat `json:"format,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateProperties.
func (cp CertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.ThumbprintAlgorithm != nil {
		objectMap["thumbprintAlgorithm"] = cp.ThumbprintAlgorithm
	}
	if cp.Thumbprint != nil {
		objectMap["thumbprint"] = cp.Thumbprint
	}
	if cp.Format != "" {
		objectMap["format"] = cp.Format
	}
	return json.Marshal(objectMap)
}

// CertificateReference ...
type CertificateReference struct {
	ID *string `json:"id,omitempty"`
	// StoreLocation - The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory. Possible values include: 'CertificateStoreLocationCurrentUser', 'CertificateStoreLocationLocalMachine'
	StoreLocation CertificateStoreLocation `json:"storeLocation,omitempty"`
	// StoreName - This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
	StoreName  *string                  `json:"storeName,omitempty"`
	Visibility *[]CertificateVisibility `json:"visibility,omitempty"`
}

// CheckNameAvailabilityParameters parameters for a check name availability request.
type CheckNameAvailabilityParameters struct {
	// Name - The name to check for availability
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; Gets the reason that a Batch account name could not be used. The Reason element is only returned if NameAvailable is false. Possible values include: 'NameAvailabilityReasonInvalid', 'NameAvailabilityReasonAlreadyExists'
	Reason NameAvailabilityReason `json:"reason,omitempty"`
	// Message - READ-ONLY; Gets an error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckNameAvailabilityResult.
func (cnar CheckNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CIFSMountConfiguration ...
type CIFSMountConfiguration struct {
	Username *string `json:"username,omitempty"`
	Source   *string `json:"source,omitempty"`
	// RelativeMountPath - All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	// MountOptions - These are 'net use' options in Windows and 'mount' options in Linux.
	MountOptions *string `json:"mountOptions,omitempty"`
	Password     *string `json:"password,omitempty"`
}

// CloudError an error response from the Batch service.
type CloudError struct {
	// Error - The body of the error response.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the Batch service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// CloudServiceConfiguration ...
type CloudServiceConfiguration struct {
	// OsFamily - Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
	OsFamily *string `json:"osFamily,omitempty"`
	// OsVersion - The default value is * which specifies the latest operating system version for the specified OS family.
	OsVersion *string `json:"osVersion,omitempty"`
}

// ComputeNodeIdentityReference the reference to a user assigned identity associated with the Batch pool
// which a compute node will use.
type ComputeNodeIdentityReference struct {
	// ResourceID - The ARM resource id of the user assigned identity.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ContainerConfiguration ...
type ContainerConfiguration struct {
	Type *string `json:"type,omitempty"`
	// ContainerImageNames - This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
	ContainerImageNames *[]string `json:"containerImageNames,omitempty"`
	// ContainerRegistries - If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
	ContainerRegistries *[]ContainerRegistry `json:"containerRegistries,omitempty"`
}

// ContainerRegistry ...
type ContainerRegistry struct {
	UserName *string `json:"username,omitempty"`
	Password *string `json:"password,omitempty"`
	// RegistryServer - If omitted, the default is "docker.io".
	RegistryServer    *string                       `json:"registryServer,omitempty"`
	IdentityReference *ComputeNodeIdentityReference `json:"identityReference,omitempty"`
}

// DataDisk settings which will be used by the data disks associated to Compute Nodes in the Pool. When
// using attached data disks, you need to mount and format the disks from within a VM to use them.
type DataDisk struct {
	// Lun - The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
	Lun *int32 `json:"lun,omitempty"`
	// Caching - Values are:
	//  none - The caching mode for the disk is not enabled.
	//  readOnly - The caching mode for the disk is read only.
	//  readWrite - The caching mode for the disk is read and write.
	//  The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/. Possible values include: 'CachingTypeNone', 'CachingTypeReadOnly', 'CachingTypeReadWrite'
	Caching    CachingType `json:"caching,omitempty"`
	DiskSizeGB *int32      `json:"diskSizeGB,omitempty"`
	// StorageAccountType - If omitted, the default is "Standard_LRS". Values are:
	//  Standard_LRS - The data disk should use standard locally redundant storage.
	//  Premium_LRS - The data disk should use premium locally redundant storage. Possible values include: 'StorageAccountTypeStandardLRS', 'StorageAccountTypePremiumLRS'
	StorageAccountType StorageAccountType `json:"storageAccountType,omitempty"`
}

// DeleteCertificateError an error response from the Batch service.
type DeleteCertificateError struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]DeleteCertificateError `json:"details,omitempty"`
}

// DeploymentConfiguration ...
type DeploymentConfiguration struct {
	// CloudServiceConfiguration - This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
	CloudServiceConfiguration *CloudServiceConfiguration `json:"cloudServiceConfiguration,omitempty"`
	// VirtualMachineConfiguration - This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
}

// DiffDiskSettings ...
type DiffDiskSettings struct {
	// Placement - This property can be used by user in the request to choose which location the operating system should be in. e.g., cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements and Linux VMs at https://docs.microsoft.com/en-us/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements. Possible values include: 'DiffDiskPlacementCacheDisk'
	Placement DiffDiskPlacement `json:"placement,omitempty"`
}

// DiskEncryptionConfiguration the disk encryption configuration applied on compute nodes in the pool. Disk
// encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared
// Image Gallery Image.
type DiskEncryptionConfiguration struct {
	// Targets - On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
	Targets *[]DiskEncryptionTarget `json:"targets,omitempty"`
}

// EncryptionProperties configures how customer data is encrypted inside the Batch account. By default,
// accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can
// be used instead.
type EncryptionProperties struct {
	// KeySource - Type of the key source. Possible values include: 'KeySourceMicrosoftBatch', 'KeySourceMicrosoftKeyVault'
	KeySource KeySource `json:"keySource,omitempty"`
	// KeyVaultProperties - Additional details when using Microsoft.KeyVault
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// EndpointDependency a domain name and connection details used to access a dependency.
type EndpointDependency struct {
	// DomainName - READ-ONLY; The domain name of the dependency. Domain names may be fully qualified or may contain a * wildcard.
	DomainName *string `json:"domainName,omitempty"`
	// Description - READ-ONLY; Human-readable supplemental information about the dependency and when it is applicable.
	Description *string `json:"description,omitempty"`
	// EndpointDetails - READ-ONLY; The list of connection details for this endpoint.
	EndpointDetails *[]EndpointDetail `json:"endpointDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointDependency.
func (ed EndpointDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EndpointDetail details about the connection between the Batch service and the endpoint.
type EndpointDetail struct {
	// Port - READ-ONLY; The port an endpoint is connected to.
	Port *int32 `json:"port,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointDetail.
func (ed EndpointDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EnvironmentSetting ...
type EnvironmentSetting struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// FixedScaleSettings ...
type FixedScaleSettings struct {
	// ResizeTimeout - The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// TargetDedicatedNodes - At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
	TargetDedicatedNodes *int32 `json:"targetDedicatedNodes,omitempty"`
	// TargetLowPriorityNodes - At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
	TargetLowPriorityNodes *int32 `json:"targetLowPriorityNodes,omitempty"`
	// NodeDeallocationOption - If omitted, the default value is Requeue. Possible values include: 'ComputeNodeDeallocationOptionRequeue', 'ComputeNodeDeallocationOptionTerminate', 'ComputeNodeDeallocationOptionTaskCompletion', 'ComputeNodeDeallocationOptionRetainedData'
	NodeDeallocationOption ComputeNodeDeallocationOption `json:"nodeDeallocationOption,omitempty"`
}

// ImageReference ...
type ImageReference struct {
	// Publisher - For example, Canonical or MicrosoftWindowsServer.
	Publisher *string `json:"publisher,omitempty"`
	// Offer - For example, UbuntuServer or WindowsServer.
	Offer *string `json:"offer,omitempty"`
	// Sku - For example, 18.04-LTS or 2019-Datacenter.
	Sku *string `json:"sku,omitempty"`
	// Version - A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
	Version *string `json:"version,omitempty"`
	// ID - This property is mutually exclusive with other properties. The Shared Image Gallery image must have replicas in the same region as the Azure Batch account. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
	ID *string `json:"id,omitempty"`
}

// InboundNatPool ...
type InboundNatPool struct {
	// Name - The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
	Name *string `json:"name,omitempty"`
	// Protocol - Possible values include: 'InboundEndpointProtocolTCP', 'InboundEndpointProtocolUDP'
	Protocol InboundEndpointProtocol `json:"protocol,omitempty"`
	// BackendPort - This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
	BackendPort *int32 `json:"backendPort,omitempty"`
	// FrontendPortRangeStart - Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`
	// FrontendPortRangeEnd - Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`
	// NetworkSecurityGroupRules - The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
	NetworkSecurityGroupRules *[]NetworkSecurityGroupRule `json:"networkSecurityGroupRules,omitempty"`
}

// KeyVaultProperties keyVault configuration when using an encryption KeySource of Microsoft.KeyVault.
type KeyVaultProperties struct {
	// KeyIdentifier - Full path to the versioned secret. Example https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053. To be usable the following prerequisites must be met:
	//  The Batch Account has a System Assigned identity
	//  The account identity has been granted Key/Get, Key/Unwrap and Key/Wrap permissions
	//  The KeyVault has soft-delete and purge protection enabled
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`
}

// KeyVaultReference identifies the Azure key vault associated with a Batch account.
type KeyVaultReference struct {
	// ID - The resource ID of the Azure key vault associated with the Batch account.
	ID *string `json:"id,omitempty"`
	// URL - The URL of the Azure key vault associated with the Batch account.
	URL *string `json:"url,omitempty"`
}

// LinuxUserConfiguration ...
type LinuxUserConfiguration struct {
	// UID - The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
	UID *int32 `json:"uid,omitempty"`
	// Gid - The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
	Gid *int32 `json:"gid,omitempty"`
	// SSHPrivateKey - The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
	SSHPrivateKey *string `json:"sshPrivateKey,omitempty"`
}

// ListApplicationPackagesResult the result of performing list application packages.
type ListApplicationPackagesResult struct {
	autorest.Response `json:"-"`
	// Value - The list of application packages.
	Value *[]ApplicationPackage `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListApplicationPackagesResultIterator provides access to a complete listing of ApplicationPackage
// values.
type ListApplicationPackagesResultIterator struct {
	i    int
	page ListApplicationPackagesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListApplicationPackagesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListApplicationPackagesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListApplicationPackagesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListApplicationPackagesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListApplicationPackagesResultIterator) Response() ListApplicationPackagesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListApplicationPackagesResultIterator) Value() ApplicationPackage {
	if !iter.page.NotDone() {
		return ApplicationPackage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListApplicationPackagesResultIterator type.
func NewListApplicationPackagesResultIterator(page ListApplicationPackagesResultPage) ListApplicationPackagesResultIterator {
	return ListApplicationPackagesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lapr ListApplicationPackagesResult) IsEmpty() bool {
	return lapr.Value == nil || len(*lapr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lapr ListApplicationPackagesResult) hasNextLink() bool {
	return lapr.NextLink != nil && len(*lapr.NextLink) != 0
}

// listApplicationPackagesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lapr ListApplicationPackagesResult) listApplicationPackagesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lapr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lapr.NextLink)))
}

// ListApplicationPackagesResultPage contains a page of ApplicationPackage values.
type ListApplicationPackagesResultPage struct {
	fn   func(context.Context, ListApplicationPackagesResult) (ListApplicationPackagesResult, error)
	lapr ListApplicationPackagesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListApplicationPackagesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListApplicationPackagesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lapr)
		if err != nil {
			return err
		}
		page.lapr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListApplicationPackagesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListApplicationPackagesResultPage) NotDone() bool {
	return !page.lapr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListApplicationPackagesResultPage) Response() ListApplicationPackagesResult {
	return page.lapr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListApplicationPackagesResultPage) Values() []ApplicationPackage {
	if page.lapr.IsEmpty() {
		return nil
	}
	return *page.lapr.Value
}

// Creates a new instance of the ListApplicationPackagesResultPage type.
func NewListApplicationPackagesResultPage(cur ListApplicationPackagesResult, getNextPage func(context.Context, ListApplicationPackagesResult) (ListApplicationPackagesResult, error)) ListApplicationPackagesResultPage {
	return ListApplicationPackagesResultPage{
		fn:   getNextPage,
		lapr: cur,
	}
}

// ListApplicationsResult the result of performing list applications.
type ListApplicationsResult struct {
	autorest.Response `json:"-"`
	// Value - The list of applications.
	Value *[]Application `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListApplicationsResultIterator provides access to a complete listing of Application values.
type ListApplicationsResultIterator struct {
	i    int
	page ListApplicationsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListApplicationsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListApplicationsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListApplicationsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListApplicationsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListApplicationsResultIterator) Response() ListApplicationsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListApplicationsResultIterator) Value() Application {
	if !iter.page.NotDone() {
		return Application{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListApplicationsResultIterator type.
func NewListApplicationsResultIterator(page ListApplicationsResultPage) ListApplicationsResultIterator {
	return ListApplicationsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lar ListApplicationsResult) IsEmpty() bool {
	return lar.Value == nil || len(*lar.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lar ListApplicationsResult) hasNextLink() bool {
	return lar.NextLink != nil && len(*lar.NextLink) != 0
}

// listApplicationsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lar ListApplicationsResult) listApplicationsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lar.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lar.NextLink)))
}

// ListApplicationsResultPage contains a page of Application values.
type ListApplicationsResultPage struct {
	fn  func(context.Context, ListApplicationsResult) (ListApplicationsResult, error)
	lar ListApplicationsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListApplicationsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListApplicationsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lar)
		if err != nil {
			return err
		}
		page.lar = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListApplicationsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListApplicationsResultPage) NotDone() bool {
	return !page.lar.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListApplicationsResultPage) Response() ListApplicationsResult {
	return page.lar
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListApplicationsResultPage) Values() []Application {
	if page.lar.IsEmpty() {
		return nil
	}
	return *page.lar.Value
}

// Creates a new instance of the ListApplicationsResultPage type.
func NewListApplicationsResultPage(cur ListApplicationsResult, getNextPage func(context.Context, ListApplicationsResult) (ListApplicationsResult, error)) ListApplicationsResultPage {
	return ListApplicationsResultPage{
		fn:  getNextPage,
		lar: cur,
	}
}

// ListCertificatesResult values returned by the List operation.
type ListCertificatesResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of returned certificates.
	Value *[]Certificate `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListCertificatesResultIterator provides access to a complete listing of Certificate values.
type ListCertificatesResultIterator struct {
	i    int
	page ListCertificatesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListCertificatesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListCertificatesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListCertificatesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListCertificatesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListCertificatesResultIterator) Response() ListCertificatesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListCertificatesResultIterator) Value() Certificate {
	if !iter.page.NotDone() {
		return Certificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListCertificatesResultIterator type.
func NewListCertificatesResultIterator(page ListCertificatesResultPage) ListCertificatesResultIterator {
	return ListCertificatesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lcr ListCertificatesResult) IsEmpty() bool {
	return lcr.Value == nil || len(*lcr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lcr ListCertificatesResult) hasNextLink() bool {
	return lcr.NextLink != nil && len(*lcr.NextLink) != 0
}

// listCertificatesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lcr ListCertificatesResult) listCertificatesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lcr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lcr.NextLink)))
}

// ListCertificatesResultPage contains a page of Certificate values.
type ListCertificatesResultPage struct {
	fn  func(context.Context, ListCertificatesResult) (ListCertificatesResult, error)
	lcr ListCertificatesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListCertificatesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListCertificatesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lcr)
		if err != nil {
			return err
		}
		page.lcr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListCertificatesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListCertificatesResultPage) NotDone() bool {
	return !page.lcr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListCertificatesResultPage) Response() ListCertificatesResult {
	return page.lcr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListCertificatesResultPage) Values() []Certificate {
	if page.lcr.IsEmpty() {
		return nil
	}
	return *page.lcr.Value
}

// Creates a new instance of the ListCertificatesResultPage type.
func NewListCertificatesResultPage(cur ListCertificatesResult, getNextPage func(context.Context, ListCertificatesResult) (ListCertificatesResult, error)) ListCertificatesResultPage {
	return ListCertificatesResultPage{
		fn:  getNextPage,
		lcr: cur,
	}
}

// ListPoolsResult values returned by the List operation.
type ListPoolsResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of returned pools.
	Value *[]Pool `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListPoolsResultIterator provides access to a complete listing of Pool values.
type ListPoolsResultIterator struct {
	i    int
	page ListPoolsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListPoolsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListPoolsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListPoolsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListPoolsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListPoolsResultIterator) Response() ListPoolsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListPoolsResultIterator) Value() Pool {
	if !iter.page.NotDone() {
		return Pool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListPoolsResultIterator type.
func NewListPoolsResultIterator(page ListPoolsResultPage) ListPoolsResultIterator {
	return ListPoolsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lpr ListPoolsResult) IsEmpty() bool {
	return lpr.Value == nil || len(*lpr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lpr ListPoolsResult) hasNextLink() bool {
	return lpr.NextLink != nil && len(*lpr.NextLink) != 0
}

// listPoolsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lpr ListPoolsResult) listPoolsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lpr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lpr.NextLink)))
}

// ListPoolsResultPage contains a page of Pool values.
type ListPoolsResultPage struct {
	fn  func(context.Context, ListPoolsResult) (ListPoolsResult, error)
	lpr ListPoolsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListPoolsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListPoolsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lpr)
		if err != nil {
			return err
		}
		page.lpr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListPoolsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListPoolsResultPage) NotDone() bool {
	return !page.lpr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListPoolsResultPage) Response() ListPoolsResult {
	return page.lpr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListPoolsResultPage) Values() []Pool {
	if page.lpr.IsEmpty() {
		return nil
	}
	return *page.lpr.Value
}

// Creates a new instance of the ListPoolsResultPage type.
func NewListPoolsResultPage(cur ListPoolsResult, getNextPage func(context.Context, ListPoolsResult) (ListPoolsResult, error)) ListPoolsResultPage {
	return ListPoolsResultPage{
		fn:  getNextPage,
		lpr: cur,
	}
}

// ListPrivateEndpointConnectionsResult values returned by the List operation.
type ListPrivateEndpointConnectionsResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of returned private endpoint connection.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListPrivateEndpointConnectionsResultIterator provides access to a complete listing of
// PrivateEndpointConnection values.
type ListPrivateEndpointConnectionsResultIterator struct {
	i    int
	page ListPrivateEndpointConnectionsResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListPrivateEndpointConnectionsResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListPrivateEndpointConnectionsResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListPrivateEndpointConnectionsResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListPrivateEndpointConnectionsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListPrivateEndpointConnectionsResultIterator) Response() ListPrivateEndpointConnectionsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListPrivateEndpointConnectionsResultIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListPrivateEndpointConnectionsResultIterator type.
func NewListPrivateEndpointConnectionsResultIterator(page ListPrivateEndpointConnectionsResultPage) ListPrivateEndpointConnectionsResultIterator {
	return ListPrivateEndpointConnectionsResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lpecr ListPrivateEndpointConnectionsResult) IsEmpty() bool {
	return lpecr.Value == nil || len(*lpecr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lpecr ListPrivateEndpointConnectionsResult) hasNextLink() bool {
	return lpecr.NextLink != nil && len(*lpecr.NextLink) != 0
}

// listPrivateEndpointConnectionsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lpecr ListPrivateEndpointConnectionsResult) listPrivateEndpointConnectionsResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lpecr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lpecr.NextLink)))
}

// ListPrivateEndpointConnectionsResultPage contains a page of PrivateEndpointConnection values.
type ListPrivateEndpointConnectionsResultPage struct {
	fn    func(context.Context, ListPrivateEndpointConnectionsResult) (ListPrivateEndpointConnectionsResult, error)
	lpecr ListPrivateEndpointConnectionsResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListPrivateEndpointConnectionsResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListPrivateEndpointConnectionsResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lpecr)
		if err != nil {
			return err
		}
		page.lpecr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListPrivateEndpointConnectionsResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListPrivateEndpointConnectionsResultPage) NotDone() bool {
	return !page.lpecr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListPrivateEndpointConnectionsResultPage) Response() ListPrivateEndpointConnectionsResult {
	return page.lpecr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListPrivateEndpointConnectionsResultPage) Values() []PrivateEndpointConnection {
	if page.lpecr.IsEmpty() {
		return nil
	}
	return *page.lpecr.Value
}

// Creates a new instance of the ListPrivateEndpointConnectionsResultPage type.
func NewListPrivateEndpointConnectionsResultPage(cur ListPrivateEndpointConnectionsResult, getNextPage func(context.Context, ListPrivateEndpointConnectionsResult) (ListPrivateEndpointConnectionsResult, error)) ListPrivateEndpointConnectionsResultPage {
	return ListPrivateEndpointConnectionsResultPage{
		fn:    getNextPage,
		lpecr: cur,
	}
}

// ListPrivateLinkResourcesResult values returned by the List operation.
type ListPrivateLinkResourcesResult struct {
	autorest.Response `json:"-"`
	// Value - The collection of returned private link resources.
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListPrivateLinkResourcesResultIterator provides access to a complete listing of PrivateLinkResource
// values.
type ListPrivateLinkResourcesResultIterator struct {
	i    int
	page ListPrivateLinkResourcesResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListPrivateLinkResourcesResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListPrivateLinkResourcesResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListPrivateLinkResourcesResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListPrivateLinkResourcesResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListPrivateLinkResourcesResultIterator) Response() ListPrivateLinkResourcesResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListPrivateLinkResourcesResultIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListPrivateLinkResourcesResultIterator type.
func NewListPrivateLinkResourcesResultIterator(page ListPrivateLinkResourcesResultPage) ListPrivateLinkResourcesResultIterator {
	return ListPrivateLinkResourcesResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lplrr ListPrivateLinkResourcesResult) IsEmpty() bool {
	return lplrr.Value == nil || len(*lplrr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lplrr ListPrivateLinkResourcesResult) hasNextLink() bool {
	return lplrr.NextLink != nil && len(*lplrr.NextLink) != 0
}

// listPrivateLinkResourcesResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lplrr ListPrivateLinkResourcesResult) listPrivateLinkResourcesResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lplrr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lplrr.NextLink)))
}

// ListPrivateLinkResourcesResultPage contains a page of PrivateLinkResource values.
type ListPrivateLinkResourcesResultPage struct {
	fn    func(context.Context, ListPrivateLinkResourcesResult) (ListPrivateLinkResourcesResult, error)
	lplrr ListPrivateLinkResourcesResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListPrivateLinkResourcesResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListPrivateLinkResourcesResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lplrr)
		if err != nil {
			return err
		}
		page.lplrr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListPrivateLinkResourcesResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListPrivateLinkResourcesResultPage) NotDone() bool {
	return !page.lplrr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListPrivateLinkResourcesResultPage) Response() ListPrivateLinkResourcesResult {
	return page.lplrr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListPrivateLinkResourcesResultPage) Values() []PrivateLinkResource {
	if page.lplrr.IsEmpty() {
		return nil
	}
	return *page.lplrr.Value
}

// Creates a new instance of the ListPrivateLinkResourcesResultPage type.
func NewListPrivateLinkResourcesResultPage(cur ListPrivateLinkResourcesResult, getNextPage func(context.Context, ListPrivateLinkResourcesResult) (ListPrivateLinkResourcesResult, error)) ListPrivateLinkResourcesResultPage {
	return ListPrivateLinkResourcesResultPage{
		fn:    getNextPage,
		lplrr: cur,
	}
}

// LocationQuota quotas associated with a Batch region for a particular subscription.
type LocationQuota struct {
	autorest.Response `json:"-"`
	// AccountQuota - READ-ONLY; The number of Batch accounts that may be created under the subscription in the specified region.
	AccountQuota *int32 `json:"accountQuota,omitempty"`
}

// MarshalJSON is the custom marshaler for LocationQuota.
func (lq LocationQuota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetadataItem the Batch service does not assign any meaning to this metadata; it is solely for the use of
// user code.
type MetadataItem struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// MountConfiguration ...
type MountConfiguration struct {
	// AzureBlobFileSystemConfiguration - This property is mutually exclusive with all other properties.
	AzureBlobFileSystemConfiguration *AzureBlobFileSystemConfiguration `json:"azureBlobFileSystemConfiguration,omitempty"`
	// NfsMountConfiguration - This property is mutually exclusive with all other properties.
	NfsMountConfiguration *NFSMountConfiguration `json:"nfsMountConfiguration,omitempty"`
	// CifsMountConfiguration - This property is mutually exclusive with all other properties.
	CifsMountConfiguration *CIFSMountConfiguration `json:"cifsMountConfiguration,omitempty"`
	// AzureFileShareConfiguration - This property is mutually exclusive with all other properties.
	AzureFileShareConfiguration *AzureFileShareConfiguration `json:"azureFileShareConfiguration,omitempty"`
}

// NetworkConfiguration the network configuration for a pool.
type NetworkConfiguration struct {
	// SubnetID - The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
	SubnetID *string `json:"subnetId,omitempty"`
	// EndpointConfiguration - Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
	EndpointConfiguration *PoolEndpointConfiguration `json:"endpointConfiguration,omitempty"`
	// PublicIPAddressConfiguration - This property is only supported on Pools with the virtualMachineConfiguration property.
	PublicIPAddressConfiguration *PublicIPAddressConfiguration `json:"publicIPAddressConfiguration,omitempty"`
}

// NetworkSecurityGroupRule ...
type NetworkSecurityGroupRule struct {
	// Priority - Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
	Priority *int32 `json:"priority,omitempty"`
	// Access - Possible values include: 'NetworkSecurityGroupRuleAccessAllow', 'NetworkSecurityGroupRuleAccessDeny'
	Access NetworkSecurityGroupRuleAccess `json:"access,omitempty"`
	// SourceAddressPrefix - Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// SourcePortRanges - Valid values are '*' (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be *.
	SourcePortRanges *[]string `json:"sourcePortRanges,omitempty"`
}

// NFSMountConfiguration ...
type NFSMountConfiguration struct {
	Source *string `json:"source,omitempty"`
	// RelativeMountPath - All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
	RelativeMountPath *string `json:"relativeMountPath,omitempty"`
	// MountOptions - These are 'net use' options in Windows and 'mount' options in Linux.
	MountOptions *string `json:"mountOptions,omitempty"`
}

// NodePlacementConfiguration allocation configuration used by Batch Service to provision the nodes.
type NodePlacementConfiguration struct {
	// Policy - Allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional policy. Possible values include: 'NodePlacementPolicyTypeRegional', 'NodePlacementPolicyTypeZonal'
	Policy NodePlacementPolicyType `json:"policy,omitempty"`
}

// Operation ...
type Operation struct {
	// Name - This is of the format {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool             `json:"isDataAction,omitempty"`
	Display      *OperationDisplay `json:"display,omitempty"`
	Origin       *string           `json:"origin,omitempty"`
	Properties   interface{}       `json:"properties,omitempty"`
}

// OperationDisplay ...
type OperationDisplay struct {
	Provider *string `json:"provider,omitempty"`
	// Operation - For example: read, write, delete, or listKeys/action
	Operation   *string `json:"operation,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationListResult ...
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OSDisk ...
type OSDisk struct {
	EphemeralOSDiskSettings *DiffDiskSettings `json:"ephemeralOSDiskSettings,omitempty"`
}

// OutboundEnvironmentEndpoint a collection of related endpoints from the same service for which the Batch
// service requires outbound access.
type OutboundEnvironmentEndpoint struct {
	// Category - READ-ONLY; The type of service that the Batch service connects to.
	Category *string `json:"category,omitempty"`
	// Endpoints - READ-ONLY; The endpoints for this service to which the Batch service makes outbound calls.
	Endpoints *[]EndpointDependency `json:"endpoints,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundEnvironmentEndpoint.
func (oee OutboundEnvironmentEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OutboundEnvironmentEndpointCollection values returned by the List operation.
type OutboundEnvironmentEndpointCollection struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The collection of outbound network dependency endpoints returned by the listing operation.
	Value *[]OutboundEnvironmentEndpoint `json:"value,omitempty"`
	// NextLink - The continuation token.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundEnvironmentEndpointCollection.
func (oeec OutboundEnvironmentEndpointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oeec.NextLink != nil {
		objectMap["nextLink"] = oeec.NextLink
	}
	return json.Marshal(objectMap)
}

// OutboundEnvironmentEndpointCollectionIterator provides access to a complete listing of
// OutboundEnvironmentEndpoint values.
type OutboundEnvironmentEndpointCollectionIterator struct {
	i    int
	page OutboundEnvironmentEndpointCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OutboundEnvironmentEndpointCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundEnvironmentEndpointCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OutboundEnvironmentEndpointCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OutboundEnvironmentEndpointCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OutboundEnvironmentEndpointCollectionIterator) Response() OutboundEnvironmentEndpointCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OutboundEnvironmentEndpointCollectionIterator) Value() OutboundEnvironmentEndpoint {
	if !iter.page.NotDone() {
		return OutboundEnvironmentEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OutboundEnvironmentEndpointCollectionIterator type.
func NewOutboundEnvironmentEndpointCollectionIterator(page OutboundEnvironmentEndpointCollectionPage) OutboundEnvironmentEndpointCollectionIterator {
	return OutboundEnvironmentEndpointCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oeec OutboundEnvironmentEndpointCollection) IsEmpty() bool {
	return oeec.Value == nil || len(*oeec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oeec OutboundEnvironmentEndpointCollection) hasNextLink() bool {
	return oeec.NextLink != nil && len(*oeec.NextLink) != 0
}

// outboundEnvironmentEndpointCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oeec OutboundEnvironmentEndpointCollection) outboundEnvironmentEndpointCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !oeec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oeec.NextLink)))
}

// OutboundEnvironmentEndpointCollectionPage contains a page of OutboundEnvironmentEndpoint values.
type OutboundEnvironmentEndpointCollectionPage struct {
	fn   func(context.Context, OutboundEnvironmentEndpointCollection) (OutboundEnvironmentEndpointCollection, error)
	oeec OutboundEnvironmentEndpointCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OutboundEnvironmentEndpointCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundEnvironmentEndpointCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oeec)
		if err != nil {
			return err
		}
		page.oeec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OutboundEnvironmentEndpointCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OutboundEnvironmentEndpointCollectionPage) NotDone() bool {
	return !page.oeec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OutboundEnvironmentEndpointCollectionPage) Response() OutboundEnvironmentEndpointCollection {
	return page.oeec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OutboundEnvironmentEndpointCollectionPage) Values() []OutboundEnvironmentEndpoint {
	if page.oeec.IsEmpty() {
		return nil
	}
	return *page.oeec.Value
}

// Creates a new instance of the OutboundEnvironmentEndpointCollectionPage type.
func NewOutboundEnvironmentEndpointCollectionPage(cur OutboundEnvironmentEndpointCollection, getNextPage func(context.Context, OutboundEnvironmentEndpointCollection) (OutboundEnvironmentEndpointCollection, error)) OutboundEnvironmentEndpointCollectionPage {
	return OutboundEnvironmentEndpointCollectionPage{
		fn:   getNextPage,
		oeec: cur,
	}
}

// Pool contains information about a pool.
type Pool struct {
	autorest.Response `json:"-"`
	// PoolProperties - The properties associated with the pool.
	*PoolProperties `json:"properties,omitempty"`
	// Identity - The type of identity used for the Batch Pool.
	Identity *PoolIdentity `json:"identity,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Pool.
func (p Pool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PoolProperties != nil {
		objectMap["properties"] = p.PoolProperties
	}
	if p.Identity != nil {
		objectMap["identity"] = p.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Pool struct.
func (p *Pool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var poolProperties PoolProperties
				err = json.Unmarshal(*v, &poolProperties)
				if err != nil {
					return err
				}
				p.PoolProperties = &poolProperties
			}
		case "identity":
			if v != nil {
				var identity PoolIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				p.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				p.Etag = &etag
			}
		}
	}

	return nil
}

// PoolDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type PoolDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PoolClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PoolDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PoolDeleteFuture.Result.
func (future *PoolDeleteFuture) result(client PoolClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.PoolDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batch.PoolDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PoolEndpointConfiguration ...
type PoolEndpointConfiguration struct {
	// InboundNatPools - The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400. This cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses.
	InboundNatPools *[]InboundNatPool `json:"inboundNatPools,omitempty"`
}

// PoolIdentity the identity of the Batch pool, if configured. If the pool identity is updated during
// update an existing pool, only the new vms which are created after the pool shrinks to 0 will have the
// updated identities
type PoolIdentity struct {
	// Type - The type of identity used for the Batch Pool. Possible values include: 'PoolIdentityTypeUserAssigned', 'PoolIdentityTypeNone'
	Type PoolIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the Batch pool.
	UserAssignedIdentities map[string]*UserAssignedIdentities `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for PoolIdentity.
func (pi PoolIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pi.Type != "" {
		objectMap["type"] = pi.Type
	}
	if pi.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = pi.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// PoolProperties pool properties.
type PoolProperties struct {
	// DisplayName - The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// LastModified - READ-ONLY; This is the last time at which the pool level data, such as the targetDedicatedNodes or autoScaleSettings, changed. It does not factor in node-level changes such as a compute node changing state.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// CreationTime - READ-ONLY
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ProvisioningState - READ-ONLY; Possible values include: 'PoolProvisioningStateSucceeded', 'PoolProvisioningStateDeleting'
	ProvisioningState PoolProvisioningState `json:"provisioningState,omitempty"`
	// ProvisioningStateTransitionTime - READ-ONLY
	ProvisioningStateTransitionTime *date.Time `json:"provisioningStateTransitionTime,omitempty"`
	// AllocationState - READ-ONLY; Possible values include: 'AllocationStateSteady', 'AllocationStateResizing', 'AllocationStateStopping'
	AllocationState AllocationState `json:"allocationState,omitempty"`
	// AllocationStateTransitionTime - READ-ONLY
	AllocationStateTransitionTime *date.Time `json:"allocationStateTransitionTime,omitempty"`
	// VMSize - For information about available sizes of virtual machines for Cloud Services pools (pools created with cloudServiceConfiguration), see Sizes for Cloud Services (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/). Batch supports all Cloud Services VM sizes except ExtraSmall. For information about available VM sizes for pools using images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration) see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
	VMSize *string `json:"vmSize,omitempty"`
	// DeploymentConfiguration - Using CloudServiceConfiguration specifies that the nodes should be creating using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses Azure Virtual Machines (IaaS).
	DeploymentConfiguration *DeploymentConfiguration `json:"deploymentConfiguration,omitempty"`
	// CurrentDedicatedNodes - READ-ONLY
	CurrentDedicatedNodes *int32 `json:"currentDedicatedNodes,omitempty"`
	// CurrentLowPriorityNodes - READ-ONLY
	CurrentLowPriorityNodes *int32         `json:"currentLowPriorityNodes,omitempty"`
	ScaleSettings           *ScaleSettings `json:"scaleSettings,omitempty"`
	// AutoScaleRun - READ-ONLY; This property is set only if the pool automatically scales, i.e. autoScaleSettings are used.
	AutoScaleRun *AutoScaleRun `json:"autoScaleRun,omitempty"`
	// InterNodeCommunication - This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. If not specified, this value defaults to 'Disabled'. Possible values include: 'InterNodeCommunicationStateEnabled', 'InterNodeCommunicationStateDisabled'
	InterNodeCommunication InterNodeCommunicationState `json:"interNodeCommunication,omitempty"`
	NetworkConfiguration   *NetworkConfiguration       `json:"networkConfiguration,omitempty"`
	// TaskSlotsPerNode - The default value is 1. The maximum value is the smaller of 4 times the number of cores of the vmSize of the pool or 256.
	TaskSlotsPerNode *int32 `json:"taskSlotsPerNode,omitempty"`
	// TaskSchedulingPolicy - If not specified, the default is spread.
	TaskSchedulingPolicy *TaskSchedulingPolicy `json:"taskSchedulingPolicy,omitempty"`
	UserAccounts         *[]UserAccount        `json:"userAccounts,omitempty"`
	// Metadata - The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
	// StartTask - In an PATCH (update) operation, this property can be set to an empty object to remove the start task from the pool.
	StartTask *StartTask `json:"startTask,omitempty"`
	// Certificates - For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
	Certificates *[]CertificateReference `json:"certificates,omitempty"`
	// ApplicationPackages - Changes to application package references affect all new compute nodes joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10 application package references on any given pool.
	ApplicationPackages *[]ApplicationPackageReference `json:"applicationPackages,omitempty"`
	// ApplicationLicenses - The list of application licenses must be a subset of available Batch service application licenses. If a license is requested which is not supported, pool creation will fail.
	ApplicationLicenses *[]string `json:"applicationLicenses,omitempty"`
	// ResizeOperationStatus - READ-ONLY
	ResizeOperationStatus *ResizeOperationStatus `json:"resizeOperationStatus,omitempty"`
	// MountConfiguration - This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
	MountConfiguration *[]MountConfiguration `json:"mountConfiguration,omitempty"`
}

// MarshalJSON is the custom marshaler for PoolProperties.
func (pp PoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.DisplayName != nil {
		objectMap["displayName"] = pp.DisplayName
	}
	if pp.VMSize != nil {
		objectMap["vmSize"] = pp.VMSize
	}
	if pp.DeploymentConfiguration != nil {
		objectMap["deploymentConfiguration"] = pp.DeploymentConfiguration
	}
	if pp.ScaleSettings != nil {
		objectMap["scaleSettings"] = pp.ScaleSettings
	}
	if pp.InterNodeCommunication != "" {
		objectMap["interNodeCommunication"] = pp.InterNodeCommunication
	}
	if pp.NetworkConfiguration != nil {
		objectMap["networkConfiguration"] = pp.NetworkConfiguration
	}
	if pp.TaskSlotsPerNode != nil {
		objectMap["taskSlotsPerNode"] = pp.TaskSlotsPerNode
	}
	if pp.TaskSchedulingPolicy != nil {
		objectMap["taskSchedulingPolicy"] = pp.TaskSchedulingPolicy
	}
	if pp.UserAccounts != nil {
		objectMap["userAccounts"] = pp.UserAccounts
	}
	if pp.Metadata != nil {
		objectMap["metadata"] = pp.Metadata
	}
	if pp.StartTask != nil {
		objectMap["startTask"] = pp.StartTask
	}
	if pp.Certificates != nil {
		objectMap["certificates"] = pp.Certificates
	}
	if pp.ApplicationPackages != nil {
		objectMap["applicationPackages"] = pp.ApplicationPackages
	}
	if pp.ApplicationLicenses != nil {
		objectMap["applicationLicenses"] = pp.ApplicationLicenses
	}
	if pp.MountConfiguration != nil {
		objectMap["mountConfiguration"] = pp.MountConfiguration
	}
	return json.Marshal(objectMap)
}

// PrivateEndpoint the private endpoint of the private endpoint connection.
type PrivateEndpoint struct {
	// ID - READ-ONLY
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection contains information about a private link resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - The properties associated with the private endpoint connection.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pec.Etag = &etag
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionProperties private endpoint connection properties.
type PrivateEndpointConnectionProperties struct {
	// ProvisioningState - READ-ONLY; Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateUpdating', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState                 PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
	PrivateEndpoint                   *PrivateEndpoint                           `json:"privateEndpoint,omitempty"`
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState         `json:"privateLinkServiceConnectionState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pecp.PrivateEndpoint
	}
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionUpdateFuture.Result.
func (future *PrivateEndpointConnectionUpdateFuture) result(client PrivateEndpointConnectionClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.PrivateEndpointConnectionUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("batch.PrivateEndpointConnectionUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.UpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "batch.PrivateEndpointConnectionUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateLinkResource contains information about a private link resource.
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// PrivateLinkResourceProperties - The properties associated with the private link resource.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				plr.Etag = &etag
			}
		}
	}

	return nil
}

// PrivateLinkResourceProperties private link resource properties.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The group id is used to establish the private link connection.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - READ-ONLY
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState the private link service connection state of the private endpoint
// connection
type PrivateLinkServiceConnectionState struct {
	// Status - Possible values include: 'PrivateLinkServiceConnectionStatusApproved', 'PrivateLinkServiceConnectionStatusPending', 'PrivateLinkServiceConnectionStatusRejected', 'PrivateLinkServiceConnectionStatusDisconnected'
	Status      PrivateLinkServiceConnectionStatus `json:"status,omitempty"`
	Description *string                            `json:"description,omitempty"`
	// ActionRequired - READ-ONLY
	ActionRequired *string `json:"actionRequired,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceConnectionState.
func (plscs PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plscs.Status != "" {
		objectMap["status"] = plscs.Status
	}
	if plscs.Description != nil {
		objectMap["description"] = plscs.Description
	}
	return json.Marshal(objectMap)
}

// ProxyResource a definition of an Azure resource.
type ProxyResource struct {
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The ETag of the resource, used for concurrency statements.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PublicIPAddressConfiguration the public IP Address configuration of the networking configuration of a
// Pool.
type PublicIPAddressConfiguration struct {
	// Provision - The default value is BatchManaged. Possible values include: 'IPAddressProvisioningTypeBatchManaged', 'IPAddressProvisioningTypeUserManaged', 'IPAddressProvisioningTypeNoPublicIPAddresses'
	Provision IPAddressProvisioningType `json:"provision,omitempty"`
	// IPAddressIds - The number of IPs specified here limits the maximum size of the Pool - 100 dedicated nodes or 100 low-priority nodes can be allocated for each public IP. For example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
	IPAddressIds *[]string `json:"ipAddressIds,omitempty"`
}

// ResizeError ...
type ResizeError struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string        `json:"message,omitempty"`
	Details *[]ResizeError `json:"details,omitempty"`
}

// ResizeOperationStatus describes either the current operation (if the pool AllocationState is Resizing)
// or the previously completed operation (if the AllocationState is Steady).
type ResizeOperationStatus struct {
	TargetDedicatedNodes   *int32 `json:"targetDedicatedNodes,omitempty"`
	TargetLowPriorityNodes *int32 `json:"targetLowPriorityNodes,omitempty"`
	// ResizeTimeout - The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// NodeDeallocationOption - The default value is requeue. Possible values include: 'ComputeNodeDeallocationOptionRequeue', 'ComputeNodeDeallocationOptionTerminate', 'ComputeNodeDeallocationOptionTaskCompletion', 'ComputeNodeDeallocationOptionRetainedData'
	NodeDeallocationOption ComputeNodeDeallocationOption `json:"nodeDeallocationOption,omitempty"`
	StartTime              *date.Time                    `json:"startTime,omitempty"`
	// Errors - This property is set only if an error occurred during the last pool resize, and only when the pool allocationState is Steady.
	Errors *[]ResizeError `json:"errors,omitempty"`
}

// Resource a definition of an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceFile ...
type ResourceFile struct {
	// AutoStorageContainerName - The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
	AutoStorageContainerName *string `json:"autoStorageContainerName,omitempty"`
	// StorageContainerURL - The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable from compute nodes. There are three ways to get such a URL for a container in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the container, use a managed identity with read and list permissions, or set the ACL for the container to allow public access.
	StorageContainerURL *string `json:"storageContainerUrl,omitempty"`
	// HTTPURL - The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL points to Azure Blob Storage, it must be readable from compute nodes. There are three ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, use a managed identity with read permission, or set the ACL for the blob or its container to allow public access.
	HTTPURL *string `json:"httpUrl,omitempty"`
	// BlobPrefix - The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
	BlobPrefix *string `json:"blobPrefix,omitempty"`
	// FilePath - If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
	FilePath *string `json:"filePath,omitempty"`
	// FileMode - This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
	FileMode          *string                       `json:"fileMode,omitempty"`
	IdentityReference *ComputeNodeIdentityReference `json:"identityReference,omitempty"`
}

// ScaleSettings defines the desired size of the pool. This can either be 'fixedScale' where the requested
// targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically
// reevaluated. If this property is not specified, the pool will have a fixed scale with 0
// targetDedicatedNodes.
type ScaleSettings struct {
	// FixedScale - This property and autoScale are mutually exclusive and one of the properties must be specified.
	FixedScale *FixedScaleSettings `json:"fixedScale,omitempty"`
	// AutoScale - This property and fixedScale are mutually exclusive and one of the properties must be specified.
	AutoScale *AutoScaleSettings `json:"autoScale,omitempty"`
}

// SkuCapability a SKU capability, such as the number of cores.
type SkuCapability struct {
	// Name - READ-ONLY; The name of the feature.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; The value of the feature.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuCapability.
func (sc SkuCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// StartTask in some cases the start task may be re-run even though the node was not rebooted. Due to this,
// start tasks should be idempotent and exit gracefully if the setup they're performing has already been
// done. Special care should be taken to avoid start tasks which create breakaway process or install/launch
// services from the start task working directory, as this will block Batch from being able to re-run the
// start task.
type StartTask struct {
	// CommandLine - The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
	CommandLine         *string               `json:"commandLine,omitempty"`
	ResourceFiles       *[]ResourceFile       `json:"resourceFiles,omitempty"`
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	// UserIdentity - If omitted, the task runs as a non-administrative user unique to the task.
	UserIdentity *UserIdentity `json:"userIdentity,omitempty"`
	// MaxTaskRetryCount - The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit.
	MaxTaskRetryCount *int32 `json:"maxTaskRetryCount,omitempty"`
	// WaitForSuccess - If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is true.
	WaitForSuccess *bool `json:"waitForSuccess,omitempty"`
	// ContainerSettings - When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
	ContainerSettings *TaskContainerSettings `json:"containerSettings,omitempty"`
}

// SupportedSku describes a Batch supported SKU.
type SupportedSku struct {
	// Name - READ-ONLY; The name of the SKU.
	Name *string `json:"name,omitempty"`
	// FamilyName - READ-ONLY; The family name of the SKU.
	FamilyName *string `json:"familyName,omitempty"`
	// Capabilities - READ-ONLY; A collection of capabilities which this SKU supports.
	Capabilities *[]SkuCapability `json:"capabilities,omitempty"`
}

// MarshalJSON is the custom marshaler for SupportedSku.
func (ss SupportedSku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SupportedSkusResult the Batch List supported SKUs operation response.
type SupportedSkusResult struct {
	autorest.Response `json:"-"`
	// Value - The list of SKUs available for the Batch service in the location.
	Value *[]SupportedSku `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SupportedSkusResult.
func (ssr SupportedSkusResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssr.Value != nil {
		objectMap["value"] = ssr.Value
	}
	return json.Marshal(objectMap)
}

// SupportedSkusResultIterator provides access to a complete listing of SupportedSku values.
type SupportedSkusResultIterator struct {
	i    int
	page SupportedSkusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SupportedSkusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SupportedSkusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SupportedSkusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SupportedSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SupportedSkusResultIterator) Response() SupportedSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SupportedSkusResultIterator) Value() SupportedSku {
	if !iter.page.NotDone() {
		return SupportedSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SupportedSkusResultIterator type.
func NewSupportedSkusResultIterator(page SupportedSkusResultPage) SupportedSkusResultIterator {
	return SupportedSkusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssr SupportedSkusResult) IsEmpty() bool {
	return ssr.Value == nil || len(*ssr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ssr SupportedSkusResult) hasNextLink() bool {
	return ssr.NextLink != nil && len(*ssr.NextLink) != 0
}

// supportedSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssr SupportedSkusResult) supportedSkusResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ssr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssr.NextLink)))
}

// SupportedSkusResultPage contains a page of SupportedSku values.
type SupportedSkusResultPage struct {
	fn  func(context.Context, SupportedSkusResult) (SupportedSkusResult, error)
	ssr SupportedSkusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SupportedSkusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SupportedSkusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ssr)
		if err != nil {
			return err
		}
		page.ssr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SupportedSkusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SupportedSkusResultPage) NotDone() bool {
	return !page.ssr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SupportedSkusResultPage) Response() SupportedSkusResult {
	return page.ssr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SupportedSkusResultPage) Values() []SupportedSku {
	if page.ssr.IsEmpty() {
		return nil
	}
	return *page.ssr.Value
}

// Creates a new instance of the SupportedSkusResultPage type.
func NewSupportedSkusResultPage(cur SupportedSkusResult, getNextPage func(context.Context, SupportedSkusResult) (SupportedSkusResult, error)) SupportedSkusResultPage {
	return SupportedSkusResultPage{
		fn:  getNextPage,
		ssr: cur,
	}
}

// TaskContainerSettings ...
type TaskContainerSettings struct {
	// ContainerRunOptions - These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
	ContainerRunOptions *string `json:"containerRunOptions,omitempty"`
	// ImageName - This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
	ImageName *string `json:"imageName,omitempty"`
	// Registry - This setting can be omitted if was already provided at pool creation.
	Registry *ContainerRegistry `json:"registry,omitempty"`
	// WorkingDirectory - Possible values include: 'ContainerWorkingDirectoryTaskWorkingDirectory', 'ContainerWorkingDirectoryContainerImageDefault'
	WorkingDirectory ContainerWorkingDirectory `json:"workingDirectory,omitempty"`
}

// TaskSchedulingPolicy ...
type TaskSchedulingPolicy struct {
	// NodeFillType - Possible values include: 'ComputeNodeFillTypeSpread', 'ComputeNodeFillTypePack'
	NodeFillType ComputeNodeFillType `json:"nodeFillType,omitempty"`
}

// UserAccount ...
type UserAccount struct {
	Name     *string `json:"name,omitempty"`
	Password *string `json:"password,omitempty"`
	// ElevationLevel - nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin. Possible values include: 'ElevationLevelNonAdmin', 'ElevationLevelAdmin'
	ElevationLevel ElevationLevel `json:"elevationLevel,omitempty"`
	// LinuxUserConfiguration - This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
	LinuxUserConfiguration *LinuxUserConfiguration `json:"linuxUserConfiguration,omitempty"`
	// WindowsUserConfiguration - This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
	WindowsUserConfiguration *WindowsUserConfiguration `json:"windowsUserConfiguration,omitempty"`
}

// UserAssignedIdentities the list of associated user identities.
type UserAssignedIdentities struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserAssignedIdentities.
func (uai UserAssignedIdentities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UserIdentity specify either the userName or autoUser property, but not both.
type UserIdentity struct {
	// UserName - The userName and autoUser properties are mutually exclusive; you must specify one but not both.
	UserName *string `json:"userName,omitempty"`
	// AutoUser - The userName and autoUser properties are mutually exclusive; you must specify one but not both.
	AutoUser *AutoUserSpecification `json:"autoUser,omitempty"`
}

// VirtualMachineConfiguration ...
type VirtualMachineConfiguration struct {
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	// NodeAgentSkuID - The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
	NodeAgentSkuID *string `json:"nodeAgentSkuId,omitempty"`
	// WindowsConfiguration - This property must not be specified if the imageReference specifies a Linux OS image.
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
	// DataDisks - This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
	DataDisks *[]DataDisk `json:"dataDisks,omitempty"`
	// LicenseType - This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:
	//  Windows_Server - The on-premises license is for Windows Server.
	//  Windows_Client - The on-premises license is for Windows Client.
	LicenseType *string `json:"licenseType,omitempty"`
	// ContainerConfiguration - If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
	ContainerConfiguration *ContainerConfiguration `json:"containerConfiguration,omitempty"`
	// DiskEncryptionConfiguration - If specified, encryption is performed on each node in the pool during node provisioning.
	DiskEncryptionConfiguration *DiskEncryptionConfiguration `json:"diskEncryptionConfiguration,omitempty"`
	// NodePlacementConfiguration - This configuration will specify rules on how nodes in the pool will be physically allocated.
	NodePlacementConfiguration *NodePlacementConfiguration `json:"nodePlacementConfiguration,omitempty"`
	// Extensions - If specified, the extensions mentioned in this configuration will be installed on each node.
	Extensions *[]VMExtension `json:"extensions,omitempty"`
	// OsDisk - Contains configuration for ephemeral OSDisk settings.
	OsDisk *OSDisk `json:"osDisk,omitempty"`
}

// VirtualMachineFamilyCoreQuota a VM Family and its associated core quota for the Batch account.
type VirtualMachineFamilyCoreQuota struct {
	// Name - READ-ONLY; The Virtual Machine family name.
	Name *string `json:"name,omitempty"`
	// CoreQuota - READ-ONLY; The core quota for the VM family for the Batch account.
	CoreQuota *int32 `json:"coreQuota,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineFamilyCoreQuota.
func (vmfcq VirtualMachineFamilyCoreQuota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VMExtension ...
type VMExtension struct {
	Name               *string `json:"name,omitempty"`
	Publisher          *string `json:"publisher,omitempty"`
	Type               *string `json:"type,omitempty"`
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// AutoUpgradeMinorVersion - Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
	AutoUpgradeMinorVersion *bool       `json:"autoUpgradeMinorVersion,omitempty"`
	Settings                interface{} `json:"settings,omitempty"`
	// ProtectedSettings - The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`
	// ProvisionAfterExtensions - Collection of extension names after which this extension needs to be provisioned.
	ProvisionAfterExtensions *[]string `json:"provisionAfterExtensions,omitempty"`
}

// WindowsConfiguration ...
type WindowsConfiguration struct {
	// EnableAutomaticUpdates - If omitted, the default value is true.
	EnableAutomaticUpdates *bool `json:"enableAutomaticUpdates,omitempty"`
}

// WindowsUserConfiguration ...
type WindowsUserConfiguration struct {
	// LoginMode - Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode. Possible values include: 'LoginModeBatch', 'LoginModeInteractive'
	LoginMode LoginMode `json:"loginMode,omitempty"`
}
