// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Generates sample utterances for an intent.
func (c *Client) GenerateBotElement(ctx context.Context, params *GenerateBotElementInput, optFns ...func(*Options)) (*GenerateBotElementOutput, error) {
	if params == nil {
		params = &GenerateBotElementInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GenerateBotElement", params, optFns, c.addOperationGenerateBotElementMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GenerateBotElementOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GenerateBotElementInput struct {

	// The bot unique Id for the bot request to generate utterances.
	//
	// This member is required.
	BotId *string

	// The bot version for the bot request to generate utterances.
	//
	// This member is required.
	BotVersion *string

	// The intent unique Id for the bot request to generate utterances.
	//
	// This member is required.
	IntentId *string

	// The unique locale Id for the bot request to generate utterances.
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

type GenerateBotElementOutput struct {

	// The unique bot Id for the bot which received the response.
	BotId *string

	// The unique bot version for the bot which received the response.
	BotVersion *string

	// The unique intent Id for the bot which received the response.
	IntentId *string

	// The unique locale Id for the bot which received the response.
	LocaleId *string

	// The sample utterances for the bot which received the response.
	SampleUtterances []types.SampleUtterance

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGenerateBotElementMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGenerateBotElement{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGenerateBotElement{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GenerateBotElement"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGenerateBotElementValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGenerateBotElement(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGenerateBotElement(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GenerateBotElement",
	}
}
