/*
evaluate.cpp - Source Code for ElephantEye, Part XI

ElephantEye - a Chinese Chess Program (UCCI Engine)
Designed by Morning Yellow, Version: 2.34, Last Modified: Oct. 2006
Copyright (C) 2004-2007 www.elephantbase.net

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "base.h"
#include "pregen.h"
#include "position.h"
#include "preeval.h"

#if _WIN32

#include <windows.h>

extern "C" __declspec(dllexport) int WINAPI Evaluate(const PositionStruct *lppos, int vlAlpha, int vlBeta);
extern "C" __declspec(dllexport) const char *WINAPI GetEngineName(void);

#else

#define WINAPI

extern "C" int Evaluate(const PositionStruct *lppos, int vlAlpha, int vlBeta);
extern "C" const char *GetEngineName(void);

#endif

/* ElephantEyeԴʹõǺԼ
 *
 * sq: (0255"pregen.cpp")
 * pc: (047"position.cpp")
 * pt: (06"position.cpp")
 * mv: ŷ(065535"position.cpp")
 * sd: ӷ(0췽1ڷ)
 * vl: ֵ("-MATE_VALUE""MATE_VALUE""position.cpp")
 * (עǺſucdwȴļǺʹ)
 * pos: (PositionStructͣ"position.h")
 * sms: λкλеŷԤýṹ("pregen.h")
 * smv: λкλеŷжԤýṹ("pregen.h")
 */

// ͵۵ı߽
const int EVAL_MARGIN1 = 160;
const int EVAL_MARGIN2 = 80;
const int EVAL_MARGIN3 = 40;
const int EVAL_MARGIN4 = 20;

// ģֻ漰"PositionStruct"е"sdPlayer""ucpcSquares""ucsqPieces""wBitPiece"ĸԱʡǰ"this->"

/* ElephantEyeľݹ44
 * 1. (ʿ)йص͵ۣ"AdvisorShape()"
 * 2. ǣ˧()򳵵͵ۣ"StringHold()"
 * 3. Եۣ"RookMobility()"
 * 4. ܵ谭ۣ"KnightTrap()"
 */

// ǵһ֣͵

/* (ʿ)״ھۣرжϿͷڡڵشãΪElephantEye״
 * 1. ˧()ԭλ˫(ʿ)ڵߣΪ1ţҪжϿͷں
 * 2. ˧()ԭλ˫(ʿ)߰Χ˧()Ϊ2ţҪжұߵĳںͳұߵ˧()ţ
 * 3. ˧()ԭλ˫(ʿ)ұ߰Χ˧()Ϊ3ţҪжߵĳںͳߵ˧()ţ
 * 4. ˧()ԭλȱ(ʿ)0
 * עԡºϡ̶̷λ涨ҡ
 */
const int WHITE_KING_BITFILE = 1 << (RANK_BOTTOM - RANK_TOP);
const int BLACK_KING_BITFILE = 1 << (RANK_TOP - RANK_TOP);
const int KING_BITRANK = 1 << (FILE_CENTER - FILE_LEFT);

const int SHAPE_NONE = 0;
const int SHAPE_CENTER = 1;
const int SHAPE_LEFT = 2;
const int SHAPE_RIGHT = 3;

int AdvisorShape(const PositionStruct *lppos) {
  int pcCannon, pcRook, sq, sqAdv1, sqAdv2, x, y, nShape;
  int vlWhitePenalty, vlBlackPenalty;
  SlideMaskStruct *lpsms;
  vlWhitePenalty = vlBlackPenalty = 0;
  if ((lppos->wBitPiece[0] & ADVISOR_BITPIECE) == ADVISOR_BITPIECE) {
    if (lppos->ucsqPieces[SIDE_TAG(0) + KING_FROM] == 0xc7) {
      sqAdv1 = lppos->ucsqPieces[SIDE_TAG(0) + ADVISOR_FROM];
      sqAdv2 = lppos->ucsqPieces[SIDE_TAG(0) + ADVISOR_TO];
      if (false) {
      } else if (sqAdv1 == 0xc6) { // 췽һ
        nShape = (sqAdv2 == 0xc8 ? SHAPE_CENTER : sqAdv2 == 0xb7 ? SHAPE_LEFT : SHAPE_NONE);
      } else if (sqAdv1 == 0xc8) { // 췽һҲ
        nShape = (sqAdv2 == 0xc6 ? SHAPE_CENTER : sqAdv2 == 0xb7 ? SHAPE_RIGHT : SHAPE_NONE);
      } else if (sqAdv1 == 0xb7) { // 췽һڻ
        nShape = (sqAdv2 == 0xc6 ? SHAPE_LEFT : sqAdv2 == 0xc8 ? SHAPE_RIGHT : SHAPE_NONE);
      } else {
        nShape = SHAPE_NONE;
      }
      switch (nShape) {
      case SHAPE_NONE:
        break;
      case SHAPE_CENTER:
        for (pcCannon = SIDE_TAG(1) + CANNON_FROM; pcCannon <= SIDE_TAG(1) + CANNON_TO; pcCannon ++) {
          sq = lppos->ucsqPieces[pcCannon];
          if (sq != 0) {
            x = FILE_X(sq);
            if (x == FILE_CENTER) {
              y = RANK_Y(sq);
              lpsms = lppos->FileMaskPtr(x, y);
              if ((lpsms->wRookCap & WHITE_KING_BITFILE) != 0) {
                // ͷڵв
                vlWhitePenalty += PreEvalEx.vlHollowThreat[RANK_FLIP(y)];
              } else if ((lpsms->wSuperCap & WHITE_KING_BITFILE) != 0 &&
                  (lppos->ucpcSquares[0xb7] == 21 || lppos->ucpcSquares[0xb7] == 22)) {
                // в
                vlWhitePenalty += PreEvalEx.vlCentralThreat[RANK_FLIP(y)];
              }
            }
          }
        }
        break;
      case SHAPE_LEFT:
      case SHAPE_RIGHT:
        for (pcCannon = SIDE_TAG(1) + CANNON_FROM; pcCannon <= SIDE_TAG(1) + CANNON_TO; pcCannon ++) {
          sq = lppos->ucsqPieces[pcCannon];
          if (sq != 0) {
            x = FILE_X(sq);
            y = RANK_Y(sq);
            if (x == FILE_CENTER) {
              if ((lppos->FileMaskPtr(x, y)->wSuperCap & WHITE_KING_BITFILE) != 0) {
                // һڵв˧()űԷƵĻжⷣ
                vlWhitePenalty += (PreEvalEx.vlCentralThreat[RANK_FLIP(y)] >> 2) +
                    (lppos->Protected(1, nShape == SHAPE_LEFT ? 0xc8 : 0xc6) ? 20 : 0);
                // ڵ߱˧()ķ֣
                for (pcRook = SIDE_TAG(0) + ROOK_FROM; pcRook <= SIDE_TAG(0) + ROOK_TO; pcRook ++) {
                  sq = lppos->ucsqPieces[pcRook];
                  if (sq != 0) {
                    y = RANK_Y(sq);
                    if (y == RANK_BOTTOM) {
                      x = FILE_X(sq);
                      if ((lppos->RankMaskPtr(x, y)->wRookCap & KING_BITRANK) != 0) {
                        vlWhitePenalty += 80;
                      }
                    }
                  }
                }
              }
            } else if (y == RANK_BOTTOM) {
              if ((lppos->RankMaskPtr(x, y)->wRookCap & KING_BITRANK) != 0) {
                // ڵв
                vlWhitePenalty += PreEvalEx.vlWhiteBottomThreat[x];
              }
            }
          }
        }
        break;
      default:
        break;
      }
    } else if (lppos->ucsqPieces[SIDE_TAG(0) + KING_FROM] == 0xb7) {
      // ˫(ʿ)ı˧()ռ죬Ҫ
      vlWhitePenalty += 20;
    }
  } else {
    if ((lppos->wBitPiece[1] & ROOK_BITPIECE) == ROOK_BITPIECE) {
      // ȱ(ʿ)˫з
      vlWhitePenalty += PreEvalEx.vlWhiteAdvisorLeakage;
    }
  }
  if ((lppos->wBitPiece[1] & ADVISOR_BITPIECE) == ADVISOR_BITPIECE) {
    if (lppos->ucsqPieces[SIDE_TAG(1) + KING_FROM] == 0x37) {
      sqAdv1 = lppos->ucsqPieces[SIDE_TAG(1) + ADVISOR_FROM];
      sqAdv2 = lppos->ucsqPieces[SIDE_TAG(1) + ADVISOR_TO];
      if (false) {
      } else if (sqAdv1 == 0x36) { // ڷһʿ
        nShape = (sqAdv2 == 0x38 ? SHAPE_CENTER : sqAdv2 == 0x47 ? SHAPE_LEFT : SHAPE_NONE);
      } else if (sqAdv1 == 0x38) { // ڷһʿҲ
        nShape = (sqAdv2 == 0x36 ? SHAPE_CENTER : sqAdv2 == 0x47 ? SHAPE_RIGHT : SHAPE_NONE);
      } else if (sqAdv1 == 0x47) { // ڷһʿڻ
        nShape = (sqAdv2 == 0x36 ? SHAPE_LEFT : sqAdv2 == 0x38 ? SHAPE_RIGHT : SHAPE_NONE);
      } else {
        nShape = SHAPE_NONE;
      }
      switch (nShape) {
      case SHAPE_NONE:
        break;
      case SHAPE_CENTER:
        for (pcCannon = SIDE_TAG(0) + CANNON_FROM; pcCannon <= SIDE_TAG(0) + CANNON_TO; pcCannon ++) {
          sq = lppos->ucsqPieces[pcCannon];
          if (sq != 0) {
            x = FILE_X(sq);
            if (x == FILE_CENTER) {
              y = RANK_Y(sq);
              lpsms = lppos->FileMaskPtr(x, y);
              if ((lpsms->wRookCap & BLACK_KING_BITFILE) != 0) {
                // ͷڵв
                vlBlackPenalty += PreEvalEx.vlHollowThreat[y];
              } else if ((lpsms->wSuperCap & BLACK_KING_BITFILE) != 0 &&
                  (lppos->ucpcSquares[0x47] == 37 || lppos->ucpcSquares[0x47] == 38)) {
                // в
                vlBlackPenalty += PreEvalEx.vlCentralThreat[y];
              }
            }
          }
        }
        break;
      case SHAPE_LEFT:
      case SHAPE_RIGHT:
        for (pcCannon = SIDE_TAG(0) + CANNON_FROM; pcCannon <= SIDE_TAG(0) + CANNON_TO; pcCannon ++) {
          sq = lppos->ucsqPieces[pcCannon];
          if (sq != 0) {
            x = FILE_X(sq);
            y = RANK_Y(sq);
            if (x == FILE_CENTER) {
              if ((lppos->FileMaskPtr(x, y)->wSuperCap & BLACK_KING_BITFILE) != 0) {
                // һڵв˧()űԷƵĻжⷣ
                vlBlackPenalty += (PreEvalEx.vlCentralThreat[y] >> 2) +
                    (lppos->Protected(0, nShape == SHAPE_LEFT ? 0x38 : 0x36) ? 20 : 0);
                // ڵ߱˧()ķ֣
                for (pcRook = SIDE_TAG(1) + ROOK_FROM; pcRook <= SIDE_TAG(1) + ROOK_TO; pcRook ++) {
                  sq = lppos->ucsqPieces[pcRook];
                  if (sq != 0) {
                    y = RANK_Y(sq);
                    if (y == RANK_TOP) {
                      x = FILE_X(sq);
                      if ((lppos->RankMaskPtr(x, y)->wRookCap & KING_BITRANK) != 0) {
                        vlBlackPenalty += 80;
                      }
                    }
                  }
                }
              }
            } else if (y == RANK_TOP) {
              if ((lppos->RankMaskPtr(x, y)->wRookCap & KING_BITRANK) != 0) {
                // ڵв
                vlBlackPenalty += PreEvalEx.vlBlackBottomThreat[x];
              }
            }
          }
        }
        break;
      default:
        break;
      }
    } else if (lppos->ucsqPieces[SIDE_TAG(1) + KING_FROM] == 0x47) {
      // ˫(ʿ)ı˧()ռ죬Ҫ
      vlBlackPenalty += 20;
    }
  } else {
    if ((lppos->wBitPiece[0] & ROOK_BITPIECE) == ROOK_BITPIECE) {
      // ȱ(ʿ)˫з
      vlBlackPenalty += PreEvalEx.vlBlackAdvisorLeakage;
    }
  }
  return SIDE_VALUE(lppos->sdPlayer, vlBlackPenalty - vlWhitePenalty);
}

// ǵһ֣͵

// ǵڶ֣ǣƵ

// "cnValuableStringPieces"жǣǷмֵ
// 0Ƕڳ˵ģǣ(ǣ)мֵ1Ƕ˵ֻǣмֵ
static const int cnValuableStringPieces[48] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 2, 2, 0, 0, 1, 1, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 2, 2, 0, 0, 1, 1, 0, 0, 0, 0, 0
};

// "ccvlStringValueTab""KNIGHT_PIN_TAB"ĳ("pregen.h")ǣƼֵ
// мӺͱǣӵľԽǣƵļֵԽ
static const char ccvlStringValueTab[512] = {
                               0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 32,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 36,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 40,  0,  0,  0,  0,  0,  0,  0,  0,
  12, 16, 20, 24, 28, 32, 36,  0, 36, 32, 28, 24, 20, 16, 12,  0,
   0,  0,  0,  0,  0,  0,  0, 40,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 36,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 32,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 28,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0
};

// ǣ˧()򳵵͵
int StringHold(const PositionStruct *lppos) {
  int sd, i, j, nDir, sqSrc, sqDst, sqStr;
  int x, y, nSideTag, nOppSideTag;
  int vlString[2];
  SlideMoveStruct *lpsmv;

  for (sd = 0; sd < 2; sd ++) {
    vlString[sd] = 0;
    nSideTag = SIDE_TAG(sd);
    nOppSideTag = OPP_SIDE_TAG(sd);
    // óǣƵ
    for (i = ROOK_FROM; i <= ROOK_TO; i ++) {
      sqSrc = lppos->ucsqPieces[nSideTag + i];
      if (sqSrc != 0) {
        __ASSERT_SQUARE(sqSrc);
        // ǣĿ˧()
        sqDst = lppos->ucsqPieces[nOppSideTag + KING_FROM];
        if (sqDst != 0) {
          __ASSERT_SQUARE(sqDst);
          x = FILE_X(sqSrc);
          y = RANK_Y(sqSrc);
          if (x == FILE_X(sqDst)) {
            lpsmv = lppos->FileMovePtr(x, y);
            nDir = (sqSrc < sqDst ? 0 : 1);
            // ڵĳԷ(óڵŷ)ܳԵĿ"sqDst"ǣƾͳˣͬ
            if (sqDst == lpsmv->ucCannonCap[nDir] + FILE_DISP(x)) {
              // ǣ"sqStr"ǳ()ܳԵӣͬ
              sqStr = lpsmv->ucRookCap[nDir] + FILE_DISP(x);
              __ASSERT_SQUARE(sqStr);
              // ǣӱǶԷӣͬ
              if ((lppos->ucpcSquares[sqStr] & nOppSideTag) != 0) {
                // ǣмֵģұǣûб(Ŀӱ)ôǣмֵģͬ
                if (cnValuableStringPieces[lppos->ucpcSquares[sqStr]] > 0 &&
                    !lppos->Protected(OPP_SIDE(sd), sqStr, sqDst)) {
                  vlString[sd] += ccvlStringValueTab[sqDst - sqStr + 256];
                }
              }
            }
          } else if (y == RANK_Y(sqDst)) {
            lpsmv = lppos->RankMovePtr(x, y);
            nDir = (sqSrc < sqDst ? 0 : 1);
            if (sqDst == lpsmv->ucCannonCap[nDir] + RANK_DISP(y)) {
              sqStr = lpsmv->ucRookCap[nDir] + RANK_DISP(y);
              __ASSERT_SQUARE(sqStr);
              if ((lppos->ucpcSquares[sqStr] & nOppSideTag) != 0) {
                if (cnValuableStringPieces[lppos->ucpcSquares[sqStr]] > 0 &&
                    !lppos->Protected(OPP_SIDE(sd), sqStr, sqDst)) {
                  vlString[sd] += ccvlStringValueTab[sqDst - sqStr + 256];
                }
              }
            }
          }
        }
        // ǣĿǳ
        for (j = ROOK_FROM; j <= ROOK_TO; j ++) {
          sqDst = lppos->ucsqPieces[nOppSideTag + j];
          if (sqDst != 0) {
            __ASSERT_SQUARE(sqDst);
            x = FILE_X(sqSrc);
            y = RANK_Y(sqSrc);
            if (x == FILE_X(sqDst)) {
              lpsmv = lppos->FileMovePtr(x, y);
              nDir = (sqSrc < sqDst ? 0 : 1);
              if (sqDst == lpsmv->ucCannonCap[nDir] + FILE_DISP(x)) {
                sqStr = lpsmv->ucRookCap[nDir] + FILE_DISP(x);
                __ASSERT_SQUARE(sqStr);
                if ((lppos->ucpcSquares[sqStr] & nOppSideTag) != 0) {
                  // Ŀǳͬ˧()ҪҲûбʱǣƼֵͬ
                  if (cnValuableStringPieces[lppos->ucpcSquares[sqStr]] > 0 &&
                      !lppos->Protected(OPP_SIDE(sd), sqDst) && !lppos->Protected(OPP_SIDE(sd), sqStr, sqDst)) {
                    vlString[sd] += ccvlStringValueTab[sqDst - sqStr + 256];
                  }
                }
              }
            } else if (y == RANK_Y(sqDst)) {
              lpsmv = lppos->RankMovePtr(x, y);
              nDir = (sqSrc < sqDst ? 0 : 1);
              if (sqDst == lpsmv->ucCannonCap[nDir] + RANK_DISP(y)) {
                sqStr = lpsmv->ucRookCap[nDir] + RANK_DISP(y);
                __ASSERT_SQUARE(sqStr);
                if ((lppos->ucpcSquares[sqStr] & nOppSideTag) != 0) {
                  if (cnValuableStringPieces[lppos->ucpcSquares[sqStr]] > 0 &&
                      !lppos->Protected(OPP_SIDE(sd), sqDst) && !lppos->Protected(OPP_SIDE(sd), sqStr, sqDst)) {
                    vlString[sd] += ccvlStringValueTab[sqDst - sqStr + 256];
                  }
                }
              }
            }
          }
        }
      }
    }

    // ǣƵ
    for (i = CANNON_FROM; i <= CANNON_TO; i ++) {
      sqSrc = lppos->ucsqPieces[nSideTag + i];
      if (sqSrc != 0) {
        __ASSERT_SQUARE(sqSrc);
        // ǣĿ˧()
        sqDst = lppos->ucsqPieces[nOppSideTag + KING_FROM];
        if (sqDst != 0) {
          __ASSERT_SQUARE(sqDst);
          x = FILE_X(sqSrc);
          y = RANK_Y(sqSrc);
          if (x == FILE_X(sqDst)) {
            lpsmv = lppos->FileMovePtr(x, y);
            nDir = (sqSrc < sqDst ? 0 : 1);
            if (sqDst == lpsmv->ucSuperCap[nDir] + FILE_DISP(x)) {
              sqStr = lpsmv->ucCannonCap[nDir] + FILE_DISP(x);
              __ASSERT_SQUARE(sqStr);
              if ((lppos->ucpcSquares[sqStr] & nOppSideTag) != 0) {
                if (cnValuableStringPieces[lppos->ucpcSquares[sqStr]] > 1 &&
                    !lppos->Protected(OPP_SIDE(sd), sqStr, sqDst)) {
                  vlString[sd] += ccvlStringValueTab[sqDst - sqStr + 256];
                }
              }
            }
          } else if (y == RANK_Y(sqDst)) {
            lpsmv = lppos->RankMovePtr(x, y);
            nDir = (sqSrc < sqDst ? 0 : 1);
            if (sqDst == lpsmv->ucSuperCap[nDir] + RANK_DISP(y)) {
              sqStr = lpsmv->ucCannonCap[nDir] + RANK_DISP(y);
              __ASSERT_SQUARE(sqStr);
              if ((lppos->ucpcSquares[sqStr] & nOppSideTag) != 0) {
                if (cnValuableStringPieces[lppos->ucpcSquares[sqStr]] > 1 &&
                    !lppos->Protected(OPP_SIDE(sd), sqStr, sqDst)) {
                  vlString[sd] += ccvlStringValueTab[sqDst - sqStr + 256];
                }
              }
            }
          }
        }
        // ǣĿǳ
        for (j = ROOK_FROM; j <= ROOK_TO; j ++) {
          sqDst = lppos->ucsqPieces[nOppSideTag + j];
          if (sqDst != 0) {
            __ASSERT_SQUARE(sqDst);
            x = FILE_X(sqSrc);
            y = RANK_Y(sqSrc);
            if (x == FILE_X(sqDst)) {
              lpsmv = lppos->FileMovePtr(x, y);
              nDir = (sqSrc < sqDst ? 0 : 1);
              if (sqDst == lpsmv->ucSuperCap[nDir] + FILE_DISP(x)) {
                sqStr = lpsmv->ucCannonCap[nDir] + FILE_DISP(x);
                __ASSERT_SQUARE(sqStr);
                if ((lppos->ucpcSquares[sqStr] & nOppSideTag) != 0) {
                  if (cnValuableStringPieces[lppos->ucpcSquares[sqStr]] > 1 &&
                      !lppos->Protected(OPP_SIDE(sd), sqStr, sqDst)) {
                    vlString[sd] += ccvlStringValueTab[sqDst - sqStr + 256];
                  }
                }
              }
            } else if (y == RANK_Y(sqDst)) {
              lpsmv = lppos->RankMovePtr(x, y);
              nDir = (sqSrc < sqDst ? 0 : 1);
              if (sqDst == lpsmv->ucSuperCap[nDir] + RANK_DISP(y)) {
                sqStr = lpsmv->ucCannonCap[nDir] + RANK_DISP(y);
                __ASSERT_SQUARE(sqStr);
                if ((lppos->ucpcSquares[sqStr] & nOppSideTag) != 0) {
                  if (cnValuableStringPieces[lppos->ucpcSquares[sqStr]] > 1 &&
                      !lppos->Protected(OPP_SIDE(sd), sqStr, sqDst)) {
                    vlString[sd] += ccvlStringValueTab[sqDst - sqStr + 256];
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return SIDE_VALUE(lppos->sdPlayer, vlString[0] - vlString[1]);
}

// ǵڶ֣ǣƵ

// ǵ֣Ե

int RookMobility(const PositionStruct *lppos) {
  int sd, i, sqSrc, nSideTag, x, y;
  int vlRookMobility[2];
  for (sd = 0; sd < 2; sd ++) {
    vlRookMobility[sd] = 0;
    nSideTag = SIDE_TAG(sd);
    for (i = ROOK_FROM; i <= ROOK_TO; i ++) {
      sqSrc = lppos->ucsqPieces[nSideTag + i];
      if (sqSrc != 0) {
        __ASSERT_SQUARE(sqSrc);
        x = FILE_X(sqSrc);
        y = RANK_Y(sqSrc);
        vlRookMobility[sd] += PreEvalEx.cPopCnt16[lppos->RankMaskPtr(x, y)->wNonCap] +
            PreEvalEx.cPopCnt16[lppos->FileMaskPtr(x, y)->wNonCap];
      }
    }
    __ASSERT(vlRookMobility[sd] <= 34);
  }
  return SIDE_VALUE(lppos->sdPlayer, vlRookMobility[0] - vlRookMobility[1]) >> 1;
}

// ǵ֣Ե

// ǵĲ֣ܵ谭

// "cbcEdgeSquares"˲λã̱Եλõǻ
static const bool cbcEdgeSquares[256] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

int KnightTrap(const PositionStruct *lppos) {
  int sd, i, sqSrc, sqDst, nSideTag, nMovable;
  uint8_t *lpucsqDst, *lpucsqPin;
  int vlKnightTraps[2];

  for (sd = 0; sd < 2; sd ++) {
    vlKnightTraps[sd] = 0;
    nSideTag = SIDE_TAG(sd);
    // ߵλãߵ̱ԵϣߵԷĿƸ񣬶ų
    for (i = KNIGHT_FROM; i <= KNIGHT_TO; i ++) {
      sqSrc = lppos->ucsqPieces[nSideTag + i];
      if (sqSrc != 0) {
        __ASSERT_SQUARE(sqSrc);
        nMovable = 0;
        lpucsqDst = PreGen.ucsqKnightMoves[sqSrc];
        lpucsqPin = PreGen.ucsqKnightPins[sqSrc];
        sqDst = *lpucsqDst;
        while (sqDst != 0) {
          __ASSERT_SQUARE(sqDst);
          // µж"genmoves.cpp"еŷųߵ̱ԵߵԷƸŷ
          if (!cbcEdgeSquares[sqDst] && lppos->ucpcSquares[sqDst] == 0 &&
              lppos->ucpcSquares[*lpucsqPin] == 0 && !lppos->Protected(OPP_SIDE(sd), sqDst)) {
            nMovable ++;
            if (nMovable > 1) {
              break;
            }
          }
          lpucsqDst ++;
          sqDst = *lpucsqDst;
          lpucsqPin ++;
        }
        // ûкõŷ10ַֻ֣һõŷ5ַ
        if (nMovable == 0) {
          vlKnightTraps[sd] += 10;
        } else if (nMovable == 1) {
          vlKnightTraps[sd] += 5;
        }
      }
      __ASSERT(vlKnightTraps[sd] <= 20);
    }
  }
  return SIDE_VALUE(lppos->sdPlayer, vlKnightTraps[1] - vlKnightTraps[0]);
}

// ǵĲ֣ܵ谭

// ۹
int WINAPI Evaluate(const PositionStruct *lppos, int vlAlpha, int vlBeta) {
  int vl;
  // ͵ľۺ¼Σ

  // 1. ļ͵(͵)ֻƽ⣻
  vl = lppos->Material();
  if (vl + EVAL_MARGIN1 <= vlAlpha) {
    return vl + EVAL_MARGIN1;
  } else if (vl - EVAL_MARGIN1 >= vlBeta) {
    return vl - EVAL_MARGIN1;
  }

  // 2. ͵ۣͣ
  vl += AdvisorShape(lppos);
  if (vl + EVAL_MARGIN2 <= vlAlpha) {
    return vl + EVAL_MARGIN2;
  } else if (vl - EVAL_MARGIN2 >= vlBeta) {
    return vl - EVAL_MARGIN2;
  }

  // 3. ͵ۣǣƣ
  vl += StringHold(lppos);
  if (vl + EVAL_MARGIN3 <= vlAlpha) {
    return vl + EVAL_MARGIN3;
  } else if (vl - EVAL_MARGIN3 >= vlBeta) {
    return vl - EVAL_MARGIN3;
  }

  // 4. һ͵ۣԣ
  vl += RookMobility(lppos);
  if (vl + EVAL_MARGIN4 <= vlAlpha) {
    return vl + EVAL_MARGIN4;
  } else if (vl - EVAL_MARGIN4 >= vlBeta) {
    return vl - EVAL_MARGIN4;
  }

  // 5. 㼶͵(ȫ)谭
  return vl + KnightTrap(lppos);
}

const char *WINAPI GetEngineName(void) {
  return NULL;
}
