/////////////////////////////////////////////////////////////////////////////
// Name:        proxysettingsdlg.cpp
// Purpose:     wxProxySettingsDlg
// Author:      Angelo Mandato
// Created:     2005/08/11
// RCS-ID:      $Id$
// Copyright:   (c) 2001-2005 Angelo Mandato
// Licence:     wxWidgets licence
/////////////////////////////////////////////////////////////////////////////



#ifdef __GNUG__
#pragma implementation "proxysettingsdlg.h"
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// includes
#ifndef WX_PRECOMP
	// here goes the #include <wx/abc.h> directives for those
	// files which are not included by wxprec.h
	#include <wx/wx.h>
#endif

#include <wx/wxhttpengine/proxysettingsdlg.h>

enum
{
    // menu items
    ProxySettings_RequiresAuthentication = 1,
};


BEGIN_EVENT_TABLE(wxProxySettingsDlg, wxDialog)
    EVT_CHECKBOX(ProxySettings_RequiresAuthentication,  wxProxySettingsDlg::OnRequiresAuthentication)
END_EVENT_TABLE()

//! wxProxySettingsDlg constructor
wxProxySettingsDlg::wxProxySettingsDlg(wxWindow* parent, wxWindowID id, const wxString& caption, const bool bShowNoProxyFor)
: wxDialog(parent, id, caption, wxDefaultPosition, wxDefaultSize)
{
  m_stExceptionsDesc = NULL;
  m_stExceptionsNote = NULL;
	m_tcExceptions = NULL;
  
  wxBoxSizer* mainSizer = new wxBoxSizer(wxVERTICAL);

  wxStaticBoxSizer *sizer = new wxStaticBoxSizer(wxVERTICAL, this, _("Configure proxy") );
  wxBoxSizer *hsizer = NULL;
  wxButton *bn = NULL;
  wxStaticBox *sb = NULL;
  wxStaticBoxSizer *sbSizer = NULL;
  wxStaticText *st = NULL;

  m_pRadioSystem = new wxRadioButton(this, wxID_ANY, _("Use system settings"));
  m_pRadioManual = new wxRadioButton(this, wxID_ANY, _("Manual configuration of proxy:"));

  sizer->Add(m_pRadioSystem, 0, wxEXPAND|wxALL, 5);
  sizer->Add(m_pRadioManual, 0, wxEXPAND|wxALL, 5);

#ifdef _WINDOWS
  m_pRadioSystem->SetValue(false);
  m_pRadioManual->SetValue(true);
  m_pRadioSystem->Hide();
  m_pRadioManual->Hide();
#else
  m_pRadioSystem->SetValue(true);
  m_pRadioManual->SetValue(false);  
#endif
	
  m_pSettingsPanel = new wxPanel(this);
  wxBoxSizer *settingsPanelSizer = new wxBoxSizer( wxVERTICAL );

  // Settings
  sb = new wxStaticBox( m_pSettingsPanel, -1, _("Server settings") );
    // StaticBox
    sbSizer = new wxStaticBoxSizer(sb, wxVERTICAL);
      // Host row
      hsizer = new wxBoxSizer( wxHORIZONTAL );
      st = new wxStaticText( m_pSettingsPanel, -1, _("Host:"), wxDefaultPosition, wxSize(100, -1) );
      hsizer->Add(st, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 10);
      m_tcHost = new wxTextCtrl(m_pSettingsPanel, -1, wxT(""), wxDefaultPosition, wxSize( 180, -1) );
      hsizer->Add(m_tcHost, 0, wxLEFT, 5);
    sbSizer->Add(hsizer, 0, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND, 5);
      // Port row
      hsizer = new wxBoxSizer( wxHORIZONTAL );
      st = new wxStaticText( m_pSettingsPanel, -1, _("Port:"), wxDefaultPosition, wxSize(100, -1) );
      hsizer->Add(st, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 10);
      m_tcPort = new wxTextCtrl(m_pSettingsPanel, -1, wxT(""), wxDefaultPosition, wxSize( 180, -1) );
      hsizer->Add(m_tcPort, 0, wxLEFT, 5);

    sbSizer->Add(hsizer, 0, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND, 5);
  settingsPanelSizer->Add(sbSizer, 0, wxTOP|wxLEFT|wxRIGHT|wxEXPAND, 10);


  // Authentication
  sb = new wxStaticBox( m_pSettingsPanel, -1, _("Authentication") );
    // StaticBox
    sbSizer = new wxStaticBoxSizer(sb, wxVERTICAL);
      m_cbAuthenticate = new wxCheckBox( m_pSettingsPanel, ProxySettings_RequiresAuthentication, _("Proxy server requires authentication") );
      sbSizer->Add(m_cbAuthenticate, 0, wxTOP|wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND, 10);
      // Host row
      hsizer = new wxBoxSizer( wxHORIZONTAL );
      st = new wxStaticText( m_pSettingsPanel, -1, _("Username:"), wxDefaultPosition, wxSize(100, -1) );
      hsizer->Add(st, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 10);
      m_tcUserName = new wxTextCtrl(m_pSettingsPanel, -1, wxT(""), wxDefaultPosition, wxSize( 180, -1) );
      m_tcUserName->Enable(false);
      hsizer->Add(m_tcUserName, 0, wxLEFT, 5);
    sbSizer->Add(hsizer, 0, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND, 5);
      // Port row
      hsizer = new wxBoxSizer( wxHORIZONTAL );
      st = new wxStaticText( m_pSettingsPanel, -1, _("Password:"), wxDefaultPosition, wxSize(100, -1) );
      hsizer->Add(st, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 10);
      m_tcPassword = new wxTextCtrl(m_pSettingsPanel, -1, wxT(""), wxDefaultPosition, wxSize( 180, -1), wxTE_PASSWORD );
      hsizer->Add(m_tcPassword, 0, wxLEFT, 5);
      m_tcPassword->Enable(false);
    sbSizer->Add(hsizer, 0, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND, 5);
  settingsPanelSizer->Add(sbSizer, 0, wxTOP|wxLEFT|wxRIGHT|wxEXPAND, 10);

  // No Proxy for
  if( bShowNoProxyFor )
  {
    sb = new wxStaticBox( m_pSettingsPanel, -1, _("Exceptions") );
      // StaticBox
      sbSizer = new wxStaticBoxSizer(sb, wxVERTICAL);

      hsizer = new wxBoxSizer( wxHORIZONTAL );
      m_stExceptionsDesc = new wxStaticText( m_pSettingsPanel, -1, _("No proxy for addresses containing:"), wxDefaultPosition, wxDefaultSize );
      hsizer->Add(m_stExceptionsDesc, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 10);
    sbSizer->Add(hsizer, 1, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND, 5);
      
      hsizer = new wxBoxSizer( wxHORIZONTAL );
      m_tcExceptions = new wxTextCtrl(m_pSettingsPanel, -1, wxT(""), wxDefaultPosition, wxDefaultSize );
      //hsizer->Add(5, 0);
      hsizer->Add(m_tcExceptions, 1, wxLEFT|wxALIGN_CENTER_VERTICAL, 10);
    sbSizer->Add(hsizer, 0, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND, 5);

      hsizer = new wxBoxSizer( wxHORIZONTAL );
      m_stExceptionsNote = new wxStaticText( m_pSettingsPanel, -1, _("Separate addresses with commas."), wxDefaultPosition, wxDefaultSize );
      hsizer->Add(m_stExceptionsNote, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 10);
    sbSizer->Add(hsizer, 1, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND, 5);

    settingsPanelSizer->Add(sbSizer, 0, wxALL|wxEXPAND, 10);
  }

  m_pSettingsPanel->SetSizerAndFit(settingsPanelSizer);

  m_pSettingsPanel->Enable(m_pRadioManual->GetValue());

  sizer->Add(m_pSettingsPanel, 0, wxEXPAND);

  mainSizer->Add(sizer, 0, wxEXPAND|wxALL, 5);
  // Button row:
  hsizer = new wxBoxSizer( wxHORIZONTAL );
    hsizer->Add(0,0,1, wxGROW);
    bn = new wxButton(this, wxID_OK, _("Accept"));
	 hsizer->Add(bn, 0, wxRIGHT, 5);
    bn = new wxButton(this, wxID_CANCEL, _("Cancel") );
    hsizer->Add(bn, 0, wxLEFT, 5);
  mainSizer->Add(hsizer, 0, wxALL|wxEXPAND, 10);

  SetSizerAndFit( mainSizer );
  CenterOnParent();

  m_pRadioSystem->Connect( wxEVT_COMMAND_RADIOBUTTON_SELECTED, wxCommandEventHandler( wxProxySettingsDlg::OnRadioSystemClick ), NULL, this );
  m_pRadioManual->Connect( wxEVT_COMMAND_RADIOBUTTON_SELECTED, wxCommandEventHandler( wxProxySettingsDlg::OnRadioManualClick ), NULL, this );
}

//! wxProxySettingsDlg destructor
wxProxySettingsDlg::~wxProxySettingsDlg()
{
  // Empty
  m_pRadioSystem->Disconnect( wxEVT_COMMAND_RADIOBUTTON_SELECTED, wxCommandEventHandler( wxProxySettingsDlg::OnRadioSystemClick ), NULL, this );
  m_pRadioManual->Disconnect( wxEVT_COMMAND_RADIOBUTTON_SELECTED, wxCommandEventHandler( wxProxySettingsDlg::OnRadioManualClick ), NULL, this );
}

void wxProxySettingsDlg::OnRadioSystemClick( wxCommandEvent&  )
{
	m_pRadioManual->SetValue(!m_pRadioSystem->GetValue());
	m_pSettingsPanel->Enable(m_pRadioManual->GetValue());
	Refresh();
}
void wxProxySettingsDlg::OnRadioManualClick( wxCommandEvent&  )
{
	m_pRadioSystem->SetValue(!m_pRadioManual->GetValue());
	m_pSettingsPanel->Enable(m_pRadioManual->GetValue());
	Refresh();
}

//! Set proxy port number
void wxProxySettingsDlg::SetPortNumber(const long port)
{
  m_tcPort->SetValue( wxString::Format( wxT("%ld"), port) );
}

//! Set Proxy host
void wxProxySettingsDlg::SetHost(const wxString &host)
{
  m_tcHost->SetValue( host );
}

//! Set proxy username
void wxProxySettingsDlg::SetUsername(const wxString &username)
{
  m_tcUserName->SetValue( username );
}

//! set proxy password
void wxProxySettingsDlg::SetPassword(const wxString &password)
{
  m_tcPassword->SetValue( password );
}

//! Set exceptions list as string
void wxProxySettingsDlg::SetHostExceptions(const wxString &exceptions)
{
  if (m_tcExceptions) m_tcExceptions->SetValue( exceptions );
}

void wxProxySettingsDlg::SetProxySettings(const wxProxySettings &settings)
{
  m_settings = settings;
  SetPortNumber(m_settings.m_nProxyPort);
  SetHostExceptions(m_settings.m_strProxyExceptions);
  SetHost(m_settings.m_strProxyHostname);
  SetUsername(m_settings.m_strProxyUsername);
  SetPassword(m_settings.m_strProxyPassword);
  SetAuthProxy(m_settings.m_bRequiresAuth);
#ifndef _WINDOWS
  m_pRadioManual->SetValue(!m_settings.m_bUseSystemProxy);
  m_pRadioSystem->SetValue(m_settings.m_bUseSystemProxy);
#endif
}

//! Get proxy port number
long wxProxySettingsDlg::GetPortNumber()
{
  long port;
  m_tcPort->GetValue().ToLong(&port);
  return port;
}

//! Get proxy host
wxString wxProxySettingsDlg::GetHost()
{
  return m_tcHost->GetValue();
}

// Get proxy username
wxString wxProxySettingsDlg::GetUsername()
{
  return m_tcUserName->GetValue();
}

// Get Proxy password
wxString wxProxySettingsDlg::GetPassword()
{
  return m_tcPassword->GetValue();
}

//! Get exceptions string
wxString wxProxySettingsDlg::GetHostExceptions()
{
  if (m_tcExceptions) 
	  return m_tcExceptions->GetValue();
  return wxEmptyString;
}

wxProxySettings wxProxySettingsDlg::GetProxySettings(void)
{
  m_settings.m_nProxyPort = GetPortNumber();
  m_settings.m_strProxyExceptions = GetHostExceptions();
  m_settings.m_strProxyHostname = GetHost();
  m_settings.m_strProxyUsername = GetUsername();
  m_settings.m_strProxyPassword = GetPassword();
  m_settings.m_bRequiresAuth = IsAuthProxy();
#ifdef _WINDOWS
  m_settings.m_bUseSystemProxy = false;
#else
  m_settings.m_bUseSystemProxy = m_pRadioSystem->GetValue();
#endif

  // if the proxy hostname is not empty, then set the use proxy flag
  m_settings.m_bUseProxy = !m_settings.m_strProxyHostname.IsEmpty();

  return m_settings;
}

//! Set proxy requires authentication (requires username and password)
void wxProxySettingsDlg::SetAuthProxy(const bool auth)
{
  m_cbAuthenticate->SetValue(auth);
  if( auth )
  {
    m_tcUserName->Enable(true);
    m_tcPassword->Enable(true);
  }
  else
  {
    m_tcUserName->Enable(false);
    m_tcPassword->Enable(false);
  }
}

//! Return true if proxy requires authentication
bool wxProxySettingsDlg::IsAuthProxy()
{
  return m_cbAuthenticate->GetValue();
}

//! Set description to describe what constitutes as exceptions host for your application
void wxProxySettingsDlg::SetHostExceptionsDesc(const wxString &text)
{
  if( m_stExceptionsDesc )
    m_stExceptionsDesc->SetLabel(text);
}

//! Additional information which may be an example or note
void wxProxySettingsDlg::SetHostExceptionsNote(const wxString &text)
{
  if( m_stExceptionsNote )
    m_stExceptionsNote->SetLabel(text);
}

//! Command event when proxy requires authentication.  Toggles the necessary text boxes enabled/disabled
void wxProxySettingsDlg::OnRequiresAuthentication(wxCommandEvent &event)
{
  if( event.IsChecked() )
  {
    m_tcUserName->Enable(true);
    m_tcPassword->Enable(true);
  }
  else
  {
    m_tcUserName->Enable(false);
    m_tcPassword->Enable(false);
  }
}

// eof
