import QtQuick 2.0

// This shows a full size image preview, a box containg link information, or nothing
Item {
    id: contentWrapper

    MetaInfo {
        id: metaInfo
    }

    property int previewHeight: units.gu(16)
    property bool crop

    height: {
        if(!metaInfo.hasContent)
            return 0

        if(metaInfo.isImagePost && !previewImagesSetting.value && crop)
            return 0

        if(metaInfo.isImagePost)
            return picture.height
        else
            return linkBox.height
    }

    Image {
        id: picture
        visible: status == Image.Ready && metaInfo.isImagePost

        source: (previewImagesSetting.value || !contentWrapper.crop) ? Qt.resolvedUrl(linkPicture) : ""
        asynchronous: true
        fillMode: crop ? Image.PreserveAspectCrop : Image.PreserveAspectFit

        width: parent.width
        height: contentWrapper.crop ? previewHeight : sourceSize.height

        MouseArea {
            anchors.fill: picture
            cursorShape: Qt.PointingHandCursor

            // Cropped pictures shouldn't be clickable
            enabled: !contentWrapper.crop && metaInfo.isImagePost

            onClicked: linkUrl ? Qt.openUrlExternally(linkUrl) : Qt.openUrlExternally(url)
        }
    }

    LinkBox {
        id: linkBox
        visible: metaInfo.isLinkPost

        width: parent.width
        height: previewHeight
    }
}
