import QtQuick 2.0
import Ubuntu.Components 0.1

// This element shows either the reply/reply all buttons
// Or a field to compose the reply
Item {
    id: replyArea
    height: entryField.visible ? units.gu(10) : units.gu(5)

    function reset() {
        entryField.visible = false
    }

    Button {
        id: replyButton
        visible: !entryField.visible
        width: units.gu(10)

        anchors {
            leftMargin: units.gu(5)
            left: parent.left
            top: parent.top
            bottom: parent.bottom
        }

        text: metaInfo.isMicroblogging ? i18n.tr("Reply"): i18n.tr("Comment")

        property var lastCursorPosition

        onClicked : {
            entryField.visible = true

            if(metaInfo.isMicroblogging)
                entryField.setText("@"+senderNick)
        }
    }

    Button {
        id: replyAllButton

        // Only show if we are using micrblogging.
        visible: !entryField.visible && metaInfo.isMicroblogging
        width: replyButton.width

        anchors {
            left: replyButton.right
            leftMargin: units.gu(1)
            top: parent.top
            bottom: parent.bottom
        }

        text: i18n.tr("Reply All")

        property var lastCursorPosition

        onClicked : {
            entryField.visible = true

            if(metaInfo.isMicroblogging) {
                var text = "@"+senderNick;

                var nicks = message.match(/[@][\w]+/g);

                if (nicks !== null) {
                    for(var i = 0; i < nicks.length; ++i) {
                        text += " " + nicks[i];
                    }
                }

                entryField.setText(text)
            }
        }
    }

    EntryField {
        id: entryField
        visible: false

        anchors.fill: parent

        hideable: true

        accountIds: [accountId]
        replyToId: messageId
    }
}
