# This script is for deleting kerning pairs that can't or shouldn't occur
# together. 1. where runes are kerned with Latin letters. This can occur, but
# so rarely that it makes no sense to devote any file space to such pairs.
# 2. small caps with lowercase letters. When these occur, there will almost
# always be a formatting boundary between them, so kerning won't be done.
# This script will remove somewhere between 2000 and 4000 kerning pairs.
# Copy this into the Glyphs macro panel and run immediately after running
# Kern On. (Don't forget to change the "italic" variable near the bottom of
# the script, if necessary)

lowercase = [
"uniA7C1",
"gormulum",
"uniA7D3",
"uniA7D5",
"Bsmall",
"Gsmall",
"Gsmallhook",
"Hsmall",
"Ismall",
"Lsmall",
"Nsmall",
"OEsmall",
"Rsmall",
"Rsmallinverted",
"Ysmall",
"a",
"aa",
"aacute",
"abreve",
"abreveacute",
"abrevedotbelow",
"abrevegrave",
"abrevehookabove",
"abrevetilde",
"acircumflex",
"acircumflexacute",
"acircumflexdotbelow",
"acircumflexgrave",
"acircumflexhookabove",
"acircumflextilde",
"adieresis",
"adotbelow",
"agrave",
"ahookabove",
"alpha-latin",
"alphaturned-latin",
"amacron",
"ao",
"aogonek",
"aring",
"aringacute",
"atilde",
"aturned",
"au",
"av",
"avbar",
"ay",
"ae",
"aeacute",
"uni01E3",
"b",
"bhook",
"bidentalpercussive",
"bilabialclick",
"bilabialpercussive",
"bstroke",
"c",
"cacute",
"ccaron",
"ccedilla",
"ccurl",
"cdotaccent",
"con",
"cstretched",
"d",
"eth",
"dcaron",
"dcroat",
"dezh",
"dhook",
"dinsular",
"dtail",
"dzaltone",
"dzcurl",
"e",
"eacute",
"ebreve",
"ecaron",
"ecircumflex",
"ecircumflexacute",
"ecircumflexdotbelow",
"ecircumflexgrave",
"ecircumflexhookabove",
"ecircumflextilde",
"edieresis",
"edotaccent",
"edotbelow",
"egrave",
"ehookabove",
"emacron",
"eogonek",
"eopen",
"eopenreversed",
"eopenreversedclosed",
"eopenreversedhook",
"ereversed",
"esh",
"eshcurl",
"eshsquatreversed",
"etabbrev",
"etilde",
"schwa",
"schwahook",
"ezh",
"ezhcurl",
"f",
"fengdigraph",
"finsular",
"g",
"gamma-latin",
"gcommaaccent",
"gdotaccent",
"ghook",
"ginsular",
"glottalstop",
"glottalstopinverted",
"glottalstopreversed",
"glottalstopstroke",
"glottalstopstrokereversed",
"gsingle",
"yogh",
"h",
"hbar",
"henghook",
"hhook",
"hturned",
"hturnedfishhook",
"hturnedfishhookandtail",
"hv",
"i",
"dotlessi",
"iacute",
"ibreve",
"icircumflex",
"idieresis",
"idotbelow",
"igrave",
"ihookabove",
"ij",
"imacron",
"iogonek",
"is",
"istroke",
"itilde",
"j",
"jdotless",
"jcrossedtail",
"jdotlessstroke",
"jdotlessstrokehook",
"k",
"kcommaaccent",
"kstroke",
"l",
"lacute",
"lbar",
"lbelt",
"lcaron",
"lcommaaccent",
"lezh",
"lhighstroke",
"lhookretroflex",
"lmiddletilde",
"longsdiagonalstroke",
"lsdigraph",
"lslash",
"lzdigraph",
"m",
"mhook",
"mlonglegturned",
"mturned",
"n",
"nacute",
"ncaron",
"ncommaaccent",
"nhookleft",
"nhookretroflex",
"ntilde",
"eng",
"o",
"oacute",
"obarred",
"obreve",
"ocircumflex",
"ocircumflexacute",
"ocircumflexdotbelow",
"ocircumflexgrave",
"ocircumflexhookabove",
"ocircumflextilde",
"odieresis",
"odotbelow",
"ograve",
"ohookabove",
"ohorn",
"ohornacute",
"ohorndotbelow",
"ohorngrave",
"ohornhookabove",
"ohorntilde",
"ohungarumlaut",
"olongstroke",
"omacron",
"oo",
"oogonek",
"oopen",
"oslash",
"oslashacute",
"otilde",
"oe",
"p",
"pflourish",
"phi-latin",
"thorn",
"pstrokethroughdescender",
"q",
"qdiagonalstroke",
"qhook",
"qstrokethroughdescender",
"r",
"racute",
"ramshorn",
"rcaron",
"rcommaaccent",
"rfishhook",
"rfishhookreversed",
"rhookturned",
"rinsular",
"rlonglegturned",
"rrotunda",
"rtail",
"rturned",
"rumrotunda",
"s",
"sacute",
"scaron",
"scedilla",
"germandbls",
"shook",
"sinsular",
"longs",
"t",
"tbar",
"tcaron",
"tccurl",
"tcedilla",
"tesh",
"thorncrossed",
"tinsular",
"tretroflexhook",
"ts",
"tturned",
"u",
"uacute",
"ubar",
"ubreve",
"ucircumflex",
"udieresis",
"udotbelow",
"ugrave",
"uhookabove",
"uhorn",
"uhornacute",
"uhorndotbelow",
"uhorngrave",
"uhornhookabove",
"uhorntilde",
"uhungarumlaut",
"umacron",
"uogonek",
"upsilon-latin",
"uring",
"utilde",
"v",
"vhook",
"vrighthook",
"vturned",
"w",
"wacute",
"wcircumflex",
"wdieresis",
"wgrave",
"wturned",
"wy",
"wynn",
"x",
"y",
"yacute",
"ycircumflex",
"ydieresis",
"ydotaccent",
"ydotbelow",
"ygrave",
"yhookabove",
"ymacron",
"ytilde",
"yturned",
"z",
"zacute",
"zcaron",
"zcurl",
"zdotaccent",
"zretroflexhook",
"zstroke",
"d.alt",
"dinsular.alt",
"f.alt",
"g.alt",
"i.alt",
"p.alt",
"r.alt",
"rrotunda.alt",
"s.alt",
"longs.alt",
"f.alt2",
"longs.alt2",
"a.ipa",
"b.lf",
"f.lf",
"h.lf",
"k.lf",
"l.lf",
"thorn.lf",
"f.lfrl",
"f.lfrtall",
"i.llongs",
"j.llongs",
"longs.llongs",
"longs.llongsrij",
"longs.llongsrtall",
"eth.loclENG",
"thorn.loclENG",
"f.rf",
"longs.rij",
"f.rl",
"longs.rlongs",
"f.rtall",
"longs.rtall",
"ae.square",
"aeacute.square",
"uni01E3.square",
"k.swash",
"z.swash",
"zacute.swash",
"zcaron.swash",
"zdotaccent.swash",
"eth.loclENG.alt",
"f.alt.lf",
"thorn.loclENG.lf",
"longs.alt.llongs",
"uni027602DE",
"uni028F02DE",
"uni006102DE",
"uni025B02DE",
"uni025802DE",
"uni026802DE",
"uni027502DE",
"uni026402DE",
"uni028902DE",
"uni028A02DE",
"uni006102DE.ipa",
"a_s",
"c_t",
"f_eth",
"f_f",
"f_j",
"h_h.hlig",
"i_s",
"longs_t",
"p_p.hlig",
"thorn_thorn.hlig",
"u_s",
"uniFB01",
"uniFB02",
"uniFB03",
"uniFB04",
"uniFB06",
"wynn_wynn.hlig",
"longs_t.llongs",
"f_eth.loclENG",
"beta",
"theta",
"pi",
"chi",
"uni037C"]

smallcaps = ["avbar.sc",
"a.sc",
"aa.sc",
"aacute.sc",
"abreve.sc",
"acircumflex.sc",
"adieresis.sc",
"agrave.sc",
"amacron.sc",
"ao.sc",
"aogonek.sc",
"aring.sc",
"aringacute.sc",
"atilde.sc",
"au.sc",
"av.sc",
"ay.sc",
"ae.sc",
"aeacute.sc",
"uni01E3.sc",
"b.sc",
"c.sc",
"cacute.sc",
"ccaron.sc",
"ccedilla.sc",
"cdotaccent.sc",
"d.sc",
"eth.sc",
"dcaron.sc",
"dcroat.sc",
"dinsular.sc",
"e.sc",
"eacute.sc",
"ebreve.sc",
"ecaron.sc",
"ecircumflex.sc",
"edieresis.sc",
"edotaccent.sc",
"egrave.sc",
"emacron.sc",
"f.sc",
"finsular.sc",
"g.sc",
"gcommaaccent.sc",
"gdotaccent.sc",
"ginsular.sc",
"yogh.sc",
"h.sc",
"hbar.sc",
"hv.sc",
"i.sc",
"iacute.sc",
"ibreve.sc",
"icircumflex.sc",
"idieresis.sc",
"igrave.sc",
"ij.sc",
"imacron.sc",
"iogonek.sc",
"j.sc",
"k.sc",
"kcommaaccent.sc",
"uniA741.sc",
"l.sc",
"lacute.sc",
"uni019A.sc",
"lcaron.sc",
"lcommaaccent.sc",
"lhighstroke.sc",
"lmiddletilde.sc",
"lslash.sc",
"m.sc",
"n.sc",
"nacute.sc",
"ncaron.sc",
"ncommaaccent.sc",
"ntilde.sc",
"eng.sc",
"o.sc",
"oacute.sc",
"obreve.sc",
"ocircumflex.sc",
"odieresis.sc",
"ograve.sc",
"ohungarumlaut.sc",
"omacron.sc",
"oo.sc",
"oogonek.sc",
"oslash.sc",
"oslashacute.sc",
"otilde.sc",
"oe.sc",
"p.sc",
"thorn.sc",
"q.sc",
"qdiagonalstroke.sc",
"r.sc",
"racute.sc",
"rcaron.sc",
"rcommaaccent.sc",
"rinsular.sc",
"s.sc",
"sacute.sc",
"scaron.sc",
"scedilla.sc",
"germandbls.sc",
"sinsular.sc",
"t.sc",
"tbar.sc",
"tcaron.sc",
"tcedilla.sc",
"tinsular.sc",
"u.sc",
"uacute.sc",
"ubreve.sc",
"ucircumflex.sc",
"udieresis.sc",
"ugrave.sc",
"uhungarumlaut.sc",
"umacron.sc",
"uogonek.sc",
"uring.sc",
"utilde.sc",
"v.sc",
"w.sc",
"wacute.sc",
"wcircumflex.sc",
"wdieresis.sc",
"wgrave.sc",
"wynn.sc",
"x.sc",
"y.sc",
"yacute.sc",
"ycircumflex.sc",
"ydieresis.sc",
"uni1E8F.sc",
"ygrave.sc",
"ymacron.sc",
"z.sc",
"zacute.sc",
"zcaron.sc",
"zdotaccent.sc",
"uni01B6.sc",
"wy.sc",
"q.alt.sc",
"thorn.loclENG.sc"]

rune_names = ["fehu-runic",
"v-runic",
"uruz-runic",
"yr-runic",
"y-runic",
"w-runic",
"thurisazThursThorn-runic",
"eth-runic",
"ansuzA-runic",
"osO-runic",
"acA-runic",
"aesc-runic",
"ossOLongBranch-runic",
"ossOShortTwig-runic",
"o-runic",
"oe-runic",
"on-runic",
"raidoRadReidR-runic",
"kauna-runic",
"cen-runic",
"kaunK-runic",
"g-runic",
"eng-runic",
"geboGyfuG-runic",
"gar-runic",
"wunjoWynnW-runic",
"haglazH-runic",
"haeglH-runic",
"hagallHLongBranch-runic",
"hagallHShortTwig-runic",
"naudNNaudizNyd-runic",
"naudNShortTwig-runic",
"nDotted-runic",
"isazIsIssI-runic",
"e-runic",
"jeranJ-runic",
"ger-runic",
"aeLongBranchAr-runic",
"aShortTwigAr-runic",
"iwazEoh-runic",
"perthoPeorthP-runic",
"algizEolhx-runic",
"sowiloS-runic",
"sigelLongBranchSol-runic",
"sShortTwigSol-runic",
"c-runic",
"z-runic",
"tiwazTirTyr-runic",
"tShortTwigTyr-runic",
"d-runic",
"berkananBeorcBjarkanB-runic",
"bjarkanBshortTwig-runic",
"pDotted-runic",
"pOpen-runic",
"ehwazEhE-runic",
"mannazManM-runic",
"mLongBranchMadr-runic",
"mShortTwigMadr-runic",
"laukazLaguLogrL-runic",
"lDotted-runic",
"ingwaz-runic",
"ing-runic",
"dagazDaegD-runic",
"othalanEthelO-runic",
"ear-runic",
"ior-runic",
"cweorth-runic",
"calc-runic",
"cealc-runic",
"stan-runic",
"yrLongBranch-runic",
"yrShortTwig-runic",
"yrIcelandic-runic",
"q-runic",
"x-runic",
"punctSingle-runic",
"punctMultiple-runic",
"punctCross-runic",
"arlaug-runic",
"tvimadur-runic",
"belgthor-runic"]

rune_ids = []
smallcap_ids = []
lowercase_ids = []

def is_rune(kern_id):
    return kern_id in rune_ids or 'runic' in kern_id

def is_small_cap(kern_id):
	return kern_id in smallcap_ids or '.sc' in kern_id

def is_lowercase(kern_id):
    return (kern_id in lowercase_ids
            or kern_id.replace("@MMK_L_KO_","") in lowercase
            or kern_id.replace("@MMK_R_KO_","") in lowercase)

def del_kerns_in_master(master_index):
    master_id = Glyphs.font.masters[master_index].id
    master_kerns = Glyphs.font.kerning[master_id]
    del_pairs = []
    left_kern_keys = master_kerns.keys()
    for l in left_kern_keys:
        right_kern_keys = master_kerns[l].keys()
        for r in right_kern_keys:
            if ((is_rune(l) and not is_rune(r))
                or (is_rune(r) and not is_rune(l))
                or (is_small_cap(l) and is_lowercase(r))
                or (is_small_cap(r) and is_lowercase(l))):
                del_pairs.append([l, r])
    for p in del_pairs:
        del master_kerns[p[0]][p[1]]
    print(str(len(del_pairs)) + " pairs deleted in master " + str(master_index))

for n in rune_names:
    try:
        rune_ids.append(Glyphs.font.glyphs[n].id)
    except:
        print("skipping " + n)
for n in smallcaps:
    try:
        smallcap_ids.append(Glyphs.font.glyphs[n].id)
    except:
        print("skipping " + n)
for n in lowercase:
    try:
        lowercase_ids.append(Glyphs.font.glyphs[n].id)
    except:
        print("skipping " + n)

italic = False

del_kerns_in_master(0)
del_kerns_in_master(1)
del_kerns_in_master(2)
del_kerns_in_master(3)
del_kerns_in_master(4)
if italic:
    del_kerns_in_master(6)
