#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core import debug


class speech_driver:
    def __init__(self):
        pass

    def initialize(self, environment):
        self._is_initialized = False
        self.language = None
        self.voice = None
        self.module = None
        self.pitch = None
        self.rate = None
        self.volume = None
        self.env = environment
        self._is_initialized = True

    def shutdown(self):
        if self._is_initialized:
            self.cancel()
        self._is_initialized = False

    def speak(self, text, queueable=True, ignore_punctuation=False):
        if not self._is_initialized:
            return
        if not queueable:
            self.cancel()

    def cancel(self):
        if not self._is_initialized:
            return

    def set_callback(self, callback):
        if not self._is_initialized:
            return
        if not callback:
            return

    def clear_buffer(self):
        if not self._is_initialized:
            return

    def set_voice(self, voice):
        if not self._is_initialized:
            return
        if voice == "":
            return
        self.voice = voice

    def set_pitch(self, pitch):
        if not self._is_initialized:
            return
        if not isinstance(pitch, float):
            return
        if pitch < 0.0:
            return
        if pitch > 1.0:
            return
        self.pitch = pitch

    def set_rate(self, rate):
        if not self._is_initialized:
            return
        if not isinstance(rate, float):
            return
        if rate < 0.0:
            return
        if rate > 1.0:
            return
        self.rate = rate

    def set_module(self, module):
        if not self._is_initialized:
            return
        if not isinstance(module, str):
            return
        if module == "":
            return
        self.module = module

    def reset(self):
        self.shutdown()
        self.initialize(self.env)

    def set_language(self, language):
        if not self._is_initialized:
            return
        if not isinstance(language, str):
            return
        if language == "":
            return
        self.language = language

    def set_volume(self, volume):
        if not self._is_initialized:
            return
        if not isinstance(volume, float):
            return
        if volume < 0.0:
            return
        if volume > 1.0:
            return
        self.volume = volume
