/* $Id: WarnUnused.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 * WarnUnused: Visitor to emit a warning if a variable/constant/signal is
 * unused.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/visitor/WarnUnused.hpp"
#include "frontend/ast/ValDeclaration.hpp"
#include "frontend/reporting/ErrorRegistry.hpp"

namespace ast {

void
WarnUnused::process(ValDeclaration &node)
{
	const char *kind = NULL;

	if (node.usage != ValDeclaration::USAGE_NONE) {
		return;
	}

	switch (node.storageClass) {
	case ValDeclaration::OBJ_CLASS_SIGNAL:
		kind = "signal";
		break;

	case ValDeclaration::OBJ_CLASS_VARIABLE:
		kind = "variable";
		break;

	case ValDeclaration::OBJ_CLASS_CONSTANT:
		/* skip */
		return;

	case ValDeclaration::OBJ_CLASS_UNSPECIFIED:
		assert(false);
		break;
	
	}

	assert(node.name != NULL);
	std::string msg = std::string("Unused ");
	msg += kind;
	msg += " '";
	msg += *node.name;
	msg += "'.";

	CompileError *ce = new CompileError(node, msg);
	/* FIXME add a warning, not an error */
	ErrorRegistry::addWarning(ce);
}

};
