// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file XMLProfilesExamplePublisher.cpp
 * This file contains the implementation of the publisher functions.
 *
 * This file was generated by the tool fastcdrgen.
 */


#include <fastrtps/participant/Participant.h>
#include <fastrtps/attributes/ParticipantAttributes.h>
#include <fastrtps/publisher/Publisher.h>
#include <fastrtps/attributes/PublisherAttributes.h>

#include <fastrtps/Domain.h>
#include "XMLProfilesExamplePublisher.h"

using namespace eprosima::fastrtps;
using namespace eprosima::fastrtps::rtps;

XMLProfilesExamplePublisher::XMLProfilesExamplePublisher() : mp_participant(nullptr), mp_publisher(nullptr) {}

XMLProfilesExamplePublisher::~XMLProfilesExamplePublisher() {    Domain::removeParticipant(mp_participant);}

bool XMLProfilesExamplePublisher::init()
{
    // Create RTPSParticipant
    std::string participant_profile_name = "participant_profile";
    mp_participant = Domain::createParticipant(participant_profile_name);
    if(mp_participant == nullptr)
        return false;

    // Register the type
    Domain::registerType(mp_participant,(TopicDataType*) &myType);

    // Create Publisher
    std::string profile_name = "publisher_profile";
    mp_publisher = Domain::createPublisher(mp_participant,profile_name,(PublisherListener*)&m_listener);
    if(mp_publisher == nullptr)
        return false;

    std::cout << "Publisher created, waiting for Subscribers." << std::endl;
    return true;
}

void XMLProfilesExamplePublisher::PubListener::onPublicationMatched(Publisher*, MatchingInfo& info)
{
    if (info.status == MATCHED_MATCHING)
    {
        n_matched++;
        std::cout << "Publisher matched" << std::endl;
    }
    else
    {
        n_matched--;
        std::cout << "Publisher unmatched" << std::endl;
    }
}

void XMLProfilesExamplePublisher::run()
{
    // Publication code

    XMLProfilesExample st;

    /* Initialize your structure here */

    int msgsent = 0;
    char ch = 'y';
    bool continuous = false;

    do
    {
        ch = 'y';
        std::cout << "Waiting for Subscribers." << std::endl;
        while(m_listener.n_matched == 0)
        {
            std::this_thread::sleep_for(std::chrono::milliseconds(250));
        }

        do
        {
            if(ch == 'y')
            {
                mp_publisher->write(&st);  ++msgsent;
                std::cout << "Sending sample, count=" << msgsent << ", send another sample?(y-yes,n-stop,c-continuous): ";
            }
            else if(ch == 'n')
            {
                std::cout << "Stopping execution " << std::endl;
                break;
            }
            else if(ch == 'c')
            {
                if(!continuous)
                {
                    continuous = true;
                    std::cout << "Starting continuous publishing" << std::endl;
                }
                mp_publisher->write(&st);  ++msgsent;
                std::cout << "Sending sample, count=" << msgsent << std::endl;
                std::this_thread::sleep_for(std::chrono::milliseconds(100));
            }
            else
            {
                std::cout << "Command " << ch << " not recognized, please enter \"y/n/c\":";
            }
        } while((m_listener.n_matched > 0) && (continuous || (std::cin >> ch)));
    } while(ch != 'n');
}
