
/*
    Enki - a fast 2D robot simulator
    Copyright (C) 1999-2016 Stephane Magnenat <stephane at magnenat dot net>
    Copyright (C) 2004-2005 Markus Waibel <markus dot waibel at epfl dot ch>
    Copyright (c) 2004-2005 Antoine Beyeler <abeyeler at ab-ware dot com>
    Copyright (C) 2005-2006 Laboratory of Intelligent Systems, EPFL, Lausanne
    Copyright (C) 2006 Laboratory of Robotics Systems, EPFL, Lausanne
    See AUTHORS for details

    This program is free software; the authors of any publication 
    arising from research using this software are asked to add the 
    following reference:
    Enki - a fast 2D robot simulator
    http://home.gna.org/enki
    Stephane Magnenat <stephane at magnenat dot net>,
    Markus Waibel <markus dot waibel at epfl dot ch>
    Laboratory of Intelligent Systems, EPFL, Lausanne.

    You can redistribute this program and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// Marxbot base

#include <QtOpenGL>

namespace Enki
{
	// 1654 Verticies
	// 513 Texture Coordinates
	// 1566 Normals
	// 3114 Triangles

	static short face_indicies[3114][9] = {
	// Object #-1
		{256,0,4 ,0,0,0 ,0,1,2 }, {5,0,256 ,0,0,0 ,2,1,0 }, {6,1,257 ,0,0,1 ,2,1,0 },
		{257,1,7 ,1,0,0 ,0,1,2 }, {8,2,258 ,2,2,3 ,2,1,0 }, {258,2,9 ,3,2,2 ,0,1,2 },
		{259,3,10 ,2,2,2 ,0,1,2 }, {11,3,259 ,2,2,2 ,2,1,0 }, {260,132,128 ,2,2,2 ,3,4,5 },
		{128,133,260 ,2,2,2 ,5,4,3 }, {129,134,261 ,2,2,2 ,5,4,3 }, {261,135,129 ,2,2,2 ,3,4,5 },
		{130,136,262 ,0,0,0 ,5,4,3 }, {262,137,130 ,0,0,0 ,3,4,5 }, {263,138,131 ,0,0,0 ,3,4,5 },
		{131,139,263 ,0,0,0 ,5,4,3 }, {256,4,12 ,0,0,0 ,0,2,6 }, {13,5,256 ,0,0,0 ,6,2,0 },
		{14,6,257 ,0,0,1 ,6,2,0 }, {257,7,15 ,1,0,0 ,0,2,6 }, {16,8,258 ,2,2,3 ,6,2,0 },
		{258,9,17 ,3,2,2 ,0,2,6 }, {259,10,18 ,2,2,2 ,0,2,6 }, {19,11,259 ,2,2,2 ,6,2,0 },
		{260,140,132 ,2,2,2 ,3,7,4 }, {133,141,260 ,2,2,2 ,4,7,3 }, {134,142,261 ,2,2,2 ,4,7,3 },
		{261,143,135 ,2,2,2 ,3,7,4 }, {136,144,262 ,0,0,0 ,4,7,3 }, {262,145,137 ,0,0,0 ,3,7,4 },
		{263,146,138 ,0,0,0 ,3,7,4 }, {139,147,263 ,0,0,0 ,4,7,3 }, {256,12,20 ,0,0,0 ,0,6,8 },
		{21,13,256 ,0,0,0 ,8,6,0 }, {22,14,257 ,0,0,1 ,8,6,0 }, {257,15,23 ,1,0,0 ,0,6,8 },
		{24,16,258 ,2,2,3 ,8,6,0 }, {258,17,25 ,3,2,2 ,0,6,8 }, {259,18,26 ,2,2,2 ,0,6,8 },
		{27,19,259 ,2,2,2 ,8,6,0 }, {260,148,140 ,2,2,2 ,3,9,7 }, {141,149,260 ,2,2,2 ,7,9,3 },
		{142,150,261 ,2,2,2 ,7,9,3 }, {261,151,143 ,2,2,2 ,3,9,7 }, {144,152,262 ,0,0,0 ,7,9,3 },
		{262,153,145 ,0,0,0 ,3,9,7 }, {263,154,146 ,0,0,0 ,3,9,7 }, {147,155,263 ,0,0,0 ,7,9,3 },
		{256,20,28 ,0,0,0 ,0,8,10 }, {29,21,256 ,0,0,0 ,10,8,0 }, {30,22,257 ,0,0,1 ,10,8,0 },
		{257,23,31 ,1,0,0 ,0,8,10 }, {32,24,258 ,2,2,3 ,10,8,0 }, {258,25,33 ,3,2,2 ,0,8,10 },
		{259,26,34 ,2,2,2 ,0,8,10 }, {35,27,259 ,2,2,2 ,10,8,0 }, {260,156,148 ,2,2,2 ,3,11,9 },
		{149,157,260 ,2,2,2 ,9,11,3 }, {150,158,261 ,2,2,2 ,9,11,3 },
		{261,159,151 ,2,2,2 ,3,11,9 }, {152,160,262 ,0,0,0 ,9,11,3 },
		{262,161,153 ,0,0,0 ,3,11,9 }, {263,162,154 ,0,0,0 ,3,11,9 },
		{155,163,263 ,0,0,0 ,9,11,3 }, {256,28,36 ,0,0,0 ,0,10,12 },
		{37,29,256 ,0,0,0 ,12,10,0 }, {38,30,257 ,0,0,1 ,12,10,0 }, {257,31,39 ,1,0,0 ,0,10,12 },
		{40,32,258 ,2,2,3 ,12,10,0 }, {258,33,41 ,3,2,2 ,0,10,12 }, {259,34,42 ,2,2,2 ,0,10,12 },
		{43,35,259 ,2,2,2 ,12,10,0 }, {260,164,156 ,2,2,2 ,3,13,11 },
		{157,165,260 ,2,2,2 ,11,13,3 }, {158,166,261 ,2,2,2 ,11,13,3 },
		{261,167,159 ,2,2,2 ,3,13,11 }, {160,168,262 ,0,0,0 ,11,13,3 },
		{262,169,161 ,0,0,0 ,3,13,11 }, {263,170,162 ,0,0,0 ,3,13,11 },
		{163,171,263 ,0,0,0 ,11,13,3 }, {260,172,164 ,2,2,2 ,3,14,13 },
		{165,173,260 ,2,2,2 ,13,14,3 }, {166,174,261 ,2,2,2 ,13,14,3 },
		{261,175,167 ,2,2,2 ,3,14,13 }, {168,176,262 ,0,0,0 ,13,14,3 },
		{262,177,169 ,0,0,0 ,3,14,13 }, {263,178,170 ,0,0,0 ,3,14,13 },
		{171,179,263 ,0,0,0 ,13,14,3 }, {256,44,52 ,0,0,0 ,0,15,16 },
		{53,45,256 ,0,0,0 ,16,15,0 }, {54,46,257 ,4,0,1 ,16,15,0 }, {257,47,55 ,1,0,0 ,0,15,16 },
		{56,48,258 ,5,2,3 ,16,15,0 }, {258,49,57 ,3,2,2 ,0,15,16 }, {259,50,58 ,2,2,2 ,0,15,16 },
		{59,51,259 ,2,2,2 ,16,15,0 }, {260,180,172 ,2,2,2 ,3,17,14 },
		{173,181,260 ,2,2,2 ,14,17,3 }, {174,182,261 ,2,2,2 ,14,17,3 },
		{261,183,175 ,2,2,2 ,3,17,14 }, {176,184,262 ,0,0,0 ,14,17,3 },
		{262,185,177 ,0,0,0 ,3,17,14 }, {263,186,178 ,0,0,0 ,3,17,14 },
		{179,187,263 ,0,0,0 ,14,17,3 }, {256,52,60 ,0,0,0 ,0,16,18 },
		{61,53,256 ,0,0,0 ,18,16,0 }, {62,54,257 ,6,4,1 ,18,16,0 }, {257,55,63 ,1,0,0 ,0,16,18 },
		{64,56,258 ,7,5,3 ,18,16,0 }, {258,57,65 ,3,2,2 ,0,16,18 }, {259,58,66 ,2,2,2 ,0,16,18 },
		{67,59,259 ,2,2,2 ,18,16,0 }, {260,188,180 ,2,2,2 ,3,19,17 },
		{181,189,260 ,2,2,2 ,17,19,3 }, {182,190,261 ,2,2,2 ,17,19,3 },
		{261,191,183 ,2,2,2 ,3,19,17 }, {184,192,262 ,0,0,0 ,17,19,3 },
		{262,193,185 ,0,0,0 ,3,19,17 }, {263,194,186 ,0,0,0 ,3,19,17 },
		{187,195,263 ,0,0,0 ,17,19,3 }, {256,60,68 ,0,0,0 ,0,18,20 },
		{69,61,256 ,0,0,0 ,20,18,0 }, {70,62,257 ,8,6,1 ,20,18,0 }, {257,63,71 ,1,0,0 ,0,18,20 },
		{72,64,258 ,9,7,3 ,20,18,0 }, {258,65,73 ,3,2,2 ,0,18,20 }, {259,66,74 ,2,2,2 ,0,18,20 },
		{75,67,259 ,2,2,2 ,20,18,0 }, {260,196,188 ,2,2,2 ,3,21,19 },
		{189,197,260 ,2,2,2 ,19,21,3 }, {190,198,261 ,2,2,2 ,19,21,3 },
		{261,199,191 ,2,2,2 ,3,21,19 }, {192,200,262 ,0,0,0 ,19,21,3 },
		{262,201,193 ,0,0,0 ,3,21,19 }, {263,202,194 ,0,0,0 ,3,21,19 },
		{195,203,263 ,0,0,0 ,19,21,3 }, {256,68,76 ,0,0,0 ,0,20,22 },
		{77,69,256 ,0,0,0 ,22,20,0 }, {78,70,257 ,0,8,1 ,22,20,0 }, {257,71,79 ,1,0,0 ,0,20,22 },
		{80,72,258 ,2,9,3 ,22,20,0 }, {258,73,81 ,3,2,2 ,0,20,22 }, {259,74,82 ,2,2,2 ,0,20,22 },
		{83,75,259 ,2,2,2 ,22,20,0 }, {260,204,196 ,2,2,2 ,3,23,21 },
		{197,205,260 ,2,2,2 ,21,23,3 }, {198,206,261 ,2,2,2 ,21,23,3 },
		{261,207,199 ,2,2,2 ,3,23,21 }, {200,208,262 ,0,0,0 ,21,23,3 },
		{262,209,201 ,0,0,0 ,3,23,21 }, {263,210,202 ,0,0,0 ,3,23,21 },
		{203,211,263 ,0,0,0 ,21,23,3 }, {256,76,84 ,0,0,0 ,0,22,24 },
		{85,77,256 ,0,0,0 ,24,22,0 }, {86,78,257 ,0,0,1 ,24,22,0 }, {257,79,87 ,1,0,0 ,0,22,24 },
		{88,80,258 ,2,2,3 ,24,22,0 }, {258,81,89 ,3,2,2 ,0,22,24 }, {259,82,90 ,2,2,2 ,0,22,24 },
		{91,83,259 ,2,2,2 ,24,22,0 }, {260,212,204 ,2,2,2 ,3,25,23 },
		{205,213,260 ,2,2,2 ,23,25,3 }, {206,214,261 ,2,2,2 ,23,25,3 },
		{261,215,207 ,2,2,2 ,3,25,23 }, {208,216,262 ,0,0,0 ,23,25,3 },
		{262,217,209 ,0,0,0 ,3,25,23 }, {263,218,210 ,0,0,0 ,3,25,23 },
		{211,219,263 ,0,0,0 ,23,25,3 }, {256,84,92 ,0,0,0 ,0,24,26 },
		{93,85,256 ,0,0,0 ,26,24,0 }, {94,86,257 ,0,0,1 ,26,24,0 }, {257,87,95 ,1,0,0 ,0,24,26 },
		{96,88,258 ,2,2,3 ,26,24,0 }, {258,89,97 ,3,2,2 ,0,24,26 }, {259,90,98 ,2,2,2 ,0,24,26 },
		{99,91,259 ,2,2,2 ,26,24,0 }, {260,220,212 ,2,2,2 ,3,27,25 },
		{213,221,260 ,2,2,2 ,25,27,3 }, {214,222,261 ,2,2,2 ,25,27,3 },
		{261,223,215 ,2,2,2 ,3,27,25 }, {216,224,262 ,0,0,0 ,25,27,3 },
		{262,225,217 ,0,0,0 ,3,27,25 }, {263,226,218 ,0,0,0 ,3,27,25 },
		{219,227,263 ,0,0,0 ,25,27,3 }, {256,92,100 ,0,0,0 ,0,26,28 },
		{101,93,256 ,0,0,0 ,28,26,0 }, {102,94,257 ,0,0,1 ,28,26,0 },
		{257,95,103 ,1,0,0 ,0,26,28 }, {104,96,258 ,2,2,3 ,28,26,0 },
		{258,97,105 ,3,2,2 ,0,26,28 }, {259,98,106 ,2,2,2 ,0,26,28 },
		{107,99,259 ,2,2,2 ,28,26,0 }, {260,228,220 ,2,2,2 ,3,29,27 },
		{221,229,260 ,2,2,2 ,27,29,3 }, {222,230,261 ,2,2,2 ,27,29,3 },
		{261,231,223 ,2,2,2 ,3,29,27 }, {224,232,262 ,0,0,0 ,27,29,3 },
		{262,233,225 ,0,0,0 ,3,29,27 }, {263,234,226 ,0,0,0 ,3,29,27 },
		{227,235,263 ,0,0,0 ,27,29,3 }, {256,100,108 ,0,0,0 ,0,28,30 },
		{109,101,256 ,0,0,0 ,30,28,0 }, {110,102,257 ,0,0,1 ,30,28,0 },
		{257,103,111 ,1,0,0 ,0,28,30 }, {112,104,258 ,2,2,3 ,30,28,0 },
		{258,105,113 ,3,2,2 ,0,28,30 }, {259,106,114 ,2,2,2 ,0,28,30 },
		{115,107,259 ,2,2,2 ,30,28,0 }, {260,236,228 ,2,2,2 ,3,31,29 },
		{229,237,260 ,2,2,2 ,29,31,3 }, {230,238,261 ,2,2,2 ,29,31,3 },
		{261,239,231 ,2,2,2 ,3,31,29 }, {232,240,262 ,0,0,0 ,29,31,3 },
		{262,241,233 ,0,0,0 ,3,31,29 }, {263,242,234 ,0,0,0 ,3,31,29 },
		{235,243,263 ,0,0,0 ,29,31,3 }, {256,108,116 ,0,0,0 ,0,30,32 },
		{117,109,256 ,0,0,0 ,32,30,0 }, {118,110,257 ,0,0,1 ,32,30,0 },
		{257,111,119 ,1,0,0 ,0,30,32 }, {120,112,258 ,2,2,3 ,32,30,0 },
		{258,113,121 ,3,2,2 ,0,30,32 }, {259,114,122 ,2,2,2 ,0,30,32 },
		{123,115,259 ,2,2,2 ,32,30,0 }, {260,244,236 ,2,2,2 ,3,33,31 },
		{237,245,260 ,2,2,2 ,31,33,3 }, {238,246,261 ,2,2,2 ,31,33,3 },
		{261,247,239 ,2,2,2 ,3,33,31 }, {240,248,262 ,0,0,0 ,31,33,3 },
		{262,249,241 ,0,0,0 ,3,33,31 }, {263,250,242 ,0,0,0 ,3,33,31 },
		{243,251,263 ,0,0,0 ,31,33,3 }, {256,116,124 ,0,0,0 ,0,32,34 },
		{124,117,256 ,0,0,0 ,34,32,0 }, {125,118,257 ,0,0,1 ,34,32,0 },
		{257,119,125 ,1,0,0 ,0,32,34 }, {126,120,258 ,2,2,3 ,34,32,0 },
		{258,121,126 ,3,2,2 ,0,32,34 }, {259,122,127 ,2,2,2 ,0,32,34 },
		{127,123,259 ,2,2,2 ,34,32,0 }, {260,252,244 ,2,2,2 ,3,35,33 },
		{245,252,260 ,2,2,2 ,33,35,3 }, {246,253,261 ,2,2,2 ,33,35,3 },
		{261,253,247 ,2,2,2 ,3,35,33 }, {248,254,262 ,0,0,0 ,33,35,3 },
		{262,254,249 ,0,0,0 ,3,35,33 }, {263,255,250 ,0,0,0 ,3,35,33 },
		{251,255,263 ,0,0,0 ,33,35,3 }, {0,132,4 ,10,11,12 ,36,37,38 },
		{0,128,132 ,10,13,11 ,36,39,37 }, {0,133,128 ,10,14,13 ,36,37,39 },
		{0,5,133 ,10,15,14 ,36,38,37 }, {134,1,6 ,16,17,18 ,37,36,38 },
		{134,129,1 ,16,19,17 ,37,39,36 }, {1,135,7 ,17,20,21 ,36,37,38 },
		{1,129,135 ,17,19,20 ,36,39,37 }, {136,2,8 ,22,23,24 ,37,36,38 },
		{136,130,2 ,22,25,23 ,37,39,36 }, {2,137,9 ,23,26,27 ,36,37,38 },
		{2,130,137 ,23,25,26 ,36,39,37 }, {3,138,10 ,28,29,30 ,36,37,38 },
		{3,131,138 ,28,31,29 ,36,39,37 }, {139,3,11 ,32,28,33 ,37,36,38 },
		{139,131,3 ,32,31,28 ,37,39,36 }, {4,140,12 ,12,34,35 ,38,40,41 },
		{4,132,140 ,12,11,34 ,38,37,40 }, {141,5,13 ,36,15,37 ,40,38,41 },
		{141,133,5 ,36,14,15 ,40,37,38 }, {142,6,14 ,38,18,39 ,40,38,41 },
		{142,134,6 ,38,16,18 ,40,37,38 }, {7,143,15 ,21,40,41 ,38,40,41 },
		{7,135,143 ,21,20,40 ,38,37,40 }, {144,8,16 ,42,24,43 ,40,38,41 },
		{144,136,8 ,42,22,24 ,40,37,38 }, {9,145,17 ,27,44,45 ,38,40,41 },
		{9,137,145 ,27,26,44 ,38,37,40 }, {10,146,18 ,30,46,47 ,38,40,41 },
		{10,138,146 ,30,29,46 ,38,37,40 }, {147,11,19 ,48,33,49 ,40,38,41 },
		{147,139,11 ,48,32,33 ,40,37,38 }, {12,148,20 ,35,50,51 ,41,42,43 },
		{12,140,148 ,35,34,50 ,41,40,42 }, {149,13,21 ,52,37,53 ,42,41,43 },
		{149,141,13 ,52,36,37 ,42,40,41 }, {150,14,22 ,54,39,55 ,42,41,43 },
		{150,142,14 ,54,38,39 ,42,40,41 }, {15,151,23 ,41,56,57 ,41,42,43 },
		{15,143,151 ,41,40,56 ,41,40,42 }, {152,16,24 ,58,43,59 ,42,41,43 },
		{152,144,16 ,58,42,43 ,42,40,41 }, {17,153,25 ,45,60,61 ,41,42,43 },
		{17,145,153 ,45,44,60 ,41,40,42 }, {18,154,26 ,47,62,63 ,41,42,43 },
		{18,146,154 ,47,46,62 ,41,40,42 }, {155,19,27 ,64,49,65 ,42,41,43 },
		{155,147,19 ,64,48,49 ,42,40,41 }, {20,156,28 ,51,66,67 ,43,44,45 },
		{20,148,156 ,51,50,66 ,43,42,44 }, {157,21,29 ,68,53,69 ,44,43,45 },
		{157,149,21 ,68,52,53 ,44,42,43 }, {158,22,30 ,70,55,71 ,44,43,45 },
		{158,150,22 ,70,54,55 ,44,42,43 }, {23,159,31 ,57,72,73 ,43,44,45 },
		{23,151,159 ,57,56,72 ,43,42,44 }, {160,24,32 ,74,59,75 ,44,43,45 },
		{160,152,24 ,74,58,59 ,44,42,43 }, {25,161,33 ,61,76,77 ,43,44,45 },
		{25,153,161 ,61,60,76 ,43,42,44 }, {26,162,34 ,63,78,79 ,43,44,45 },
		{26,154,162 ,63,62,78 ,43,42,44 }, {163,27,35 ,80,65,81 ,44,43,45 },
		{163,155,27 ,80,64,65 ,44,42,43 }, {28,164,36 ,67,82,83 ,45,46,47 },
		{28,156,164 ,67,66,82 ,45,44,46 }, {165,29,37 ,84,69,85 ,46,45,47 },
		{165,157,29 ,84,68,69 ,46,44,45 }, {166,30,38 ,86,71,87 ,46,45,47 },
		{166,158,30 ,86,70,71 ,46,44,45 }, {31,167,39 ,73,88,89 ,45,46,47 },
		{31,159,167 ,73,72,88 ,45,44,46 }, {168,32,40 ,90,75,83 ,46,45,47 },
		{168,160,32 ,90,74,75 ,46,44,45 }, {33,169,41 ,77,91,92 ,45,46,47 },
		{33,161,169 ,77,76,91 ,45,44,46 }, {34,170,42 ,79,93,87 ,45,46,47 },
		{34,162,170 ,79,78,93 ,45,44,46 }, {171,35,43 ,94,81,95 ,46,45,47 },
		{171,163,35 ,94,80,81 ,46,44,45 }, {60,196,68 ,96,97,98 ,48,49,50 },
		{60,188,196 ,96,99,97 ,48,51,49 }, {197,61,69 ,100,101,102 ,49,48,50 },
		{197,189,61 ,100,103,101 ,49,51,48 }, {198,62,70 ,104,105,106 ,49,48,50 },
		{198,190,62 ,104,107,105 ,49,51,48 }, {63,199,71 ,108,109,110 ,48,49,50 },
		{63,191,199 ,108,111,109 ,48,51,49 }, {200,64,72 ,112,113,114 ,49,48,50 },
		{200,192,64 ,112,115,113 ,49,51,48 }, {65,201,73 ,116,117,118 ,48,49,50 },
		{65,193,201 ,116,119,117 ,48,51,49 }, {66,202,74 ,120,121,122 ,48,49,50 },
		{66,194,202 ,120,123,121 ,48,51,49 }, {203,67,75 ,124,125,126 ,49,48,50 },
		{203,195,67 ,124,127,125 ,49,51,48 }, {68,204,76 ,98,128,129 ,50,52,53 },
		{68,196,204 ,98,97,128 ,50,49,52 }, {205,69,77 ,130,102,131 ,52,50,53 },
		{205,197,69 ,130,100,102 ,52,49,50 }, {206,70,78 ,132,106,133 ,52,50,53 },
		{206,198,70 ,132,104,106 ,52,49,50 }, {71,207,79 ,110,134,135 ,50,52,53 },
		{71,199,207 ,110,109,134 ,50,49,52 }, {208,72,80 ,136,114,137 ,52,50,53 },
		{208,200,72 ,136,112,114 ,52,49,50 }, {73,209,81 ,118,138,139 ,50,52,53 },
		{73,201,209 ,118,117,138 ,50,49,52 }, {74,210,82 ,122,140,141 ,50,52,53 },
		{74,202,210 ,122,121,140 ,50,49,52 }, {211,75,83 ,142,126,143 ,52,50,53 },
		{211,203,75 ,142,124,126 ,52,49,50 }, {76,212,84 ,129,144,145 ,53,54,55 },
		{76,204,212 ,129,128,144 ,53,52,54 }, {213,77,85 ,146,131,147 ,54,53,55 },
		{213,205,77 ,146,130,131 ,54,52,53 }, {214,78,86 ,148,133,149 ,54,53,55 },
		{214,206,78 ,148,132,133 ,54,52,53 }, {79,215,87 ,135,150,151 ,53,54,55 },
		{79,207,215 ,135,134,150 ,53,52,54 }, {216,80,88 ,152,137,153 ,54,53,55 },
		{216,208,80 ,152,136,137 ,54,52,53 }, {81,217,89 ,139,154,155 ,53,54,55 },
		{81,209,217 ,139,138,154 ,53,52,54 }, {82,218,90 ,141,156,157 ,53,54,55 },
		{82,210,218 ,141,140,156 ,53,52,54 }, {219,83,91 ,158,143,159 ,54,53,55 },
		{219,211,83 ,158,142,143 ,54,52,53 }, {84,220,92 ,145,160,161 ,55,56,57 },
		{84,212,220 ,145,144,160 ,55,54,56 }, {221,85,93 ,162,147,163 ,56,55,57 },
		{221,213,85 ,162,146,147 ,56,54,55 }, {222,86,94 ,164,149,165 ,56,55,57 },
		{222,214,86 ,164,148,149 ,56,54,55 }, {87,223,95 ,151,166,167 ,55,56,57 },
		{87,215,223 ,151,150,166 ,55,54,56 }, {224,88,96 ,168,153,169 ,56,55,57 },
		{224,216,88 ,168,152,153 ,56,54,55 }, {89,225,97 ,155,170,171 ,55,56,57 },
		{89,217,225 ,155,154,170 ,55,54,56 }, {90,226,98 ,157,172,173 ,55,56,57 },
		{90,218,226 ,157,156,172 ,55,54,56 }, {227,91,99 ,174,159,175 ,56,55,57 },
		{227,219,91 ,174,158,159 ,56,54,55 }, {92,228,100 ,161,176,177 ,57,58,59 },
		{92,220,228 ,161,160,176 ,57,56,58 }, {229,93,101 ,178,163,179 ,58,57,59 },
		{229,221,93 ,178,162,163 ,58,56,57 }, {230,94,102 ,180,165,181 ,58,57,59 },
		{230,222,94 ,180,164,165 ,58,56,57 }, {95,231,103 ,167,182,183 ,57,58,59 },
		{95,223,231 ,167,166,182 ,57,56,58 }, {232,96,104 ,184,169,185 ,58,57,59 },
		{232,224,96 ,184,168,169 ,58,56,57 }, {97,233,105 ,171,186,187 ,57,58,59 },
		{97,225,233 ,171,170,186 ,57,56,58 }, {98,234,106 ,173,188,189 ,57,58,59 },
		{98,226,234 ,173,172,188 ,57,56,58 }, {235,99,107 ,190,175,191 ,58,57,59 },
		{235,227,99 ,190,174,175 ,58,56,57 }, {100,236,108 ,177,192,193 ,59,60,61 },
		{100,228,236 ,177,176,192 ,59,58,60 }, {237,101,109 ,194,179,195 ,60,59,61 },
		{237,229,101 ,194,178,179 ,60,58,59 }, {238,102,110 ,196,181,197 ,60,59,61 },
		{238,230,102 ,196,180,181 ,60,58,59 }, {103,239,111 ,183,198,199 ,59,60,61 },
		{103,231,239 ,183,182,198 ,59,58,60 }, {240,104,112 ,200,185,201 ,60,59,61 },
		{240,232,104 ,200,184,185 ,60,58,59 }, {105,241,113 ,187,202,203 ,59,60,61 },
		{105,233,241 ,187,186,202 ,59,58,60 }, {106,242,114 ,189,204,205 ,59,60,61 },
		{106,234,242 ,189,188,204 ,59,58,60 }, {243,107,115 ,206,191,207 ,60,59,61 },
		{243,235,107 ,206,190,191 ,60,58,59 }, {108,244,116 ,193,208,209 ,61,62,63 },
		{108,236,244 ,193,192,208 ,61,60,62 }, {245,109,117 ,210,195,211 ,62,61,63 },
		{245,237,109 ,210,194,195 ,62,60,61 }, {246,110,118 ,212,197,213 ,62,61,63 },
		{246,238,110 ,212,196,197 ,62,60,61 }, {111,247,119 ,199,214,215 ,61,62,63 },
		{111,239,247 ,199,198,214 ,61,60,62 }, {248,112,120 ,216,201,217 ,62,61,63 },
		{248,240,112 ,216,200,201 ,62,60,61 }, {113,249,121 ,203,218,219 ,61,62,63 },
		{113,241,249 ,203,202,218 ,61,60,62 }, {114,250,122 ,205,220,221 ,61,62,63 },
		{114,242,250 ,205,204,220 ,61,60,62 }, {251,115,123 ,222,207,223 ,62,61,63 },
		{251,243,115 ,222,206,207 ,62,60,61 }, {116,252,124 ,209,224,225 ,63,64,65 },
		{116,244,252 ,209,208,224 ,63,62,64 }, {252,117,124 ,224,211,225 ,64,63,65 },
		{252,245,117 ,224,210,211 ,64,62,63 }, {253,118,125 ,226,213,227 ,64,63,65 },
		{253,246,118 ,226,212,213 ,64,62,63 }, {119,253,125 ,215,226,227 ,63,64,65 },
		{119,247,253 ,215,214,226 ,63,62,64 }, {254,120,126 ,228,217,229 ,64,63,65 },
		{254,248,120 ,228,216,217 ,64,62,63 }, {121,254,126 ,219,228,229 ,63,64,65 },
		{121,249,254 ,219,218,228 ,63,62,64 }, {122,255,127 ,221,230,231 ,63,64,65 },
		{122,250,255 ,221,220,230 ,63,62,64 }, {255,123,127 ,230,223,231 ,64,63,65 },
		{255,251,123 ,230,222,223 ,64,62,63 }, {256,36,44 ,0,0,0 ,0,12,15 },
		{45,37,256 ,0,0,0 ,15,12,0 }, {46,38,257 ,0,0,1 ,15,12,0 }, {257,39,47 ,1,0,0 ,0,12,15 },
		{48,40,258 ,2,2,3 ,15,12,0 }, {258,41,49 ,3,2,2 ,0,12,15 }, {259,42,50 ,2,2,2 ,0,12,15 },
		{51,43,259 ,2,2,2 ,15,12,0 }, {44,284,280 ,0,0,0 ,15,66,67 },
		{44,36,284 ,0,0,0 ,15,12,66 }, {285,45,281 ,0,0,0 ,66,15,67 },
		{285,37,45 ,0,0,0 ,66,12,15 }, {284,46,280 ,0,0,0 ,66,15,67 },
		{284,38,46 ,0,0,0 ,66,12,15 }, {47,285,281 ,0,0,0 ,15,66,67 },
		{47,39,285 ,0,0,0 ,15,12,66 }, {286,48,282 ,2,2,2 ,66,15,67 },
		{286,40,48 ,2,2,2 ,66,12,15 }, {49,287,283 ,2,2,2 ,15,66,67 },
		{49,41,287 ,2,2,2 ,15,12,66 }, {50,286,282 ,2,2,2 ,15,66,67 },
		{50,42,286 ,2,2,2 ,15,12,66 }, {287,51,283 ,2,2,2 ,66,15,67 },
		{287,43,51 ,2,2,2 ,66,12,15 }, {188,268,264 ,99,232,233 ,51,68,69 },
		{188,60,268 ,99,96,232 ,51,48,68 }, {269,189,265 ,234,103,235 ,68,51,69 },
		{269,61,189 ,234,101,103 ,68,48,51 }, {268,190,264 ,232,107,233 ,68,51,69 },
		{268,62,190 ,232,105,107 ,68,48,51 }, {191,269,265 ,111,234,235 ,51,68,69 },
		{191,63,269 ,111,108,234 ,51,48,68 }, {270,192,266 ,236,115,233 ,68,51,69 },
		{270,64,192 ,236,113,115 ,68,48,51 }, {193,271,267 ,119,237,235 ,51,68,69 },
		{193,65,271 ,119,116,237 ,51,48,68 }, {194,270,266 ,123,236,233 ,51,68,69 },
		{194,66,270 ,123,120,236 ,51,48,68 }, {271,195,267 ,237,127,235 ,68,51,69 },
		{271,67,195 ,237,125,127 ,68,48,51 }, {36,276,284 ,238,239,239 ,47,70,71 },
		{36,164,276 ,238,238,239 ,47,46,70 }, {277,37,285 ,240,241,242 ,70,47,71 },
		{277,165,37 ,240,243,241 ,70,46,47 }, {276,38,284 ,239,244,239 ,70,47,71 },
		{276,166,38 ,239,244,244 ,70,46,47 }, {39,277,285 ,245,240,242 ,47,70,71 },
		{39,167,277 ,245,246,240 ,47,46,70 }, {278,40,286 ,239,238,239 ,70,47,71 },
		{278,168,40 ,239,238,238 ,70,46,47 }, {41,279,287 ,247,248,249 ,47,70,71 },
		{41,169,279 ,247,250,248 ,47,46,70 }, {42,278,286 ,244,239,239 ,47,70,71 },
		{42,170,278 ,244,244,239 ,47,46,70 }, {279,43,287 ,248,251,249 ,70,47,71 },
		{279,171,43 ,248,252,251 ,70,46,47 }, {180,188,264 ,2,2,2 ,17,19,72 },
		{265,189,181 ,2,2,2 ,72,19,17 }, {264,190,182 ,2,2,2 ,72,19,17 },
		{183,191,265 ,2,2,2 ,17,19,72 }, {266,192,184 ,0,0,0 ,72,19,17 },
		{185,193,267 ,0,0,0 ,17,19,72 }, {186,194,266 ,0,0,0 ,17,19,72 },
		{267,195,187 ,0,0,0 ,72,19,17 }, {60,52,268 ,0,0,0 ,18,16,73 },
		{269,53,61 ,0,0,0 ,73,16,18 }, {268,54,62 ,0,4,6 ,73,16,18 },
		{63,55,269 ,0,0,0 ,18,16,73 }, {270,56,64 ,2,5,7 ,73,16,18 },
		{65,57,271 ,2,2,2 ,18,16,73 }, {66,58,270 ,2,2,2 ,18,16,73 },
		{271,59,67 ,2,2,2 ,73,16,18 }, {172,264,272 ,2,2,2 ,14,72,74 },
		{172,180,264 ,2,2,2 ,14,17,72 }, {265,173,273 ,2,2,2 ,72,14,74 },
		{265,181,173 ,2,2,2 ,72,17,14 }, {264,174,272 ,2,2,2 ,72,14,74 },
		{264,182,174 ,2,2,2 ,72,17,14 }, {175,265,273 ,2,2,2 ,14,72,74 },
		{175,183,265 ,2,2,2 ,14,17,72 }, {266,176,274 ,0,0,0 ,72,14,74 },
		{266,184,176 ,0,0,0 ,72,17,14 }, {177,267,275 ,0,0,0 ,14,72,74 },
		{177,185,267 ,0,0,0 ,14,17,72 }, {178,266,274 ,0,0,0 ,14,72,74 },
		{178,186,266 ,0,0,0 ,14,17,72 }, {267,179,275 ,0,0,0 ,72,14,74 },
		{267,187,179 ,0,0,0 ,72,17,14 }, {52,280,268 ,0,0,0 ,16,67,73 },
		{52,44,280 ,0,0,0 ,16,15,67 }, {281,53,269 ,0,0,0 ,67,16,73 },
		{281,45,53 ,0,0,0 ,67,15,16 }, {280,54,268 ,0,4,0 ,67,16,73 },
		{280,46,54 ,0,0,4 ,67,15,16 }, {55,281,269 ,0,0,0 ,16,67,73 },
		{55,47,281 ,0,0,0 ,16,15,67 }, {282,56,270 ,2,5,2 ,67,16,73 },
		{282,48,56 ,2,2,5 ,67,15,16 }, {57,283,271 ,2,2,2 ,16,67,73 },
		{57,49,283 ,2,2,2 ,16,15,67 }, {58,282,270 ,2,2,2 ,16,67,73 },
		{58,50,282 ,2,2,2 ,16,15,67 }, {283,59,271 ,2,2,2 ,67,16,73 },
		{283,51,59 ,2,2,2 ,67,15,16 }, {164,272,276 ,2,2,2 ,13,74,75 },
		{164,172,272 ,2,2,2 ,13,14,74 }, {273,165,277 ,2,2,2 ,74,13,75 },
		{273,173,165 ,2,2,2 ,74,14,13 }, {272,166,276 ,2,2,2 ,74,13,75 },
		{272,174,166 ,2,2,2 ,74,14,13 }, {167,273,277 ,2,2,2 ,13,74,75 },
		{167,175,273 ,2,2,2 ,13,14,74 }, {274,168,278 ,0,0,0 ,74,13,75 },
		{274,176,168 ,0,0,0 ,74,14,13 }, {169,275,279 ,0,0,0 ,13,74,75 },
		{169,177,275 ,0,0,0 ,13,14,74 }, {170,274,278 ,0,0,0 ,13,74,75 },
		{170,178,274 ,0,0,0 ,13,14,74 }, {275,171,279 ,0,0,0 ,74,13,75 },
		{275,179,171 ,0,0,0 ,74,14,13 }, {284,272,280 ,253,253,253 ,71,76,77 },
		{284,276,272 ,253,253,253 ,71,70,76 }, {273,285,281 ,253,253,253 ,76,71,77 },
		{273,277,285 ,253,253,253 ,76,70,71 }, {274,286,282 ,253,253,253 ,76,71,77 },
		{274,278,286 ,253,253,253 ,76,70,71 }, {287,275,283 ,253,253,253 ,71,76,77 },
		{287,279,275 ,253,253,253 ,71,70,76 }, {280,264,268 ,253,253,253 ,77,69,68 },
		{280,272,264 ,253,253,253 ,77,76,69 }, {265,281,269 ,253,253,253 ,69,77,68 },
		{265,273,281 ,253,253,253 ,69,76,77 }, {266,282,270 ,253,253,253 ,69,77,68 },
		{266,274,282 ,253,253,253 ,69,76,77 }, {283,267,271 ,253,253,253 ,77,69,68 },
		{283,275,267 ,253,253,253 ,77,76,69 }, {1413,1009,1409 ,254,255,256 ,78,79,80 },
		{1410,1010,1414 ,257,258,259 ,80,79,78 }, {1411,1011,1415 ,260,261,262 ,80,79,78 },
		{1416,1012,1412 ,263,264,265 ,78,79,80 }, {1421,1045,1401 ,266,267,268 ,81,82,83 },
		{1402,1046,1422 ,269,270,271 ,83,82,81 }, {1403,1047,1423 ,272,273,274 ,83,82,81 },
		{1424,1048,1404 ,275,276,277 ,81,82,83 }, {1425,1045,1421 ,278,267,266 ,84,82,81 },
		{1422,1046,1426 ,271,270,279 ,81,82,84 }, {1423,1047,1427 ,274,273,280 ,81,82,84 },
		{1428,1048,1424 ,281,276,275 ,84,82,81 }, {1401,1045,1041 ,268,267,282 ,83,82,85 },
		{1042,1046,1402 ,283,270,269 ,85,82,83 }, {1043,1047,1403 ,284,273,272 ,85,82,83 },
		{1404,1048,1044 ,277,276,285 ,83,82,85 }, {1401,288,1421 ,286,287,288 ,86,87,88 },
		{1422,289,1402 ,289,290,291 ,88,87,86 }, {1423,290,1403 ,292,293,294 ,88,87,86 },
		{1404,291,1424 ,295,296,297 ,86,87,88 }, {1377,288,1401 ,298,287,286 ,89,87,86 },
		{1402,289,1378 ,291,290,299 ,86,87,89 }, {1403,290,1379 ,294,293,300 ,86,87,89 },
		{1380,291,1404 ,301,296,295 ,89,87,86 }, {1421,288,1381 ,288,287,302 ,88,87,90 },
		{1382,289,1422 ,303,290,289 ,90,87,88 }, {1383,290,1423 ,304,293,292 ,90,87,88 },
		{1424,291,1384 ,297,296,305 ,88,87,90 }, {1381,288,1361 ,302,287,306 ,90,87,91 },
		{1362,289,1382 ,307,290,303 ,91,87,90 }, {1363,290,1383 ,308,293,304 ,91,87,90 },
		{1384,291,1364 ,305,296,309 ,90,87,91 }, {1357,288,1365 ,310,287,311 ,92,87,93 },
		{1366,289,1358 ,312,290,313 ,93,87,92 }, {1367,290,1359 ,314,293,315 ,93,87,92 },
		{1360,291,1368 ,316,296,317 ,92,87,93 }, {1361,288,1357 ,306,287,310 ,91,87,92 },
		{1358,289,1362 ,313,290,307 ,92,87,91 }, {1359,290,1363 ,315,293,308 ,92,87,91 },
		{1364,291,1360 ,309,296,316 ,91,87,92 }, {1365,288,1369 ,311,287,318 ,93,87,94 },
		{1370,289,1366 ,319,290,312 ,94,87,93 }, {1371,290,1367 ,320,293,314 ,94,87,93 },
		{1368,291,1372 ,317,296,321 ,93,87,94 }, {1369,288,1377 ,318,287,298 ,94,87,89 },
		{1378,289,1370 ,299,290,319 ,89,87,94 }, {1379,290,1371 ,300,293,320 ,89,87,94 },
		{1372,291,1380 ,321,296,301 ,94,87,89 }, {1377,969,1373 ,298,322,323 ,89,95,96 },
		{1374,970,1378 ,324,325,299 ,96,95,89 }, {1375,971,1379 ,326,327,300 ,96,95,89 },
		{1380,972,1376 ,301,328,329 ,89,95,96 }, {1377,933,969 ,298,330,322 ,89,97,95 },
		{970,934,1378 ,325,331,299 ,95,97,89 }, {971,935,1379 ,327,332,300 ,95,97,89 },
		{1380,936,972 ,301,333,328 ,89,97,95 }, {1373,969,981 ,323,322,334 ,96,95,98 },
		{982,970,1374 ,335,325,324 ,98,95,96 }, {983,971,1375 ,336,327,326 ,98,95,96 },
		{1376,972,984 ,329,328,337 ,96,95,98 }, {1401,1397,1377 ,286,338,298 ,86,99,89 },
		{1378,1398,1402 ,299,339,291 ,89,99,86 }, {1379,1399,1403 ,300,340,294 ,89,99,86 },
		{1404,1400,1380 ,295,341,301 ,86,99,89 }, {1349,519,515 ,342,342,342 ,100,101,102 },
		{516,520,1350 ,342,342,342 ,102,101,100 }, {517,521,1351 ,342,342,342 ,102,101,100 },
		{1352,522,518 ,342,342,342 ,100,101,102 }, {1393,519,1349 ,342,342,342 ,103,101,100 },
		{1350,520,1394 ,342,342,342 ,100,101,103 }, {1351,521,1395 ,342,342,342 ,100,101,103 },
		{1396,522,1352 ,342,342,342 ,103,101,100 }, {359,355,351 ,343,344,345 ,104,105,106 },
		{352,356,360 ,346,347,348 ,106,105,104 }, {353,357,361 ,349,350,351 ,106,105,104 },
		{362,358,354 ,352,353,354 ,104,105,106 }, {663,355,359 ,355,344,343 ,107,105,104 },
		{360,356,664 ,348,347,356 ,104,105,107 }, {361,357,665 ,351,350,357 ,104,105,107 },
		{666,358,362 ,358,353,352 ,107,105,104 }, {663,359,343 ,355,343,359 ,108,109,110 },
		{344,360,664 ,360,348,356 ,110,109,108 }, {345,361,665 ,361,351,357 ,110,109,108 },
		{666,362,346 ,358,352,362 ,108,109,110 }, {663,343,339 ,355,359,363 ,108,110,111 },
		{340,344,664 ,364,360,356 ,111,110,108 }, {341,345,665 ,365,361,357 ,111,110,108 },
		{666,346,342 ,358,362,366 ,108,110,111 }, {635,339,343 ,367,368,369 ,112,111,110 },
		{344,340,636 ,370,368,371 ,110,111,112 }, {345,341,637 ,372,373,374 ,110,111,112 },
		{638,342,346 ,375,373,376 ,112,111,110 }, {643,635,343 ,377,367,369 ,113,112,110 },
		{344,636,644 ,370,371,378 ,110,112,113 }, {345,637,645 ,372,374,379 ,110,112,113 },
		{646,638,346 ,380,375,376 ,113,112,110 }, {1437,317,1417 ,381,382,383 ,114,115,116 },
		{1418,317,1438 ,384,382,385 ,116,115,114 }, {1419,318,1439 ,386,387,388 ,116,115,114 },
		{1440,318,1420 ,389,387,390 ,114,115,116 }, {1437,311,317 ,381,391,382 ,114,117,115 },
		{317,311,1438 ,382,391,385 ,115,117,114 }, {318,312,1439 ,387,392,388 ,115,117,114 },
		{1440,312,318 ,389,392,387 ,114,117,115 }, {1437,1425,311 ,393,393,393 ,118,119,120 },
		{311,1426,1438 ,393,393,393 ,120,119,118 }, {312,1427,1439 ,393,393,393 ,120,119,118 },
		{1440,1428,312 ,393,393,393 ,118,119,120 }, {1171,1165,1167 ,394,395,396 ,121,122,123 },
		{1168,1166,1172 ,397,398,399 ,123,122,121 }, {1169,1165,1171 ,400,395,394 ,123,122,121 },
		{1172,1166,1170 ,399,398,401 ,121,122,123 }, {1167,1165,813 ,396,395,402 ,123,122,124 },
		{814,1166,1168 ,403,398,397 ,124,122,123 }, {815,1165,1169 ,404,395,400 ,124,122,123 },
		{1170,1166,816 ,401,398,405 ,123,122,124 }, {1393,1385,511 ,342,342,342 ,103,125,126 },
		{512,1386,1394 ,342,342,342 ,126,125,103 }, {513,1387,1395 ,342,342,342 ,126,125,103 },
		{1396,1388,514 ,342,342,342 ,103,125,126 }, {1385,551,511 ,406,407,408 ,125,127,126 },
		{512,552,1386 ,409,410,411 ,126,127,125 }, {513,553,1387 ,412,413,414 ,126,127,125 },
		{1388,554,514 ,415,416,417 ,125,127,126 }, {559,539,547 ,418,419,420 ,128,129,130 },
		{548,540,560 ,421,422,423 ,130,129,128 }, {549,541,561 ,424,425,426 ,130,129,128 },
		{562,542,550 ,427,428,429 ,128,129,130 }, {559,543,539 ,418,430,419 ,128,131,129 },
		{540,544,560 ,422,431,423 ,129,131,128 }, {541,545,561 ,425,432,426 ,129,131,128 },
		{562,546,542 ,427,433,428 ,128,131,129 }, {543,531,539 ,430,434,419 ,131,132,129 },
		{540,532,544 ,422,435,431 ,129,132,131 }, {541,533,545 ,425,436,432 ,129,132,131 },
		{546,534,542 ,433,437,428 ,131,132,129 }, {543,535,531 ,430,438,434 ,131,133,132 },
		{532,536,544 ,435,439,431 ,132,133,131 }, {533,537,545 ,436,440,432 ,132,133,131 },
		{546,538,534 ,433,441,437 ,131,133,132 }, {1369,877,901 ,318,442,443 ,94,134,135 },
		{902,878,1370 ,444,445,319 ,135,134,94 }, {903,879,1371 ,446,447,320 ,135,134,94 },
		{1372,880,904 ,321,448,449 ,94,134,135 }, {1369,901,1365 ,318,443,311 ,94,135,93 },
		{1366,902,1370 ,312,444,319 ,93,135,94 }, {1367,903,1371 ,314,446,320 ,93,135,94 },
		{1372,904,1368 ,321,449,317 ,94,135,93 }, {611,603,575 ,450,451,452 ,136,137,138 },
		{576,604,612 ,453,454,455 ,138,137,136 }, {577,605,613 ,456,457,458 ,138,137,136 },
		{614,606,578 ,459,460,461 ,136,137,138 }, {603,579,575 ,451,462,452 ,137,139,138 },
		{576,580,604 ,453,463,454 ,138,139,137 }, {577,581,605 ,456,464,457 ,138,139,137 },
		{606,582,578 ,460,465,461 ,137,139,138 }, {631,603,611 ,466,451,450 ,140,137,136 },
		{612,604,632 ,455,454,467 ,136,137,140 }, {613,605,633 ,458,457,468 ,136,137,140 },
		{634,606,614 ,469,460,459 ,140,137,136 }, {631,619,603 ,470,471,472 ,140,141,137 },
		{604,620,632 ,473,474,475 ,137,141,140 }, {605,621,633 ,476,477,478 ,137,141,140 },
		{634,622,606 ,479,480,481 ,140,141,137 }, {1381,623,611 ,482,482,450 ,142,143,136 },
		{612,624,1382 ,455,483,483 ,136,143,142 }, {613,625,1383 ,458,484,484 ,136,143,142 },
		{1384,626,614 ,485,485,459 ,142,143,136 }, {631,611,623 ,470,486,487 ,140,136,143 },
		{624,612,632 ,488,489,475 ,143,136,140 }, {625,613,633 ,490,491,478 ,143,136,140 },
		{634,614,626 ,479,492,493 ,140,136,143 }, {611,575,583 ,450,452,494 ,136,138,144 },
		{584,576,612 ,495,453,455 ,144,138,136 }, {585,577,613 ,496,456,458 ,144,138,136 },
		{614,578,586 ,459,461,497 ,136,138,144 }, {583,575,571 ,494,452,498 ,144,138,145 },
		{572,576,584 ,499,453,495 ,145,138,144 }, {573,577,585 ,500,456,496 ,145,138,144 },
		{586,578,574 ,497,461,501 ,144,138,145 }, {1381,611,583 ,302,450,494 ,142,136,144 },
		{584,612,1382 ,495,455,303 ,144,136,142 }, {585,613,1383 ,496,458,304 ,144,136,142 },
		{1384,614,586 ,305,459,497 ,142,136,144 }, {579,567,575 ,462,502,452 ,139,146,138 },
		{576,568,580 ,453,503,463 ,138,146,139 }, {577,569,581 ,456,504,464 ,138,146,139 },
		{582,570,578 ,465,505,461 ,139,146,138 }, {363,359,351 ,506,343,507 ,147,104,106 },
		{352,360,364 ,508,348,509 ,106,104,147 }, {353,361,365 ,510,351,511 ,106,104,147 },
		{366,362,354 ,512,352,513 ,147,104,106 }, {1141,1121,1125 ,514,515,516 ,148,149,150 },
		{1126,1122,1142 ,517,518,519 ,150,149,148 }, {1127,1123,1143 ,520,521,522 ,150,149,148 },
		{1144,1124,1128 ,523,524,525 ,148,149,150 }, {1145,1141,1125 ,526,514,527 ,151,148,150 },
		{1126,1142,1146 ,528,519,529 ,150,148,151 }, {1127,1143,1147 ,530,522,531 ,150,148,151 },
		{1148,1144,1128 ,532,523,533 ,151,148,150 }, {1197,1145,1125 ,534,526,516 ,152,151,150 },
		{1126,1146,1198 ,517,529,535 ,150,151,152 }, {1127,1147,1199 ,520,531,536 ,150,151,152 },
		{1200,1148,1128 ,537,532,525 ,152,151,150 }, {1133,1121,1141 ,538,515,514 ,153,149,148 },
		{1142,1122,1134 ,519,518,539 ,148,149,153 }, {1143,1123,1135 ,522,521,540 ,148,149,153 },
		{1136,1124,1144 ,541,524,523 ,153,149,148 }, {1133,1129,1121 ,538,542,515 ,154,155,156 },
		{1122,1130,1134 ,518,543,539 ,156,155,154 }, {1123,1131,1135 ,521,544,540 ,156,155,154 },
		{1136,1132,1124 ,541,545,524 ,154,155,156 }, {1353,1109,623 ,546,547,548 ,157,158,143 },
		{624,1110,1354 ,549,550,551 ,143,158,157 }, {625,1111,1355 ,552,553,554 ,143,158,157 },
		{1356,1112,626 ,555,556,557 ,157,158,143 }, {1353,1105,1109 ,546,558,547 ,157,159,158 },
		{1110,1106,1354 ,550,559,551 ,158,159,157 }, {1111,1107,1355 ,553,560,554 ,158,159,157 },
		{1356,1108,1112 ,555,561,556 ,157,159,158 }, {1113,1109,1105 ,562,547,558 ,160,158,159 },
		{1106,1110,1114 ,559,550,563 ,159,158,160 }, {1107,1111,1115 ,560,553,564 ,159,158,160 },
		{1116,1112,1108 ,565,556,561 ,160,158,159 }, {1201,1113,1105 ,566,567,568 ,161,160,159 },
		{1106,1114,1202 ,569,570,571 ,159,160,161 }, {1107,1115,1203 ,572,573,574 ,159,160,161 },
		{1204,1116,1108 ,575,576,577 ,161,160,159 }, {1401,1041,1397 ,268,282,578 ,83,85,162 },
		{1398,1042,1402 ,579,283,269 ,162,85,83 }, {1399,1043,1403 ,580,284,272 ,162,85,83 },
		{1404,1044,1400 ,277,285,581 ,83,85,162 }, {1269,1221,1265 ,342,342,342 ,163,164,165 },
		{1269,1217,1221 ,342,342,342 ,163,166,164 }, {1222,1270,1266 ,342,342,342 ,164,163,165 },
		{1222,1218,1270 ,342,342,342 ,164,166,163 }, {1223,1271,1267 ,342,342,342 ,164,163,165 },
		{1223,1219,1271 ,342,342,342 ,164,166,163 }, {1272,1224,1268 ,342,342,342 ,163,164,165 },
		{1272,1220,1224 ,342,342,342 ,163,166,164 }, {1297,867,329 ,582,342,583 ,167,168,169 },
		{329,867,1298 ,583,342,584 ,169,168,167 }, {330,868,1299 ,585,342,586 ,169,168,167 },
		{1300,868,330 ,587,342,585 ,167,168,169 }, {1297,861,867 ,582,342,342 ,167,170,168 },
		{867,862,1298 ,342,342,584 ,168,170,167 }, {868,863,1299 ,342,342,586 ,168,170,167 },
		{1300,864,868 ,587,342,342 ,167,170,168 }, {1297,1293,861 ,582,588,342 ,167,171,170 },
		{862,1294,1298 ,342,589,584 ,170,171,167 }, {863,1295,1299 ,342,590,586 ,170,171,167 },
		{1300,1296,864 ,587,591,342 ,167,171,170 }, {1213,1209,849 ,592,342,342 ,172,173,174 },
		{850,1210,1214 ,342,342,593 ,174,173,172 }, {851,1211,1215 ,342,342,594 ,174,173,172 },
		{1216,1212,852 ,595,342,342 ,172,173,174 }, {849,821,825 ,596,597,598 ,174,175,176 },
		{826,822,850 ,599,600,601 ,176,175,174 }, {827,823,851 ,602,603,604 ,176,175,174 },
		{852,824,828 ,605,606,607 ,174,175,176 }, {825,821,809 ,598,597,608 ,176,175,177 },
		{810,822,826 ,609,600,599 ,177,175,176 }, {811,823,827 ,610,603,602 ,177,175,176 },
		{828,824,812 ,607,606,611 ,176,175,177 }, {821,817,809 ,597,612,608 ,175,178,177 },
		{810,818,822 ,609,613,600 ,177,178,175 }, {811,819,823 ,610,614,603 ,177,178,175 },
		{824,820,812 ,606,615,611 ,175,178,177 }, {817,805,809 ,612,616,608 ,178,179,177 },
		{810,806,818 ,609,617,613 ,177,179,178 }, {811,807,819 ,610,618,614 ,177,179,178 },
		{820,808,812 ,615,619,611 ,178,179,177 }, {817,813,805 ,612,620,616 ,178,124,179 },
		{806,814,818 ,617,621,613 ,179,124,178 }, {807,815,819 ,618,622,614 ,179,124,178 },
		{820,816,808 ,615,623,619 ,178,124,179 }, {813,803,805 ,620,624,616 ,124,180,179 },
		{806,804,814 ,617,625,621 ,179,180,124 }, {807,803,815 ,618,624,622 ,179,180,124 },
		{816,804,808 ,623,625,619 ,124,180,179 }, {805,803,781 ,616,624,626 ,179,180,181 },
		{782,804,806 ,627,625,617 ,181,180,179 }, {783,803,807 ,628,624,618 ,181,180,179 },
		{808,804,784 ,619,625,629 ,179,180,181 }, {803,771,781 ,624,253,626 ,180,182,181 },
		{782,772,804 ,627,630,625 ,181,182,180 }, {783,771,803 ,628,253,624 ,181,182,180 },
		{804,772,784 ,625,630,629 ,180,182,181 }, {1209,1189,849 ,342,342,342 ,173,183,174 },
		{850,1190,1210 ,342,342,342 ,174,183,173 }, {851,1191,1211 ,342,342,342 ,174,183,173 },
		{1212,1192,852 ,342,342,342 ,173,183,174 }, {1189,821,849 ,342,342,342 ,183,175,174 },
		{850,822,1190 ,342,342,342 ,174,175,183 }, {851,823,1191 ,342,342,342 ,174,175,183 },
		{1192,824,852 ,342,342,342 ,183,175,174 }, {1189,817,821 ,342,342,342 ,183,178,175 },
		{822,818,1190 ,342,342,342 ,175,178,183 }, {823,819,1191 ,342,342,342 ,175,178,183 },
		{1192,820,824 ,342,342,342 ,183,178,175 }, {1189,1167,817 ,342,396,342 ,183,123,178 },
		{818,1168,1190 ,342,397,342 ,178,123,183 }, {819,1169,1191 ,342,400,342 ,178,123,183 },
		{1192,1170,820 ,342,401,342 ,183,123,178 }, {1167,813,817 ,396,402,342 ,123,124,178 },
		{818,814,1168 ,342,403,397 ,178,124,123 }, {819,815,1169 ,342,404,400 ,178,124,123 },
		{1170,816,820 ,401,405,342 ,123,124,178 }, {1165,803,813 ,631,624,620 ,122,180,124 },
		{814,804,1166 ,621,625,632 ,124,180,122 }, {815,803,1165 ,622,624,631 ,124,180,122 },
		{1166,804,816 ,632,625,623 ,122,180,124 }, {1213,1205,1209 ,592,633,342 ,172,184,173 },
		{1210,1206,1214 ,342,634,593 ,173,184,172 }, {1211,1207,1215 ,342,635,594 ,173,184,172 },
		{1216,1208,1212 ,595,636,342 ,172,184,173 }, {849,825,845 ,596,598,637 ,174,176,185 },
		{846,826,850 ,638,599,601 ,185,176,174 }, {847,827,851 ,639,602,604 ,185,176,174 },
		{852,828,848 ,605,607,640 ,174,176,185 }, {845,825,829 ,637,598,641 ,185,176,186 },
		{830,826,846 ,642,599,638 ,186,176,185 }, {831,827,847 ,643,602,639 ,186,176,185 },
		{848,828,832 ,640,607,644 ,185,176,186 }, {1309,845,829 ,645,637,641 ,187,185,186 },
		{830,846,1310 ,642,638,646 ,186,185,187 }, {831,847,1311 ,643,639,647 ,186,185,187 },
		{1312,848,832 ,648,640,644 ,187,185,186 }, {1309,829,833 ,645,641,649 ,187,186,188 },
		{834,830,1310 ,650,642,646 ,188,186,187 }, {835,831,1311 ,651,643,647 ,188,186,187 },
		{1312,832,836 ,648,644,652 ,187,186,188 }, {1309,833,853 ,645,649,653 ,187,188,189 },
		{854,834,1310 ,654,650,646 ,189,188,187 }, {855,835,1311 ,655,651,647 ,189,188,187 },
		{1312,836,856 ,648,652,656 ,187,188,189 }, {857,853,833 ,657,653,649 ,190,189,188 },
		{834,854,858 ,650,654,658 ,188,189,190 }, {835,855,859 ,651,655,659 ,188,189,190 },
		{860,856,836 ,660,656,652 ,190,189,188 }, {857,833,837 ,657,649,661 ,190,188,191 },
		{838,834,858 ,662,650,658 ,191,188,190 }, {839,835,859 ,663,651,659 ,191,188,190 },
		{860,836,840 ,660,652,664 ,190,188,191 }, {861,857,837 ,665,657,661 ,170,190,191 },
		{838,858,862 ,662,658,666 ,191,190,170 }, {839,859,863 ,663,659,667 ,191,190,170 },
		{864,860,840 ,668,660,664 ,170,190,191 }, {861,837,841 ,665,661,669 ,170,191,192 },
		{842,838,862 ,670,662,666 ,192,191,170 }, {843,839,863 ,671,663,667 ,192,191,170 },
		{864,840,844 ,668,664,672 ,170,191,192 }, {867,861,841 ,673,665,669 ,168,170,192 },
		{842,862,867 ,670,666,673 ,192,170,168 }, {843,863,868 ,671,667,674 ,192,170,168 },
		{868,864,844 ,674,668,672 ,168,170,192 }, {867,841,865 ,673,669,675 ,168,192,193 },
		{865,842,867 ,675,670,673 ,193,192,168 }, {866,843,868 ,676,671,674 ,193,192,168 },
		{868,844,866 ,674,672,676 ,168,192,193 }, {1305,715,845 ,2,677,2 ,194,195,196 },
		{846,716,1306 ,2,678,2 ,196,195,194 }, {847,717,1307 ,0,679,0 ,196,195,194 },
		{1308,718,848 ,0,680,0 ,194,195,196 }, {1309,1305,845 ,342,342,342 ,187,197,185 },
		{846,1306,1310 ,342,342,342 ,185,197,187 }, {847,1307,1311 ,342,342,342 ,185,197,187 },
		{1312,1308,848 ,342,342,342 ,187,197,185 }, {1173,292,1171 ,681,682,394 ,198,199,121 },
		{1172,293,1174 ,399,683,684 ,121,199,198 }, {1171,292,1175 ,394,682,685 ,121,199,198 },
		{1176,293,1172 ,686,683,399 ,198,199,121 }, {1093,1063,296 ,687,688,689 ,200,201,202 },
		{1093,1065,1063 ,687,690,688 ,200,203,201 }, {1064,1094,297 ,691,692,693 ,201,200,202 },
		{1064,1066,1094 ,691,694,692 ,201,203,200 }, {1063,1095,296 ,688,695,689 ,201,200,202 },
		{1063,1067,1095 ,688,696,695 ,201,203,200 }, {1096,1064,297 ,697,691,693 ,200,201,202 },
		{1096,1068,1064 ,697,698,691 ,200,203,201 }, {1173,294,292 ,681,699,682 ,198,204,199 },
		{1173,1089,294 ,681,700,699 ,198,205,204 }, {295,1174,293 ,701,684,683 ,204,198,199 },
		{295,1090,1174 ,701,702,684 ,204,205,198 }, {294,1175,292 ,699,685,682 ,204,198,199 },
		{294,1091,1175 ,699,703,685 ,204,205,198 }, {1176,295,293 ,686,701,683 ,198,204,199 },
		{1176,1092,295 ,686,704,701 ,198,205,204 }, {1089,296,294 ,705,689,706 ,205,206,204 },
		{1089,1093,296 ,705,687,689 ,205,207,206 }, {297,1090,295 ,693,707,708 ,206,205,204 },
		{297,1094,1090 ,693,692,707 ,206,207,205 }, {296,1091,294 ,689,709,706 ,206,205,204 },
		{296,1095,1091 ,689,695,709 ,206,207,205 }, {1092,297,295 ,710,693,708 ,205,206,204 },
		{1092,1096,297 ,710,697,693 ,205,207,206 }, {1441,299,301 ,711,342,712 ,208,209,210 },
		{1441,1449,299 ,711,713,342 ,208,211,209 }, {300,1442,302 ,342,714,715 ,209,208,210 },
		{300,1450,1442 ,342,716,714 ,209,211,208 }, {299,1443,301 ,342,717,712 ,209,208,210 },
		{299,1451,1443 ,342,718,717 ,209,211,208 }, {1444,300,302 ,719,342,715 ,208,209,210 },
		{1444,1452,300 ,719,720,342 ,208,211,209 }, {1061,921,303 ,721,722,723 ,212,213,214 },
		{304,922,1062 ,724,725,726 ,214,213,212 }, {303,923,1061 ,723,727,721 ,214,213,212 },
		{1062,924,304 ,726,728,724 ,212,213,214 }, {1449,298,299 ,713,342,342 ,211,215,209 },
		{1449,327,298 ,713,729,342 ,211,216,215 }, {298,1450,300 ,342,716,342 ,215,211,209 },
		{298,327,1450 ,342,729,716 ,215,216,211 }, {298,1451,299 ,342,718,342 ,215,211,209 },
		{298,328,1451 ,342,730,718 ,215,216,211 }, {1452,298,300 ,720,342,342 ,211,215,209 },
		{1452,328,298 ,720,730,342 ,211,216,215 }, {937,301,305 ,731,712,732 ,217,210,218 },
		{937,1441,301 ,731,711,712 ,217,208,210 }, {302,938,306 ,715,733,734 ,210,217,218 },
		{302,1442,938 ,715,714,733 ,210,208,217 }, {301,939,305 ,712,735,732 ,210,217,218 },
		{301,1443,939 ,712,717,735 ,210,208,217 }, {940,302,306 ,736,715,734 ,217,210,218 },
		{940,1444,302 ,736,719,715 ,217,208,210 }, {921,309,303 ,722,737,723 ,213,219,214 },
		{921,949,309 ,722,738,737 ,213,220,219 }, {310,922,304 ,739,725,724 ,219,213,214 },
		{310,950,922 ,739,740,725 ,219,220,213 }, {309,923,303 ,737,727,723 ,219,213,214 },
		{309,951,923 ,737,741,727 ,219,220,213 }, {924,310,304 ,728,739,724 ,213,219,214 },
		{924,952,310 ,728,742,739 ,213,220,219 }, {945,305,307 ,743,732,744 ,221,218,222 },
		{945,937,305 ,743,731,732 ,221,217,218 }, {306,946,308 ,734,745,746 ,218,221,222 },
		{306,938,946 ,734,733,745 ,218,217,221 }, {305,947,307 ,732,747,744 ,218,221,222 },
		{305,939,947 ,732,735,747 ,218,217,221 }, {948,306,308 ,748,734,746 ,221,218,222 },
		{948,940,306 ,748,736,734 ,221,217,218 }, {949,307,309 ,738,744,737 ,220,222,219 },
		{949,945,307 ,738,743,744 ,220,221,222 }, {308,950,310 ,746,740,739 ,222,220,219 },
		{308,946,950 ,746,745,740 ,222,221,220 }, {307,951,309 ,744,741,737 ,222,220,219 },
		{307,947,951 ,744,747,741 ,222,221,220 }, {952,308,310 ,742,746,739 ,220,222,219 },
		{952,948,308 ,742,748,746 ,220,221,222 }, {1037,1017,1025 ,749,750,751 ,223,224,225 },
		{1026,1018,1038 ,752,753,754 ,225,224,223 }, {1027,1019,1039 ,755,756,757 ,225,224,223 },
		{1040,1020,1028 ,758,759,760 ,223,224,225 }, {1409,1017,1037 ,256,750,749 ,80,224,223 },
		{1038,1018,1410 ,754,753,257 ,223,224,80 }, {1039,1019,1411 ,757,756,260 ,223,224,80 },
		{1412,1020,1040 ,265,759,758 ,80,224,223 }, {1409,1037,1405 ,256,749,761 ,80,223,226 },
		{1406,1038,1410 ,762,754,257 ,226,223,80 }, {1407,1039,1411 ,763,757,260 ,226,223,80 },
		{1412,1040,1408 ,265,758,764 ,80,223,226 }, {1433,1429,1425 ,393,393,393 ,227,228,119 },
		{1426,1430,1434 ,393,393,393 ,119,228,227 }, {1427,1431,1435 ,393,393,393 ,119,228,227 },
		{1436,1432,1428 ,393,393,393 ,227,228,119 }, {1437,1433,1425 ,393,393,393 ,118,227,119 },
		{1426,1434,1438 ,393,393,393 ,119,227,118 }, {1427,1435,1439 ,393,393,393 ,119,227,118 },
		{1440,1436,1428 ,393,393,393 ,118,227,119 }, {1425,315,311 ,393,393,393 ,119,229,120 },
		{311,315,1426 ,393,393,393 ,120,229,119 }, {312,316,1427 ,393,393,393 ,120,229,119 },
		{1428,316,312 ,393,393,393 ,119,229,120 }, {1425,1421,315 ,393,393,393 ,119,88,229 },
		{315,1422,1426 ,393,393,393 ,229,88,119 }, {316,1423,1427 ,393,393,393 ,229,88,119 },
		{1428,1424,316 ,393,393,393 ,119,88,229 }, {1421,313,315 ,288,2,2 ,88,230,229 },
		{1421,1389,313 ,288,2,2 ,88,231,230 }, {313,1422,315 ,2,289,2 ,230,88,229 },
		{313,1390,1422 ,2,2,289 ,230,231,88 }, {314,1423,316 ,0,292,0 ,230,88,229 },
		{314,1391,1423 ,0,0,292 ,230,231,88 }, {1424,314,316 ,297,0,0 ,88,230,229 },
		{1424,1392,314 ,297,0,0 ,88,231,230 }, {767,845,763 ,765,766,767 ,232,233,234 },
		{767,1213,845 ,765,768,766 ,232,235,233 }, {846,768,764 ,769,770,771 ,233,232,234 },
		{846,1214,768 ,769,772,770 ,233,235,232 }, {847,769,765 ,773,774,767 ,233,232,234 },
		{847,1215,769 ,773,775,774 ,233,235,232 }, {770,848,766 ,776,777,771 ,232,233,234 },
		{770,1216,848 ,776,778,777 ,232,235,233 }, {1213,849,845 ,592,342,342 ,172,174,185 },
		{846,850,1214 ,342,342,593 ,185,174,172 }, {847,851,1215 ,342,342,594 ,185,174,172 },
		{1216,852,848 ,595,342,342 ,172,174,185 }, {1445,323,325 ,779,780,781 ,236,237,238 },
		{1445,1057,323 ,779,782,780 ,236,239,237 }, {323,1446,325 ,780,783,781 ,237,236,238 },
		{323,1058,1446 ,780,784,783 ,237,239,236 }, {324,1447,326 ,785,786,787 ,237,236,238 },
		{324,1059,1447 ,785,788,786 ,237,239,236 }, {1448,324,326 ,789,785,787 ,236,237,238 },
		{1448,1060,324 ,789,790,785 ,236,239,237 }, {1049,317,319 ,791,382,792 ,240,115,241 },
		{1049,1417,317 ,791,383,382 ,240,116,115 }, {317,1050,319 ,382,793,792 ,115,240,241 },
		{317,1418,1050 ,382,384,793 ,115,116,240 }, {318,1051,320 ,387,794,795 ,115,240,241 },
		{318,1419,1051 ,387,386,794 ,115,116,240 }, {1052,318,320 ,796,387,795 ,240,115,241 },
		{1052,1420,318 ,796,390,387 ,240,116,115 }, {1053,319,321 ,797,792,798 ,242,241,243 },
		{1053,1049,319 ,797,791,792 ,242,240,241 }, {319,1054,321 ,792,799,798 ,241,242,243 },
		{319,1050,1054 ,792,793,799 ,241,240,242 }, {320,1055,322 ,795,800,801 ,241,242,243 },
		{320,1051,1055 ,795,794,800 ,241,240,242 }, {1056,320,322 ,802,795,801 ,242,241,243 },
		{1056,1052,320 ,802,796,795 ,242,240,241 }, {1057,321,323 ,782,798,780 ,239,243,237 },
		{1057,1053,321 ,782,797,798 ,239,242,243 }, {321,1058,323 ,798,784,780 ,243,239,237 },
		{321,1054,1058 ,798,799,784 ,243,242,239 }, {322,1059,324 ,801,788,785 ,243,239,237 },
		{322,1055,1059 ,801,800,788 ,243,242,239 }, {1060,322,324 ,790,801,785 ,239,243,237 },
		{1060,1056,322 ,790,802,801 ,239,242,243 }, {1449,325,327 ,713,781,729 ,244,238,245 },
		{1449,1445,325 ,713,779,781 ,244,236,238 }, {325,1450,327 ,781,716,729 ,238,244,245 },
		{325,1446,1450 ,781,783,716 ,238,236,244 }, {326,1451,328 ,787,718,730 ,238,244,245 },
		{326,1447,1451 ,787,786,718 ,238,236,244 }, {1452,326,328 ,720,787,730 ,244,238,245 },
		{1452,1448,326 ,720,789,787 ,244,236,238 }, {1057,1029,1021 ,782,803,804 ,239,246,247 },
		{1022,1030,1058 ,805,806,784 ,247,246,239 }, {1023,1031,1059 ,807,808,788 ,247,246,239 },
		{1060,1032,1024 ,790,809,810 ,239,246,247 }, {1057,1445,1029 ,782,779,803 ,239,236,246 },
		{1030,1446,1058 ,806,783,784 ,246,236,239 }, {1031,1447,1059 ,808,786,788 ,246,236,239 },
		{1060,1448,1032 ,790,789,809 ,239,236,246 }, {1429,1045,1425 ,811,267,278 ,248,82,84 },
		{1429,1405,1045 ,811,761,267 ,248,226,82 }, {1046,1430,1426 ,270,812,279 ,82,248,84 },
		{1046,1406,1430 ,270,762,812 ,82,226,248 }, {1047,1431,1427 ,273,813,280 ,82,248,84 },
		{1047,1407,1431 ,273,763,813 ,82,226,248 }, {1432,1048,1428 ,814,276,281 ,248,82,84 },
		{1432,1408,1048 ,814,764,276 ,248,226,82 }, {1405,1037,1041 ,761,749,282 ,226,223,85 },
		{1042,1038,1406 ,283,754,762 ,85,223,226 }, {1043,1039,1407 ,284,757,763 ,85,223,226 },
		{1408,1040,1044 ,764,758,285 ,226,223,85 }, {1405,1041,1045 ,761,282,267 ,226,85,82 },
		{1046,1042,1406 ,270,283,762 ,82,85,226 }, {1047,1043,1407 ,273,284,763 ,82,85,226 },
		{1408,1044,1048 ,764,285,276 ,226,85,82 }, {1289,1261,853 ,815,342,342 ,249,250,189 },
		{1289,1281,1261 ,815,816,342 ,249,251,250 }, {1262,1290,854 ,342,817,342 ,250,249,189 },
		{1262,1282,1290 ,342,818,817 ,250,251,249 }, {1263,1291,855 ,342,819,342 ,250,249,189 },
		{1263,1283,1291 ,342,820,819 ,250,251,249 }, {1292,1264,856 ,821,342,342 ,249,250,189 },
		{1292,1284,1264 ,821,822,342 ,249,251,250 }, {1273,853,1261 ,342,342,342 ,252,189,250 },
		{1262,854,1274 ,342,342,342 ,250,189,252 }, {1263,855,1275 ,342,342,342 ,250,189,252 },
		{1276,856,1264 ,342,342,342 ,252,189,250 }, {1273,1261,1225 ,342,342,342 ,252,250,253 },
		{1226,1262,1274 ,342,342,342 ,253,250,252 }, {1227,1263,1275 ,342,342,342 ,253,250,252 },
		{1276,1264,1228 ,342,342,342 ,252,250,253 }, {1285,1261,1281 ,823,342,816 ,254,250,251 },
		{1282,1262,1286 ,818,342,824 ,251,250,254 }, {1283,1263,1287 ,820,342,825 ,251,250,254 },
		{1288,1264,1284 ,826,342,822 ,254,250,251 }, {1273,1269,853 ,342,342,342 ,252,163,189 },
		{854,1270,1274 ,342,342,342 ,189,163,252 }, {855,1271,1275 ,342,342,342 ,189,163,252 },
		{1276,1272,856 ,342,342,342 ,252,163,189 }, {1269,1265,853 ,342,342,342 ,163,165,189 },
		{854,1266,1270 ,342,342,342 ,189,165,163 }, {855,1267,1271 ,342,342,342 ,189,165,163 },
		{1272,1268,856 ,342,342,342 ,163,165,189 }, {1313,853,1265 ,342,342,342 ,255,189,165 },
		{1266,854,1314 ,342,342,342 ,165,189,255 }, {1267,855,1315 ,342,342,342 ,165,189,255 },
		{1316,856,1268 ,342,342,342 ,255,189,165 }, {1325,1313,1265 ,342,342,342 ,256,255,165 },
		{1266,1314,1326 ,342,342,342 ,165,255,256 }, {1267,1315,1327 ,342,342,342 ,165,255,256 },
		{1328,1316,1268 ,342,342,342 ,256,255,165 }, {1325,1317,1313 ,342,342,342 ,256,257,255 },
		{1325,1321,1317 ,342,342,342 ,256,258,257 }, {1318,1326,1314 ,342,342,342 ,257,256,255 },
		{1318,1322,1326 ,342,342,342 ,257,258,256 }, {1319,1327,1315 ,342,342,342 ,257,256,255 },
		{1319,1323,1327 ,342,342,342 ,257,258,256 }, {1328,1320,1316 ,342,342,342 ,256,257,255 },
		{1328,1324,1320 ,342,342,342 ,256,258,257 }, {1301,853,857 ,827,342,342 ,259,189,190 },
		{1301,1289,853 ,827,815,342 ,259,249,189 }, {854,1302,858 ,342,828,342 ,189,259,190 },
		{854,1290,1302 ,342,817,828 ,189,249,259 }, {855,1303,859 ,342,829,342 ,189,259,190 },
		{855,1291,1303 ,342,819,829 ,189,249,259 }, {1304,856,860 ,830,342,342 ,259,189,190 },
		{1304,1292,856 ,830,821,342 ,259,249,189 }, {1301,861,1293 ,827,342,588 ,259,170,171 },
		{1301,857,861 ,827,342,342 ,259,190,170 }, {862,1302,1294 ,342,828,589 ,170,259,171 },
		{862,858,1302 ,342,342,828 ,170,190,259 }, {863,1303,1295 ,342,829,590 ,170,259,171 },
		{863,859,1303 ,342,342,829 ,170,190,259 }, {1304,864,1296 ,830,342,591 ,259,170,171 },
		{1304,860,864 ,830,342,342 ,259,190,170 }, {443,329,333 ,831,583,832 ,260,169,261 },
		{443,1297,329 ,831,582,583 ,260,167,169 }, {329,444,333 ,583,833,832 ,169,260,261 },
		{329,1298,444 ,583,584,833 ,169,167,260 }, {330,445,334 ,585,834,835 ,169,260,261 },
		{330,1299,445 ,585,586,834 ,169,167,260 }, {446,330,334 ,836,585,835 ,260,169,261 },
		{446,1300,330 ,836,587,585 ,260,167,169 }, {495,331,335 ,837,838,2 ,262,263,264 },
		{495,439,331 ,837,839,838 ,262,265,263 }, {331,496,335 ,838,840,2 ,263,262,264 },
		{331,440,496 ,838,841,840 ,263,265,262 }, {332,497,336 ,842,843,0 ,263,262,264 },
		{332,441,497 ,842,844,843 ,263,265,262 }, {498,332,336 ,845,842,0 ,262,263,264 },
		{498,442,332 ,845,846,842 ,262,265,263 }, {439,333,331 ,839,847,838 ,265,261,263 },
		{439,443,333 ,839,848,847 ,265,260,261 }, {333,440,331 ,847,841,838 ,261,265,263 },
		{333,444,440 ,847,849,841 ,261,260,265 }, {334,441,332 ,850,844,842 ,261,265,263 },
		{334,445,441 ,850,851,844 ,261,260,265 }, {442,334,332 ,846,850,842 ,265,261,263 },
		{442,446,334 ,846,852,850 ,265,260,261 }, {503,335,337 ,342,342,342 ,266,264,267 },
		{503,495,335 ,342,342,342 ,266,262,264 }, {335,504,337 ,342,342,342 ,264,266,267 },
		{335,496,504 ,342,342,342 ,264,262,266 }, {336,505,338 ,342,342,342 ,264,266,267 },
		{336,497,505 ,342,342,342 ,264,262,266 }, {506,336,338 ,342,342,342 ,266,264,267 },
		{506,498,336 ,342,342,342 ,266,262,264 }, {1229,567,579 ,853,502,462 ,268,146,139 },
		{580,568,1230 ,463,503,854 ,139,146,268 }, {581,569,1231 ,464,504,855 ,139,146,268 },
		{1232,570,582 ,856,505,465 ,268,146,139 }, {1229,571,567 ,853,498,502 ,268,145,146 },
		{568,572,1230 ,503,499,854 ,146,145,268 }, {569,573,1231 ,504,500,855 ,146,145,268 },
		{1232,574,570 ,856,501,505 ,268,145,146 }, {1233,543,559 ,857,858,418 ,269,131,128 },
		{560,544,1234 ,423,859,860 ,128,131,269 }, {561,545,1235 ,426,861,862 ,128,131,269 },
		{1236,546,562 ,863,864,427 ,269,131,128 }, {559,547,555 ,418,420,865 ,128,130,270 },
		{556,548,560 ,866,421,423 ,270,130,128 }, {557,549,561 ,867,424,426 ,270,130,128 },
		{562,550,558 ,427,429,868 ,128,130,270 }, {1385,583,563 ,406,494,869 ,125,144,271 },
		{1385,1381,583 ,406,302,494 ,125,142,144 }, {584,1386,564 ,495,411,870 ,144,125,271 },
		{584,1382,1386 ,495,303,411 ,144,142,125 }, {585,1387,565 ,496,414,871 ,144,125,271 },
		{585,1383,1387 ,496,304,414 ,144,142,125 }, {1388,586,566 ,415,497,872 ,125,144,271 },
		{1388,1384,586 ,415,305,497 ,125,142,144 }, {563,571,559 ,869,498,418 ,271,145,128 },
		{563,583,571 ,869,494,498 ,271,144,145 }, {572,564,560 ,499,870,423 ,145,271,128 },
		{572,584,564 ,499,495,870 ,145,144,271 }, {573,565,561 ,500,871,426 ,145,271,128 },
		{573,585,565 ,500,496,871 ,145,144,271 }, {566,574,562 ,872,501,427 ,271,145,128 },
		{566,586,574 ,872,497,501 ,271,144,145 }, {1233,571,1229 ,857,498,853 ,269,145,268 },
		{1233,559,571 ,857,418,498 ,269,128,145 }, {572,1234,1230 ,499,860,854 ,145,269,268 },
		{572,560,1234 ,499,423,860 ,145,128,269 }, {573,1235,1231 ,500,862,855 ,145,269,268 },
		{573,561,1235 ,500,426,862 ,145,128,269 }, {1236,574,1232 ,863,501,856 ,269,145,268 },
		{1236,562,574 ,863,427,501 ,269,128,145 }, {555,547,551 ,873,420,407 ,270,130,127 },
		{552,548,556 ,410,421,874 ,127,130,270 }, {553,549,557 ,413,424,875 ,127,130,270 },
		{558,550,554 ,876,429,416 ,270,130,127 }, {563,555,551 ,869,873,407 ,271,270,127 },
		{552,556,564 ,410,874,870 ,127,270,271 }, {553,557,565 ,413,875,871 ,127,270,271 },
		{566,558,554 ,872,876,416 ,271,270,127 }, {1385,563,551 ,406,869,407 ,125,271,127 },
		{552,564,1386 ,410,870,411 ,127,271,125 }, {553,565,1387 ,413,871,414 ,127,271,125 },
		{1388,566,554 ,415,872,416 ,125,271,127 }, {1241,527,1233 ,877,878,857 ,272,273,269 },
		{1234,528,1242 ,860,879,880 ,269,273,272 }, {1235,529,1243 ,862,881,882 ,269,273,272 },
		{1244,530,1236 ,883,884,863 ,272,273,269 }, {1233,527,535 ,857,878,885 ,269,273,133 },
		{536,528,1234 ,886,879,860 ,133,273,269 }, {537,529,1235 ,887,881,862 ,133,273,269 },
		{1236,530,538 ,863,884,888 ,269,273,133 }, {1233,535,543 ,857,885,858 ,269,133,131 },
		{544,536,1234 ,859,886,860 ,131,133,269 }, {545,537,1235 ,861,887,862 ,131,133,269 },
		{1236,538,546 ,863,888,864 ,269,133,131 }, {1229,579,587 ,853,462,889 ,268,139,274 },
		{588,580,1230 ,890,463,854 ,274,139,268 }, {589,581,1231 ,891,464,855 ,274,139,268 },
		{1232,582,590 ,856,465,892 ,268,139,274 }, {575,567,571 ,452,502,498 ,138,146,145 },
		{572,568,576 ,499,503,453 ,145,146,138 }, {573,569,577 ,500,504,456 ,145,146,138 },
		{578,570,574 ,461,505,501 ,138,146,145 }, {1213,1157,1149 ,893,893,894 ,172,275,276 },
		{1150,1158,1214 ,895,896,896 ,276,275,172 }, {1151,1159,1215 ,897,898,898 ,276,275,172 },
		{1216,1160,1152 ,899,899,900 ,172,275,276 }, {1213,1149,1205 ,592,901,633 ,172,276,184 },
		{1206,1150,1214 ,634,902,593 ,184,276,172 }, {1207,1151,1215 ,635,903,594 ,184,276,172 },
		{1216,1152,1208 ,595,904,636 ,172,276,184 }, {1309,1313,715 ,905,906,677 ,277,278,195 },
		{716,1314,1310 ,678,907,908 ,195,278,277 }, {717,1315,1311 ,679,909,910 ,195,278,277 },
		{1312,1316,718 ,911,912,680 ,277,278,195 }, {1313,719,715 ,906,913,677 ,278,279,195 },
		{716,720,1314 ,678,913,907 ,195,279,278 }, {717,721,1315 ,679,914,909 ,195,279,278 },
		{1316,722,718 ,912,914,680 ,278,279,195 }, {1305,1309,715 ,915,915,915 ,194,277,195 },
		{716,1310,1306 ,916,916,916 ,195,277,194 }, {717,1311,1307 ,917,917,917 ,195,277,194 },
		{1308,1312,718 ,918,918,918 ,194,277,195 }, {719,1313,1317 ,919,919,919 ,279,278,280 },
		{1318,1314,720 ,920,920,920 ,280,278,279 }, {1319,1315,721 ,921,921,921 ,280,278,279 },
		{722,1316,1320 ,922,922,922 ,279,278,280 }, {747,1161,1265 ,923,924,925 ,281,282,283 },
		{1266,1162,748 ,926,927,928 ,283,282,281 }, {1267,1163,749 ,929,930,931 ,283,282,281 },
		{750,1164,1268 ,932,933,934 ,281,282,283 }, {1161,747,739 ,924,923,935 ,282,281,284 },
		{740,748,1162 ,935,928,927 ,284,281,282 }, {741,749,1163 ,936,931,930 ,284,281,282 },
		{1164,750,742 ,933,932,936 ,282,281,284 }, {739,1321,1161 ,937,938,938 ,284,285,282 },
		{1162,1322,740 ,939,939,940 ,282,285,284 }, {1163,1323,741 ,941,941,942 ,282,285,284 },
		{742,1324,1164 ,943,944,944 ,284,285,282 }, {1321,1325,1161 ,938,945,938 ,285,286,282 },
		{1162,1326,1322 ,939,946,939 ,282,286,285 }, {1163,1327,1323 ,941,945,941 ,282,286,285 },
		{1324,1328,1164 ,944,946,944 ,285,286,282 }, {747,1265,1221 ,630,630,630 ,281,283,287 },
		{1222,1266,748 ,253,253,253 ,287,283,281 }, {1223,1267,749 ,630,630,630 ,287,283,281 },
		{750,1268,1224 ,253,253,253 ,281,283,287 }, {1217,1269,743 ,253,253,253 ,288,289,290 },
		{744,1270,1218 ,630,630,630 ,290,289,288 }, {745,1271,1219 ,253,253,253 ,290,289,288 },
		{1220,1272,746 ,630,630,630 ,288,289,290 }, {743,1269,1273 ,947,948,948 ,290,289,291 },
		{1274,1270,744 ,948,948,947 ,291,289,290 }, {1275,1271,745 ,949,949,950 ,291,289,290 },
		{746,1272,1276 ,950,949,949 ,290,289,291 }, {1273,759,743 ,948,951,947 ,291,292,290 },
		{744,760,1274 ,947,951,948 ,290,292,291 }, {745,761,1275 ,950,952,949 ,290,292,291 },
		{1276,762,746 ,949,952,950 ,291,292,290 }, {759,1273,1225 ,630,630,630 ,292,291,293 },
		{1226,1274,760 ,253,253,253 ,293,291,292 }, {1227,1275,761 ,630,630,630 ,293,291,292 },
		{762,1276,1228 ,253,253,253 ,292,291,293 }, {643,599,639 ,377,953,954 ,113,294,295 },
		{640,600,644 ,954,955,378 ,295,294,113 }, {641,601,645 ,956,957,379 ,295,294,113 },
		{646,602,642 ,380,958,956 ,113,294,295 }, {627,639,599 ,959,954,953 ,296,295,294 },
		{600,640,628 ,955,954,959 ,294,295,296 }, {601,641,629 ,957,956,960 ,294,295,296 },
		{630,642,602 ,960,956,958 ,296,295,294 }, {343,599,643 ,369,953,377 ,110,294,113 },
		{644,600,344 ,378,955,370 ,113,294,110 }, {645,601,345 ,379,957,372 ,113,294,110 },
		{346,602,646 ,376,958,380 ,110,294,113 }, {599,615,627 ,953,959,959 ,294,297,296 },
		{628,616,600 ,959,959,955 ,296,297,294 }, {629,617,601 ,960,960,957 ,296,297,294 },
		{602,618,630 ,958,960,960 ,294,297,296 }, {635,647,667 ,367,961,961 ,112,298,299 },
		{668,648,636 ,961,961,371 ,299,298,112 }, {669,649,637 ,962,962,374 ,299,298,112 },
		{638,650,670 ,375,962,962 ,112,298,299 }, {667,339,635 ,961,368,367 ,299,111,112 },
		{636,340,668 ,371,368,961 ,112,111,299 }, {637,341,669 ,374,373,962 ,112,111,299 },
		{670,342,638 ,962,373,375 ,299,111,112 }, {667,663,339 ,963,355,363 ,299,108,111 },
		{340,664,668 ,364,356,964 ,111,108,299 }, {341,665,669 ,365,357,965 ,111,108,299 },
		{670,666,342 ,966,358,366 ,299,108,111 }, {359,363,343 ,343,506,359 ,109,300,110 },
		{344,364,360 ,360,509,348 ,110,300,109 }, {345,365,361 ,361,511,351 ,110,300,109 },
		{362,366,346 ,352,512,362 ,109,300,110 }, {599,343,363 ,967,359,506 ,294,110,300 },
		{364,344,600 ,509,360,968 ,300,110,294 }, {365,345,601 ,511,361,969 ,300,110,294 },
		{602,346,366 ,970,362,512 ,294,110,300 }, {599,363,595 ,967,506,971 ,294,300,301 },
		{596,364,600 ,972,509,968 ,301,300,294 }, {597,365,601 ,973,511,969 ,301,300,294 },
		{602,366,598 ,970,512,974 ,294,300,301 }, {659,723,675 ,975,976,977 ,302,303,304 },
		{676,724,660 ,976,977,978 ,304,303,302 }, {677,725,661 ,977,976,975 ,304,303,302 },
		{662,726,678 ,978,977,976 ,302,303,304 }, {711,659,707 ,975,975,979 ,305,302,306 },
		{708,660,712 ,980,978,978 ,306,302,305 }, {709,661,713 ,979,975,975 ,306,302,305 },
		{714,662,710 ,978,978,980 ,305,302,306 }, {763,703,651 ,767,981,982 ,234,307,308 },
		{652,704,764 ,983,984,771 ,308,307,234 }, {653,705,765 ,982,981,767 ,308,307,234 },
		{766,706,654 ,771,984,983 ,234,307,308 }, {703,707,655 ,981,979,985 ,307,306,309 },
		{656,708,704 ,986,980,984 ,309,306,307 }, {657,709,705 ,985,979,981 ,309,306,307 },
		{706,710,658 ,984,980,986 ,307,306,309 }, {711,723,659 ,975,976,975 ,305,303,302 },
		{660,724,712 ,978,977,978 ,302,303,305 }, {661,725,713 ,975,976,975 ,302,303,305 },
		{714,726,662 ,978,977,978 ,305,303,302 }, {655,651,703 ,985,982,981 ,309,308,307 },
		{704,652,656 ,984,983,986 ,307,308,309 }, {705,653,657 ,981,982,985 ,307,308,309 },
		{658,654,706 ,986,983,984 ,309,308,307 }, {651,767,763 ,982,765,767 ,308,232,234 },
		{764,768,652 ,771,770,983 ,234,232,308 }, {765,769,653 ,767,774,982 ,234,232,308 },
		{654,770,766 ,983,776,771 ,308,232,234 }, {659,655,707 ,975,985,979 ,302,309,306 },
		{708,656,660 ,980,986,978 ,306,309,302 }, {709,657,661 ,979,985,975 ,306,309,302 },
		{662,658,710 ,978,986,980 ,302,309,306 }, {727,679,675 ,987,978,977 ,310,311,304 },
		{676,680,728 ,976,975,988 ,304,311,310 }, {677,681,729 ,977,978,987 ,304,311,310 },
		{730,682,678 ,988,975,976 ,310,311,304 }, {727,675,723 ,987,977,976 ,310,304,303 },
		{724,676,728 ,977,976,988 ,303,304,310 }, {725,677,729 ,976,977,987 ,303,304,310 },
		{730,678,726 ,988,976,977 ,310,304,303 }, {731,735,687 ,989,990,991 ,312,313,314 },
		{688,736,732 ,992,993,994 ,314,313,312 }, {689,737,733 ,991,990,989 ,314,313,312 },
		{734,738,690 ,994,993,992 ,312,313,314 }, {691,727,731 ,995,987,989 ,315,310,312 },
		{732,728,692 ,994,988,996 ,312,310,315 }, {733,729,693 ,989,987,995 ,312,310,315 },
		{694,730,734 ,996,988,994 ,315,310,312 }, {751,683,735 ,997,998,990 ,316,317,313 },
		{736,684,752 ,993,999,1000 ,313,317,316 }, {737,685,753 ,990,998,1001 ,313,317,316 },
		{754,686,738 ,1002,999,993 ,316,317,313 }, {687,691,731 ,991,995,989 ,314,315,312 },
		{732,692,688 ,994,996,992 ,312,315,314 }, {733,693,689 ,989,995,991 ,312,315,314 },
		{690,694,734 ,992,996,994 ,314,315,312 }, {691,679,727 ,995,978,987 ,315,311,310 },
		{728,680,692 ,988,975,996 ,310,311,315 }, {729,681,693 ,987,978,995 ,310,311,315 },
		{694,682,730 ,996,975,988 ,315,311,310 }, {683,687,735 ,998,991,990 ,317,314,313 },
		{736,688,684 ,993,992,999 ,313,314,317 }, {737,689,685 ,990,991,998 ,313,314,317 },
		{686,690,738 ,999,992,993 ,317,314,313 }, {1261,347,671 ,1003,1004,1005 ,250,318,319 },
		{672,348,1262 ,1006,1007,1008 ,319,318,250 }, {673,349,1263 ,1009,1010,1011 ,319,318,250 },
		{1264,350,674 ,1012,1013,1014 ,250,318,319 }, {1261,671,751 ,1003,1005,997 ,320,321,316 },
		{752,672,1262 ,1000,1006,1008 ,316,321,320 }, {753,673,1263 ,1001,1009,1011 ,316,321,320 },
		{1264,674,754 ,1012,1014,1002 ,320,321,316 }, {683,751,671 ,998,997,1005 ,317,316,321 },
		{672,752,684 ,1006,1000,999 ,321,316,317 }, {673,753,685 ,1009,1001,998 ,321,316,317 },
		{686,754,674 ,999,1002,1014 ,317,316,321 }, {1261,1253,347 ,1003,1015,1004 ,250,322,318 },
		{348,1254,1262 ,1007,1016,1008 ,318,322,250 }, {349,1255,1263 ,1010,1015,1011 ,318,322,250 },
		{1264,1256,350 ,1012,1016,1013 ,250,322,318 }, {347,355,671 ,1017,344,1018 ,318,105,319 },
		{672,356,348 ,1019,347,1020 ,319,105,318 }, {673,357,349 ,1021,350,1022 ,319,105,318 },
		{350,358,674 ,1023,353,1024 ,318,105,319 }, {663,671,355 ,355,1018,344 ,107,319,105 },
		{356,672,664 ,347,1019,356 ,105,319,107 }, {357,673,665 ,350,1021,357 ,105,319,107 },
		{666,674,358 ,358,1024,353 ,107,319,105 }, {1253,1237,355 ,1025,1026,344 ,322,323,105 },
		{356,1238,1254 ,347,1027,1028 ,105,323,322 }, {357,1239,1255 ,350,1029,1030 ,105,323,322 },
		{1256,1240,358 ,1031,1032,353 ,322,323,105 }, {355,347,1253 ,344,1033,1025 ,105,318,322 },
		{1254,348,356 ,1028,1034,347 ,322,318,105 }, {1255,349,357 ,1030,1035,350 ,322,318,105 },
		{358,350,1256 ,353,1036,1031 ,105,318,322 }, {355,1237,351 ,344,1026,345 ,105,323,106 },
		{352,1238,356 ,346,1027,347 ,106,323,105 }, {353,1239,357 ,349,1029,350 ,106,323,105 },
		{358,1240,354 ,353,1032,354 ,105,323,106 }, {1237,591,351 ,1026,1037,345 ,323,324,106 },
		{352,592,1238 ,346,1038,1027 ,106,324,323 }, {353,593,1239 ,349,1039,1029 ,106,324,323 },
		{1240,594,354 ,1032,1040,354 ,323,324,106 }, {351,591,595 ,507,1041,971 ,106,324,325 },
		{596,592,352 ,972,1042,508 ,325,324,106 }, {597,593,353 ,973,1043,510 ,325,324,106 },
		{354,594,598 ,513,1044,974 ,106,324,325 }, {595,363,351 ,971,506,507 ,325,147,106 },
		{352,364,596 ,508,509,972 ,106,147,325 }, {353,365,597 ,510,511,973 ,106,147,325 },
		{598,366,354 ,974,512,513 ,325,147,106 }, {411,487,415 ,1045,1046,1047 ,326,327,328 },
		{416,488,412 ,1048,1049,1050 ,328,327,326 }, {417,489,413 ,1051,1052,1053 ,328,327,326 },
		{414,490,418 ,1054,1055,1056 ,326,327,328 }, {495,499,411 ,837,1057,1045 ,262,329,326 },
		{412,500,496 ,1050,1058,840 ,326,329,262 }, {413,501,497 ,1053,1059,843 ,326,329,262 },
		{498,502,414 ,845,1060,1054 ,262,329,326 }, {499,487,411 ,1057,1046,1045 ,329,327,326 },
		{412,488,500 ,1050,1049,1058 ,326,327,329 }, {413,489,501 ,1053,1052,1059 ,326,327,329 },
		{502,490,414 ,1060,1055,1054 ,329,327,326 }, {411,439,495 ,1045,839,837 ,326,265,262 },
		{496,440,412 ,840,841,1050 ,262,265,326 }, {497,441,413 ,843,844,1053 ,262,265,326 },
		{414,442,498 ,1054,846,845 ,326,265,262 }, {483,415,487 ,1061,1047,1046 ,330,328,327 },
		{488,416,484 ,1049,1048,1062 ,327,328,330 }, {489,417,485 ,1052,1051,1063 ,327,328,330 },
		{486,418,490 ,1064,1056,1055 ,330,328,327 }, {483,431,415 ,1061,1065,1047 ,330,331,328 },
		{416,432,484 ,1048,1066,1062 ,328,331,330 }, {417,433,485 ,1051,1067,1063 ,328,331,330 },
		{486,434,418 ,1064,1068,1056 ,330,331,328 }, {427,483,467 ,1069,1061,1070 ,332,330,333 },
		{468,484,428 ,1071,1062,1072 ,333,330,332 }, {469,485,429 ,1073,1063,1074 ,333,330,332 },
		{430,486,470 ,1075,1064,1076 ,332,330,333 }, {427,431,483 ,1069,1065,1061 ,332,331,330 },
		{484,432,428 ,1062,1066,1072 ,330,331,332 }, {485,433,429 ,1063,1067,1074 ,330,331,332 },
		{430,434,486 ,1075,1068,1064 ,332,331,330 }, {367,451,375 ,1077,1078,1079 ,334,335,336 },
		{376,452,368 ,1080,1081,1082 ,336,335,334 }, {377,453,369 ,1083,1084,1085 ,336,335,334 },
		{370,454,378 ,1086,1087,1088 ,334,335,336 }, {455,459,367 ,1089,1090,1077 ,337,338,334 },
		{368,460,456 ,1082,1091,1092 ,334,338,337 }, {369,461,457 ,1085,1093,1094 ,334,338,337 },
		{458,462,370 ,1095,1096,1086 ,337,338,334 }, {459,451,367 ,1090,1078,1077 ,338,335,334 },
		{368,452,460 ,1082,1081,1091 ,334,335,338 }, {369,453,461 ,1085,1084,1093 ,334,335,338 },
		{462,454,370 ,1096,1087,1086 ,338,335,334 }, {367,395,455 ,1077,1097,1089 ,334,339,337 },
		{456,396,368 ,1092,1098,1082 ,337,339,334 }, {457,397,369 ,1094,1099,1085 ,337,339,334 },
		{370,398,458 ,1086,1100,1095 ,334,339,337 }, {447,375,451 ,1101,1079,1078 ,340,336,335 },
		{452,376,448 ,1081,1080,1102 ,335,336,340 }, {453,377,449 ,1084,1083,1103 ,335,336,340 },
		{450,378,454 ,1104,1088,1087 ,340,336,335 }, {447,387,375 ,1101,1105,1079 ,340,341,336 },
		{376,388,448 ,1080,1106,1102 ,336,341,340 }, {377,389,449 ,1083,1107,1103 ,336,341,340 },
		{450,390,378 ,1104,1108,1088 ,340,341,336 }, {523,447,515 ,1109,1101,1110 ,342,340,102 },
		{516,448,524 ,1111,1102,1112 ,102,340,342 }, {517,449,525 ,1113,1103,1114 ,102,340,342 },
		{526,450,518 ,1115,1104,1116 ,342,340,102 }, {523,387,447 ,1109,1105,1101 ,342,341,340 },
		{448,388,524 ,1102,1106,1112 ,340,341,342 }, {449,389,525 ,1103,1107,1114 ,340,341,342 },
		{526,390,450 ,1115,1108,1104 ,342,341,340 }, {375,379,371 ,1079,1117,1118 ,336,343,344 },
		{372,380,376 ,1119,1120,1080 ,344,343,336 }, {373,381,377 ,1121,1122,1083 ,344,343,336 },
		{378,382,374 ,1088,1123,1124 ,336,343,344 }, {391,1257,1285 ,1125,1126,823 ,345,346,254 },
		{1286,1258,392 ,824,1127,1128 ,254,346,345 }, {1287,1259,393 ,825,1129,1130 ,254,346,345 },
		{394,1260,1288 ,1131,1132,826 ,345,346,254 }, {371,1257,391 ,1133,1126,1125 ,344,346,345 },
		{392,1258,372 ,1128,1127,1134 ,345,346,344 }, {393,1259,373 ,1130,1129,1135 ,345,346,344 },
		{374,1260,394 ,1136,1132,1131 ,344,346,345 }, {1245,1249,379 ,1137,1138,1139 ,347,348,343 },
		{380,1250,1246 ,1140,1141,1142 ,343,348,347 }, {381,1251,1247 ,1143,1144,1145 ,343,348,347 },
		{1248,1252,382 ,1146,1147,1148 ,347,348,343 }, {1257,371,1249 ,1126,1133,1138 ,346,344,348 },
		{1250,372,1258 ,1141,1134,1127 ,348,344,346 }, {1251,373,1259 ,1144,1135,1129 ,348,344,346 },
		{1260,374,1252 ,1132,1136,1147 ,346,344,348 }, {1249,371,379 ,1138,1133,1139 ,348,344,343 },
		{380,372,1250 ,1140,1134,1141 ,343,344,348 }, {381,373,1251 ,1143,1135,1144 ,343,344,348 },
		{1252,374,382 ,1147,1136,1148 ,348,344,343 }, {395,371,391 ,1097,1118,1125 ,339,344,345 },
		{392,372,396 ,1128,1119,1098 ,345,344,339 }, {393,373,397 ,1130,1121,1099 ,345,344,339 },
		{398,374,394 ,1100,1124,1131 ,339,344,345 }, {395,367,371 ,1097,1077,1118 ,339,334,344 },
		{372,368,396 ,1119,1082,1098 ,344,334,339 }, {373,369,397 ,1121,1085,1099 ,344,334,339 },
		{398,370,374 ,1100,1086,1124 ,339,334,344 }, {371,367,375 ,1118,1077,1079 ,344,334,336 },
		{376,368,372 ,1080,1082,1119 ,336,334,344 }, {377,369,373 ,1083,1085,1121 ,336,334,344 },
		{374,370,378 ,1124,1086,1088 ,344,334,336 }, {1241,1245,383 ,877,1137,1149 ,272,347,349 },
		{384,1246,1242 ,1150,1142,880 ,349,347,272 }, {385,1247,1243 ,1151,1145,882 ,349,347,272 },
		{1244,1248,386 ,883,1146,1152 ,272,347,349 }, {379,383,1245 ,1139,1149,1137 ,343,349,347 },
		{1246,384,380 ,1142,1150,1140 ,347,349,343 }, {1247,385,381 ,1145,1151,1143 ,347,349,343 },
		{382,386,1248 ,1148,1152,1146 ,343,349,347 }, {383,527,1241 ,1149,878,877 ,349,273,272 },
		{1242,528,384 ,880,879,1150 ,272,273,349 }, {1243,529,385 ,882,881,1151 ,272,273,349 },
		{386,530,1244 ,1152,884,883 ,349,273,272 }, {527,383,387 ,878,1153,1105 ,273,349,341 },
		{388,384,528 ,1106,1154,879 ,341,349,273 }, {389,385,529 ,1107,1155,881 ,341,349,273 },
		{530,386,390 ,884,1156,1108 ,273,349,341 }, {375,387,379 ,1079,1105,1117 ,336,341,343 },
		{380,388,376 ,1120,1106,1080 ,343,341,336 }, {381,389,377 ,1122,1107,1083 ,343,341,336 },
		{378,390,382 ,1088,1108,1123 ,336,341,343 }, {383,379,387 ,1153,1117,1105 ,349,343,341 },
		{388,380,384 ,1106,1120,1154 ,341,343,349 }, {389,381,385 ,1107,1122,1155 ,341,343,349 },
		{386,382,390 ,1156,1123,1108 ,349,343,341 }, {387,523,527 ,1105,1109,878 ,341,342,273 },
		{528,524,388 ,879,1112,1106 ,273,342,341 }, {529,525,389 ,881,1114,1107 ,273,342,341 },
		{390,526,530 ,1108,1115,884 ,341,342,273 }, {399,395,403 ,1157,1097,1158 ,350,339,351 },
		{404,396,400 ,1159,1098,1157 ,351,339,350 }, {405,397,401 ,1160,1099,1161 ,351,339,350 },
		{402,398,406 ,1161,1100,1162 ,350,339,351 }, {403,395,391 ,1158,1097,1125 ,351,339,345 },
		{392,396,404 ,1128,1098,1159 ,345,339,351 }, {393,397,405 ,1130,1099,1160 ,345,339,351 },
		{406,398,394 ,1162,1100,1131 ,351,339,345 }, {1277,403,391 ,1163,1158,1125 ,352,351,345 },
		{392,404,1278 ,1128,1159,1164 ,345,351,352 }, {393,405,1279 ,1130,1160,1165 ,345,351,352 },
		{1280,406,394 ,1166,1162,1131 ,352,351,345 }, {1277,391,1285 ,1163,1125,823 ,352,345,254 },
		{1286,392,1278 ,824,1128,1164 ,254,345,352 }, {1287,393,1279 ,825,1130,1165 ,254,345,352 },
		{1280,394,1288 ,1166,1131,826 ,352,345,254 }, {399,463,455 ,1157,2,1089 ,350,353,337 },
		{456,464,400 ,1092,2,1157 ,337,353,350 }, {457,465,401 ,1094,0,1161 ,337,353,350 },
		{402,466,458 ,1161,0,1095 ,350,353,337 }, {455,395,399 ,1089,1097,1157 ,337,339,350 },
		{400,396,456 ,1157,1098,1092 ,350,339,337 }, {401,397,457 ,1161,1099,1094 ,350,339,337 },
		{458,398,402 ,1095,1100,1161 ,337,339,350 }, {427,467,463 ,1069,1070,253 ,332,333,353 },
		{464,468,428 ,630,1071,1072 ,353,333,332 }, {465,469,429 ,253,1073,1074 ,353,333,332 },
		{430,470,466 ,1075,1076,630 ,332,333,353 }, {463,399,427 ,253,1167,1069 ,353,350,332 },
		{428,400,464 ,1072,1168,630 ,332,350,353 }, {429,401,465 ,1074,1167,253 ,332,350,353 },
		{466,402,430 ,630,1168,1075 ,353,350,332 }, {427,403,435 ,1069,1169,1170 ,332,351,354 },
		{436,404,428 ,1171,1172,1072 ,354,351,332 }, {437,405,429 ,1173,1174,1074 ,354,351,332 },
		{430,406,438 ,1075,1175,1176 ,332,351,354 }, {427,399,403 ,1069,1167,1169 ,332,350,351 },
		{404,400,428 ,1172,1168,1072 ,351,350,332 }, {405,401,429 ,1174,1167,1074 ,351,350,332 },
		{430,402,406 ,1075,1168,1175 ,332,350,351 }, {1277,1281,435 ,1163,816,1170 ,352,251,354 },
		{436,1282,1278 ,1171,818,1164 ,354,251,352 }, {437,1283,1279 ,1173,820,1165 ,354,251,352 },
		{1280,1284,438 ,1166,822,1176 ,352,251,354 }, {435,403,1277 ,1170,1169,1163 ,354,351,352 },
		{1278,404,436 ,1164,1172,1171 ,352,351,354 }, {1279,405,437 ,1165,1174,1173 ,352,351,354 },
		{438,406,1280 ,1176,1175,1166 ,354,351,352 }, {443,1293,1297 ,831,588,582 ,260,171,167 },
		{1298,1294,444 ,584,589,833 ,167,171,260 }, {1299,1295,445 ,586,590,834 ,167,171,260 },
		{446,1296,1300 ,836,591,587 ,260,171,167 }, {407,1293,443 ,1177,588,831 ,355,171,260 },
		{444,1294,408 ,833,589,1178 ,260,171,355 }, {445,1295,409 ,834,590,1179 ,260,171,355 },
		{410,1296,446 ,1180,591,836 ,355,171,260 }, {1289,1301,419 ,815,827,1181 ,249,259,356 },
		{420,1302,1290 ,1182,828,817 ,356,259,249 }, {421,1303,1291 ,1183,829,819 ,356,259,249 },
		{1292,1304,422 ,821,830,1184 ,249,259,356 }, {1293,407,1301 ,588,1177,827 ,171,355,259 },
		{1302,408,1294 ,828,1178,589 ,259,355,171 }, {1303,409,1295 ,829,1179,590 ,259,355,171 },
		{1296,410,1304 ,591,1180,830 ,171,355,259 }, {1301,407,419 ,827,1177,1181 ,259,355,356 },
		{420,408,1302 ,1182,1178,828 ,356,355,259 }, {421,409,1303 ,1183,1179,829 ,356,355,259 },
		{1304,410,422 ,830,1180,1184 ,259,355,356 }, {439,407,443 ,839,1185,848 ,265,355,260 },
		{444,408,440 ,849,1186,841 ,260,355,265 }, {445,409,441 ,851,1187,844 ,260,355,265 },
		{442,410,446 ,846,1188,852 ,265,355,260 }, {439,411,407 ,839,1045,1185 ,265,326,355 },
		{408,412,440 ,1186,1050,841 ,355,326,265 }, {409,413,441 ,1187,1053,844 ,355,326,265 },
		{442,414,410 ,846,1054,1188 ,265,326,355 }, {411,419,407 ,1045,1189,1185 ,326,356,355 },
		{408,420,412 ,1186,1190,1050 ,355,356,326 }, {409,421,413 ,1187,1191,1053 ,355,356,326 },
		{414,422,410 ,1054,1192,1188 ,326,356,355 }, {1281,1289,423 ,816,815,1193 ,251,249,357 },
		{424,1290,1282 ,1194,817,818 ,357,249,251 }, {425,1291,1283 ,1195,819,820 ,357,249,251 },
		{1284,1292,426 ,822,821,1196 ,251,249,357 }, {423,1289,419 ,1193,815,1181 ,357,249,356 },
		{420,1290,424 ,1182,817,1194 ,356,249,357 }, {421,1291,425 ,1183,819,1195 ,356,249,357 },
		{426,1292,422 ,1196,821,1184 ,357,249,356 }, {423,435,1281 ,1193,1170,816 ,357,354,251 },
		{1282,436,424 ,818,1171,1194 ,251,354,357 }, {1283,437,425 ,820,1173,1195 ,251,354,357 },
		{426,438,1284 ,1196,1176,822 ,357,354,251 }, {411,415,419 ,1045,1047,1189 ,326,328,356 },
		{420,416,412 ,1190,1048,1050 ,356,328,326 }, {421,417,413 ,1191,1051,1053 ,356,328,326 },
		{414,418,422 ,1054,1056,1192 ,326,328,356 }, {431,423,415 ,1065,1197,1047 ,331,357,328 },
		{416,424,432 ,1048,1198,1066 ,328,357,331 }, {417,425,433 ,1051,1199,1067 ,328,357,331 },
		{434,426,418 ,1068,1200,1056 ,331,357,328 }, {419,415,423 ,1189,1047,1197 ,356,328,357 },
		{424,416,420 ,1198,1048,1190 ,357,328,356 }, {425,417,421 ,1199,1051,1191 ,357,328,356 },
		{422,418,426 ,1192,1056,1200 ,356,328,357 }, {423,431,435 ,1197,1065,1170 ,357,331,354 },
		{436,432,424 ,1171,1066,1198 ,354,331,357 }, {437,433,425 ,1173,1067,1199 ,354,331,357 },
		{426,434,438 ,1200,1068,1176 ,357,331,354 }, {435,431,427 ,1170,1065,1069 ,354,331,332 },
		{428,432,436 ,1072,1066,1171 ,332,331,354 }, {429,433,437 ,1074,1067,1173 ,332,331,354 },
		{438,434,430 ,1176,1068,1075 ,354,331,332 }, {511,507,1393 ,342,342,342 ,126,358,103 },
		{1394,508,512 ,342,342,342 ,103,358,126 }, {1395,509,513 ,342,342,342 ,103,358,126 },
		{514,510,1396 ,342,342,342 ,126,358,103 }, {519,1393,507 ,342,342,342 ,101,103,358 },
		{508,1394,520 ,342,342,342 ,358,103,101 }, {509,1395,521 ,342,342,342 ,358,103,101 },
		{522,1396,510 ,342,342,342 ,101,103,358 }, {1341,451,1333 ,342,342,342 ,359,335,360 },
		{1334,452,1342 ,342,342,342 ,360,335,359 }, {1335,453,1343 ,342,342,342 ,360,335,359 },
		{1344,454,1336 ,342,342,342 ,359,335,360 }, {515,1345,1349 ,342,342,342 ,102,361,100 },
		{1350,1346,516 ,342,342,342 ,100,361,102 }, {1351,1347,517 ,342,342,342 ,100,361,102 },
		{518,1348,1352 ,342,342,342 ,102,361,100 }, {447,1345,515 ,342,342,342 ,340,361,102 },
		{516,1346,448 ,342,342,342 ,102,361,340 }, {517,1347,449 ,342,342,342 ,102,361,340 },
		{450,1348,518 ,342,342,342 ,340,361,102 }, {447,1341,1345 ,342,342,342 ,340,359,361 },
		{1346,1342,448 ,342,342,342 ,361,359,340 }, {1347,1343,449 ,342,342,342 ,361,359,340 },
		{450,1344,1348 ,342,342,342 ,340,359,361 }, {447,451,1341 ,342,342,342 ,340,335,359 },
		{1342,452,448 ,342,342,342 ,359,335,340 }, {1343,453,449 ,342,342,342 ,359,335,340 },
		{450,454,1344 ,342,342,342 ,340,335,359 }, {1329,1337,463 ,342,342,342 ,362,363,353 },
		{464,1338,1330 ,342,342,342 ,353,363,362 }, {465,1339,1331 ,342,342,342 ,353,363,362 },
		{1332,1340,466 ,342,342,342 ,362,363,353 }, {1337,1333,459 ,342,342,342 ,363,360,338 },
		{460,1334,1338 ,342,342,342 ,338,360,363 }, {461,1335,1339 ,342,342,342 ,338,360,363 },
		{1340,1336,462 ,342,342,342 ,363,360,338 }, {471,1329,463 ,342,342,342 ,364,362,353 },
		{464,1330,472 ,342,342,342 ,353,362,364 }, {465,1331,473 ,342,342,342 ,353,362,364 },
		{474,1332,466 ,342,342,342 ,364,362,353 }, {1337,455,463 ,342,342,342 ,363,337,353 },
		{464,456,1338 ,342,342,342 ,353,337,363 }, {465,457,1339 ,342,342,342 ,353,337,363 },
		{1340,458,466 ,342,342,342 ,363,337,353 }, {1333,451,459 ,342,342,342 ,360,335,338 },
		{460,452,1334 ,342,342,342 ,338,335,360 }, {461,453,1335 ,342,342,342 ,338,335,360 },
		{1336,454,462 ,342,342,342 ,360,335,338 }, {1337,459,455 ,342,342,342 ,363,338,337 },
		{456,460,1338 ,342,342,342 ,337,338,363 }, {457,461,1339 ,342,342,342 ,337,338,363 },
		{1340,462,458 ,342,342,342 ,363,338,337 }, {475,467,483 ,342,342,342 ,365,333,330 },
		{484,468,476 ,342,342,342 ,330,333,365 }, {485,469,477 ,342,342,342 ,330,333,365 },
		{478,470,486 ,342,342,342 ,365,333,330 }, {467,471,463 ,342,342,342 ,333,364,353 },
		{464,472,468 ,342,342,342 ,353,364,333 }, {465,473,469 ,342,342,342 ,353,364,333 },
		{470,474,466 ,342,342,342 ,333,364,353 }, {475,471,467 ,342,342,342 ,365,364,333 },
		{468,472,476 ,342,342,342 ,333,364,365 }, {469,473,477 ,342,342,342 ,333,364,365 },
		{478,474,470 ,342,342,342 ,365,364,333 }, {491,479,487 ,342,342,342 ,366,367,327 },
		{488,480,492 ,342,342,342 ,327,367,366 }, {489,481,493 ,342,342,342 ,327,367,366 },
		{494,482,490 ,342,342,342 ,366,367,327 }, {479,483,487 ,342,342,342 ,367,330,327 },
		{488,484,480 ,342,342,342 ,327,330,367 }, {489,485,481 ,342,342,342 ,327,330,367 },
		{482,486,490 ,342,342,342 ,367,330,327 }, {483,479,475 ,342,342,342 ,330,367,365 },
		{476,480,484 ,342,342,342 ,365,367,330 }, {477,481,485 ,342,342,342 ,365,367,330 },
		{486,482,478 ,342,342,342 ,330,367,365 }, {499,491,487 ,342,342,342 ,329,366,327 },
		{488,492,500 ,342,342,342 ,327,366,329 }, {489,493,501 ,342,342,342 ,327,366,329 },
		{502,494,490 ,342,342,342 ,329,366,327 }, {499,503,491 ,342,342,342 ,329,266,366 },
		{492,504,500 ,342,342,342 ,366,266,329 }, {493,505,501 ,342,342,342 ,366,266,329 },
		{502,506,494 ,342,342,342 ,329,266,366 }, {499,495,503 ,342,342,342 ,329,262,266 },
		{504,496,500 ,342,342,342 ,266,262,329 }, {505,497,501 ,342,342,342 ,266,262,329 },
		{502,498,506 ,342,342,342 ,329,262,266 }, {511,547,507 ,408,420,1201 ,126,130,358 },
		{508,548,512 ,1202,421,409 ,358,130,126 }, {509,549,513 ,1203,424,412 ,358,130,126 },
		{514,550,510 ,417,429,1204 ,126,130,358 }, {531,519,539 ,434,1205,419 ,132,101,129 },
		{540,520,532 ,422,1206,435 ,129,101,132 }, {541,521,533 ,425,1207,436 ,129,101,132 },
		{534,522,542 ,437,1208,428 ,132,101,129 }, {547,539,507 ,420,419,1201 ,130,129,358 },
		{508,540,548 ,1202,422,421 ,358,129,130 }, {509,541,549 ,1203,425,424 ,358,129,130 },
		{550,542,510 ,429,428,1204 ,130,129,358 }, {539,519,507 ,419,1205,1201 ,129,101,358 },
		{508,520,540 ,1202,1206,422 ,358,101,129 }, {509,521,541 ,1203,1207,425 ,358,101,129 },
		{542,522,510 ,428,1208,1204 ,129,101,358 }, {547,511,551 ,420,408,407 ,130,126,127 },
		{552,512,548 ,410,409,421 ,127,126,130 }, {553,513,549 ,413,412,424 ,127,126,130 },
		{550,514,554 ,429,417,416 ,130,126,127 }, {523,515,531 ,1109,1110,434 ,342,102,132 },
		{532,516,524 ,435,1111,1112 ,132,102,342 }, {533,517,525 ,436,1113,1114 ,132,102,342 },
		{526,518,534 ,1115,1116,437 ,342,102,132 }, {519,531,515 ,1205,434,1110 ,101,132,102 },
		{516,532,520 ,1111,435,1206 ,102,132,101 }, {517,533,521 ,1113,436,1207 ,102,132,101 },
		{522,534,518 ,1208,437,1116 ,101,132,102 }, {531,527,523 ,434,878,1109 ,132,273,342 },
		{524,528,532 ,1112,879,435 ,342,273,132 }, {525,529,533 ,1114,881,436 ,342,273,132 },
		{534,530,526 ,437,884,1115 ,132,273,342 }, {527,531,535 ,878,434,438 ,273,132,133 },
		{536,532,528 ,439,435,879 ,133,132,273 }, {537,533,529 ,440,436,881 ,133,132,273 },
		{530,534,538 ,884,437,441 ,273,132,133 }, {559,555,563 ,418,873,869 ,128,270,271 },
		{564,556,560 ,870,874,423 ,271,270,128 }, {565,557,561 ,871,875,426 ,271,270,128 },
		{562,558,566 ,427,876,872 ,128,270,271 }, {579,603,607 ,462,451,1209 ,139,137,368 },
		{608,604,580 ,1210,454,463 ,368,137,139 }, {609,605,581 ,1211,457,464 ,368,137,139 },
		{582,606,610 ,465,460,1212 ,139,137,368 }, {607,587,579 ,1209,1213,462 ,368,274,139 },
		{580,588,608 ,463,1214,1210 ,139,274,368 }, {581,589,609 ,464,1215,1211 ,139,274,368 },
		{610,590,582 ,1212,1216,465 ,368,274,139 }, {607,595,587 ,1209,971,1213 ,368,325,274 },
		{588,596,608 ,1214,972,1210 ,274,325,368 }, {589,597,609 ,1215,973,1211 ,274,325,368 },
		{610,598,590 ,1212,974,1216 ,368,325,274 }, {587,595,591 ,1213,971,1041 ,274,325,324 },
		{592,596,588 ,1042,972,1214 ,324,325,274 }, {593,597,589 ,1043,973,1215 ,324,325,274 },
		{590,598,594 ,1216,974,1044 ,274,325,324 }, {587,591,1229 ,889,1037,853 ,274,324,268 },
		{1230,592,588 ,854,1038,890 ,268,324,274 }, {1231,593,589 ,855,1039,891 ,268,324,274 },
		{590,594,1232 ,892,1040,856 ,274,324,268 }, {1229,591,1237 ,853,1037,1026 ,268,324,323 },
		{1238,592,1230 ,1027,1038,854 ,323,324,268 }, {1239,593,1231 ,1029,1039,855 ,323,324,268 },
		{1232,594,1240 ,856,1040,1032 ,268,324,323 }, {607,615,595 ,1209,630,971 ,368,369,325 },
		{596,616,608 ,972,253,1210 ,325,369,368 }, {597,617,609 ,973,630,1211 ,325,369,368 },
		{610,618,598 ,1212,253,974 ,368,369,325 }, {599,595,615 ,967,971,630 ,294,301,297 },
		{616,596,600 ,253,972,968 ,297,301,294 }, {617,597,601 ,630,973,969 ,297,301,294 },
		{602,598,618 ,970,974,253 ,294,301,297 }, {615,607,619 ,630,1209,1217 ,369,368,141 },
		{620,608,616 ,1218,1210,253 ,141,368,369 }, {621,609,617 ,1219,1211,630 ,141,368,369 },
		{618,610,622 ,253,1212,1220 ,369,368,141 }, {619,607,603 ,1217,1209,451 ,141,368,137 },
		{604,608,620 ,454,1210,1218 ,137,368,141 }, {605,609,621 ,457,1211,1219 ,137,368,141 },
		{622,610,606 ,1220,1212,460 ,141,368,137 }, {1361,623,1381 ,1221,487,1221 ,370,143,142 },
		{1382,624,1362 ,1222,488,1222 ,142,143,370 }, {1383,625,1363 ,1223,490,1223 ,142,143,370 },
		{1364,626,1384 ,1224,493,1224 ,370,143,142 }, {631,627,619 ,470,342,471 ,140,371,141 },
		{620,628,632 ,474,342,475 ,141,371,140 }, {621,629,633 ,477,342,478 ,141,371,140 },
		{634,630,622 ,479,342,480 ,140,371,141 }, {615,619,627 ,342,471,342 ,369,141,371 },
		{628,620,616 ,342,474,342 ,371,141,369 }, {629,621,617 ,342,477,342 ,371,141,369 },
		{618,622,630 ,342,480,342 ,369,141,371 }, {1109,631,623 ,547,1225,548 ,158,140,143 },
		{624,632,1110 ,549,1226,550 ,143,140,158 }, {625,633,1111 ,552,1227,553 ,143,140,158 },
		{1112,634,626 ,556,1228,557 ,158,140,143 }, {1353,623,1361 ,546,548,306 ,157,143,370 },
		{1362,624,1354 ,307,549,551 ,370,143,157 }, {1363,625,1355 ,308,552,554 ,370,143,157 },
		{1356,626,1364 ,555,557,309 ,157,143,370 }, {1117,627,1109 ,1229,1230,547 ,372,371,158 },
		{1110,628,1118 ,550,1231,1232 ,158,371,372 }, {1111,629,1119 ,553,1233,1234 ,158,371,372 },
		{1120,630,1112 ,1235,1236,556 ,372,371,158 }, {627,1117,639 ,1230,1229,1237 ,296,373,295 },
		{640,1118,628 ,1238,1232,1231 ,295,373,296 }, {641,1119,629 ,1239,1234,1233 ,295,373,296 },
		{630,1120,642 ,1236,1235,1240 ,296,373,295 }, {631,1109,627 ,1225,547,1230 ,140,158,371 },
		{628,1110,632 ,1231,550,1226 ,371,158,140 }, {629,1111,633 ,1233,553,1227 ,371,158,140 },
		{634,1112,630 ,1228,556,1236 ,140,158,371 }, {635,1129,1137 ,1241,542,1242 ,112,155,374 },
		{1138,1130,636 ,1243,543,1244 ,374,155,112 }, {1139,1131,637 ,1245,544,1246 ,374,155,112 },
		{638,1132,1140 ,1247,545,1248 ,112,155,374 }, {647,635,1137 ,1249,1241,1242 ,298,112,374 },
		{1138,636,648 ,1243,1244,1250 ,374,112,298 }, {1139,637,649 ,1245,1246,1251 ,374,112,298 },
		{650,638,1140 ,1252,1247,1248 ,298,112,374 }, {635,643,1129 ,1241,1253,542 ,112,113,155 },
		{1130,644,636 ,543,1254,1244 ,155,113,112 }, {1131,645,637 ,544,1255,1246 ,155,113,112 },
		{638,646,1132 ,1247,1256,545 ,112,113,155 }, {1129,643,1117 ,542,1253,1229 ,155,113,373 },
		{1118,644,1130 ,1232,1254,543 ,373,113,155 }, {1119,645,1131 ,1234,1255,544 ,373,113,155 },
		{1132,646,1120 ,545,1256,1235 ,155,113,373 }, {639,1117,643 ,1237,1229,1253 ,295,373,113 },
		{644,1118,640 ,1254,1232,1238 ,113,373,295 }, {645,1119,641 ,1255,1234,1239 ,113,373,295 },
		{642,1120,646 ,1240,1235,1256 ,295,373,113 }, {1153,767,647 ,1257,0,1249 ,375,376,377 },
		{648,768,1154 ,1250,0,1258 ,377,376,375 }, {649,769,1155 ,1251,2,1259 ,377,376,375 },
		{1156,770,650 ,1260,2,1252 ,375,376,377 }, {1137,1157,1153 ,1242,1261,1257 ,378,275,379 },
		{1154,1158,1138 ,1258,1262,1243 ,379,275,378 }, {1155,1159,1139 ,1259,1263,1245 ,379,275,378 },
		{1140,1160,1156 ,1248,1264,1260 ,378,275,379 }, {647,699,667 ,1249,0,963 ,377,380,381 },
		{668,700,648 ,964,0,1250 ,381,380,377 }, {669,701,649 ,965,2,1251 ,381,380,377 },
		{650,702,670 ,1252,2,966 ,377,380,381 }, {647,767,699 ,1249,0,0 ,377,376,380 },
		{700,768,648 ,0,0,1250 ,380,376,377 }, {701,769,649 ,2,2,1251 ,380,376,377 },
		{650,770,702 ,1252,2,2 ,377,376,380 }, {1153,647,1137 ,1257,1249,1242 ,382,298,374 },
		{1138,648,1154 ,1243,1250,1258 ,374,298,382 }, {1139,649,1155 ,1245,1251,1259 ,374,298,382 },
		{1156,650,1140 ,1260,1252,1248 ,382,298,374 }, {699,767,651 ,0,0,0 ,380,376,383 },
		{652,768,700 ,0,0,0 ,383,376,380 }, {653,769,701 ,2,2,2 ,383,376,380 },
		{702,770,654 ,2,2,2 ,380,376,383 }, {699,651,655 ,0,0,0 ,380,383,384 },
		{656,652,700 ,0,0,0 ,384,383,380 }, {657,653,701 ,2,2,2 ,384,383,380 },
		{702,654,658 ,2,2,2 ,380,383,384 }, {699,655,659 ,0,0,0 ,380,384,385 },
		{660,656,700 ,0,0,0 ,385,384,380 }, {661,657,701 ,2,2,2 ,385,384,380 },
		{702,658,662 ,2,2,2 ,380,384,385 }, {699,659,675 ,0,0,0 ,380,385,386 },
		{676,660,700 ,0,0,0 ,386,385,380 }, {677,661,701 ,2,2,2 ,386,385,380 },
		{702,662,678 ,2,2,2 ,380,385,386 }, {683,667,699 ,0,963,0 ,387,381,380 },
		{700,668,684 ,0,964,0 ,380,381,387 }, {701,669,685 ,2,965,2 ,380,381,387 },
		{686,670,702 ,2,966,2 ,387,381,380 }, {671,663,667 ,1018,355,963 ,388,108,299 },
		{668,664,672 ,964,356,1019 ,299,108,388 }, {669,665,673 ,965,357,1021 ,299,108,388 },
		{674,666,670 ,1024,358,966 ,388,108,299 }, {671,667,683 ,1018,963,0 ,389,381,387 },
		{684,668,672 ,0,964,1019 ,387,381,389 }, {685,669,673 ,2,965,1021 ,387,381,389 },
		{674,670,686 ,1024,966,2 ,389,381,387 }, {679,691,699 ,0,0,0 ,390,391,380 },
		{700,692,680 ,0,0,0 ,380,391,390 }, {701,693,681 ,2,2,2 ,380,391,390 },
		{682,694,702 ,2,2,2 ,390,391,380 }, {675,679,699 ,0,0,0 ,386,390,380 },
		{700,680,676 ,0,0,0 ,380,390,386 }, {701,681,677 ,2,2,2 ,380,390,386 },
		{678,682,702 ,2,2,2 ,386,390,380 }, {683,699,687 ,0,0,0 ,387,380,392 },
		{688,700,684 ,0,0,0 ,392,380,387 }, {689,701,685 ,2,2,2 ,392,380,387 },
		{686,702,690 ,2,2,2 ,387,380,392 }, {699,691,687 ,0,0,0 ,380,391,392 },
		{688,692,700 ,0,0,0 ,392,391,380 }, {689,693,701 ,2,2,2 ,392,391,380 },
		{702,694,690 ,2,2,2 ,380,391,392 }, {755,695,699 ,393,393,393 ,393,394,395 },
		{700,696,756 ,393,393,393 ,395,394,393 }, {701,697,757 ,393,393,393 ,395,394,393 },
		{758,698,702 ,393,393,393 ,393,394,395 }, {763,715,755 ,2,677,2 ,396,195,397 },
		{756,716,764 ,2,678,2 ,397,195,396 }, {757,717,765 ,0,679,0 ,397,195,396 },
		{766,718,758 ,0,680,0 ,396,195,397 }, {707,703,755 ,2,2,2 ,398,399,397 },
		{756,704,708 ,2,2,2 ,397,399,398 }, {757,705,709 ,0,0,0 ,397,399,398 },
		{710,706,758 ,0,0,0 ,398,399,397 }, {703,763,755 ,2,2,2 ,399,396,397 },
		{756,764,704 ,2,2,2 ,397,396,399 }, {757,765,705 ,0,0,0 ,397,396,399 },
		{706,766,758 ,0,0,0 ,399,396,397 }, {755,723,711 ,2,2,2 ,397,400,401 },
		{712,724,756 ,2,2,2 ,401,400,397 }, {713,725,757 ,0,0,0 ,401,400,397 },
		{758,726,714 ,0,0,0 ,397,400,401 }, {755,711,707 ,2,2,2 ,397,401,398 },
		{708,712,756 ,2,2,2 ,398,401,397 }, {709,713,757 ,0,0,0 ,398,401,397 },
		{758,714,710 ,0,0,0 ,397,401,398 }, {715,763,845 ,677,2,2 ,195,396,196 },
		{846,764,716 ,2,2,678 ,196,396,195 }, {847,765,717 ,0,0,679 ,196,396,195 },
		{718,766,848 ,680,0,0 ,195,396,196 }, {755,715,719 ,2,677,913 ,397,195,279 },
		{720,716,756 ,913,678,2 ,279,195,397 }, {721,717,757 ,914,679,0 ,279,195,397 },
		{758,718,722 ,0,680,914 ,397,195,279 }, {719,1317,739 ,913,2,935 ,279,280,284 },
		{740,1318,720 ,935,2,913 ,284,280,279 }, {741,1319,721 ,936,0,914 ,284,280,279 },
		{722,1320,742 ,914,0,936 ,279,280,284 }, {755,719,739 ,2,913,935 ,397,279,284 },
		{740,720,756 ,935,913,2 ,284,279,397 }, {741,721,757 ,936,914,0 ,284,279,397 },
		{758,722,742 ,0,914,936 ,397,279,284 }, {739,1317,1321 ,935,2,2 ,284,280,285 },
		{1322,1318,740 ,2,2,935 ,285,280,284 }, {1323,1319,741 ,0,0,936 ,285,280,284 },
		{742,1320,1324 ,936,0,0 ,284,280,285 }, {723,755,727 ,2,2,2 ,400,397,402 },
		{728,756,724 ,2,2,2 ,402,397,400 }, {729,757,725 ,0,0,0 ,402,397,400 },
		{726,758,730 ,0,0,0 ,400,397,402 }, {731,727,755 ,2,2,2 ,403,402,397 },
		{756,728,732 ,2,2,2 ,397,402,403 }, {757,729,733 ,0,0,0 ,397,402,403 },
		{734,730,758 ,0,0,0 ,403,402,397 }, {751,735,755 ,2,2,2 ,404,405,397 },
		{756,736,752 ,2,2,2 ,397,405,404 }, {757,737,753 ,0,0,0 ,397,405,404 },
		{754,738,758 ,0,0,0 ,404,405,397 }, {755,735,731 ,2,2,2 ,397,405,403 },
		{732,736,756 ,2,2,2 ,403,405,397 }, {733,737,757 ,0,0,0 ,403,405,397 },
		{758,738,734 ,0,0,0 ,397,405,403 }, {759,755,743 ,951,2,947 ,292,397,290 },
		{744,756,760 ,947,2,951 ,290,397,292 }, {745,757,761 ,950,0,952 ,290,397,292 },
		{762,758,746 ,952,0,950 ,292,397,290 }, {739,747,755 ,935,923,2 ,284,281,397 },
		{756,748,740 ,2,928,935 ,397,281,284 }, {757,749,741 ,0,931,936 ,397,281,284 },
		{742,750,758 ,936,932,0 ,284,281,397 }, {747,743,755 ,923,947,2 ,281,290,397 },
		{756,744,748 ,2,947,928 ,397,290,281 }, {757,745,749 ,0,950,931 ,397,290,281 },
		{750,746,758 ,932,950,0 ,281,290,397 }, {1217,743,1221 ,2,947,2 ,288,290,287 },
		{1222,744,1218 ,2,947,2 ,287,290,288 }, {1223,745,1219 ,0,950,0 ,287,290,288 },
		{1220,746,1224 ,0,950,0 ,288,290,287 }, {747,1221,743 ,923,2,947 ,281,287,290 },
		{744,1222,748 ,947,2,928 ,290,287,281 }, {745,1223,749 ,950,0,931 ,290,287,281 },
		{750,1224,746 ,932,0,950 ,281,287,290 }, {751,759,1261 ,2,951,2 ,404,292,406 },
		{1262,760,752 ,2,951,2 ,406,292,404 }, {1263,761,753 ,0,952,0 ,406,292,404 },
		{754,762,1264 ,0,952,0 ,404,292,406 }, {751,755,759 ,2,2,951 ,404,397,292 },
		{760,756,752 ,951,2,2 ,292,397,404 }, {761,757,753 ,952,0,0 ,292,397,404 },
		{754,758,762 ,0,0,952 ,404,397,292 }, {759,1225,1261 ,951,2,2 ,292,293,406 },
		{1262,1226,760 ,2,2,951 ,406,293,292 }, {1263,1227,761 ,0,0,952 ,406,293,292 },
		{762,1228,1264 ,952,0,0 ,292,293,406 }, {1213,767,1153 ,768,765,1265 ,235,232,407 },
		{1154,768,1214 ,1266,770,772 ,407,232,235 }, {1155,769,1215 ,1267,774,775 ,407,232,235 },
		{1216,770,1156 ,778,776,1268 ,235,232,407 }, {865,797,801 ,675,1269,1270 ,193,408,409 },
		{801,798,865 ,1270,1271,675 ,409,408,193 }, {802,799,866 ,1272,1273,676 ,409,408,193 },
		{866,800,802 ,676,1274,1272 ,193,408,409 }, {777,785,825 ,1275,1276,598 ,410,411,176 },
		{826,786,778 ,599,1277,1278 ,176,411,410 }, {827,787,779 ,602,1279,1280 ,176,411,410 },
		{780,788,828 ,1281,1282,607 ,410,411,176 }, {777,809,781 ,1275,608,626 ,410,177,181 },
		{782,810,778 ,627,609,1278 ,181,177,410 }, {783,811,779 ,628,610,1280 ,181,177,410 },
		{780,812,784 ,1281,611,629 ,410,177,181 }, {837,793,789 ,661,1283,1284 ,191,412,413 },
		{790,794,838 ,1285,1286,662 ,413,412,191 }, {791,795,839 ,1287,1288,663 ,413,412,191 },
		{840,796,792 ,664,1289,1290 ,191,412,413 }, {773,829,785 ,1291,641,1276 ,414,186,411 },
		{786,830,774 ,1277,642,1292 ,411,186,414 }, {787,831,775 ,1279,643,1293 ,411,186,414 },
		{776,832,788 ,1294,644,1282 ,414,186,411 }, {793,833,773 ,1283,649,1291 ,412,188,414 },
		{774,834,794 ,1292,650,1286 ,414,188,412 }, {775,835,795 ,1293,651,1288 ,414,188,412 },
		{796,836,776 ,1289,652,1294 ,412,188,414 }, {797,841,789 ,1269,669,1284 ,408,192,413 },
		{790,842,798 ,1285,670,1271 ,413,192,408 }, {791,843,799 ,1287,671,1273 ,413,192,408 },
		{800,844,792 ,1274,672,1290 ,408,192,413 }, {833,829,773 ,649,641,1291 ,188,186,414 },
		{774,830,834 ,1292,642,650 ,414,186,188 }, {775,831,835 ,1293,643,651 ,414,186,188 },
		{836,832,776 ,652,644,1294 ,188,186,414 }, {825,809,777 ,598,608,1275 ,176,177,410 },
		{778,810,826 ,1278,609,599 ,410,177,176 }, {779,811,827 ,1280,610,602 ,410,177,176 },
		{828,812,780 ,607,611,1281 ,176,177,410 }, {809,805,781 ,608,616,626 ,177,179,181 },
		{782,806,810 ,627,617,609 ,181,179,177 }, {783,807,811 ,628,618,610 ,181,179,177 },
		{812,808,784 ,611,619,629 ,177,179,181 }, {829,825,785 ,641,598,1276 ,186,176,411 },
		{786,826,830 ,1277,599,642 ,411,176,186 }, {787,827,831 ,1279,602,643 ,411,176,186 },
		{832,828,788 ,644,607,1282 ,186,176,411 }, {841,837,789 ,669,661,1284 ,192,191,413 },
		{790,838,842 ,1285,662,670 ,413,191,192 }, {791,839,843 ,1287,663,671 ,413,191,192 },
		{844,840,792 ,672,664,1290 ,192,191,413 }, {837,833,793 ,661,649,1283 ,191,188,412 },
		{794,834,838 ,1286,650,662 ,412,188,191 }, {795,835,839 ,1288,651,663 ,412,188,191 },
		{840,836,796 ,664,652,1289 ,191,188,412 }, {865,841,797 ,675,669,1269 ,193,192,408 },
		{798,842,865 ,1271,670,675 ,408,192,193 }, {799,843,866 ,1273,671,676 ,408,192,193 },
		{866,844,800 ,676,672,1274 ,193,192,408 }, {1309,853,1313 ,342,342,342 ,187,189,255 },
		{1314,854,1310 ,342,342,342 ,255,189,187 }, {1315,855,1311 ,342,342,342 ,255,189,187 },
		{1312,856,1316 ,342,342,342 ,187,189,255 }, {1081,905,889 ,1295,1296,1297 ,415,416,417 },
		{890,906,1082 ,1298,1299,1300 ,417,416,415 }, {891,907,1083 ,1301,1302,1303 ,417,416,415 },
		{1084,908,892 ,1304,1305,1306 ,415,416,417 }, {1365,1069,1357 ,311,1307,310 ,93,418,92 },
		{1358,1070,1366 ,313,1308,312 ,92,418,93 }, {1359,1071,1367 ,315,1309,314 ,92,418,93 },
		{1368,1072,1360 ,317,1310,316 ,93,418,92 }, {1069,1365,905 ,1307,311,1296 ,418,93,416 },
		{906,1366,1070 ,1299,312,1308 ,416,93,418 }, {907,1367,1071 ,1302,314,1309 ,416,93,418 },
		{1072,1368,908 ,1310,317,1305 ,418,93,416 }, {1081,1069,905 ,1295,1307,1296 ,415,418,416 },
		{906,1070,1082 ,1299,1308,1300 ,416,418,415 }, {907,1071,1083 ,1302,1309,1303 ,416,418,415 },
		{1084,1072,908 ,1304,1310,1305 ,415,418,416 }, {1097,1081,889 ,1311,1295,1297 ,419,415,417 },
		{890,1082,1098 ,1298,1300,1312 ,417,415,419 }, {891,1083,1099 ,1301,1303,1313 ,417,415,419 },
		{1100,1084,892 ,1314,1304,1306 ,419,415,417 }, {889,893,1097 ,1297,1315,1311 ,417,420,419 },
		{1098,894,890 ,1312,1316,1298 ,419,420,417 }, {1099,895,891 ,1313,1317,1301 ,419,420,417 },
		{892,896,1100 ,1306,1318,1314 ,417,420,419 }, {893,1065,1093 ,1315,690,687 ,420,421,422 },
		{1094,1066,894 ,692,694,1316 ,422,421,420 }, {1095,1067,895 ,695,696,1317 ,422,421,420 },
		{896,1068,1096 ,1318,698,697 ,420,421,422 }, {1093,1097,893 ,687,1311,1315 ,422,419,420 },
		{894,1098,1094 ,1316,1312,692 ,420,419,422 }, {895,1099,1095 ,1317,1313,695 ,420,419,422 },
		{1096,1100,896 ,697,1314,1318 ,422,419,420 }, {881,921,1061 ,1319,722,721 ,423,213,212 },
		{1062,922,882 ,726,725,1320 ,212,213,423 }, {1061,923,883 ,721,727,1321 ,212,213,423 },
		{884,924,1062 ,1322,728,726 ,423,213,212 }, {1061,1063,881 ,721,688,1319 ,212,201,423 },
		{882,1064,1062 ,1320,691,726 ,423,201,212 }, {883,1063,1061 ,1321,688,721 ,423,201,212 },
		{1062,1064,884 ,726,691,1322 ,212,201,423 }, {1065,881,1063 ,690,1319,688 ,203,423,201 },
		{1064,882,1066 ,691,1320,694 ,201,423,203 }, {1063,883,1067 ,688,1321,696 ,201,423,203 },
		{1068,884,1064 ,698,1322,691 ,203,423,201 }, {873,913,869 ,1323,1324,1325 ,424,425,426 },
		{870,914,874 ,1326,1327,1328 ,426,425,424 }, {871,915,875 ,1329,1330,1331 ,426,425,424 },
		{876,916,872 ,1332,1333,1334 ,424,425,426 }, {917,921,869 ,1335,722,1325 ,427,428,426 },
		{870,922,918 ,1326,725,1336 ,426,428,427 }, {871,923,919 ,1329,727,1337 ,426,428,427 },
		{920,924,872 ,1338,728,1334 ,427,428,426 }, {913,917,869 ,1324,1335,1325 ,425,427,426 },
		{870,918,914 ,1326,1336,1327 ,426,427,425 }, {871,919,915 ,1329,1337,1330 ,426,427,425 },
		{916,920,872 ,1333,1338,1334 ,425,427,426 }, {881,869,921 ,1319,1325,722 ,429,426,428 },
		{922,870,882 ,725,1326,1320 ,428,426,429 }, {923,871,883 ,727,1329,1321 ,428,426,429 },
		{884,872,924 ,1322,1334,728 ,429,426,428 }, {885,897,869 ,1339,1340,1325 ,430,431,426 },
		{870,898,886 ,1326,1341,1342 ,426,431,430 }, {871,899,887 ,1329,1343,1344 ,426,431,430 },
		{888,900,872 ,1345,1346,1334 ,430,431,426 }, {885,869,881 ,1339,1325,1319 ,430,426,429 },
		{882,870,886 ,1320,1326,1342 ,429,426,430 }, {883,871,887 ,1321,1329,1344 ,429,426,430 },
		{888,872,884 ,1345,1334,1322 ,430,426,429 }, {897,873,869 ,1340,1323,1325 ,431,424,426 },
		{870,874,898 ,1326,1328,1341 ,426,424,431 }, {871,875,899 ,1329,1331,1343 ,426,424,431 },
		{900,876,872 ,1346,1332,1334 ,431,424,426 }, {873,909,913 ,1323,1347,1324 ,424,432,425 },
		{914,910,874 ,1327,1348,1328 ,425,432,424 }, {915,911,875 ,1330,1349,1331 ,425,432,424 },
		{876,912,916 ,1332,1350,1333 ,424,432,425 }, {909,877,1369 ,1347,442,318 ,432,134,94 },
		{1370,878,910 ,319,445,1348 ,94,134,432 }, {1371,879,911 ,320,447,1349 ,94,134,432 },
		{912,880,1372 ,1350,448,321 ,432,134,94 }, {877,909,873 ,442,1347,1323 ,134,432,424 },
		{874,910,878 ,1328,1348,445 ,424,432,134 }, {875,911,879 ,1331,1349,447 ,424,432,134 },
		{880,912,876 ,448,1350,1332 ,134,432,424 }, {897,877,873 ,1340,442,1323 ,431,134,424 },
		{874,878,898 ,1328,445,1341 ,424,134,431 }, {875,879,899 ,1331,447,1343 ,424,134,431 },
		{900,880,876 ,1346,448,1332 ,431,134,424 }, {901,877,897 ,443,442,1340 ,135,134,431 },
		{898,878,902 ,1341,445,444 ,431,134,135 }, {899,879,903 ,1343,447,446 ,431,134,135 },
		{904,880,900 ,449,448,1346 ,135,134,431 }, {889,905,897 ,1297,1296,1340 ,417,416,431 },
		{898,906,890 ,1341,1299,1298 ,431,416,417 }, {899,907,891 ,1343,1302,1301 ,431,416,417 },
		{892,908,900 ,1306,1305,1346 ,417,416,431 }, {885,881,893 ,1339,1319,1315 ,430,429,420 },
		{894,882,886 ,1316,1320,1342 ,420,429,430 }, {895,883,887 ,1317,1321,1344 ,420,429,430 },
		{888,884,896 ,1345,1322,1318 ,430,429,420 }, {897,885,889 ,1340,1339,1297 ,431,430,417 },
		{890,886,898 ,1298,1342,1341 ,417,430,431 }, {891,887,899 ,1301,1344,1343 ,417,430,431 },
		{900,888,892 ,1346,1345,1306 ,431,430,417 }, {1065,893,881 ,690,1315,1319 ,421,420,429 },
		{882,894,1066 ,1320,1316,694 ,429,420,421 }, {883,895,1067 ,1321,1317,696 ,429,420,421 },
		{1068,896,884 ,698,1318,1322 ,421,420,429 }, {893,889,885 ,1315,1297,1339 ,420,417,430 },
		{886,890,894 ,1342,1298,1316 ,430,417,420 }, {887,891,895 ,1344,1301,1317 ,430,417,420 },
		{896,892,888 ,1318,1306,1345 ,420,417,430 }, {905,901,897 ,1296,443,1340 ,416,135,431 },
		{898,902,906 ,1341,444,1299 ,431,135,416 }, {899,903,907 ,1343,446,1302 ,431,135,416 },
		{908,904,900 ,1305,449,1346 ,416,135,431 }, {905,1365,901 ,1296,311,443 ,416,93,135 },
		{902,1366,906 ,444,312,1299 ,135,93,416 }, {903,1367,907 ,446,314,1302 ,135,93,416 },
		{908,1368,904 ,1305,317,449 ,416,93,135 }, {913,977,957 ,1324,1351,1352 ,425,433,434 },
		{958,978,914 ,1353,1354,1327 ,434,433,425 }, {959,979,915 ,1355,1356,1330 ,434,433,425 },
		{916,980,960 ,1333,1357,1358 ,425,433,434 }, {1373,909,1369 ,323,1347,318 ,96,432,94 },
		{1370,910,1374 ,319,1348,324 ,94,432,96 }, {1371,911,1375 ,320,1349,326 ,94,432,96 },
		{1376,912,1372 ,329,1350,321 ,96,432,94 }, {909,1373,977 ,1347,323,1351 ,432,96,433 },
		{978,1374,910 ,1354,324,1348 ,433,96,432 }, {979,1375,911 ,1356,326,1349 ,433,96,432 },
		{912,1376,980 ,1350,329,1357 ,432,96,433 }, {913,909,977 ,1324,1347,1351 ,425,432,433 },
		{978,910,914 ,1354,1348,1327 ,433,432,425 }, {979,911,915 ,1356,1349,1330 ,433,432,425 },
		{916,912,980 ,1333,1350,1357 ,425,432,433 }, {917,913,957 ,1335,1324,1352 ,427,425,434 },
		{958,914,918 ,1353,1327,1336 ,434,425,427 }, {959,915,919 ,1355,1330,1337 ,434,425,427 },
		{920,916,960 ,1338,1333,1358 ,427,425,434 }, {957,953,917 ,1352,1359,1335 ,434,435,427 },
		{918,954,958 ,1336,1360,1353 ,427,435,434 }, {919,955,959 ,1337,1361,1355 ,427,435,434 },
		{960,956,920 ,1358,1362,1338 ,434,435,427 }, {953,949,921 ,1359,738,722 ,435,436,428 },
		{922,950,954 ,725,740,1360 ,428,436,435 }, {923,951,955 ,727,741,1361 ,428,436,435 },
		{956,952,924 ,1362,742,728 ,435,436,428 }, {921,917,953 ,722,1335,1359 ,428,427,435 },
		{954,918,922 ,1360,1336,725 ,435,427,428 }, {955,919,923 ,1361,1337,727 ,435,427,428 },
		{924,920,956 ,728,1338,1362 ,428,427,435 }, {969,961,973 ,322,1363,1364 ,95,437,438 },
		{974,962,970 ,1365,1366,325 ,438,437,95 }, {975,963,971 ,1367,1368,327 ,438,437,95 },
		{972,964,976 ,328,1369,1370 ,95,437,438 }, {925,937,941 ,1371,731,1372 ,439,440,441 },
		{942,938,926 ,1373,733,1374 ,441,440,439 }, {943,939,927 ,1375,735,1376 ,441,440,439 },
		{928,940,944 ,1377,736,1378 ,439,440,441 }, {929,985,989 ,1379,1380,1381 ,442,443,444 },
		{990,986,930 ,1382,1383,1384 ,444,443,442 }, {991,987,931 ,1385,1386,1387 ,444,443,442 },
		{932,988,992 ,1388,1389,1390 ,442,443,444 }, {993,929,989 ,1391,1379,1381 ,445,442,444 },
		{990,930,994 ,1382,1384,1392 ,444,442,445 }, {991,931,995 ,1385,1387,1393 ,444,442,445 },
		{996,932,992 ,1394,1388,1390 ,445,442,444 }, {993,1441,925 ,1391,711,1371 ,445,446,439 },
		{926,1442,994 ,1374,714,1392 ,439,446,445 }, {927,1443,995 ,1376,717,1393 ,439,446,445 },
		{996,1444,928 ,1394,719,1377 ,445,446,439 }, {961,941,965 ,1363,1372,1395 ,437,441,447 },
		{966,942,962 ,1396,1373,1366 ,447,441,437 }, {967,943,963 ,1397,1375,1368 ,447,441,437 },
		{964,944,968 ,1369,1378,1398 ,437,441,447 }, {929,993,925 ,1379,1391,1371 ,442,445,439 },
		{926,994,930 ,1374,1392,1384 ,439,445,442 }, {927,995,931 ,1376,1393,1387 ,439,445,442 },
		{932,996,928 ,1388,1394,1377 ,442,445,439 }, {925,941,961 ,1371,1372,1363 ,439,441,437 },
		{962,942,926 ,1366,1373,1374 ,437,441,439 }, {963,943,927 ,1368,1375,1376 ,437,441,439 },
		{928,944,964 ,1377,1378,1369 ,439,441,437 }, {1441,937,925 ,711,731,1371 ,446,440,439 },
		{926,938,1442 ,1374,733,714 ,439,440,446 }, {927,939,1443 ,1376,735,717 ,439,440,446 },
		{1444,940,928 ,719,736,1377 ,446,440,439 }, {929,961,969 ,1379,1363,322 ,442,437,95 },
		{970,962,930 ,325,1366,1384 ,95,437,442 }, {971,963,931 ,327,1368,1387 ,95,437,442 },
		{932,964,972 ,1388,1369,328 ,442,437,95 }, {961,929,925 ,1363,1379,1371 ,437,442,439 },
		{926,930,962 ,1374,1384,1366 ,439,442,437 }, {927,931,963 ,1376,1387,1368 ,439,442,437 },
		{964,932,928 ,1369,1388,1377 ,437,442,439 }, {929,933,985 ,1379,330,1380 ,442,97,443 },
		{986,934,930 ,1383,331,1384 ,443,97,442 }, {987,935,931 ,1386,332,1387 ,443,97,442 },
		{932,936,988 ,1388,333,1389 ,442,97,443 }, {969,933,929 ,322,330,1379 ,95,97,442 },
		{930,934,970 ,1384,331,325 ,442,97,95 }, {931,935,971 ,1387,332,327 ,442,97,95 },
		{972,936,932 ,328,333,1388 ,95,97,442 }, {985,933,1377 ,1380,330,298 ,443,97,89 },
		{1378,934,986 ,299,331,1383 ,89,97,443 }, {1379,935,987 ,300,332,1386 ,89,97,443 },
		{988,936,1380 ,1389,333,301 ,443,97,89 }, {973,965,953 ,1364,1395,1359 ,438,447,435 },
		{954,966,974 ,1360,1396,1365 ,435,447,438 }, {955,967,975 ,1361,1397,1367 ,435,447,438 },
		{976,968,956 ,1370,1398,1362 ,438,447,435 }, {941,945,965 ,1372,743,1395 ,441,448,447 },
		{966,946,942 ,1396,745,1373 ,447,448,441 }, {967,947,943 ,1397,747,1375 ,447,448,441 },
		{944,948,968 ,1378,748,1398 ,441,448,447 }, {941,937,945 ,1372,731,743 ,441,440,448 },
		{946,938,942 ,745,733,1373 ,448,440,441 }, {947,939,943 ,747,735,1375 ,448,440,441 },
		{944,940,948 ,1378,736,748 ,441,440,448 }, {965,949,953 ,1395,738,1359 ,447,436,435 },
		{954,950,966 ,1360,740,1396 ,435,436,447 }, {955,951,967 ,1361,741,1397 ,435,436,447 },
		{968,952,956 ,1398,742,1362 ,447,436,435 }, {949,965,945 ,738,1395,743 ,436,447,448 },
		{946,966,950 ,745,1396,740 ,448,447,436 }, {947,967,951 ,747,1397,741 ,448,447,436 },
		{952,968,948 ,742,1398,748 ,436,447,448 }, {957,973,953 ,1352,1364,1359 ,434,438,435 },
		{954,974,958 ,1360,1365,1353 ,435,438,434 }, {955,975,959 ,1361,1367,1355 ,435,438,434 },
		{960,976,956 ,1358,1370,1362 ,434,438,435 }, {977,973,957 ,1351,1364,1352 ,433,438,434 },
		{958,974,978 ,1353,1365,1354 ,434,438,433 }, {959,975,979 ,1355,1367,1356 ,434,438,433 },
		{980,976,960 ,1357,1370,1358 ,433,438,434 }, {965,973,961 ,1395,1364,1363 ,447,438,437 },
		{962,974,966 ,1366,1365,1396 ,437,438,447 }, {963,975,967 ,1368,1367,1397 ,437,438,447 },
		{968,976,964 ,1398,1370,1369 ,447,438,437 }, {969,973,981 ,322,1364,334 ,95,438,98 },
		{982,974,970 ,335,1365,325 ,98,438,95 }, {983,975,971 ,336,1367,327 ,98,438,95 },
		{972,976,984 ,328,1370,337 ,95,438,98 }, {981,973,977 ,334,1364,1351 ,98,438,433 },
		{978,974,982 ,1354,1365,335 ,433,438,98 }, {979,975,983 ,1356,1367,336 ,433,438,98 },
		{984,976,980 ,337,1370,1357 ,98,438,433 }, {981,977,1373 ,334,1351,323 ,98,433,96 },
		{1374,978,982 ,324,1354,335 ,96,433,98 }, {1375,979,983 ,326,1356,336 ,96,433,98 },
		{984,980,1376 ,337,1357,329 ,98,433,96 }, {985,1001,989 ,1380,1399,1381 ,443,449,444 },
		{990,1002,986 ,1382,1400,1383 ,444,449,443 }, {991,1003,987 ,1385,1401,1386 ,444,449,443 },
		{988,1004,992 ,1389,1402,1390 ,443,449,444 }, {1397,997,1377 ,338,1403,298 ,99,450,89 },
		{1378,998,1398 ,299,1404,339 ,89,450,99 }, {1379,999,1399 ,300,1405,340 ,89,450,99 },
		{1400,1000,1380 ,341,1406,301 ,99,450,89 }, {997,1001,985 ,1403,1399,1380 ,450,449,443 },
		{986,1002,998 ,1383,1400,1404 ,443,449,450 }, {987,1003,999 ,1386,1401,1405 ,443,449,450 },
		{1000,1004,988 ,1406,1402,1389 ,450,449,443 }, {985,1377,997 ,1380,298,1403 ,443,89,450 },
		{998,1378,986 ,1404,299,1383 ,450,89,443 }, {999,1379,987 ,1405,300,1386 ,450,89,443 },
		{988,1380,1000 ,1389,301,1406 ,443,89,450 }, {1001,1449,993 ,1399,713,1391 ,449,451,445 },
		{994,1450,1002 ,1392,716,1400 ,445,451,449 }, {995,1451,1003 ,1393,718,1401 ,445,451,449 },
		{1004,1452,996 ,1402,720,1394 ,449,451,445 }, {1001,993,989 ,1399,1391,1381 ,449,445,444 },
		{990,994,1002 ,1382,1392,1400 ,444,445,449 }, {991,995,1003 ,1385,1393,1401 ,444,445,449 },
		{1004,996,992 ,1402,1394,1390 ,449,445,444 }, {993,1449,1441 ,1391,713,711 ,445,451,446 },
		{1442,1450,994 ,714,716,1392 ,446,451,445 }, {1443,1451,995 ,717,718,1393 ,446,451,445 },
		{996,1452,1444 ,1394,720,719 ,445,451,446 }, {1033,997,1397 ,1407,1408,578 ,452,453,162 },
		{1398,998,1034 ,579,1409,1410 ,162,453,452 }, {1399,999,1035 ,580,1411,1412 ,162,453,452 },
		{1036,1000,1400 ,1413,1414,581 ,452,453,162 }, {1449,1001,1029 ,713,1399,803 ,244,454,246 },
		{1030,1002,1450 ,806,1400,716 ,246,454,244 }, {1031,1003,1451 ,808,1401,718 ,246,454,244 },
		{1452,1004,1032 ,720,1402,809 ,244,454,246 }, {1001,997,1033 ,1399,1408,1407 ,454,453,452 },
		{1034,998,1002 ,1410,1409,1400 ,452,453,454 }, {1035,999,1003 ,1412,1411,1401 ,452,453,454 },
		{1004,1000,1036 ,1402,1414,1413 ,454,453,452 }, {1449,1029,1445 ,713,803,779 ,244,246,236 },
		{1446,1030,1450 ,783,806,716 ,236,246,244 }, {1447,1031,1451 ,786,808,718 ,236,246,244 },
		{1452,1032,1448 ,720,809,789 ,244,246,236 }, {1001,1033,1029 ,1399,1407,803 ,454,452,246 },
		{1030,1034,1002 ,806,1410,1400 ,246,452,454 }, {1031,1035,1003 ,808,1412,1401 ,246,452,454 },
		{1004,1036,1032 ,1402,1413,809 ,454,452,246 }, {1041,1033,1397 ,282,1407,578 ,85,452,162 },
		{1398,1034,1042 ,579,1410,283 ,162,452,85 }, {1399,1035,1043 ,580,1412,284 ,162,452,85 },
		{1044,1036,1400 ,285,1413,581 ,85,452,162 }, {1009,1413,1005 ,255,254,1415 ,79,78,455 },
		{1006,1414,1010 ,1416,259,258 ,455,78,79 }, {1007,1415,1011 ,1417,262,261 ,455,78,79 },
		{1012,1416,1008 ,264,263,1418 ,79,78,455 }, {1005,1417,1049 ,1415,383,791 ,455,116,240 },
		{1050,1418,1006 ,793,384,1416 ,240,116,455 }, {1051,1419,1007 ,794,386,1417 ,240,116,455 },
		{1008,1420,1052 ,1418,390,796 ,455,116,240 }, {1005,1013,1017 ,1415,1419,750 ,455,456,224 },
		{1018,1014,1006 ,753,1420,1416 ,224,456,455 }, {1019,1015,1007 ,756,1421,1417 ,224,456,455 },
		{1008,1016,1020 ,1418,1422,759 ,455,456,224 }, {1005,1413,1417 ,1415,254,383 ,455,78,116 },
		{1418,1414,1006 ,384,259,1416 ,116,78,455 }, {1419,1415,1007 ,386,262,1417 ,116,78,455 },
		{1008,1416,1420 ,1418,263,390 ,455,78,116 }, {1057,1021,1013 ,782,804,1419 ,239,247,456 },
		{1014,1022,1058 ,1420,805,784 ,456,247,239 }, {1015,1023,1059 ,1421,807,788 ,456,247,239 },
		{1060,1024,1016 ,790,810,1422 ,239,247,456 }, {1053,1057,1013 ,797,782,1419 ,242,239,456 },
		{1014,1058,1054 ,1420,784,799 ,456,239,242 }, {1015,1059,1055 ,1421,788,800 ,456,239,242 },
		{1056,1060,1016 ,802,790,1422 ,242,239,456 }, {1049,1013,1005 ,791,1419,1415 ,240,456,455 },
		{1006,1014,1050 ,1416,1420,793 ,455,456,240 }, {1007,1015,1051 ,1417,1421,794 ,455,456,240 },
		{1052,1016,1008 ,796,1422,1418 ,240,456,455 }, {1013,1049,1053 ,1419,791,797 ,456,240,242 },
		{1054,1050,1014 ,799,793,1420 ,242,240,456 }, {1055,1051,1015 ,800,794,1421 ,242,240,456 },
		{1016,1052,1056 ,1422,796,802 ,456,240,242 }, {1017,1009,1005 ,750,255,1415 ,224,79,455 },
		{1006,1010,1018 ,1416,258,753 ,455,79,224 }, {1007,1011,1019 ,1417,261,756 ,455,79,224 },
		{1020,1012,1008 ,759,264,1418 ,224,79,455 }, {1409,1009,1017 ,256,255,750 ,80,79,224 },
		{1018,1010,1410 ,753,258,257 ,224,79,80 }, {1019,1011,1411 ,756,261,260 ,224,79,80 },
		{1412,1012,1020 ,265,264,759 ,80,79,224 }, {1017,1013,1021 ,750,1419,804 ,224,456,247 },
		{1022,1014,1018 ,805,1420,753 ,247,456,224 }, {1023,1015,1019 ,807,1421,756 ,247,456,224 },
		{1020,1016,1024 ,759,1422,810 ,224,456,247 }, {1033,1037,1025 ,1407,749,751 ,452,223,225 },
		{1026,1038,1034 ,752,754,1410 ,225,223,452 }, {1027,1039,1035 ,755,757,1412 ,225,223,452 },
		{1036,1040,1028 ,1413,758,760 ,452,223,225 }, {1025,1017,1021 ,751,750,804 ,225,224,247 },
		{1022,1018,1026 ,805,753,752 ,247,224,225 }, {1023,1019,1027 ,807,756,755 ,247,224,225 },
		{1028,1020,1024 ,760,759,810 ,225,224,247 }, {1025,1029,1033 ,751,803,1407 ,225,246,452 },
		{1034,1030,1026 ,1410,806,752 ,452,246,225 }, {1035,1031,1027 ,1412,808,755 ,452,246,225 },
		{1028,1032,1036 ,760,809,1413 ,225,246,452 }, {1029,1025,1021 ,803,751,804 ,246,225,247 },
		{1022,1026,1030 ,805,752,806 ,247,225,246 }, {1023,1027,1031 ,807,755,808 ,247,225,246 },
		{1032,1028,1024 ,809,760,810 ,246,225,247 }, {1041,1037,1033 ,282,749,1407 ,85,223,452 },
		{1034,1038,1042 ,1410,754,283 ,452,223,85 }, {1035,1039,1043 ,1412,757,284 ,452,223,85 },
		{1044,1040,1036 ,285,758,1413 ,85,223,452 }, {1101,1185,1193 ,1423,1424,1425 ,457,458,459 },
		{1194,1186,1102 ,1426,1427,1428 ,459,458,457 }, {1195,1187,1103 ,1429,1430,1431 ,459,458,457 },
		{1104,1188,1196 ,1432,1433,1434 ,457,458,459 }, {1073,1185,1101 ,1435,1424,1423 ,460,458,457 },
		{1102,1186,1074 ,1428,1427,1436 ,457,458,460 }, {1103,1187,1075 ,1431,1430,1437 ,457,458,460 },
		{1076,1188,1104 ,1438,1433,1432 ,460,458,457 }, {1177,1181,1077 ,1439,1440,1441 ,461,462,463 },
		{1078,1182,1178 ,1442,1443,1444 ,463,462,461 }, {1079,1183,1179 ,1445,1446,1447 ,463,462,461 },
		{1180,1184,1080 ,1448,1449,1450 ,461,462,463 }, {1185,1073,1181 ,1424,1435,1440 ,458,460,462 },
		{1182,1074,1186 ,1443,1436,1427 ,462,460,458 }, {1183,1075,1187 ,1446,1437,1430 ,462,460,458 },
		{1188,1076,1184 ,1433,1438,1449 ,458,460,462 }, {1181,1073,1077 ,1440,1435,1441 ,462,460,463 },
		{1078,1074,1182 ,1442,1436,1443 ,463,460,462 }, {1079,1075,1183 ,1445,1437,1446 ,463,460,462 },
		{1184,1076,1080 ,1449,1438,1450 ,462,460,463 }, {1069,1073,1357 ,1307,1451,310 ,464,460,465 },
		{1358,1074,1070 ,313,1452,1308 ,465,460,464 }, {1359,1075,1071 ,315,1453,1309 ,465,460,464 },
		{1072,1076,1360 ,1310,1454,316 ,464,460,465 }, {1101,1357,1073 ,1423,310,1451 ,457,465,460 },
		{1074,1358,1102 ,1452,313,1428 ,460,465,457 }, {1075,1359,1103 ,1453,315,1431 ,460,465,457 },
		{1104,1360,1076 ,1432,316,1454 ,457,465,460 }, {1069,1077,1073 ,1307,1455,1451 ,464,463,460 },
		{1074,1078,1070 ,1452,1456,1308 ,460,463,464 }, {1075,1079,1071 ,1453,1457,1309 ,460,463,464 },
		{1072,1080,1076 ,1310,1458,1454 ,464,463,460 }, {1081,1077,1069 ,1295,1455,1307 ,466,463,464 },
		{1070,1078,1082 ,1308,1456,1300 ,464,463,466 }, {1071,1079,1083 ,1309,1457,1303 ,464,463,466 },
		{1084,1080,1072 ,1304,1458,1310 ,466,463,464 }, {1085,1077,1081 ,1459,1455,1295 ,467,463,466 },
		{1082,1078,1086 ,1300,1456,1460 ,466,463,467 }, {1083,1079,1087 ,1303,1457,1461 ,466,463,467 },
		{1088,1080,1084 ,1462,1458,1304 ,467,463,466 }, {1177,1077,1085 ,1439,1441,1463 ,461,463,467 },
		{1086,1078,1178 ,1464,1442,1444 ,467,463,461 }, {1087,1079,1179 ,1465,1445,1447 ,467,463,461 },
		{1180,1080,1088 ,1448,1450,1466 ,461,463,467 }, {1085,1173,1177 ,1463,681,1439 ,467,198,461 },
		{1178,1174,1086 ,1444,684,1464 ,461,198,467 }, {1179,1175,1087 ,1447,685,1465 ,461,198,467 },
		{1088,1176,1180 ,1466,686,1448 ,467,198,461 }, {1089,1173,1085 ,700,681,1463 ,205,198,467 },
		{1086,1174,1090 ,1464,684,702 ,467,198,205 }, {1087,1175,1091 ,1465,685,703 ,467,198,205 },
		{1092,1176,1088 ,704,686,1466 ,205,198,467 }, {1089,1085,1097 ,705,1459,1311 ,205,467,468 },
		{1098,1086,1090 ,1312,1460,707 ,468,467,205 }, {1099,1087,1091 ,1313,1461,709 ,468,467,205 },
		{1092,1088,1100 ,710,1462,1314 ,205,467,468 }, {1085,1081,1097 ,1459,1295,1311 ,467,466,468 },
		{1098,1082,1086 ,1312,1300,1460 ,468,466,467 }, {1099,1083,1087 ,1313,1303,1461 ,468,466,467 },
		{1088,1084,1100 ,1462,1304,1314 ,467,466,468 }, {1097,1093,1089 ,1311,687,705 ,468,207,205 },
		{1090,1094,1098 ,707,692,1312 ,205,207,468 }, {1091,1095,1099 ,709,695,1313 ,205,207,468 },
		{1100,1096,1092 ,1314,697,710 ,468,207,205 }, {1353,1101,1105 ,546,1423,568 ,157,457,159 },
		{1106,1102,1354 ,569,1428,551 ,159,457,157 }, {1107,1103,1355 ,572,1431,554 ,159,457,157 },
		{1356,1104,1108 ,555,1432,577 ,157,457,159 }, {1105,1101,1193 ,568,1423,1425 ,159,457,459 },
		{1194,1102,1106 ,1426,1428,569 ,459,457,159 }, {1195,1103,1107 ,1429,1431,572 ,459,457,159 },
		{1108,1104,1196 ,577,1432,1434 ,159,457,459 }, {1193,1201,1105 ,1425,566,568 ,459,161,159 },
		{1106,1202,1194 ,569,571,1426 ,159,161,459 }, {1107,1203,1195 ,572,574,1429 ,159,161,459 },
		{1196,1204,1108 ,1434,575,577 ,459,161,159 }, {1357,1101,1353 ,310,1423,546 ,465,457,157 },
		{1354,1102,1358 ,551,1428,313 ,157,457,465 }, {1355,1103,1359 ,554,1431,315 ,157,457,465 },
		{1360,1104,1356 ,316,1432,555 ,465,457,157 }, {1109,1125,1117 ,547,527,1229 ,158,150,372 },
		{1118,1126,1110 ,1232,528,550 ,372,150,158 }, {1119,1127,1111 ,1234,530,553 ,372,150,158 },
		{1112,1128,1120 ,556,533,1235 ,158,150,372 }, {1109,1113,1125 ,547,1467,527 ,158,160,150 },
		{1126,1114,1110 ,528,1468,550 ,150,160,158 }, {1127,1115,1111 ,530,1469,553 ,150,160,158 },
		{1112,1116,1128 ,556,1470,533 ,158,160,150 }, {1197,1125,1201 ,534,516,566 ,152,150,161 },
		{1202,1126,1198 ,571,517,535 ,161,150,152 }, {1203,1127,1199 ,574,520,536 ,161,150,152 },
		{1200,1128,1204 ,537,525,575 ,152,150,161 }, {1125,1113,1201 ,516,567,566 ,150,160,161 },
		{1202,1114,1126 ,571,570,517 ,161,160,150 }, {1203,1115,1127 ,574,573,520 ,161,160,150 },
		{1128,1116,1204 ,525,576,575 ,150,160,161 }, {1129,1117,1121 ,542,1229,515 ,155,373,156 },
		{1122,1118,1130 ,518,1232,543 ,156,373,155 }, {1123,1119,1131 ,521,1234,544 ,156,373,155 },
		{1132,1120,1124 ,545,1235,524 ,155,373,156 }, {1117,1125,1121 ,1229,527,1471 ,372,150,149 },
		{1122,1126,1118 ,1472,528,1232 ,149,150,372 }, {1123,1127,1119 ,1473,530,1234 ,149,150,372 },
		{1120,1128,1124 ,1235,533,1474 ,372,150,149 }, {1137,1129,1133 ,1242,542,538 ,374,155,154 },
		{1134,1130,1138 ,539,543,1243 ,154,155,374 }, {1135,1131,1139 ,540,544,1245 ,154,155,374 },
		{1140,1132,1136 ,1248,545,541 ,374,155,154 }, {1141,1137,1133 ,514,1242,1475 ,148,378,153 },
		{1134,1138,1142 ,1476,1243,519 ,153,378,148 }, {1135,1139,1143 ,1477,1245,522 ,153,378,148 },
		{1144,1140,1136 ,523,1248,1478 ,148,378,153 }, {1149,1157,1141 ,901,1261,514 ,276,275,148 },
		{1142,1158,1150 ,519,1262,902 ,148,275,276 }, {1143,1159,1151 ,522,1263,903 ,148,275,276 },
		{1152,1160,1144 ,904,1264,523 ,276,275,148 }, {1157,1137,1141 ,1261,1242,514 ,275,378,148 },
		{1142,1138,1158 ,519,1243,1262 ,148,378,275 }, {1143,1139,1159 ,522,1245,1263 ,148,378,275 },
		{1160,1140,1144 ,1264,1248,523 ,275,378,148 }, {1149,1141,1145 ,901,514,526 ,276,148,151 },
		{1146,1142,1150 ,529,519,902 ,151,148,276 }, {1147,1143,1151 ,531,522,903 ,151,148,276 },
		{1152,1144,1148 ,904,523,532 ,276,148,151 }, {1197,1205,1149 ,534,633,901 ,152,184,276 },
		{1150,1206,1198 ,902,634,535 ,276,184,152 }, {1151,1207,1199 ,903,635,536 ,276,184,152 },
		{1200,1208,1152 ,537,636,904 ,152,184,276 }, {1149,1145,1197 ,901,526,534 ,276,151,152 },
		{1198,1146,1150 ,535,529,902 ,152,151,276 }, {1199,1147,1151 ,536,531,903 ,152,151,276 },
		{1152,1148,1200 ,904,532,537 ,276,151,152 }, {1153,1157,1213 ,1479,893,893 ,379,275,172 },
		{1214,1158,1154 ,896,896,1480 ,172,275,379 }, {1215,1159,1155 ,898,898,1481 ,172,275,379 },
		{1156,1160,1216 ,1482,899,899 ,379,275,172 }, {1265,1161,1325 ,1483,1483,1483 ,283,282,286 },
		{1326,1162,1266 ,1484,1484,1484 ,286,282,283 }, {1327,1163,1267 ,1485,1485,1485 ,286,282,283 },
		{1268,1164,1328 ,1486,1486,1486 ,283,282,286 }, {1171,1167,1173 ,394,396,681 ,121,123,198 },
		{1174,1168,1172 ,684,397,399 ,198,123,121 }, {1175,1169,1171 ,685,400,394 ,198,123,121 },
		{1172,1170,1176 ,399,401,686 ,121,123,198 }, {1177,1173,1167 ,1439,681,396 ,461,198,123 },
		{1168,1174,1178 ,397,684,1444 ,123,198,461 }, {1169,1175,1179 ,400,685,1447 ,123,198,461 },
		{1180,1176,1170 ,1448,686,401 ,461,198,123 }, {1177,1167,1189 ,1439,396,342 ,461,123,183 },
		{1190,1168,1178 ,342,397,1444 ,183,123,461 }, {1191,1169,1179 ,342,400,1447 ,183,123,461 },
		{1180,1170,1192 ,1448,401,342 ,461,123,183 }, {1189,1185,1181 ,342,1424,1440 ,183,458,462 },
		{1182,1186,1190 ,1443,1427,342 ,462,458,183 }, {1183,1187,1191 ,1446,1430,342 ,462,458,183 },
		{1192,1188,1184 ,342,1433,1449 ,183,458,462 }, {1181,1177,1189 ,1440,1439,342 ,462,461,183 },
		{1190,1178,1182 ,342,1444,1443 ,183,461,462 }, {1191,1179,1183 ,342,1447,1446 ,183,461,462 },
		{1184,1180,1192 ,1449,1448,342 ,462,461,183 }, {1185,1189,1193 ,1424,342,1425 ,458,183,459 },
		{1194,1190,1186 ,1426,342,1427 ,459,183,458 }, {1195,1191,1187 ,1429,342,1430 ,459,183,458 },
		{1188,1192,1196 ,1433,342,1434 ,458,183,459 }, {1193,1189,1209 ,1425,342,342 ,459,183,173 },
		{1210,1190,1194 ,342,342,1426 ,173,183,459 }, {1211,1191,1195 ,342,342,1429 ,173,183,459 },
		{1196,1192,1212 ,1434,342,342 ,459,183,173 }, {1193,1209,1201 ,1425,342,566 ,459,173,161 },
		{1202,1210,1194 ,571,342,1426 ,161,173,459 }, {1203,1211,1195 ,574,342,1429 ,161,173,459 },
		{1196,1212,1204 ,1434,342,575 ,459,173,161 }, {1197,1201,1205 ,534,566,633 ,152,161,184 },
		{1206,1202,1198 ,634,571,535 ,184,161,152 }, {1207,1203,1199 ,635,574,536 ,184,161,152 },
		{1200,1204,1208 ,537,575,636 ,152,161,184 }, {1209,1205,1201 ,342,633,566 ,173,184,161 },
		{1202,1206,1210 ,571,634,342 ,161,184,173 }, {1203,1207,1211 ,574,635,342 ,161,184,173 },
		{1212,1208,1204 ,342,636,575 ,173,184,161 }, {1237,1241,1229 ,1026,877,853 ,323,272,268 },
		{1230,1242,1238 ,854,880,1027 ,268,272,323 }, {1231,1243,1239 ,855,882,1029 ,268,272,323 },
		{1240,1244,1232 ,1032,883,856 ,323,272,268 }, {1253,1249,1245 ,1025,1138,1137 ,322,348,347 },
		{1246,1250,1254 ,1142,1141,1028 ,347,348,322 }, {1247,1251,1255 ,1145,1144,1030 ,347,348,322 },
		{1256,1252,1248 ,1031,1147,1146 ,322,348,347 }, {1233,1229,1241 ,857,853,877 ,269,268,272 },
		{1242,1230,1234 ,880,854,860 ,272,268,269 }, {1243,1231,1235 ,882,855,862 ,272,268,269 },
		{1236,1232,1244 ,863,856,883 ,269,268,272 }, {1253,1241,1237 ,1025,877,1026 ,322,272,323 },
		{1238,1242,1254 ,1027,880,1028 ,323,272,322 }, {1239,1243,1255 ,1029,882,1030 ,323,272,322 },
		{1256,1244,1240 ,1031,883,1032 ,322,272,323 }, {1253,1245,1241 ,1025,1137,877 ,322,347,272 },
		{1242,1246,1254 ,880,1142,1028 ,272,347,322 }, {1243,1247,1255 ,882,1145,1030 ,272,347,322 },
		{1256,1248,1244 ,1031,1146,883 ,322,347,272 }, {1257,1249,1261 ,1126,1138,342 ,346,348,250 },
		{1262,1250,1258 ,342,1141,1127 ,250,348,346 }, {1263,1251,1259 ,342,1144,1129 ,250,348,346 },
		{1260,1252,1264 ,1132,1147,342 ,346,348,250 }, {1253,1261,1249 ,1025,342,1138 ,322,250,348 },
		{1250,1262,1254 ,1141,342,1028 ,348,250,322 }, {1251,1263,1255 ,1144,342,1030 ,348,250,322 },
		{1256,1264,1252 ,1031,342,1147 ,322,250,348 }, {1261,1285,1257 ,342,823,1126 ,250,254,346 },
		{1258,1286,1262 ,1127,824,342 ,346,254,250 }, {1259,1287,1263 ,1129,825,342 ,346,254,250 },
		{1264,1288,1260 ,342,826,1132 ,250,254,346 }, {1285,1281,1277 ,823,816,1163 ,254,251,352 },
		{1278,1282,1286 ,1164,818,824 ,352,251,254 }, {1279,1283,1287 ,1165,820,825 ,352,251,254 },
		{1288,1284,1280 ,826,822,1166 ,254,251,352 }, {1361,1357,1353 ,306,310,546 ,370,465,157 },
		{1354,1358,1362 ,551,313,307 ,157,465,370 }, {1355,1359,1363 ,554,315,308 ,157,465,370 },
		{1364,1360,1356 ,309,316,555 ,370,465,157 }, {1369,1377,1373 ,318,298,323 ,94,89,96 },
		{1374,1378,1370 ,324,299,319 ,96,89,94 }, {1375,1379,1371 ,326,300,320 ,96,89,94 },
		{1372,1380,1376 ,321,301,329 ,94,89,96 }, {1385,1421,1381 ,406,288,302 ,469,88,90 },
		{1382,1422,1386 ,303,289,411 ,90,88,469 }, {1383,1423,1387 ,304,292,414 ,90,88,469 },
		{1388,1424,1384 ,415,297,305 ,469,88,90 }, {1421,1385,1393 ,288,406,2 ,88,469,470 },
		{1394,1386,1422 ,2,411,289 ,470,469,88 }, {1395,1387,1423 ,0,414,292 ,470,469,88 },
		{1424,1388,1396 ,297,415,0 ,88,469,470 }, {1393,1389,1421 ,2,2,288 ,470,231,88 },
		{1422,1390,1394 ,289,2,2 ,88,231,470 }, {1423,1391,1395 ,292,0,0 ,88,231,470 },
		{1396,1392,1424 ,0,0,297 ,470,231,88 }, {1405,1429,1409 ,761,811,256 ,226,248,80 },
		{1410,1430,1406 ,257,812,762 ,80,248,226 }, {1411,1431,1407 ,260,813,763 ,80,248,226 },
		{1408,1432,1412 ,764,814,265 ,226,248,80 }, {1433,1409,1429 ,1487,256,811 ,471,80,248 },
		{1430,1410,1434 ,812,257,1488 ,248,80,471 }, {1431,1411,1435 ,813,260,1489 ,248,80,471 },
		{1436,1412,1432 ,1490,265,814 ,471,80,248 }, {1433,1413,1409 ,1487,254,256 ,471,78,80 },
		{1410,1414,1434 ,257,259,1488 ,80,78,471 }, {1411,1415,1435 ,260,262,1489 ,80,78,471 },
		{1436,1416,1412 ,1490,263,265 ,471,78,80 }, {1413,1433,1437 ,254,1487,381 ,78,471,114 },
		{1438,1434,1414 ,385,1488,259 ,114,471,78 }, {1439,1435,1415 ,388,1489,262 ,114,471,78 },
		{1416,1436,1440 ,263,1490,389 ,78,471,114 }, {1417,1413,1437 ,383,254,381 ,116,78,114 },
		{1438,1414,1418 ,385,259,384 ,114,78,116 }, {1439,1415,1419 ,388,262,386 ,114,78,116 },
		{1420,1416,1440 ,390,263,389 ,116,78,114 }, {801,797,1453 ,393,393,393 ,472,473,474 },
		{798,801,1453 ,393,393,393 ,475,472,474 }, {785,777,1453 ,393,393,393 ,476,477,474 },
		{778,786,1453 ,393,393,393 ,478,479,474 }, {781,771,1453 ,393,393,393 ,480,481,474 },
		{772,782,1453 ,393,393,393 ,482,483,474 }, {771,783,1453 ,393,393,393 ,481,484,474 },
		{784,772,1453 ,393,393,393 ,485,482,474 }, {777,781,1453 ,393,393,393 ,477,480,474 },
		{782,778,1453 ,393,393,393 ,483,478,474 }, {789,793,1453 ,393,393,393 ,486,487,474 },
		{794,790,1453 ,393,393,393 ,488,489,474 }, {773,785,1453 ,393,393,393 ,490,476,474 },
		{786,774,1453 ,393,393,393 ,479,491,474 }, {793,773,1453 ,393,393,393 ,487,490,474 },
		{774,794,1453 ,393,393,393 ,491,488,474 }, {797,789,1453 ,393,393,393 ,473,486,474 },
		{790,798,1453 ,393,393,393 ,489,475,474 }, {799,802,1453 ,393,393,393 ,492,493,474 },
		{802,800,1453 ,393,393,393 ,493,494,474 }, {779,787,1453 ,393,393,393 ,495,496,474 },
		{788,780,1453 ,393,393,393 ,497,498,474 }, {783,779,1453 ,393,393,393 ,484,495,474 },
		{780,784,1453 ,393,393,393 ,498,485,474 }, {795,791,1453 ,393,393,393 ,499,500,474 },
		{792,796,1453 ,393,393,393 ,501,502,474 }, {787,775,1453 ,393,393,393 ,496,503,474 },
		{776,788,1453 ,393,393,393 ,504,497,474 }, {775,795,1453 ,393,393,393 ,503,499,474 },
		{796,776,1453 ,393,393,393 ,502,504,474 }, {791,799,1453 ,393,393,393 ,500,492,474 },
		{800,792,1453 ,393,393,393 ,494,501,474 }, {1457,1461,1455 ,393,393,393 ,505,506,507 },
		{1457,1460,1461 ,393,393,393 ,505,508,506 }, {1454,1461,1459 ,1491,1491,1491 ,509,506,510 },
		{1454,1455,1461 ,1491,1491,1491 ,509,507,506 }, {1456,1459,1458 ,342,342,342 ,511,510,512 },
		{1456,1454,1459 ,342,342,342 ,511,509,510 }, {1456,1460,1457 ,1492,1492,1492 ,511,508,505 },
		{1456,1458,1460 ,1492,1492,1492 ,511,512,508 }, {1454,1457,1455 ,1493,1493,1493 ,509,505,507 },
		{1454,1456,1457 ,1493,1493,1493 ,509,511,505 }, {1467,1468,1466 ,1494,1494,1494 ,509,505,507 },
		{1467,1469,1468 ,1494,1494,1494 ,509,511,505 }, {1469,1462,1468 ,1495,1495,1495 ,511,508,505 },
		{1469,1465,1462 ,1495,1495,1495 ,511,512,508 }, {1469,1464,1465 ,342,342,342 ,511,510,512 },
		{1469,1467,1464 ,342,342,342 ,511,509,510 }, {1467,1463,1464 ,1496,1496,1496 ,509,506,510 },
		{1467,1466,1463 ,1496,1496,1496 ,509,507,506 }, {1468,1463,1466 ,393,393,393 ,505,506,507 },
		{1468,1462,1463 ,393,393,393 ,505,508,506 }, {1471,1476,1473 ,393,393,393 ,505,506,507 },
		{1471,1477,1476 ,393,393,393 ,505,508,506 }, {1472,1476,1475 ,1497,1497,1497 ,509,506,510 },
		{1472,1473,1476 ,1497,1497,1497 ,509,507,506 }, {1470,1475,1474 ,342,342,342 ,511,510,512 },
		{1470,1472,1475 ,342,342,342 ,511,509,510 }, {1470,1477,1471 ,1498,1498,1498 ,511,508,505 },
		{1470,1474,1477 ,1498,1498,1498 ,511,512,508 }, {1472,1471,1473 ,1499,1499,1499 ,509,505,507 },
		{1472,1470,1471 ,1499,1499,1499 ,509,511,505 }, {1483,1484,1482 ,1500,1500,1500 ,509,505,507 },
		{1483,1485,1484 ,1500,1500,1500 ,509,511,505 }, {1485,1478,1484 ,1501,1501,1501 ,511,508,505 },
		{1485,1481,1478 ,1501,1501,1501 ,511,512,508 }, {1485,1480,1481 ,342,342,342 ,511,510,512 },
		{1485,1483,1480 ,342,342,342 ,511,509,510 }, {1483,1479,1480 ,1502,1502,1502 ,509,506,510 },
		{1483,1482,1479 ,1502,1502,1502 ,509,507,506 }, {1484,1479,1482 ,393,393,393 ,505,506,507 },
		{1484,1478,1479 ,393,393,393 ,505,508,506 }, {1487,1492,1489 ,393,393,393 ,505,506,507 },
		{1487,1493,1492 ,393,393,393 ,505,508,506 }, {1488,1492,1491 ,1503,1503,1503 ,509,506,510 },
		{1488,1489,1492 ,1503,1503,1503 ,509,507,506 }, {1486,1491,1490 ,342,342,342 ,511,510,512 },
		{1486,1488,1491 ,342,342,342 ,511,509,510 }, {1486,1493,1487 ,1504,1504,1504 ,511,508,505 },
		{1486,1490,1493 ,1504,1504,1504 ,511,512,508 }, {1488,1487,1489 ,1505,1505,1505 ,509,505,507 },
		{1488,1486,1487 ,1505,1505,1505 ,509,511,505 }, {1499,1500,1498 ,1506,1506,1506 ,509,505,507 },
		{1499,1501,1500 ,1506,1506,1506 ,509,511,505 }, {1501,1494,1500 ,1507,1507,1507 ,511,508,505 },
		{1501,1497,1494 ,1507,1507,1507 ,511,512,508 }, {1501,1496,1497 ,342,342,342 ,511,510,512 },
		{1501,1499,1496 ,342,342,342 ,511,509,510 }, {1499,1495,1496 ,1508,1508,1508 ,509,506,510 },
		{1499,1498,1495 ,1508,1508,1508 ,509,507,506 }, {1500,1495,1498 ,393,393,393 ,505,506,507 },
		{1500,1494,1495 ,393,393,393 ,505,508,506 }, {1503,1508,1505 ,393,393,393 ,505,506,507 },
		{1503,1509,1508 ,393,393,393 ,505,508,506 }, {1504,1508,1507 ,1509,1509,1509 ,509,506,510 },
		{1504,1505,1508 ,1509,1509,1509 ,509,507,506 }, {1502,1507,1506 ,342,342,342 ,511,510,512 },
		{1502,1504,1507 ,342,342,342 ,511,509,510 }, {1502,1509,1503 ,1510,1510,1510 ,511,508,505 },
		{1502,1506,1509 ,1510,1510,1510 ,511,512,508 }, {1504,1503,1505 ,1511,1511,1511 ,509,505,507 },
		{1504,1502,1503 ,1511,1511,1511 ,509,511,505 }, {1515,1516,1514 ,1512,1512,1512 ,509,505,507 },
		{1515,1517,1516 ,1512,1512,1512 ,509,511,505 }, {1517,1510,1516 ,1513,1513,1513 ,511,508,505 },
		{1517,1513,1510 ,1513,1513,1513 ,511,512,508 }, {1517,1512,1513 ,342,342,342 ,511,510,512 },
		{1517,1515,1512 ,342,342,342 ,511,509,510 }, {1515,1511,1512 ,1514,1514,1514 ,509,506,510 },
		{1515,1514,1511 ,1514,1514,1514 ,509,507,506 }, {1516,1511,1514 ,393,393,393 ,505,506,507 },
		{1516,1510,1511 ,393,393,393 ,505,508,506 }, {1519,1524,1521 ,393,393,393 ,505,506,507 },
		{1519,1525,1524 ,393,393,393 ,505,508,506 }, {1520,1524,1523 ,1515,1515,1515 ,509,506,510 },
		{1520,1521,1524 ,1515,1515,1515 ,509,507,506 }, {1518,1523,1522 ,342,342,342 ,511,510,512 },
		{1518,1520,1523 ,342,342,342 ,511,509,510 }, {1518,1525,1519 ,1516,1516,1516 ,511,508,505 },
		{1518,1522,1525 ,1516,1516,1516 ,511,512,508 }, {1520,1519,1521 ,1517,1517,1517 ,509,505,507 },
		{1520,1518,1519 ,1517,1517,1517 ,509,511,505 }, {1531,1532,1530 ,1518,1518,1518 ,509,505,507 },
		{1531,1533,1532 ,1518,1518,1518 ,509,511,505 }, {1533,1526,1532 ,1519,1519,1519 ,511,508,505 },
		{1533,1529,1526 ,1519,1519,1519 ,511,512,508 }, {1533,1528,1529 ,342,342,342 ,511,510,512 },
		{1533,1531,1528 ,342,342,342 ,511,509,510 }, {1531,1527,1528 ,1520,1520,1520 ,509,506,510 },
		{1531,1530,1527 ,1520,1520,1520 ,509,507,506 }, {1532,1527,1530 ,393,393,393 ,505,506,507 },
		{1532,1526,1527 ,393,393,393 ,505,508,506 }, {1535,1540,1537 ,393,393,393 ,505,506,507 },
		{1535,1541,1540 ,393,393,393 ,505,508,506 }, {1536,1540,1539 ,1521,1521,1521 ,509,506,510 },
		{1536,1537,1540 ,1521,1521,1521 ,509,507,506 }, {1534,1539,1538 ,342,342,342 ,511,510,512 },
		{1534,1536,1539 ,342,342,342 ,511,509,510 }, {1534,1541,1535 ,1522,1522,1522 ,511,508,505 },
		{1534,1538,1541 ,1522,1522,1522 ,511,512,508 }, {1536,1535,1537 ,1523,1523,1523 ,509,505,507 },
		{1536,1534,1535 ,1523,1523,1523 ,509,511,505 }, {1547,1548,1546 ,1524,1524,1524 ,509,505,507 },
		{1547,1549,1548 ,1524,1524,1524 ,509,511,505 }, {1549,1542,1548 ,1525,1525,1525 ,511,508,505 },
		{1549,1545,1542 ,1525,1525,1525 ,511,512,508 }, {1549,1544,1545 ,342,342,342 ,511,510,512 },
		{1549,1547,1544 ,342,342,342 ,511,509,510 }, {1547,1543,1544 ,1526,1526,1526 ,509,506,510 },
		{1547,1546,1543 ,1526,1526,1526 ,509,507,506 }, {1548,1543,1546 ,393,393,393 ,505,506,507 },
		{1548,1542,1543 ,393,393,393 ,505,508,506 }, {1551,1556,1553 ,393,393,393 ,505,506,507 },
		{1551,1557,1556 ,393,393,393 ,505,508,506 }, {1552,1556,1555 ,1527,1527,1527 ,509,506,510 },
		{1552,1553,1556 ,1527,1527,1527 ,509,507,506 }, {1550,1555,1554 ,342,342,342 ,511,510,512 },
		{1550,1552,1555 ,342,342,342 ,511,509,510 }, {1550,1557,1551 ,1528,1528,1528 ,511,508,505 },
		{1550,1554,1557 ,1528,1528,1528 ,511,512,508 }, {1552,1551,1553 ,1529,1529,1529 ,509,505,507 },
		{1552,1550,1551 ,1529,1529,1529 ,509,511,505 }, {1563,1564,1562 ,1530,1530,1530 ,509,505,507 },
		{1563,1565,1564 ,1530,1530,1530 ,509,511,505 }, {1565,1558,1564 ,1531,1531,1531 ,511,508,505 },
		{1565,1561,1558 ,1531,1531,1531 ,511,512,508 }, {1565,1560,1561 ,342,342,342 ,511,510,512 },
		{1565,1563,1560 ,342,342,342 ,511,509,510 }, {1563,1559,1560 ,1532,1532,1532 ,509,506,510 },
		{1563,1562,1559 ,1532,1532,1532 ,509,507,506 }, {1564,1559,1562 ,393,393,393 ,505,506,507 },
		{1564,1558,1559 ,393,393,393 ,505,508,506 }, {1567,1572,1569 ,393,393,393 ,505,506,507 },
		{1567,1573,1572 ,393,393,393 ,505,508,506 }, {1568,1572,1571 ,1533,1533,1533 ,509,506,510 },
		{1568,1569,1572 ,1533,1533,1533 ,509,507,506 }, {1566,1571,1570 ,342,342,342 ,511,510,512 },
		{1566,1568,1571 ,342,342,342 ,511,509,510 }, {1566,1573,1567 ,1534,1534,1534 ,511,508,505 },
		{1566,1570,1573 ,1534,1534,1534 ,511,512,508 }, {1568,1567,1569 ,1535,1535,1535 ,509,505,507 },
		{1568,1566,1567 ,1535,1535,1535 ,509,511,505 }, {1579,1580,1578 ,1536,1536,1536 ,509,505,507 },
		{1579,1581,1580 ,1536,1536,1536 ,509,511,505 }, {1581,1574,1580 ,1537,1537,1537 ,511,508,505 },
		{1581,1577,1574 ,1537,1537,1537 ,511,512,508 }, {1581,1576,1577 ,342,342,342 ,511,510,512 },
		{1581,1579,1576 ,342,342,342 ,511,509,510 }, {1579,1575,1576 ,1538,1538,1538 ,509,506,510 },
		{1579,1578,1575 ,1538,1538,1538 ,509,507,506 }, {1580,1575,1578 ,393,393,393 ,505,506,507 },
		{1580,1574,1575 ,393,393,393 ,505,508,506 }, {1583,1588,1585 ,393,393,393 ,505,506,507 },
		{1583,1589,1588 ,393,393,393 ,505,508,506 }, {1584,1588,1587 ,1539,1539,1539 ,509,506,510 },
		{1584,1585,1588 ,1539,1539,1539 ,509,507,506 }, {1582,1587,1586 ,342,342,342 ,511,510,512 },
		{1582,1584,1587 ,342,342,342 ,511,509,510 }, {1582,1589,1583 ,1540,1540,1540 ,511,508,505 },
		{1582,1586,1589 ,1540,1540,1540 ,511,512,508 }, {1584,1583,1585 ,1541,1541,1541 ,509,505,507 },
		{1584,1582,1583 ,1541,1541,1541 ,509,511,505 }, {1595,1596,1594 ,1542,1542,1542 ,509,505,507 },
		{1595,1597,1596 ,1542,1542,1542 ,509,511,505 }, {1597,1590,1596 ,1543,1543,1543 ,511,508,505 },
		{1597,1593,1590 ,1543,1543,1543 ,511,512,508 }, {1597,1592,1593 ,342,342,342 ,511,510,512 },
		{1597,1595,1592 ,342,342,342 ,511,509,510 }, {1595,1591,1592 ,1544,1544,1544 ,509,506,510 },
		{1595,1594,1591 ,1544,1544,1544 ,509,507,506 }, {1596,1591,1594 ,393,393,393 ,505,506,507 },
		{1596,1590,1591 ,393,393,393 ,505,508,506 }, {1599,1604,1601 ,393,393,393 ,505,506,507 },
		{1599,1605,1604 ,393,393,393 ,505,508,506 }, {1600,1604,1603 ,1545,1545,1545 ,509,506,510 },
		{1600,1601,1604 ,1545,1545,1545 ,509,507,506 }, {1598,1603,1602 ,342,342,342 ,511,510,512 },
		{1598,1600,1603 ,342,342,342 ,511,509,510 }, {1598,1605,1599 ,1546,1546,1546 ,511,508,505 },
		{1598,1602,1605 ,1546,1546,1546 ,511,512,508 }, {1600,1599,1601 ,1547,1547,1547 ,509,505,507 },
		{1600,1598,1599 ,1547,1547,1547 ,509,511,505 }, {1611,1612,1610 ,1548,1548,1548 ,509,505,507 },
		{1611,1613,1612 ,1548,1548,1548 ,509,511,505 }, {1613,1606,1612 ,1549,1549,1549 ,511,508,505 },
		{1613,1609,1606 ,1549,1549,1549 ,511,512,508 }, {1613,1608,1609 ,342,342,342 ,511,510,512 },
		{1613,1611,1608 ,342,342,342 ,511,509,510 }, {1611,1607,1608 ,1550,1550,1550 ,509,506,510 },
		{1611,1610,1607 ,1550,1550,1550 ,509,507,506 }, {1612,1607,1610 ,393,393,393 ,505,506,507 },
		{1612,1606,1607 ,393,393,393 ,505,508,506 }, {1615,1620,1617 ,393,393,393 ,505,506,507 },
		{1615,1621,1620 ,393,393,393 ,505,508,506 }, {1616,1620,1619 ,1551,1551,1551 ,509,506,510 },
		{1616,1617,1620 ,1551,1551,1551 ,509,507,506 }, {1614,1619,1618 ,342,342,342 ,511,510,512 },
		{1614,1616,1619 ,342,342,342 ,511,509,510 }, {1614,1621,1615 ,1552,1552,1552 ,511,508,505 },
		{1614,1618,1621 ,1552,1552,1552 ,511,512,508 }, {1616,1615,1617 ,1553,1553,1553 ,509,505,507 },
		{1616,1614,1615 ,1553,1553,1553 ,509,511,505 }, {1627,1628,1626 ,1554,1554,1554 ,509,505,507 },
		{1627,1629,1628 ,1554,1554,1554 ,509,511,505 }, {1629,1622,1628 ,1555,1555,1555 ,511,508,505 },
		{1629,1625,1622 ,1555,1555,1555 ,511,512,508 }, {1629,1624,1625 ,342,342,342 ,511,510,512 },
		{1629,1627,1624 ,342,342,342 ,511,509,510 }, {1627,1623,1624 ,1556,1556,1556 ,509,506,510 },
		{1627,1626,1623 ,1556,1556,1556 ,509,507,506 }, {1628,1623,1626 ,393,393,393 ,505,506,507 },
		{1628,1622,1623 ,393,393,393 ,505,508,506 }, {1631,1636,1633 ,393,393,393 ,505,506,507 },
		{1631,1637,1636 ,393,393,393 ,505,508,506 }, {1632,1636,1635 ,1557,1557,1557 ,509,506,510 },
		{1632,1633,1636 ,1557,1557,1557 ,509,507,506 }, {1630,1635,1634 ,342,342,342 ,511,510,512 },
		{1630,1632,1635 ,342,342,342 ,511,509,510 }, {1630,1637,1631 ,1558,1558,1558 ,511,508,505 },
		{1630,1634,1637 ,1558,1558,1558 ,511,512,508 }, {1632,1631,1633 ,1559,1559,1559 ,509,505,507 },
		{1632,1630,1631 ,1559,1559,1559 ,509,511,505 }, {1643,1644,1642 ,1560,1560,1560 ,509,505,507 },
		{1643,1645,1644 ,1560,1560,1560 ,509,511,505 }, {1645,1638,1644 ,1561,1561,1561 ,511,508,505 },
		{1645,1641,1638 ,1561,1561,1561 ,511,512,508 }, {1645,1640,1641 ,342,342,342 ,511,510,512 },
		{1645,1643,1640 ,342,342,342 ,511,509,510 }, {1643,1639,1640 ,1562,1562,1562 ,509,506,510 },
		{1643,1642,1639 ,1562,1562,1562 ,509,507,506 }, {1644,1639,1642 ,393,393,393 ,505,506,507 },
		{1644,1638,1639 ,393,393,393 ,505,508,506 }, {1647,1652,1649 ,393,393,393 ,505,506,507 },
		{1647,1653,1652 ,393,393,393 ,505,508,506 }, {1648,1652,1651 ,1563,1563,1563 ,509,506,510 },
		{1648,1649,1652 ,1563,1563,1563 ,509,507,506 }, {1646,1651,1650 ,342,342,342 ,511,510,512 },
		{1646,1648,1651 ,342,342,342 ,511,509,510 }, {1646,1653,1647 ,1564,1564,1564 ,511,508,505 },
		{1646,1650,1653 ,1564,1564,1564 ,511,512,508 }, {1648,1647,1649 ,1565,1565,1565 ,509,505,507 },
		{1648,1646,1647 ,1565,1565,1565 ,509,511,505 }
	};
	static GLfloat vertices [1654][3] = {
	{1.8138f,-2.22779f,2.79854f},{1.8138f,2.22779f,2.79854f},{-1.8138f,-2.22779f,2.79854f},
	{-1.8138f,2.22779f,2.79854f},{1.8138f,-2.28106f,2.25764f},{1.8138f,-2.28106f,3.34236f},
	{1.8138f,2.28106f,2.25764f},{1.8138f,2.28106f,3.34236f},{-1.8138f,-2.28106f,2.25764f},
	{-1.8138f,-2.28106f,3.34236f},{-1.8138f,2.28106f,2.25764f},{-1.8138f,2.28106f,3.34236f},
	{1.8138f,-2.43883f,1.73752f},{1.8138f,-2.43883f,3.86247f},{1.8138f,2.43883f,1.73752f},
	{1.8138f,2.43883f,3.86247f},{-1.8138f,-2.43883f,1.73752f},{-1.8138f,-2.43883f,3.86247f},
	{-1.8138f,2.43883f,1.73752f},{-1.8138f,2.43883f,3.86247f},{1.8138f,-2.69504f,1.25819f},
	{1.8138f,-2.69504f,4.34181f},{1.8138f,2.69504f,1.25819f},{1.8138f,2.69504f,4.34181f},
	{-1.8138f,-2.69504f,1.25819f},{-1.8138f,-2.69504f,4.34181f},{-1.8138f,2.69504f,1.25819f},
	{-1.8138f,2.69504f,4.34181f},{1.8138f,-3.03985f,0.838045f},{1.8138f,-3.03985f,4.76195f},
	{1.8138f,3.03985f,0.838045f},{1.8138f,3.03985f,4.76195f},{-1.8138f,-3.03985f,0.838045f},
	{-1.8138f,-3.03985f,4.76195f},{-1.8138f,3.03985f,0.838045f},{-1.8138f,3.03985f,4.76195f},
	{1.8138f,-3.45999f,0.493242f},{1.8138f,-3.45999f,5.10676f},{1.8138f,3.45999f,0.493242f},
	{1.8138f,3.45999f,5.10676f},{-1.8138f,-3.45999f,0.493242f},{-1.8138f,-3.45999f,5.10676f},
	{-1.8138f,3.45999f,0.493242f},{-1.8138f,3.45999f,5.10676f},{1.8138f,-3.93933f,0.237031f},
	{1.8138f,-3.93933f,5.36297f},{1.8138f,3.93933f,0.237031f},{1.8138f,3.93933f,5.36297f},
	{-1.8138f,-3.93933f,0.237031f},{-1.8138f,-3.93933f,5.36297f},{-1.8138f,3.93933f,0.237031f},
	{-1.8138f,3.93933f,5.36297f},{1.8138f,-4.45944f,0.079257f},{1.8138f,-4.45944f,5.52074f},
	{1.8138f,4.45944f,0.079257f},{1.8138f,4.45944f,5.52074f},{-1.8138f,-4.45944f,0.079257f},
	{-1.8138f,-4.45944f,5.52074f},{-1.8138f,4.45944f,0.079257f},{-1.8138f,4.45944f,5.52074f},
	{1.8138f,-5.00034f,0.025983f},{1.8138f,-5.00034f,5.57402f},{1.8138f,5.00034f,0.025983f},
	{1.8138f,5.00034f,5.57402f},{-1.8138f,-5.00034f,0.025983f},{-1.8138f,-5.00034f,5.57402f},
	{-1.8138f,5.00034f,0.025983f},{-1.8138f,5.00034f,5.57402f},{1.8138f,-5.54123f,0.079257f},
	{1.8138f,-5.54123f,5.52074f},{1.8138f,5.54123f,0.079257f},{1.8138f,5.54123f,5.52074f},
	{-1.8138f,-5.54123f,0.079257f},{-1.8138f,-5.54123f,5.52074f},{-1.8138f,5.54123f,0.079257f},
	{-1.8138f,5.54123f,5.52074f},{1.8138f,-6.06135f,0.237032f},{1.8138f,-6.06135f,5.36297f},
	{1.8138f,6.06135f,0.237032f},{1.8138f,6.06135f,5.36297f},{-1.8138f,-6.06135f,0.237032f},
	{-1.8138f,-6.06135f,5.36297f},{-1.8138f,6.06135f,0.237032f},{-1.8138f,6.06135f,5.36297f},
	{1.8138f,-6.54069f,0.493243f},{1.8138f,-6.54069f,5.10676f},{1.8138f,6.54069f,0.493243f},
	{1.8138f,6.54069f,5.10676f},{-1.8138f,-6.54069f,0.493243f},{-1.8138f,-6.54069f,5.10676f},
	{-1.8138f,6.54069f,0.493243f},{-1.8138f,6.54069f,5.10676f},{1.8138f,-6.96083f,0.838046f},
	{1.8138f,-6.96083f,4.76195f},{1.8138f,6.96083f,0.838046f},{1.8138f,6.96083f,4.76195f},
	{-1.8138f,-6.96083f,0.838046f},{-1.8138f,-6.96083f,4.76195f},{-1.8138f,6.96083f,0.838046f},
	{-1.8138f,6.96083f,4.76195f},{1.8138f,-7.30563f,1.25819f},{1.8138f,-7.30563f,4.34181f},
	{1.8138f,7.30563f,1.25819f},{1.8138f,7.30563f,4.34181f},{-1.8138f,-7.30563f,1.25819f},
	{-1.8138f,-7.30563f,4.34181f},{-1.8138f,7.30563f,1.25819f},{-1.8138f,7.30563f,4.34181f},
	{1.8138f,-7.56184f,1.73753f},{1.8138f,-7.56184f,3.86247f},{1.8138f,7.56184f,1.73753f},
	{1.8138f,7.56184f,3.86247f},{-1.8138f,-7.56184f,1.73753f},{-1.8138f,-7.56184f,3.86247f},
	{-1.8138f,7.56184f,1.73753f},{-1.8138f,7.56184f,3.86247f},{1.8138f,-7.71961f,2.25764f},
	{1.8138f,-7.71961f,3.34236f},{1.8138f,7.71961f,2.25764f},{1.8138f,7.71961f,3.34236f},
	{-1.8138f,-7.71961f,2.25764f},{-1.8138f,-7.71961f,3.34236f},{-1.8138f,7.71961f,2.25764f},
	{-1.8138f,7.71961f,3.34236f},{1.8138f,-7.77289f,2.79854f},{1.8138f,7.77289f,2.79854f},
	{-1.8138f,-7.77289f,2.79854f},{-1.8138f,7.77289f,2.79854f},{4.96148f,-2.22779f,2.79853f},
	{4.96148f,2.22779f,2.79853f},{-4.96148f,-2.22779f,2.79853f},{-4.96148f,2.22779f,2.79853f},
	{4.96148f,-2.28106f,2.25763f},{4.96148f,-2.28106f,3.34237f},{4.96148f,2.28106f,2.25763f},
	{4.96148f,2.28106f,3.34237f},{-4.96148f,-2.28106f,2.25763f},{-4.96148f,-2.28106f,3.34237f},
	{-4.96148f,2.28106f,2.25763f},{-4.96148f,2.28106f,3.34237f},{4.96148f,-2.43883f,1.73752f},
	{4.96148f,-2.43883f,3.86248f},{4.96148f,2.43883f,1.73752f},{4.96148f,2.43883f,3.86248f},
	{-4.96148f,-2.43883f,1.73752f},{-4.96148f,-2.43883f,3.86248f},{-4.96148f,2.43883f,1.73752f},
	{-4.96148f,2.43883f,3.86248f},{4.96148f,-2.69505f,1.25819f},{4.96148f,-2.69505f,4.34181f},
	{4.96148f,2.69505f,1.25819f},{4.96148f,2.69505f,4.34181f},{-4.96148f,-2.69505f,1.25819f},
	{-4.96148f,-2.69505f,4.34181f},{-4.96148f,2.69505f,1.25819f},{-4.96148f,2.69505f,4.34181f},
	{4.96148f,-3.03985f,0.838043f},{4.96148f,-3.03985f,4.76196f},{4.96148f,3.03985f,0.838043f},
	{4.96148f,3.03985f,4.76196f},{-4.96148f,-3.03985f,0.838043f},{-4.96148f,-3.03985f,4.76196f},
	{-4.96148f,3.03985f,0.838043f},{-4.96148f,3.03985f,4.76196f},{4.96148f,-3.45999f,0.493242f},
	{4.96148f,-3.45999f,5.10676f},{4.96148f,3.45999f,0.493242f},{4.96148f,3.45999f,5.10676f},
	{-4.96148f,-3.45999f,0.493242f},{-4.96148f,-3.45999f,5.10676f},{-4.96148f,3.45999f,0.493242f},
	{-4.96148f,3.45999f,5.10676f},{4.96148f,-3.93933f,0.237031f},{4.96148f,-3.93933f,5.36297f},
	{4.96148f,3.93933f,0.237031f},{4.96148f,3.93933f,5.36297f},{-4.96148f,-3.93933f,0.237031f},
	{-4.96148f,-3.93933f,5.36297f},{-4.96148f,3.93933f,0.237031f},{-4.96148f,3.93933f,5.36297f},
	{4.96148f,-4.45944f,0.079257f},{4.96148f,-4.45944f,5.52074f},{4.96148f,4.45944f,0.079257f},
	{4.96148f,4.45944f,5.52074f},{-4.96148f,-4.45944f,0.079257f},{-4.96148f,-4.45944f,5.52074f},
	{-4.96148f,4.45944f,0.079257f},{-4.96148f,4.45944f,5.52074f},{4.96148f,-5.00033f,0.025983f},
	{4.96148f,-5.00033f,5.57402f},{4.96148f,5.00033f,0.025983f},{4.96148f,5.00033f,5.57402f},
	{-4.96148f,-5.00033f,0.025983f},{-4.96148f,-5.00033f,5.57402f},{-4.96148f,5.00033f,0.025983f},
	{-4.96148f,5.00033f,5.57402f},{4.96148f,-5.54123f,0.079256f},{4.96148f,-5.54123f,5.52074f},
	{4.96148f,5.54123f,0.079256f},{4.96148f,5.54123f,5.52074f},{-4.96148f,-5.54123f,0.079256f},
	{-4.96148f,-5.54123f,5.52074f},{-4.96148f,5.54123f,0.079256f},{-4.96148f,5.54123f,5.52074f},
	{4.96148f,-6.06134f,0.237029f},{4.96148f,-6.06134f,5.36297f},{4.96148f,6.06134f,0.237029f},
	{4.96148f,6.06134f,5.36297f},{-4.96148f,-6.06134f,0.237029f},{-4.96148f,-6.06134f,5.36297f},
	{-4.96148f,6.06134f,0.237029f},{-4.96148f,6.06134f,5.36297f},{4.96148f,-6.54068f,0.493239f},
	{4.96148f,-6.54068f,5.10676f},{4.96148f,6.54068f,0.493239f},{4.96148f,6.54068f,5.10676f},
	{-4.96148f,-6.54068f,0.493239f},{-4.96148f,-6.54068f,5.10676f},{-4.96148f,6.54068f,0.493239f},
	{-4.96148f,6.54068f,5.10676f},{4.96148f,-6.96082f,0.83804f},{4.96148f,-6.96082f,4.76196f},
	{4.96148f,6.96082f,0.83804f},{4.96148f,6.96082f,4.76196f},{-4.96148f,-6.96082f,0.83804f},
	{-4.96148f,-6.96082f,4.76196f},{-4.96148f,6.96082f,0.83804f},{-4.96148f,6.96082f,4.76196f},
	{4.96148f,-7.30562f,1.25818f},{4.96148f,-7.30562f,4.34182f},{4.96148f,7.30562f,1.25818f},
	{4.96148f,7.30562f,4.34182f},{-4.96148f,-7.30562f,1.25818f},{-4.96148f,-7.30562f,4.34182f},
	{-4.96148f,7.30562f,1.25818f},{-4.96148f,7.30562f,4.34182f},{4.96148f,-7.56184f,1.73752f},
	{4.96148f,-7.56184f,3.86248f},{4.96148f,7.56184f,1.73752f},{4.96148f,7.56184f,3.86248f},
	{-4.96148f,-7.56184f,1.73752f},{-4.96148f,-7.56184f,3.86248f},{-4.96148f,7.56184f,1.73752f},
	{-4.96148f,7.56184f,3.86248f},{4.96148f,-7.71961f,2.25763f},{4.96148f,-7.71961f,3.34237f},
	{4.96148f,7.71961f,2.25763f},{4.96148f,7.71961f,3.34237f},{-4.96148f,-7.71961f,2.25763f},
	{-4.96148f,-7.71961f,3.34237f},{-4.96148f,7.71961f,2.25763f},{-4.96148f,7.71961f,3.34237f},
	{4.96148f,-7.77289f,2.79852f},{4.96148f,7.77289f,2.79852f},{-4.96148f,-7.77289f,2.79852f},
	{-4.96148f,7.77289f,2.79852f},{1.8138f,-5.00034f,2.79854f},{1.8138f,5.00034f,2.79854f},
	{-1.8138f,-5.00034f,2.79854f},{-1.8138f,5.00034f,2.79854f},{4.96148f,-5.00034f,2.79854f},
	{4.96148f,5.00034f,2.79854f},{-4.96148f,-5.00034f,2.79854f},{-4.96148f,5.00034f,2.79854f},
	{4.96148f,-0.000342f,0.030289f},{4.96148f,-0.000342f,5.56971f},{-4.96148f,-0.000342f,0.030289f},
	{-4.96148f,-0.000342f,5.56971f},{1.8138f,-0.000342f,0.030289f},{1.8138f,-0.000342f,5.56971f},
	{-1.8138f,-0.000342f,0.030289f},{-1.8138f,-0.000342f,5.56971f},{4.96148f,-0.000342f,0.241337f},
	{4.96148f,-0.000342f,5.35866f},{-4.96148f,-0.000342f,0.241337f},{-4.96148f,-0.000342f,5.35866f},
	{4.96148f,-0.000342f,0.497548f},{4.96148f,-0.000342f,5.10245f},{-4.96148f,-0.000342f,0.497548f},
	{-4.96148f,-0.000342f,5.10245f},{1.8138f,-0.000342f,0.241336f},{1.8138f,-0.000342f,5.35866f},
	{-1.8138f,-0.000342f,0.241336f},{-1.8138f,-0.000342f,5.35866f},{1.8138f,-0.000342f,0.497548f},
	{1.8138f,-0.000342f,5.10245f},{-1.8138f,-0.000342f,0.497548f},{-1.8138f,-0.000342f,5.10245f},
	{1.65007f,5.00607f,3.58512f},{1.65007f,-5.00607f,3.58512f},{-1.64992f,5.00607f,3.58512f},
	{-1.64992f,-5.00607f,3.58512f},{7.5e-005f,7.43758f,6.44916f},{7.5e-005f,-7.43758f,6.44916f},
	{7.5e-005f,7.24129f,6.34488f},{7.5e-005f,-7.24129f,6.34488f},{7.5e-005f,7.15f,6.14935f},
	{7.5e-005f,-7.15f,6.14935f},{7.5e-005f,0.0f,1.44934f},{7.5e-005f,2.1f,1.44934f},
	{7.5e-005f,-2.1f,1.44934f},{7.5e-005f,6.58944f,1.44934f},{7.5e-005f,-6.58944f,1.44934f},
	{7.5e-005f,7.04923f,1.89819f},{7.5e-005f,-7.04923f,1.89819f},{7.5e-005f,6.731f,1.48484f},
	{7.5e-005f,-6.731f,1.48484f},{7.5e-005f,6.79109f,1.52722f},{7.5e-005f,-6.79109f,1.52722f},
	{7.5e-005f,6.83906f,1.58293f},{7.5e-005f,-6.83906f,1.58293f},{4.59835f,0.0f,4.34935f},
	{-4.5982f,0.0f,4.34935f},{1.65007f,0.0f,6.44935f},{-1.64992f,0.0f,6.44935f},
	{1.65007f,0.0f,4.34935f},{-1.64992f,0.0f,4.34935f},{4.60006f,0.0f,1.64934f},
	{-4.59992f,0.0f,1.64934f},{4.58485f,0.0f,1.57281f},{-4.58469f,0.0f,1.57281f},
	{4.54148f,0.0f,1.50792f},{-4.54134f,0.0f,1.50792f},{4.4766f,0.0f,1.46457f},
	{-4.47646f,0.0f,1.46457f},{4.40044f,0.0f,1.44942f},{-4.40029f,0.0f,1.44942f},
	{1.45008f,0.0f,1.44934f},{-1.44993f,0.0f,1.44934f},{6.78008f,0.0f,6.44988f},
	{-6.77993f,0.0f,6.44988f},{6.63008f,0.0f,6.29935f},{-6.62992f,0.0f,6.29935f},
	{6.67939f,0.0f,6.40003f},{-6.67924f,0.0f,6.40003f},{6.63008f,0.0f,6.04935f},
	{-6.62992f,0.0f,6.04935f},{6.45008f,0.0f,6.04935f},{-6.44992f,0.0f,6.04935f},
	{5.32955f,4.68879f,5.26156f},{5.32955f,-4.68879f,5.26156f},{-5.3294f,4.68879f,5.26156f},
	{-5.3294f,-4.68879f,5.26156f},{5.23885f,4.83469f,5.3667f},{5.23885f,-4.83469f,5.3667f},
	{-5.23871f,4.83469f,5.3667f},{-5.23871f,-4.83469f,5.3667f},{5.24348f,3.63177f,6.35194f},
	{5.24348f,-3.63177f,6.35194f},{-5.24333f,3.63177f,6.35194f},{-5.24333f,-3.63177f,6.35194f},
	{5.14906f,4.79604f,6.33539f},{5.14906f,-4.79604f,6.33539f},{-5.14891f,4.79604f,6.33539f},
	{-5.14891f,-4.79604f,6.33539f},{5.24144f,4.61f,6.35071f},{5.24144f,-4.61f,6.35071f},
	{-5.24129f,4.61f,6.35071f},{-5.24129f,-4.61f,6.35071f},{5.2522f,4.82213f,6.14935f},
	{5.2522f,-4.82213f,6.14935f},{-5.25206f,4.82213f,6.14935f},{-5.25206f,-4.82213f,6.14935f},
	{5.15488f,4.88716f,6.14935f},{5.15488f,-4.88716f,6.14935f},{-5.15473f,4.88716f,6.14935f},
	{-5.15473f,-4.88716f,6.14935f},{5.04354f,2.78369f,6.29935f},{5.04354f,-2.78369f,6.29935f},
	{-5.04339f,2.78369f,6.29935f},{-5.04339f,-2.78369f,6.29935f},{5.0891f,2.80256f,6.40003f},
	{5.0891f,-2.80256f,6.40003f},{-5.08895f,2.80256f,6.40003f},{-5.08895f,-2.80256f,6.40003f},
	{4.93948f,2.93941f,6.29935f},{4.93948f,-2.93941f,6.29935f},{-4.93933f,2.93941f,6.29935f},
	{-4.93933f,-2.93941f,6.29935f},{4.97436f,2.97428f,6.40003f},{4.97436f,-2.97428f,6.40003f},
	{-4.97421f,2.97428f,6.40003f},{-4.97421f,-2.97428f,6.40003f},{4.80264f,3.08902f,6.40003f},
	{4.80264f,-3.08902f,6.40003f},{-4.80249f,3.08902f,6.40003f},{-4.80249f,-3.08902f,6.40003f},
	{4.78376f,3.04346f,6.29935f},{4.78376f,-3.04346f,6.29935f},{-4.78362f,3.04346f,6.29935f},
	{-4.78362f,-3.04346f,6.29935f},{5.12939f,2.6f,6.40003f},{5.12939f,-2.6f,6.40003f},
	{-5.12924f,2.6f,6.40003f},{-5.12924f,-2.6f,6.40003f},{5.08007f,2.6f,6.29935f},
	{5.08007f,-2.6f,6.29935f},{-5.07993f,2.6f,6.29935f},{-5.07993f,-2.6f,6.29935f},
	{5.08007f,1.34985f,6.29935f},{5.08007f,-1.34985f,6.29935f},{-5.07993f,1.34985f,6.29935f},
	{-5.07993f,-1.34985f,6.29935f},{5.10515f,1.37493f,6.37295f},{5.10515f,-1.37493f,6.37295f},
	{-5.105f,1.37493f,6.37295f},{-5.105f,-1.37493f,6.37295f},{6.64671f,1.13414f,6.40003f},
	{6.64671f,-1.13414f,6.40003f},{-6.64656f,1.13414f,6.40003f},{-6.64656f,-1.13414f,6.40003f},
	{6.60115f,1.11527f,6.29935f},{6.60115f,-1.11527f,6.29935f},{-6.601f,1.11527f,6.29935f},
	{-6.601f,-1.11527f,6.29935f},{6.51878f,1.23855f,6.29935f},{6.51878f,-1.23855f,6.29935f},
	{-6.51862f,1.23855f,6.29935f},{-6.51862f,-1.23855f,6.29935f},{6.55365f,1.27343f,6.40003f},
	{6.55365f,-1.27343f,6.40003f},{-6.5535f,1.27343f,6.40003f},{-6.5535f,-1.27343f,6.40003f},
	{6.41437f,1.36649f,6.40003f},{6.41437f,-1.36649f,6.40003f},{-6.41422f,1.36649f,6.40003f},
	{-6.41422f,-1.36649f,6.40003f},{6.25008f,1.34985f,6.29935f},{6.25008f,-1.34985f,6.29935f},
	{-6.24993f,1.34985f,6.29935f},{-6.24993f,-1.34985f,6.29935f},{6.3955f,1.32093f,6.29935f},
	{6.3955f,-1.32093f,6.29935f},{-6.39534f,1.32093f,6.29935f},{-6.39534f,-1.32093f,6.29935f},
	{6.25008f,1.39917f,6.40003f},{6.25008f,-1.39917f,6.40003f},{-6.24993f,1.39917f,6.40003f},
	{-6.24993f,-1.39917f,6.40003f},{6.63008f,0.969852f,6.29935f},{6.63008f,-0.969852f,6.29935f},
	{-6.62992f,0.969852f,6.29935f},{-6.62992f,-0.969852f,6.29935f},{6.67939f,0.969852f,6.40003f},
	{6.67939f,-0.969852f,6.40003f},{-6.67924f,0.969852f,6.40003f},{-6.67924f,-0.969852f,6.40003f},
	{4.78376f,3.04346f,6.04935f},{4.78376f,-3.04346f,6.04935f},{-4.78362f,3.04346f,6.04935f},
	{-4.78362f,-3.04346f,6.04935f},{4.93948f,2.93941f,6.04935f},{4.93948f,-2.93941f,6.04935f},
	{-4.93933f,2.93941f,6.04935f},{-4.93933f,-2.93941f,6.04935f},{5.08007f,2.6f,6.04935f},
	{5.08007f,-2.6f,6.04935f},{-5.07993f,2.6f,6.04935f},{-5.07993f,-2.6f,6.04935f},
	{5.04354f,2.78369f,6.04935f},{5.04354f,-2.78369f,6.04935f},{-5.04339f,2.78369f,6.04935f},
	{-5.04339f,-2.78369f,6.04935f},{5.08007f,1.34985f,6.04935f},{5.08007f,-1.34985f,6.04935f},
	{-5.07993f,1.34985f,6.04935f},{-5.07993f,-1.34985f,6.04935f},{6.25008f,1.34985f,6.04935f},
	{6.25008f,-1.34985f,6.04935f},{-6.24993f,1.34985f,6.04935f},{-6.24993f,-1.34985f,6.04935f},
	{6.25008f,1.16985f,6.04935f},{6.25008f,-1.16985f,6.04935f},{-6.24993f,1.16985f,6.04935f},
	{-6.24993f,-1.16985f,6.04935f},{6.32661f,1.15463f,6.04935f},{6.32661f,-1.15463f,6.04935f},
	{-6.32647f,1.15463f,6.04935f},{-6.32647f,-1.15463f,6.04935f},{6.3915f,1.11127f,6.04935f},
	{6.3915f,-1.11127f,6.04935f},{-6.39135f,1.11127f,6.04935f},{-6.39135f,-1.11127f,6.04935f},
	{6.3955f,1.32093f,6.04935f},{6.3955f,-1.32093f,6.04935f},{-6.39534f,1.32093f,6.04935f},
	{-6.39534f,-1.32093f,6.04935f},{6.51878f,1.23855f,6.04935f},{6.51878f,-1.23855f,6.04935f},
	{-6.51862f,1.23855f,6.04935f},{-6.51862f,-1.23855f,6.04935f},{6.43486f,1.04639f,6.04935f},
	{6.43486f,-1.04639f,6.04935f},{-6.4347f,1.04639f,6.04935f},{-6.4347f,-1.04639f,6.04935f},
	{6.63008f,0.969852f,6.04935f},{6.63008f,-0.969852f,6.04935f},{-6.62992f,0.969852f,6.04935f},
	{-6.62992f,-0.969852f,6.04935f},{6.60115f,1.11527f,6.04935f},{6.60115f,-1.11527f,6.04935f},
	{-6.601f,1.11527f,6.04935f},{-6.601f,-1.11527f,6.04935f},{6.45008f,0.969852f,6.04935f},
	{6.45008f,-0.969852f,6.04935f},{-6.44992f,0.969852f,6.04935f},{-6.44992f,-0.969852f,6.04935f},
	{1.897f,3.11045f,6.04935f},{1.897f,-3.11045f,6.04935f},{-1.89685f,3.11045f,6.04935f},
	{-1.89685f,-3.11045f,6.04935f},{1.76724f,3.19716f,6.04935f},{1.76724f,-3.19716f,6.04935f},
	{-1.76708f,3.19716f,6.04935f},{-1.76708f,-3.19716f,6.04935f},{4.60007f,3.08f,6.04935f},
	{4.60007f,-3.08f,6.04935f},{-4.59993f,3.08f,6.04935f},{-4.59993f,-3.08f,6.04935f},
	{2.05008f,3.08f,6.04935f},{2.05008f,-3.08f,6.04935f},{-2.04993f,3.08f,6.04935f},
	{-2.04993f,-3.08f,6.04935f},{4.60007f,3.08f,6.29935f},{4.60007f,-3.08f,6.29935f},
	{-4.59993f,3.08f,6.29935f},{-4.59993f,-3.08f,6.29935f},{4.60007f,3.12932f,6.40003f},
	{4.60007f,-3.12932f,6.40003f},{-4.59993f,3.12932f,6.40003f},{-4.59993f,-3.12932f,6.40003f},
	{2.05008f,3.08001f,6.29935f},{2.05008f,-3.08001f,6.29935f},{-2.04993f,3.08001f,6.29935f},
	{-2.04993f,-3.08001f,6.29935f},{2.05003f,3.10768f,6.38109f},{2.05003f,-3.10768f,6.38109f},
	{-2.04989f,3.10768f,6.38109f},{-2.04989f,-3.10768f,6.38109f},{1.90956f,3.10547f,6.28343f},
	{1.90956f,-3.10547f,6.28343f},{-1.9094f,3.10547f,6.28343f},{-1.9094f,-3.10547f,6.28343f},
	{1.95148f,3.13198f,6.39199f},{1.95148f,-3.13198f,6.39199f},{-1.95133f,3.13198f,6.39199f},
	{-1.95133f,-3.13198f,6.39199f},{1.7812f,3.18385f,6.23442f},{1.7812f,-3.18385f,6.23442f},
	{-1.78106f,3.18385f,6.23442f},{-1.78106f,-3.18385f,6.23442f},{1.68587f,3.31477f,6.1526f},
	{1.68587f,-3.31477f,6.1526f},{-1.68572f,3.31477f,6.1526f},{-1.68572f,-3.31477f,6.1526f},
	{1.73937f,3.26737f,6.28624f},{1.73937f,-3.26737f,6.28624f},{-1.73923f,3.26737f,6.28624f},
	{-1.73923f,-3.26737f,6.28624f},{1.7812f,3.29491f,6.3455f},{1.7812f,-3.29491f,6.3455f},
	{-1.78105f,3.29491f,6.3455f},{-1.78105f,-3.29491f,6.3455f},{1.68587f,3.37675f,6.21458f},
	{1.68587f,-3.37675f,6.21458f},{-1.68572f,3.37675f,6.21458f},{-1.68572f,-3.37675f,6.21458f},
	{1.87468f,4.6644f,6.40123f},{1.87468f,-4.6644f,6.40123f},{-1.87452f,4.6644f,6.40123f},
	{-1.87452f,-4.6644f,6.40123f},{1.76954f,4.58121f,6.33449f},{1.76954f,-4.58121f,6.33449f},
	{-1.76939f,4.58121f,6.33449f},{-1.76939f,-4.58121f,6.33449f},{1.78787f,4.7091f,6.31652f},
	{1.78787f,-4.7091f,6.31652f},{-1.78772f,4.7091f,6.31652f},{-1.78772f,-4.7091f,6.31652f},
	{1.95185f,4.79684f,6.34381f},{1.95185f,-4.79684f,6.34381f},{-1.95169f,4.79684f,6.34381f},
	{-1.95169f,-4.79684f,6.34381f},{1.68107f,4.54854f,6.20367f},{1.68107f,-4.54854f,6.20367f},
	{-1.68093f,4.54854f,6.20367f},{-1.68093f,-4.54854f,6.20367f},{2.05005f,4.81138f,6.3507f},
	{2.05005f,-4.81138f,6.3507f},{-2.0499f,4.81138f,6.3507f},{-2.0499f,-4.81138f,6.3507f},
	{5.04008f,4.81137f,6.35071f},{5.04008f,-4.81137f,6.35071f},{-5.03993f,4.81137f,6.35071f},
	{-5.03993f,-4.81137f,6.35071f},{5.04008f,4.91f,6.14935f},{5.04008f,-4.91f,6.14935f},
	{-5.03993f,4.91f,6.14935f},{-5.03993f,-4.91f,6.14935f},{5.04008f,4.91f,5.59718f},
	{5.04008f,-4.91f,5.59718f},{-5.03993f,4.91f,5.59718f},{-5.03993f,-4.91f,5.59718f},
	{1.89922f,4.88046f,6.14199f},{1.89922f,-4.88046f,6.14199f},{-1.89907f,4.88046f,6.14199f},
	{-1.89907f,-4.88046f,6.14199f},{2.0501f,4.91f,6.14935f},{2.0501f,-4.91f,6.14935f},
	{-2.04996f,4.91f,6.14935f},{-2.04996f,-4.91f,6.14935f},{1.76953f,4.79513f,6.12063f},
	{1.76953f,-4.79513f,6.12063f},{-1.76938f,4.79513f,6.12063f},{-1.76938f,-4.79513f,6.12063f},
	{4.65007f,4.91f,6.04935f},{4.65007f,-4.91f,6.04935f},{-4.64993f,4.91f,6.04935f},
	{-4.64993f,-4.91f,6.04935f},{2.05008f,4.91f,6.04935f},{2.05008f,-4.91f,6.04935f},
	{-2.04993f,4.91f,6.04935f},{-2.04993f,-4.91f,6.04935f},{1.74871f,5.18863f,6.04935f},
	{1.74871f,-5.18863f,6.04935f},{-1.74856f,5.18863f,6.04935f},{-1.74856f,-5.18863f,6.04935f},
	{4.65007f,5.09f,6.04935f},{4.65007f,-5.09f,6.04935f},{-4.64993f,5.09f,6.04935f},
	{-4.64993f,-5.09f,6.04935f},{1.95008f,5.09f,6.04935f},{1.95008f,-5.09f,6.04935f},
	{-1.94992f,5.09f,6.04935f},{-1.94992f,-5.09f,6.04935f},{5.32955f,5.31121f,5.26156f},
	{5.32955f,-5.31121f,5.26156f},{-5.3294f,5.31121f,5.26156f},{-5.3294f,-5.31121f,5.26156f},
	{5.04008f,5.09f,5.59718f},{5.04008f,-5.09f,5.59718f},{-5.03993f,5.09f,5.59718f},
	{-5.03993f,-5.09f,5.59718f},{5.23185f,5.17604f,5.37482f},{5.23185f,-5.17604f,5.37482f},
	{-5.2317f,5.17604f,5.37482f},{-5.2317f,-5.17604f,5.37482f},{5.34008f,5.39f,5.24935f},
	{5.34008f,-5.39f,5.24935f},{-5.33992f,5.39f,5.24935f},{-5.33992f,-5.39f,5.24935f},
	{5.34008f,5.69282f,2.79935f},{5.34008f,-5.69282f,2.79935f},{-5.33992f,5.69282f,2.79935f},
	{-5.33992f,-5.69282f,2.79935f},{5.34008f,5.51423f,2.5865f},{5.34008f,-5.51423f,2.5865f},
	{-5.33992f,5.51423f,2.5865f},{-5.33992f,-5.51423f,2.5865f},{5.34008f,5.27362f,2.44759f},
	{5.34008f,-5.27362f,2.44759f},{-5.33992f,5.27362f,2.44759f},{-5.33992f,-5.27362f,2.44759f},
	{5.34008f,4.61f,6.14935f},{5.34008f,-4.61f,6.14935f},{-5.33992f,4.61f,6.14935f},
	{-5.33992f,-4.61f,6.14935f},{5.34008f,4.61f,5.24935f},{5.34008f,-4.61f,5.24935f},
	{-5.33992f,4.61f,5.24935f},{-5.33992f,-4.61f,5.24935f},{5.34008f,3.66749f,6.14935f},
	{5.34008f,-3.66749f,6.14935f},{-5.33992f,3.66749f,6.14935f},{-5.33992f,-3.66749f,6.14935f},
	{5.34008f,5.0f,2.39934f},{5.34008f,-5.0f,2.39934f},{-5.33992f,5.0f,2.39934f},
	{-5.33992f,-5.0f,2.39934f},{5.34008f,4.72638f,2.44759f},{5.34008f,-4.72638f,2.44759f},
	{-5.33992f,4.72638f,2.44759f},{-5.33992f,-4.72638f,2.44759f},{5.34008f,4.21215f,3.06043f},
	{5.34008f,-4.21215f,3.06043f},{-5.33992f,4.21215f,3.06043f},{-5.33992f,-4.21215f,3.06043f},
	{5.34008f,4.30718f,2.79935f},{5.34008f,-4.30718f,2.79935f},{-5.33992f,4.30718f,2.79935f},
	{-5.33992f,-4.30718f,2.79935f},{5.34008f,4.48577f,2.5865f},{5.34008f,-4.48577f,2.5865f},
	{-5.33992f,4.48577f,2.5865f},{-5.33992f,-4.48577f,2.5865f},{5.44007f,5.00042f,2.95147f},
	{5.44007f,-5.00042f,2.95147f},{-5.43993f,5.00042f,2.95147f},{-5.43993f,-5.00042f,2.95147f},
	{5.34008f,5.00042f,2.95147f},{5.34008f,-5.00042f,2.95147f},{-5.33992f,5.00042f,2.95147f},
	{-5.33992f,-5.00042f,2.95147f},{5.54008f,5.69282f,2.79935f},{5.54008f,-5.69282f,2.79935f},
	{-5.53993f,5.69282f,2.79935f},{-5.53993f,-5.69282f,2.79935f},{5.54008f,5.51423f,2.5865f},
	{5.54008f,-5.51423f,2.5865f},{-5.53993f,5.51423f,2.5865f},{-5.53993f,-5.51423f,2.5865f},
	{5.54008f,5.27362f,2.44759f},{5.54008f,-5.27362f,2.44759f},{-5.53993f,5.27362f,2.44759f},
	{-5.53993f,-5.27362f,2.44759f},{5.54008f,5.55f,3.54935f},{5.54008f,-5.55f,3.54935f},
	{-5.53993f,5.55f,3.54935f},{-5.53993f,-5.55f,3.54935f},{5.54008f,5.35f,3.54935f},
	{5.54008f,-5.35f,3.54935f},{-5.53993f,5.35f,3.54935f},{-5.53993f,-5.35f,3.54935f},
	{5.54008f,5.0f,2.39934f},{5.54008f,-5.0f,2.39934f},{-5.53993f,5.0f,2.39934f},
	{-5.53993f,-5.0f,2.39934f},{5.54008f,4.72638f,2.44759f},{5.54008f,-4.72638f,2.44759f},
	{-5.53993f,4.72638f,2.44759f},{-5.53993f,-4.72638f,2.44759f},{5.54008f,4.48577f,2.5865f},
	{5.54008f,-4.48577f,2.5865f},{-5.53993f,4.48577f,2.5865f},{-5.53993f,-4.48577f,2.5865f},
	{5.54008f,4.30718f,2.79935f},{5.54008f,-4.30718f,2.79935f},{-5.53993f,4.30718f,2.79935f},
	{-5.53993f,-4.30718f,2.79935f},{5.54008f,5.1f,3.54935f},{5.54008f,-5.1f,3.54935f},
	{-5.53993f,5.1f,3.54935f},{-5.53993f,-5.1f,3.54935f},{5.54008f,4.65f,3.54935f},
	{5.54008f,-4.65f,3.54935f},{-5.53993f,4.65f,3.54935f},{-5.53993f,-4.65f,3.54935f},
	{5.54008f,4.9f,3.54935f},{5.54008f,-4.9f,3.54935f},{-5.53993f,4.9f,3.54935f},
	{-5.53993f,-4.9f,3.54935f},{5.54008f,4.21215f,3.06043f},{5.54008f,-4.21215f,3.06043f},
	{-5.53993f,4.21215f,3.06043f},{-5.53993f,-4.21215f,3.06043f},{5.54008f,5.00042f,2.95147f},
	{5.54008f,-5.00042f,2.95147f},{-5.53993f,5.00042f,2.95147f},{-5.53993f,-5.00042f,2.95147f},
	{5.54008f,4.45f,3.54935f},{5.54008f,-4.45f,3.54935f},{-5.53993f,4.45f,3.54935f},
	{-5.53993f,-4.45f,3.54935f},{5.54008f,5.78785f,3.06043f},{5.54008f,-5.78785f,3.06043f},
	{-5.53993f,5.78785f,3.06043f},{-5.53993f,-5.78785f,3.06043f},{5.34008f,5.78785f,3.06043f},
	{5.34008f,-5.78785f,3.06043f},{-5.33992f,5.78785f,3.06043f},{-5.33992f,-5.78785f,3.06043f},
	{7.5e-005f,8.5f,6.99935f},{7.5e-005f,-8.5f,6.99935f},{6.01049f,6.01041f,6.99935f},
	{6.01049f,-6.01041f,6.99935f},{-6.01033f,6.01041f,6.99935f},{-6.01033f,-6.01041f,6.99935f},
	{3.25288f,7.85298f,6.99935f},{3.25288f,-7.85298f,6.99935f},{-3.25273f,7.85298f,6.99935f},
	{-3.25273f,-7.85298f,6.99935f},{1.65834f,8.33668f,6.99935f},{1.65834f,-8.33668f,6.99935f},
	{-1.6582f,8.33668f,6.99935f},{-1.6582f,-8.33668f,6.99935f},{4.72243f,7.06749f,6.99935f},
	{4.72243f,-7.06749f,6.99935f},{-4.72227f,7.06749f,6.99935f},{-4.72227f,-7.06749f,6.99935f},
	{7.85306f,3.25281f,6.99935f},{7.85306f,-3.25281f,6.99935f},{-7.8529f,3.25281f,6.99935f},
	{-7.8529f,-3.25281f,6.99935f},{7.06757f,4.72235f,6.99935f},{7.06757f,-4.72235f,6.99935f},
	{-7.06741f,4.72235f,6.99935f},{-7.06741f,-4.72235f,6.99935f},{8.33676f,1.65827f,6.99935f},
	{8.33676f,-1.65827f,6.99935f},{-8.33661f,1.65827f,6.99935f},{-8.33661f,-1.65827f,6.99935f},
	{8.50008f,0.0f,6.99935f},{-8.49993f,0.0f,6.99935f},{7.5e-005f,8.5f,6.54935f},
	{7.5e-005f,-8.5f,6.54935f},{1.65834f,8.33668f,6.54935f},{1.65834f,-8.33668f,6.54935f},
	{-1.6582f,8.33668f,6.54935f},{-1.6582f,-8.33668f,6.54935f},{3.25288f,7.85298f,6.54935f},
	{3.25288f,-7.85298f,6.54935f},{-3.25273f,7.85298f,6.54935f},{-3.25273f,-7.85298f,6.54935f},
	{1.18248f,8.35501f,6.44988f},{1.18248f,-8.35501f,6.44988f},{-1.18234f,8.35501f,6.44988f},
	{-1.18234f,-8.35501f,6.44988f},{2.35611f,8.10268f,6.44988f},{2.35611f,-8.10268f,6.44988f},
	{-2.35595f,8.10268f,6.44988f},{-2.35595f,-8.10268f,6.44988f},{3.48204f,7.68637f,6.44988f},
	{3.48204f,-7.68637f,6.44988f},{-3.4819f,7.68637f,6.44988f},{-3.4819f,-7.68637f,6.44988f},
	{4.72243f,7.06749f,6.54935f},{4.72243f,-7.06749f,6.54935f},{-4.72227f,7.06749f,6.54935f},
	{-4.72227f,-7.06749f,6.54935f},{6.01049f,6.01041f,6.54935f},{6.01049f,-6.01041f,6.54935f},
	{-6.01033f,6.01041f,6.54935f},{-6.01033f,-6.01041f,6.54935f},{7.06757f,4.72235f,6.54935f},
	{7.06757f,-4.72235f,6.54935f},{-7.06741f,4.72235f,6.54935f},{-7.06741f,-4.72235f,6.54935f},
	{7.85306f,3.25281f,6.54935f},{7.85306f,-3.25281f,6.54935f},{-7.8529f,3.25281f,6.54935f},
	{-7.8529f,-3.25281f,6.54935f},{8.33676f,1.65827f,6.54935f},{8.33676f,-1.65827f,6.54935f},
	{-8.33661f,1.65827f,6.54935f},{-8.33661f,-1.65827f,6.54935f},{5.54008f,6.38843f,6.44988f},
	{5.54008f,-6.38843f,6.44988f},{-5.53993f,6.38843f,6.44988f},{-5.53993f,-6.38843f,6.44988f},
	{4.53751f,7.11449f,6.44988f},{4.53751f,-7.11449f,6.44988f},{-4.53736f,7.11449f,6.44988f},
	{-4.53736f,-7.11449f,6.44988f},{7.07719f,4.59553f,6.44988f},{7.07719f,-4.59553f,6.44988f},
	{-7.07703f,4.59553f,6.44988f},{-7.07703f,-4.59553f,6.44988f},{7.65769f,3.54477f,6.44988f},
	{7.65769f,-3.54477f,6.44988f},{-7.65754f,3.54477f,6.44988f},{-7.65754f,-3.54477f,6.44988f},
	{8.08321f,2.42228f,6.44988f},{8.08321f,-2.42228f,6.44988f},{-8.08306f,2.42228f,6.44988f},
	{-8.08306f,-2.42228f,6.44988f},{8.49991f,0.0f,6.54935f},{-8.49975f,0.0f,6.54935f},
	{8.43818f,0.0f,6.44988f},{-8.43802f,0.0f,6.44988f},{1.52662f,7.07883f,1.9814f},
	{1.52662f,-7.07883f,1.9814f},{-1.52647f,7.07883f,1.9814f},{-1.52647f,-7.07883f,1.9814f},
	{1.5915f,7.03962f,1.99991f},{1.5915f,-7.03962f,1.99991f},{-1.59134f,7.03962f,1.99991f},
	{-1.59134f,-7.03962f,1.99991f},{1.63486f,6.98094f,2.0276f},{1.63486f,-6.98094f,2.0276f},
	{-1.63471f,6.98094f,2.0276f},{-1.63471f,-6.98094f,2.0276f},{1.45008f,7.1339f,2.10014f},
	{1.45008f,-7.1339f,2.10014f},{-1.44993f,7.1339f,2.10014f},{-1.44993f,-7.1339f,2.10014f},
	{1.52662f,7.11908f,2.10345f},{1.52662f,-7.11908f,2.10345f},{-1.52647f,7.11908f,2.10345f},
	{-1.52647f,-7.11908f,2.10345f},{1.5915f,7.09142f,2.23101f},{1.5915f,-7.09142f,2.23101f},
	{-1.59134f,7.09142f,2.23101f},{-1.59134f,-7.09142f,2.23101f},{1.52662f,7.13478f,2.23101f},
	{1.52662f,-7.13478f,2.23101f},{-1.52647f,7.13478f,2.23101f},{-1.52647f,-7.13478f,2.23101f},
	{1.5915f,7.07689f,2.11291f},{1.5915f,-7.07689f,2.11291f},{-1.59134f,7.07689f,2.11291f},
	{-1.59134f,-7.07689f,2.11291f},{1.63486f,7.01374f,2.12707f},{1.63486f,-7.01374f,2.12707f},
	{-1.63471f,7.01374f,2.12707f},{-1.63471f,-7.01374f,2.12707f},{1.63486f,7.02654f,2.23101f},
	{1.63486f,-7.02654f,2.23101f},{-1.63471f,7.02654f,2.23101f},{-1.63471f,-7.02654f,2.23101f},
	{1.63486f,6.9465f,1.96667f},{1.63486f,-6.9465f,1.96667f},{-1.63471f,6.9465f,1.96667f},
	{-1.63471f,-6.9465f,1.96667f},{1.5915f,7.00049f,1.93069f},{1.5915f,-7.00049f,1.93069f},
	{-1.59134f,7.00049f,1.93069f},{-1.59134f,-7.00049f,1.93069f},{1.52662f,7.03656f,1.90663f},
	{1.52662f,-7.03656f,1.90663f},{-1.52647f,7.03656f,1.90663f},{-1.52647f,-7.03656f,1.90663f},
	{1.45008f,7.04923f,1.89819f},{1.45008f,-7.04923f,1.89819f},{-1.44993f,7.04923f,1.89819f},
	{-1.44993f,-7.04923f,1.89819f},{1.52419f,6.65717f,1.47173f},{1.52419f,-6.65717f,1.47173f},
	{-1.52404f,6.65717f,1.47173f},{-1.52404f,-6.65717f,1.47173f},{1.59229f,6.64648f,1.51557f},
	{1.59229f,-6.64648f,1.51557f},{-1.59213f,6.64648f,1.51557f},{-1.59213f,-6.64648f,1.51557f},
	{1.63662f,6.63024f,1.58212f},{1.63662f,-6.63024f,1.58212f},{-1.63646f,6.63024f,1.58212f},
	{-1.63646f,-6.63024f,1.58212f},{1.45008f,6.731f,1.48484f},{1.45008f,-6.731f,1.48484f},
	{-1.44993f,6.731f,1.48484f},{-1.44993f,-6.731f,1.48484f},{1.52419f,6.72383f,1.49716f},
	{1.52419f,-6.72383f,1.49716f},{-1.52404f,6.72383f,1.49716f},{-1.52404f,-6.72383f,1.49716f},
	{1.45008f,6.79109f,1.52722f},{1.45008f,-6.79109f,1.52722f},{-1.44993f,6.79109f,1.52722f},
	{-1.44993f,-6.79109f,1.52722f},{1.45008f,6.83906f,1.58293f},{1.45008f,-6.83906f,1.58293f},
	{-1.44993f,6.83906f,1.58293f},{-1.44993f,-6.83906f,1.58293f},{1.52662f,6.82639f,1.59138f},
	{1.52662f,-6.82639f,1.59138f},{-1.52647f,6.82639f,1.59138f},{-1.52647f,-6.82639f,1.59138f},
	{1.5915f,6.79032f,1.61543f},{1.5915f,-6.79032f,1.61543f},{-1.59134f,6.79032f,1.61543f},
	{-1.59134f,-6.79032f,1.61543f},{1.59229f,6.70261f,1.53699f},{1.59229f,-6.70261f,1.53699f},
	{-1.59213f,6.70261f,1.53699f},{-1.59213f,-6.70261f,1.53699f},{1.52419f,6.78213f,1.53832f},
	{1.52419f,-6.78213f,1.53832f},{-1.52404f,6.78213f,1.53832f},{-1.52404f,-6.78213f,1.53832f},
	{1.63662f,6.67039f,1.59744f},{1.63662f,-6.67039f,1.59744f},{-1.63646f,6.67039f,1.59744f},
	{-1.63646f,-6.67039f,1.59744f},{1.59229f,6.7517f,1.57165f},{1.59229f,-6.7517f,1.57165f},
	{-1.59213f,6.7517f,1.57165f},{-1.59213f,-6.7517f,1.57165f},{1.63486f,6.73633f,1.65142f},
	{1.63486f,-6.73633f,1.65142f},{-1.63471f,6.73633f,1.65142f},{-1.63471f,-6.73633f,1.65142f},
	{1.63662f,6.70551f,1.62223f},{1.63662f,-6.70551f,1.62223f},{-1.63646f,6.70551f,1.62223f},
	{-1.63646f,-6.70551f,1.62223f},{1.63486f,6.58944f,1.57281f},{1.63486f,-6.58944f,1.57281f},
	{-1.63471f,6.58944f,1.57281f},{-1.63471f,-6.58944f,1.57281f},{1.5915f,6.58944f,1.50792f},
	{1.5915f,-6.58944f,1.50792f},{-1.59134f,6.58944f,1.50792f},{-1.59134f,-6.58944f,1.50792f},
	{1.52662f,6.58944f,1.46457f},{1.52662f,-6.58944f,1.46457f},{-1.52647f,6.58944f,1.46457f},
	{-1.52647f,-6.58944f,1.46457f},{1.63546f,2.43065f,1.57429f},{1.63546f,-2.43065f,1.57429f},
	{-1.63531f,2.43065f,1.57429f},{-1.63531f,-2.43065f,1.57429f},{1.59441f,2.34033f,1.51087f},
	{1.59441f,-2.34033f,1.51087f},{-1.59425f,2.34033f,1.51087f},{-1.59425f,-2.34033f,1.51087f},
	{4.57487f,2.2184f,1.59278f},{4.57487f,-2.2184f,1.59278f},{-4.57472f,2.2184f,1.59278f},
	{-4.57472f,-2.2184f,1.59278f},{4.54459f,2.32031f,1.63919f},{4.54459f,-2.32031f,1.63919f},
	{-4.54444f,2.32031f,1.63919f},{-4.54444f,-2.32031f,1.63919f},{4.53131f,2.22383f,1.52457f},
	{4.53131f,-2.22383f,1.52457f},{-4.53116f,2.22383f,1.52457f},{-4.53116f,-2.22383f,1.52457f},
	{4.50346f,2.33294f,1.57044f},{4.50346f,-2.33294f,1.57044f},{-4.50331f,2.33294f,1.57044f},
	{-4.50331f,-2.33294f,1.57044f},{4.46502f,2.21949f,1.47804f},{4.46502f,-2.21949f,1.47804f},
	{-4.46487f,2.21949f,1.47804f},{-4.46487f,-2.21949f,1.47804f},{4.44085f,2.32777f,1.51913f},
	{4.44085f,-2.32777f,1.51913f},{-4.4407f,2.32777f,1.51913f},{-4.4407f,-2.32777f,1.51913f},
	{4.38076f,2.27659f,1.48155f},{4.38076f,-2.27659f,1.48155f},{-4.38062f,2.27659f,1.48155f},
	{-4.38062f,-2.27659f,1.48155f},{4.3216f,2.43718f,1.58014f},{4.3216f,-2.43718f,1.58014f},
	{-4.32144f,2.43718f,1.58014f},{-4.32144f,-2.43718f,1.58014f},{4.36125f,2.48876f,1.65446f},
	{4.36125f,-2.48876f,1.65446f},{-4.36109f,2.48876f,1.65446f},{-4.36109f,-2.48876f,1.65446f},
	{4.2234f,2.5557f,1.74374f},{4.2234f,-2.5557f,1.74374f},{-4.22326f,2.5557f,1.74374f},
	{-4.22326f,-2.5557f,1.74374f},{4.20288f,2.57785f,1.88768f},{4.20288f,-2.57785f,1.88768f},
	{-4.20272f,2.57785f,1.88768f},{-4.20272f,-2.57785f,1.88768f},{4.58485f,2.10007f,1.57281f},
	{4.58485f,-2.10007f,1.57281f},{-4.58469f,2.10007f,1.57281f},{-4.58469f,-2.10007f,1.57281f},
	{4.54148f,2.1f,1.50792f},{4.54148f,-2.1f,1.50792f},{-4.54134f,2.1f,1.50792f},
	{-4.54134f,-2.1f,1.50792f},{4.4766f,2.09992f,1.46457f},{4.4766f,-2.09992f,1.46457f},
	{-4.47646f,2.09992f,1.46457f},{-4.47646f,-2.09992f,1.46457f},{7.5e-005f,7.13317f,2.09443f},
	{7.5e-005f,-7.13317f,2.09443f},{7.5e-005f,7.15f,2.23101f},{7.5e-005f,-7.15f,2.23101f},
	{1.45008f,7.15f,2.23101f},{1.45008f,-7.15f,2.23101f},{-1.44993f,7.15f,2.23101f},
	{-1.44993f,-7.15f,2.23101f},{1.63486f,7.02654f,6.14935f},{1.63486f,-7.02654f,6.14935f},
	{-1.63471f,7.02654f,6.14935f},{-1.63471f,-7.02654f,6.14935f},{1.72598f,7.06429f,6.35071f},
	{1.72598f,-7.06429f,6.35071f},{-1.72582f,7.06429f,6.35071f},{-1.72582f,-7.06429f,6.35071f},
	{1.66124f,7.16116f,6.35071f},{1.66124f,-7.16116f,6.35071f},{-1.66109f,7.16116f,6.35071f},
	{-1.66109f,-7.16116f,6.35071f},{1.5915f,7.09142f,6.14935f},{1.5915f,-7.09142f,6.14935f},
	{-1.59134f,7.09142f,6.14935f},{-1.59134f,-7.09142f,6.14935f},{1.56436f,7.2259f,6.35071f},
	{1.56436f,-7.2259f,6.35071f},{-1.56421f,7.2259f,6.35071f},{-1.56421f,-7.2259f,6.35071f},
	{1.45008f,7.24129f,6.34488f},{1.45008f,-7.24129f,6.34488f},{-1.44993f,7.24129f,6.34488f},
	{-1.44993f,-7.24129f,6.34488f},{1.45008f,7.15f,6.14935f},{1.45008f,-7.15f,6.14935f},
	{-1.44993f,7.15f,6.14935f},{-1.44993f,-7.15f,6.14935f},{1.52662f,7.13478f,6.14935f},
	{1.52662f,-7.13478f,6.14935f},{-1.52647f,7.13478f,6.14935f},{-1.52647f,-7.13478f,6.14935f},
	{1.74871f,6.95f,6.35071f},{1.74871f,-6.95f,6.35071f},{-1.74856f,6.95f,6.35071f},
	{-1.74856f,-6.95f,6.35071f},{1.83526f,5.39f,6.42651f},{1.83526f,-5.39f,6.42651f},
	{-1.83511f,5.39f,6.42651f},{-1.83511f,-5.39f,6.42651f},{1.95008f,5.1269f,6.25832f},
	{1.95008f,-5.1269f,6.25832f},{-1.94992f,5.1269f,6.25832f},{-1.94992f,-5.1269f,6.25832f},
	{1.95008f,5.27519f,6.42651f},{1.95008f,-5.27519f,6.42651f},{-1.94992f,5.27519f,6.42651f},
	{-1.94992f,-5.27519f,6.42651f},{5.04008f,5.09f,6.14935f},{5.04008f,-5.09f,6.14935f},
	{-5.03993f,5.09f,6.14935f},{-5.03993f,-5.09f,6.14935f},{5.14614f,5.12775f,6.24924f},
	{5.14614f,-5.12775f,6.24924f},{-5.146f,5.12775f,6.24924f},{-5.146f,-5.12775f,6.24924f},
	{5.04008f,5.18863f,6.35071f},{5.04008f,-5.18863f,6.35071f},{-5.03993f,5.18863f,6.35071f},
	{-5.03993f,-5.18863f,6.35071f},{5.24144f,5.18863f,6.14935f},{5.24144f,-5.18863f,6.14935f},
	{-5.24129f,5.18863f,6.14935f},{-5.24129f,-5.18863f,6.14935f},{5.31723f,5.30882f,6.23053f},
	{5.31723f,-5.30882f,6.23053f},{-5.31708f,5.30882f,6.23053f},{-5.31708f,-5.30882f,6.23053f},
	{5.34008f,5.39f,6.14935f},{5.34008f,-5.39f,6.14935f},{-5.33992f,5.39f,6.14935f},
	{-5.33992f,-5.39f,6.14935f},{5.28472f,5.39f,6.31281f},{5.28472f,-5.39f,6.31281f},
	{-5.28457f,5.39f,6.31281f},{-5.28457f,-5.39f,6.31281f},{5.15488f,5.39f,6.42651f},
	{5.15488f,-5.39f,6.42651f},{-5.15473f,5.39f,6.42651f},{-5.15473f,-5.39f,6.42651f},
	{5.15174f,6.13143f,6.42515f},{5.15174f,-6.13143f,6.42515f},{-5.15159f,6.13143f,6.42515f},
	{-5.15159f,-6.13143f,6.42515f},{5.34008f,6.30215f,5.97719f},{5.34008f,-6.30215f,5.97719f},
	{-5.33992f,6.30215f,5.97719f},{-5.33992f,-6.30215f,5.97719f},{5.3191f,6.27481f,6.23463f},
	{5.3191f,-6.27481f,6.23463f},{-5.31895f,6.27481f,6.23463f},{-5.31895f,-6.27481f,6.23463f},
	{6.17905f,5.09916f,5.94889f},{6.17905f,-5.09916f,5.94889f},{-6.17891f,5.09916f,5.94889f},
	{-6.17891f,-5.09916f,5.94889f},{7.5e-005f,8.4f,6.44935f},{7.5e-005f,-8.4f,6.44935f},
	{1.37007f,7.97f,6.44988f},{1.37007f,-7.97f,6.44988f},{-1.36993f,7.97f,6.44988f},
	{-1.36993f,-7.97f,6.44988f},{7.5e-005f,7.765f,6.44988f},{7.5e-005f,-7.765f,6.44988f},
	{1.45765f,7.43758f,6.44988f},{1.45765f,-7.43758f,6.44988f},{-1.4575f,7.43758f,6.44988f},
	{-1.4575f,-7.43758f,6.44988f},{1.65492f,7.40611f,6.44988f},{1.65492f,-7.40611f,6.44988f},
	{-1.65478f,7.40611f,6.44988f},{-1.65478f,-7.40611f,6.44988f},{1.8105f,7.29656f,6.44988f},
	{1.8105f,-7.29656f,6.44988f},{-1.81035f,7.29656f,6.44988f},{-1.81035f,-7.29656f,6.44988f},
	{1.91386f,7.1368f,6.44988f},{1.91386f,-7.1368f,6.44988f},{-1.91372f,7.1368f,6.44988f},
	{-1.91372f,-7.1368f,6.44988f},{3.12871f,7.5532f,6.44988f},{3.12871f,-7.5532f,6.44988f},
	{-3.12856f,7.5532f,6.44988f},{-3.12856f,-7.5532f,6.44988f},{1.95008f,6.95f,6.44988f},
	{1.95008f,-6.95f,6.44988f},{-1.94992f,6.95f,6.44988f},{-1.94992f,-6.95f,6.44988f},
	{5.04008f,5.39f,6.44988f},{5.04008f,-5.39f,6.44988f},{-5.03993f,5.39f,6.44988f},
	{-5.03993f,-5.39f,6.44988f},{1.95008f,5.39f,6.44988f},{1.95008f,-5.39f,6.44988f},
	{-1.94992f,5.39f,6.44988f},{-1.94992f,-5.39f,6.44988f},{5.04008f,6.21711f,6.44988f},
	{5.04008f,-6.21711f,6.44988f},{-5.03993f,6.21711f,6.44988f},{-5.03993f,-6.21711f,6.44988f},
	{4.55315f,6.59075f,6.44988f},{4.55315f,-6.59075f,6.44988f},{-4.553f,6.59075f,6.44988f},
	{-4.553f,-6.59075f,6.44988f},{5.39829f,6.3834f,6.44988f},{5.39829f,-6.3834f,6.44988f},
	{-5.39814f,6.3834f,6.44988f},{-5.39814f,-6.3834f,6.44988f},{5.54008f,4.65f,6.44988f},
	{5.54008f,-4.65f,6.44988f},{-5.53993f,4.65f,6.44988f},{-5.53993f,-4.65f,6.44988f},
	{5.54008f,4.9f,6.44988f},{5.54008f,-4.9f,6.44988f},{-5.53993f,4.9f,6.44988f},
	{-5.53993f,-4.9f,6.44988f},{5.54008f,4.45f,6.44988f},{5.54008f,-4.45f,6.44988f},
	{-5.53993f,4.45f,6.44988f},{-5.53993f,-4.45f,6.44988f},{2.05008f,4.61119f,6.44988f},
	{2.05008f,-4.61119f,6.44988f},{-2.04993f,4.61119f,6.44988f},{-2.04993f,-4.61119f,6.44988f},
	{2.05012f,3.23f,6.44988f},{2.05012f,-3.23f,6.44988f},{-2.04996f,3.23f,6.44988f},
	{-2.04996f,-3.23f,6.44988f},{5.04008f,4.61f,6.44988f},{5.04008f,-4.61f,6.44988f},
	{-5.03993f,4.61f,6.44988f},{-5.03993f,-4.61f,6.44988f},{4.60007f,3.23f,6.44988f},
	{4.60007f,-3.23f,6.44988f},{-4.59993f,3.23f,6.44988f},{-4.59993f,-3.23f,6.44988f},
	{4.84116f,3.18204f,6.44988f},{4.84116f,-3.18204f,6.44988f},{-4.84101f,3.18204f,6.44988f},
	{-4.84101f,-3.18204f,6.44988f},{5.04556f,3.04548f,6.44988f},{5.04556f,-3.04548f,6.44988f},
	{-5.04541f,3.04548f,6.44988f},{-5.04541f,-3.04548f,6.44988f},{5.04008f,3.6146f,6.44988f},
	{5.04008f,-3.6146f,6.44988f},{-5.03993f,3.6146f,6.44988f},{-5.03993f,-3.6146f,6.44988f},
	{5.18211f,2.84109f,6.44988f},{5.18211f,-2.84109f,6.44988f},{-5.18196f,2.84109f,6.44988f},
	{-5.18196f,-2.84109f,6.44988f},{5.54008f,3.6146f,6.44988f},{5.54008f,-3.6146f,6.44988f},
	{-5.53993f,3.6146f,6.44988f},{-5.53993f,-3.6146f,6.44988f},{6.35142f,4.9f,6.44988f},
	{6.35142f,-4.9f,6.44988f},{-6.35127f,4.9f,6.44988f},{-6.35127f,-4.9f,6.44988f},
	{6.34008f,4.65f,6.44988f},{6.34008f,-4.65f,6.44988f},{-6.33992f,4.65f,6.44988f},
	{-6.33992f,-4.65f,6.44988f},{6.34008f,4.45f,6.44988f},{6.34008f,-4.45f,6.44988f},
	{-6.33992f,4.45f,6.44988f},{-6.33992f,-4.45f,6.44988f},{5.23008f,1.49985f,6.44988f},
	{5.23008f,-1.49985f,6.44988f},{-5.22993f,1.49985f,6.44988f},{-5.22993f,-1.49985f,6.44988f},
	{6.25008f,1.49985f,6.44988f},{6.25008f,-1.49985f,6.44988f},{-6.24993f,1.49985f,6.44988f},
	{-6.24993f,-1.49985f,6.44988f},{5.23008f,2.6f,6.44988f},{5.23008f,-2.6f,6.44988f},
	{-5.22993f,2.6f,6.44988f},{-5.22993f,-2.6f,6.44988f},{6.4529f,1.45951f,6.44988f},
	{6.4529f,-1.45951f,6.44988f},{-6.45274f,1.45951f,6.44988f},{-6.45274f,-1.45951f,6.44988f},
	{6.73973f,1.17267f,6.44988f},{6.73973f,-1.17267f,6.44988f},{-6.73957f,1.17267f,6.44988f},
	{-6.73957f,-1.17267f,6.44988f},{6.78008f,0.969852f,6.44988f},{6.78008f,-0.969852f,6.44988f},
	{-6.77993f,0.969852f,6.44988f},{-6.77993f,-0.969852f,6.44988f},{6.62485f,1.34462f,6.44988f},
	{6.62485f,-1.34462f,6.44988f},{-6.62469f,1.34462f,6.44988f},{-6.62469f,-1.34462f,6.44988f},
	{5.54008f,5.55f,6.44988f},{5.54008f,-5.55f,6.44988f},{-5.53993f,5.55f,6.44988f},
	{-5.53993f,-5.55f,6.44988f},{6.34384f,5.55206f,6.44988f},{6.34384f,-5.55206f,6.44988f},
	{-6.34369f,5.55206f,6.44988f},{-6.34369f,-5.55206f,6.44988f},{6.33876f,5.35891f,6.44988f},
	{6.33876f,-5.35891f,6.44988f},{-6.33861f,5.35891f,6.44988f},{-6.33861f,-5.35891f,6.44988f},
	{5.54008f,5.35f,6.44988f},{5.54008f,-5.35f,6.44988f},{-5.53993f,5.35f,6.44988f},
	{-5.53993f,-5.35f,6.44988f},{5.54008f,5.1f,6.44988f},{5.54008f,-5.1f,6.44988f},
	{-5.53993f,5.1f,6.44988f},{-5.53993f,-5.1f,6.44988f},{6.17115f,5.1f,6.44988f},
	{6.17115f,-5.1f,6.44988f},{-6.17099f,5.1f,6.44988f},{-6.17099f,-5.1f,6.44988f},
	{4.90007f,1.16985f,6.04935f},{4.90007f,-1.16985f,6.04935f},{-4.89993f,1.16985f,6.04935f},
	{-4.89993f,-1.16985f,6.04935f},{4.87724f,2.71481f,6.04935f},{4.87724f,-2.71481f,6.04935f},
	{-4.87709f,2.71481f,6.04935f},{-4.87709f,-2.71481f,6.04935f},{4.90007f,2.6f,6.04935f},
	{4.90007f,-2.6f,6.04935f},{-4.89993f,2.6f,6.04935f},{-4.89993f,-2.6f,6.04935f},
	{4.81221f,2.81213f,6.04935f},{4.81221f,-2.81213f,6.04935f},{-4.81205f,2.81213f,6.04935f},
	{-4.81205f,-2.81213f,6.04935f},{4.71488f,2.87716f,6.04935f},{4.71488f,-2.87716f,6.04935f},
	{-4.71473f,2.87716f,6.04935f},{-4.71473f,-2.87716f,6.04935f},{4.60007f,2.9f,6.04935f},
	{4.60007f,-2.9f,6.04935f},{-4.59993f,2.9f,6.04935f},{-4.59993f,-2.9f,6.04935f},
	{1.6776f,5.32467f,6.21273f},{1.6776f,-5.32467f,6.21273f},{-1.67745f,5.32467f,6.21273f},
	{-1.67745f,-5.32467f,6.21273f},{1.65007f,6.95f,6.14935f},{1.65007f,-6.95f,6.14935f},
	{-1.64992f,6.95f,6.14935f},{-1.64992f,-6.95f,6.14935f},{1.65007f,5.39f,6.04935f},
	{1.65007f,-5.39f,6.04935f},{-1.64992f,5.39f,6.04935f},{-1.64992f,-5.39f,6.04935f},
	{1.65007f,6.95f,2.23101f},{1.65007f,-6.95f,2.23101f},{-1.64992f,6.95f,2.23101f},
	{-1.64992f,-6.95f,2.23101f},{1.65007f,6.88282f,2.00913f},{1.65007f,-6.88282f,2.00913f},
	{-1.64992f,6.88282f,2.00913f},{-1.64992f,-6.88282f,2.00913f},{1.65007f,6.67265f,1.69387f},
	{1.65007f,-6.67265f,1.69387f},{-1.64992f,6.67265f,1.69387f},{-1.64992f,-6.67265f,1.69387f},
	{1.65004f,6.58944f,1.64913f},{1.65004f,-6.58944f,1.64913f},{-1.64989f,6.58944f,1.64913f},
	{-1.64989f,-6.58944f,1.64913f},{1.65007f,4.50988f,6.04919f},{1.65007f,-4.50988f,6.04919f},
	{-1.64992f,4.50988f,6.04919f},{-1.64992f,-4.50988f,6.04919f},{1.65007f,3.48f,6.04935f},
	{1.65007f,-3.48f,6.04935f},{-1.64992f,3.48f,6.04935f},{-1.64992f,-3.48f,6.04935f},
	{1.65007f,2.28711f,6.44935f},{1.65007f,-2.28711f,6.44935f},{-1.64992f,2.28711f,6.44935f},
	{-1.64992f,-2.28711f,6.44935f},{1.65007f,2.9f,6.04935f},{1.65007f,-2.9f,6.04935f},
	{-1.64992f,2.9f,6.04935f},{-1.64992f,-2.9f,6.04935f},{1.65007f,2.5f,1.64934f},
	{1.65007f,-2.5f,1.64934f},{-1.64992f,2.5f,1.64934f},{-1.64992f,-2.5f,1.64934f},
	{1.65007f,2.58394f,1.83024f},{1.65007f,-2.58394f,1.83024f},{-1.64992f,2.58394f,1.83024f},
	{-1.64992f,-2.58394f,1.83024f},{4.30568f,2.5557f,1.82601f},{4.30568f,-2.5557f,1.82601f},
	{-4.30553f,2.5557f,1.82601f},{-4.30553f,-2.5557f,1.82601f},{4.46929f,2.43717f,1.72785f},
	{4.46929f,-2.43717f,1.72785f},{-4.46913f,2.43717f,1.72785f},{-4.46913f,-2.43717f,1.72785f},
	{4.56787f,2.27659f,1.66867f},{4.56787f,-2.27659f,1.66867f},{-4.56773f,2.27659f,1.66867f},
	{-4.56773f,-2.27659f,1.66867f},{4.60006f,2.1f,1.64934f},{4.60006f,-2.1f,1.64934f},
	{-4.59992f,2.1f,1.64934f},{-4.59992f,-2.1f,1.64934f},{1.65007f,2.59858f,4.34935f},
	{1.65007f,-2.59858f,4.34935f},{-1.64992f,2.59858f,4.34935f},{-1.64992f,-2.59858f,4.34935f},
	{4.10007f,2.6f,4.34935f},{4.10007f,-2.6f,4.34935f},{-4.09993f,2.6f,4.34935f},
	{-4.09993f,-2.6f,4.34935f},{4.45363f,2.45355f,4.34935f},{4.45363f,-2.45355f,4.34935f},
	{-4.45348f,2.45355f,4.34935f},{-4.45348f,-2.45355f,4.34935f},{4.56202f,2.29134f,4.34935f},
	{4.56202f,-2.29134f,4.34935f},{-4.56187f,2.29134f,4.34935f},{-4.56187f,-2.29134f,4.34935f},
	{4.60007f,2.1f,4.34935f},{4.60007f,-2.1f,4.34935f},{-4.59993f,2.1f,4.34935f},
	{-4.59993f,-2.1f,4.34935f},{1.45008f,6.58944f,1.44934f},{1.45008f,-6.58944f,1.44934f},
	{-1.44993f,6.58944f,1.44934f},{-1.44993f,-6.58944f,1.44934f},{4.40044f,2.1f,1.44942f},
	{4.40044f,-2.1f,1.44942f},{-4.40029f,2.1f,1.44942f},{-4.40029f,-2.1f,1.44942f},
	{1.45008f,2.1f,1.44934f},{1.45008f,-2.1f,1.44934f},{-1.44993f,2.1f,1.44934f},
	{-1.44993f,-2.1f,1.44934f},{-0.09747f,0.0f,6.99935f},{8.18383f,-1.43044f,5.86718f},
	{8.18383f,-1.43044f,6.26718f},{8.27519f,-0.73643f,5.86718f},{8.27519f,-0.73643f,6.26718f},
	{8.02733f,-0.703798f,5.86718f},{7.93596f,-1.39781f,5.86718f},{8.02733f,-0.703798f,6.26718f},
	{7.93596f,-1.39781f,6.26718f},{7.57165f,-2.75744f,6.26718f},{7.30377f,-3.40416f,6.26718f},
	{7.30377f,-3.40416f,5.86718f},{7.57165f,-2.75744f,5.86718f},{7.53475f,-3.49983f,6.26718f},
	{7.53475f,-3.49983f,5.86718f},{7.80262f,-2.85311f,6.26718f},{7.80262f,-2.85311f,5.86718f},
	{6.79831f,-4.77536f,5.86718f},{6.79831f,-4.77536f,6.26718f},{6.37219f,-5.33071f,5.86718f},
	{6.37219f,-5.33071f,6.26718f},{6.59997f,-4.62317f,5.86718f},{6.17384f,-5.17852f,5.86718f},
	{6.17384f,-5.17852f,6.26718f},{6.59997f,-4.62317f,6.26718f},{5.17852f,-6.17384f,6.26718f},
	{4.62317f,-6.59997f,6.26718f},{4.62317f,-6.59997f,5.86718f},{5.17852f,-6.17384f,5.86718f},
	{4.77537f,-6.79832f,6.26718f},{4.77537f,-6.79832f,5.86718f},{5.33071f,-6.37218f,6.26718f},
	{5.33071f,-6.37218f,5.86718f},{3.49983f,-7.53474f,5.86718f},{3.49983f,-7.53474f,6.26718f},
	{2.85312f,-7.80263f,5.86718f},{2.85312f,-7.80263f,6.26718f},{3.40416f,-7.30377f,5.86718f},
	{2.75744f,-7.57165f,5.86718f},{2.75744f,-7.57165f,6.26718f},{3.40416f,-7.30377f,6.26718f},
	{1.39781f,-7.93596f,6.26718f},{0.703796f,-8.02733f,6.26718f},{0.703796f,-8.02733f,5.86718f},
	{1.39781f,-7.93596f,5.86718f},{0.736431f,-8.2752f,6.26718f},{0.736431f,-8.2752f,5.86718f},
	{1.43044f,-8.18382f,6.26718f},{1.43044f,-8.18382f,5.86718f},{-0.736431f,-8.27519f,5.86718f},
	{-0.736431f,-8.27519f,6.26718f},{-1.43044f,-8.18383f,5.86718f},{-1.43044f,-8.18383f,6.26718f},
	{-0.703799f,-8.02733f,5.86718f},{-1.39781f,-7.93596f,5.86718f},{-1.39781f,-7.93596f,6.26718f},
	{-0.703799f,-8.02733f,6.26718f},{-2.75744f,-7.57165f,6.26718f},{-3.40416f,-7.30377f,6.26718f},
	{-3.40416f,-7.30377f,5.86718f},{-2.75744f,-7.57165f,5.86718f},{-3.49983f,-7.53475f,6.26718f},
	{-3.49983f,-7.53475f,5.86718f},{-2.85312f,-7.80262f,6.26718f},{-2.85312f,-7.80262f,5.86718f},
	{-4.77536f,-6.79831f,5.86718f},{-4.77536f,-6.79831f,6.26718f},{-5.33072f,-6.37219f,5.86718f},
	{-5.33072f,-6.37219f,6.26718f},{-4.62318f,-6.59998f,5.86718f},{-5.17852f,-6.17384f,5.86718f},
	{-5.17852f,-6.17384f,6.26718f},{-4.62318f,-6.59998f,6.26718f},{-6.17384f,-5.17852f,6.26718f},
	{-6.59998f,-4.62317f,6.26718f},{-6.59998f,-4.62317f,5.86718f},{-6.17384f,-5.17852f,5.86718f},
	{-6.79832f,-4.77537f,6.26718f},{-6.79832f,-4.77537f,5.86718f},{-6.37218f,-5.33071f,6.26718f},
	{-6.37218f,-5.33071f,5.86718f},{-7.53474f,-3.49983f,5.86718f},{-7.53474f,-3.49983f,6.26718f},
	{-7.80263f,-2.85312f,5.86718f},{-7.80263f,-2.85312f,6.26718f},{-7.30377f,-3.40416f,5.86718f},
	{-7.57165f,-2.75744f,5.86718f},{-7.57165f,-2.75744f,6.26718f},{-7.30377f,-3.40416f,6.26718f},
	{-7.93597f,-1.39781f,6.26718f},{-8.02733f,-0.703796f,6.26718f},{-8.02733f,-0.703796f,5.86718f},
	{-7.93597f,-1.39781f,5.86718f},{-8.2752f,-0.736431f,6.26718f},{-8.2752f,-0.736431f,5.86718f},
	{-8.18382f,-1.43044f,6.26718f},{-8.18382f,-1.43044f,5.86718f},{-8.27519f,0.736432f,5.86718f},
	{-8.27519f,0.736432f,6.26718f},{-8.18384f,1.43044f,5.86718f},{-8.18384f,1.43044f,6.26718f},
	{-8.02734f,0.7038f,5.86718f},{-7.93596f,1.39781f,5.86718f},{-7.93596f,1.39781f,6.26718f},
	{-8.02734f,0.7038f,6.26718f},{-7.57165f,2.75745f,6.26718f},{-7.30377f,3.40416f,6.26718f},
	{-7.30377f,3.40416f,5.86718f},{-7.57165f,2.75745f,5.86718f},{-7.53475f,3.49984f,6.26718f},
	{-7.53475f,3.49984f,5.86718f},{-7.80262f,2.85312f,6.26718f},{-7.80262f,2.85312f,5.86718f},
	{-6.79831f,4.77537f,5.86718f},{-6.79831f,4.77537f,6.26718f},{-6.37219f,5.33072f,5.86718f},
	{-6.37219f,5.33072f,6.26718f},{-6.59998f,4.62318f,5.86718f},{-6.17384f,5.17852f,5.86718f},
	{-6.17384f,5.17852f,6.26718f},{-6.59998f,4.62318f,6.26718f},{-5.17852f,6.17384f,6.26718f},
	{-4.62317f,6.59998f,6.26718f},{-4.62317f,6.59998f,5.86718f},{-5.17852f,6.17384f,5.86718f},
	{-4.77537f,6.79832f,6.26718f},{-4.77537f,6.79832f,5.86718f},{-5.33071f,6.37218f,6.26718f},
	{-5.33071f,6.37218f,5.86718f},{-3.49983f,7.53475f,5.86718f},{-3.49983f,7.53475f,6.26718f},
	{-2.85312f,7.80263f,5.86718f},{-2.85312f,7.80263f,6.26718f},{-3.40416f,7.30378f,5.86718f},
	{-2.75744f,7.57165f,5.86718f},{-2.75744f,7.57165f,6.26718f},{-3.40416f,7.30378f,6.26718f},
	{-1.39781f,7.93597f,6.26718f},{-0.703795f,8.02734f,6.26718f},{-0.703795f,8.02734f,5.86718f},
	{-1.39781f,7.93597f,5.86718f},{-0.73643f,8.27521f,6.26718f},{-0.73643f,8.27521f,5.86718f},
	{-1.43044f,8.18383f,6.26718f},{-1.43044f,8.18383f,5.86718f},{0.736433f,8.2752f,5.86718f},
	{0.736433f,8.2752f,6.26718f},{1.43044f,8.18384f,5.86718f},{1.43044f,8.18384f,6.26718f},
	{0.703801f,8.02734f,5.86718f},{1.39781f,7.93597f,5.86718f},{1.39781f,7.93597f,6.26718f},
	{0.703801f,8.02734f,6.26718f},{2.75745f,7.57165f,6.26718f},{3.40416f,7.30377f,6.26718f},
	{3.40416f,7.30377f,5.86718f},{2.75745f,7.57165f,5.86718f},{3.49984f,7.53475f,6.26718f},
	{3.49984f,7.53475f,5.86718f},{2.85312f,7.80262f,6.26718f},{2.85312f,7.80262f,5.86718f},
	{4.77537f,6.79831f,5.86718f},{4.77537f,6.79831f,6.26718f},{5.33072f,6.37219f,5.86718f},
	{5.33072f,6.37219f,6.26718f},{4.62318f,6.59998f,5.86718f},{5.17852f,6.17384f,5.86718f},
	{5.17852f,6.17384f,6.26718f},{4.62318f,6.59998f,6.26718f},{6.17385f,5.17852f,6.26718f},
	{6.59998f,4.62317f,6.26718f},{6.59998f,4.62317f,5.86718f},{6.17385f,5.17852f,5.86718f},
	{6.79833f,4.77537f,6.26718f},{6.79833f,4.77537f,5.86718f},{6.37219f,5.33071f,6.26718f},
	{6.37219f,5.33071f,5.86718f},{7.53475f,3.49983f,5.86718f},{7.53475f,3.49983f,6.26718f},
	{7.80264f,2.85312f,5.86718f},{7.80264f,2.85312f,6.26718f},{7.30378f,3.40416f,5.86718f},
	{7.57166f,2.75744f,5.86718f},{7.57166f,2.75744f,6.26718f},{7.30378f,3.40416f,6.26718f},
	{7.93597f,1.39781f,6.26718f},{8.02734f,0.703794f,6.26718f},{8.02734f,0.703794f,5.86718f},
	{7.93597f,1.39781f,5.86718f},{8.27521f,0.73643f,6.26718f},{8.27521f,0.73643f,5.86718f},
	{8.18383f,1.43044f,6.26718f},{8.18383f,1.43044f,5.86718f},{8.2752f,-0.736434f,5.86718f},
	{8.2752f,-0.736434f,6.26718f},{8.18384f,-1.43044f,5.86718f},{8.18384f,-1.43044f,6.26718f},
	{8.02734f,-0.703801f,5.86718f},{7.93597f,-1.39781f,5.86718f},{7.93597f,-1.39781f,6.26718f},
	{8.02734f,-0.703801f,6.26718f}
	};
	static GLfloat normals [1566][3] = {
	{-1.0f,0.0f,0.0f},{-1.0f,-1.98523e-023f,0.0f},{1.0f,0.0f,0.0f},
	{1.0f,1.98523e-023f,0.0f},{-1.0f,2.96124e-017f,0.0f},{1.0f,-2.96124e-017f,0.0f},
	{-1.0f,-2.11758e-022f,0.0f},{1.0f,2.11758e-022f,0.0f},{-1.0f,-7.40314e-017f,0.0f},
	{1.0f,7.40314e-017f,0.0f},{2.17136e-007f,1.0f,-0.000263468f},{1.14663e-007f,0.986658f,-0.162804f},
	{2.61895e-007f,0.973856f,-0.227167f},{-6.00243e-010f,1.0f,-0.000264155f},{2.24355e-007f,0.986716f,0.162457f},
	{2.19177e-007f,0.973895f,0.226998f},{1.14663e-007f,-0.986658f,-0.162804f},{2.17136e-007f,-1.0f,-0.000263468f},
	{2.61895e-007f,-0.973856f,-0.227167f},{-6.00243e-010f,-1.0f,-0.000264155f},{2.24355e-007f,-0.986716f,0.162457f},
	{2.19177e-007f,-0.973895f,0.226998f},{-1.14663e-007f,0.986658f,-0.162804f},{-2.17136e-007f,1.0f,-0.000263468f},
	{-2.61895e-007f,0.973856f,-0.227167f},{6.00243e-010f,1.0f,-0.000264155f},{-2.24355e-007f,0.986716f,0.162457f},
	{-2.19177e-007f,0.973895f,0.226998f},{-2.17136e-007f,-1.0f,-0.000263468f},{-1.14663e-007f,-0.986658f,-0.162804f},
	{-2.61895e-007f,-0.973856f,-0.227167f},{6.00243e-010f,-1.0f,-0.000264155f},{-2.24355e-007f,-0.986716f,0.162457f},
	{-2.19177e-007f,-0.973895f,0.226998f},{9.38874e-008f,0.935939f,-0.352162f},{4.2192e-008f,0.910825f,-0.412793f},
	{5.47876e-008f,0.935939f,0.352163f},{3.85116e-008f,0.910825f,0.412793f},{9.38874e-008f,-0.935939f,-0.352162f},
	{4.2192e-008f,-0.910825f,-0.412793f},{5.47876e-008f,-0.935939f,0.352163f},{3.85116e-008f,-0.910825f,0.412793f},
	{-9.38874e-008f,0.935939f,-0.352162f},{-4.2192e-008f,0.910825f,-0.412793f},{-5.47876e-008f,0.935939f,0.352163f},
	{-3.85116e-008f,0.910825f,0.412793f},{-9.38874e-008f,-0.935939f,-0.352162f},{-4.2192e-008f,-0.910825f,-0.412793f},
	{-5.47876e-008f,-0.935939f,0.352163f},{-3.85116e-008f,-0.910825f,0.412793f},{-8.88037e-008f,0.849251f,-0.527989f},
	{-2.0721e-007f,0.812791f,-0.582555f},{-8.07604e-008f,0.849252f,0.527989f},{-2.81664e-007f,0.812792f,0.582555f},
	{-8.88037e-008f,-0.849251f,-0.527989f},{-2.0721e-007f,-0.812791f,-0.582555f},{-8.07604e-008f,-0.849252f,0.527989f},
	{-2.81664e-007f,-0.812792f,0.582555f},{8.88037e-008f,0.849251f,-0.527989f},{2.0721e-007f,0.812791f,-0.582555f},
	{8.07604e-008f,0.849252f,0.527989f},{2.81664e-007f,0.812792f,0.582555f},{8.88037e-008f,-0.849251f,-0.527989f},
	{2.0721e-007f,-0.812791f,-0.582555f},{8.07604e-008f,-0.849252f,0.527989f},{2.81664e-007f,-0.812792f,0.582555f},
	{-3.61668e-007f,0.729927f,-0.683525f},{-3.0334e-007f,0.683523f,-0.729929f},{-5.49903e-007f,0.729927f,0.683525f},
	{-5.78022e-007f,0.683523f,0.729929f},{-3.61668e-007f,-0.729927f,-0.683525f},{-3.0334e-007f,-0.683523f,-0.729929f},
	{-5.49903e-007f,-0.729927f,0.683525f},{-5.78022e-007f,-0.683523f,0.729929f},{3.61668e-007f,0.729927f,-0.683525f},
	{3.0334e-007f,0.683523f,-0.729929f},{5.49903e-007f,0.729927f,0.683525f},{5.78022e-007f,0.683523f,0.729929f},
	{3.61668e-007f,-0.729927f,-0.683525f},{3.0334e-007f,-0.683523f,-0.729929f},{5.49903e-007f,-0.729927f,0.683525f},
	{5.78022e-007f,-0.683523f,0.729929f},{-2.48842e-007f,0.634393f,-0.773011f},{0.0f,0.634394f,-0.77301f},
	{-5.2696e-007f,0.634393f,0.773011f},{-2.34204e-007f,0.634394f,0.77301f},{-2.48842e-007f,-0.634393f,-0.773011f},
	{0.0f,-0.634394f,-0.77301f},{-5.2696e-007f,-0.634393f,0.773011f},{-2.34204e-007f,-0.634394f,0.77301f},
	{2.48842e-007f,0.634393f,-0.773011f},{5.2696e-007f,0.634393f,0.773011f},{2.34204e-007f,0.634394f,0.77301f},
	{2.48842e-007f,-0.634393f,-0.773011f},{5.2696e-007f,-0.634393f,0.773011f},{2.34204e-007f,-0.634394f,0.77301f},
	{-1.16686e-008f,-0.0651283f,-0.997877f},{4.93546e-009f,-0.162802f,-0.986659f},{-1.63191e-007f,-0.227168f,-0.973856f},
	{5.4024e-008f,-0.0321327f,-0.999484f},{1.42169e-008f,-0.162803f,0.986659f},{-6.95193e-009f,-0.0651285f,0.997877f},
	{-1.4026e-007f,-0.227168f,0.973856f},{5.40242e-008f,-0.0321329f,0.999484f},{4.93546e-009f,0.162802f,-0.986659f},
	{-1.16686e-008f,0.0651284f,-0.997877f},{-1.63191e-007f,0.227168f,-0.973856f},{5.40241e-008f,0.0321328f,-0.999484f},
	{-6.95186e-009f,0.0651286f,0.997877f},{1.42169e-008f,0.162803f,0.986659f},{-1.4026e-007f,0.227168f,0.973856f},
	{5.40243e-008f,0.032133f,0.999484f},{-4.93546e-009f,-0.162802f,-0.986659f},{1.16686e-008f,-0.0651283f,-0.997877f},
	{1.63191e-007f,-0.227168f,-0.973856f},{-5.4024e-008f,-0.0321327f,-0.999484f},{6.95193e-009f,-0.0651285f,0.997877f},
	{-1.42169e-008f,-0.162803f,0.986659f},{1.4026e-007f,-0.227168f,0.973856f},{-5.40242e-008f,-0.0321329f,0.999484f},
	{1.16686e-008f,0.0651284f,-0.997877f},{-4.93546e-009f,0.162802f,-0.986659f},{1.63191e-007f,0.227168f,-0.973856f},
	{-5.40241e-008f,0.0321328f,-0.999484f},{-1.42169e-008f,0.162803f,0.986659f},{6.95186e-009f,0.0651286f,0.997877f},
	{1.4026e-007f,0.227168f,0.973856f},{-5.40243e-008f,0.032133f,0.999484f},{-6.74401e-008f,-0.352162f,-0.935939f},
	{-1.50191e-007f,-0.412792f,-0.910825f},{-3.66629e-008f,-0.352162f,0.935939f},{-1.04396e-007f,-0.412791f,0.910826f},
	{-6.74401e-008f,0.352162f,-0.935939f},{-1.50191e-007f,0.412792f,-0.910825f},{-3.66629e-008f,0.352162f,0.935939f},
	{-1.04396e-007f,0.412791f,0.910826f},{6.74401e-008f,-0.352162f,-0.935939f},{1.50191e-007f,-0.412792f,-0.910825f},
	{3.66629e-008f,-0.352162f,0.935939f},{1.04396e-007f,-0.412791f,0.910826f},{6.74401e-008f,0.352162f,-0.935939f},
	{1.50191e-007f,0.412792f,-0.910825f},{3.66629e-008f,0.352162f,0.935939f},{1.04396e-007f,0.412791f,0.910826f},
	{5.07286e-008f,-0.527987f,-0.849252f},{-8.79744e-008f,-0.582554f,-0.812792f},{1.00024e-007f,-0.527986f,0.849253f},
	{-6.59592e-008f,-0.582553f,0.812793f},{5.07286e-008f,0.527987f,-0.849252f},{-8.79744e-008f,0.582554f,-0.812792f},
	{1.00024e-007f,0.527986f,0.849253f},{-6.59592e-008f,0.582553f,0.812793f},{-5.07286e-008f,-0.527987f,-0.849252f},
	{8.79744e-008f,-0.582554f,-0.812792f},{-1.00024e-007f,-0.527986f,0.849253f},{6.59592e-008f,-0.582553f,0.812793f},
	{-5.07286e-008f,0.527987f,-0.849252f},{8.79744e-008f,0.582554f,-0.812792f},{-1.00024e-007f,0.527986f,0.849253f},
	{6.59592e-008f,0.582553f,0.812793f},{4.28618e-008f,-0.683523f,-0.729928f},{-2.69875e-007f,-0.729928f,-0.683524f},
	{3.32468e-008f,-0.683523f,0.729929f},{-2.7251e-007f,-0.729929f,0.683523f},{4.28618e-008f,0.683523f,-0.729928f},
	{-2.69875e-007f,0.729928f,-0.683524f},{3.32468e-008f,0.683523f,0.729929f},{-2.7251e-007f,0.729929f,0.683523f},
	{-4.28618e-008f,-0.683523f,-0.729928f},{2.69875e-007f,-0.729928f,-0.683524f},{-3.32468e-008f,-0.683523f,0.729929f},
	{2.7251e-007f,-0.729929f,0.683523f},{-4.28618e-008f,0.683523f,-0.729928f},{2.69875e-007f,0.729928f,-0.683524f},
	{-3.32468e-008f,0.683523f,0.729929f},{2.7251e-007f,0.729929f,0.683523f},{-2.03648e-007f,-0.812791f,-0.582555f},
	{-3.25761e-007f,-0.849251f,-0.527989f},{-1.73652e-007f,-0.812792f,0.582554f},{-2.83702e-007f,-0.849251f,0.527989f},
	{-2.03648e-007f,0.812791f,-0.582555f},{-3.25761e-007f,0.849251f,-0.527989f},{-1.73652e-007f,0.812792f,0.582554f},
	{-2.83702e-007f,0.849251f,0.527989f},{2.03648e-007f,-0.812791f,-0.582555f},{3.25761e-007f,-0.849251f,-0.527989f},
	{1.73652e-007f,-0.812792f,0.582554f},{2.83702e-007f,-0.849251f,0.527989f},{2.03648e-007f,0.812791f,-0.582555f},
	{3.25761e-007f,0.849251f,-0.527989f},{1.73652e-007f,0.812792f,0.582554f},{2.83702e-007f,0.849251f,0.527989f},
	{9.47368e-008f,-0.910824f,-0.412795f},{1.5757e-007f,-0.935938f,-0.352164f},{1.12666e-007f,-0.910824f,0.412795f},
	{1.20767e-007f,-0.935938f,0.352164f},{9.47368e-008f,0.910824f,-0.412795f},{1.5757e-007f,0.935938f,-0.352164f},
	{1.12666e-007f,0.910824f,0.412795f},{1.20767e-007f,0.935938f,0.352164f},{-9.47368e-008f,-0.910824f,-0.412795f},
	{-1.5757e-007f,-0.935938f,-0.352164f},{-1.12666e-007f,-0.910824f,0.412795f},{-1.20767e-007f,-0.935938f,0.352164f},
	{-9.47368e-008f,0.910824f,-0.412795f},{-1.5757e-007f,0.935938f,-0.352164f},{-1.12666e-007f,0.910824f,0.412795f},
	{-1.20767e-007f,0.935938f,0.352164f},{4.94911e-007f,-0.973855f,-0.22717f},{1.53044e-007f,-0.986658f,-0.162804f},
	{4.46447e-007f,-0.973895f,0.226999f},{3.97069e-007f,-0.986716f,0.162457f},{4.94911e-007f,0.973855f,-0.22717f},
	{1.53044e-007f,0.986658f,-0.162804f},{4.46447e-007f,0.973895f,0.226999f},{3.97069e-007f,0.986716f,0.162457f},
	{-4.94911e-007f,-0.973855f,-0.22717f},{-1.53044e-007f,-0.986658f,-0.162804f},{-4.46447e-007f,-0.973895f,0.226999f},
	{-3.97069e-007f,-0.986716f,0.162457f},{-4.94911e-007f,0.973855f,-0.22717f},{-1.53044e-007f,0.986658f,-0.162804f},
	{-4.46447e-007f,0.973895f,0.226999f},{-3.97069e-007f,0.986716f,0.162457f},{4.10083e-007f,-1.0f,-0.000263736f},
	{-1.17271e-009f,-1.0f,-0.000262418f},{4.10083e-007f,1.0f,-0.000263736f},{-1.17271e-009f,1.0f,-0.000262418f},
	{-4.10083e-007f,-1.0f,-0.000263736f},{1.17271e-009f,-1.0f,-0.000262418f},{-4.10083e-007f,1.0f,-0.000263736f},
	{1.17271e-009f,1.0f,-0.000262418f},{-7.17492e-010f,5.88916e-008f,-1.0f},{0.0f,5.89062e-008f,-1.0f},
	{-7.17465e-010f,5.89062e-008f,1.0f},{0.0f,5.89062e-008f,1.0f},{7.17492e-010f,5.88916e-008f,-1.0f},
	{7.17465e-010f,5.89062e-008f,1.0f},{0.0f,-0.00124464f,0.999999f},{0.0f,-1.22993e-007f,1.0f},
	{3.78721e-007f,-1.23022e-007f,-1.0f},{3.78721e-007f,-0.00124466f,-0.999999f},{4.54465e-007f,-1.23051e-007f,-1.0f},
	{3.02977e-007f,-0.00124459f,-0.999999f},{0.0f,0.00124439f,0.999999f},{3.78721e-007f,0.00124441f,-0.999999f},
	{3.02977e-007f,0.00124434f,-0.999999f},{-3.78721e-007f,-0.00124466f,-0.999999f},{-3.78721e-007f,-1.23022e-007f,-1.0f},
	{-4.54465e-007f,-1.23051e-007f,-1.0f},{-3.02977e-007f,-0.00124459f,-0.999999f},{-3.78721e-007f,0.00124441f,-0.999999f},
	{-3.02977e-007f,0.00124434f,-0.999999f},{0.0f,1.0f,0.0f},{0.943759f,0.329314f,-0.0295267f},
	{0.839705f,0.500701f,-0.210225f},{0.72411f,0.681012f,-0.109029f},{0.72411f,-0.681012f,-0.109029f},
	{0.839705f,-0.500701f,-0.210225f},{0.943759f,-0.329314f,-0.0295267f},{-0.724108f,0.681013f,-0.109032f},
	{-0.839702f,0.500697f,-0.210244f},{-0.943757f,0.329318f,-0.0295485f},{-0.943757f,-0.329318f,-0.0295485f},
	{-0.839702f,-0.500697f,-0.210244f},{-0.724108f,-0.681013f,-0.109032f},{0.000967516f,0.999972f,-0.00741591f},
	{0.126351f,0.990979f,-0.0446749f},{0.00138336f,0.980651f,-0.19576f},{0.00138336f,-0.980651f,-0.19576f},
	{0.126351f,-0.990979f,-0.0446749f},{0.000967516f,-0.999972f,-0.00741591f},{-0.00138337f,0.980651f,-0.19576f},
	{-0.126348f,0.990979f,-0.0446742f},{-0.000967518f,0.999972f,-0.00741591f},{-0.000967518f,-0.999972f,-0.00741591f},
	{-0.126348f,-0.990979f,-0.0446742f},{-0.00138337f,-0.980651f,-0.19576f},{0.194812f,0.98084f,-0.000689926f},
	{0.194812f,-0.98084f,-0.000689926f},{-0.194812f,0.98084f,-0.00069033f},{-0.194812f,-0.98084f,-0.00069033f},
	{0.0737877f,0.927789f,-0.365736f},{0.0737877f,-0.927789f,-0.365736f},{-0.0737873f,0.927789f,-0.365735f},
	{-0.0737873f,-0.927789f,-0.365735f},{1.0f,7.11563e-006f,-4.93684e-006f},{1.0f,-6.04324e-006f,-1.00015e-005f},
	{1.0f,5.15496e-007f,-2.47908e-007f},{1.0f,-5.15496e-007f,-2.47908e-007f},{1.0f,6.04324e-006f,-1.00015e-005f},
	{1.0f,-7.11563e-006f,-4.93684e-006f},{-1.0f,5.15496e-007f,-2.47908e-007f},{-1.0f,-6.04324e-006f,-1.00015e-005f},
	{-1.0f,7.11563e-006f,-4.93684e-006f},{-1.0f,-7.11563e-006f,-4.93684e-006f},{-1.0f,6.04324e-006f,-1.00015e-005f},
	{-1.0f,-5.15496e-007f,-2.47908e-007f},{0.995042f,0.0153104f,-0.0982738f},{0.995042f,-0.0153104f,-0.0982738f},
	{-0.995042f,0.0153108f,-0.0982741f},{-0.995042f,-0.0153108f,-0.0982741f},{0.99551f,-0.0739067f,-0.0591392f},
	{0.99551f,0.0739067f,-0.0591392f},{-0.99551f,-0.0739067f,-0.0591392f},{-0.99551f,0.0739067f,-0.0591392f},
	{0.992739f,0.115041f,-0.035145f},{0.992739f,-0.115041f,-0.035145f},{-0.992739f,0.115041f,-0.035145f},
	{-0.992739f,-0.115041f,-0.035145f},{0.973135f,0.0814304f,-0.215353f},{0.992174f,0.124285f,-0.012006f},
	{0.992174f,-0.124285f,-0.012006f},{0.973135f,-0.0814304f,-0.215353f},{-0.992174f,0.124285f,-0.012006f},
	{-0.973135f,0.0814305f,-0.215353f},{-0.973135f,-0.0814305f,-0.215353f},{-0.992174f,-0.124285f,-0.012006f},
	{0.994647f,0.0935772f,-0.04382f},{0.994647f,-0.0935772f,-0.04382f},{-0.994647f,0.0935772f,-0.04382f},
	{-0.994647f,-0.0935772f,-0.04382f},{0.921107f,0.183107f,-0.343559f},{0.988764f,0.109955f,-0.101272f},
	{0.988764f,-0.109955f,-0.101272f},{0.921107f,-0.183107f,-0.343559f},{-0.988764f,0.109955f,-0.101273f},
	{-0.921107f,0.183107f,-0.34356f},{-0.921107f,-0.183107f,-0.34356f},{-0.988764f,-0.109955f,-0.101273f},
	{0.929538f,0.0879551f,-0.358082f},{0.929538f,-0.0879551f,-0.358082f},{-0.929538f,0.0879566f,-0.358082f},
	{-0.929538f,-0.0879566f,-0.358082f},{0.929558f,0.248423f,-0.272411f},{0.929558f,-0.248423f,-0.272411f},
	{-0.929558f,0.248423f,-0.272412f},{-0.929558f,-0.248423f,-0.272412f},{0.995376f,4.78961e-006f,-0.0960505f},
	{0.995376f,-4.78961e-006f,-0.0960505f},{-0.995376f,4.78961e-006f,-0.0960505f},{-0.995376f,-4.78961e-006f,-0.0960505f},
	{0.0f,0.0f,-1.0f},{-0.764713f,-0.584011f,-0.272298f},{-0.719105f,-0.161171f,-0.675953f},
	{-0.482209f,-0.398239f,-0.780308f},{-0.482209f,0.398239f,-0.780308f},{-0.719105f,0.161171f,-0.675953f},
	{-0.764713f,0.584011f,-0.272298f},{0.482204f,-0.398239f,-0.780311f},{0.719109f,-0.161169f,-0.675949f},
	{0.764714f,-0.584011f,-0.272294f},{0.764714f,0.584011f,-0.272294f},{0.719109f,0.161169f,-0.675949f},
	{0.482204f,0.398239f,-0.780311f},{-0.959004f,-0.238789f,-0.152613f},{-0.959004f,0.238789f,-0.152613f},
	{0.959009f,-0.238775f,-0.152607f},{0.959009f,0.238775f,-0.152607f},{-0.706534f,-0.707679f,-0.000200523f},
	{-0.706534f,0.707679f,-0.000200523f},{0.706534f,-0.707679f,-0.000202026f},{0.706534f,0.707679f,-0.000202026f},
	{-0.944674f,-0.327525f,-0.0178598f},{-0.944674f,0.327525f,-0.0178598f},{0.944683f,-0.327498f,-0.0178614f},
	{0.944683f,0.327498f,-0.0178614f},{-0.757239f,3.38662e-006f,-0.653138f},{-0.757232f,0.0f,-0.653146f},
	{-0.757243f,8.7254e-006f,-0.653133f},{-0.757243f,-8.7254e-006f,-0.653133f},{-0.757239f,-3.38662e-006f,-0.653138f},
	{0.757241f,6.76844e-006f,-0.653135f},{0.757293f,0.0f,-0.653076f},{0.757299f,2.61516e-006f,-0.653069f},
	{0.757299f,-2.61516e-006f,-0.653069f},{0.757241f,-6.76844e-006f,-0.653135f},{-0.757257f,8.7254e-006f,-0.653117f},
	{-0.757257f,-8.7254e-006f,-0.653117f},{0.757252f,6.76844e-006f,-0.653123f},{0.757252f,-6.76844e-006f,-0.653123f},
	{0.995589f,0.0938166f,0.000426043f},{0.995205f,0.0f,-0.0978133f},{0.991389f,0.096442f,-0.0885778f},
	{0.991389f,-0.096442f,-0.0885778f},{0.995589f,-0.0938166f,0.000426043f},{-0.991386f,0.0964449f,-0.0886114f},
	{-0.995202f,0.0f,-0.0978402f},{-0.995589f,0.0938166f,0.000426043f},{-0.995589f,-0.0938166f,0.000426043f},
	{-0.991386f,-0.0964449f,-0.0886114f},{1.0f,0.0f,0.00063437f},{-1.0f,0.0f,0.00063437f},
	{0.0f,0.0f,1.0f},{0.0f,0.000454556f,-1.0f},{7.27596e-012f,-0.000310607f,-1.0f},
	{8.43193e-005f,-8.87448e-005f,-1.0f},{8.43193e-005f,8.87448e-005f,-1.0f},{7.27596e-012f,0.000310607f,-1.0f},
	{0.0f,-0.000454556f,-1.0f},{-8.43193e-005f,-8.87448e-005f,-1.0f},{-8.43193e-005f,8.87448e-005f,-1.0f},
	{0.000231744f,0.000112914f,-1.0f},{0.000231744f,-0.000112914f,-1.0f},{-0.000231744f,0.000112914f,-1.0f},
	{-0.000231744f,-0.000112914f,-1.0f},{0.995368f,0.0854608f,-0.044033f},{0.920216f,0.386568f,-0.0613791f},
	{0.78158f,0.616295f,0.0965069f},{0.78158f,-0.616295f,0.0965069f},{0.920216f,-0.386568f,-0.0613791f},
	{0.995368f,-0.0854608f,-0.044033f},{-0.78158f,0.616296f,0.0965013f},{-0.920215f,0.386572f,-0.0613796f},
	{-0.995368f,0.0854608f,-0.0440331f},{-0.995368f,-0.0854608f,-0.0440331f},{-0.920215f,-0.386572f,-0.0613796f},
	{-0.78158f,-0.616296f,0.0965013f},{0.632696f,0.302513f,-0.712869f},{0.42062f,0.877399f,-0.230761f},
	{0.668236f,0.703636f,-0.241573f},{0.668236f,-0.703636f,-0.241573f},{0.42062f,-0.877399f,-0.230761f},
	{0.632696f,-0.302513f,-0.712869f},{-0.668234f,0.703637f,-0.241573f},{-0.420623f,0.877397f,-0.230761f},
	{-0.632695f,0.302512f,-0.71287f},{-0.632695f,-0.302512f,-0.71287f},{-0.420623f,-0.877397f,-0.230761f},
	{-0.668234f,-0.703637f,-0.241573f},{0.376479f,0.854319f,-0.358334f},{0.376479f,-0.854319f,-0.358334f},
	{-0.376479f,0.854317f,-0.358337f},{-0.376479f,-0.854317f,-0.358337f},{0.083186f,0.97596f,-0.201451f},
	{0.083186f,-0.97596f,-0.201451f},{-0.083186f,0.97596f,-0.201452f},{-0.083186f,-0.97596f,-0.201452f},
	{0.0948116f,0.942955f,-0.319135f},{0.0948116f,-0.942955f,-0.319135f},{-0.0948114f,0.942954f,-0.319136f},
	{-0.0948114f,-0.942954f,-0.319136f},{0.909873f,0.383621f,-0.158007f},{0.942039f,0.32694f,-0.0753167f},
	{0.942039f,-0.32694f,-0.0753167f},{0.909873f,-0.383621f,-0.158007f},{-0.942039f,0.32694f,-0.0753168f},
	{-0.909873f,0.383621f,-0.158008f},{-0.909873f,-0.383621f,-0.158008f},{-0.942039f,-0.32694f,-0.0753168f},
	{0.74957f,-0.44662f,-0.488545f},{0.392121f,-0.813216f,-0.430024f},{0.671644f,-0.504465f,-0.542594f},
	{0.671644f,0.504465f,-0.542594f},{0.392121f,0.813216f,-0.430024f},{0.74957f,0.44662f,-0.488545f},
	{-0.671645f,-0.504466f,-0.542593f},{-0.392121f,-0.813215f,-0.430025f},{-0.74957f,-0.446619f,-0.488545f},
	{-0.74957f,0.446619f,-0.488545f},{-0.392121f,0.813215f,-0.430025f},{-0.671645f,0.504466f,-0.542593f},
	{0.261767f,-0.698878f,-0.665619f},{0.261767f,0.698878f,-0.665619f},{-0.261768f,-0.698878f,-0.665618f},
	{-0.261768f,0.698878f,-0.665618f},{0.425575f,-0.450315f,-0.784922f},{0.425575f,0.450315f,-0.784922f},
	{-0.425579f,-0.450317f,-0.784918f},{-0.425579f,0.450317f,-0.784918f},{-0.191283f,-0.151786f,-0.969728f},
	{-0.161623f,-0.0897911f,-0.982759f},{-0.467841f,-0.259913f,-0.844731f},{-0.467841f,0.259913f,-0.844731f},
	{-0.161623f,0.0897911f,-0.982759f},{-0.191283f,0.151786f,-0.969728f},{0.467842f,-0.259911f,-0.844731f},
	{0.161624f,-0.0897904f,-0.982759f},{0.191284f,-0.151785f,-0.969728f},{0.191284f,0.151785f,-0.969728f},
	{0.161624f,0.0897904f,-0.982759f},{0.467842f,0.259911f,-0.844731f},{0.671825f,-0.0974555f,-0.734271f},
	{0.671825f,0.0974555f,-0.734271f},{-0.671825f,-0.0974555f,-0.734271f},{-0.671825f,0.0974555f,-0.734271f},
	{-0.0891978f,-0.182105f,-0.979225f},{-0.044648f,-0.0914402f,-0.994809f},{-0.044648f,0.0914402f,-0.994809f},
	{-0.0891978f,0.182105f,-0.979225f},{0.044648f,-0.0914402f,-0.994809f},{0.0891978f,-0.182105f,-0.979225f},
	{0.0891978f,0.182105f,-0.979225f},{0.044648f,0.0914402f,-0.994809f},{0.934198f,-0.165012f,-0.3163f},
	{0.934198f,0.165012f,-0.3163f},{-0.934197f,-0.165013f,-0.316301f},{-0.934197f,0.165013f,-0.316301f},
	{0.629049f,-0.0150451f,-0.77722f},{0.629049f,0.0150451f,-0.77722f},{-0.629051f,-0.0150461f,-0.777219f},
	{-0.629051f,0.0150461f,-0.777219f},{0.404876f,-0.24567f,-0.880751f},{0.404876f,0.24567f,-0.880751f},
	{-0.404879f,-0.245672f,-0.880749f},{-0.404879f,0.245672f,-0.880749f},{-0.3663f,-0.915384f,-0.167022f},
	{-0.294721f,-0.855281f,-0.426185f},{-0.294721f,0.855281f,-0.426185f},{-0.3663f,0.915384f,-0.167022f},
	{0.294714f,-0.855285f,-0.426182f},{0.366293f,-0.915388f,-0.16702f},{0.366293f,0.915388f,-0.16702f},
	{0.294714f,0.855285f,-0.426182f},{-0.746139f,0.209407f,-0.632001f},{-0.600823f,0.667563f,-0.43974f},
	{-0.173722f,0.388825f,-0.904785f},{-0.173722f,-0.388825f,-0.904785f},{-0.600823f,-0.667563f,-0.43974f},
	{-0.746139f,-0.209407f,-0.632001f},{0.173719f,0.388824f,-0.904786f},{0.600823f,0.667563f,-0.43974f},
	{0.746139f,0.209408f,-0.632001f},{0.746139f,-0.209408f,-0.632001f},{0.600823f,-0.667563f,-0.43974f},
	{0.173719f,-0.388824f,-0.904786f},{-0.424524f,0.261405f,-0.86686f},{-0.119861f,0.812975f,-0.569829f},
	{-0.119861f,-0.812975f,-0.569829f},{-0.424524f,-0.261405f,-0.86686f},{0.119859f,0.812974f,-0.56983f},
	{0.424517f,0.261404f,-0.866864f},{0.424517f,-0.261404f,-0.866864f},{0.119859f,-0.812974f,-0.56983f},
	{-0.12274f,0.180078f,-0.975964f},{-0.12274f,-0.180078f,-0.975964f},{0.12274f,0.180078f,-0.975965f},
	{0.12274f,-0.180078f,-0.975965f},{-0.780955f,0.55646f,-0.283657f},{-0.780955f,-0.55646f,-0.283657f},
	{0.780962f,0.556452f,-0.283653f},{0.780962f,-0.556452f,-0.283653f},{-0.731945f,0.681359f,-0.00231233f},
	{-0.731945f,-0.681359f,-0.00231233f},{0.731949f,0.681356f,-0.00230996f},{0.731949f,-0.681356f,-0.00230996f},
	{0.861859f,0.329363f,-0.385641f},{0.292779f,0.870397f,-0.39584f},{0.672741f,0.720253f,-0.169277f},
	{0.672741f,-0.720253f,-0.169277f},{0.292779f,-0.870397f,-0.39584f},{0.861859f,-0.329363f,-0.385641f},
	{-0.672741f,0.720253f,-0.169277f},{-0.292779f,0.870397f,-0.39584f},{-0.861859f,0.329363f,-0.385641f},
	{-0.861859f,-0.329363f,-0.385641f},{-0.292779f,-0.870397f,-0.39584f},{-0.672741f,-0.720253f,-0.169277f},
	{0.569902f,0.604495f,-0.556594f},{0.569902f,-0.604495f,-0.556594f},{-0.569904f,0.604493f,-0.556594f},
	{-0.569904f,-0.604493f,-0.556594f},{0.600023f,0.600046f,-0.529072f},{0.600023f,-0.600046f,-0.529072f},
	{-0.600027f,0.600044f,-0.52907f},{-0.600027f,-0.600044f,-0.52907f},{0.0547716f,0.121676f,-0.991058f},
	{0.0891372f,0.198755f,-0.975987f},{0.430243f,0.0504305f,-0.901303f},{0.430243f,-0.0504305f,-0.901303f},
	{0.0891372f,-0.198755f,-0.975987f},{0.0547716f,-0.121676f,-0.991058f},{-0.430244f,0.0504306f,-0.901303f},
	{-0.0891381f,0.198755f,-0.975987f},{-0.0547721f,0.121676f,-0.991057f},{-0.0547721f,-0.121676f,-0.991057f},
	{-0.0891381f,-0.198755f,-0.975987f},{-0.430244f,-0.0504306f,-0.901303f},{-0.00019825f,0.824265f,-0.566205f},
	{-0.00019825f,-0.824265f,-0.566205f},{0.000198249f,0.824265f,-0.566205f},{0.000198249f,-0.824265f,-0.566205f},
	{0.181849f,0.0180536f,-0.983161f},{0.302899f,0.0f,-0.953023f},{0.181849f,-0.0180536f,-0.983161f},
	{-0.302893f,0.0f,-0.953025f},{-0.181845f,0.0180545f,-0.983161f},{-0.181845f,-0.0180545f,-0.983161f},
	{0.258842f,0.0876464f,-0.961935f},{0.258842f,-0.0876464f,-0.961935f},{-0.258845f,0.0876479f,-0.961934f},
	{-0.258845f,-0.0876479f,-0.961934f},{-0.0205528f,0.044273f,-0.998808f},{-0.0205528f,-0.044273f,-0.998808f},
	{0.0205528f,0.044273f,-0.998808f},{0.0205528f,-0.044273f,-0.998808f},{0.457429f,0.732365f,-0.504381f},
	{0.384983f,0.793556f,-0.47123f},{0.525231f,0.824383f,-0.211009f},{0.525231f,-0.824383f,-0.211009f},
	{0.384983f,-0.793556f,-0.47123f},{0.457429f,-0.732365f,-0.504381f},{-0.525233f,0.824383f,-0.211004f},
	{-0.384984f,0.793558f,-0.471225f},{-0.457433f,0.732371f,-0.504369f},{-0.457433f,-0.732371f,-0.504369f},
	{-0.384984f,-0.793558f,-0.471225f},{-0.525233f,-0.824383f,-0.211004f},{0.353307f,0.912905f,-0.204396f},
	{0.353307f,-0.912905f,-0.204396f},{-0.353307f,0.912905f,-0.204397f},{-0.353307f,-0.912905f,-0.204397f},
	{0.24625f,0.831291f,-0.498313f},{0.24625f,-0.831291f,-0.498313f},{-0.24625f,0.83129f,-0.498315f},
	{-0.24625f,-0.83129f,-0.498315f},{0.192484f,0.953372f,-0.232446f},{0.192484f,-0.953372f,-0.232446f},
	{-0.192484f,0.953372f,-0.232447f},{-0.192484f,-0.953372f,-0.232447f},{0.0970125f,0.827152f,-0.553541f},
	{0.0970125f,-0.827152f,-0.553541f},{-0.0970125f,0.827152f,-0.553541f},{-0.0970125f,-0.827152f,-0.553541f},
	{2.46144e-010f,0.965776f,-0.259378f},{2.46144e-010f,-0.965776f,-0.259378f},{0.195089f,0.980786f,0.0f},
	{0.195089f,-0.980786f,0.0f},{-0.195089f,0.980786f,0.0f},{-0.195089f,-0.980786f,0.0f},
	{0.0f,-1.0f,0.0f},{9.31668e-010f,0.707105f,-0.707108f},{9.31668e-010f,-0.707105f,-0.707108f},
	{-0.0600118f,0.0355092f,-0.997566f},{-0.0600118f,-0.0355092f,-0.997566f},{0.0600118f,0.0355092f,-0.997566f},
	{0.0600118f,-0.0355092f,-0.997566f},{0.58299f,0.686482f,-0.434587f},{0.58299f,-0.686482f,-0.434587f},
	{-0.582992f,0.686484f,-0.434581f},{-0.582992f,-0.686484f,-0.434581f},{0.685991f,0.707243f,-0.17095f},
	{0.685991f,-0.707243f,-0.17095f},{-0.685991f,0.707243f,-0.170949f},{-0.685991f,-0.707243f,-0.170949f},
	{0.658974f,0.555915f,-0.506668f},{0.658974f,-0.555915f,-0.506668f},{-0.658973f,0.555914f,-0.506669f},
	{-0.658973f,-0.555914f,-0.506669f},{0.798922f,0.547546f,-0.248832f},{0.798922f,-0.547546f,-0.248832f},
	{-0.798921f,0.547546f,-0.248835f},{-0.798921f,-0.547546f,-0.248835f},{0.714367f,0.464594f,-0.523289f},
	{0.714367f,-0.464594f,-0.523289f},{-0.714364f,0.464593f,-0.523294f},{-0.714364f,-0.464593f,-0.523294f},
	{0.787651f,0.387365f,-0.479118f},{0.787651f,-0.387365f,-0.479118f},{-0.787648f,0.387363f,-0.479124f},
	{-0.787648f,-0.387363f,-0.479124f},{0.900544f,0.386255f,-0.199568f},{0.900544f,-0.386255f,-0.199568f},
	{-0.900544f,0.386254f,-0.19957f},{-0.900544f,-0.386254f,-0.19957f},{0.785483f,0.226213f,-0.576059f},
	{0.785483f,-0.226213f,-0.576059f},{-0.785483f,0.226213f,-0.576059f},{-0.785483f,-0.226213f,-0.576059f},
	{0.939776f,0.201665f,-0.275956f},{0.939776f,-0.201665f,-0.275956f},{-0.939776f,0.201665f,-0.275957f},
	{-0.939776f,-0.201665f,-0.275957f},{0.726943f,0.0f,-0.686698f},{-0.726941f,0.0f,-0.6867f},
	{0.983251f,0.0f,-0.182258f},{-0.98325f,0.0f,-0.182261f},{0.995981f,-0.00425824f,-0.089461f},
	{0.995981f,0.00425824f,-0.089461f},{-0.995981f,-0.00425465f,-0.0894611f},{-0.995981f,0.00425465f,-0.0894611f},
	{0.026594f,0.273989f,-0.961365f},{-7.49632e-012f,0.242829f,-0.970069f},{-7.49632e-012f,-0.242829f,-0.970069f},
	{0.026594f,-0.273989f,-0.961365f},{-0.0265941f,0.273989f,-0.961365f},{-0.0265941f,-0.273989f,-0.961365f},
	{0.0970315f,0.984877f,-0.143532f},{-1.36681e-012f,0.998124f,-0.0612288f},{0.0f,0.957601f,-0.288096f},
	{0.0978195f,0.993339f,-0.0608977f},{-1.36681e-012f,-0.998124f,-0.0612288f},{0.0970315f,-0.984877f,-0.143532f},
	{0.0f,-0.957601f,-0.288096f},{0.0978195f,-0.993339f,-0.0608977f},{-0.0970326f,0.984877f,-0.143532f},
	{-0.0978206f,0.993339f,-0.0608977f},{-0.0970326f,-0.984877f,-0.143532f},{-0.0978206f,-0.993339f,-0.0608977f},
	{-7.27597e-012f,0.470439f,-0.882433f},{0.0538498f,0.469405f,-0.88134f},{-7.27597e-012f,-0.470439f,-0.882433f},
	{0.0538498f,-0.469405f,-0.88134f},{-0.0538503f,0.469405f,-0.881339f},{-0.0538503f,-0.469405f,-0.881339f},
	{0.0801002f,0.90187f,-0.424517f},{0.0f,0.906115f,-0.423033f},{0.0801002f,-0.90187f,-0.424517f},
	{0.0f,-0.906115f,-0.423033f},{-0.0801011f,0.90187f,-0.424517f},{-0.0801011f,-0.90187f,-0.424517f},
	{0.0773426f,0.100297f,-0.991947f},{0.0f,0.163257f,-0.986584f},{0.0662176f,0.0479546f,-0.996652f},
	{0.0773426f,-0.100297f,-0.991947f},{0.0f,-0.163257f,-0.986584f},{0.0662176f,-0.0479546f,-0.996652f},
	{-0.0773435f,0.100297f,-0.991947f},{-0.0662182f,0.0479546f,-0.996652f},{-0.0773435f,-0.100297f,-0.991947f},
	{-0.0662182f,-0.0479546f,-0.996652f},{1.35157e-010f,0.952884f,-0.303335f},{0.0818397f,0.870909f,-0.484582f},
	{0.0f,0.879451f,-0.475989f},{0.0f,-0.879451f,-0.475989f},{0.0818397f,-0.870909f,-0.484582f},
	{1.35157e-010f,-0.952884f,-0.303335f},{-0.0818407f,0.870909f,-0.484582f},{-0.0818407f,-0.870909f,-0.484582f},
	{1.35558e-005f,0.0f,-1.0f},{-1.35559e-005f,0.0f,-1.0f},{0.0754386f,0.376667f,-0.923272f},
	{0.0f,0.472359f,-0.881406f},{0.0754386f,-0.376667f,-0.923272f},{0.0f,-0.472359f,-0.881406f},
	{-0.0754395f,0.376667f,-0.923272f},{-0.0754395f,-0.376667f,-0.923272f},{0.0f,0.808665f,-0.58827f},
	{0.0964505f,0.78111f,-0.616899f},{0.0f,-0.808665f,-0.58827f},{0.0964505f,-0.78111f,-0.616899f},
	{-0.0964516f,0.78111f,-0.616899f},{-0.0964516f,-0.78111f,-0.616899f},{0.0948356f,0.638281f,-0.763939f},
	{0.0f,0.702016f,-0.712161f},{0.0948356f,-0.638281f,-0.763939f},{0.0f,-0.702016f,-0.712161f},
	{-0.0948367f,0.638281f,-0.763939f},{-0.0948367f,-0.638281f,-0.763939f},{0.367398f,0.814188f,-0.449574f},
	{0.642728f,0.554696f,-0.528405f},{0.325985f,0.561595f,-0.760489f},{0.325985f,-0.561595f,-0.760489f},
	{0.642728f,-0.554696f,-0.528405f},{0.367398f,-0.814188f,-0.449574f},{-0.325988f,0.561597f,-0.760488f},
	{-0.642735f,0.55469f,-0.528404f},{-0.367399f,0.814188f,-0.449573f},{-0.367399f,-0.814188f,-0.449573f},
	{-0.642735f,-0.55469f,-0.528404f},{-0.325988f,-0.561597f,-0.760488f},{0.354211f,0.928539f,-0.111128f},
	{0.354211f,-0.928539f,-0.111128f},{-0.35421f,0.92854f,-0.111128f},{-0.35421f,-0.92854f,-0.111128f},
	{0.000127073f,0.97633f,-0.216286f},{-0.0174583f,0.984688f,-0.173448f},{0.0f,0.95789f,-0.287136f},
	{0.000253499f,0.984911f,-0.173061f},{-0.0174583f,-0.984688f,-0.173448f},{0.000127073f,-0.97633f,-0.216286f},
	{0.0f,-0.95789f,-0.287136f},{0.000253499f,-0.984911f,-0.173061f},{0.0174582f,0.984688f,-0.173448f},
	{-0.000127132f,0.97633f,-0.216286f},{-0.000253616f,0.984911f,-0.173061f},{-0.000127132f,-0.97633f,-0.216286f},
	{0.0174582f,-0.984688f,-0.173448f},{-0.000253616f,-0.984911f,-0.173061f},{0.11735f,0.0757215f,-0.9902f},
	{0.320688f,0.0f,-0.947185f},{0.0653074f,0.0f,-0.997865f},{0.389022f,0.0902098f,-0.916801f},
	{0.11735f,-0.0757215f,-0.9902f},{0.389022f,-0.0902098f,-0.916801f},{-0.320686f,0.0f,-0.947186f},
	{-0.117348f,0.0757211f,-0.9902f},{-0.0653062f,0.0f,-0.997865f},{-0.389025f,0.0902124f,-0.9168f},
	{-0.117348f,-0.0757211f,-0.9902f},{-0.389025f,-0.0902124f,-0.9168f},{0.923758f,0.0706672f,-0.376401f},
	{0.896528f,0.0f,-0.442987f},{0.923758f,-0.0706672f,-0.376401f},{-0.923753f,0.0706722f,-0.376411f},
	{-0.896534f,0.0f,-0.442976f},{-0.923753f,-0.0706722f,-0.376411f},{0.733412f,0.0606989f,-0.677069f},
	{0.658766f,0.0f,-0.752348f},{0.733412f,-0.0606989f,-0.677069f},{-0.73343f,0.0607081f,-0.677049f},
	{-0.658777f,0.0f,-0.752338f},{-0.73343f,-0.0607081f,-0.677049f},{0.0755543f,0.319345f,-0.944622f},
	{0.39101f,0.30996f,-0.866624f},{0.39101f,-0.30996f,-0.866624f},{0.0755543f,-0.319345f,-0.944622f},
	{-0.391022f,0.309958f,-0.866618f},{-0.0755538f,0.319345f,-0.944622f},{-0.0755538f,-0.319345f,-0.944622f},
	{-0.391022f,-0.309958f,-0.866618f},{0.527363f,0.849594f,0.00879935f},{0.527363f,-0.849594f,0.00879935f},
	{-0.527362f,0.849595f,0.00879922f},{-0.527362f,-0.849595f,0.00879922f},{0.10095f,0.20432f,-0.973685f},
	{0.0301228f,0.227471f,-0.973319f},{0.10095f,-0.20432f,-0.973685f},{0.0301228f,-0.227471f,-0.973319f},
	{-0.100951f,0.20432f,-0.973685f},{-0.0301235f,0.227471f,-0.973319f},{-0.100951f,-0.20432f,-0.973685f},
	{-0.0301235f,-0.227471f,-0.973319f},{0.181845f,0.0180528f,-0.983161f},{0.181845f,-0.0180528f,-0.983161f},
	{-0.181845f,0.0180529f,-0.983162f},{-0.181845f,-0.0180529f,-0.983162f},{0.146842f,0.128574f,-0.980768f},
	{0.146842f,-0.128574f,-0.980768f},{-0.146843f,0.128576f,-0.980768f},{-0.146843f,-0.128576f,-0.980768f},
	{0.443311f,0.0440106f,-0.895287f},{0.44374f,0.0f,-0.896156f},{0.443311f,-0.0440106f,-0.895287f},
	{-0.443308f,0.0440105f,-0.895288f},{-0.443732f,0.0f,-0.89616f},{-0.443308f,-0.0440105f,-0.895288f},
	{0.995183f,0.0980337f,0.0f},{0.988677f,0.0f,-0.150062f},{0.949651f,0.0936591f,-0.298985f},
	{0.995183f,-0.0980337f,0.0f},{0.949651f,-0.0936591f,-0.298985f},{-0.988676f,0.0f,-0.150066f},
	{-0.995183f,0.0980305f,0.0f},{-0.949648f,0.0936541f,-0.298995f},{-0.995183f,-0.0980305f,0.0f},
	{-0.949648f,-0.0936541f,-0.298995f},{0.898062f,0.0f,-0.43987f},{0.894555f,0.0882814f,-0.438152f},
	{0.894555f,-0.0882814f,-0.438152f},{-0.898057f,0.0f,-0.43988f},{-0.894551f,0.0882734f,-0.438163f},
	{-0.894551f,-0.0882734f,-0.438163f},{0.125677f,-0.195158f,-0.972686f},{0.125677f,0.195158f,-0.972686f},
	{-0.125677f,-0.195157f,-0.972686f},{-0.125677f,0.195157f,-0.972686f},{0.17274f,0.233853f,-0.956804f},
	{0.213308f,0.328776f,-0.920003f},{0.213308f,-0.328776f,-0.920003f},{0.17274f,-0.233853f,-0.956804f},
	{-0.21331f,0.328777f,-0.920003f},{-0.172741f,0.233853f,-0.956804f},{-0.172741f,-0.233853f,-0.956804f},
	{-0.21331f,-0.328777f,-0.920003f},{0.472484f,0.62328f,-0.623123f},{0.472484f,-0.62328f,-0.623123f},
	{-0.472472f,0.623286f,-0.623125f},{-0.472472f,-0.623286f,-0.623125f},{0.913128f,0.0724015f,-0.401192f},
	{0.913128f,-0.0724015f,-0.401192f},{-0.913127f,0.0724005f,-0.401194f},{-0.913127f,-0.0724005f,-0.401194f},
	{0.894136f,0.279734f,-0.34967f},{0.894136f,-0.279734f,-0.34967f},{-0.894135f,0.279737f,-0.349671f},
	{-0.894135f,-0.279737f,-0.349671f},{0.0258063f,0.194848f,-0.980494f},{0.0661805f,0.756813f,-0.650273f},
	{0.0661805f,-0.756813f,-0.650273f},{0.0258063f,-0.194848f,-0.980494f},{-0.0661808f,0.756813f,-0.650272f},
	{-0.0258064f,0.194848f,-0.980494f},{-0.0258064f,-0.194848f,-0.980494f},{-0.0661808f,-0.756813f,-0.650272f},
	{0.0133937f,0.490176f,-0.871521f},{0.0133937f,-0.490176f,-0.871521f},{-0.0133938f,0.490176f,-0.871521f},
	{-0.0133938f,-0.490176f,-0.871521f},{0.0638722f,-0.443046f,-0.894221f},{0.0638722f,0.443046f,-0.894221f},
	{-0.0638722f,-0.443046f,-0.894221f},{-0.0638722f,0.443046f,-0.894221f},{-0.759035f,0.649257f,-0.048286f},
	{-0.707009f,0.700992f,-0.0935272f},{-0.707009f,-0.700992f,-0.0935272f},{-0.759035f,-0.649257f,-0.048286f},
	{0.707007f,0.700992f,-0.093545f},{0.75905f,0.649239f,-0.0482901f},{0.75905f,-0.649239f,-0.0482901f},
	{0.707007f,-0.700992f,-0.093545f},{-0.398442f,0.029201f,-0.916729f},{-0.398442f,-0.029201f,-0.916729f},
	{0.398436f,0.0292004f,-0.916731f},{0.398436f,-0.0292004f,-0.916731f},{0.963379f,-0.0253426f,-0.266943f},
	{0.963826f,-0.0126723f,-0.266231f},{0.963826f,0.0126723f,-0.266231f},{0.963379f,0.0253426f,-0.266943f},
	{-0.963826f,-0.0126616f,-0.266232f},{-0.96338f,-0.0253212f,-0.266943f},{-0.96338f,0.0253212f,-0.266943f},
	{-0.963826f,0.0126616f,-0.266232f},{0.997765f,0.0f,-0.0668202f},{-0.997765f,0.0f,-0.0668205f},
	{-0.0025676f,0.999997f,0.0f},{-0.0025676f,-0.999997f,0.0f},{0.0025676f,0.999997f,0.0f},
	{0.0025676f,-0.999997f,0.0f},{0.0111524f,-0.999938f,0.0f},{0.0111524f,0.999938f,0.0f},
	{-0.0111524f,-0.999938f,0.0f},{-0.0111524f,0.999938f,0.0f},{0.993901f,0.0311193f,-0.105798f},
	{0.961827f,0.077222f,-0.262536f},{0.951548f,0.15398f,-0.266169f},{0.951548f,-0.15398f,-0.266169f},
	{0.961827f,-0.077222f,-0.262536f},{0.993901f,-0.0311193f,-0.105798f},{-0.951551f,0.153961f,-0.26617f},
	{-0.961828f,0.0772123f,-0.262536f},{-0.993901f,0.0311154f,-0.105798f},{-0.993901f,-0.0311154f,-0.105798f},
	{-0.961828f,-0.0772123f,-0.262536f},{-0.951551f,-0.153961f,-0.26617f},{0.99866f,0.0f,-0.0517443f},
	{-0.99866f,0.0f,-0.0517446f},{0.0013134f,0.999999f,0.0f},{0.000656701f,0.999999f,-0.000837559f},
	{0.000656701f,-0.999999f,-0.000837559f},{0.0013134f,-0.999999f,0.0f},{-0.000656698f,0.999999f,-0.000837559f},
	{-0.00131339f,0.999999f,0.0f},{-0.00131339f,-0.999999f,0.0f},{-0.000656698f,-0.999999f,-0.000837559f},
	{0.0f,0.999999f,-0.00167512f},{0.0f,-0.999999f,-0.00167512f},{0.996001f,0.0f,-0.0893452f},
	{0.964005f,0.0f,-0.265883f},{-0.964005f,0.0f,-0.265883f},{-0.996001f,0.0f,-0.0893451f},
	{0.998569f,0.0f,-0.0534855f},{-0.998569f,0.0f,-0.0534855f},{-0.757252f,3.15743e-006f,-0.653123f},
	{-0.75725f,0.0f,-0.653125f},{-0.757252f,-3.15743e-006f,-0.653123f},{0.757249f,0.0f,-0.653126f},
	{0.75725f,2.46117e-006f,-0.653125f},{0.75725f,-2.46117e-006f,-0.653125f},{-0.757242f,0.0f,-0.653134f},
	{0.757246f,0.0f,-0.65313f},{-0.757247f,0.0f,-0.653129f},{0.757364f,0.0f,-0.652993f},
	{-0.999648f,-0.0265366f,0.0f},{-0.999648f,0.0265366f,0.0f},{0.999648f,-0.0265271f,0.0f},
	{0.999648f,0.0265271f,0.0f},{-0.175035f,-0.984515f,0.0095859f},{-0.175035f,0.984515f,0.0095859f},
	{0.175032f,-0.984516f,0.00958558f},{0.175032f,0.984516f,0.00958558f},{-0.081764f,-0.962811f,-0.257507f},
	{-0.081764f,0.962811f,-0.257507f},{0.0817623f,-0.962811f,-0.257506f},{0.0817623f,0.962811f,-0.257506f},
	{0.0f,0.342019f,-0.939693f},{0.0f,0.0586759f,-0.998277f},{0.0f,-0.0586759f,-0.998277f},
	{0.0f,-0.342019f,-0.939693f},{0.0f,0.596731f,-0.802442f},{0.0f,-0.596731f,-0.802442f},
	{0.0f,0.835197f,-0.549951f},{0.0f,0.89387f,-0.448326f},{0.0f,-0.89387f,-0.448326f},
	{0.0f,-0.835197f,-0.549951f},{0.0f,0.686628f,-0.727009f},{0.0f,-0.686628f,-0.727009f},
	{0.0f,-0.342019f,-0.939693f},{0.0f,0.342019f,-0.939693f},{0.0f,-0.686633f,-0.727004f},
	{0.0f,-0.893868f,-0.448331f},{0.0f,-0.835199f,-0.549948f},{0.0f,0.835199f,-0.549948f},
	{0.0f,0.893868f,-0.448331f},{0.0f,0.686633f,-0.727004f},{0.0f,-0.596734f,-0.802439f},
	{0.0f,0.596734f,-0.802439f},{0.00015263f,-0.973061f,-0.230548f},{0.0f,-0.957967f,-0.286877f},
	{0.0f,0.957967f,-0.286877f},{0.00015263f,0.973061f,-0.230548f},{-0.00015263f,-0.973061f,-0.230548f},
	{-0.00015263f,0.973061f,-0.230548f},{0.000247305f,-0.984875f,-0.173266f},{0.000142786f,-0.984906f,-0.17309f},
	{0.000247305f,-0.984818f,-0.173592f},{0.000247305f,0.984818f,-0.173592f},{0.000142786f,0.984906f,-0.17309f},
	{0.000247305f,0.984875f,-0.173266f},{-0.000247306f,-0.984818f,-0.173592f},{-0.000142789f,-0.984906f,-0.17309f},
	{-0.000247306f,-0.984875f,-0.173266f},{-0.000247306f,0.984875f,-0.173266f},{-0.000142789f,0.984906f,-0.17309f},
	{-0.000247306f,0.984818f,-0.173592f},{0.0f,-0.98498f,-0.17267f},{0.0f,0.98498f,-0.17267f},
	{-0.902471f,-0.00242016f,-0.430745f},{-0.974749f,-0.000620718f,-0.223302f},{-0.974749f,0.000620718f,-0.223302f},
	{-0.902471f,0.00242016f,-0.430745f},{0.974751f,-0.00062049f,-0.223293f},{0.902478f,-0.00241928f,-0.430729f},
	{0.902478f,0.00241928f,-0.430729f},{0.974751f,0.00062049f,-0.223293f},{-0.149314f,-0.00034697f,-0.98879f},
	{-0.182686f,-0.201189f,-0.962366f},{-0.182686f,0.201189f,-0.962366f},{-0.149314f,0.00034697f,-0.98879f},
	{0.182682f,-0.201188f,-0.962367f},{0.149311f,-0.000346895f,-0.98879f},{0.149311f,0.000346895f,-0.98879f},
	{0.182682f,0.201188f,-0.962367f},{-0.433722f,-0.00203459f,-0.901044f},{-0.433722f,0.00203459f,-0.901044f},
	{0.433715f,-0.00203415f,-0.901048f},{0.433715f,0.00203415f,-0.901048f},{-0.0619751f,-0.441691f,-0.895024f},
	{-0.0619751f,0.441691f,-0.895024f},{0.0619722f,-0.441691f,-0.895024f},{0.0619722f,0.441691f,-0.895024f},
	{-0.0928632f,-0.894173f,-0.437985f},{-0.0928632f,0.894173f,-0.437985f},{0.0928589f,-0.894174f,-0.437985f},
	{0.0928589f,0.894174f,-0.437985f},{0.896008f,0.399535f,-0.193758f},{0.752351f,0.658762f,0.0f},
	{0.641793f,0.732904f,-0.225727f},{0.641793f,-0.732904f,-0.225727f},{0.752351f,-0.658762f,0.0f},
	{0.896008f,-0.399535f,-0.193758f},{-0.641791f,0.732906f,-0.225729f},{-0.752349f,0.658765f,0.0f},
	{-0.896005f,0.399536f,-0.193766f},{-0.896005f,-0.399536f,-0.193766f},{-0.752349f,-0.658765f,0.0f},
	{-0.641791f,-0.732906f,-0.225729f},{0.923874f,0.382696f,0.0f},{0.923874f,-0.382696f,0.0f},
	{-0.923875f,0.382695f,0.0f},{-0.923875f,-0.382695f,0.0f},{0.382685f,0.923879f,0.0f},
	{0.382685f,-0.923879f,0.0f},{-0.382688f,0.923878f,0.0f},{-0.382688f,-0.923878f,0.0f},
	{0.334238f,0.902732f,-0.270852f},{0.334238f,-0.902732f,-0.270852f},{-0.334241f,0.90273f,-0.270852f},
	{-0.334241f,-0.90273f,-0.270852f},{0.0817292f,0.981115f,-0.175309f},{0.0979981f,0.995187f,0.0f},
	{0.0979981f,-0.995187f,0.0f},{0.0817292f,-0.981115f,-0.175309f},{-0.0980009f,0.995186f,0.0f},
	{-0.0817315f,0.981115f,-0.175309f},{-0.0817315f,-0.981115f,-0.175309f},{-0.0980009f,-0.995186f,0.0f},
	{0.913363f,0.378334f,-0.150436f},{0.752332f,0.658784f,0.0f},{0.686407f,0.691149f,-0.226184f},
	{0.686407f,-0.691149f,-0.226184f},{0.752332f,-0.658784f,0.0f},{0.913363f,-0.378334f,-0.150436f},
	{-0.686413f,0.691143f,-0.226184f},{-0.75234f,0.658775f,0.0f},{-0.913362f,0.378336f,-0.150435f},
	{-0.913362f,-0.378336f,-0.150435f},{-0.75234f,-0.658775f,0.0f},{-0.686413f,-0.691143f,-0.226184f},
	{0.995185f,0.0980143f,0.0f},{0.923877f,0.382689f,0.0f},{0.923877f,-0.382689f,0.0f},
	{0.995185f,-0.0980143f,0.0f},{-0.923876f,0.382691f,0.0f},{-0.995184f,0.0980254f,0.0f},
	{-0.995184f,-0.0980254f,0.0f},{-0.923876f,-0.382691f,0.0f},{0.956063f,0.0920822f,-0.278324f},
	{0.956063f,-0.0920822f,-0.278324f},{-0.956062f,0.0920923f,-0.278323f},{-0.956062f,-0.0920923f,-0.278323f},
	{0.382688f,0.923878f,0.0f},{0.382688f,-0.923878f,0.0f},{-0.382689f,0.923877f,0.0f},
	{-0.382689f,-0.923877f,0.0f},{0.365001f,0.881181f,-0.300491f},{0.365001f,-0.881181f,-0.300491f},
	{-0.365002f,0.881181f,-0.300489f},{-0.365002f,-0.881181f,-0.300489f},{0.116557f,0.976784f,-0.179741f},
	{0.0653126f,0.997865f,-1.62821e-005f},{0.0653126f,-0.997865f,-1.62821e-005f},{0.116557f,-0.976784f,-0.179741f},
	{-0.0653126f,0.997865f,-1.62821e-005f},{-0.116557f,0.976784f,-0.179741f},{-0.116557f,-0.976784f,-0.179741f},
	{-0.0653126f,-0.997865f,-1.62821e-005f},{0.591869f,0.675929f,-0.439103f},{0.829698f,0.343675f,-0.439874f},
	{0.829698f,-0.343675f,-0.439874f},{0.591869f,-0.675929f,-0.439103f},{-0.829698f,0.343677f,-0.439871f},
	{-0.591873f,0.675927f,-0.439101f},{-0.591873f,-0.675927f,-0.439101f},{-0.829698f,-0.343677f,-0.439871f},
	{0.634131f,0.0615817f,-0.77077f},{0.258842f,0.0876455f,-0.961935f},{0.258842f,-0.0876455f,-0.961935f},
	{0.634131f,-0.0615817f,-0.77077f},{-0.258836f,0.0876455f,-0.961937f},{-0.634128f,0.0615858f,-0.770771f},
	{-0.634128f,-0.0615858f,-0.770771f},{-0.258836f,-0.0876455f,-0.961937f},{0.398534f,0.196902f,-0.895768f},
	{0.398534f,-0.196902f,-0.895768f},{-0.398527f,0.196901f,-0.895771f},{-0.398527f,-0.196901f,-0.895771f},
	{0.121049f,0.245f,-0.961937f},{0.171449f,0.150127f,-0.973687f},{0.292826f,0.334426f,-0.895775f},
	{0.292826f,-0.334426f,-0.895775f},{0.171449f,-0.150127f,-0.973687f},{0.121049f,-0.245f,-0.961937f},
	{-0.292829f,0.334425f,-0.895774f},{-0.171449f,0.150125f,-0.973688f},{-0.121049f,0.245f,-0.961937f},
	{-0.121049f,-0.245f,-0.961937f},{-0.171449f,-0.150125f,-0.973688f},{-0.292829f,-0.334425f,-0.895774f},
	{0.142572f,0.421042f,-0.895766f},{0.142572f,-0.421042f,-0.895766f},{-0.142572f,0.421041f,-0.895766f},
	{-0.142572f,-0.421041f,-0.895766f},{0.343674f,0.829697f,-0.439876f},{0.343674f,-0.829697f,-0.439876f},
	{-0.343675f,0.829699f,-0.439872f},{-0.343675f,-0.829699f,-0.439872f},{0.994065f,0.0f,-0.108789f},
	{0.825138f,0.000213123f,-0.564931f},{0.825138f,-0.000213123f,-0.564931f},{-0.825139f,0.000213279f,-0.56493f},
	{-0.994065f,0.0f,-0.108789f},{-0.825139f,-0.000213279f,-0.56493f},{0.206278f,0.206055f,-0.956552f},
	{0.206278f,-0.206055f,-0.956552f},{-0.206277f,0.206055f,-0.956552f},{-0.206277f,-0.206055f,-0.956552f},
	{0.0f,0.986552f,-0.163451f},{0.0f,-0.986552f,-0.163451f},{0.000233564f,0.825034f,-0.565084f},
	{0.0773887f,0.715387f,-0.69443f},{0.0773887f,-0.715387f,-0.69443f},{0.000233564f,-0.825034f,-0.565084f},
	{-0.0773908f,0.715387f,-0.69443f},{-0.000233564f,0.825034f,-0.565084f},{-0.000233564f,-0.825034f,-0.565084f},
	{-0.0773908f,-0.715387f,-0.69443f},{0.398537f,0.196901f,-0.895767f},{0.398537f,-0.196901f,-0.895767f},
	{-0.398543f,0.196904f,-0.895763f},{-0.398543f,-0.196904f,-0.895763f},{0.292841f,0.334427f,-0.895769f},
	{0.292841f,-0.334427f,-0.895769f},{-0.29284f,0.33443f,-0.895769f},{-0.29284f,-0.33443f,-0.895769f},
	{0.850976f,0.288158f,-0.439095f},{0.850976f,-0.288158f,-0.439095f},{-0.850968f,0.288153f,-0.439114f},
	{-0.850968f,-0.288153f,-0.439114f},{0.675933f,0.59185f,-0.439122f},{0.675933f,-0.59185f,-0.439122f},
	{-0.675925f,0.591853f,-0.439131f},{-0.675925f,-0.591853f,-0.439131f},{0.142569f,0.421048f,-0.895764f},
	{0.142569f,-0.421048f,-0.895764f},{-0.14257f,0.421048f,-0.895764f},{-0.14257f,-0.421048f,-0.895764f},
	{0.397986f,0.805471f,-0.439116f},{0.397986f,-0.805471f,-0.439116f},{-0.397986f,0.805471f,-0.439117f},
	{-0.397986f,-0.805471f,-0.439117f},{0.431591f,0.902048f,0.00619479f},{0.431591f,-0.902048f,0.00619479f},
	{-0.431595f,0.902046f,0.00619243f},{-0.431595f,-0.902046f,0.00619243f},{0.124953f,0.992157f,0.00344948f},
	{0.124953f,-0.992157f,0.00344948f},{-0.124953f,0.992157f,0.00344951f},{-0.124953f,-0.992157f,0.00344951f},
	{0.0940605f,-0.970533f,-0.221851f},{0.0940605f,0.970533f,-0.221851f},{-0.0940591f,-0.970533f,-0.221852f},
	{-0.0940591f,0.970533f,-0.221852f},{0.0540259f,-0.896753f,-0.43922f},{0.0540259f,0.896753f,-0.43922f},
	{-0.0540258f,-0.896754f,-0.43922f},{-0.0540258f,0.896754f,-0.43922f},{0.0965187f,-0.995331f,-2.69231e-005f},
	{0.0965187f,0.995331f,-2.69231e-005f},{-0.0965168f,-0.995331f,-2.9914e-005f},{-0.0965168f,0.995331f,-2.9914e-005f},
	{0.000368327f,0.000180415f,-1.0f},{0.000368327f,-0.000180415f,-1.0f},{-0.000368327f,0.000180415f,-1.0f},
	{-0.000368327f,-0.000180415f,-1.0f},{0.222828f,0.960005f,-0.169525f},{0.222828f,-0.960005f,-0.169525f},
	{-0.222828f,0.960005f,-0.169525f},{-0.222828f,-0.960005f,-0.169525f},{-0.178336f,0.976562f,-0.120513f},
	{0.00350625f,0.997413f,-0.0718023f},{0.00350625f,-0.997413f,-0.0718023f},{-0.178336f,-0.976562f,-0.120513f},
	{-0.00350625f,0.997413f,-0.0718022f},{0.178333f,0.976563f,-0.120511f},{0.178333f,-0.976563f,-0.120511f},
	{-0.00350625f,-0.997413f,-0.0718022f},{-0.2093f,0.977851f,0.0f},{-0.2093f,-0.977851f,0.0f},
	{0.209297f,0.977852f,0.0f},{0.209297f,-0.977852f,0.0f},{-0.918922f,0.394325f,-0.00948931f},
	{-0.986608f,0.139716f,-0.0841651f},{-0.986608f,-0.139716f,-0.0841651f},{-0.918922f,-0.394325f,-0.00948931f},
	{0.986611f,0.139703f,-0.0841525f},{0.918931f,0.394305f,-0.00948955f},{0.918931f,-0.394305f,-0.00948955f},
	{0.986611f,-0.139703f,-0.0841525f},{-0.999648f,0.0265363f,0.0f},{-0.999648f,-0.0265363f,0.0f},
	{0.999648f,0.0265268f,0.0f},{0.999648f,-0.0265268f,0.0f},{-0.569302f,0.822123f,-0.00296975f},
	{-0.569302f,-0.822123f,-0.00296975f},{0.569297f,0.822127f,-0.00296903f},{0.569297f,-0.822127f,-0.00296903f},
	{-0.999604f,-0.00521681f,-0.0276412f},{-0.999604f,0.00521681f,-0.0276412f},{0.999604f,-0.00521551f,-0.0276343f},
	{0.999604f,0.00521551f,-0.0276343f},{-0.928034f,-0.0131032f,-0.372264f},{-0.928034f,0.0131032f,-0.372264f},
	{0.928039f,-0.0131014f,-0.372254f},{0.928039f,0.0131014f,-0.372254f},{0.035418f,0.98419f,-0.173538f},
	{0.035418f,-0.98419f,-0.173538f},{-0.035418f,0.98419f,-0.173538f},{-0.035418f,-0.98419f,-0.173538f},
	{0.986664f,0.162768f,-0.000129206f},{1.0f,0.0f,-0.000387826f},{0.986664f,-0.162768f,-0.000129206f},
	{-1.0f,0.0f,-0.000389945f},{-0.986664f,0.162768f,-0.000129912f},{-0.986664f,-0.162768f,-0.000129912f},
	{0.412794f,0.910825f,0.0f},{0.582554f,0.812792f,0.0f},{0.582554f,-0.812792f,0.0f},
	{0.412794f,-0.910825f,0.0f},{-0.582554f,0.812792f,0.0f},{-0.412794f,0.910824f,0.0f},
	{-0.412794f,-0.910824f,0.0f},{-0.582554f,-0.812792f,0.0f},{0.849251f,0.527988f,0.0f},
	{0.935938f,0.352165f,0.0f},{0.935938f,-0.352165f,0.0f},{0.849251f,-0.527988f,0.0f},
	{-0.935938f,0.352164f,0.0f},{-0.849251f,0.527989f,0.0f},{-0.849251f,-0.527989f,0.0f},
	{-0.935938f,-0.352164f,0.0f},{0.729929f,0.683523f,0.0f},{0.729929f,-0.683523f,0.0f},
	{-0.729929f,0.683523f,0.0f},{-0.729929f,-0.683523f,0.0f},{0.691129f,0.686428f,-0.226181f},
	{0.896224f,0.442766f,-0.0272245f},{0.658185f,0.751441f,-0.0461382f},{0.658185f,-0.751441f,-0.0461382f},
	{0.896224f,-0.442766f,-0.0272245f},{0.691129f,-0.686428f,-0.226181f},{-0.658185f,0.751441f,-0.0461382f},
	{-0.896223f,0.442767f,-0.0272246f},{-0.691129f,0.686428f,-0.226181f},{-0.691129f,-0.686428f,-0.226181f},
	{-0.896223f,-0.442767f,-0.0272246f},{-0.658185f,-0.751441f,-0.0461382f},{0.901211f,0.369675f,-0.226185f},
	{0.901211f,-0.369675f,-0.226185f},{-0.901211f,0.369675f,-0.226185f},{-0.901211f,-0.369675f,-0.226185f},
	{0.370444f,0.901721f,-0.222869f},{0.370444f,-0.901721f,-0.222869f},{-0.370445f,0.90172f,-0.222869f},
	{-0.370445f,-0.90172f,-0.222869f},{0.320274f,0.945548f,-0.0579966f},{0.320274f,-0.945548f,-0.0579966f},
	{-0.320276f,0.945547f,-0.0579966f},{-0.320276f,-0.945547f,-0.0579966f},{0.0933382f,0.969623f,-0.226097f},
	{0.0933382f,-0.969623f,-0.226097f},{-0.0933393f,0.969623f,-0.226097f},{-0.0933393f,-0.969623f,-0.226097f},
	{0.734785f,0.615752f,-0.284499f},{0.706899f,0.603449f,-0.368975f},{0.391605f,0.842629f,-0.369624f},
	{0.391605f,-0.842629f,-0.369624f},{0.706899f,-0.603449f,-0.368975f},{0.734785f,-0.615752f,-0.284499f},
	{-0.391606f,0.842629f,-0.369624f},{-0.706899f,0.603449f,-0.368976f},{-0.734785f,0.615753f,-0.284499f},
	{-0.734785f,-0.615753f,-0.284499f},{-0.706899f,-0.603449f,-0.368976f},{-0.391606f,-0.842629f,-0.369624f},
	{0.419023f,0.770189f,-0.480862f},{0.419023f,-0.770189f,-0.480862f},{-0.419025f,0.770188f,-0.480862f},
	{-0.419025f,-0.770188f,-0.480862f},{0.418328f,0.889803f,-0.182353f},{0.726109f,0.668227f,-0.161985f},
	{0.726109f,-0.668227f,-0.161985f},{0.418328f,-0.889803f,-0.182353f},{-0.726109f,0.668227f,-0.161985f},
	{-0.418329f,0.889802f,-0.182353f},{-0.418329f,-0.889802f,-0.182353f},{-0.726109f,-0.668227f,-0.161985f},
	{0.923778f,0.327389f,-0.198623f},{0.923778f,-0.327389f,-0.198623f},{-0.923777f,0.32739f,-0.198624f},
	{-0.923777f,-0.32739f,-0.198624f},{0.897699f,0.351484f,-0.265696f},{0.67808f,0.591812f,-0.435851f},
	{0.67808f,-0.591812f,-0.435851f},{0.897699f,-0.351484f,-0.265696f},{-0.67808f,0.591812f,-0.435851f},
	{-0.897699f,0.351484f,-0.265697f},{-0.897699f,-0.351484f,-0.265697f},{-0.67808f,-0.591812f,-0.435851f},
	{0.381542f,0.737076f,-0.557803f},{0.381542f,-0.737076f,-0.557803f},{-0.381544f,0.737076f,-0.557802f},
	{-0.381544f,-0.737076f,-0.557802f},{0.66072f,0.353011f,-0.662444f},{0.730701f,0.467428f,-0.497581f},
	{0.730701f,-0.467428f,-0.497581f},{0.66072f,-0.353011f,-0.662444f},{-0.730701f,0.467428f,-0.497581f},
	{-0.66072f,0.353011f,-0.662444f},{-0.66072f,-0.353011f,-0.662444f},{-0.730701f,-0.467428f,-0.497581f},
	{0.360387f,0.241258f,-0.901064f},{0.340895f,0.464014f,-0.817607f},{0.340895f,-0.464014f,-0.817607f},
	{0.360387f,-0.241258f,-0.901064f},{-0.340896f,0.464014f,-0.817607f},{-0.360388f,0.241258f,-0.901063f},
	{-0.360388f,-0.241258f,-0.901063f},{-0.340896f,-0.464014f,-0.817607f},{0.730692f,0.153168f,-0.665303f},
	{0.898791f,0.0257477f,-0.43762f},{0.706573f,0.0423776f,-0.706371f},{0.706573f,-0.0423776f,-0.706371f},
	{0.898791f,-0.0257477f,-0.43762f},{0.730692f,-0.153168f,-0.665303f},{-0.706572f,0.0423776f,-0.706371f},
	{-0.898791f,0.0257486f,-0.437621f},{-0.730692f,0.153169f,-0.665303f},{-0.730692f,-0.153169f,-0.665303f},
	{-0.898791f,-0.0257486f,-0.437621f},{-0.706572f,-0.0423776f,-0.706371f},{0.414365f,0.0536597f,-0.908528f},
	{0.414365f,-0.0536597f,-0.908528f},{-0.414366f,0.0536597f,-0.908527f},{-0.414366f,-0.0536597f,-0.908527f},
	{0.379237f,0.624663f,-0.682624f},{0.379237f,-0.624663f,-0.682624f},{-0.379238f,0.624662f,-0.682624f},
	{-0.379238f,-0.624662f,-0.682624f},{0.421129f,0.216014f,-0.880902f},{0.421129f,-0.216014f,-0.880902f},
	{-0.421129f,0.216014f,-0.880902f},{-0.421129f,-0.216014f,-0.880902f},{0.949132f,-7.44534e-007f,-0.314879f},
	{0.949132f,7.44534e-007f,-0.314879f},{-0.949132f,-7.44704e-007f,-0.314879f},{-0.949132f,7.44704e-007f,-0.314879f},
	{0.0585377f,0.683498f,-0.727602f},{3.89981e-005f,0.65824f,-0.752808f},{3.89981e-005f,-0.65824f,-0.752808f},
	{0.0585377f,-0.683498f,-0.727602f},{-3.89981e-005f,0.65824f,-0.752808f},{-0.0585374f,0.683498f,-0.727602f},
	{-0.0585374f,-0.683498f,-0.727602f},{-3.89981e-005f,-0.65824f,-0.752808f},{0.907106f,0.280596f,-0.313727f},
	{0.907106f,-0.280596f,-0.313727f},{-0.907099f,0.280589f,-0.313754f},{-0.907099f,-0.280589f,-0.313754f},
	{0.69596f,0.247522f,-0.674072f},{0.69596f,-0.247522f,-0.674072f},{-0.695971f,0.247524f,-0.674059f},
	{-0.695971f,-0.247524f,-0.674059f},{0.683629f,0.0600373f,-0.727356f},{0.258166f,0.0856498f,-0.962296f},
	{0.184196f,0.011286f,-0.982825f},{0.184196f,-0.011286f,-0.982825f},{0.258166f,-0.0856498f,-0.962296f},
	{0.683629f,-0.0600373f,-0.727356f},{-0.184196f,0.0112856f,-0.982825f},{-0.258165f,0.0856498f,-0.962297f},
	{-0.683628f,0.0600371f,-0.727357f},{-0.683628f,-0.0600371f,-0.727357f},{-0.258165f,-0.0856498f,-0.962297f},
	{-0.184196f,-0.0112856f,-0.982825f},{0.396684f,0.193585f,-0.89731f},{0.396684f,-0.193585f,-0.89731f},
	{-0.396683f,0.193586f,-0.897311f},{-0.396683f,-0.193586f,-0.897311f},{0.0991749f,0.204142f,-0.973905f},
	{0.206975f,0.17673f,-0.962251f},{0.293042f,0.329322f,-0.897593f},{0.293042f,-0.329322f,-0.897593f},
	{0.206975f,-0.17673f,-0.962251f},{0.0991749f,-0.204142f,-0.973905f},{-0.293043f,0.329322f,-0.897593f},
	{-0.206976f,0.17673f,-0.962251f},{-0.0991752f,0.204142f,-0.973905f},{-0.0991752f,-0.204142f,-0.973905f},
	{-0.206976f,-0.17673f,-0.962251f},{-0.293043f,-0.329322f,-0.897593f},{0.850981f,0.28814f,-0.439097f},
	{0.850981f,-0.28814f,-0.439097f},{-0.850981f,0.288141f,-0.439097f},{-0.850981f,-0.288141f,-0.439097f},
	{0.675902f,0.5919f,-0.439101f},{0.675902f,-0.5919f,-0.439101f},{-0.675902f,0.5919f,-0.439101f},
	{-0.675902f,-0.5919f,-0.439101f},{0.387691f,0.810342f,-0.439365f},{0.387691f,-0.810342f,-0.439365f},
	{-0.387691f,0.810342f,-0.439365f},{-0.387691f,-0.810342f,-0.439365f},{0.14268f,0.430849f,-0.891073f},
	{0.14268f,-0.430849f,-0.891073f},{-0.14268f,0.430849f,-0.891073f},{-0.14268f,-0.430849f,-0.891073f},
	{0.0047895f,0.750065f,-0.661347f},{0.0047895f,-0.750065f,-0.661347f},{-0.0047895f,0.750065f,-0.661347f},
	{-0.0047895f,-0.750065f,-0.661347f},{0.0942186f,0.894059f,-0.437929f},{0.0942186f,-0.894059f,-0.437929f},
	{-0.094214f,0.894059f,-0.437929f},{-0.094214f,-0.894059f,-0.437929f},{-0.945774f,-0.0541524f,-0.32028f},
	{-0.945774f,0.0541524f,-0.32028f},{0.945783f,-0.0541559f,-0.320253f},{0.945783f,0.0541559f,-0.320253f},
	{-0.805421f,0.592697f,-0.00268614f},{-0.805421f,-0.592697f,-0.00268614f},{0.805449f,0.592659f,-0.00267609f},
	{0.805449f,-0.592659f,-0.00267609f},{0.742736f,0.6695f,0.010602f},{0.742736f,-0.6695f,0.010602f},
	{-0.742738f,0.669498f,0.010607f},{-0.742738f,-0.669498f,0.010607f},{0.902141f,0.431441f,0.000523924f},
	{0.902141f,-0.431441f,0.000523924f},{-0.90214f,0.431443f,0.000523803f},{-0.90214f,-0.431443f,0.000523803f},
	{-0.130515f,-0.991446f,0.0f},{0.130529f,0.991445f,0.0f},{0.991446f,-0.130515f,0.0f},
	{0.923884f,-0.382672f,0.0f},{0.382686f,0.923878f,0.0f},{-0.382674f,-0.923883f,0.0f},
	{-0.608754f,-0.793359f,0.0f},{0.608764f,0.793351f,0.0f},{0.793361f,-0.608752f,0.0f},
	{0.60877f,-0.793346f,0.0f},{0.793355f,0.60876f,0.0f},{-0.793345f,-0.608773f,0.0f},
	{-0.923876f,-0.382692f,0.0f},{0.92388f,0.382682f,0.0f},{0.382694f,-0.923875f,0.0f},
	{0.130539f,-0.991443f,0.0f},{0.991445f,0.130525f,0.0f},{-0.991444f,-0.130535f,0.0f},
	{-0.991446f,0.130515f,0.0f},{0.991444f,-0.130529f,0.0f},{-0.130514f,-0.991447f,0.0f},
	{-0.382671f,-0.923885f,0.0f},{0.923877f,-0.382689f,0.0f},{-0.923883f,0.382674f,0.0f},
	{-0.793359f,0.608754f,0.0f},{0.793351f,-0.608764f,0.0f},{-0.608749f,-0.793363f,0.0f},
	{-0.793345f,-0.608773f,0.0f},{0.608759f,-0.793355f,0.0f},{-0.608769f,0.793347f,0.0f},
	{-0.382691f,0.923877f,0.0f},{0.38268f,-0.923881f,0.0f},{-0.923875f,-0.382695f,0.0f},
	{-0.991443f,-0.130541f,0.0f},{0.130522f,-0.991445f,0.0f},{-0.130535f,0.991444f,0.0f},
	{0.130519f,0.991446f,0.0f},{-0.13053f,-0.991444f,0.0f},{-0.991447f,0.130512f,0.0f},
	{-0.923885f,0.382671f,0.0f},{-0.382686f,-0.923878f,0.0f},{0.382677f,0.923882f,0.0f},
	{0.608756f,0.793357f,0.0f},{-0.608762f,-0.793353f,0.0f},{-0.793362f,0.60875f,0.0f},
	{-0.608773f,0.793344f,0.0f},{-0.793358f,-0.608756f,0.0f},{0.79335f,0.608766f,0.0f},
	{0.923877f,0.382689f,0.0f},{-0.92388f,-0.382682f,0.0f},{-0.382694f,0.923875f,0.0f},
	{-0.130539f,0.991443f,0.0f},{-0.991445f,-0.130525f,0.0f},{0.991444f,0.130535f,0.0f},
	{0.991446f,-0.130519f,0.0f},{-0.991445f,0.130529f,0.0f},{0.130513f,0.991447f,0.0f},
	{0.382671f,0.923885f,0.0f},{-0.923878f,0.382686f,0.0f},{0.923884f,-0.382673f,0.0f},
	{0.79336f,-0.608752f,0.0f},{-0.793352f,0.608763f,0.0f},{0.60875f,0.793362f,0.0f},
	{0.793345f,0.608773f,0.0f},{-0.608756f,0.793358f,0.0f},{0.608771f,-0.793346f,0.0f},
	{0.382691f,-0.923876f,0.0f},{-0.38268f,0.923881f,0.0f},{0.923875f,0.382695f,0.0f},
	{0.991443f,0.130541f,0.0f},{-0.130525f,0.991445f,0.0f},{0.130538f,-0.991443f,0.0f},
	{-0.130514f,-0.991446f,0.0f},{0.130533f,0.991444f,0.0f},{0.991447f,-0.130513f,0.0f}
	};
	static GLfloat textures [513][2] = {
	{0.904122f,0.679399f},{0.987585f,0.679576f},{0.985947f,0.695855f},
	{0.904124f,0.679453f},{0.985729f,0.695685f},{0.987328f,0.679453f},
	{0.981164f,0.711502f},{0.980994f,0.711294f},{0.973421f,0.725915f},
	{0.973305f,0.725679f},{0.963014f,0.738541f},{0.962958f,0.738287f},
	{0.950344f,0.748894f},{0.95035f,0.748634f},{0.940621f,0.753862f},
	{0.940574f,0.754117f},{0.926014f,0.760099f},{0.926118f,0.759856f},
	{0.906687f,0.765744f},{0.906863f,0.765524f},{0.889792f,0.764585f},
	{0.890019f,0.764405f},{0.873449f,0.760153f},{0.873717f,0.760021f},
	{0.858284f,0.752617f},{0.858583f,0.752541f},{0.84488f,0.742267f},
	{0.845199f,0.742252f},{0.833754f,0.729502f},{0.83408f,0.72955f},
	{0.825331f,0.714811f},{0.825653f,0.714922f},{0.819936f,0.698759f},
	{0.820241f,0.698932f},{0.817777f,0.681963f},{0.818052f,0.682193f},
	{0.993322f,0.516675f},{0.983348f,0.574438f},{0.983348f,0.516675f},
	{0.993322f,0.574438f},{0.973374f,0.574438f},{0.973374f,0.516675f},
	{0.9634f,0.574438f},{0.9634f,0.516675f},{0.953426f,0.574438f},
	{0.953426f,0.516675f},{0.943452f,0.574438f},{0.943452f,0.516675f},
	{0.773113f,0.515822f},{0.763139f,0.573584f},{0.763139f,0.515822f},
	{0.773113f,0.573584f},{0.753165f,0.573584f},{0.753165f,0.515822f},
	{0.743191f,0.573584f},{0.743191f,0.515822f},{0.733217f,0.573584f},
	{0.733218f,0.515822f},{0.723244f,0.573584f},{0.723244f,0.515822f},
	{0.71327f,0.573584f},{0.71327f,0.515822f},{0.703296f,0.573584f},
	{0.703296f,0.515822f},{0.693322f,0.573584f},{0.693322f,0.515822f},
	{0.980143f,0.747203f},{0.980244f,0.751111f},{0.86488f,0.515822f},
	{0.86488f,0.573585f},{0.879952f,0.574439f},{0.879951f,0.516676f},
	{0.980179f,0.755932f},{0.980251f,0.756277f},{0.980161f,0.750781f},
	{0.980052f,0.746886f},{0.872406f,0.574065f},{0.872405f,0.516302f},
	{0.910755f,0.869006f},{0.908035f,0.870331f},{0.901343f,0.865733f},
	{0.799855f,0.799881f},{0.884563f,0.858485f},{0.819387f,0.888363f},
	{0.886553f,0.789244f},{0.888056f,0.866806f},{0.5991f,0.830392f},
	{0.698228f,0.741057f},{0.714186f,0.850879f},{0.637367f,0.631526f},
	{0.793409f,0.768557f},{0.794648f,0.733055f},{0.7995f,0.673371f},
	{0.665228f,0.626189f},{0.656053f,0.626036f},{0.633544f,0.6253f},
	{0.640001f,0.626467f},{0.631997f,0.627711f},{0.635616f,0.623297f},
	{0.589851f,0.827962f},{0.312066f,0.801847f},{0.24505f,0.821437f},
	{0.308633f,0.794514f},{0.229053f,0.838579f},{0.273435f,0.696847f},
	{0.277805f,0.711242f},{0.269941f,0.707912f},{0.283714f,0.702956f},
	{0.344132f,0.909859f},{0.336001f,0.910345f},{0.33205f,0.878075f},
	{0.338824f,0.874587f},{0.317027f,0.865418f},{0.319005f,0.872816f},
	{0.920113f,0.790355f},{0.963989f,0.89242f},{0.921215f,0.872008f},
	{0.986113f,0.807562f},{0.581637f,0.867957f},{0.604832f,0.846516f},
	{0.578029f,0.961694f},{0.042272f,0.661936f},{0.038349f,0.637526f},
	{0.092127f,0.643966f},{0.080425f,0.630979f},{0.215606f,0.811248f},
	{0.227652f,0.821143f},{0.224124f,0.812469f},{0.230085f,0.806572f},
	{0.23783f,0.811516f},{0.231528f,0.81249f},{0.238903f,0.806908f},
	{0.244322f,0.810653f},{0.243005f,0.806354f},{0.658697f,0.61702f},
	{0.669127f,0.61815f},{0.185955f,0.759527f},{0.189391f,0.750531f},
	{0.19639f,0.762672f},{0.200116f,0.755848f},{0.182077f,0.736988f},
	{0.193223f,0.740112f},{0.188336f,0.776387f},{0.168324f,0.739359f},
	{0.193657f,0.771594f},{0.198877f,0.7674f},{0.201401f,0.762201f},
	{0.266243f,0.69769f},{0.253697f,0.670682f},{0.25524f,0.684176f},
	{0.247743f,0.681974f},{0.247589f,0.672051f},{0.243581f,0.67341f},
	{0.257768f,0.672706f},{0.288039f,0.893241f},{0.29398f,0.89469f},
	{0.294089f,0.900244f},{0.163029f,0.728078f},{0.17964f,0.72747f},
	{0.167048f,0.716927f},{0.175738f,0.717929f},{0.171834f,0.711961f},
	{0.82311f,0.897781f},{0.32394f,0.665753f},{0.28845f,0.679297f},
	{0.317544f,0.656897f},{0.295503f,0.689287f},{0.474847f,0.774338f},
	{0.563724f,0.72406f},{0.521861f,0.798716f},{0.453181f,0.675577f},
	{0.461922f,0.769472f},{0.245103f,0.6335f},{0.216267f,0.641994f},
	{0.207155f,0.626804f},{0.171299f,0.625679f},{0.214782f,0.622081f},
	{0.159814f,0.620756f},{0.127666f,0.626261f},{0.099587f,0.623652f},
	{0.037469f,0.631829f},{0.098163f,0.60694f},{0.03533f,0.61486f},
	{0.161588f,0.634926f},{0.235132f,0.64522f},{0.251516f,0.629031f},
	{0.278098f,0.626686f},{0.300564f,0.635224f},{0.346248f,0.638517f},
	{0.350551f,0.646402f},{0.396356f,0.658461f},{0.416076f,0.657529f},
	{0.495673f,0.683672f},{0.568651f,0.714791f},{0.066524f,0.720662f},
	{0.04633f,0.84467f},{0.036219f,0.713657f},{0.272479f,0.652841f},
	{0.102356f,0.663283f},{0.044602f,0.67473f},{0.422504f,0.986332f},
	{0.288521f,0.937213f},{0.422353f,0.936806f},{0.288671f,0.986738f},
	{0.046192f,0.683432f},{0.104398f,0.67258f},{0.047708f,0.691909f},
	{0.105158f,0.681734f},{0.242408f,0.985616f},{0.089092f,0.935971f},
	{0.242446f,0.936086f},{0.089055f,0.985501f},{0.282039f,0.936972f},
	{0.27471f,0.986493f},{0.274748f,0.936966f},{0.017359f,0.935917f},
	{0.017322f,0.985448f},{0.248906f,0.985445f},{0.248943f,0.935916f},
	{0.261807f,0.936955f},{0.261769f,0.986483f},{0.255337f,0.985964f},
	{0.255375f,0.936436f},{0.89596f,0.869731f},{0.906067f,0.873834f},
	{0.903853f,0.877243f},{0.891606f,0.861692f},{0.583671f,0.859483f},
	{0.588794f,0.852433f},{0.709626f,0.966867f},{0.803361f,0.970552f},
	{0.807373f,0.868466f},{0.485989f,0.592949f},{0.595847f,0.622558f},
	{0.484901f,0.607557f},{0.596923f,0.607948f},{0.911001f,0.889819f},
	{0.954977f,0.909846f},{0.951457f,0.915322f},{0.914492f,0.885945f},
	{0.919334f,0.876932f},{0.960755f,0.898131f},{0.917212f,0.881457f},
	{0.957905f,0.904052f},{0.828723f,0.933416f},{0.879515f,0.993233f},
	{0.90297f,0.881859f},{0.908641f,0.881115f},{0.898093f,0.790123f},
	{0.434844f,0.772018f},{0.323064f,0.726609f},{0.423912f,0.779191f},
	{0.329523f,0.672611f},{0.30183f,0.696189f},{0.351484f,0.778127f},
	{0.305455f,0.642046f},{0.306191f,0.654773f},{0.276408f,0.661843f},
	{0.282989f,0.671392f},{0.448648f,0.768637f},{0.471266f,0.780606f},
	{0.518812f,0.804815f},{0.464079f,0.800094f},{0.515791f,0.810934f},
	{0.50989f,0.82286f},{0.468306f,0.786979f},{0.458986f,0.808411f},
	{0.505603f,0.831512f},{0.208574f,0.760531f},{0.240173f,0.800725f},
	{0.22892f,0.809219f},{0.223636f,0.808892f},{0.299834f,0.773069f},
	{0.302564f,0.778894f},{0.203254f,0.752987f},{0.248189f,0.642613f},
	{0.240023f,0.646876f},{0.095059f,0.725661f},{0.108648f,0.732163f},
	{0.058773f,0.853152f},{0.131188f,0.748856f},{0.084491f,0.875152f},
	{0.152053f,0.790005f},{0.176076f,0.779513f},{0.073454f,0.86442f},
	{0.143562f,0.75668f},{0.165649f,0.772059f},{0.190875f,0.803047f},
	{0.199513f,0.814649f},{0.216362f,0.83641f},{0.096245f,0.889586f},
	{0.222018f,0.850151f},{0.104673f,0.902066f},{0.227847f,0.878727f},
	{0.324164f,0.889428f},{0.317162f,0.886429f},{0.308925f,0.908924f},
	{0.314762f,0.911274f},{0.312296f,0.861838f},{0.344243f,0.875294f},
	{0.331663f,0.910771f},{0.327465f,0.91136f},{0.425114f,0.588411f},
	{0.403732f,0.601501f},{0.404824f,0.586896f},{0.424023f,0.603017f},
	{0.444315f,0.604532f},{0.464608f,0.606045f},{0.465696f,0.591438f},
	{0.445404f,0.589925f},{0.383443f,0.599983f},{0.384535f,0.585379f},
	{0.363155f,0.598464f},{0.342868f,0.596943f},{0.343964f,0.582341f},
	{0.364249f,0.583861f},{0.322584f,0.59542f},{0.32368f,0.580819f},
	{0.307516f,0.734742f},{0.307497f,0.725294f},{0.199755f,0.594461f},
	{0.211491f,0.579911f},{0.303259f,0.744953f},{0.271956f,0.718063f},
	{0.2658f,0.710546f},{0.259911f,0.701038f},{0.459398f,0.784225f},
	{0.450658f,0.797356f},{0.449848f,0.783835f},{0.457211f,0.797978f},
	{0.444215f,0.798421f},{0.440523f,0.786033f},{0.43246f,0.790246f},
	{0.438212f,0.801415f},{0.335119f,0.78317f},{0.323609f,0.792773f},
	{0.324918f,0.78083f},{0.337642f,0.798658f},{0.330772f,0.794827f},
	{0.343907f,0.788497f},{0.316145f,0.792645f},{0.314686f,0.781511f},
	{0.305619f,0.784794f},{0.325543f,0.774329f},{0.337566f,0.77702f},
	{0.347716f,0.782939f},{0.340022f,0.770888f},{0.311778f,0.768924f},
	{0.325991f,0.767723f},{0.313417f,0.775279f},{0.387183f,0.820536f},
	{0.387337f,0.813058f},{0.387407f,0.805889f},{0.387373f,0.835533f},
	{0.428187f,0.784226f},{0.460636f,0.776933f},{0.449226f,0.776276f},
	{0.437822f,0.778947f},{0.236802f,0.822837f},{0.32257f,0.800416f},
	{0.327794f,0.801897f},{0.317185f,0.800354f},{0.387177f,0.847405f},
	{0.332453f,0.804625f},{0.443244f,0.808061f},{0.446758f,0.806447f},
	{0.454997f,0.806652f},{0.450819f,0.805986f},{0.19691f,0.745287f},
	{0.254663f,0.700375f},{0.156117f,0.733119f},{0.251378f,0.695578f},
	{0.252342f,0.691259f},{0.299571f,0.900707f},{0.287943f,0.888837f},
	{0.437316f,0.983254f},{0.556479f,0.907493f},{0.452783f,0.92981f},
	{0.259633f,0.668479f},{0.253362f,0.644262f},{0.546945f,0.870812f},
	{0.438584f,0.89544f},{0.265237f,0.858991f},{0.566253f,0.898553f},
	{0.572381f,0.886809f},{0.574122f,0.873678f},{0.571267f,0.860743f},
	{0.527794f,0.838061f},{0.38033f,0.909975f},{0.381768f,0.870293f},
	{0.56416f,0.849564f},{0.553658f,0.841491f},{0.541028f,0.837496f},
	{0.419311f,0.330079f},{0.414543f,0.330392f},{0.409775f,0.330079f},
	{0.024191f,0.866679f},{0.052126f,0.896997f},{0.019323f,0.893496f},
	{0.01951f,0.879685f},{0.031715f,0.917734f},{0.023567f,0.906619f},
	{0.042932f,0.925771f},{0.056153f,0.929881f},{0.083069f,0.924648f},
	{0.070037f,0.929525f},{0.23563f,0.90908f},{0.597932f,0.59334f},
	{0.50325f,0.662932f},{0.577259f,0.694805f},{0.159469f,0.604985f},
	{0.215608f,0.605953f},{0.350221f,0.619465f},{0.422242f,0.637318f},
	{0.280155f,0.60883f},{0.804048f,0.640642f},{0.681915f,0.621514f},
	{0.685179f,0.611021f},{0.80185f,0.656839f},{0.806075f,0.624675f},
	{0.686999f,0.599988f},{0.687373f,0.588138f},{0.807958f,0.608866f},
	{0.28219f,0.986498f},{0.657987f,0.609954f},{0.651104f,0.611378f},
	{0.656675f,0.602733f},{0.649107f,0.604937f},{0.646802f,0.598378f},
	{0.668749f,0.590807f},{0.670051f,0.60039f},{0.670255f,0.60938f},
	{0.652675f,0.617735f},{0.637925f,0.621552f},{0.635563f,0.616618f},
	{0.632751f,0.611548f},{0.629405f,0.606138f},{0.629243f,0.621864f},
	{0.632174f,0.618927f},{0.621922f,0.622802f},{0.619842f,0.614663f},
	{0.624691f,0.61833f},{0.627084f,0.625352f},{0.630817f,0.630195f},
	{0.625694f,0.628971f},{0.620306f,0.627659f},{0.613959f,0.625791f},
	{0.628353f,0.614461f},{0.6242f,0.609936f},{0.574922f,0.82259f},
	{0.582561f,0.825405f},{0.56475f,0.820689f},{0.895664f,0.874456f},
	{0.826131f,0.908056f},{0.828261f,0.919458f},{0.913102f,0.873632f},
	{0.911057f,0.877522f},{0.123316f,0.67932f},{0.125707f,0.668236f},
	{0.130574f,0.673878f},{0.119627f,0.675905f},{0.110613f,0.661877f},
	{0.119167f,0.664154f},{0.114974f,0.673327f},{0.114378f,0.683964f},
	{0.116847f,0.685955f},{0.111514f,0.68254f},{0.109615f,0.672039f},
	{0.108379f,0.681792f},{0.791609f,0.814522f},{0.790593f,0.840409f},
	{0.908939f,0.790115f},{0.564565f,0.285392f},{0.560321f,0.339227f},
	{0.285982f,0.290826f},{0.558225f,0.231763f},{0.446626f,0.516784f},
	{0.399506f,0.543165f},{0.389579f,0.034251f},{0.437692f,0.058774f},
	{0.348145f,0.559846f},{0.294516f,0.566186f},{0.28377f,0.015342f},
	{0.337606f,0.019586f},{0.24068f,0.561943f},{0.230141f,0.021682f},
	{0.545656f,0.3912f},{0.521132f,0.439313f},{0.515163f,0.133281f},
	{0.541544f,0.180401f},{0.487694f,0.481718f},{0.480097f,0.092212f},
	{0.020061f,0.349766f},{0.013721f,0.296137f},{0.017964f,0.242302f},
	{0.188707f,0.547277f},{0.140594f,0.522754f},{0.131659f,0.064744f},
	{0.178779f,0.038363f},{0.063123f,0.448248f},{0.036742f,0.401128f},
	{0.03263f,0.190329f},{0.057153f,0.142215f},{0.098189f,0.489316f},
	{0.090591f,0.09981f},{0.898838f,0.639651f},{0.842992f,0.647428f},
	{0.853009f,0.639955f},{0.907781f,0.647428f},{0.853221f,0.60998f},
	{0.843346f,0.600135f},{0.898905f,0.609506f},{0.908345f,0.599745f}
	};
	GLint GenMarxbotBase()
	{
	unsigned i;
	unsigned j;

	GLint lid=glGenLists(1);
	glNewList(lid, GL_COMPILE);

		glBegin (GL_TRIANGLES);
		for(i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
		{
		for(j=0;j<3;j++)
			{
			int vi=face_indicies[i][j];
			int ni=face_indicies[i][j+3];//Normal index
			int ti=face_indicies[i][j+6];//Texture index
			/*glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][0],vertices[vi][1],vertices[vi][2]);*/
			// rotate 90 deg around z
			glNormal3f (normals[ni][1],-normals[ni][0],normals[ni][2]);
			glTexCoord2f(textures[ti][0],textures[ti][1]);
			glVertex3f (vertices[vi][1],-vertices[vi][0],vertices[vi][2]);
			}
		}
		glEnd ();

	glEndList();
	return lid;
	};
}
