C Copyright 1981-2012 ECMWF.
C
C This software is licensed under the terms of the Apache Licence 
C Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
C
C In applying this licence, ECMWF does not waive the privileges and immunities 
C granted to it by virtue of its status as an intergovernmental organisation 
C nor does it submit to any jurisdiction.
C

      SUBROUTINE LGRPR4 (KSEC0,KLINE,KSEC4,PSEC4)
C
C---->
C**** lgrpr4 - Print information from Section 4 of GRIB code.
C
C     Purpose.
C     --------
C
C           Print the information in the Binary data section
C           Section (Section 4) of decoded GRIB data.
C
C**   Interface.
C     ----------
C
C           CALL lgrpr4 (KSEC0,KSEC4,PSEC4)
C
C           Integer    K.
C           Real       P.
C           Logical    O.
C           Character  H.
C
C               Input Parameters.
C               -----------------
C
C               KSEC0 - Array of decoded integers from Section 0.
C
C               KSEC4 - Array of decoded integers from Section 4.
C
C               PSEC4 - Array of decoded reals from Section 4.
C
C               Output Parameters.
C               ------------------
C
C               None.
C
C     Method.
C     -------
C
C           Fields printed as integers or reals.
C
C     Externals.
C     ----------
C
C           None.
C
C     Reference.
C     ----------
C
C           WMO Manual on Codes re GRIB Code.
C           See also routine GRIBEX.
C
C     Comments.
C     ---------
C
C           Routine contains Sections 0 to 1 and Section 9.
C
C     Author.
C     -------
C
C           J. Hennessy    ECMWF 11.09.91
C
C     Modifications.
C     --------------
C
C           K. Fielding    ecmwf 03/08/92
C           Special version with reduced printout for Monthly
C           means and time series
C
C----<
C     -----------------------------------------------------------------
C
C
C
C
C
C
C
C
C
C
C*    Section 0. Definition of variables.
C     -----------------------------------------------------------------
      IMPLICIT NONE
C
C*    Prefix conventions for variable names.
C
C     Logical      L (but not LP), global or common.
C                  O, dummy arguments.
C                  G, local variable.
C                  LP, parameter.
C     Character    C, Global or common.
C                  H, dummy arguments.
C                  Y (but not YP), local variables.
C                  YP, parameter.
C     Integer      M and N, global or common.
C                  K, dummy arguments.
C                  I, local variables.
C                  J (but not JP), loop control.
C                  JP, parameter.
C     Real         A to F and Q to X, global or common.
C                  P (but not PP), dummy arguments.
C                  Z, local variables.
C                  PP, parameter.
C
*IF DEF,CRAY
C     IMPLICIT NONE
*ENDIF
C
      INTEGER INUM
C
      INTEGER J210, J220
C
      INTEGER KSEC0
      INTEGER KSEC4
      INTEGER KLINE
C
      REAL PSEC4
C
      DIMENSION KSEC0(*)
      DIMENSION KSEC4(*)
C
      DIMENSION PSEC4(*)
C
C     -----------------------------------------------------------------
C
C
C
C
C
C
C
C
C
C
C*    Section 1 . Print integer information from KSEC4.
C     -----------------------------------------------------------------
C
  100 CONTINUE
C
      WRITE (*,9000)
      WRITE (*,9001)
      WRITE (*,9002)
C
      WRITE (*,9003) KSEC4(1)
      WRITE (*,9004) KSEC4(2)
C     WRITE (*,9005) KSEC4(3)
C     WRITE (*,9006) KSEC4(4)
C     WRITE (*,9007) KSEC4(5)
C     WRITE (*,9008) KSEC4(6)
C     WRITE (*,9009) KSEC4(7)
C     WRITE (*,9010) KSEC4(8)
C
C     -----------------------------------------------------------------
C
C
C
C
C
C
C
C
C
C
C
C*    Section 2. Print real values from PSEC4.
C     -----------------------------------------------------------------
C
  200 CONTINUE
C
      WRITE (*,9000)
C
      INUM = KSEC4(1)
      IF (INUM.LT.0)  INUM = - INUM
      IF (INUM.GT.10) INUM = 10
C
C     Print first INUM values.
C
      WRITE (*,9011) INUM
      DO 220 J220 = 0, 3
         WRITE (*, *)
      DO 210 J210=1,INUM
	 WRITE (*,9012) PSEC4(J220 * KLINE + J210)
  210 CONTINUE
  220 CONTINUE
C
C     -----------------------------------------------------------------
C
C
C
C
C
C
C
C*    Section 9 . Format statements. Return to calling routine.
C     -----------------------------------------------------------------
C
  900 CONTINUE
C
 9000 FORMAT (1H )
 9001 FORMAT (1H ,'Section 4 - Binary Data  Section.')
 9002 FORMAT (1H ,'-------------------------------------')
 9003 FORMAT (1H ,'Number of data values coded/decoded.         ',I9)
 9004 FORMAT (1H ,'Number of bits per data value.               ',I9)
 9005 FORMAT (1H ,'Type of data indicator.                      ',I9)
 9006 FORMAT (1H ,'Type of packing indicator.                   ',I9)
 9007 FORMAT (1H ,'Type of data representation.                 ',I9)
 9008 FORMAT (1H ,'Additional flags indicator.                  ',I9)
 9009 FORMAT (1H ,'Reserved.                                    ',I9)
 9010 FORMAT (1H ,'Number of values indicator.                  ',I9)
 9011 FORMAT (1H ,'First ',I4,' data values.')
 9012 FORMAT (1H ,F30.15)
C
      RETURN
C
      END
