DefineMacro="BeamLimitingDevicePositionMacro"
	Sequence="BeamLimitingDevicePositionSequence"				Type="1C"	VM="1-n"	NoCondition=""
		Name="RTBeamLimitingDeviceType"							Type="1"	StringEnumValues="RTBeamLimitingDeviceType"
		Name="LeafJawPositions"									Type="1"
	SequenceEnd
MacroEnd

DefineMacro="PatientSupportIdentificationMacro"
	Name="PatientSupportType"									Type="1"	StringDefinedTerms="PatientSupportType"
	Name="PatientSupportID"										Type="3"
	Name="PatientSupportAccessoryCode"							Type="3"
MacroEnd

Module="RTSeries"
	Name="Modality"										Type="1"	StringEnumValues="RTModality"
	Name="SeriesInstanceUID"							Type="1"
	Name="SeriesNumber"									Type="2"
	Name="SeriesDescription"							Type="3"
	Name="SeriesDate"									Type="3"
	Name="SeriesTime"									Type="3"
	Sequence="SeriesDescriptionCodeSequence"			Type="3"	VM="1"
		InvokeMacro="CodeSequenceMacro"
	SequenceEnd
	Name="OperatorsName"								Type="2"
	Sequence="OperatorIdentificationSequence"			Type="3"	VM="1-n"
		InvokeMacro="PersonIdentificationMacro"
	SequenceEnd
	Sequence="ReferencedPerformedProcedureStepSequence"	Type="3"	VM="1-n"
		InvokeMacro="SOPInstanceReferenceMacro"
	SequenceEnd
	Sequence="RequestAttributesSequence"				Type="3"	VM="1-n"
		InvokeMacro="RequestAttributesMacro"
	SequenceEnd
	InvokeMacro="PerformedProcedureStepSummaryMacro"
ModuleEnd

Module="RTImage"
	Name="SamplesPerPixel"								Type="1"	BinaryEnumValues="SamplesPerPixelIsOne"
	Name="PhotometricInterpretation"					Type="1"	StringEnumValues="PhotometricInterpretationMonochrome2"
	Name="BitsAllocated"								Type="1"	BinaryEnumValues="BitsAre8Or16"
	Name="BitsStored"									Type="1"	BinaryEnumValues="BitsAre8Or12To16"	#should real be 8 if BitsAllocated is 8 and 12 to 16 if BitsAllocated is 16
	Name="HighBit"										Type="1"	BinaryEnumValues="BitsAre7Or11To15"	#should real be one less than BitsStored
	Name="PixelRepresentation"							Type="1"	BinaryEnumValues="PixelRepresentationUnsigned"
	Name="PixelIntensityRelationship"					Type="1"	StringEnumValues="DXPixelIntensityRelationship"
	Name="PixelIntensityRelationshipSign"				Type="1"	BinaryEnumValues="PixelIntensityRelationshipSign"
	Name="RTImageLabel"									Type="1"
	Name="RTImageName"									Type="3"
	Name="RTImageDescription"							Type="3"
	Name="ImageType"									Type="1"	ValueSelector="2"	StringDefinedTerms="RTImageTypeValue3"
	Verify="ImageType"									Condition="ImageTypeValue3MissingOrEmpty"	ThenErrorMessage="A value is required for value 3 in RT Images"
	Name="ConversionType"								Type="2"	StringDefinedTerms="ConversionType"
	Name="ReportedValuesOrigin"							Type="2C"	Condition="ImageTypeValue3SimulatorOrPortal"	StringEnumValues="ReportedValuesOrigin"
	Name="RTImagePlane"									Type="1"	StringEnumValues="RTImagePlane"
	Name="XRayImageReceptorAngle"						Type="2"
	Name="RTImageOrientation"							Type="2C"	Condition="RTImagePlaneIsNonNormal" mbpo="true"
	Name="ImagePlanePixelSpacing"						Type="2"
	Name="RTImagePosition"								Type="2"
	Name="RadiationMachineName"							Type="2"
	Name="PrimaryDosimeterUnit"							Type="2"	StringEnumValues="PrimaryDosimeterUnit"
	Name="RadiationMachineSAD"							Type="2"
	Name="RadiationMachineSSD"							Type="3"
	Name="RTImageSID"									Type="2"
	Name="SourceToReferenceObjectDistance"				Type="3"
	Sequence="ReferencedRTPlanSequence"					Type="3"	VM="1"
		InvokeMacro="SOPInstanceReferenceMacro"
	SequenceEnd
	Name="ReferencedBeamNumber"							Type="3"
	Name="ReferencedFractionGroupNumber"				Type="3"
	Name="FractionNumber"								Type="3"
	Name="StartCumulativeMetersetWeight"				Type="3"
	Name="EndCumulativeMetersetWeight"					Type="3"
	Sequence="ExposureSequence"							Type="3"	VM="1-n"
		Name="ReferencedFrameNumber"					Type="1C"	Condition="NeedExposureSequenceReferencedFrameNumber"	NotZeroError=""
		Name="KVP"										Type="2C"	Condition="ImageTypeValue3SimulatorOrPortalOrRadiograph"
		Sequence="PrimaryFluenceModeSequence"			Type="3"	VM="1"
			Name="FluenceMode"							Type="1"	StringEnumValues="FluenceMode"
			Name="FluenceModeID"						Type="1C"	Condition="FluenceModeIsNonStandard"
		SequenceEnd
		Name="XRayTubeCurrent"							Type="2C"	Condition="ImageTypeValue3SimulatorOrRadiograph"
		Name="XRayTubeCurrentInmA"						Type="3"
		Name="ExposureTime"								Type="2C"	Condition="ImageTypeValue3SimulatorOrRadiograph"
		Name="ExposureTimeInms"							Type="3"
		Name="MetersetExposure"							Type="2C"	Condition="ImageTypeValue3Portal"
		Name="DiaphragmPosition"						Type="3"
		Sequence="BeamLimitingDeviceSequence"			Type="3"	VM="1-n"
			Name="RTBeamLimitingDeviceType"				Type="1"	StringEnumValues="RTBeamLimitingDeviceType"
			Name="SourceToBeamLimitingDeviceDistance"	Type="3"
			Name="NumberOfLeafJawPairs"					Type="1"
			Name="LeafPositionBoundaries"				Type="2C"	Condition="RTBeamLimitingDeviceTypeMLCXOrMLCY" mbpo="true"
			Name="LeafJawPositions"						Type="1"
		SequenceEnd
		Sequence="ApplicatorSequence"					Type="3"	VM="1"
			Name="ApplicatorID"							Type="1"
			Name="ApplicatorType"						Type="1"	StringDefinedTerms="ApplicatorType"
			Name="ApplicatorDescription"				Type="3"
		SequenceEnd
		Sequence="GeneralAccessorySequence"				Type="3"	VM="1-n"
			Name="GeneralAccessoryNumber"				Type="1"
			Name="GeneralAccessoryID"					Type="1"
			Name="GeneralAccessoryDescription"			Type="3"
			Name="GeneralAccessoryType"					Type="3"	StringDefinedTerms="RTGeneralAccessoryType"
			Name="AccessoryCode"						Type="3"
			Name="SourceToGeneralAccessoryDistance"		Type="3"
		SequenceEnd
		Name="NumberOfBlocks"							Type="1"
		Sequence="BlockSequence"						Type="2C"	VM="0-n"	Condition="NumberOfBlocksNotZero"
			Name="BlockTrayID"							Type="3"
			Name="TrayAccessoryCode"					Type="3"
			Name="AccessoryCode"						Type="3"
			Name="SourceToBlockTrayDistance"			Type="2"
			Name="BlockType"							Type="1"	StringEnumValues="BlockType"
			Name="BlockDivergence"						Type="2"	StringEnumValues="BlockDivergence"
			Name="BlockMountingPosition"				Type="3"	StringEnumValues="BlockMountingPosition"
			Name="BlockNumber"							Type="1"
			Name="BlockName"							Type="3"
			Name="MaterialID"							Type="2"
			Name="BlockThickness"						Type="3"
			Name="BlockNumberOfPoints"					Type="2"
			Name="BlockData"							Type="2"
		SequenceEnd
	SequenceEnd
	Sequence="FluenceMapSequence"						Type="1C"	VM="1"	Condition="ImageTypeValue3Fluence"
		Name="FluenceDataSource"						Type="1"	StringEnumValues="FluenceDataSource"
		Name="FluenceDataScale"							Type="3"
	SequenceEnd
	Name="GantryAngle"									Type="3"
	Name="GantryPitchAngle"								Type="3"
	Name="BeamLimitingDeviceAngle"						Type="3"
	Name="PatientSupportAngle"							Type="3"
	Name="TableTopEccentricAxisDistance"				Type="3"
	Name="TableTopEccentricAngle"						Type="3"
	Name="TableTopPitchAngle"							Type="3"
	Name="TableTopRollAngle"							Type="3"
	Name="TableTopVerticalPosition"						Type="3"
	Name="TableTopLongitudinalPosition"					Type="3"
	Name="TableTopLateralPosition"						Type="3"
	Name="IsocenterPosition"							Type="3"
	Name="PatientPosition"								Type="1C"	Condition="IsocenterPositionIsPresent"
	Name="ExposureTime"									Type="3"
	Name="ExposureTimeInms"								Type="3"
	Name="MetersetExposure"								Type="3"
ModuleEnd

Module="RTDose"
	Name="SamplesPerPixel"										Type="1C"	Condition="PixelDataPresent"	BinaryEnumValues="SamplesPerPixelIsOne"
	Name="PhotometricInterpretation"							Type="1C"	Condition="PixelDataPresent"	StringEnumValues="PhotometricInterpretationMonochrome2"
	Name="BitsAllocated"										Type="1C"	Condition="PixelDataPresent"	BinaryEnumValues="BitsAre16Or32"
	Name="BitsStored"											Type="1C"	Condition="PixelDataPresent"	BinaryEnumValues="BitsAre16Or32"	#should real be same as BitsAllocated
	Name="HighBit"												Type="1C"	Condition="PixelDataPresent"	BinaryEnumValues="BitsAre15Or31"	#should real be one less than BitsStored
	Name="PixelRepresentation"									Type="1C"	Condition="PixelDataPresent"	BinaryEnumValues="PixelRepresentationUnsigned"
	Name="ContentDate"											Type="3"
	Name="ContentTime"											Type="3"
	Name="DoseUnits"											Type="1"	StringEnumValues="DoseUnits"
	Name="DoseType"												Type="1"	StringDefinedTerms="DoseType"
	Name="SpatialTransformOfDose"								Type="3"	StringDefinedTerms="SpatialTransformOfDose"
	Sequence="ReferencedSpatialRegistrationSequence"			Type="2C"	VM="0-n"		Condition="SpatialTransformOfDoseIsRigidOrNonRigid"
		InvokeMacro="SOPInstanceReferenceMacro"
	SequenceEnd
	Name="InstanceNumber"										Type="3"
	Name="DoseComment"											Type="3"
	Name="NormalizationPoint"									Type="3"
	Name="DoseSummationType"									Type="1"	StringDefinedTerms="DoseSummationType"
	Sequence="ReferencedRTPlanSequence"							Type="1C"	VM="1-n"		Condition="NeedReferencedRTPlanSequence"
		InvokeMacro="SOPInstanceReferenceMacro"
		Sequence="ReferencedFractionGroupSequence"				Type="1C"	VM="1"		Condition="NeedReferencedFractionGroupSequence"
			Name="ReferencedFractionGroupNumber"				Type="1"
			Sequence="ReferencedBeamSequence"					Type="1C"	VM="1-n"	Condition="NeedReferencedBeamSequence"
				Name="ReferencedBeamNumber"						Type="1"
				Sequence="ReferencedControlPointSequence"		Type="1C"	VM="1"		Condition="DoseSummationTypeControlPoint"
					Name="ReferencedStartControlPointIndex"		Type="1"
					Name="ReferencedStopControlPointIndex"		Type="1"
				SequenceEnd
			SequenceEnd
			Sequence="ReferencedBrachyApplicationSetupSequence"	Type="1C"	VM="1-n"	Condition="NeedReferencedBrachyApplicationSetupSequence"
				Name="ReferencedBrachyApplicationSetupNumber"	Type="1"
			SequenceEnd
		SequenceEnd
	SequenceEnd
	Verify="ReferencedRTPlanSequence"										Condition="DoseSummationTypeIsNotMultiPlanAndReferencedRTPlanSequenceHasMultipleItems"	ThenErrorMessage="Multiple items not permitted unless DoseSummationType is MULTI_PLAN"
	Verify="ReferencedRTPlanSequence"										Condition="DoseSummationTypeIsMultiPlanAndReferencedRTPlanSequenceHasLessThanTwoItems"	ThenErrorMessage="Two or more items required if DoseSummationType is MULTI_PLAN"
	Name="GridFrameOffsetVector"								Type="1C"	Condition="NeedGridFrameOffsetVector"
	Name="DoseGridScaling"										Type="1C"	Condition="PixelDataPresent"
	Name="TissueHeterogeneityCorrection"						Type="3"	StringEnumValues="TissueHeterogeneityCorrection"
ModuleEnd

Module="RTDVH"
	Sequence="ReferencedStructureSetSequence"					Type="1"	VM="1"
		InvokeMacro="SOPInstanceReferenceMacro"
	SequenceEnd
	Name="DVHNormalizationPoint"								Type="3"
	Name="DVHNormalizationDoseValue"							Type="3"
	Sequence="DVHSequence"										Type="1"	VM="1-n"
		Sequence="DVHReferencedROISequence"						Type="1"	VM="1-n"
			Name="ReferencedROINumber"							Type="1"
			Name="DVHROIContributionType"						Type="1"	StringEnumValues="DVHROIContributionType"
		SequenceEnd
		Name="DVHType"											Type="1"	StringEnumValues="DVHType"
		Name="DoseUnits"										Type="1"	StringEnumValues="DVHDoseUnits"
		Name="DoseType"											Type="1"	StringDefinedTerms="DVHDoseType"
		Name="DVHDoseScaling"									Type="1"
		Name="DVHVolumeUnits"									Type="1"	StringDefinedTerms="DVHVolumeUnits"
		Name="DVHNumberOfBins"									Type="1"
		Name="DVHData"											Type="1"
		Name="DVHMinimumDose"									Type="3"
		Name="DVHMaximumDose"									Type="3"
		Name="DVHMeanDose"										Type="3"
	SequenceEnd
ModuleEnd

Module="StructureSet"
	Name="StructureSetLabel"									Type="1"
	Name="StructureSetName"										Type="3"
	Name="StructureSetDescription"								Type="3"
	Name="InstanceNumber"										Type="3"
	Name="StructureSetDate"										Type="2"
	Name="StructureSetTime"										Type="2"
	Sequence="ReferencedFrameOfReferenceSequence"				Type="3"	VM="1-n"
		Name="FrameOfReferenceUID"								Type="1"
		Sequence="FrameOfReferenceRelationshipSequence"			Type="3"	VM="1-n"
			Name="RelatedFrameOfReferenceUID"					Type="1"
			Name="FrameOfReferenceTransformationType"			Type="1"	StringDefinedTerms="TransformationType"
			Name="FrameOfReferenceTransformationMatrix"			Type="1"
			Name="FrameOfReferenceTransformationComment"		Type="3"
		SequenceEnd
		Sequence="RTReferencedStudySequence"					Type="3"	VM="1-n"
			InvokeMacro="SOPInstanceReferenceMacro"
			Sequence="RTReferencedSeriesSequence"				Type="1"	VM="1-n"
				Name="SeriesInstanceUID"						Type="1"
				Sequence="ContourImageSequence"					Type="1"	VM="1-n"
					InvokeMacro="ImageSOPInstanceReferenceMacro"
				SequenceEnd
			SequenceEnd
		SequenceEnd
	SequenceEnd
	Sequence="StructureSetROISequence"							Type="1"	VM="1-n"
		Name="ROINumber"										Type="1"
		Name="ReferencedFrameOfReferenceUID"					Type="1"
		Name="ROIName"											Type="2"
		Name="ROIDescription"									Type="3"
		Name="ROIVolume"										Type="3"
		Name="ROIGenerationAlgorithm"							Type="2"	StringDefinedTerms="ROIGenerationAlgorithm"
		Name="ROIGenerationDescription"							Type="3"
	SequenceEnd
	Sequence="PredecessorStructureSetSequence"					Type="3"	VM="1"
		InvokeMacro="SOPInstanceReferenceMacro"
	SequenceEnd
ModuleEnd

Module="ROIContour"
	Sequence="ROIContourSequence"								Type="1"	VM="1-n"
		Name="ReferencedROINumber"								Type="1"
		Name="ROIDisplayColor"									Type="3"
		Sequence="ContourSequence"								Type="3"	VM="1-n"
			Name="ContourNumber"								Type="3"
			Name="AttachedContours"								Type="3"
			Sequence="ContourImageSequence"						Type="3"	VM="1-n"
				InvokeMacro="ImageSOPInstanceReferenceMacro"
			SequenceEnd
			Name="ContourGeometricType"							Type="1"	StringEnumValues="ContourGeometricType"
			Name="ContourSlabThickness"							Type="3"
			Name="ContourOffsetVector"							Type="3"
			Name="NumberOfContourPoints"						Type="1"
			Name="ContourData"									Type="1"
		SequenceEnd
	SequenceEnd
ModuleEnd

Module="RTDoseROI"
	Sequence="RTDoseROISequence"								Type="1"	VM="1-n"
		Name="ReferencedROINumber"								Type="1"
		Name="DoseUnits"										Type="1"	StringEnumValues="DoseUnits"
		Name="DoseValue"										Type="1"
	SequenceEnd
ModuleEnd

Module="RTROIObservations"
	Sequence="RTROIObservationsSequence"						Type="1"	VM="1-n"
		Name="ObservationNumber"								Type="1"
		Name="ReferencedROINumber"								Type="1"
		Name="ROIObservationLabel"								Type="3"
		Name="ROIObservationDescription"						Type="3"
		Sequence="RTRelatedROISequence"							Type="3"	VM="1-n"
			Name="ReferencedROINumber"							Type="1"
			Name="RTROIRelationship"							Type="3"	StringDefinedTerms="RTROIRelationship"
		SequenceEnd
		Sequence="RTROIIdentificationCodeSequence"				Type="3"	VM="1"
			InvokeMacro="CodeSequenceMacro"
			Sequence="SegmentedPropertyTypeModifierCodeSequence"	Type="3"	VM="1-n"
				InvokeMacro="CodeSequenceMacro"								BaselineContextID="244"
			SequenceEnd
		SequenceEnd
		Sequence="RelatedRTROIObservationsSequence"				Type="3"	VM="1-n"
			Name="ObservationNumber"							Type="1"
		SequenceEnd
		Name="RTROIInterpretedType"								Type="2"	StringDefinedTerms="RTROIInterpretedType"
		Name="ROIInterpreter"									Type="2"
		Name="MaterialID"										Type="3"
		Sequence="ROIPhysicalPropertiesSequence"				Type="3"	VM="1-n"
			Name="ROIPhysicalProperty"							Type="1"	StringDefinedTerms="ROIPhysicalProperty"
			Sequence="ROIElementalCompositionSequence"				Type="1C"	VM="1-n"	Condition="ROIPhysicalPropertyIsElemFraction"
				Name="ROIElementalCompositionAtomicNumber"			Type="1"
				Name="ROIElementalCompositionAtomicMassFraction"	Type="1"
			SequenceEnd
			Name="ROIPhysicalPropertyValue"						Type="1"
		SequenceEnd
	SequenceEnd
ModuleEnd

Module="RTGeneralPlan"
	Name="RTPlanLabel"											Type="1"
	Name="RTPlanName"											Type="3"
	Name="RTPlanDescription"									Type="3"
	Name="InstanceNumber"										Type="3"
	Name="RTPlanDate"											Type="2"
	Name="RTPlanTime"											Type="2"
	Name="TreatmentProtocols"									Type="3"
	Name="PlanIntent"											Type="3"	StringDefinedTerms="PlanIntent"
	Name="TreatmentSites"										Type="3"
	Name="RTPlanGeometry"										Type="1"	StringDefinedTerms="RTPlanGeometry"
	Sequence="ReferencedStructureSetSequence"					Type="1C"	VM="1"	Condition="RTPlanGeometryIsPatient"
		InvokeMacro="SOPInstanceReferenceMacro"
	SequenceEnd
	Sequence="ReferencedDoseSequence"							Type="3"	VM="1-n"
		InvokeMacro="SOPInstanceReferenceMacro"
	SequenceEnd
	Sequence="ReferencedRTPlanSequence"							Type="3"`	VM="1-n"
		InvokeMacro="SOPInstanceReferenceMacro"
		Name="RTPlanRelationship"								Type="1"	StringDefinedTerms="RTPlanRelationship"
		Verify="RTPlanRelationship"											Condition="PlanIntentIsVerification" StringDefinedTerms="RTPlanRelationshipVerifiedPlan"
	SequenceEnd
	Name="FrameOfReferenceToDisplayedCoordinateSystemTransformationMatrix"	Type="3"
ModuleEnd

Module="RTPrescription"
	Name="PrescriptionDescription"								Type="3"
	Sequence="DoseReferenceSequence"							Type="3"	VM="1-n"
		Name="DoseReferenceNumber"								Type="1"
		Name="DoseReferenceUID"									Type="3"
		Name="DoseReferenceStructureType"						Type="1"	StringDefinedTerms="DoseReferenceStructureType"
		Name="DoseReferenceDescription"							Type="3"
		Name="ReferencedROINumber"								Type="1C"	Condition="DoseReferenceStructureTypePointOrVolume"
		Name="DoseReferencePointCoordinates"					Type="1C"	Condition="DoseReferenceStructureTypeCoordinates"
		Name="NominalPriorDose"									Type="3"
		Name="DoseReferenceType"								Type="1"	StringDefinedTerms="DoseReferenceType"
		Name="ConstraintWeight"									Type="3"
		Name="DeliveryWarningDose"								Type="3"
		Name="DeliveryMaximumDose"								Type="3"
		Name="TargetMinimumDose"								Type="3"
		Name="TargetPrescriptionDose"							Type="3"
		Name="TargetMaximumDose"								Type="3"
		Name="TargetUnderdoseVolumeFraction"					Type="3"
		Name="OrganAtRiskFullVolumeDose"						Type="3"
		Name="OrganAtRiskLimitDose"								Type="3"
		Name="OrganAtRiskMaximumDose"							Type="3"
		Name="OrganAtRiskOverdoseVolumeFraction"				Type="3"
	SequenceEnd
ModuleEnd

Module="RTToleranceTables"
	Sequence="ToleranceTableSequence"							Type="3"	VM="1-n"
		Name="ToleranceTableNumber"								Type="1"
		Name="ToleranceTableLabel"								Type="3"
		Name="GantryAngleTolerance"								Type="3"
		Name="GantryPitchAngleTolerance"						Type="3"
		Name="BeamLimitingDeviceAngleTolerance"					Type="3"
		Sequence="BeamLimitingDeviceToleranceSequence"			Type="3"	VM="1-n"
			Name="RTBeamLimitingDeviceType"						Type="1"	StringEnumValues="RTBeamLimitingDeviceType"
			Name="BeamLimitingDevicePositionTolerance"			Type="1"
		SequenceEnd
		Name="PatientSupportAngleTolerance"						Type="3"
		Name="TableTopEccentricAngleTolerance"					Type="3"
		Name="TableTopPitchAngleTolerance"						Type="3"
		Name="TableTopRollAngleTolerance"						Type="3"
		Name="TableTopVerticalPositionTolerance"				Type="3"
		Name="TableTopLongitudinalPositionTolerance"			Type="3"
		Name="TableTopLateralPositionTolerance"					Type="3"
	SequenceEnd
ModuleEnd

Module="RTPatientSetup"
	Sequence="PatientSetupSequence"								Type="1"	VM="1-n"
		Name="PatientSetupNumber"								Type="1"
		Name="PatientSetupLabel"								Type="3"
		Name="PatientPosition"									Type="1C"	Condition="PatientAdditionalPositionNotPresent"		StringDefinedTerms="RTPatientPosition"
		Name="PatientAdditionalPosition"						Type="1C"	Condition="PatientPositionNotPresent"
		Sequence="ReferencedSetupImageSequence"					Type="3"	VM="1-n"
			Name="SetupImageComment"							Type="3"
			InvokeMacro="ImageSOPInstanceReferenceMacro"
		SequenceEnd
		Sequence="FixationDeviceSequence"						Type="3"	VM="1-n"
			Name="FixationDeviceType"							Type="1"	StringDefinedTerms="FixationDeviceType"
			Name="FixationDeviceLabel"							Type="2"
			Name="FixationDeviceDescription"					Type="3"
			Name="FixationDevicePosition"						Type="3"
			Name="FixationDevicePitchAngle"						Type="3"
			Name="FixationDeviceRollAngle"						Type="3"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Sequence="ShieldingDeviceSequence"						Type="3"	VM="1-n"
			Name="ShieldingDeviceType"							Type="1"	StringDefinedTerms="ShieldingDeviceType"
			Name="ShieldingDeviceLabel"							Type="2"
			Name="ShieldingDeviceDescription"					Type="3"
			Name="ShieldingDevicePosition"						Type="3"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Name="SetupTechnique"									Type="3"	StringDefinedTerms="SetupTechnique"
		Name="SetupTechniqueDescription"						Type="3"
		Sequence="SetupDeviceSequence"							Type="3"	VM="1-n"
			Name="SetupDeviceType"								Type="1"	StringDefinedTerms="SetupDeviceType"
			Name="SetupDeviceLabel"								Type="2"
			Name="SetupDeviceDescription"						Type="3"
			Name="SetupDeviceParameter"							Type="2"
			Name="SetupReferenceDescription"					Type="3"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Name="TableTopVerticalSetupDisplacement"				Type="3"
		Name="TableTopLongitudinalSetupDisplacement"			Type="3"
		Name="TableTopLateralSetupDisplacement"					Type="3"
		Sequence="MotionSynchronizationSequence"				Type="3"	VM="1-n"
			Name="RespiratoryMotionCompensationTechnique"		Type="1"	StringDefinedTerms="RTRespiratoryMotionCompensationTechnique"
			Name="RespiratorySignalSource"						Type="1"	StringDefinedTerms="RTRespiratorySignalSource"
			Name="RespiratoryMotionCompensationTechniqueDescription"	Type="3"
			Name="RespiratorySignalSourceID"					Type="3"
		SequenceEnd
	SequenceEnd
ModuleEnd

Module="RTFractionScheme"
	Sequence="FractionGroupSequence"							Type="1"	VM="1-n"
		Name="FractionGroupNumber"								Type="1"
		Name="FractionGroupDescription"							Type="3"
		Sequence="ReferencedDoseSequence"						Type="3"	VM="1-n"
			InvokeMacro="SOPInstanceReferenceMacro"
		SequenceEnd
		Sequence="ReferencedDoseReferenceSequence"				Type="3"	VM="1-n"
			Name="ReferencedDoseReferenceNumber"				Type="1"
			Name="ConstraintWeight"								Type="3"
			Name="DeliveryWarningDose"							Type="3"
			Name="DeliveryMaximumDose"							Type="3"
			Name="TargetMinimumDose"							Type="3"
			Name="TargetPrescriptionDose"						Type="3"
			Name="TargetMaximumDose"							Type="3"
			Name="TargetUnderdoseVolumeFraction"				Type="3"
			Name="OrganAtRiskFullVolumeDose"					Type="3"
			Name="OrganAtRiskLimitDose"							Type="3"
			Name="OrganAtRiskMaximumDose"						Type="3"
			Name="OrganAtRiskOverdoseVolumeFraction"			Type="3"
		SequenceEnd
		Name="NumberOfFractionsPlanned"							Type="2"
		Name="NumberOfFractionPatternDigitsPerDay"				Type="3"
		Name="RepeatFractionCycleLength"						Type="3"
		Name="FractionPattern"									Type="3"
		Name="BeamDoseMeaning"									Type="3"	StringEnumValues="BeamDoseMeaning"
		Name="NumberOfBeams"									Type="1"
		Sequence="ReferencedBeamSequence"						Type="1C"	VM="1-n"	Condition="NumberOfBeamsNotZero"
			Name="ReferencedBeamNumber"							Type="1"
			Name="BeamDoseSpecificationPoint"					Type="3"
			Name="ReferencedDoseReferenceUID"					Type="3"
			Name="BeamDose"										Type="3"
			Name="BeamDoseType"									Type="1C"	Condition="AlternateBeamDosePresent"	StringEnumValues="BeamDoseType"	mbpo="true"
			Verify="BeamDoseType"											Condition="AlternateBeamDoseTypeSameValueAsBeamDoseType"	ThenErrorMessage="A different value than AlternateBeamDoseType is required"
			Name="AlternateBeamDose"							Type="3"
			Name="AlternateBeamDoseType"						Type="1C"	Condition="AlternateBeamDosePresent"	StringEnumValues="BeamDoseType"
			Verify="AlternateBeamDoseType"									Condition="AlternateBeamDoseTypeSameValueAsBeamDoseType"	ThenErrorMessage="A different value than BeamDoseType is required"
			Sequence="BeamDoseVerificationControlPointSequence"	Type="3"	VM="2-n"
				Name="CumulativeMetersetWeight"					Type="1"
				Name="ReferencedControlPointIndex"				Type="1C"	NoCondition=""		# Required if the Referenced Cumulative Meterset corresponds to a Control Point in the Control Point Sequence:(
				Name="AverageBeamDosePointDepth"				Type="2C"	NoCondition=""		# Required for all but the last items in that sequence :(
				Name="AverageBeamDosePointEquivalentDepth"		Type="2C"	NoCondition=""		# Required for all but the last items in that sequence :(
				Name="AverageBeamDosePointSSD"					Type="2C"	NoCondition=""		# Required for all but the last items in that sequence :(
			SequenceEnd
			Name="BeamMeterset"									Type="3"
		SequenceEnd
		Name="NumberOfBrachyApplicationSetups"					Type="1"
		Sequence="ReferencedBrachyApplicationSetupSequence"		Type="1C"	VM="1-n"	Condition="NumberOfBrachyApplicationSetupsNotZero"
			Name="ReferencedBrachyApplicationSetupNumber"		Type="1"
			Name="BrachyApplicationSetupDoseSpecificationPoint"	Type="3"
			Name="BrachyApplicationSetupDose"					Type="3"
		SequenceEnd
	SequenceEnd
ModuleEnd

Module="RTBeams"
	Sequence="BeamSequence"										Type="1"	VM="1-n"
		Name="BeamNumber"										Type="1"
		Name="BeamName"											Type="3"
		Name="BeamDescription"									Type="3"
		Name="BeamType"											Type="1"	StringEnumValues="BeamType"
		Name="RadiationType"									Type="2"	StringDefinedTerms="RadiationType"
		Sequence="PrimaryFluenceModeSequence"					Type="3"	VM="1"
			Name="FluenceMode"									Type="1"	StringEnumValues="FluenceMode"
			Name="FluenceModeID"								Type="1C"	Condition="FluenceModeIsNonStandard"
		SequenceEnd
		Name="HighDoseTechniqueType"							Type="1C"	StringDefinedTerms="HighDoseTechniqueType"	NoCondition="" # real-world
		Name="TreatmentMachineName"								Type="2"
		Name="Manufacturer"										Type="3"
		Name="InstitutionName"									Type="3"
		Name="InstitutionAddress"								Type="3"
		Name="InstitutionalDepartmentName"						Type="3"
		Name="ManufacturerModelName"							Type="3"
		Name="DeviceSerialNumber"								Type="3"
		Name="PrimaryDosimeterUnit"								Type="3"	StringEnumValues="PrimaryDosimeterUnit"
		Name="ReferencedToleranceTableNumber"					Type="3"
		Name="SourceAxisDistance"								Type="3"
		Sequence="BeamLimitingDeviceSequence"					Type="1"	VM="1-n"
			Name="RTBeamLimitingDeviceType"						Type="1"	StringEnumValues="RTBeamLimitingDeviceType"
			Name="SourceToBeamLimitingDeviceDistance"			Type="3"
			Name="NumberOfLeafJawPairs"							Type="1"
			Name="LeafPositionBoundaries"						Type="2C"	Condition="RTBeamLimitingDeviceTypeMLCXOrMLCY" mbpo="true"
		SequenceEnd
		Name="ReferencedPatientSetupNumber"						Type="3"
		Sequence="ReferencedReferenceImageSequence"				Type="3"	VM="1-n"
			InvokeMacro="SOPInstanceReferenceMacro"
			Name="ReferenceImageNumber"							Type="1"
			Name="StartCumulativeMetersetWeight"				Type="3"
			Name="EndCumulativeMetersetWeight"					Type="3"
		SequenceEnd
		Sequence="PlannedVerificationImageSequence"				Type="3"	VM="1-n"
			Name="StartCumulativeMetersetWeight"				Type="3"
			Name="MetersetExposure"								Type="3"
			Name="EndCumulativeMetersetWeight"					Type="3"
			Name="RTImagePlane"									Type="3"	StringEnumValues="RTImagePlane"
			Name="XRayImageReceptorAngle"						Type="3"
			Name="RTImageOrientation"							Type="3"
			Name="RTImagePosition"								Type="3"
			Name="RTImageSID"									Type="3"
			Name="ImagingDeviceSpecificAcquisitionParameters"	Type="3"
			Name="ReferencedReferenceImageNumber"		Type="3"
		SequenceEnd
		Name="TreatmentDeliveryType"							Type="3"	StringDefinedTerms="TreatmentDeliveryType"
		Sequence="ReferencedDoseSequence"						Type="3"	VM="1-n"
			InvokeMacro="SOPInstanceReferenceMacro"
		SequenceEnd
		Name="NumberOfWedges"									Type="1"
		Sequence="WedgeSequence"								Type="1C"	VM="1-n"	Condition="NumberOfWedgesNotZero"
			Name="WedgeNumber"									Type="1"
			Name="WedgeType"									Type="2"	StringDefinedTerms="WedgeType"
			Name="WedgeID"										Type="3"
			Name="AccessoryCode"								Type="3"
			Name="WedgeAngle"									Type="2"
			Name="WedgeFactor"									Type="2"
			Name="WedgeOrientation"								Type="2"
			Name="SourceToWedgeTrayDistance"					Type="3"
		SequenceEnd
		Name="NumberOfCompensators"								Type="1"
		Name="TotalCompensatorTrayFactor"						Type="3"
		Sequence="CompensatorSequence"							Type="1C"	VM="1-n"	Condition="NumberOfCompensatorsNotZero"
			Name="CompensatorDescription"						Type="3"
			Name="CompensatorNumber"							Type="1"
			Name="MaterialID"									Type="2"
			Name="CompensatorID"								Type="3"
			Name="AccessoryCode"								Type="3"
			Name="CompensatorTrayID"							Type="3"
			Name="TrayAccessoryCode"							Type="3"
			Name="SourceToCompensatorTrayDistance"				Type="2"
			Name="CompensatorDivergence"						Type="3"	StringEnumValues="CompensatorDivergence"
			Name="CompensatorMountingPosition"					Type="3"	StringEnumValues="CompensatorMountingPosition"
			Name="CompensatorRows"								Type="1"
			Name="CompensatorColumns"							Type="1"
			Name="CompensatorPixelSpacing"						Type="1"
			Name="CompensatorPosition"							Type="1"
			Name="CompensatorTransmissionData"					Type="1"
			Name="CompensatorThicknessData"						Type="1"
			Name="SourceToCompensatorDistance"					Type="1C"	Condition="NeedSourceToCompensatorDistance"
		SequenceEnd
		Name="NumberOfBoli"										Type="1"
		Sequence="ReferencedBolusSequence"						Type="1C"	VM="1-n"	Condition="NumberOfBoliNotZero"
			Name="ReferencedROINumber"							Type="1"
			Name="BolusID"										Type="3"
			Name="BolusDescription"								Type="3"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Name="NumberOfBlocks"									Type="1"
		Name="TotalBlockTrayFactor"								Type="3"
		Sequence="BlockSequence"								Type="1C"	VM="1-n"	Condition="NumberOfBlocksNotZero"
			Name="BlockTrayID"									Type="3"
			Name="TrayAccessoryCode"							Type="3"
			Name="AccessoryCode"								Type="3"
			Name="SourceToBlockTrayDistance"					Type="2"
			Name="BlockType"									Type="1"	StringEnumValues="BlockType"
			Name="BlockDivergence"								Type="2"	StringEnumValues="BlockDivergence"
			Name="BlockMountingPosition"						Type="3"	StringEnumValues="BlockMountingPosition"
			Name="BlockNumber"									Type="1"
			Name="BlockName"									Type="3"
			Name="MaterialID"									Type="2"
			Name="BlockThickness"								Type="2"
			Name="BlockTransmission"							Type="2"
			Name="BlockNumberOfPoints"							Type="2"
			Name="BlockData"									Type="2"
		SequenceEnd
		Sequence="ApplicatorSequence"							Type="3"	VM="1"
			Name="ApplicatorID"									Type="1"
			Name="AccessoryCode"								Type="3"
			Name="ApplicatorType"								Type="1"	StringDefinedTerms="ApplicatorType"
			Name="ApplicatorDescription"						Type="3"
			Sequence="GeneralAccessorySequence"					Type="3"	VM="1-n"
				Name="GeneralAccessoryNumber"					Type="1"
				Name="GeneralAccessoryID"						Type="1"
				Name="GeneralAccessoryDescription"				Type="3"
				Name="GeneralAccessoryType"						Type="3"	StringDefinedTerms="RTGeneralAccessoryType"
				Name="AccessoryCode"							Type="3"
				Name="SourceToGeneralAccessoryDistance"			Type="3"
			SequenceEnd
		SequenceEnd
		Name="FinalCumulativeMetersetWeight"					Type="1C"	NoCondition=""
		Name="NumberOfControlPoints"							Type="1"
		Sequence="ControlPointSequence"							Type="1"	VM="2-n"
			Name="ControlPointIndex"							Type="1"
			Name="CumulativeMetersetWeight"						Type="2"
			Sequence="ReferencedDoseReferenceSequence"			Type="3"	VM="1-n"
				Name="ReferencedDoseReferenceNumber"			Type="1"
				Name="CumulativeDoseReferenceCoefficient"		Type="2"
			SequenceEnd
			Sequence="ReferencedDoseSequence"					Type="1C"	VM="1-n"	Condition="DoseSummationTypeControlPoint"
				InvokeMacro="SOPInstanceReferenceMacro"
			SequenceEnd
			Name="NominalBeamEnergy"							Type="3"
			Name="DoseRateSet"									Type="3"
			Sequence="WedgePositionSequence"					Type="3"	VM="1-n"
				Name="ReferencedWedgeNumber"					Type="1"
				Name="WedgePosition"							Type="1"	StringEnumValues="WedgePosition"
			SequenceEnd
			Sequence="BeamLimitingDevicePositionSequence"		Type="1C"	VM="1-n"	NoCondition=""
				Name="RTBeamLimitingDeviceType"					Type="1"	StringEnumValues="RTBeamLimitingDeviceType"
				Name="LeafJawPositions"							Type="1"
			SequenceEnd
			Name="GantryAngle"									Type="1C"	NoCondition=""
			Name="GantryRotationDirection"						Type="1C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="GantryPitchAngle"								Type="3"
			Name="GantryPitchRotationDirection"					Type="3"	StringEnumValues="RotationDirectionWithNone"
			Name="BeamLimitingDeviceAngle"						Type="1C"	NoCondition=""
			Name="BeamLimitingDeviceRotationDirection"			Type="1C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="PatientSupportAngle"							Type="1C"	NoCondition=""
			Name="PatientSupportRotationDirection"				Type="1C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="TableTopEccentricAxisDistance"				Type="3"
			Name="TableTopEccentricAngle"						Type="1C"	NoCondition=""
			Name="TableTopEccentricRotationDirection"			Type="1C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="TableTopPitchAngle"							Type="1C"	NoCondition=""
			Name="TableTopPitchRotationDirection"				Type="1C""	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="TableTopRollAngle"							Type="1C"	NoCondition=""
			Name="TableTopRollRotationDirection"				Type="1C""	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="TableTopVerticalPosition"						Type="2C"	NoCondition=""
			Name="TableTopLongitudinalPosition"					Type="2C"	NoCondition=""
			Name="TableTopLateralPosition"						Type="2C"	NoCondition=""
			Name="IsocenterPosition"							Type="2C"	NoCondition=""
			Name="SurfaceEntryPoint"							Type="3"
			Name="SourceToSurfaceDistance"						Type="3"
		SequenceEnd
	SequenceEnd
ModuleEnd

Module="RTBrachyApplicationSetups"
	Name="BrachyTreatmentTechnique"								Type="1"	StringEnumValues="BrachyTreatmentTechnique"
	Name="BrachyTreatmentType"									Type="1"	StringDefinedTerms="BrachyTreatmentType"
	Sequence="TreatmentMachineSequence"							Type="1"	VM="1"
		Name="TreatmentMachineName"								Type="2"
		Name="Manufacturer"										Type="3"
		Name="InstitutionName"									Type="3"
		Name="InstitutionAddress"								Type="3"
		Name="InstitutionalDepartmentName"						Type="3"
		Name="ManufacturerModelName"							Type="3"
		Name="DeviceSerialNumber"								Type="3"
	SequenceEnd
	Sequence="SourceSequence"									Type="1"	VM="1-n"
		Name="SourceNumber"										Type="1"
		Name="SourceSerialNumber"								Type="3"
		Name="SourceModelID"									Type="3"
		Name="SourceDescription"								Type="3"
		Name="SourceType"										Type="1"
		Name="SourceManufacturer"								Type="3"
		Name="ActiveSourceDiameter"								Type="3"
		Name="ActiveSourceLength"								Type="3"
		Name="MaterialID"										Type="3"
		Name="SourceEncapsulationNominalThickness"				Type="3"
		Name="SourceEncapsulationNominalTransmission"			Type="3"
		Name="SourceIsotopeName"								Type="1"
		Name="SourceIsotopeHalfLife"							Type="1"
		Name="SourceStrengthUnits"								Type="1C"	Condition="SourceIsNotGammaEmitter"	StringEnumValues="SourceStrengthUnits" mbpo="true"
		Name="ReferenceAirKermaRate"							Type="1"
		Name="SourceStrength"									Type="1C"	Condition="SourceIsNotGammaEmitter"
		Name="SourceStrengthReferenceDate"						Type="1"
		Name="SourceStrengthReferenceTime"						Type="1"
	SequenceEnd
	Sequence="ApplicationSetupSequence"							Type="1"	VM="1-n"
		Name="ApplicationSetupType"								Type="1"	StringDefinedTerms="ApplicationSetupType"
		Name="ApplicationSetupNumber"							Type="1"
		Name="ApplicationSetupName"								Type="3"
		Name="ApplicationSetupManufacturer"						Type="3"
		Name="TemplateNumber"									Type="3"
		Name="TemplateType"										Type="3"
		Name="TemplateName"										Type="3"
		Sequence="ReferencedReferenceImageSequence"				Type="3"	VM="1-n"
			InvokeMacro="SOPInstanceReferenceMacro"
		SequenceEnd
		Name="TotalReferenceAirKerma"							Type="1"
		Sequence="BrachyAccessoryDeviceSequence"				Type="3"	VM="1-n"
			Name="BrachyAccessoryDeviceNumber"					Type="2"
			Name="BrachyAccessoryDeviceID"						Type="2"
			Name="BrachyAccessoryDeviceType"					Type="1"	StringDefinedTerms="BrachyAccessoryDeviceType"
			Name="BrachyAccessoryDeviceName"					Type="3"
			Name="MaterialID"									Type="3"
			Name="BrachyAccessoryDeviceNominalThickness"		Type="3"
			Name="BrachyAccessoryDeviceNominalTransmission"		Type="3"
			Name="ReferencedROINumber"							Type="2"
		SequenceEnd
		Sequence="ChannelSequence"								Type="1"	VM="1-n"
			Name="ChannelNumber"								Type="1"
			Name="ChannelLength"								Type="2"
			Name="ChannelTotalTime"								Type="1"
			Name="SourceMovementType"							Type="1"	StringDefinedTerms="SourceMovementType"
			Name="NumberOfPulses"								Type="1C"	Condition="BrachyTreatmentTypePDR"
			Name="PulseRepetitionInterval"						Type="1C"	Condition="BrachyTreatmentTypePDR"
			Name="SourceApplicatorNumber"						Type="3"
			Name="SourceApplicatorID"							Type="2C"	Condition="SourceApplicatorNumberPresent"
			Name="SourceApplicatorType"							Type="1C"	Condition="SourceApplicatorNumberPresent"	StringDefinedTerms="SourceApplicatorType"
			Name="SourceApplicatorName"							Type="3"
			Name="SourceApplicatorLength"						Type="1C"	Condition="SourceApplicatorNumberPresent"
			Name="SourceApplicatorManufacturer"					Type="3"
			Name="MaterialID"									Type="3"
			Name="SourceApplicatorWallNominalThickness"			Type="3"
			Name="SourceApplicatorWallNominalTransmission"		Type="3"
			Name="SourceApplicatorStepSize"						Type="1C"	Condition="SourceMovementTypeStepwise"
			Name="ReferencedROINumber"							Type="2C"	Condition="SourceApplicatorNumberPresent"
			Name="TransferTubeNumber"							Type="2"
			Name="TransferTubeLength"							Type="2C"	Condition="TransferTubeNumberNotNull"
			Sequence="ChannelShieldSequence"					Type="3"	VM="1-n"
				Name="ChannelShieldNumber"						Type="1"
				Name="ChannelShieldID"							Type="2"
				Name="ChannelShieldName"						Type="3"
				Name="MaterialID"								Type="3"
				Name="ChannelShieldNominalThickness"			Type="3"
				Name="ChannelShieldNominalTransmission"			Type="3"
				Name="ReferencedROINumber"						Type="2"
			SequenceEnd
			Name="ReferencedSourceNumber"						Type="1"
			Name="NumberOfControlPoints"						Type="1"
			Name="FinalCumulativeTimeWeight"					Type="1C"	NoCondition=""
			Sequence="BrachyControlPointSequence"				Type="1"	VM="2-n"
				Name="ControlPointIndex"						Type="1"
				Name="CumulativeTimeWeight"						Type="2"
				Name="ControlPointRelativePosition"				Type="1"
				Name="ControlPoint3DPosition"					Type="3"
				Name="ControlPointOrientation"					Type="3"
				Sequence="BrachyReferencedDoseReferenceSequence"	Type="3"	VM="1-n"
					Name="ReferencedDoseReferenceNumber"		Type="1"
					Name="CumulativeDoseReferenceCoefficient"	Type="1"
				SequenceEnd
			SequenceEnd
		SequenceEnd
	SequenceEnd
ModuleEnd

Module="Approval"
	Name="ApprovalStatus"										Type="1"	StringEnumValues="ApprovalStatus"
	Name="ReviewDate"											Type="2C"	Condition="ApprovalStatusApprovedOrRejected"
	Name="ReviewTime"											Type="2C"	Condition="ApprovalStatusApprovedOrRejected"
	Name="ReviewerName"											Type="2C"	Condition="ApprovalStatusApprovedOrRejected"
ModuleEnd

Module="RTGeneralTreatmentRecord"
	Name="InstanceNumber"										Type="1"
	Name="TreatmentDate"										Type="2"
	Name="TreatmentTime"										Type="2"
	Sequence="ReferencedRTPlanSequence"							Type="2"	VM="0-1"
		InvokeMacro="SOPInstanceReferenceMacro"
	SequenceEnd
	Sequence="ReferencedTreatmentRecordSequence"				Type="3"	VM="1-n"
		InvokeMacro="SOPInstanceReferenceMacro"
	SequenceEnd
ModuleEnd

Module="RTTreatmentMachineRecord"
	Sequence="TreatmentMachineSequence"							Type="1"	VM="1"
		Name="TreatmentMachineName"								Type="2"
		Name="Manufacturer"										Type="2"
		Name="InstitutionName"									Type="2"
		Name="InstitutionAddress"								Type="3"
		Name="InstitutionalDepartmentName"						Type="3"
		Name="ManufacturerModelName"							Type="2"
		Name="DeviceSerialNumber"								Type="2"
	SequenceEnd
ModuleEnd

Module="MeasuredDoseReferenceRecord"
	Sequence="MeasuredDoseReferenceSequence"					Type="1"	VM="1-n"
		Name="ReferencedDoseReferenceNumber"					Type="1C"	Condition="MeasuredDoseReferenceNumberNotPresent"
		Name="MeasuredDoseReferenceNumber"						Type="1C"	Condition="ReferencedDoseReferenceNumberNotPresent"
		Name="DoseUnits"										Type="1"	StringEnumValues="DoseUnits"
		Name="MeasuredDoseValue"								Type="2"
		Name="MeasuredDoseType"									Type="2"	StringDefinedTerms="MeasuredDoseType"
		Name="MeasuredDoseDescription"							Type="3"
	SequenceEnd
ModuleEnd

Module="CalculatedDoseReferenceRecord"
	Sequence="CalculatedDoseReferenceSequence"					Type="1"	VM="1-n"
		Name="ReferencedDoseReferenceNumber"					Type="1C"	Condition="CalculatedDoseReferenceNumberNotPresent"
		Name="CalculatedDoseReferenceNumber"					Type="1C"	Condition="ReferencedDoseReferenceNumberNotPresent"
		Name="CalculatedDoseReferenceDoseValue"					Type="2"
		Name="CalculatedDoseReferenceDescription"				Type="3"
	SequenceEnd
ModuleEnd

Module="RTBeamsSessionRecord"
	Name="ReferencedFractionGroupNumber"						Type="3"
	Name="NumberOfFractionsPlanned"								Type="2"
	Name="PrimaryDosimeterUnit"									Type="1"	StringEnumValues="PrimaryDosimeterUnit"
	Sequence="TreatmentSessionBeamSequence"						Type="1"	VM="1-n"
		Name="ReferencedBeamNumber"								Type="3"
		Name="BeamName"											Type="3"
		Name="BeamDescription"									Type="3"
		Name="BeamType"											Type="1"	StringEnumValues="BeamType"
		Name="RadiationType"									Type="1"	StringDefinedTerms="RadiationType"
		Sequence="PrimaryFluenceModeSequence"					Type="3"	VM="1"
			Name="FluenceMode"									Type="1"	StringEnumValues="FluenceMode"
			Name="FluenceModeID"								Type="1C"	Condition="FluenceModeIsNonStandard"
		SequenceEnd
		Name="HighDoseTechniqueType"							Type="1C"	StringDefinedTerms="HighDoseTechniqueType"	NoCondition="" #real-world
		Sequence="ReferencedVerificationImageSequence"			Type="3"	VM="1-n"
			InvokeMacro="SOPInstanceReferenceMacro"
			Name="StartMeterset"								Type="3"
			Name="EndMeterset"									Type="3"
		SequenceEnd
		Sequence="ReferencedMeasuredDoseReferenceSequence"		Type="3"	VM="1-n"
			Name="ReferencedDoseReferenceNumber"				Type="1C"	Condition="ReferencedMeasuredDoseReferenceNumberNotPresent"
			Name="ReferencedMeasuredDoseReferenceNumber"		Type="1C"	Condition="ReferencedDoseReferenceNumberNotPresent"
			Name="MeasuredDoseValue"							Type="1"
		SequenceEnd
		Sequence="ReferencedCalculatedDoseReferenceSequence"	Type="3"	VM="1-n"
			Name="ReferencedDoseReferenceNumber"				Type="1C"	Condition="ReferencedCalculatedDoseReferenceNumberNotPresent"
			Name="ReferencedCalculatedDoseReferenceNumber"		Type="1C"	Condition="ReferencedDoseReferenceNumberNotPresent"
			Name="CalculatedDoseReferenceDoseValue"				Type="1"
		SequenceEnd
		Name="SourceAxisDistance"								Type="3"
		Sequence="BeamLimitingDeviceLeafPairsSequence"			Type="1"	VM="1-n"
			Name="RTBeamLimitingDeviceType"						Type="1"	StringEnumValues="RTBeamLimitingDeviceType"
			Name="NumberOfLeafJawPairs"							Type="1"
		SequenceEnd
		Name="ReferencedPatientSetupNumber"						Type="3"
		Name="NumberOfWedges"									Type="1"
		Sequence="RecordedWedgeSequence"						Type="1C"	VM="1-n"	Condition="NumberOfWedgesNotZero"
			Name="WedgeNumber"									Type="3"
			Name="WedgeType"									Type="2"	StringDefinedTerms="WedgeType"
			Name="WedgeID"										Type="3"
			Name="AccessoryCode"								Type="3"
			Name="WedgeAngle"									Type="3"
			Name="WedgeOrientation"								Type="3"
		SequenceEnd
		Name="NumberOfCompensators"								Type="2"
		Sequence="RecordedCompensatorSequence"					Type="3"	VM="1-n"
			Name="ReferencedCompensatorNumber"					Type="1"
			Name="CompensatorType"								Type="2"	StringDefinedTerms="CompensatorType"
			Name="CompensatorID"								Type="3"
			Name="AccessoryCode"								Type="3"
			Name="CompensatorTrayID"							Type="3"
			Name="TrayAccessoryCode"							Type="3"
		SequenceEnd
		Name="NumberOfBoli"										Type="2"
		Sequence="ReferencedBolusSequence"						Type="3"	VM="1-n"
			Name="ReferencedROINumber"							Type="1"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Name="NumberOfBlocks"									Type="2"	
		Sequence="RecordedBlockSequence"						Type="3"	VM="1-n"
			Name="BlockTrayID"									Type="3"
			Name="TrayAccessoryCode"							Type="3"
			Name="AccessoryCode"								Type="3"
			Name="ReferencedBlockNumber"						Type="3"
			Name="BlockName"									Type="2"
		SequenceEnd
		Sequence="ApplicatorSequence"							Type="3"	VM="1"
			Name="ApplicatorID"									Type="1"
			Name="AccessoryCode"								Type="3"
			Name="ApplicatorType"								Type="1"	StringDefinedTerms="ApplicatorType"
			Name="ApplicatorDescription"						Type="3"
			Sequence="GeneralAccessorySequence"					Type="3"	VM="1-n"
				Name="GeneralAccessoryNumber"					Type="1"
				Name="GeneralAccessoryID"						Type="1"
				Name="GeneralAccessoryDescription"				Type="3"
				Name="GeneralAccessoryType"						Type="3"	StringDefinedTerms="RTGeneralAccessoryType"
				Name="AccessoryCode"							Type="3"
				Name="SourceToGeneralAccessoryDistance"			Type="3"
			SequenceEnd
		SequenceEnd
		Name="CurrentFractionNumber"							Type="2"
		Name="TreatmentDeliveryType"							Type="2"	StringDefinedTerms="TreatmentDeliveryType"
		Name="TreatmentTerminationStatus"						Type="1"	StringEnumValues="TreatmentTerminationStatus"
		Name="TreatmentTerminationCode"							Type="3"
		Name="TreatmentVerificationStatus"						Type="2"	StringEnumValues="TreatmentVerificationStatus"
		Name="SpecifiedPrimaryMeterset"							Type="3"
		Name="SpecifiedSecondaryMeterset"						Type="3"
		Name="DeliveredPrimaryMeterset"							Type="3"
		Name="DeliveredSecondaryMeterset"						Type="3"
		Name="SpecifiedTreatmentTime"							Type="3"
		Name="DeliveredTreatmentTime"							Type="3"
		Name="NumberOfControlPoints"							Type="1"
		Sequence="ControlPointDeliverySequence"					Type="1"	VM="1-n"
			Name="ReferencedControlPointIndex"					Type="3"
			Name="TreatmentControlPointDate"					Type="1"
			Name="TreatmentControlPointTime"					Type="1"
			Name="SpecifiedMeterset"							Type="2"
			Name="DeliveredMeterset"							Type="1"
			Name="DoseRateSet"									Type="2"
			Name="DoseRateDelivered"							Type="2"
			Name="NominalBeamEnergy"							Type="3"
			Name="NominalBeamEnergyUnit"						Type="1C"	Condition="NominalBeamEnergyIsPresent"	StringDefinedTerms="NominalBeamEnergyUnit"
			Sequence="WedgePositionSequence"					Type="3"	VM="1-n"
				Name="ReferencedWedgeNumber"					Type="1"
				Name="WedgePosition"							Type="1"	StringEnumValues="WedgePosition"
			SequenceEnd
			Sequence="BeamLimitingDevicePositionSequence"		Type="1C"	VM="1-n"	NoCondition="" # too hard :(
				Name="RTBeamLimitingDeviceType"					Type="1"	StringEnumValues="RTBeamLimitingDeviceType"
				Name="LeafJawPositions"							Type="1"
			SequenceEnd
			Name="GantryAngle"									Type="1C"	NoCondition="" # too hard :(
			Name="GantryRotationDirection"						Type="1C"	StringEnumValues="RotationDirectionWithNone"	NoCondition="" # too hard :(
			Name="GantryPitchAngle"								Type="3"
			Name="GantryPitchRotationDirection"					Type="3"	StringEnumValues="RotationDirectionWithNone"
			Name="BeamStopperPosition"							Type="3"	StringEnumValues="BeamStopperPosition"
			Name="BeamLimitingDeviceAngle"						Type="1C"	NoCondition="" # too hard :(
			Name="BeamLimitingDeviceRotationDirection"			Type="1C"	NoCondition="" # too hard :(
			Name="PatientSupportAngle"							Type="1C"	NoCondition="" # too hard :(
			Name="PatientSupportRotationDirection"				Type="1C"	StringEnumValues="RotationDirectionWithNone"	NoCondition="" # too hard :(
			Name="TableTopEccentricAxisDistance"				Type="3"
			Name="TableTopEccentricAngle"						Type="1C"	NoCondition="" # too hard :(
			Name="TableTopEccentricRotationDirection"			Type="1C"	StringEnumValues="RotationDirectionWithNone"	NoCondition="" # too hard :(
			Name="TableTopPitchAngle"							Type="1C"	NoCondition="" # too hard :(
			Name="TableTopPitchRotationDirection"				Type="1C""	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="TableTopRollAngle"							Type="1C"	NoCondition="" # too hard :(
			Name="TableTopRollRotationDirection"				Type="1C""	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="TableTopVerticalPosition"						Type="2C"	NoCondition="" # too hard :(
			Name="TableTopLongitudinalPosition"					Type="2C"	NoCondition="" # too hard :(
			Name="TableTopLateralPosition"						Type="2C"	NoCondition="" # too hard :(
			Sequence="CorrectedParameterSequence"				Type="3"	VM="1-n"
				Name="ParameterSequencePointer"					Type="1"
				Name="ParameterItemIndex"						Type="1"
				Name="ParameterPointer"							Type="1"
				Name="CorrectionValue"							Type="1"
			SequenceEnd
			Sequence="OverrideSequence"							Type="3"	VM="1-n"
				Name="OverrideParameterPointer"					Type="2"
				Name="ParameterSequencePointer"					Type="3"
				Name="ParameterItemIndex"						Type="3"
				Name="ParameterValueNumber"						Type="3"
				Name="OperatorsName"							Type="2"
				Sequence="OperatorIdentificationSequence"		Type="3"	VM="1"
					InvokeMacro="PersonIdentificationMacro"
				SequenceEnd
				Name="OverrideReason"							Type="3"
			SequenceEnd
		SequenceEnd
	SequenceEnd
ModuleEnd

Module="RTBrachySessionRecord"
	Name="ReferencedFractionGroupNumber"						Type="3"
	Name="NumberOfFractionsPlanned"								Type="2"
	Name="BrachyTreatmentTechnique"								Type="1"	StringEnumValues="BrachyTreatmentTechnique"
	Name="BrachyTreatmentType"									Type="1"	StringDefinedTerms="BrachyTreatmentType"
	Sequence="RecordedSourceSequence"							Type="1"	VM="1-n"
		Name="SourceNumber"										Type="1"
		Name="SourceType"										Type="1"	StringDefinedTerms="SourceType"
		Name="SourceManufacturer"								Type="2"
		Name="SourceSerialNumber"								Type="2"
		Name="SourceIsotopeName"								Type="1"
		Name="SourceIsotopeHalfLife"							Type="1"
		Name="SourceStrengthUnits"								Type="1C"	Condition="SourceIsNotGammaEmitter"	StringEnumValues="SourceStrengthUnits" mbpo="true"
		Name="ReferenceAirKermaRate"							Type="1"
		Name="SourceStrength"									Type="1C"	Condition="SourceIsNotGammaEmitter"
		Name="SourceStrengthReferenceDate"						Type="1"
		Name="SourceStrengthReferenceTime"						Type="1"
	SequenceEnd
	Sequence="TreatmentSessionApplicationSetupSequence"			Type="1"	VM="1-n"
		Name="ApplicationSetupType"								Type="1"	StringDefinedTerms="ApplicationSetupType"
		Name="ReferencedBrachyApplicationSetupNumber"			Type="3"
		Name="ApplicationSetupName"								Type="3"
		Name="ApplicationSetupManufacturer"						Type="3"
		Name="TemplateNumber"									Type="3"
		Name="TemplateType"										Type="3"
		Name="TemplateName"										Type="3"
		Name="ApplicationSetupCheck"							Type="3"	StringEnumValues="ApplicationSetupCheck"
		Sequence="ReferencedVerificationImageSequence"			Type="3"	VM="1-n"
			InvokeMacro="SOPInstanceReferenceMacro"
		SequenceEnd
		Name="TotalReferenceAirKerma"							Type="1"
		Sequence="ReferencedMeasuredDoseReferenceSequence"		Type="3"	VM="1-n"
			Name="ReferencedDoseReferenceNumber"				Type="1C"	Condition="ReferencedMeasuredDoseReferenceNumberNotPresent"
			Name="ReferencedMeasuredDoseReferenceNumber"		Type="1C"	Condition="ReferencedDoseReferenceNumberNotPresent"
			Name="MeasuredDoseValue"							Type="1"
		SequenceEnd
		Sequence="ReferencedCalculatedDoseReferenceSequence"	Type="3"	VM="1-n"
			Name="ReferencedDoseReferenceNumber"				Type="1C"	Condition="ReferencedCalculatedDoseReferenceNumberNotPresent"
			Name="ReferencedCalculatedDoseReferenceNumber"		Type="1C"	Condition="ReferencedDoseReferenceNumberNotPresent"
			Name="CalculatedDoseReferenceDoseValue"				Type="1"
		SequenceEnd
		Name="CurrentFractionNumber"							Type="2"
		Name="TreatmentDeliveryType"							Type="2"	StringDefinedTerms="TreatmentDeliveryTypeNormalOrContinuation"
		Name="TreatmentTerminationStatus"						Type="1"	StringEnumValues="TreatmentTerminationStatus"
		Name="TreatmentTerminationCode"							Type="3"
		Name="TreatmentVerificationStatus"						Type="2"	StringEnumValues="TreatmentVerificationStatus"
		Sequence="RecordedBrachyAccessoryDeviceSequence"		Type="3"	VM="1-n"
			Name="ReferencedBrachyAccessoryDeviceNumber"		Type="2"
			Name="BrachyAccessoryDeviceID"						Type="2"
			Name="BrachyAccessoryDeviceType"					Type="1"	StringDefinedTerms="BrachyAccessoryDeviceType"
			Name="BrachyAccessoryDeviceName"					Type="3"
		SequenceEnd
		Sequence="RecordedChannelSequence"						Type="1"	VM="1-n"
			Name="ChannelNumber"								Type="1"
			Name="ChannelLength"								Type="2"
			Name="SpecifiedChannelTotalTime"					Type="1"
			Name="DeliveredChannelTotalTime"					Type="1"
			Name="SourceMovementType"							Type="1"	StringDefinedTerms="SourceMovementType"
			Name="SpecifiedNumberOfPulses"						Type="1C"	Condition="BrachyTreatmentTypeIsPDR"
			Name="DeliveredNumberOfPulses"						Type="1C"	Condition="BrachyTreatmentTypeIsPDR"
			Name="SpecifiedPulseRepetitionInterval"				Type="1C"	Condition="BrachyTreatmentTypeIsPDR"
			Name="DeliveredPulseRepetitionInterval"				Type="1C"	Condition="BrachyTreatmentTypeIsPDR"
			Sequence="ReferencedMeasuredDoseReferenceSequence"	Type="3"	VM="1-n"
				Name="ReferencedDoseReferenceNumber"			Type="1C"	Condition="ReferencedMeasuredDoseReferenceNumberNotPresent"
				Name="ReferencedMeasuredDoseReferenceNumber"	Type="1C"	Condition="ReferencedDoseReferenceNumberNotPresent"
				Name="MeasuredDoseValue"						Type="1"
			SequenceEnd
			Sequence="ReferencedCalculatedDoseReferenceSequence"	Type="3"	VM="1-n"
				Name="ReferencedDoseReferenceNumber"			Type="1C"	Condition="ReferencedCalculatedDoseReferenceNumberNotPresent"
				Name="ReferencedCalculatedDoseReferenceNumber"	Type="1C"	Condition="ReferencedDoseReferenceNumberNotPresent"
				Name="CalculatedDoseReferenceDoseValue"			Type="1"
			SequenceEnd
			Sequence="RecordedSourceApplicatorSequence"			Type="3"	VM="1-n"
				Name="ReferencedSourceApplicatorNumber"			Type="2"
				Name="SourceApplicatorID"						Type="2"
				Name="SourceApplicatorType"						Type="1"	StringDefinedTerms="SourceApplicatorType"
				Name="SourceApplicatorName"						Type="3"
				Name="SourceApplicatorLength"					Type="1"
				Name="SourceApplicatorManufacturer"				Type="3"
				Name="SourceApplicatorStepSize"					Type="1C"	NoCondition="" # need StringValueAbove SourceMovementType Stepwise :(
			SequenceEnd
			Name="TransferTubeNumber"							Type="2"
			Name="TransferTubeLength"							Type="2C"	Condition="TransferTubeNumberIsNotEmpty"
			Sequence="RecordedChannelShieldSequence"			Type="3"	VM="1-n"
				Name="ReferencedChannelShieldNumber"			Type="2"
				Name="ChannelShieldID"							Type="2"
				Name="ChannelShieldName"						Type="3"
			SequenceEnd
			Name="ReferencedSourceNumber"						Type="1"
			Name="SafePositionExitDate"							Type="1C"	NoCondition="" # Need StringValueAbove BrachyTreatmentType Not Manual :(
			Name="SafePositionExitTime"							Type="1C"	NoCondition="" # Need StringValueAbove BrachyTreatmentType Not Manual :(
			Name="SafePositionReturnDate"						Type="1C"	NoCondition="" # Need StringValueAbove BrachyTreatmentType Not Manual :(
			Name="SafePositionReturnTime"						Type="1C"	NoCondition="" # Need StringValueAbove BrachyTreatmentType Not Manual :(
			Name="NumberOfControlPoints"						Type="1"
			Sequence="BrachyControlPointDeliveredSequence"		Type="1"	VM="2-n"
				Name="ReferencedControlPointIndex"				Type="3"
				Name="TreatmentControlPointDate"				Type="1"
				Name="TreatmentControlPointTime"				Type="1"
				Name="ControlPointRelativePosition"				Type="1"
				Sequence="OverrideSequence"						Type="3"	VM="1-n"
					Name="OverrideParameterPointer"				Type="2"
					Name="OperatorsName"						Type="2"
					Sequence="OperatorIdentificationSequence"	Type="3"	VM="1"
						InvokeMacro="PersonIdentificationMacro"
					SequenceEnd
					Name="OverrideReason"						Type="3"
				SequenceEnd
			SequenceEnd
		SequenceEnd
	SequenceEnd
ModuleEnd

Module="RTTreatmentSummaryRecord"
	Name="CurrentTreatmentStatus"								Type="1"	StringEnumValues="CurrentTreatmentStatus"
	Name="TreatmentStatusComment"								Type="3"
	Name="FirstTreatmentDate"									Type="2"
	Name="MostRecentTreatmentDate"								Type="2"
	Sequence="FractionGroupSummarySequence"						Type="3"	VM="1-n"
		Name="ReferencedFractionGroupNumber"					Type="3"
		Name="FractionGroupType"								Type="2"	StringEnumValues="FractionGroupType"
		Name="NumberOfFractionsPlanned"							Type="2"
		Name="NumberOfFractionsDelivered"						Type="2"
		Sequence="FractionStatusSummarySequence"				Type="3"	VM="1-n"
			Name="ReferencedFractionNumber"						Type="1"
			Name="TreatmentDate"								Type="2"
			Name="TreatmentTime"								Type="2"
			Name="TreatmentTerminationStatus"					Type="2"	StringEnumValues="TreatmentTerminationStatus"
		SequenceEnd
	SequenceEnd
	Sequence="TreatmentSummaryMeasuredDoseReferenceSequence"	Type="3"	VM="1-n"
		Name="ReferencedDoseReferenceNumber"					Type="3"
		Name="DoseReferenceDescription"							Type="3"
		Name="CumulativeDoseToDoseReference"					Type="1"
	SequenceEnd
	Sequence="TreatmentSummaryCalculatedDoseReferenceSequence"	Type="3"	VM="1-n"
		Name="ReferencedDoseReferenceNumber"					Type="3"
		Name="DoseReferenceDescription"							Type="3"
		Name="CumulativeDoseToDoseReference"					Type="1"
	SequenceEnd
ModuleEnd

Module="RTIonToleranceTables"
	Sequence="IonToleranceTableSequence"						Type="3"	VM="1-n"
		Name="ToleranceTableNumber"								Type="1"
		Name="ToleranceTableLabel"								Type="3"
		Name="GantryAngleTolerance"								Type="3"
		Name="BeamLimitingDeviceAngleTolerance"					Type="3"
		Sequence="BeamLimitingDeviceToleranceSequence"			Type="3"	VM="1-n"
			Name="RTBeamLimitingDeviceType"						Type="1"	StringEnumValues="RTBeamLimitingDeviceType"
			Name="BeamLimitingDevicePositionTolerance"			Type="1"
		SequenceEnd
		Name="PatientSupportAngleTolerance"						Type="3"
		Name="TableTopVerticalPositionTolerance"				Type="3"
		Name="TableTopLongitudinalPositionTolerance"			Type="3"
		Name="TableTopLateralPositionTolerance"					Type="3"
		Name="TableTopPitchAngleTolerance"						Type="3"
		Name="TableTopRollAngleTolerance"						Type="3"
		Name="SnoutPositionTolerance"							Type="3"
	SequenceEnd
ModuleEnd

Module="RTIonBeams"
	Sequence="IonBeamSequence"									Type="1"	VM="1-n"
		Name="BeamNumber"										Type="1"
		Name="BeamName"											Type="1"
		Name="BeamDescription"									Type="3"
		Name="BeamType"											Type="1"	StringEnumValues="BeamType"
		Name="RadiationType"									Type="1"	StringDefinedTerms="IonRadiationType"
		Name="RadiationMassNumber"								Type="1C"	Condition="RadiationTypeIsIon"
		Name="RadiationAtomicNumber"							Type="1C"	Condition="RadiationTypeIsIon"
		Name="RadiationChargeState"								Type="1C"	Condition="RadiationTypeIsIon"
		Name="ScanMode"											Type="1"	StringDefinedTerms="IonScanMode"
		Name="ModulatedScanModeType"							Type="1C"	Condition="ScanModeIsModulatedSpec"	StringDefinedTerms="ModulatedScanModeType"
		Name="TreatmentMachineName"								Type="2"
		Name="Manufacturer"										Type="3"
		Name="InstitutionName"									Type="3"
		Name="InstitutionAddress"								Type="3"
		Name="InstitutionalDepartmentName"						Type="3"
		Name="ManufacturerModelName"							Type="3"
		Name="DeviceSerialNumber"								Type="3"
		Name="PrimaryDosimeterUnit"								Type="3"	StringEnumValues="IonPrimaryDosimeterUnit"
		Name="ReferencedToleranceTableNumber"					Type="3"
		Name="VirtualSourceAxisDistances"						Type="1"
		Sequence="IonBeamLimitingDeviceSequence"				Type="3"	VM="1-n"
			Name="RTBeamLimitingDeviceType"						Type="1"	StringEnumValues="RTBeamLimitingDeviceType"
			Name="IsocenterToBeamLimitingDeviceDistance"		Type="2"
			Name="NumberOfLeafJawPairs"							Type="1"
			Name="LeafPositionBoundaries"						Type="1C"	Condition="RTBeamLimitingDeviceTypeMLCXOrMLCY" mbpo="true"
		SequenceEnd
		Name="ReferencedPatientSetupNumber"						Type="3"
		Sequence="ReferencedReferenceImageSequence"				Type="3"	VM="1-n"
			InvokeMacro="SOPInstanceReferenceMacro"
			Name="ReferenceImageNumber"							Type="1"
		SequenceEnd
		Name="TreatmentDeliveryType"							Type="1"	StringDefinedTerms="TreatmentDeliveryType"
		Sequence="ReferencedDoseSequence"						Type="3"	VM="1-n"
			# SOPInstanceReferenceMacro, but want to check SOPClassUID
			Name="ReferencedSOPClassUID"						Type="1"	StringEnumValues="RTDoseSOPClass"
			Name="ReferencedSOPInstanceUID"						Type="1"
		SequenceEnd
		Name="NumberOfWedges"									Type="1"
		Name="TotalWedgeTrayWaterEquivalentThickness"			Type="3"
		Sequence="IonWedgeSequence"								Type="1C"	VM="1-n"	Condition="NumberOfWedgesNotZero"
			Name="WedgeNumber"									Type="1"
			Name="WedgeType"									Type="2"	StringDefinedTerms="IonWedgeType"
			Name="WedgeID"										Type="3"
			Name="AccessoryCode"								Type="3"
			Name="WedgeAngle"									Type="2"
			Name="WedgeOrientation"								Type="2"
			Name="IsocenterToWedgeTrayDistance"					Type="1"
		SequenceEnd
		Name="NumberOfCompensators"								Type="1"
		Name="TotalCompensatorTrayWaterEquivalentThickness"		Type="3"
		Sequence="IonRangeCompensatorSequence"					Type="1C"	VM="1-n"	Condition="NumberOfCompensatorsNotZero"
			Name="CompensatorDescription"						Type="3"
			Name="CompensatorNumber"							Type="1"
			Name="MaterialID"									Type="2"
			Name="CompensatorID"								Type="3"
			Name="AccessoryCode"								Type="3"
			Name="IsocenterToCompensatorTrayDistance"			Type="1C"	Condition="CompensatorMountingPositionNotDoubleSided"
			Name="CompensatorDivergence"						Type="1"	StringEnumValues="CompensatorDivergence"
			Name="CompensatorMountingPosition"					Type="1"	StringEnumValues="CompensatorMountingPosition"
			Name="CompensatorRows"								Type="1"
			Name="CompensatorColumns"							Type="1"
			Name="CompensatorPixelSpacing"						Type="1"
			Name="CompensatorPosition"							Type="1"
			Name="CompensatorColumnOffset"						Type="1C"	NoCondition=""	# if compensator pattern is hexagonal
			Name="CompensatorThicknessData"						Type="1"
			Name="IsocenterToCompensatorDistances"				Type="1C"	Condition="NeedIsocenterToCompensatorDistance"
			Name="CompensatorRelativeStoppingPowerRatio"		Type="3"
			Name="CompensatorMillingToolDiameter"				Type="3"
		SequenceEnd
		Name="NumberOfBoli"										Type="1"
		Sequence="ReferencedBolusSequence"						Type="1C"	VM="1-n"	Condition="NumberOfBoliNotZero"
			Name="ReferencedROINumber"							Type="1"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Name="NumberOfBlocks"									Type="1"
		Name="TotalBlockTrayWaterEquivalentThickness"			Type="3"
		Sequence="IonBlockSequence"								Type="1C"	VM="1-n"	Condition="NumberOfBlocksNotZero"
			Name="BlockTrayID"									Type="3"
			Name="AccessoryCode"								Type="3"
			Name="IsocenterToBlockTrayDistance"					Type="1"
			Name="BlockType"									Type="1"	StringEnumValues="BlockType"
			Name="BlockDivergence"								Type="1"	StringEnumValues="BlockDivergence"
			Name="BlockMountingPosition"						Type="1"	StringEnumValues="BlockMountingPosition"
			Name="BlockNumber"									Type="1"
			Name="BlockName"									Type="3"
			Name="MaterialID"									Type="2"
			Name="BlockThickness"								Type="1"
			Name="BlockNumberOfPoints"							Type="1"
			Name="BlockData"									Type="1"
		SequenceEnd
		Sequence="SnoutSequence"								Type="3"	VM="1"
			Name="SnoutID"										Type="1"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Sequence="ApplicatorSequence"							Type="3"	VM="1"
			Name="ApplicatorID"									Type="1"
			Name="AccessoryCode"								Type="3"
			Name="ApplicatorType"								Type="1"	StringDefinedTerms="IonApplicatorType"
			Name="ApplicatorDescription"						Type="3"
			Sequence="GeneralAccessorySequence"					Type="3"	VM="1-n"
				Name="GeneralAccessoryNumber"					Type="1"
				Name="GeneralAccessoryID"						Type="1"
				Name="GeneralAccessoryDescription"				Type="3"
				Name="GeneralAccessoryType"						Type="3"	StringDefinedTerms="RTGeneralAccessoryType"
				Name="AccessoryCode"							Type="3"
				Name="SourceToGeneralAccessoryDistance"			Type="3"
			SequenceEnd
		SequenceEnd
		Name="NumberOfRangeShifters"							Type="1"
		Sequence="RangeShifterSequence"							Type="1C"	VM="1-n"	Condition="NumberOfRangeShiftersNotZero"
			Name="RangeShifterNumber"							Type="1"
			Name="RangeShifterID"								Type="1"
			Name="AccessoryCode"								Type="3"
			Name="RangeShifterType"								Type="1"	StringDefinedTerms="RangeShifterType"
			Name="RangeShifterDescription"						Type="3"
		SequenceEnd
		Name="NumberOfLateralSpreadingDevices"					Type="1"
		Sequence="LateralSpreadingDeviceSequence"				Type="1C"	VM="1-n"	Condition="NumberOfLateralSpreadingDevicesNotZero"
			Name="LateralSpreadingDeviceNumber"					Type="1"
			Name="LateralSpreadingDeviceID"						Type="1"
			Name="AccessoryCode"								Type="3"
			Name="LateralSpreadingDeviceType"					Type="1"	StringDefinedTerms="LateralSpreadingDeviceType"
			Name="LateralSpreadingDeviceDescription"			Type="3"
		SequenceEnd
		Name="NumberOfRangeModulators"							Type="1"
		Sequence="RangeModulatorSequence"						Type="1C"	VM="1-n"	Condition="NumberOfRangeModulatorsNotZero"
			Name="RangeModulatorNumber"							Type="1"
			Name="RangeModulatorID"								Type="1"
			Name="AccessoryCode"								Type="3"
			Name="RangeModulatorType"							Type="1"	StringDefinedTerms="RangeModulatorType"
			Name="RangeModulatorDescription"					Type="3"
			Name="BeamCurrentModulationID"						Type="1C"	Condition="RangeModulatorTypeIsWhlModWeights"
		SequenceEnd
		InvokeMacro="PatientSupportIdentificationMacro"
		Name="FixationLightAzimuthalAngle"						Type="3"
		Name="FixationLightPolarAngle"							Type="3"
		Name="FinalCumulativeMetersetWeight"					Type="1C"	NoCondition=""
		Name="NumberOfControlPoints"							Type="1"
		Sequence="IonControlPointSequence"						Type="1"	VM="2-n"
			Name="ControlPointIndex"							Type="1"
			Name="CumulativeMetersetWeight"						Type="2"
			Sequence="ReferencedDoseReferenceSequence"			Type="3"	VM="1-n"
				Name="ReferencedDoseReferenceNumber"			Type="1"
				Name="CumulativeDoseReferenceCoefficient"		Type="2"
			SequenceEnd
			Name="NominalBeamEnergy"							Type="1C"	NoCondition=""
			Name="KVP"											Type="1C"	NoCondition=""
			Name="MetersetRate"									Type="3"
			Sequence="IonWedgePositionSequence"					Type="1C"	VM="1-n"	NoCondition=""
				Name="ReferencedWedgeNumber"					Type="1"
				Name="WedgePosition"							Type="1"	StringEnumValues="WedgePosition"
				Name="WedgeThinEdgePosition"					Type="1C"	NoCondition=""
			SequenceEnd
			Sequence="RangeShifterSettingsSequence"				Type="1C"	VM="1-n"	NoCondition=""
				Name="ReferencedRangeShifterNumber"				Type="1"
				Name="RangeShifterSetting"						Type="1"
				Name="IsocenterToRangeShifterDistance"			Type="3"
				Name="RangeShifterWaterEquivalentThickness"		Type="3"
			SequenceEnd
			Sequence="LateralSpreadingDeviceSettingsSequence"			Type="1C"	VM="1-n"	NoCondition=""
				Name="ReferencedLateralSpreadingDeviceNumber"			Type="1"
				Name="LateralSpreadingDeviceSetting"					Type="1"
				Name="IsocenterToLateralSpreadingDeviceDistance"		Type="3"
				Name="LateralSpreadingDeviceWaterEquivalentThickness"	Type="3"
			SequenceEnd
			Sequence="RangeModulatorSettingsSequence"						Type="1C"	VM="1-n"	NoCondition=""
				Name="ReferencedRangeModulatorNumber"						Type="1"
				Name="RangeModulatorGatingStartValue"						Type="1C"	NoCondition=""
				Name="RangeModulatorGatingStopValue"						Type="1C"	NoCondition=""
				Name="RangeModulatorGatingStartWaterEquivalentThickness"	Type="3"
				Name="RangeModulatorGatingStopWaterEquivalentThickness"		Type="3"
			SequenceEnd
			InvokeMacro="BeamLimitingDevicePositionMacro"
			Name="GantryAngle"									Type="1C"	NoCondition=""
			Name="GantryRotationDirection"						Type="1C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="GantryPitchAngle"								Type="3"
			Name="GantryPitchRotationDirection"					Type="3"	StringEnumValues="RotationDirectionWithNone"
			Name="BeamLimitingDeviceAngle"						Type="1C"	NoCondition=""
			Name="BeamLimitingDeviceRotationDirection"			Type="1C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="ScanSpotPositionMap"							Type="1C"	Condition="ScanModeAboveIsModulatedOrModulatedSpec"
			Name="ScanSpotMetersetWeights"						Type="1C"	Condition="ScanModeAboveIsModulatedOrModulatedSpec"
			Name="ScanningSpotSize"								Type="3"
			Name="NumberOfPaintings"							Type="1C"	Condition="ScanModeAboveIsModulatedOrModulatedSpec"
			Name="PatientSupportAngle"							Type="1C"	NoCondition=""
			Name="PatientSupportRotationDirection"				Type="1C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="TableTopPitchAngle"							Type="2C"	NoCondition=""
			Name="TableTopPitchRotationDirection"				Type="2C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="TableTopRollAngle"							Type="2C"	NoCondition=""
			Name="TableTopRollRotationDirection"				Type="2C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="HeadFixationAngle"							Type="3"
			Name="TableTopVerticalPosition"						Type="2C"	NoCondition=""
			Name="TableTopLongitudinalPosition"					Type="2C"	NoCondition=""
			Name="TableTopLateralPosition"						Type="2C"	NoCondition=""
			Name="SnoutPosition"								Type="2C"	NoCondition=""
			Name="IsocenterPosition"							Type="2C"	NoCondition=""
			Name="SurfaceEntryPoint"							Type="3"
		SequenceEnd
	SequenceEnd
ModuleEnd

Module="RTIonBeamsSessionRecord"
	Name="ReferencedFractionGroupNumber"						Type="3"
	Name="NumberOfFractionsPlanned"								Type="2"
	Name="PrimaryDosimeterUnit"									Type="1"	StringEnumValues="IonPrimaryDosimeterUnit"
	Sequence="TreatmentSessionIonBeamSequence"					Type="1"	VM="1-n"
		Name="ReferencedBeamNumber"								Type="1"
		Name="BeamName"											Type="1"
		Name="BeamDescription"									Type="3"
		Name="BeamType"											Type="1"	StringEnumValues="BeamType"
		Name="RadiationType"									Type="1"	StringDefinedTerms="IonRadiationType"
		Name="RadiationMassNumber"								Type="1C"	Condition="RadiationTypeIsIon"
		Name="RadiationAtomicNumber"							Type="1C"	Condition="RadiationTypeIsIon"
		Name="RadiationChargeState"								Type="1C"	Condition="RadiationTypeIsIon"
		Name="ScanMode"											Type="1"	StringDefinedTerms="IonScanMode"
		Name="ModulatedScanModeType"							Type="1C"	Condition="ScanModeIsModulatedSpec"	StringDefinedTerms="ModulatedScanModeType"
		Name="ReferencedToleranceTableNumber"					Type="3"
		Sequence="BeamLimitingDeviceLeafPairsSequence"			Type="3"	VM="1-n"
			Name="RTBeamLimitingDeviceType"						Type="1"	StringEnumValues="RTBeamLimitingDeviceType"
			Name="NumberOfLeafJawPairs"							Type="1"
		SequenceEnd
		Name="ReferencedPatientSetupNumber"						Type="3"
		Sequence="ReferencedVerificationImageSequence"			Type="3"	VM="1-n"
			InvokeMacro="SOPInstanceReferenceMacro"
		SequenceEnd
		Sequence="ReferencedMeasuredDoseReferenceSequence"		Type="3"	VM="1-n"
			Name="ReferencedDoseReferenceNumber"				Type="1C"	Condition="ReferencedMeasuredDoseReferenceNumberNotPresent"
			Name="ReferencedMeasuredDoseReferenceNumber"		Type="1C"	Condition="ReferencedDoseReferenceNumberNotPresent"
			Name="MeasuredDoseValue"							Type="1"
		SequenceEnd
		Sequence="ReferencedCalculatedDoseReferenceSequence"	Type="3"	VM="1-n"
			Name="ReferencedDoseReferenceNumber"				Type="1C"	Condition="ReferencedCalculatedDoseReferenceNumberNotPresent"
			Name="ReferencedCalculatedDoseReferenceNumber"		Type="1C"	Condition="ReferencedDoseReferenceNumberNotPresent"
			Name="CalculatedDoseReferenceDoseValue"				Type="1"
		SequenceEnd
		Name="NumberOfWedges"									Type="1"
		Sequence="RecordedWedgeSequence"						Type="1C"	VM="1-n"	Condition="NumberOfWedgesNotZero"
			Name="WedgeNumber"									Type="1"
			Name="WedgeType"									Type="2"	StringDefinedTerms="IonWedgeType"
			Name="WedgeID"										Type="3"
			Name="AccessoryCode"								Type="3"
			Name="WedgeAngle"									Type="3"
			Name="WedgeOrientation"								Type="3"
		SequenceEnd
		Name="NumberOfCompensators"								Type="1"
		Sequence="RecordedCompensatorSequence"					Type="1C"	VM="1-n"	Condition="NumberOfCompensatorsNotZero"
			Name="ReferencedCompensatorNumber"					Type="1"
			Name="CompensatorType"								Type="2"	StringDefinedTerms="CompensatorType"
			Name="CompensatorID"								Type="3"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Name="NumberOfBoli"										Type="1"
		Sequence="ReferencedBolusSequence"						Type="1C"	VM="1-n"	Condition="NumberOfBoliNotZero"
			Name="ReferencedROINumber"							Type="1"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Name="NumberOfBlocks"									Type="1"
		Sequence="RecordedBlockSequence"						Type="1C"	VM="1-n"	Condition="NumberOfBlocksNotZero"
			Name="BlockTrayID"									Type="3"
			Name="AccessoryCode"								Type="3"
			Name="ReferencedBlockNumber"						Type="1"
			Name="BlockName"									Type="2"
		SequenceEnd
		Sequence="RecordedSnoutSequence"						Type="1C"	VM="1"	NoCondition=""
			Name="SnoutID"										Type="1"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Sequence="ApplicatorSequence"							Type="1C"	VM="1"	NoCondition=""
			Name="ApplicatorID"									Type="1"
			Name="AccessoryCode"								Type="3"
			Name="ApplicatorType"								Type="1"	StringDefinedTerms="IonApplicatorType"
			Name="ApplicatorDescription"						Type="3"
			Sequence="GeneralAccessorySequence"					Type="3"	VM="1-n"
				Name="GeneralAccessoryNumber"					Type="1"
				Name="GeneralAccessoryID"						Type="1"
				Name="GeneralAccessoryDescription"				Type="3"
				Name="GeneralAccessoryType"						Type="3"	StringDefinedTerms="RTGeneralAccessoryType"
				Name="AccessoryCode"							Type="3"
				Name="SourceToGeneralAccessoryDistance"			Type="3"
			SequenceEnd
		SequenceEnd
		Name="NumberOfRangeShifters"							Type="1"
		Sequence="RecordedRangeShifterSequence"					Type="1C"	VM="1-n"	Condition="NumberOfRangeShiftersNotZero"
			Name="ReferencedRangeShifterNumber"					Type="1"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Name="NumberOfLateralSpreadingDevices"					Type="1"
		Sequence="RecordedLateralSpreadingDeviceSequence"		Type="1C"	VM="1-n"	Condition="NumberOfLateralSpreadingDevicesNotZero"
			Name="ReferencedLateralSpreadingDeviceNumber"		Type="1"
			Name="LateralSpreadingDeviceID"						Type="1"
			Name="AccessoryCode"								Type="3"
		SequenceEnd
		Name="NumberOfRangeModulators"							Type="1"
		Sequence="RecordedRangeModulatorSequence"				Type="1C"	VM="1-n"	Condition="NumberOfRangeModulatorsNotZero"
			Name="ReferencedRangeModulatorNumber"				Type="1"
			Name="RangeModulatorID"								Type="1"
			Name="AccessoryCode"								Type="3"
			Name="RangeModulatorType"							Type="1"	StringDefinedTerms="RangeModulatorType"
			Name="BeamCurrentModulationID"						Type="1C"	Condition="RangeModulatorTypeIsWhlModWeights"
		SequenceEnd
		InvokeMacro="PatientSupportIdentificationMacro"
		Name="FixationLightAzimuthalAngle"						Type="3"
		Name="FixationLightPolarAngle"							Type="3"
		Name="CurrentFractionNumber"							Type="2"
		Name="TreatmentDeliveryType"							Type="2"	StringDefinedTerms="TreatmentDeliveryType"
		Name="TreatmentTerminationStatus"						Type="1"	StringEnumValues="TreatmentTerminationStatus"
		Name="TreatmentTerminationCode"							Type="3"
		Name="TreatmentVerificationStatus"						Type="2"	StringEnumValues="TreatmentVerificationStatus"
		Name="SpecifiedPrimaryMeterset"							Type="3"
		Name="SpecifiedSecondaryMeterset"						Type="3"
		Name="DeliveredPrimaryMeterset"							Type="3"
		Name="DeliveredSecondaryMeterset"						Type="3"
		Name="SpecifiedTreatmentTime"							Type="3"
		Name="DeliveredTreatmentTime"							Type="3"
		Name="NumberOfControlPoints"							Type="1"
		Sequence="IonControlPointDeliverySequence"				Type="1"	VM="1-n"
			Name="ReferencedControlPointIndex"					Type="1"
			Name="TreatmentControlPointDate"					Type="1"
			Name="TreatmentControlPointTime"					Type="1"
			Name="SpecifiedMeterset"							Type="2"
			Name="DeliveredMeterset"							Type="1"
			Name="MetersetRateSet"								Type="3"
			Name="MetersetRateDelivered"						Type="3"
			Name="NominalBeamEnergy"							Type="1C"	NoCondition=""
			Name="KVP"											Type="1C"	NoCondition=""
			Sequence="IonWedgePositionSequence"					Type="1C"	VM="1-n"	NoCondition=""
				Name="ReferencedWedgeNumber"					Type="1"
				Name="WedgePosition"							Type="1"	StringEnumValues="WedgePosition"
				Name="WedgeThinEdgePosition"					Type="1C"	NoCondition=""
			SequenceEnd
			InvokeMacro="BeamLimitingDevicePositionMacro"
			Sequence="RangeShifterSettingsSequence"				Type="1C"	VM="1-n"	NoCondition=""
				Name="ReferencedRangeShifterNumber"				Type="1"
				Name="RangeShifterSetting"						Type="1"
			SequenceEnd
			Sequence="LateralSpreadingDeviceSettingsSequence"			Type="1C"	VM="1-n"	NoCondition=""
				Name="ReferencedLateralSpreadingDeviceNumber"			Type="1"
				Name="LateralSpreadingDeviceSetting"					Type="1"
			SequenceEnd
			Sequence="RangeModulatorSettingsSequence"						Type="1C"	VM="1-n"	NoCondition=""
				Name="ReferencedRangeModulatorNumber"						Type="1"
				Name="RangeModulatorGatingStartValue"						Type="1C"	NoCondition=""
				Name="RangeModulatorGatingStopValue"						Type="1C"	NoCondition=""
			SequenceEnd
			Name="GantryAngle"									Type="1C"	NoCondition=""
			Name="GantryRotationDirection"						Type="1C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="GantryPitchAngle"								Type="3"
			Name="GantryPitchRotationDirection"					Type="3"	StringEnumValues="RotationDirectionWithNone"
			Name="BeamLimitingDeviceAngle"						Type="1C"	NoCondition=""
			Name="BeamLimitingDeviceRotationDirection"			Type="1C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="ScanSpotTuneID"								Type="1C"	Condition="ScanModeAboveIsModulatedOrModulatedSpec"
			Name="NumberOfScanSpotPositions"					Type="1C"	Condition="ScanModeAboveIsModulatedOrModulatedSpec"
			Name="ScanSpotPositionMap"							Type="1C"	Condition="ScanModeAboveIsModulatedOrModulatedSpec"
			Name="ScanSpotMetersetsDelivered"					Type="1C"	Condition="ScanModeAboveIsModulatedOrModulatedSpec"
			Name="ScanSpotTimeOffset"							Type="3"
			Name="ScanningSpotSize"								Type="3"
			Name="NumberOfPaintings"							Type="1C"	Condition="ScanModeAboveIsModulatedOrModulatedSpec"
			Name="PatientSupportAngle"							Type="1C"	NoCondition=""
			Name="PatientSupportRotationDirection"				Type="1C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="TableTopPitchAngle"							Type="2C"	NoCondition=""
			Name="TableTopPitchRotationDirection"				Type="2C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="TableTopRollAngle"							Type="2C"	NoCondition=""
			Name="TableTopRollRotationDirection"				Type="2C"	NoCondition=""	StringEnumValues="RotationDirectionWithNone"
			Name="HeadFixationAngle"							Type="3"
			Name="TableTopVerticalPosition"						Type="2C"	NoCondition=""
			Name="TableTopLongitudinalPosition"					Type="2C"	NoCondition=""
			Name="TableTopLateralPosition"						Type="2C"	NoCondition=""
			Name="SnoutPosition"								Type="2C"	NoCondition=""
			Sequence="CorrectedParameterSequence"				Type="3"	VM="1-n"
				Name="ParameterSequencePointer"					Type="1"
				Name="ParameterItemIndex"						Type="1"
				Name="ParameterPointer"							Type="1"
				Name="CorrectionValue"							Type="1"
			SequenceEnd
			Sequence="OverrideSequence"							Type="3"	VM="1-n"
				Name="ParameterSequencePointer"					Type="1"
				Name="OverrideParameterPointer"					Type="1"
				Name="ParameterItemIndex"						Type="1"
				Name="ParameterValueNumber"						Type="3"
				Name="OperatorsName"							Type="2"
				Sequence="OperatorIdentificationSequence"		Type="3"	VM="1"
					InvokeMacro="PersonIdentificationMacro"
				SequenceEnd
				Name="OverrideReason"							Type="3"
			SequenceEnd
		SequenceEnd
	SequenceEnd
ModuleEnd
