/* Copyright (C) 2004 - 2006 db4objects Inc. http://www.db4o.com */

package com.db4odoc.servlets;

import com.db4o.Db4o;
import com.db4o.ObjectServer;
import javax.servlet.*;

public class Db4oServletContextListener implements ServletContextListener {
	public static final String KEY_DB4O_FILE_NAME = "db4oFileName";

	public static final String KEY_DB4O_SERVER = "db4oServer";

	private ObjectServer server = null;

	public void contextInitialized(ServletContextEvent event) {
		close();
		ServletContext context = event.getServletContext();
		String filePath = context.getRealPath("WEB-INF/db/"
				+ context.getInitParameter(KEY_DB4O_FILE_NAME));
		server = Db4o.openServer(filePath, 0);
		context.setAttribute(KEY_DB4O_SERVER, server);
		context.log("db4o startup on " + filePath);
	}

	public void contextDestroyed(ServletContextEvent event) {
		ServletContext context = event.getServletContext();
		context.removeAttribute(KEY_DB4O_SERVER);
		close();
		context.log("db4o shutdown");
	}

	private void close() {
		if (server != null) {
			server.close();
		}
		server = null;
	}
}
