info = {
    "name": "it",
    "date_order": "DMY",
    "january": [
        "gen",
        "gennaio"
    ],
    "february": [
        "feb",
        "febbraio"
    ],
    "march": [
        "mar",
        "marzo"
    ],
    "april": [
        "apr",
        "aprile"
    ],
    "may": [
        "mag",
        "maggio"
    ],
    "june": [
        "giu",
        "giugno"
    ],
    "july": [
        "lug",
        "luglio"
    ],
    "august": [
        "ago",
        "agosto"
    ],
    "september": [
        "set",
        "settembre"
    ],
    "october": [
        "ott",
        "ottobre"
    ],
    "november": [
        "nov",
        "novembre"
    ],
    "december": [
        "dic",
        "dicembre"
    ],
    "monday": [
        "lun",
        "lunedì"
    ],
    "tuesday": [
        "mar",
        "martedì"
    ],
    "wednesday": [
        "mer",
        "mercoledì"
    ],
    "thursday": [
        "gio",
        "giovedì"
    ],
    "friday": [
        "ven",
        "venerdì"
    ],
    "saturday": [
        "sab",
        "sabato"
    ],
    "sunday": [
        "dom",
        "domenica"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "anno",
        "anni"
    ],
    "month": [
        "mese",
        "mesi"
    ],
    "week": [
        "sett",
        "settimana",
        "settimane"
    ],
    "day": [
        "g",
        "giorno",
        "giorni"
    ],
    "hour": [
        "h",
        "ora",
        "ore"
    ],
    "minute": [
        "m",
        "min",
        "minuto",
        "minuti"
    ],
    "second": [
        "s",
        "sec",
        "secondo",
        "secondi"
    ],
    "relative-type": {
        "0 day ago": [
            "oggi"
        ],
        "0 hour ago": [
            "quest'ora"
        ],
        "0 minute ago": [
            "questo minuto"
        ],
        "0 month ago": [
            "questo mese"
        ],
        "0 second ago": [
            "ora"
        ],
        "0 week ago": [
            "questa settimana"
        ],
        "0 year ago": [
            "quest'anno"
        ],
        "1 day ago": [
            "ieri"
        ],
        "1 month ago": [
            "mese scorso"
        ],
        "1 week ago": [
            "settimana scorsa"
        ],
        "1 year ago": [
            "anno scorso"
        ],
        "in 1 day": [
            "domani"
        ],
        "in 1 month": [
            "mese prossimo"
        ],
        "in 1 week": [
            "settimana prossima"
        ],
        "in 1 year": [
            "anno prossimo"
        ],
        "2 day ago": [
            "altro ieri"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) g fa",
            "(\\d+) gg fa",
            "(\\d+) giorni fa",
            "(\\d+) giorno fa"
        ],
        "\\1 hour ago": [
            "(\\d+) h fa",
            "(\\d+) ora fa",
            "(\\d+) ore fa"
        ],
        "\\1 minute ago": [
            "(\\d+) min fa",
            "(\\d+) minuti fa",
            "(\\d+) minuto fa"
        ],
        "\\1 month ago": [
            "(\\d+) mese fa",
            "(\\d+) mesi fa"
        ],
        "\\1 second ago": [
            "(\\d+) s fa",
            "(\\d+) sec fa",
            "(\\d+) secondi fa",
            "(\\d+) secondo fa"
        ],
        "\\1 week ago": [
            "(\\d+) sett fa",
            "(\\d+) settimana fa",
            "(\\d+) settimane fa"
        ],
        "\\1 year ago": [
            "(\\d+) anni fa",
            "(\\d+) anno fa"
        ],
        "in \\1 day": [
            "tra (\\d+) g",
            "tra (\\d+) gg",
            "tra (\\d+) giorni",
            "tra (\\d+) giorno"
        ],
        "in \\1 hour": [
            "tra (\\d+) h",
            "tra (\\d+) ora",
            "tra (\\d+) ore"
        ],
        "in \\1 minute": [
            "tra (\\d+) min",
            "tra (\\d+) minuti",
            "tra (\\d+) minuto"
        ],
        "in \\1 month": [
            "tra (\\d+) mese",
            "tra (\\d+) mesi"
        ],
        "in \\1 second": [
            "tra (\\d+) s",
            "tra (\\d+) sec",
            "tra (\\d+) secondi",
            "tra (\\d+) secondo"
        ],
        "in \\1 week": [
            "tra (\\d+) sett",
            "tra (\\d+) settimana",
            "tra (\\d+) settimane"
        ],
        "in \\1 year": [
            "tra (\\d+) anni",
            "tra (\\d+) anno"
        ]
    },
    "locale_specific": {
        "it-CH": {
            "name": "it-CH"
        },
        "it-SM": {
            "name": "it-SM"
        },
        "it-VA": {
            "name": "it-VA"
        }
    },
    "skip": [
        "circa",
        "e",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "fa"
    ],
    "in": [
        "in"
    ],
    "simplifications": [
        {
            "(\\d+)\\s+ora": "\\1 ore"
        }
    ]
}
