# Development Report for Feb 10, 2017

Sorry for slacking off last week on the report.  We totally spaced it.
This week we will go over what happened last week and this week.

## Snapshot Design Changes

* https://github.com/containerd/containerd/pull/496

After receiving feedback on the `snapshot.Driver` interface, now known as the
`Snapshotter`, it was found that the behavior of active and committed snapshots
was confusing.  Specifically, it was hard to tell which methods to use based on
the state of the snapshot. It was also confusing which identifier to use based
on the state.

To clean this up, we moved to using "Active" and "Committed" as the type of a
snapshot, as opposed to the state of the snapshot. These lifecycle
relationships are such that "Active" snapshots can only be created from a
"Committed" snapshot and "Committed" snapshots must come from an "Active"
snapshot. We retain the concept of a parent for "Active" and "Committed"
snapshots, but clarified that only "Committed" snapshots can be a parent.


As part of this, we unified the keyspace of snapshots. For common operations,
such as removal and stat, we only have a single method that works for both
active and committed snapshots. For methods that take one or the other, the
restriction is called out. `Remove` and `Delete` were consolidated as part of
this. This also makes it easier to handle scenarios that use the snapshot
identity as a lock to coordinate multiple writers.

`Exists` and `Parent` have also be consolidated into single `Stat` call. This
returns an `Info` structure which includes information about state and
parentage. We also simplify the `Walk` method as part of this.

Effectively, we now have snapshots that are either active or committed and a
much smaller interface!

## Bundles Bundles Bundles

We spend time talking with people implementing Windows support as well as a few other users.
One the the major issues with our current approach was that bundles were a central part of our architecture.
The content and storage subsystems would produce bundles and the execution subsystem would consume them.
However, with a bundle being on the filesystem, having this concept does not work as smoothly on Windows
as it would for Unix platforms.

So the major design change is that bundles will be an implementation detail of the runtime and not a core
part of the API.  You will no longer pass the bundle path to containerd, it will manage bundles internally
and the root filesystem mounts along with the spec, passed via the `Any` type, will be API fields for the 
create request of a container.

## Runtimes

With the bundles change above we also need to make sure changes for where containers are created and who
does the supervision after creation.

The runtimes in containerd, things such as Linux, Windows, and Solaris, will be responsible for the 
creation of containers and loading of containers when containerd boots.

The containerd core will be responsible for interfacing with the GRPC API and managing a common `Container` 
interface that the runtimes produce.  The supervision of containers will be handled in the core. 
This is not much of a change from today, just refining where responsibilities lie. 

## Progress and POC

Overall design has been a large focus for us at the moment.  While containerd can run containers today it 
is not optimized in terms of speed or design.  With the work we did this week to make sure that containerd 
will work across many different platforms with first class support, not as an after thought, we are in a good 
position to really start on the development work and get a POC out within the next few weeks.  

This POC should give you a good idea of what containerd can do, its APIs, and how users will interact with
its various subsystems.
