#include <vector>
#include <string>
#include <exception>
#include <common/JSON.h>

#include <boost/range/irange.hpp>

using namespace std::literals::string_literals;

#include <gtest/gtest.h>

enum class ResultType
{
    Return,
    Throw
};

struct GetStringTestRecord
{
    std::string input;
    ResultType result_type;
    std::string result;
};

TEST(JSON_Suite, SimpleTest)
{
    std::vector<GetStringTestRecord> test_data =
    {
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Вафельница Vitek WX-1102 FL\""s, ResultType::Return, "Вафельница Vitek WX-1102 FL"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"184509\""s, ResultType::Return, "184509"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"Все для детей/Детская техника/Vitek\""s, ResultType::Return, "Все для детей/Детская техника/Vitek"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"В наличии\""s, ResultType::Return, "В наличии"s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"2390.00\""s, ResultType::Return, "2390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"Карточка\""s, ResultType::Return, "Карточка"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"detail\""s, ResultType::Return, "detail"s },
        { "\"actionField\""s, ResultType::Return, "actionField"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"http://www.techport.ru/q/?t=вафельница&sort=price&sdim=asc\""s, ResultType::Return, "http://www.techport.ru/q/?t=вафельница&sort=price&sdim=asc"s },
        { "\"action\""s, ResultType::Return, "action"s },
        { "\"detail\""s, ResultType::Return, "detail"s },
        { "\"products\""s, ResultType::Return, "products"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Вафельница Vitek WX-1102 FL\""s, ResultType::Return, "Вафельница Vitek WX-1102 FL"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"184509\""s, ResultType::Return, "184509"s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"2390.00\""s, ResultType::Return, "2390.00"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"Vitek\""s, ResultType::Return, "Vitek"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"Все для детей/Детская техника/Vitek\""s, ResultType::Return, "Все для детей/Детская техника/Vitek"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"В наличии\""s, ResultType::Return, "В наличии"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"experiments\""s, ResultType::Return, "experiments"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"los_portal\""s, ResultType::Return, "los_portal"s },
        { "\"los_level\""s, ResultType::Return, "los_level"s },
        { "\"none\""s, ResultType::Return, "none"s },
        { "\"isAuthorized\""s, ResultType::Return, "isAuthorized"s },
        { "\"isSubscriber\""s, ResultType::Return, "isSubscriber"s },
        { "\"postType\""s, ResultType::Return, "postType"s },
        { "\"Новости\""s, ResultType::Return, "Новости"s },
        { "\"experiments\""s, ResultType::Return, "experiments"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"los_portal\""s, ResultType::Return, "los_portal"s },
        { "\"los_level\""s, ResultType::Return, "los_level"s },
        { "\"none\""s, ResultType::Return, "none"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"Электроплита GEFEST Брест ЭПНД 5140-01 0001\""s, ResultType::Return, "Электроплита GEFEST Брест ЭПНД 5140-01 0001"s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"currencyCode\""s, ResultType::Return, "currencyCode"s },
        { "\"RUB\""s, ResultType::Return, "RUB"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"experiments\""s, ResultType::Return, "experiments"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"los_portal\""s, ResultType::Return, "los_portal"s },
        { "\"los_level\""s, ResultType::Return, "los_level"s },
        { "\"none\""s, ResultType::Return, "none"s },
        { "\"trash_login\""s, ResultType::Return, "trash_login"s },
        { "\"novikoff\""s, ResultType::Return, "novikoff"s },
        { "\"trash_cat_link\""s, ResultType::Return, "trash_cat_link"s },
        { "\"progs\""s, ResultType::Return, "progs"s },
        { "\"trash_parent_link\""s, ResultType::Return, "trash_parent_link"s },
        { "\"content\""s, ResultType::Return, "content"s },
        { "\"trash_posted_parent\""s, ResultType::Return, "trash_posted_parent"s },
        { "\"content.01.2016\""s, ResultType::Return, "content.01.2016"s },
        { "\"trash_posted_cat\""s, ResultType::Return, "trash_posted_cat"s },
        { "\"progs.01.2016\""s, ResultType::Return, "progs.01.2016"s },
        { "\"trash_virus_count\""s, ResultType::Return, "trash_virus_count"s },
        { "\"trash_is_android\""s, ResultType::Return, "trash_is_android"s },
        { "\"trash_is_wp8\""s, ResultType::Return, "trash_is_wp8"s },
        { "\"trash_is_ios\""s, ResultType::Return, "trash_is_ios"s },
        { "\"trash_posted\""s, ResultType::Return, "trash_posted"s },
        { "\"01.2016\""s, ResultType::Return, "01.2016"s },
        { "\"experiments\""s, ResultType::Return, "experiments"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"los_portal\""s, ResultType::Return, "los_portal"s },
        { "\"los_level\""s, ResultType::Return, "los_level"s },
        { "\"none\""s, ResultType::Return, "none"s },
        { "\"merchantId\""s, ResultType::Return, "merchantId"s },
        { "\"13694_49246\""s, ResultType::Return, "13694_49246"s },
        { "\"cps-source\""s, ResultType::Return, "cps-source"s },
        { "\"wargaming\""s, ResultType::Return, "wargaming"s },
        { "\"cps_provider\""s, ResultType::Return, "cps_provider"s },
        { "\"default\""s, ResultType::Return, "default"s },
        { "\"errorReason\""s, ResultType::Return, "errorReason"s },
        { "\"no errors\""s, ResultType::Return, "no errors"s },
        { "\"scid\""s, ResultType::Return, "scid"s },
        { "\"isAuthPayment\""s, ResultType::Return, "isAuthPayment"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"rubric\""s, ResultType::Return, "rubric"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"rubric\""s, ResultType::Return, "rubric"s },
        { "\"Мир\""s, ResultType::Return, "Мир"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"experiments\""s, ResultType::Return, "experiments"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"los_portal\""s, ResultType::Return, "los_portal"s },
        { "\"los_level\""s, ResultType::Return, "los_level"s },
        { "\"none\""s, ResultType::Return, "none"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"__ym\""s, ResultType::Return, "__ym"s },
        { "\"ecommerce\""s, ResultType::Return, "ecommerce"s },
        { "\"impressions\""s, ResultType::Return, "impressions"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"863813\""s, ResultType::Return, "863813"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Happy, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Happy, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"863839\""s, ResultType::Return, "863839"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Pretty kitten, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Pretty kitten, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"863847\""s, ResultType::Return, "863847"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Little tiger, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Little tiger, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"911480\""s, ResultType::Return, "911480"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Puppy, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Puppy, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"911484\""s, ResultType::Return, "911484"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Little bears, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Little bears, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"911489\""s, ResultType::Return, "911489"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Dolphin, возраст 2-4 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Dolphin, возраст 2-4 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"911496\""s, ResultType::Return, "911496"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Pretty, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Pretty, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"911504\""s, ResultType::Return, "911504"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Fairytale, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Fairytale, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"911508\""s, ResultType::Return, "911508"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Kittens, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Kittens, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"911512\""s, ResultType::Return, "911512"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Sunshine, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Sunshine, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"911516\""s, ResultType::Return, "911516"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Dog in bag, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Dog in bag, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"911520\""s, ResultType::Return, "911520"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Cute puppy, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Cute puppy, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"911524\""s, ResultType::Return, "911524"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Rabbit, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Rabbit, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"911528\""s, ResultType::Return, "911528"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Футболка детская 3D Turtle, возраст 1-2 года, трикотаж\""s, ResultType::Return, "Футболка детская 3D Turtle, возраст 1-2 года, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"390.00\""s, ResultType::Return, "390.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"888616\""s, ResultType::Return, "888616"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"3Д Футболка мужская \\\"Collorista\\\" Светлое завтра р-р XL(52-54), 100% хлопок, трикотаж\""s, ResultType::Return, "3Д Футболка мужская \"Collorista\" Светлое завтра р-р XL(52-54), 100% хлопок, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Одежда и обувь/Мужская одежда/Футболки/\""s, ResultType::Return, "/Одежда и обувь/Мужская одежда/Футболки/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"406.60\""s, ResultType::Return, "406.60"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"913361\""s, ResultType::Return, "913361"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"3Д Футболка детская World р-р 8-10, 100% хлопок, трикотаж\""s, ResultType::Return, "3Д Футболка детская World р-р 8-10, 100% хлопок, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"470.00\""s, ResultType::Return, "470.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"913364\""s, ResultType::Return, "913364"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"3Д Футболка детская Force р-р 8-10, 100% хлопок, трикотаж\""s, ResultType::Return, "3Д Футболка детская Force р-р 8-10, 100% хлопок, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"470.00\""s, ResultType::Return, "470.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"913367\""s, ResultType::Return, "913367"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"3Д Футболка детская Winter tale р-р 8-10, 100% хлопок, трикотаж\""s, ResultType::Return, "3Д Футболка детская Winter tale р-р 8-10, 100% хлопок, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"470.00\""s, ResultType::Return, "470.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"913385\""s, ResultType::Return, "913385"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"3Д Футболка детская Moonshine р-р 8-10, 100% хлопок, трикотаж\""s, ResultType::Return, "3Д Футболка детская Moonshine р-р 8-10, 100% хлопок, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"470.00\""s, ResultType::Return, "470.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"913391\""s, ResultType::Return, "913391"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"3Д Футболка детская Shaman р-р 8-10, 100% хлопок, трикотаж\""s, ResultType::Return, "3Д Футболка детская Shaman р-р 8-10, 100% хлопок, трикотаж"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"/Летние товары/Летний текстиль/\""s, ResultType::Return, "/Летние товары/Летний текстиль/"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"\""s, ResultType::Return, ""s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"470.00\""s, ResultType::Return, "470.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"/retailrocket/\""s, ResultType::Return, "/retailrocket/"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/\""s, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"s },
        { "\"usertype\""s, ResultType::Return, "usertype"s },
        { "\"visitor\""s, ResultType::Return, "visitor"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"__ym\""s, ResultType::Return, "__ym"s },
        { "\"ecommerce\""s, ResultType::Return, "ecommerce"s },
        { "\"impressions\""s, ResultType::Return, "impressions"s },
        { "\"experiments\""s, ResultType::Return, "experiments"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"los_portal\""s, ResultType::Return, "los_portal"s },
        { "\"los_level\""s, ResultType::Return, "los_level"s },
        { "\"none\""s, ResultType::Return, "none"s },
        { "\"experiments\""s, ResultType::Return, "experiments"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"los_portal\""s, ResultType::Return, "los_portal"s },
        { "\"los_level\""s, ResultType::Return, "los_level"s },
        { "\"none\""s, ResultType::Return, "none"s },
        { "\"experiments\""s, ResultType::Return, "experiments"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"los_portal\""s, ResultType::Return, "los_portal"s },
        { "\"los_level\""s, ResultType::Return, "los_level"s },
        { "\"none\""s, ResultType::Return, "none"s },
        { "\"experiments\""s, ResultType::Return, "experiments"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"los_portal\""s, ResultType::Return, "los_portal"s },
        { "\"los_level\""s, ResultType::Return, "los_level"s },
        { "\"none\""s, ResultType::Return, "none"s },
        { "\"experiments\""s, ResultType::Return, "experiments"s },
        { "\"lang\""s, ResultType::Return, "lang"s },
        { "\"ru\""s, ResultType::Return, "ru"s },
        { "\"los_portal\""s, ResultType::Return, "los_portal"s },
        { "\"los_level\""s, ResultType::Return, "los_level"s },
        { "\"none\""s, ResultType::Return, "none"s },
        { "\"__ym\""s, ResultType::Return, "__ym"s },
        { "\"ecommerce\""s, ResultType::Return, "ecommerce"s },
        { "\"currencyCode\""s, ResultType::Return, "currencyCode"s },
        { "\"RUR\""s, ResultType::Return, "RUR"s },
        { "\"impressions\""s, ResultType::Return, "impressions"s },
        { "\"name\""s, ResultType::Return, "name"s },
        { "\"Чайник электрический Mystery MEK-1627, белый\""s, ResultType::Return, "Чайник электрический Mystery MEK-1627, белый"s },
        { "\"brand\""s, ResultType::Return, "brand"s },
        { "\"Mystery\""s, ResultType::Return, "Mystery"s },
        { "\"id\""s, ResultType::Return, "id"s },
        { "\"187180\""s, ResultType::Return, "187180"s },
        { "\"category\""s, ResultType::Return, "category"s },
        { "\"Мелкая бытовая техника/Мелкие кухонные приборы/Чайники электрические/Mystery\""s, ResultType::Return, "Мелкая бытовая техника/Мелкие кухонные приборы/Чайники электрические/Mystery"s },
        { "\"variant\""s, ResultType::Return, "variant"s },
        { "\"В наличии\""s, ResultType::Return, "В наличии"s },
        { "\"price\""s, ResultType::Return, "price"s },
        { "\"1630.00\""s, ResultType::Return, "1630.00"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\"Карточка\""s, ResultType::Return, "Карточка"s },
        { "\"position\""s, ResultType::Return, "position"s },
        { "\"detail\""s, ResultType::Return, "detail"s },
        { "\"actionField\""s, ResultType::Return, "actionField"s },
        { "\"list\""s, ResultType::Return, "list"s },
        { "\0\""s, ResultType::Throw, "JSON: expected \", got \0"s },
        { "\"/igrushki/konstruktory\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/1290414/komplekt-zhenskiy-dzhemper-plusbryuki-m-254-09-malina-plustemno-siniy-\0a"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Творчество/Рисование/Инструменты и кра\0a"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройства для автомобильных аккумуляторов/Пуско-зарядные устр\xD0\0a"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройств\xD0\0t"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройства для автомобиль\0k"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\0t"s, ResultType::Throw, "JSON: expected \", got \0"s },
        { "\"/Хозтовары/Хранение вещей и организа\xD1\0t"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Хозтовары/Товары для стир\0a"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"li\0a"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/734859/samolet-radioupravlyaemyy-istrebitel-rabotaet-o\0k"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/kosmetika-i-parfyum/parfyumeriya/mu\0t"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/ko\0\x04"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { ""s, ResultType::Throw, "JSON: begin >= end."s },
        { "\"/stroitelstvo-i-remont/stroit\0t"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/stroitelstvo-i-remont/stroitelnyy-instrument/av\0k"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/s\0a"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Строительство и ремонт/Строительный инструмент/Изм\0e"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/avto/soputstvuy\0l"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/str\0\xD0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Отвертка 2 в 1 \\\"TUNDRA basic\\\" 5х75 мм (+,-) \0\xFF"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/stroitelstvo-i-remont/stroitelnyy-instrument/avtoinstrumen\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Мелкая бытовая техника/Мелки\xD0\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Пряжа \\\"Бамбук стрейч\\0\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Карандаш чёрнографитны\xD0\0\xD0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Творчество/Рукоделие, аппликации/Пряжа и шерсть для \xD0\0l"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/1071547/karandash-chernografitnyy-volshebstvo-nv-kruglyy-d-7-2mm-dl-176mm-plast-tuba/\0e"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"ca\0e"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"ca\0e"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/1165424/chipbord-vyrubnoy-dlya-skrapbukinga-malyshi-mikki-maus-disney-bebi\0t"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/posuda/kuhonnye-prinadlezhnosti-i-i\0d"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Канцтовары/Ежедневники и блокн\xD0\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/kanctovary/ezhednevniki-i-blok\0a"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Стакан \xD0\0a"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Набор бумаги для скрапбукинга \\\"Мои первый годик\\\": Микки Маус, Дисней бэби, 12 листов 29.5 х 29.5 см, 160\0\x80"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"c\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Органайзер для хранения аксессуаров, \0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"quantity\00"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Сменный блок для тетрадей на кольцах А5, 160 листов клетка, офсет \xE2\x84\0="s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Сувениры/Ф\xD0\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"\0\""s, ResultType::Return, "\0"s },
        { "\"\0\x04"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"va\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"ca\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"В \0\x04"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/letnie-tovary/z\0\x04"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Посудомоечная машина Ha\0="s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Крупная бытов\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Полочная акустическая система Magnat Needl\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"brand\00"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"\0d"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"pos\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"c\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"var\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Телевизоры и видеотехника/Всё для домашних кинотеатр\0="s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Флеш-диск Transcend JetFlash 620 8GB (TS8GJF62\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Табурет Мег\0\xD0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"variant\0\x04"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Катал\xD0\0\""s, ResultType::Return, "Катал\xD0\0"s },
        { "\"К\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Полочная акустическая система Magnat Needl\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"brand\00"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"\0d"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"pos\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"c\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"17\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/igrushki/razvivayusc\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Ключница \\\"\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Игр\xD1\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Игрушки/Игрушки для девочек/Игровые модули дл\xD1\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Крупная бытовая техника/Стиральные машины/С фронт\xD0\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\0 "s, ResultType::Throw, "JSON: expected \", got \0"s },
        { "\"Светодиодная лента SMD3528, 5 м. IP33, 60LED, зеленый, 4,8W/мет\xD1\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Сантехника/Мебель для ванных комнат/Стол\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\0o"s, ResultType::Throw, "JSON: expected \", got \0"s },
        { "\"/igrushki/konstruktory\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/posuda/kuhonnye-prinadlezhnosti-i-instrumenty/kuhonnye-pr\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/1290414/komplekt-zhenskiy-dzhemper-plusbryuki-m-254-09-malina-plustemno-siniy-\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Творчество/Рисование/Инструменты и кра\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройства для автомобильных аккумуляторов/Пуско-зарядные устр\xD0\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройств\xD0\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройства для автомобиль\0d"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\0 "s, ResultType::Throw, "JSON: expected \", got \0"s },
        { "\"/Хозтовары/Хранение вещей и организа\xD1\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Хозтовары/Товары для стир\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"li\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/igrushki/igrus\0d"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/734859/samolet-radioupravlyaemyy-istrebitel-rabotaet-o\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/kosmetika-i-parfyum/parfyumeriya/mu\00"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/ko\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/avto/avtomobilnyy\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/stroitelstvo-i-remont/stroit\00"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/stroitelstvo-i-remont/stroitelnyy-instrument/av\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/s\0d"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Строительство и ремонт/Строительный инструмент/Изм\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/avto/soputstvuy\0\""s, ResultType::Return, "/avto/soputstvuy\0"s },
        { "\"/str\0k"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Отвертка 2 в 1 \\\"TUNDRA basic\\\" 5х75 мм (+,-) \0\xD0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/stroitelstvo-i-remont/stroitelnyy-instrument/avtoinstrumen\0="s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Чайник электрический Vitesse\0="s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Мелкая бытовая техника/Мелки\xD0\0\xD0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Пряжа \\\"Бамбук стрейч\\0о"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Карандаш чёрнографитны\xD0\0k"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Творчество/Рукоделие, аппликации/Пряжа и шерсть для \xD0\0\""s, ResultType::Return, "/Творчество/Рукоделие, аппликации/Пряжа и шерсть для \xD0\0"s },
        { "\"/1071547/karandash-chernografitnyy-volshebstvo-nv-kruglyy-d-7-2mm-dl-176mm-plast-tuba/\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"ca\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Подаро\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Средство для прочис\xD1\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"i\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/p\0\""s, ResultType::Return, "/p\0"s },
        { "\"/Сувениры/Магниты, н\xD0\0k"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Дерев\xD0\0="s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/prazdniki/svadba/svadebnaya-c\0\xD0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Канцт\0d"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Праздники/То\xD0\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"v\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Косметика \xD0\0d"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Спорт и отдых/Настольные игры/Покер, руле\xD1\0\xD0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"categ\0="s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/retailr\0k"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/retailrocket\0k"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Ежедневник недат А5 140л кл,ляссе,обл пв\0="s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/432809/ezhednevnik-organayzer-sredniy-s-remeshkom-na-knopke-v-oblozhke-kalkulyator-kalendar-do-\0\xD0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/1165424/chipbord-vyrubnoy-dlya-skrapbukinga-malyshi-mikki-maus-disney-bebi\0d"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/posuda/kuhonnye-prinadlezhnosti-i-i\0 "s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/Канцтовары/Ежедневники и блокн\xD0\0o"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"/kanctovary/ezhednevniki-i-blok\00"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Стакан \xD0\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"Набор бумаги для скрапбукинга \\\"Мои первый годик\\\": Микки Маус, Дисней бэби, 12 листов 29.5 х 29.5 см, 160\0\0"s, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."s },
        { "\"c\0\""s, ResultType::Return, "c\0"s },
    };

    for (auto i : boost::irange(0, 1/*00000*/))
    {
        static_cast<void>(i);

        for (auto & r : test_data)
        {
            try
            {
                JSON j(r.input.c_str(), r.input.c_str() + r.input.size());

                ASSERT_EQ(j.getString(), r.result);
                ASSERT_TRUE(r.result_type == ResultType::Return);
            }
            catch (JSONException & e)
            {
                ASSERT_TRUE(r.result_type == ResultType::Throw);
                ASSERT_EQ(e.message(), r.result);
            }
        }
    }
}
