use Test::More tests => 14;
use Test::Refcount;

use CipUX::Object::Action;
use CipUX::Object::Client;
use CipUX::Object::Action::Create;
use CipUX::Object::Action::Destroy;
use CipUX::Object::Action::List;
use CipUX::Object::Action::Attribute::List;
use CipUX::Object::Action::Attribute::Change;

# 1
diag('test CipUX::Object::Action');
my $object1 = CipUX::Object::Action->new( { cache_dir => 'blib/cache' } );
is_oneref( $object1, '$object has a refcount of 1' );

my $otherref1 = $object1;
is_refcount( $object1, 2, '$object now has 2 references' );

# 2

diag('test CipUX::Object::Client');
my $object2 = CipUX::Object::Client->new(
    {
        name      => 'cipux_object_client',
        cache_dir => 'blib/cache',
    }
);
is_oneref( $object2, '$object has a refcount of 1' );

my $otherref2 = $object2;
is_refcount( $object2, 2, '$object now has 2 references' );

# 3
diag('test CipUX::Object::Action::Create');
my $object3
    = CipUX::Object::Action::Create->new( { cache_dir => 'blib/cache' } );
is_oneref( $object3, '$object has a refcount of 1' );

my $otherref3 = $object3;
is_refcount( $object3, 2, '$object now has 2 references' );

# 4
diag('test CipUX::Object::Action::Destroy');
my $object4
    = CipUX::Object::Action::Destroy->new( { cache_dir => 'blib/cache' } );
is_oneref( $object4, '$object has a refcount of 1' );

my $otherref4 = $object4;
is_refcount( $object4, 2, '$object now has 2 references' );

# 5
diag('test CipUX::Object::Action::List');
my $object5
    = CipUX::Object::Action::List->new( { cache_dir => 'blib/cache' } );
is_oneref( $object5, '$object has a refcount of 1' );

my $otherref5 = $object5;
is_refcount( $object5, 2, '$object now has 2 references' );

# 6
diag('test CipUX::Object::Action::Attribute::List');
my $object6 = CipUX::Object::Action::Attribute::List->new(
    { cache_dir => 'blib/cache' } );
is_oneref( $object6, '$object has a refcount of 1' );

my $otherref6 = $object6;
is_refcount( $object6, 2, '$object now has 2 references' );

# 7
diag('test CipUX::Object::Action::Attribute::Change');
my $object7 = CipUX::Object::Action::Attribute::Change->new(
    { cache_dir => 'blib/cache' } );
is_oneref( $object7, '$object has a refcount of 1' );

my $otherref7 = $object7;
is_refcount( $object7, 2, '$object now has 2 references' );

