/*
 * Secret Labs' Regular Expression Engine
 *
 * regular expression matching engine
 *
 * Copyright (c) 1997-2001 by Secret Labs AB.  All rights reserved.
 *
 * NOTE: This file is generated by regex.py.  If you need
 * to change anything in here, edit regex.py and run it.
 *
 * 2010-01-16 mrab Re-written
 */

/* Supports Unicode version 7.0.0. */

#define RE_MAGIC 20100116

#include "_regex_unicode.h"

/* Operators. */
#define RE_OP_FAILURE 0
#define RE_OP_SUCCESS 1
#define RE_OP_ANY 2
#define RE_OP_ANY_ALL 3
#define RE_OP_ANY_ALL_REV 4
#define RE_OP_ANY_REV 5
#define RE_OP_ANY_U 6
#define RE_OP_ANY_U_REV 7
#define RE_OP_ATOMIC 8
#define RE_OP_BOUNDARY 9
#define RE_OP_BRANCH 10
#define RE_OP_CALL_REF 11
#define RE_OP_CHARACTER 12
#define RE_OP_CHARACTER_IGN 13
#define RE_OP_CHARACTER_IGN_REV 14
#define RE_OP_CHARACTER_REV 15
#define RE_OP_DEFAULT_BOUNDARY 16
#define RE_OP_DEFAULT_END_OF_WORD 17
#define RE_OP_DEFAULT_START_OF_WORD 18
#define RE_OP_END 19
#define RE_OP_END_OF_LINE 20
#define RE_OP_END_OF_LINE_U 21
#define RE_OP_END_OF_STRING 22
#define RE_OP_END_OF_STRING_LINE 23
#define RE_OP_END_OF_STRING_LINE_U 24
#define RE_OP_END_OF_WORD 25
#define RE_OP_FUZZY 26
#define RE_OP_GRAPHEME_BOUNDARY 27
#define RE_OP_GREEDY_REPEAT 28
#define RE_OP_GROUP 29
#define RE_OP_GROUP_CALL 30
#define RE_OP_GROUP_EXISTS 31
#define RE_OP_LAZY_REPEAT 32
#define RE_OP_LOOKAROUND 33
#define RE_OP_NEXT 34
#define RE_OP_PROPERTY 35
#define RE_OP_PROPERTY_IGN 36
#define RE_OP_PROPERTY_IGN_REV 37
#define RE_OP_PROPERTY_REV 38
#define RE_OP_RANGE 39
#define RE_OP_RANGE_IGN 40
#define RE_OP_RANGE_IGN_REV 41
#define RE_OP_RANGE_REV 42
#define RE_OP_REF_GROUP 43
#define RE_OP_REF_GROUP_FLD 44
#define RE_OP_REF_GROUP_FLD_REV 45
#define RE_OP_REF_GROUP_IGN 46
#define RE_OP_REF_GROUP_IGN_REV 47
#define RE_OP_REF_GROUP_REV 48
#define RE_OP_SEARCH_ANCHOR 49
#define RE_OP_SET_DIFF 50
#define RE_OP_SET_DIFF_IGN 51
#define RE_OP_SET_DIFF_IGN_REV 52
#define RE_OP_SET_DIFF_REV 53
#define RE_OP_SET_INTER 54
#define RE_OP_SET_INTER_IGN 55
#define RE_OP_SET_INTER_IGN_REV 56
#define RE_OP_SET_INTER_REV 57
#define RE_OP_SET_SYM_DIFF 58
#define RE_OP_SET_SYM_DIFF_IGN 59
#define RE_OP_SET_SYM_DIFF_IGN_REV 60
#define RE_OP_SET_SYM_DIFF_REV 61
#define RE_OP_SET_UNION 62
#define RE_OP_SET_UNION_IGN 63
#define RE_OP_SET_UNION_IGN_REV 64
#define RE_OP_SET_UNION_REV 65
#define RE_OP_START_OF_LINE 66
#define RE_OP_START_OF_LINE_U 67
#define RE_OP_START_OF_STRING 68
#define RE_OP_START_OF_WORD 69
#define RE_OP_STRING 70
#define RE_OP_STRING_FLD 71
#define RE_OP_STRING_FLD_REV 72
#define RE_OP_STRING_IGN 73
#define RE_OP_STRING_IGN_REV 74
#define RE_OP_STRING_REV 75
#define RE_OP_STRING_SET 76
#define RE_OP_STRING_SET_FLD 77
#define RE_OP_STRING_SET_FLD_REV 78
#define RE_OP_STRING_SET_IGN 79
#define RE_OP_STRING_SET_IGN_REV 80
#define RE_OP_STRING_SET_REV 81
#define RE_OP_BODY_END 82
#define RE_OP_BODY_START 83
#define RE_OP_END_FUZZY 84
#define RE_OP_END_GREEDY_REPEAT 85
#define RE_OP_END_GROUP 86
#define RE_OP_END_LAZY_REPEAT 87
#define RE_OP_GREEDY_REPEAT_ONE 88
#define RE_OP_GROUP_RETURN 89
#define RE_OP_LAZY_REPEAT_ONE 90
#define RE_OP_MATCH_BODY 91
#define RE_OP_MATCH_TAIL 92
#define RE_OP_START_GROUP 93

char* re_op_text[] = {
    "RE_OP_FAILURE",
    "RE_OP_SUCCESS",
    "RE_OP_ANY",
    "RE_OP_ANY_ALL",
    "RE_OP_ANY_ALL_REV",
    "RE_OP_ANY_REV",
    "RE_OP_ANY_U",
    "RE_OP_ANY_U_REV",
    "RE_OP_ATOMIC",
    "RE_OP_BOUNDARY",
    "RE_OP_BRANCH",
    "RE_OP_CALL_REF",
    "RE_OP_CHARACTER",
    "RE_OP_CHARACTER_IGN",
    "RE_OP_CHARACTER_IGN_REV",
    "RE_OP_CHARACTER_REV",
    "RE_OP_DEFAULT_BOUNDARY",
    "RE_OP_DEFAULT_END_OF_WORD",
    "RE_OP_DEFAULT_START_OF_WORD",
    "RE_OP_END",
    "RE_OP_END_OF_LINE",
    "RE_OP_END_OF_LINE_U",
    "RE_OP_END_OF_STRING",
    "RE_OP_END_OF_STRING_LINE",
    "RE_OP_END_OF_STRING_LINE_U",
    "RE_OP_END_OF_WORD",
    "RE_OP_FUZZY",
    "RE_OP_GRAPHEME_BOUNDARY",
    "RE_OP_GREEDY_REPEAT",
    "RE_OP_GROUP",
    "RE_OP_GROUP_CALL",
    "RE_OP_GROUP_EXISTS",
    "RE_OP_LAZY_REPEAT",
    "RE_OP_LOOKAROUND",
    "RE_OP_NEXT",
    "RE_OP_PROPERTY",
    "RE_OP_PROPERTY_IGN",
    "RE_OP_PROPERTY_IGN_REV",
    "RE_OP_PROPERTY_REV",
    "RE_OP_RANGE",
    "RE_OP_RANGE_IGN",
    "RE_OP_RANGE_IGN_REV",
    "RE_OP_RANGE_REV",
    "RE_OP_REF_GROUP",
    "RE_OP_REF_GROUP_FLD",
    "RE_OP_REF_GROUP_FLD_REV",
    "RE_OP_REF_GROUP_IGN",
    "RE_OP_REF_GROUP_IGN_REV",
    "RE_OP_REF_GROUP_REV",
    "RE_OP_SEARCH_ANCHOR",
    "RE_OP_SET_DIFF",
    "RE_OP_SET_DIFF_IGN",
    "RE_OP_SET_DIFF_IGN_REV",
    "RE_OP_SET_DIFF_REV",
    "RE_OP_SET_INTER",
    "RE_OP_SET_INTER_IGN",
    "RE_OP_SET_INTER_IGN_REV",
    "RE_OP_SET_INTER_REV",
    "RE_OP_SET_SYM_DIFF",
    "RE_OP_SET_SYM_DIFF_IGN",
    "RE_OP_SET_SYM_DIFF_IGN_REV",
    "RE_OP_SET_SYM_DIFF_REV",
    "RE_OP_SET_UNION",
    "RE_OP_SET_UNION_IGN",
    "RE_OP_SET_UNION_IGN_REV",
    "RE_OP_SET_UNION_REV",
    "RE_OP_START_OF_LINE",
    "RE_OP_START_OF_LINE_U",
    "RE_OP_START_OF_STRING",
    "RE_OP_START_OF_WORD",
    "RE_OP_STRING",
    "RE_OP_STRING_FLD",
    "RE_OP_STRING_FLD_REV",
    "RE_OP_STRING_IGN",
    "RE_OP_STRING_IGN_REV",
    "RE_OP_STRING_REV",
    "RE_OP_STRING_SET",
    "RE_OP_STRING_SET_FLD",
    "RE_OP_STRING_SET_FLD_REV",
    "RE_OP_STRING_SET_IGN",
    "RE_OP_STRING_SET_IGN_REV",
    "RE_OP_STRING_SET_REV",
    "RE_OP_BODY_END",
    "RE_OP_BODY_START",
    "RE_OP_END_FUZZY",
    "RE_OP_END_GREEDY_REPEAT",
    "RE_OP_END_GROUP",
    "RE_OP_END_LAZY_REPEAT",
    "RE_OP_GREEDY_REPEAT_ONE",
    "RE_OP_GROUP_RETURN",
    "RE_OP_LAZY_REPEAT_ONE",
    "RE_OP_MATCH_BODY",
    "RE_OP_MATCH_TAIL",
    "RE_OP_START_GROUP",
};

#define RE_FLAG_ASCII 0x80
#define RE_FLAG_BESTMATCH 0x1000
#define RE_FLAG_DEBUG 0x200
#define RE_FLAG_DOTALL 0x10
#define RE_FLAG_ENHANCEMATCH 0x8000
#define RE_FLAG_FULLCASE 0x4000
#define RE_FLAG_IGNORECASE 0x2
#define RE_FLAG_LOCALE 0x4
#define RE_FLAG_MULTILINE 0x8
#define RE_FLAG_REVERSE 0x400
#define RE_FLAG_TEMPLATE 0x1
#define RE_FLAG_UNICODE 0x20
#define RE_FLAG_VERBOSE 0x40
#define RE_FLAG_VERSION0 0x2000
#define RE_FLAG_VERSION1 0x100
#define RE_FLAG_WORD 0x800
