;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; NOTE: This test was ported using port_test.py and could be cleaned up.

;; RUN: foreach %s %t wasm-opt --memory-packing --all-features -S -o - | filecheck %s

(module
  ;; CHECK:      (import "env" "memoryBase" (global $memoryBase i32))

  ;; CHECK:      (memory $0 2048 2048)
  (memory $0 2048 2048)
  (import "env" "memoryBase" (global $memoryBase i32))
  ;; nothing
)

(module
  ;; CHECK:      (import "env" "memoryBase" (global $memoryBase i32))

  ;; CHECK:      (memory $0 2048 2048)
  (memory $0 2048 2048)
  (import "env" "memoryBase" (global $memoryBase i32))
  (data (i32.const 4066) "") ;; empty
)

(module
  ;; CHECK:      (import "env" "memoryBase" (global $memoryBase i32))

  ;; CHECK:      (memory $0 2048 2048)
  (memory $0 2048 2048)
  (import "env" "memoryBase" (global $memoryBase i32))

  (data (global.get $memoryBase) "waka this cannot be optimized\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00we don't know where it will go")
)

;; CHECK:      (data (global.get $memoryBase) "waka this cannot be optimized\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00we don\'t know where it will go")
(module
  (memory 1 1)

  (data (i32.const 1024) "waka this CAN be optimized\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00we DO know where it will go")

  (data (i32.const 2000) "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeros before")

  (data (i32.const 3000) "zeros after\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00")

  (data (i32.const 4000) "zeros\00in\00the\00middle\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00nice skip here\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00another\00but no")

  ;; CHECK:      (type $none_=>_none (func))

  ;; CHECK:      (memory $0 1 1)

  ;; CHECK:      (data (i32.const 1024) "waka this CAN be optimized")

  ;; CHECK:      (data (i32.const 1107) "we DO know where it will go")

  ;; CHECK:      (data (i32.const 2057) "zeros before")

  ;; CHECK:      (data (i32.const 3000) "zeros after")

  ;; CHECK:      (data (i32.const 4000) "zeros\00in\00the\00middle")

  ;; CHECK:      (data (i32.const 4035) "nice skip here")

  ;; CHECK:      (data (i32.const 4066) "another\00but no")

  ;; CHECK:      (func $nonzero-size-init-of-active-will-trap
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 42)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 13)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $nonzero-size-init-of-active-will-trap
    (memory.init 0
      (i32.const 42)
      (i32.const 0)
      (i32.const 13)
    )
    (data.drop 0)
  )

  ;; CHECK:      (func $nonzero-offset-init-of-active-will-trap
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 42)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 13)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $nonzero-offset-init-of-active-will-trap
    (memory.init 0
      (i32.const 42)
      (i32.const 13)
      (i32.const 0)
    )
    (data.drop 0)
  )

  ;; CHECK:      (func $zero-offset-size-init-of-active-may-trap
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.gt_u
  ;; CHECK-NEXT:    (i32.const 42)
  ;; CHECK-NEXT:    (i32.shl
  ;; CHECK-NEXT:     (memory.size)
  ;; CHECK-NEXT:     (i32.const 16)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $zero-offset-size-init-of-active-may-trap
    (memory.init 0
      (i32.const 42)
      (i32.const 0)
      (i32.const 0)
    )
    (data.drop 0)
  )
)

(module
  ;; CHECK:      (type $none_=>_none (func))

  ;; CHECK:      (global $__mem_segment_drop_state (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_0 (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_1 (mut i32) (i32.const 0))

  ;; CHECK:      (memory $0 2048 2048)
  (memory $0 2048 2048)

  (data "not referenced, delete me") ;; 0

  ;; CHECK:      (data "zeroes at start")

  ;; CHECK:      (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes at start")
  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes at start") ;; 1

  ;; CHECK:      (data "\00\00\00few zeroes at start")

  ;; CHECK:      (data "zeroes at end")

  ;; CHECK:      (data "zeroes at end\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00")

  ;; CHECK:      (data "few zeroes at end\00\00\00")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (data "in middle")

  ;; CHECK:      (data "zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00in middle")

  ;; CHECK:      (data "few zeroes\00\00\00in middle")

  ;; CHECK:      (data "multiple")

  ;; CHECK:      (data "spans")

  ;; CHECK:      (data "of zeroes")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "more")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (data "no zeroes")

  ;; CHECK:      (func $zeroes-at-start
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 0
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 15)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $zeroes-at-start
    (memory.init 1
      (i32.const 0)
      (i32.const 0)
      (i32.const 45)
    )
    (data.drop 1)
  )

  ;; the not-split tests have too many memory.init and data.drop instructions for splitting to be worth it
  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes at start") ;; 2

  ;; CHECK:      (func $zeroes-at-start-not-split
  ;; CHECK-NEXT:  (memory.init 1
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 45)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (memory.init 1
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 45)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (memory.init 1
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 45)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (memory.init 1
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 45)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (data.drop 1)
  ;; CHECK-NEXT: )
  (func $zeroes-at-start-not-split
    (memory.init 2
      (i32.const 0)
      (i32.const 0)
      (i32.const 45)
    )
    (memory.init 2
      (i32.const 0)
      (i32.const 0)
      (i32.const 45)
    )
    (memory.init 2
      (i32.const 0)
      (i32.const 0)
      (i32.const 45)
    )
    (memory.init 2
      (i32.const 0)
      (i32.const 0)
      (i32.const 45)
    )
    (data.drop 2)
  )

  (data "\00\00\00few zeroes at start") ;; 3

  ;; CHECK:      (func $few-zeroes-at-start
  ;; CHECK-NEXT:  (memory.init 2
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 22)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (data.drop 2)
  ;; CHECK-NEXT: )
  (func $few-zeroes-at-start
    (memory.init 3
      (i32.const 0)
      (i32.const 0)
      (i32.const 22)
    )
    (data.drop 3)
  )

  (data "zeroes at end\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 4

  ;; CHECK:      (func $zeroes-at-end
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (memory.init 3
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 13)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 13)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (data.drop 3)
  ;; CHECK-NEXT: )
  (func $zeroes-at-end
    (memory.init 4
      (i32.const 0)
      (i32.const 0)
      (i32.const 43)
    )
    (data.drop 4)
  )

  (data "zeroes at end\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 5

  ;; CHECK:      (func $zeroes-at-end-not-split
  ;; CHECK-NEXT:  (memory.init 4
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 43)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (memory.init 4
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 43)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (memory.init 4
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 43)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (memory.init 4
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 43)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (data.drop 4)
  ;; CHECK-NEXT: )
  (func $zeroes-at-end-not-split
    (memory.init 5
      (i32.const 0)
      (i32.const 0)
      (i32.const 43)
    )
    (memory.init 5
      (i32.const 0)
      (i32.const 0)
      (i32.const 43)
    )
    (memory.init 5
      (i32.const 0)
      (i32.const 0)
      (i32.const 43)
    )
    (memory.init 5
      (i32.const 0)
      (i32.const 0)
      (i32.const 43)
    )
    (data.drop 5)
  )

  (data "few zeroes at end\00\00\00") ;; 6

  ;; CHECK:      (func $few-zeroes-at-end
  ;; CHECK-NEXT:  (memory.init 5
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 20)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (data.drop 5)
  ;; CHECK-NEXT: )
  (func $few-zeroes-at-end
    (memory.init 6
      (i32.const 0)
      (i32.const 0)
      (i32.const 20)
    )
    (data.drop 6)
  )

  (data "zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00in middle") ;; 7

  ;; CHECK:      (func $zeroes-in-middle
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (memory.init 6
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 6)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 6)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 7
  ;; CHECK-NEXT:    (i32.const 36)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 9)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (data.drop 6)
  ;; CHECK-NEXT:   (data.drop 7)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $zeroes-in-middle
    (memory.init 7
      (i32.const 0)
      (i32.const 0)
      (i32.const 45)
    )
    (data.drop 7)
  )

  (data "zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00in middle") ;; 8

  ;; CHECK:      (func $zeroes-in-middle-not-split
  ;; CHECK-NEXT:  (memory.init 8
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 35)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (memory.init 8
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 45)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (data.drop 8)
  ;; CHECK-NEXT: )
  (func $zeroes-in-middle-not-split
    (memory.init 8
      (i32.const 0)
      (i32.const 0)
      (i32.const 35)
    )
    (memory.init 8
      (i32.const 0)
      (i32.const 0)
      (i32.const 45)
    )
    (data.drop 8)
  )

  (data "few zeroes\00\00\00in middle") ;; 9

  ;; CHECK:      (func $few-zeroes-in-middle
  ;; CHECK-NEXT:  (memory.init 9
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 22)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (data.drop 9)
  ;; CHECK-NEXT: )
  (func $few-zeroes-in-middle
    (memory.init 9
      (i32.const 0)
      (i32.const 0)
      (i32.const 22)
    )
    (data.drop 9)
  )

  (data "multiple\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00spans\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00of zeroes") ;; 10

  ;; CHECK:      (func $multiple-spans-of-zeroes
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (memory.init 10
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 8)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 11
  ;; CHECK-NEXT:    (i32.const 38)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 5)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 43)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 12
  ;; CHECK-NEXT:    (i32.const 73)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 9)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (data.drop 10)
  ;; CHECK-NEXT:   (data.drop 11)
  ;; CHECK-NEXT:   (data.drop 12)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $multiple-spans-of-zeroes
    (memory.init 10
      (i32.const 0)
      (i32.const 0)
      (i32.const 82)
    )
    (data.drop 10)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 11

  ;; CHECK:      (func $even-more-zeroes
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_0)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 13
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 34)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 14
  ;; CHECK-NEXT:    (i32.const 64)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 68)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 15
  ;; CHECK-NEXT:    (i32.const 98)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 6)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 104)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state_0
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 13)
  ;; CHECK-NEXT:   (data.drop 14)
  ;; CHECK-NEXT:   (data.drop 15)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $even-more-zeroes
    (memory.init 11
      (i32.const 0)
      (i32.const 0)
      (i32.const 134)
    )
    (data.drop 11)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 12

  ;; CHECK:      (func $only-zeroes
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_1)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (global.set $__mem_segment_drop_state_1
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $only-zeroes
    (memory.init 12
      (i32.const 0)
      (i32.const 0)
      (i32.const 30)
    )
    (data.drop 12)
  )

  (data "no zeroes") ;; 13

  ;; CHECK:      (func $no-zeroes
  ;; CHECK-NEXT:  (memory.init 16
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 9)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (data.drop 16)
  ;; CHECK-NEXT: )
  (func $no-zeroes
    (memory.init 13
      (i32.const 0)
      (i32.const 0)
      (i32.const 9)
    )
    (data.drop 13)
  )

  (data "") ;; 14

  ;; CHECK:      (func $empty
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.gt_u
  ;; CHECK-NEXT:    (i32.const 13)
  ;; CHECK-NEXT:    (i32.shl
  ;; CHECK-NEXT:     (memory.size)
  ;; CHECK-NEXT:     (i32.const 16)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $empty
    (memory.init 14
      (i32.const 13)
      (i32.const 0)
      (i32.const 0)
    )
    (data.drop 14)
  )

  (data "only dropped") ;; 15

  ;; CHECK:      (func $only-dropped
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $only-dropped
    (data.drop 15)
    (data.drop 15)
  )

  (data "\00\00\00\00\00") ;; 16

  ;; CHECK:      (func $only-dropped-zeroes
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $only-dropped-zeroes
    (data.drop 16)
    (data.drop 16)
  )

  (data "") ;; not referenced

  (data "\00\00\00\00\00") ;; not referenced
)

(module
  ;; CHECK:      (type $none_=>_none (func))

  ;; CHECK:      (import "env" "param" (global $param i32))

  ;; CHECK:      (global $__mem_segment_drop_state (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_0 (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_1 (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_2 (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_3 (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_4 (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_5 (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_6 (mut i32) (i32.const 0))

  ;; CHECK:      (memory $0 2048 2048)
  (memory $0 2048 2048)
  (import "env" "param" (global $param i32))

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "more")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00")
  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 0

  ;; CHECK:      (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "more")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "more")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "more")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "more")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "more")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "more")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "more")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "more")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "more")

  ;; CHECK:      (data "zeroes")

  ;; CHECK:      (func $nonconst-dest
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $0
  ;; CHECK-NEXT:    (global.get $param)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 0
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:     (i32.const 30)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:     (i32.const 34)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 1
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:     (i32.const 64)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:     (i32.const 68)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 2
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:     (i32.const 98)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 6)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $0)
  ;; CHECK-NEXT:     (i32.const 104)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 0)
  ;; CHECK-NEXT:   (data.drop 1)
  ;; CHECK-NEXT:   (data.drop 2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $nonconst-dest
    (memory.init 0
      (global.get $param)
      (i32.const 0)
      (i32.const 134)
    )
    (data.drop 0)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 1

  ;; CHECK:      (func $nonconst-offset
  ;; CHECK-NEXT:  (memory.init 3
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (global.get $param)
  ;; CHECK-NEXT:   (i32.const 134)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (data.drop 3)
  ;; CHECK-NEXT: )
  (func $nonconst-offset
    (memory.init 1
      (i32.const 0)
      (global.get $param)
      (i32.const 134)
    )
    (data.drop 1)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 2

  ;; CHECK:      (func $nonconst-size
  ;; CHECK-NEXT:  (memory.init 4
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (global.get $param)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (data.drop 4)
  ;; CHECK-NEXT: )
  (func $nonconst-size
    (memory.init 2
      (i32.const 0)
      (i32.const 0)
      (global.get $param)
    )
    (data.drop 2)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 3

  ;; CHECK:      (func $partial-skip-start
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_0)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 5
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 24)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 6
  ;; CHECK-NEXT:    (i32.const 54)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 58)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 7
  ;; CHECK-NEXT:    (i32.const 88)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 6)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 94)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state_0
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 5)
  ;; CHECK-NEXT:   (data.drop 6)
  ;; CHECK-NEXT:   (data.drop 7)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $partial-skip-start
    (memory.init 3
      (i32.const 0)
      (i32.const 10)
      (i32.const 124)
    )
    (data.drop 3)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 4

  ;; CHECK:      (func $full-skip-start
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (memory.init 8
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 9
  ;; CHECK-NEXT:    (i32.const 32)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 36)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 10
  ;; CHECK-NEXT:    (i32.const 66)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 6)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 72)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (data.drop 8)
  ;; CHECK-NEXT:   (data.drop 9)
  ;; CHECK-NEXT:   (data.drop 10)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $full-skip-start
    (memory.init 4
      (i32.const 0)
      (i32.const 32)
      (i32.const 102)
    )
    (data.drop 4)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 5

  ;; CHECK:      (func $partial-skip-end
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_1)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 11
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 34)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 12
  ;; CHECK-NEXT:    (i32.const 64)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 68)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 13
  ;; CHECK-NEXT:    (i32.const 98)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 6)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 104)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state_1
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 11)
  ;; CHECK-NEXT:   (data.drop 12)
  ;; CHECK-NEXT:   (data.drop 13)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $partial-skip-end
    (memory.init 5
      (i32.const 0)
      (i32.const 0)
      (i32.const 124)
    )
    (data.drop 5)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 6

  ;; CHECK:      (func $full-skip-end
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_2)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 14
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 34)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 15
  ;; CHECK-NEXT:    (i32.const 64)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 68)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 16
  ;; CHECK-NEXT:    (i32.const 98)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state_2
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 14)
  ;; CHECK-NEXT:   (data.drop 15)
  ;; CHECK-NEXT:   (data.drop 16)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $full-skip-end
    (memory.init 6
      (i32.const 0)
      (i32.const 0)
      (i32.const 102)
    )
    (data.drop 6)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 7

  ;; CHECK:      (func $slice-zeroes
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_3)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state_3
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 17)
  ;; CHECK-NEXT:   (data.drop 18)
  ;; CHECK-NEXT:   (data.drop 19)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $slice-zeroes
    (memory.init 7
      (i32.const 0)
      (i32.const 35)
      (i32.const 10)
    )
    (data.drop 7)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 8

  ;; CHECK:      (func $slice-nonzeroes
  ;; CHECK-NEXT:  (memory.init 20
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:   (i32.const 2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (data.drop 20)
  ;; CHECK-NEXT:   (data.drop 21)
  ;; CHECK-NEXT:   (data.drop 22)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $slice-nonzeroes
    (memory.init 8
      (i32.const 0)
      (i32.const 31)
      (i32.const 2)
    )
    (data.drop 8)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 9

  ;; CHECK:      (func $zero-size
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.or
  ;; CHECK-NEXT:    (i32.gt_u
  ;; CHECK-NEXT:     (i32.const 13)
  ;; CHECK-NEXT:     (i32.shl
  ;; CHECK-NEXT:      (memory.size)
  ;; CHECK-NEXT:      (i32.const 16)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state_4
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 23)
  ;; CHECK-NEXT:   (data.drop 24)
  ;; CHECK-NEXT:   (data.drop 25)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $zero-size
    (memory.init 9
      (i32.const 13)
      (i32.const 40)
      (i32.const 0)
    )
    (data.drop 9)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 10

  ;; CHECK:      (func $zero-size-undropped
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.or
  ;; CHECK-NEXT:    (i32.gt_u
  ;; CHECK-NEXT:     (i32.const 13)
  ;; CHECK-NEXT:     (i32.shl
  ;; CHECK-NEXT:      (memory.size)
  ;; CHECK-NEXT:      (i32.const 16)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_5)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $zero-size-undropped
    (memory.init 10
      (i32.const 13)
      (i32.const 40)
      (i32.const 0)
    )
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 11

  ;; CHECK:      (func $out-of-bounds-offset
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 135)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $out-of-bounds-offset
    (memory.init 11
      (i32.const 0)
      (i32.const 135)
      (i32.const 1)
    )
    (data.drop 11)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 12

  ;; CHECK:      (func $zero-size-out-of-bounds-offset
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 135)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $zero-size-out-of-bounds-offset
    (memory.init 12
      (i32.const 0)
      (i32.const 135)
      (i32.const 0)
    )
    (data.drop 12)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 13

  ;; CHECK:      (func $out-of-bounds-size
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (i32.const 135)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  (func $out-of-bounds-size
    (memory.init 13
      (i32.const 0)
      (i32.const 0)
      (i32.const 135)
    )
    (data.drop 13)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00more\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00zeroes\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00") ;; 14

  ;; CHECK:      (func $zero-size-at-bounds-offset
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.or
  ;; CHECK-NEXT:    (i32.gt_u
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:     (i32.shl
  ;; CHECK-NEXT:      (memory.size)
  ;; CHECK-NEXT:      (i32.const 16)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_6)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state_6
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 29)
  ;; CHECK-NEXT:   (data.drop 30)
  ;; CHECK-NEXT:   (data.drop 31)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $zero-size-at-bounds-offset
    (memory.init 14
      (i32.const 0)
      (i32.const 134)
      (i32.const 0)
    )
    (data.drop 14)
  )
)

(module
  ;; CHECK:      (type $none_=>_none (func))

  ;; CHECK:      (global $__mem_segment_drop_state (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_0 (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_1 (mut i32) (i32.const 0))

  ;; CHECK:      (global $__mem_segment_drop_state_2 (mut i32) (i32.const 0))

  ;; CHECK:      (memory $0 2048 2048)
  (memory $0 2048 2048)
  (data "hi\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00hi") ;; 0

  ;; CHECK:      (data "hi")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "hi")

  ;; CHECK:      (data "hi")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "hi")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "hi")

  ;; CHECK:      (data "even")

  ;; CHECK:      (data "hi")

  ;; CHECK:      (func $zero-length-init-zeroes
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.or
  ;; CHECK-NEXT:    (i32.gt_u
  ;; CHECK-NEXT:     (i32.const 13)
  ;; CHECK-NEXT:     (i32.shl
  ;; CHECK-NEXT:      (memory.size)
  ;; CHECK-NEXT:      (i32.const 16)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 0)
  ;; CHECK-NEXT:   (data.drop 1)
  ;; CHECK-NEXT:   (data.drop 2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $zero-length-init-zeroes
    (memory.init 0
      (i32.const 13)
      (i32.const 10)
      (i32.const 0)
    )
    (data.drop 0)
  )

  (data "hi\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00hi") ;; 1

  ;; CHECK:      (func $zero-length-init-nonzeroes
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.or
  ;; CHECK-NEXT:    (i32.gt_u
  ;; CHECK-NEXT:     (i32.const 13)
  ;; CHECK-NEXT:     (i32.shl
  ;; CHECK-NEXT:      (memory.size)
  ;; CHECK-NEXT:      (i32.const 16)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state_0
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 3)
  ;; CHECK-NEXT:   (data.drop 4)
  ;; CHECK-NEXT:   (data.drop 5)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $zero-length-init-nonzeroes
    (memory.init 1
      (i32.const 13)
      (i32.const 33)
      (i32.const 0)
    )
    (data.drop 1)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00hi") ;; 2

  ;; CHECK:      (func $zero-length-init-zeroes-2
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.or
  ;; CHECK-NEXT:    (i32.gt_u
  ;; CHECK-NEXT:     (i32.const 13)
  ;; CHECK-NEXT:     (i32.shl
  ;; CHECK-NEXT:      (memory.size)
  ;; CHECK-NEXT:      (i32.const 16)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state_1
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 6)
  ;; CHECK-NEXT:   (data.drop 7)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $zero-length-init-zeroes-2
    (memory.init 2
      (i32.const 13)
      (i32.const 10)
      (i32.const 0)
    )
    (data.drop 2)
  )

  (data "\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00even\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00hi") ;; 3

  ;; CHECK:      (func $zero-length-init-nonzeroes-2
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.or
  ;; CHECK-NEXT:    (i32.gt_u
  ;; CHECK-NEXT:     (i32.const 13)
  ;; CHECK-NEXT:     (i32.shl
  ;; CHECK-NEXT:      (memory.size)
  ;; CHECK-NEXT:      (i32.const 16)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (global.get $__mem_segment_drop_state_2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (global.set $__mem_segment_drop_state_2
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (data.drop 8)
  ;; CHECK-NEXT:   (data.drop 9)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $zero-length-init-nonzeroes-2
    (memory.init 3
      (i32.const 13)
      (i32.const 31)
      (i32.const 0)
    )
    (data.drop 3)
  )
)

(module
  ;; CHECK:      (type $none_=>_none (func))

  ;; CHECK:      (memory $0 2048 2048)
  (memory $0 2048 2048)
  (data "a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00a") ;; 64 ranges of zeroes

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (data "a")

  ;; CHECK:      (func $init-lots
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (memory.init 0
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 1
  ;; CHECK-NEXT:    (i32.const 31)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 32)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 2
  ;; CHECK-NEXT:    (i32.const 62)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 63)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 3
  ;; CHECK-NEXT:    (i32.const 93)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 94)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 4
  ;; CHECK-NEXT:    (i32.const 124)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 125)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 5
  ;; CHECK-NEXT:    (i32.const 155)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 156)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 6
  ;; CHECK-NEXT:    (i32.const 186)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 187)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 7
  ;; CHECK-NEXT:    (i32.const 217)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 218)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 8
  ;; CHECK-NEXT:    (i32.const 248)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 249)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 9
  ;; CHECK-NEXT:    (i32.const 279)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 280)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 10
  ;; CHECK-NEXT:    (i32.const 310)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 311)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 11
  ;; CHECK-NEXT:    (i32.const 341)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 342)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 12
  ;; CHECK-NEXT:    (i32.const 372)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 373)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 13
  ;; CHECK-NEXT:    (i32.const 403)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 404)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 14
  ;; CHECK-NEXT:    (i32.const 434)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 435)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 15
  ;; CHECK-NEXT:    (i32.const 465)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 466)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 16
  ;; CHECK-NEXT:    (i32.const 496)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 497)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 17
  ;; CHECK-NEXT:    (i32.const 527)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 528)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 18
  ;; CHECK-NEXT:    (i32.const 558)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 559)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 19
  ;; CHECK-NEXT:    (i32.const 589)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 590)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 20
  ;; CHECK-NEXT:    (i32.const 620)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 621)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 21
  ;; CHECK-NEXT:    (i32.const 651)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 652)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 22
  ;; CHECK-NEXT:    (i32.const 682)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 683)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 23
  ;; CHECK-NEXT:    (i32.const 713)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 714)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 24
  ;; CHECK-NEXT:    (i32.const 744)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 745)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 25
  ;; CHECK-NEXT:    (i32.const 775)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 776)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 26
  ;; CHECK-NEXT:    (i32.const 806)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 807)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 27
  ;; CHECK-NEXT:    (i32.const 837)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 838)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 28
  ;; CHECK-NEXT:    (i32.const 868)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 869)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 29
  ;; CHECK-NEXT:    (i32.const 899)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 900)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 30
  ;; CHECK-NEXT:    (i32.const 930)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 931)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 31
  ;; CHECK-NEXT:    (i32.const 961)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 962)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 32
  ;; CHECK-NEXT:    (i32.const 992)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 993)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 33
  ;; CHECK-NEXT:    (i32.const 1023)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1024)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 34
  ;; CHECK-NEXT:    (i32.const 1054)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1055)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 35
  ;; CHECK-NEXT:    (i32.const 1085)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1086)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 36
  ;; CHECK-NEXT:    (i32.const 1116)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1117)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 37
  ;; CHECK-NEXT:    (i32.const 1147)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1148)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 38
  ;; CHECK-NEXT:    (i32.const 1178)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1179)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 39
  ;; CHECK-NEXT:    (i32.const 1209)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1210)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 40
  ;; CHECK-NEXT:    (i32.const 1240)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1241)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 41
  ;; CHECK-NEXT:    (i32.const 1271)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1272)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 42
  ;; CHECK-NEXT:    (i32.const 1302)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1303)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 30)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.init 43
  ;; CHECK-NEXT:    (i32.const 1333)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (memory.fill
  ;; CHECK-NEXT:    (i32.const 1334)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 11)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (data.drop 0)
  ;; CHECK-NEXT:   (data.drop 1)
  ;; CHECK-NEXT:   (data.drop 2)
  ;; CHECK-NEXT:   (data.drop 3)
  ;; CHECK-NEXT:   (data.drop 4)
  ;; CHECK-NEXT:   (data.drop 5)
  ;; CHECK-NEXT:   (data.drop 6)
  ;; CHECK-NEXT:   (data.drop 7)
  ;; CHECK-NEXT:   (data.drop 8)
  ;; CHECK-NEXT:   (data.drop 9)
  ;; CHECK-NEXT:   (data.drop 10)
  ;; CHECK-NEXT:   (data.drop 11)
  ;; CHECK-NEXT:   (data.drop 12)
  ;; CHECK-NEXT:   (data.drop 13)
  ;; CHECK-NEXT:   (data.drop 14)
  ;; CHECK-NEXT:   (data.drop 15)
  ;; CHECK-NEXT:   (data.drop 16)
  ;; CHECK-NEXT:   (data.drop 17)
  ;; CHECK-NEXT:   (data.drop 18)
  ;; CHECK-NEXT:   (data.drop 19)
  ;; CHECK-NEXT:   (data.drop 20)
  ;; CHECK-NEXT:   (data.drop 21)
  ;; CHECK-NEXT:   (data.drop 22)
  ;; CHECK-NEXT:   (data.drop 23)
  ;; CHECK-NEXT:   (data.drop 24)
  ;; CHECK-NEXT:   (data.drop 25)
  ;; CHECK-NEXT:   (data.drop 26)
  ;; CHECK-NEXT:   (data.drop 27)
  ;; CHECK-NEXT:   (data.drop 28)
  ;; CHECK-NEXT:   (data.drop 29)
  ;; CHECK-NEXT:   (data.drop 30)
  ;; CHECK-NEXT:   (data.drop 31)
  ;; CHECK-NEXT:   (data.drop 32)
  ;; CHECK-NEXT:   (data.drop 33)
  ;; CHECK-NEXT:   (data.drop 34)
  ;; CHECK-NEXT:   (data.drop 35)
  ;; CHECK-NEXT:   (data.drop 36)
  ;; CHECK-NEXT:   (data.drop 37)
  ;; CHECK-NEXT:   (data.drop 38)
  ;; CHECK-NEXT:   (data.drop 39)
  ;; CHECK-NEXT:   (data.drop 40)
  ;; CHECK-NEXT:   (data.drop 41)
  ;; CHECK-NEXT:   (data.drop 42)
  ;; CHECK-NEXT:   (data.drop 43)
  ;; CHECK-NEXT:   (data.drop 44)
  ;; CHECK-NEXT:   (data.drop 45)
  ;; CHECK-NEXT:   (data.drop 46)
  ;; CHECK-NEXT:   (data.drop 47)
  ;; CHECK-NEXT:   (data.drop 48)
  ;; CHECK-NEXT:   (data.drop 49)
  ;; CHECK-NEXT:   (data.drop 50)
  ;; CHECK-NEXT:   (data.drop 51)
  ;; CHECK-NEXT:   (data.drop 52)
  ;; CHECK-NEXT:   (data.drop 53)
  ;; CHECK-NEXT:   (data.drop 54)
  ;; CHECK-NEXT:   (data.drop 55)
  ;; CHECK-NEXT:   (data.drop 56)
  ;; CHECK-NEXT:   (data.drop 57)
  ;; CHECK-NEXT:   (data.drop 58)
  ;; CHECK-NEXT:   (data.drop 59)
  ;; CHECK-NEXT:   (data.drop 60)
  ;; CHECK-NEXT:   (data.drop 61)
  ;; CHECK-NEXT:   (data.drop 62)
  ;; CHECK-NEXT:   (data.drop 63)
  ;; CHECK-NEXT:   (data.drop 64)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $init-lots
    (memory.init 0
      (i32.const 0)
      (i32.const 0)
      (i32.const 1345)
    )
    (data.drop 0)
  )
)
(module
 ;; CHECK:      (memory $0 1 1)
 (memory $0 1 1)
 (data (i32.const 1024) "x")
 (data (i32.const 1024) "\00") ;; this tramples the "x", and so must be kept.
)
;; CHECK:      (data (i32.const 1024) "x")

;; CHECK:      (data (i32.const 1024) "\00")
(module
 ;; CHECK:      (memory $0 1 1)
 (memory $0 1 1)
 (data (i32.const 1024) "x")
 (data (i32.const 1025) "\00")
)
;; CHECK:      (data (i32.const 1024) "x")
(module
 ;; CHECK:      (memory $0 1 1)
 (memory $0 1 1)
 (data (i32.const 1024) "x")
 (data (i32.const 1023) "\00")
)
;; CHECK:      (data (i32.const 1024) "x")
(module
 ;; CHECK:      (memory $0 1 1)
 (memory $0 1 1)
 (data (i32.const 1024) "x")
 (data (i32.const 1024) "\00") ;; when we see one bad thing, we give up
 (data (i32.const 4096) "\00")
)
;; CHECK:      (data (i32.const 1024) "x")

;; CHECK:      (data (i32.const 1024) "\00")

;; CHECK:      (data (i32.const 4096) "\00")
(module
 ;; CHECK:      (import "env" "memoryBase" (global $memoryBase i32))

 ;; CHECK:      (memory $0 1 1)
 (memory $0 1 1)
 (import "env" "memoryBase" (global $memoryBase i32))
 (data (i32.const 1024) "x")
 (data (global.get $memoryBase) "\00") ;; this could trample, or not
)
;; CHECK:      (data (i32.const 1024) "x")

;; CHECK:      (data (global.get $memoryBase) "\00")
(module
 ;; CHECK:      (import "env" "memoryBase" (global $memoryBase i32))

 ;; CHECK:      (memory $0 1 1)
 (memory $0 1 1)
 (import "env" "memoryBase" (global $memoryBase i32))
 (data (i32.const 1024) "\00") ;; this could trample, or not
 (data (global.get $memoryBase) "x")
)
;; CHECK:      (data (i32.const 1024) "\00")

;; CHECK:      (data (global.get $memoryBase) "x")
(module
 ;; CHECK:      (type $none_=>_none (func))

 ;; CHECK:      (global $__mem_segment_drop_state (mut i32) (i32.const 0))

 ;; CHECK:      (memory $0 1 1)
 (memory $0 1 1)
 (data "skipped\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00\00included")
 ;; CHECK:      (data "skipped")

 ;; CHECK:      (data "included")

 ;; CHECK:      (export "func_54" (func $0))
 (export "func_54" (func $0))
 ;; CHECK:      (func $0
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (global.get $__mem_segment_drop_state)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (memory.fill
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (i32.const 30)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (memory.init 1
 ;; CHECK-NEXT:   (i32.const 30)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (i32.const 8)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $0
  (memory.init 0
   (i32.const 0)
   (i32.const 7)
   (i32.const 38)
  )
 )
)
(module
 ;; we can't optimize on an imported memory without zeroFilledMemory being set.
 ;; CHECK:      (import "env" "memory" (memory $0 1 1))
 (import "env" "memory" (memory $0 1 1))
 (data (i32.const 1024) "x")
 (data (i32.const 2048) "\00")
)
;; CHECK:      (data (i32.const 1024) "x")

;; CHECK:      (data (i32.const 2048) "\00")
(module
 ;; we can when not imported
 ;; CHECK:      (memory $0 1 1)
 (memory $0 1 1)
 (data (i32.const 1024) "x")
 (data (i32.const 2048) "\00")
)

;; CHECK:      (data (i32.const 1024) "x")
(module
 ;; Regression test for a bug where referrers were accidentally associated with
 ;; the wrong segments in the presence of unreferenced segments.
 ;; CHECK:      (type $none_=>_none (func))

 ;; CHECK:      (memory $0 (shared 1 1))
 (memory $0 (shared 1 1))
 (data (i32.const 0) "")
 ;; CHECK:      (data "foo")
 (data "foo")
 ;; CHECK:      (func $0
 ;; CHECK-NEXT:  (memory.init 0
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $0
  (memory.init 1
   (i32.const 0)
   (i32.const 1)
   (i32.const 1)
  )
 )
)
