/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:31:51 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.IOException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class ReadOnlyEmblStreamFeature_ESTest extends ReadOnlyEmblStreamFeature_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      Key key0 = new Key("");
      QualifierVector qualifierVector0 = new QualifierVector();
      qualifierVector0.add((Qualifier) null);
      ReadOnlyEmblStreamFeature readOnlyEmblStreamFeature0 = null;
      try {
        readOnlyEmblStreamFeature0 = new ReadOnlyEmblStreamFeature(key0, (Location) null, qualifierVector0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(3121, 3121);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      ReadOnlyEmblStreamFeature readOnlyEmblStreamFeature0 = new ReadOnlyEmblStreamFeature(key0, location0, qualifierVector0);
      Qualifier qualifier0 = new Qualifier(")g[a?", "{Q E");
      try { 
        readOnlyEmblStreamFeature0.addQualifierValues(qualifier0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      Range range0 = new Range(3121, 3121);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      ReadOnlyEmblStreamFeature readOnlyEmblStreamFeature0 = new ReadOnlyEmblStreamFeature(key0, location0, qualifierVector0);
      try { 
        readOnlyEmblStreamFeature0.removeQualiferByName("*?4-}1WLs{5b_");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      Key key0 = new Key((String) null);
      QualifierVector qualifierVector0 = new QualifierVector();
      ReadOnlyEmblStreamFeature readOnlyEmblStreamFeature0 = new ReadOnlyEmblStreamFeature(key0, (Location) null, qualifierVector0);
      Qualifier qualifier0 = new Qualifier((String) null, "ISoM*h%V)P'j");
      try { 
        readOnlyEmblStreamFeature0.setQualifier(qualifier0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      Key key0 = Key.CDS;
      QualifierVector qualifierVector0 = new QualifierVector();
      ReadOnlyEmblStreamFeature readOnlyEmblStreamFeature0 = new ReadOnlyEmblStreamFeature(key0, (Location) null, qualifierVector0);
      try { 
        readOnlyEmblStreamFeature0.setLocation((Location) null);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      Key key0 = new Key("", false);
      QualifierVector qualifierVector0 = new QualifierVector();
      ReadOnlyEmblStreamFeature readOnlyEmblStreamFeature0 = new ReadOnlyEmblStreamFeature(key0, (Location) null, qualifierVector0);
      try { 
        readOnlyEmblStreamFeature0.setKey(key0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      Key key0 = Key.CDS;
      QualifierVector qualifierVector0 = new QualifierVector();
      ReadOnlyEmblStreamFeature readOnlyEmblStreamFeature0 = new ReadOnlyEmblStreamFeature(key0, (Location) null, qualifierVector0);
      try { 
        readOnlyEmblStreamFeature0.set(key0, (Location) null, (QualifierVector) null);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      QualifierVector qualifierVector0 = new QualifierVector();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((EntryInformation) null);
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      ReadOnlyEmblStreamFeature readOnlyEmblStreamFeature0 = new ReadOnlyEmblStreamFeature(key0, (Location) null, qualifierVector0);
      try { 
        readOnlyEmblStreamFeature0.setDocumentEntry(mSPcrunchDocumentEntry0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      Key key0 = new Key("");
      QualifierVector qualifierVector0 = new QualifierVector();
      ReadOnlyEmblStreamFeature readOnlyEmblStreamFeature0 = new ReadOnlyEmblStreamFeature(key0, (Location) null, qualifierVector0);
      try { 
        readOnlyEmblStreamFeature0.setQualifiers(qualifierVector0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature", e);
      }
  }
}
