/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.sdb.sql;

import org.apache.jena.sdb.SDBException ;

public enum SAPStorageType
{
    row       { @Override public String getStorageName() { return "ROW" ; } } ,
    column    { @Override public String getStorageName() { return "COLUMN" ; } } ,
    ;
    abstract public String getStorageName() ;
    
    public static SAPStorageType convert(String storageName)
    {
        if ( check(storageName, row) )  return row ;
        if ( check(storageName, column) )   return column ;
        throw new SDBException("Can't turn '"+storageName+"' into a storage type") ; 
    }
    
    private static boolean check(String storageName, SAPStorageType t)
    { return  storageName.equalsIgnoreCase(t.getStorageName()) ; }
}
