/* Copyright (C) 2005  Ole André Vadla Ravnås <oleavr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include "mimic-private.h"

guchar _col_zag[64] = {
     0,  8,  1,  2,  9, 16, 24, 17,
    10,  3,  4, 11, 18, 25, 32, 40,
    33, 26, 19, 12,  5,  6, 13, 20,
    27, 34, 41, 48, 56, 49, 42, 35,
    28, 21, 14,  7, 15, 22, 29, 36,
    43, 50, 57, 58, 51, 44, 37, 30,
    23, 31, 38, 45, 52, 59, 39, 46,
    53, 60, 61, 54, 47, 55, 62, 63
};

VlcSymbol _vlc_alphabet[16][128] = {

    /*
     * base alphabet - no zeroes prefixed
     */
    {
        {  3,        0x1, 0,    0 },   {  4,        0x7, 0,    0 },
        {  4,        0x5, 0,    0 },   {  6,       0x27, 0,    0 },
        {  6,       0x25, 0,    0 },   {  6,       0x23, 0,    0 },
        {  6,       0x21, 0,    0 },   {  8,       0xcf, 0,    0 },
        {  8,       0xcd, 0,    0 },   {  8,       0xcb, 0,    0 },
        {  8,       0xc9, 0,    0 },   {  8,       0xc7, 0,    0 },
        {  8,       0xc5, 0,    0 },   {  8,       0xc3, 0,    0 },
        {  8,       0xc1, 0,    0 },   { 10,      0x35f, 0,    0 },
        { 10,      0x35d, 0,    0 },   { 10,      0x35b, 0,    0 },
        { 10,      0x359, 0,    0 },   { 10,      0x357, 0,    0 },
        { 10,      0x355, 0,    0 },   { 10,      0x353, 0,    0 },
        { 10,      0x351, 0,    0 },   { 10,      0x34f, 0,    0 },
        { 10,      0x34d, 0,    0 },   { 10,      0x34b, 0,    0 },
        { 10,      0x349, 0,    0 },   { 10,      0x347, 0,    0 },
        { 10,      0x345, 0,    0 },   { 10,      0x343, 0,    0 },
        { 10,      0x341, 0,    0 },   { 12,      0xeff, 0,    0 },
        { 12,      0xefd, 0,    0 },   { 12,      0xefb, 0,    0 },
        { 12,      0xef9, 0,    0 },   { 12,      0xef7, 0,    0 },
        { 12,      0xef5, 0,    0 },   { 12,      0xef3, 0,    0 },
        { 12,      0xef1, 0,    0 },   { 12,      0xeef, 0,    0 },
        { 12,      0xeed, 0,    0 },   { 12,      0xeeb, 0,    0 },
        { 12,      0xee9, 0,    0 },   { 12,      0xee7, 0,    0 },
        { 12,      0xee5, 0,    0 },   { 12,      0xee3, 0,    0 },
        { 12,      0xee1, 0,    0 },   { 12,      0xedf, 0,    0 },
        { 12,      0xedd, 0,    0 },   { 12,      0xedb, 0,    0 },
        { 12,      0xed9, 0,    0 },   { 12,      0xed7, 0,    0 },
        { 12,      0xed5, 0,    0 },   { 12,      0xed3, 0,    0 },
        { 12,      0xed1, 0,    0 },   { 12,      0xecf, 0,    0 },
        { 12,      0xecd, 0,    0 },   { 12,      0xecb, 0,    0 },
        { 12,      0xec9, 0,    0 },   { 12,      0xec7, 0,    0 },
        { 12,      0xec5, 0,    0 },   { 12,      0xec3, 0,    0 },
        { 12,      0xec1, 0,    0 },   { 17,    0x1fd7f, 0,    0 },
        { 17,    0x1fd7d, 0,    0 },   { 17,    0x1fd7b, 0,    0 },
        { 17,    0x1fd79, 0,    0 },   { 17,    0x1fd77, 0,    0 },
        { 17,    0x1fd75, 0,    0 },   { 17,    0x1fd73, 0,    0 },
        { 17,    0x1fd71, 0,    0 },   { 17,    0x1fd6f, 0,    0 },
        { 17,    0x1fd6d, 0,    0 },   { 17,    0x1fd6b, 0,    0 },
        { 17,    0x1fd69, 0,    0 },   { 17,    0x1fd67, 0,    0 },
        { 17,    0x1fd65, 0,    0 },   { 17,    0x1fd63, 0,    0 },
        { 17,    0x1fd61, 0,    0 },   { 17,    0x1fd5f, 0,    0 },
        { 17,    0x1fd5d, 0,    0 },   { 17,    0x1fd5b, 0,    0 },
        { 17,    0x1fd59, 0,    0 },   { 17,    0x1fd57, 0,    0 },
        { 17,    0x1fd55, 0,    0 },   { 17,    0x1fd53, 0,    0 },
        { 17,    0x1fd51, 0,    0 },   { 17,    0x1fd4f, 0,    0 },
        { 17,    0x1fd4d, 0,    0 },   { 17,    0x1fd4b, 0,    0 },
        { 17,    0x1fd49, 0,    0 },   { 17,    0x1fd47, 0,    0 },
        { 17,    0x1fd45, 0,    0 },   { 17,    0x1fd43, 0,    0 },
        { 17,    0x1fd41, 0,    0 },   { 17,    0x1fd3f, 0,    0 },
        { 17,    0x1fd3d, 0,    0 },   { 17,    0x1fd3b, 0,    0 },
        { 17,    0x1fd39, 0,    0 },   { 17,    0x1fd37, 0,    0 },
        { 17,    0x1fd35, 0,    0 },   { 17,    0x1fd33, 0,    0 },
        { 17,    0x1fd31, 0,    0 },   { 17,    0x1fd2f, 0,    0 },
        { 17,    0x1fd2d, 0,    0 },   { 17,    0x1fd2b, 0,    0 },
        { 17,    0x1fd29, 0,    0 },   { 17,    0x1fd27, 0,    0 },
        { 17,    0x1fd25, 0,    0 },   { 17,    0x1fd23, 0,    0 },
        { 17,    0x1fd21, 0,    0 },   { 17,    0x1fd1f, 0,    0 },
        { 17,    0x1fd1d, 0,    0 },   { 17,    0x1fd1b, 0,    0 },
        { 17,    0x1fd19, 0,    0 },   { 17,    0x1fd17, 0,    0 },
        { 17,    0x1fd15, 0,    0 },   { 17,    0x1fd13, 0,    0 },
        { 17,    0x1fd11, 0,    0 },   { 17,    0x1fd0f, 0,    0 },
        { 17,    0x1fd0d, 0,    0 },   { 17,    0x1fd0b, 0,    0 },
        { 17,    0x1fd09, 0,    0 },   { 17,    0x1fd07, 0,    0 },
        { 17,    0x1fd05, 0,    0 },   { 17,    0x1fd03, 0,    0 },
        { 17,    0x1fd01, 0,    0 },   { 17,    0x1fd01, 0,    0 }
    },

    /*
     * prefixed with 1 zero
     */
    {
        {  5,       0x17, 0,    0 },   {  8,       0xe7, 0,    0 },
        {  8,       0xe5, 0,    0 },   {  9,      0x1d7, 0,    0 },
        {  9,      0x1d5, 0,    0 },   {  9,      0x1d3, 0,    0 },
        {  9,      0x1d1, 0,    0 },   { 12,      0xf8f, 0,    0 },
        { 12,      0xf8d, 0,    0 },   { 12,      0xf8b, 0,    0 },
        { 12,      0xf89, 0,    0 },   { 12,      0xf87, 0,    0 },
        { 12,      0xf85, 0,    0 },   { 12,      0xf83, 0,    0 },
        { 12,      0xf81, 0,    0 },   { 15,     0x7f1f, 0,    0 },
        { 15,     0x7f1d, 0,    0 },   { 15,     0x7f1b, 0,    0 },
        { 15,     0x7f19, 0,    0 },   { 15,     0x7f17, 0,    0 },
        { 15,     0x7f15, 0,    0 },   { 15,     0x7f13, 0,    0 },
        { 15,     0x7f11, 0,    0 },   { 15,     0x7f0f, 0,    0 },
        { 15,     0x7f0d, 0,    0 },   { 15,     0x7f0b, 0,    0 },
        { 15,     0x7f09, 0,    0 },   { 15,     0x7f07, 0,    0 },
        { 15,     0x7f05, 0,    0 },   { 15,     0x7f03, 0,    0 },
        { 15,     0x7f01, 0,    0 },   { 16,     0xfe7f, 0,    0 },
        { 16,     0xfe7d, 0,    0 },   { 16,     0xfe7b, 0,    0 },
        { 16,     0xfe79, 0,    0 },   { 16,     0xfe77, 0,    0 },
        { 16,     0xfe75, 0,    0 },   { 16,     0xfe73, 0,    0 },
        { 16,     0xfe71, 0,    0 },   { 16,     0xfe6f, 0,    0 },
        { 16,     0xfe6d, 0,    0 },   { 16,     0xfe6b, 0,    0 },
        { 16,     0xfe69, 0,    0 },   { 16,     0xfe67, 0,    0 },
        { 16,     0xfe65, 0,    0 },   { 16,     0xfe63, 0,    0 },
        { 16,     0xfe61, 0,    0 },   { 16,     0xfe5f, 0,    0 },
        { 16,     0xfe5d, 0,    0 },   { 16,     0xfe5b, 0,    0 },
        { 16,     0xfe59, 0,    0 },   { 16,     0xfe57, 0,    0 },
        { 16,     0xfe55, 0,    0 },   { 16,     0xfe53, 0,    0 },
        { 16,     0xfe51, 0,    0 },   { 16,     0xfe4f, 0,    0 },
        { 16,     0xfe4d, 0,    0 },   { 16,     0xfe4b, 0,    0 },
        { 16,     0xfe49, 0,    0 },   { 16,     0xfe47, 0,    0 },
        { 16,     0xfe45, 0,    0 },   { 16,     0xfe43, 0,    0 },
        { 16,     0xfe41, 0,    0 },   { 27,  0x7fffff9, 7, 0x7f },
        { 27,  0x7fffff9, 7, 0x7d },   { 27,  0x7fffff9, 7, 0x7b },
        { 27,  0x7fffff9, 7, 0x79 },   { 27,  0x7fffff9, 7, 0x77 },
        { 27,  0x7fffff9, 7, 0x75 },   { 27,  0x7fffff9, 7, 0x73 },
        { 27,  0x7fffff9, 7, 0x71 },   { 27,  0x7fffff9, 7, 0x6f },
        { 27,  0x7fffff9, 7, 0x6d },   { 27,  0x7fffff9, 7, 0x6b },
        { 27,  0x7fffff9, 7, 0x69 },   { 27,  0x7fffff9, 7, 0x67 },
        { 27,  0x7fffff9, 7, 0x65 },   { 27,  0x7fffff9, 7, 0x63 },
        { 27,  0x7fffff9, 7, 0x61 },   { 27,  0x7fffff9, 7, 0x5f },
        { 27,  0x7fffff9, 7, 0x5d },   { 27,  0x7fffff9, 7, 0x5b },
        { 27,  0x7fffff9, 7, 0x59 },   { 27,  0x7fffff9, 7, 0x57 },
        { 27,  0x7fffff9, 7, 0x55 },   { 27,  0x7fffff9, 7, 0x53 },
        { 27,  0x7fffff9, 7, 0x51 },   { 27,  0x7fffff9, 7, 0x4f },
        { 27,  0x7fffff9, 7, 0x4d },   { 27,  0x7fffff9, 7, 0x4b },
        { 27,  0x7fffff9, 7, 0x49 },   { 27,  0x7fffff9, 7, 0x47 },
        { 27,  0x7fffff9, 7, 0x45 },   { 27,  0x7fffff9, 7, 0x43 },
        { 27,  0x7fffff9, 7, 0x41 },   { 27,  0x7fffff9, 7, 0x3f },
        { 27,  0x7fffff9, 7, 0x3d },   { 27,  0x7fffff9, 7, 0x3b },
        { 27,  0x7fffff9, 7, 0x39 },   { 27,  0x7fffff9, 7, 0x37 },
        { 27,  0x7fffff9, 7, 0x35 },   { 27,  0x7fffff9, 7, 0x33 },
        { 27,  0x7fffff9, 7, 0x31 },   { 27,  0x7fffff9, 7, 0x2f },
        { 27,  0x7fffff9, 7, 0x2d },   { 27,  0x7fffff9, 7, 0x2b },
        { 27,  0x7fffff9, 7, 0x29 },   { 27,  0x7fffff9, 7, 0x27 },
        { 27,  0x7fffff9, 7, 0x25 },   { 27,  0x7fffff9, 7, 0x23 },
        { 27,  0x7fffff9, 7, 0x21 },   { 27,  0x7fffff9, 7, 0x1f },
        { 27,  0x7fffff9, 7, 0x1d },   { 27,  0x7fffff9, 7, 0x1b },
        { 27,  0x7fffff9, 7, 0x19 },   { 27,  0x7fffff9, 7, 0x17 },
        { 27,  0x7fffff9, 7, 0x15 },   { 27,  0x7fffff9, 7, 0x13 },
        { 27,  0x7fffff9, 7, 0x11 },   { 27,  0x7fffff9, 7,  0xf },
        { 27,  0x7fffff9, 7,  0xd },   { 27,  0x7fffff9, 7,  0xb },
        { 27,  0x7fffff9, 7,  0x9 },   { 27,  0x7fffff9, 7,  0x7 },
        { 27,  0x7fffff9, 7,  0x5 },   { 27,  0x7fffff9, 7,  0x3 },
        { 27,  0x7fffff9, 7,  0x1 },   { 27,  0x7fffff9, 7,  0x1 }
    },

    /*
     * prefixed with 2 zeroes
     */
    {
        {  6,       0x37, 0,    0 },   {  9,      0x1ef, 0,    0 },
        {  9,      0x1ed, 0,    0 },   { 12,      0xfd7, 0,    0 },
        { 12,      0xfd5, 0,    0 },   { 12,      0xfd3, 0,    0 },
        { 12,      0xfd1, 0,    0 },   { 13,     0x1fbf, 0,    0 },
        { 13,     0x1fbd, 0,    0 },   { 13,     0x1fbb, 0,    0 },
        { 13,     0x1fb9, 0,    0 },   { 13,     0x1fb7, 0,    0 },
        { 13,     0x1fb5, 0,    0 },   { 13,     0x1fb3, 0,    0 },
        { 13,     0x1fb1, 0,    0 },   { 25,  0x1ffff7f, 0,    0 },
        { 25,  0x1ffff7d, 0,    0 },   { 25,  0x1ffff7b, 0,    0 },
        { 25,  0x1ffff79, 0,    0 },   { 25,  0x1ffff77, 0,    0 },
        { 25,  0x1ffff75, 0,    0 },   { 25,  0x1ffff73, 0,    0 },
        { 25,  0x1ffff71, 0,    0 },   { 25,  0x1ffff6f, 0,    0 },
        { 25,  0x1ffff6d, 0,    0 },   { 25,  0x1ffff6b, 0,    0 },
        { 25,  0x1ffff69, 0,    0 },   { 25,  0x1ffff67, 0,    0 },
        { 25,  0x1ffff65, 0,    0 },   { 25,  0x1ffff63, 0,    0 },
        { 25,  0x1ffff61, 0,    0 },   { 30, 0x3ffffe3f, 0,    0 },
        { 30, 0x3ffffe3d, 0,    0 },   { 30, 0x3ffffe3b, 0,    0 },
        { 30, 0x3ffffe39, 0,    0 },   { 30, 0x3ffffe37, 0,    0 },
        { 30, 0x3ffffe35, 0,    0 },   { 30, 0x3ffffe33, 0,    0 },
        { 30, 0x3ffffe31, 0,    0 },   { 30, 0x3ffffe2f, 0,    0 },
        { 30, 0x3ffffe2d, 0,    0 },   { 30, 0x3ffffe2b, 0,    0 },
        { 30, 0x3ffffe29, 0,    0 },   { 30, 0x3ffffe27, 0,    0 },
        { 30, 0x3ffffe25, 0,    0 },   { 30, 0x3ffffe23, 0,    0 },
        { 30, 0x3ffffe21, 0,    0 },   { 30, 0x3ffffe1f, 0,    0 },
        { 30, 0x3ffffe1d, 0,    0 },   { 30, 0x3ffffe1b, 0,    0 },
        { 30, 0x3ffffe19, 0,    0 },   { 30, 0x3ffffe17, 0,    0 },
        { 30, 0x3ffffe15, 0,    0 },   { 30, 0x3ffffe13, 0,    0 },
        { 30, 0x3ffffe11, 0,    0 },   { 30, 0x3ffffe0f, 0,    0 },
        { 30, 0x3ffffe0d, 0,    0 },   { 30, 0x3ffffe0b, 0,    0 },
        { 30, 0x3ffffe09, 0,    0 },   { 30, 0x3ffffe07, 0,    0 },
        { 30, 0x3ffffe05, 0,    0 },   { 30, 0x3ffffe03, 0,    0 },
        { 30, 0x3ffffe01, 0,    0 },   { 27,  0x7fffffa, 7, 0x7f },
        { 27,  0x7fffffa, 7, 0x7d },   { 27,  0x7fffffa, 7, 0x7b },
        { 27,  0x7fffffa, 7, 0x79 },   { 27,  0x7fffffa, 7, 0x77 },
        { 27,  0x7fffffa, 7, 0x75 },   { 27,  0x7fffffa, 7, 0x73 },
        { 27,  0x7fffffa, 7, 0x71 },   { 27,  0x7fffffa, 7, 0x6f },
        { 27,  0x7fffffa, 7, 0x6d },   { 27,  0x7fffffa, 7, 0x6b },
        { 27,  0x7fffffa, 7, 0x69 },   { 27,  0x7fffffa, 7, 0x67 },
        { 27,  0x7fffffa, 7, 0x65 },   { 27,  0x7fffffa, 7, 0x63 },
        { 27,  0x7fffffa, 7, 0x61 },   { 27,  0x7fffffa, 7, 0x5f },
        { 27,  0x7fffffa, 7, 0x5d },   { 27,  0x7fffffa, 7, 0x5b },
        { 27,  0x7fffffa, 7, 0x59 },   { 27,  0x7fffffa, 7, 0x57 },
        { 27,  0x7fffffa, 7, 0x55 },   { 27,  0x7fffffa, 7, 0x53 },
        { 27,  0x7fffffa, 7, 0x51 },   { 27,  0x7fffffa, 7, 0x4f },
        { 27,  0x7fffffa, 7, 0x4d },   { 27,  0x7fffffa, 7, 0x4b },
        { 27,  0x7fffffa, 7, 0x49 },   { 27,  0x7fffffa, 7, 0x47 },
        { 27,  0x7fffffa, 7, 0x45 },   { 27,  0x7fffffa, 7, 0x43 },
        { 27,  0x7fffffa, 7, 0x41 },   { 27,  0x7fffffa, 7, 0x3f },
        { 27,  0x7fffffa, 7, 0x3d },   { 27,  0x7fffffa, 7, 0x3b },
        { 27,  0x7fffffa, 7, 0x39 },   { 27,  0x7fffffa, 7, 0x37 },
        { 27,  0x7fffffa, 7, 0x35 },   { 27,  0x7fffffa, 7, 0x33 },
        { 27,  0x7fffffa, 7, 0x31 },   { 27,  0x7fffffa, 7, 0x2f },
        { 27,  0x7fffffa, 7, 0x2d },   { 27,  0x7fffffa, 7, 0x2b },
        { 27,  0x7fffffa, 7, 0x29 },   { 27,  0x7fffffa, 7, 0x27 },
        { 27,  0x7fffffa, 7, 0x25 },   { 27,  0x7fffffa, 7, 0x23 },
        { 27,  0x7fffffa, 7, 0x21 },   { 27,  0x7fffffa, 7, 0x1f },
        { 27,  0x7fffffa, 7, 0x1d },   { 27,  0x7fffffa, 7, 0x1b },
        { 27,  0x7fffffa, 7, 0x19 },   { 27,  0x7fffffa, 7, 0x17 },
        { 27,  0x7fffffa, 7, 0x15 },   { 27,  0x7fffffa, 7, 0x13 },
        { 27,  0x7fffffa, 7, 0x11 },   { 27,  0x7fffffa, 7,  0xf },
        { 27,  0x7fffffa, 7,  0xd },   { 27,  0x7fffffa, 7,  0xb },
        { 27,  0x7fffffa, 7,  0x9 },   { 27,  0x7fffffa, 7,  0x7 },
        { 27,  0x7fffffa, 7,  0x5 },   { 27,  0x7fffffa, 7,  0x3 },
        { 27,  0x7fffffa, 7,  0x1 },   { 27,  0x7fffffa, 7,  0x1 }
    },

    /*
     * prefixed with 3 zeroes
     */
    {
        {  7,       0x71, 0,    0 },   { 10,      0x3ef, 0,    0 },
        { 10,      0x3ed, 0,    0 },   { 17,    0x1ffdf, 0,    0 },
        { 17,    0x1ffdd, 0,    0 },   { 17,    0x1ffdb, 0,    0 },
        { 17,    0x1ffd9, 0,    0 },   { 21,   0x1fffbf, 0,    0 },
        { 21,   0x1fffbd, 0,    0 },   { 21,   0x1fffbb, 0,    0 },
        { 21,   0x1fffb9, 0,    0 },   { 21,   0x1fffb7, 0,    0 },
        { 21,   0x1fffb5, 0,    0 },   { 21,   0x1fffb3, 0,    0 },
        { 21,   0x1fffb1, 0,    0 },   { 26,  0x3ffff1f, 0,    0 },
        { 26,  0x3ffff1d, 0,    0 },   { 26,  0x3ffff1b, 0,    0 },
        { 26,  0x3ffff19, 0,    0 },   { 26,  0x3ffff17, 0,    0 },
        { 26,  0x3ffff15, 0,    0 },   { 26,  0x3ffff13, 0,    0 },
        { 26,  0x3ffff11, 0,    0 },   { 26,  0x3ffff0f, 0,    0 },
        { 26,  0x3ffff0d, 0,    0 },   { 26,  0x3ffff0b, 0,    0 },
        { 26,  0x3ffff09, 0,    0 },   { 26,  0x3ffff07, 0,    0 },
        { 26,  0x3ffff05, 0,    0 },   { 26,  0x3ffff03, 0,    0 },
        { 26,  0x3ffff01, 0,    0 },   { 30, 0x3ffffe7f, 0,    0 },
        { 30, 0x3ffffe7d, 0,    0 },   { 30, 0x3ffffe7b, 0,    0 },
        { 30, 0x3ffffe79, 0,    0 },   { 30, 0x3ffffe77, 0,    0 },
        { 30, 0x3ffffe75, 0,    0 },   { 30, 0x3ffffe73, 0,    0 },
        { 30, 0x3ffffe71, 0,    0 },   { 30, 0x3ffffe6f, 0,    0 },
        { 30, 0x3ffffe6d, 0,    0 },   { 30, 0x3ffffe6b, 0,    0 },
        { 30, 0x3ffffe69, 0,    0 },   { 30, 0x3ffffe67, 0,    0 },
        { 30, 0x3ffffe65, 0,    0 },   { 30, 0x3ffffe63, 0,    0 },
        { 30, 0x3ffffe61, 0,    0 },   { 30, 0x3ffffe5f, 0,    0 },
        { 30, 0x3ffffe5d, 0,    0 },   { 30, 0x3ffffe5b, 0,    0 },
        { 30, 0x3ffffe59, 0,    0 },   { 30, 0x3ffffe57, 0,    0 },
        { 30, 0x3ffffe55, 0,    0 },   { 30, 0x3ffffe53, 0,    0 },
        { 30, 0x3ffffe51, 0,    0 },   { 30, 0x3ffffe4f, 0,    0 },
        { 30, 0x3ffffe4d, 0,    0 },   { 30, 0x3ffffe4b, 0,    0 },
        { 30, 0x3ffffe49, 0,    0 },   { 30, 0x3ffffe47, 0,    0 },
        { 30, 0x3ffffe45, 0,    0 },   { 30, 0x3ffffe43, 0,    0 },
        { 30, 0x3ffffe41, 0,    0 },   { 27,  0x7fffffb, 7, 0x7f },
        { 27,  0x7fffffb, 7, 0x7d },   { 27,  0x7fffffb, 7, 0x7b },
        { 27,  0x7fffffb, 7, 0x79 },   { 27,  0x7fffffb, 7, 0x77 },
        { 27,  0x7fffffb, 7, 0x75 },   { 27,  0x7fffffb, 7, 0x73 },
        { 27,  0x7fffffb, 7, 0x71 },   { 27,  0x7fffffb, 7, 0x6f },
        { 27,  0x7fffffb, 7, 0x6d },   { 27,  0x7fffffb, 7, 0x6b },
        { 27,  0x7fffffb, 7, 0x69 },   { 27,  0x7fffffb, 7, 0x67 },
        { 27,  0x7fffffb, 7, 0x65 },   { 27,  0x7fffffb, 7, 0x63 },
        { 27,  0x7fffffb, 7, 0x61 },   { 27,  0x7fffffb, 7, 0x5f },
        { 27,  0x7fffffb, 7, 0x5d },   { 27,  0x7fffffb, 7, 0x5b },
        { 27,  0x7fffffb, 7, 0x59 },   { 27,  0x7fffffb, 7, 0x57 },
        { 27,  0x7fffffb, 7, 0x55 },   { 27,  0x7fffffb, 7, 0x53 },
        { 27,  0x7fffffb, 7, 0x51 },   { 27,  0x7fffffb, 7, 0x4f },
        { 27,  0x7fffffb, 7, 0x4d },   { 27,  0x7fffffb, 7, 0x4b },
        { 27,  0x7fffffb, 7, 0x49 },   { 27,  0x7fffffb, 7, 0x47 },
        { 27,  0x7fffffb, 7, 0x45 },   { 27,  0x7fffffb, 7, 0x43 },
        { 27,  0x7fffffb, 7, 0x41 },   { 27,  0x7fffffb, 7, 0x3f },
        { 27,  0x7fffffb, 7, 0x3d },   { 27,  0x7fffffb, 7, 0x3b },
        { 27,  0x7fffffb, 7, 0x39 },   { 27,  0x7fffffb, 7, 0x37 },
        { 27,  0x7fffffb, 7, 0x35 },   { 27,  0x7fffffb, 7, 0x33 },
        { 27,  0x7fffffb, 7, 0x31 },   { 27,  0x7fffffb, 7, 0x2f },
        { 27,  0x7fffffb, 7, 0x2d },   { 27,  0x7fffffb, 7, 0x2b },
        { 27,  0x7fffffb, 7, 0x29 },   { 27,  0x7fffffb, 7, 0x27 },
        { 27,  0x7fffffb, 7, 0x25 },   { 27,  0x7fffffb, 7, 0x23 },
        { 27,  0x7fffffb, 7, 0x21 },   { 27,  0x7fffffb, 7, 0x1f },
        { 27,  0x7fffffb, 7, 0x1d },   { 27,  0x7fffffb, 7, 0x1b },
        { 27,  0x7fffffb, 7, 0x19 },   { 27,  0x7fffffb, 7, 0x17 },
        { 27,  0x7fffffb, 7, 0x15 },   { 27,  0x7fffffb, 7, 0x13 },
        { 27,  0x7fffffb, 7, 0x11 },   { 27,  0x7fffffb, 7,  0xf },
        { 27,  0x7fffffb, 7,  0xd },   { 27,  0x7fffffb, 7,  0xb },
        { 27,  0x7fffffb, 7,  0x9 },   { 27,  0x7fffffb, 7,  0x7 },
        { 27,  0x7fffffb, 7,  0x5 },   { 27,  0x7fffffb, 7,  0x3 },
        { 27,  0x7fffffb, 7,  0x1 },   { 27,  0x7fffffb, 7,  0x1 }
    },

    /*
     * prefixed with 4 zeroes
     */
    {
        {  8,       0xf1, 0,    0 },   { 11,      0x7e3, 0,    0 },
        { 11,      0x7e1, 0,    0 },   { 18,    0x3ffc7, 0,    0 },
        { 18,    0x3ffc5, 0,    0 },   { 18,    0x3ffc3, 0,    0 },
        { 18,    0x3ffc1, 0,    0 },   { 22,   0x3fff8f, 0,    0 },
        { 22,   0x3fff8d, 0,    0 },   { 22,   0x3fff8b, 0,    0 },
        { 22,   0x3fff89, 0,    0 },   { 22,   0x3fff87, 0,    0 },
        { 22,   0x3fff85, 0,    0 },   { 22,   0x3fff83, 0,    0 },
        { 22,   0x3fff81, 0,    0 },   { 26,  0x3ffff3f, 0,    0 },
        { 26,  0x3ffff3d, 0,    0 },   { 26,  0x3ffff3b, 0,    0 },
        { 26,  0x3ffff39, 0,    0 },   { 26,  0x3ffff37, 0,    0 },
        { 26,  0x3ffff35, 0,    0 },   { 26,  0x3ffff33, 0,    0 },
        { 26,  0x3ffff31, 0,    0 },   { 26,  0x3ffff2f, 0,    0 },
        { 26,  0x3ffff2d, 0,    0 },   { 26,  0x3ffff2b, 0,    0 },
        { 26,  0x3ffff29, 0,    0 },   { 26,  0x3ffff27, 0,    0 },
        { 26,  0x3ffff25, 0,    0 },   { 26,  0x3ffff23, 0,    0 },
        { 26,  0x3ffff21, 0,    0 },   { 30, 0x3ffffebf, 0,    0 },
        { 30, 0x3ffffebd, 0,    0 },   { 30, 0x3ffffebb, 0,    0 },
        { 30, 0x3ffffeb9, 0,    0 },   { 30, 0x3ffffeb7, 0,    0 },
        { 30, 0x3ffffeb5, 0,    0 },   { 30, 0x3ffffeb3, 0,    0 },
        { 30, 0x3ffffeb1, 0,    0 },   { 30, 0x3ffffeaf, 0,    0 },
        { 30, 0x3ffffead, 0,    0 },   { 30, 0x3ffffeab, 0,    0 },
        { 30, 0x3ffffea9, 0,    0 },   { 30, 0x3ffffea7, 0,    0 },
        { 30, 0x3ffffea5, 0,    0 },   { 30, 0x3ffffea3, 0,    0 },
        { 30, 0x3ffffea1, 0,    0 },   { 30, 0x3ffffe9f, 0,    0 },
        { 30, 0x3ffffe9d, 0,    0 },   { 30, 0x3ffffe9b, 0,    0 },
        { 30, 0x3ffffe99, 0,    0 },   { 30, 0x3ffffe97, 0,    0 },
        { 30, 0x3ffffe95, 0,    0 },   { 30, 0x3ffffe93, 0,    0 },
        { 30, 0x3ffffe91, 0,    0 },   { 30, 0x3ffffe8f, 0,    0 },
        { 30, 0x3ffffe8d, 0,    0 },   { 30, 0x3ffffe8b, 0,    0 },
        { 30, 0x3ffffe89, 0,    0 },   { 30, 0x3ffffe87, 0,    0 },
        { 30, 0x3ffffe85, 0,    0 },   { 30, 0x3ffffe83, 0,    0 },
        { 30, 0x3ffffe81, 0,    0 },   { 28,  0xffffff8, 7, 0x7f },
        { 28,  0xffffff8, 7, 0x7d },   { 28,  0xffffff8, 7, 0x7b },
        { 28,  0xffffff8, 7, 0x79 },   { 28,  0xffffff8, 7, 0x77 },
        { 28,  0xffffff8, 7, 0x75 },   { 28,  0xffffff8, 7, 0x73 },
        { 28,  0xffffff8, 7, 0x71 },   { 28,  0xffffff8, 7, 0x6f },
        { 28,  0xffffff8, 7, 0x6d },   { 28,  0xffffff8, 7, 0x6b },
        { 28,  0xffffff8, 7, 0x69 },   { 28,  0xffffff8, 7, 0x67 },
        { 28,  0xffffff8, 7, 0x65 },   { 28,  0xffffff8, 7, 0x63 },
        { 28,  0xffffff8, 7, 0x61 },   { 28,  0xffffff8, 7, 0x5f },
        { 28,  0xffffff8, 7, 0x5d },   { 28,  0xffffff8, 7, 0x5b },
        { 28,  0xffffff8, 7, 0x59 },   { 28,  0xffffff8, 7, 0x57 },
        { 28,  0xffffff8, 7, 0x55 },   { 28,  0xffffff8, 7, 0x53 },
        { 28,  0xffffff8, 7, 0x51 },   { 28,  0xffffff8, 7, 0x4f },
        { 28,  0xffffff8, 7, 0x4d },   { 28,  0xffffff8, 7, 0x4b },
        { 28,  0xffffff8, 7, 0x49 },   { 28,  0xffffff8, 7, 0x47 },
        { 28,  0xffffff8, 7, 0x45 },   { 28,  0xffffff8, 7, 0x43 },
        { 28,  0xffffff8, 7, 0x41 },   { 28,  0xffffff8, 7, 0x3f },
        { 28,  0xffffff8, 7, 0x3d },   { 28,  0xffffff8, 7, 0x3b },
        { 28,  0xffffff8, 7, 0x39 },   { 28,  0xffffff8, 7, 0x37 },
        { 28,  0xffffff8, 7, 0x35 },   { 28,  0xffffff8, 7, 0x33 },
        { 28,  0xffffff8, 7, 0x31 },   { 28,  0xffffff8, 7, 0x2f },
        { 28,  0xffffff8, 7, 0x2d },   { 28,  0xffffff8, 7, 0x2b },
        { 28,  0xffffff8, 7, 0x29 },   { 28,  0xffffff8, 7, 0x27 },
        { 28,  0xffffff8, 7, 0x25 },   { 28,  0xffffff8, 7, 0x23 },
        { 28,  0xffffff8, 7, 0x21 },   { 28,  0xffffff8, 7, 0x1f },
        { 28,  0xffffff8, 7, 0x1d },   { 28,  0xffffff8, 7, 0x1b },
        { 28,  0xffffff8, 7, 0x19 },   { 28,  0xffffff8, 7, 0x17 },
        { 28,  0xffffff8, 7, 0x15 },   { 28,  0xffffff8, 7, 0x13 },
        { 28,  0xffffff8, 7, 0x11 },   { 28,  0xffffff8, 7,  0xf },
        { 28,  0xffffff8, 7,  0xd },   { 28,  0xffffff8, 7,  0xb },
        { 28,  0xffffff8, 7,  0x9 },   { 28,  0xffffff8, 7,  0x7 },
        { 28,  0xffffff8, 7,  0x5 },   { 28,  0xffffff8, 7,  0x3 },
        { 28,  0xffffff8, 7,  0x1 },   {  0,          0, 0,    0 }
    },

    /*
     * prefixed with 5 zeroes
     */
    {
        {  8,       0xf3, 0,    0 },   { 11,      0x7e7, 0,    0 },
        { 11,      0x7e5, 0,    0 },   { 18,    0x3ffcf, 0,    0 },
        { 18,    0x3ffcd, 0,    0 },   { 18,    0x3ffcb, 0,    0 },
        { 18,    0x3ffc9, 0,    0 },   { 22,   0x3fff9f, 0,    0 },
        { 22,   0x3fff9d, 0,    0 },   { 22,   0x3fff9b, 0,    0 },
        { 22,   0x3fff99, 0,    0 },   { 22,   0x3fff97, 0,    0 },
        { 22,   0x3fff95, 0,    0 },   { 22,   0x3fff93, 0,    0 },
        { 22,   0x3fff91, 0,    0 },   { 26,  0x3ffff5f, 0,    0 },
        { 26,  0x3ffff5d, 0,    0 },   { 26,  0x3ffff5b, 0,    0 },
        { 26,  0x3ffff59, 0,    0 },   { 26,  0x3ffff57, 0,    0 },
        { 26,  0x3ffff55, 0,    0 },   { 26,  0x3ffff53, 0,    0 },
        { 26,  0x3ffff51, 0,    0 },   { 26,  0x3ffff4f, 0,    0 },
        { 26,  0x3ffff4d, 0,    0 },   { 26,  0x3ffff4b, 0,    0 },
        { 26,  0x3ffff49, 0,    0 },   { 26,  0x3ffff47, 0,    0 },
        { 26,  0x3ffff45, 0,    0 },   { 26,  0x3ffff43, 0,    0 },
        { 26,  0x3ffff41, 0,    0 },   { 30, 0x3ffffeff, 0,    0 },
        { 30, 0x3ffffefd, 0,    0 },   { 30, 0x3ffffefb, 0,    0 },
        { 30, 0x3ffffef9, 0,    0 },   { 30, 0x3ffffef7, 0,    0 },
        { 30, 0x3ffffef5, 0,    0 },   { 30, 0x3ffffef3, 0,    0 },
        { 30, 0x3ffffef1, 0,    0 },   { 30, 0x3ffffeef, 0,    0 },
        { 30, 0x3ffffeed, 0,    0 },   { 30, 0x3ffffeeb, 0,    0 },
        { 30, 0x3ffffee9, 0,    0 },   { 30, 0x3ffffee7, 0,    0 },
        { 30, 0x3ffffee5, 0,    0 },   { 30, 0x3ffffee3, 0,    0 },
        { 30, 0x3ffffee1, 0,    0 },   { 30, 0x3ffffedf, 0,    0 },
        { 30, 0x3ffffedd, 0,    0 },   { 30, 0x3ffffedb, 0,    0 },
        { 30, 0x3ffffed9, 0,    0 },   { 30, 0x3ffffed7, 0,    0 },
        { 30, 0x3ffffed5, 0,    0 },   { 30, 0x3ffffed3, 0,    0 },
        { 30, 0x3ffffed1, 0,    0 },   { 30, 0x3ffffecf, 0,    0 },
        { 30, 0x3ffffecd, 0,    0 },   { 30, 0x3ffffecb, 0,    0 },
        { 30, 0x3ffffec9, 0,    0 },   { 30, 0x3ffffec7, 0,    0 },
        { 30, 0x3ffffec5, 0,    0 },   { 30, 0x3ffffec3, 0,    0 },
        { 30, 0x3ffffec1, 0,    0 },   { 28,  0xffffff9, 7, 0x7f },
        { 28,  0xffffff9, 7, 0x7d },   { 28,  0xffffff9, 7, 0x7b },
        { 28,  0xffffff9, 7, 0x79 },   { 28,  0xffffff9, 7, 0x77 },
        { 28,  0xffffff9, 7, 0x75 },   { 28,  0xffffff9, 7, 0x73 },
        { 28,  0xffffff9, 7, 0x71 },   { 28,  0xffffff9, 7, 0x6f },
        { 28,  0xffffff9, 7, 0x6d },   { 28,  0xffffff9, 7, 0x6b },
        { 28,  0xffffff9, 7, 0x69 },   { 28,  0xffffff9, 7, 0x67 },
        { 28,  0xffffff9, 7, 0x65 },   { 28,  0xffffff9, 7, 0x63 },
        { 28,  0xffffff9, 7, 0x61 },   { 28,  0xffffff9, 7, 0x5f },
        { 28,  0xffffff9, 7, 0x5d },   { 28,  0xffffff9, 7, 0x5b },
        { 28,  0xffffff9, 7, 0x59 },   { 28,  0xffffff9, 7, 0x57 },
        { 28,  0xffffff9, 7, 0x55 },   { 28,  0xffffff9, 7, 0x53 },
        { 28,  0xffffff9, 7, 0x51 },   { 28,  0xffffff9, 7, 0x4f },
        { 28,  0xffffff9, 7, 0x4d },   { 28,  0xffffff9, 7, 0x4b },
        { 28,  0xffffff9, 7, 0x49 },   { 28,  0xffffff9, 7, 0x47 },
        { 28,  0xffffff9, 7, 0x45 },   { 28,  0xffffff9, 7, 0x43 },
        { 28,  0xffffff9, 7, 0x41 },   { 28,  0xffffff9, 7, 0x3f },
        { 28,  0xffffff9, 7, 0x3d },   { 28,  0xffffff9, 7, 0x3b },
        { 28,  0xffffff9, 7, 0x39 },   { 28,  0xffffff9, 7, 0x37 },
        { 28,  0xffffff9, 7, 0x35 },   { 28,  0xffffff9, 7, 0x33 },
        { 28,  0xffffff9, 7, 0x31 },   { 28,  0xffffff9, 7, 0x2f },
        { 28,  0xffffff9, 7, 0x2d },   { 28,  0xffffff9, 7, 0x2b },
        { 28,  0xffffff9, 7, 0x29 },   { 28,  0xffffff9, 7, 0x27 },
        { 28,  0xffffff9, 7, 0x25 },   { 28,  0xffffff9, 7, 0x23 },
        { 28,  0xffffff9, 7, 0x21 },   { 28,  0xffffff9, 7, 0x1f },
        { 28,  0xffffff9, 7, 0x1d },   { 28,  0xffffff9, 7, 0x1b },
        { 28,  0xffffff9, 7, 0x19 },   { 28,  0xffffff9, 7, 0x17 },
        { 28,  0xffffff9, 7, 0x15 },   { 28,  0xffffff9, 7, 0x13 },
        { 28,  0xffffff9, 7, 0x11 },   { 28,  0xffffff9, 7,  0xf },
        { 28,  0xffffff9, 7,  0xd },   { 28,  0xffffff9, 7,  0xb },
        { 28,  0xffffff9, 7,  0x9 },   { 28,  0xffffff9, 7,  0x7 },
        { 28,  0xffffff9, 7,  0x5 },   { 28,  0xffffff9, 7,  0x3 },
        { 28,  0xffffff9, 7,  0x1 },   {  0,          0, 0,    0 }
    },

    /*
     * prefixed with 6 zeroes
     */
    {
        {  8,       0xf5, 0,    0 },   { 14,     0x3feb, 0,    0 },
        { 14,     0x3fe9, 0,    0 },   { 18,    0x3ffd7, 0,    0 },
        { 18,    0x3ffd5, 0,    0 },   { 18,    0x3ffd3, 0,    0 },
        { 18,    0x3ffd1, 0,    0 },   { 22,   0x3fffaf, 0,    0 },
        { 22,   0x3fffad, 0,    0 },   { 22,   0x3fffab, 0,    0 },
        { 22,   0x3fffa9, 0,    0 },   { 22,   0x3fffa7, 0,    0 },
        { 22,   0x3fffa5, 0,    0 },   { 22,   0x3fffa3, 0,    0 },
        { 22,   0x3fffa1, 0,    0 },   { 26,  0x3ffff7f, 0,    0 },
        { 26,  0x3ffff7d, 0,    0 },   { 26,  0x3ffff7b, 0,    0 },
        { 26,  0x3ffff79, 0,    0 },   { 26,  0x3ffff77, 0,    0 },
        { 26,  0x3ffff75, 0,    0 },   { 26,  0x3ffff73, 0,    0 },
        { 26,  0x3ffff71, 0,    0 },   { 26,  0x3ffff6f, 0,    0 },
        { 26,  0x3ffff6d, 0,    0 },   { 26,  0x3ffff6b, 0,    0 },
        { 26,  0x3ffff69, 0,    0 },   { 26,  0x3ffff67, 0,    0 },
        { 26,  0x3ffff65, 0,    0 },   { 26,  0x3ffff63, 0,    0 },
        { 26,  0x3ffff61, 0,    0 },   { 31, 0x7ffffe3f, 0,    0 },
        { 31, 0x7ffffe3d, 0,    0 },   { 31, 0x7ffffe3b, 0,    0 },
        { 31, 0x7ffffe39, 0,    0 },   { 31, 0x7ffffe37, 0,    0 },
        { 31, 0x7ffffe35, 0,    0 },   { 31, 0x7ffffe33, 0,    0 },
        { 31, 0x7ffffe31, 0,    0 },   { 31, 0x7ffffe2f, 0,    0 },
        { 31, 0x7ffffe2d, 0,    0 },   { 31, 0x7ffffe2b, 0,    0 },
        { 31, 0x7ffffe29, 0,    0 },   { 31, 0x7ffffe27, 0,    0 },
        { 31, 0x7ffffe25, 0,    0 },   { 31, 0x7ffffe23, 0,    0 },
        { 31, 0x7ffffe21, 0,    0 },   { 31, 0x7ffffe1f, 0,    0 },
        { 31, 0x7ffffe1d, 0,    0 },   { 31, 0x7ffffe1b, 0,    0 },
        { 31, 0x7ffffe19, 0,    0 },   { 31, 0x7ffffe17, 0,    0 },
        { 31, 0x7ffffe15, 0,    0 },   { 31, 0x7ffffe13, 0,    0 },
        { 31, 0x7ffffe11, 0,    0 },   { 31, 0x7ffffe0f, 0,    0 },
        { 31, 0x7ffffe0d, 0,    0 },   { 31, 0x7ffffe0b, 0,    0 },
        { 31, 0x7ffffe09, 0,    0 },   { 31, 0x7ffffe07, 0,    0 },
        { 31, 0x7ffffe05, 0,    0 },   { 31, 0x7ffffe03, 0,    0 },
        { 31, 0x7ffffe01, 0,    0 },   { 28,  0xffffffa, 7, 0x7f },
        { 28,  0xffffffa, 7, 0x7d },   { 28,  0xffffffa, 7, 0x7b },
        { 28,  0xffffffa, 7, 0x79 },   { 28,  0xffffffa, 7, 0x77 },
        { 28,  0xffffffa, 7, 0x75 },   { 28,  0xffffffa, 7, 0x73 },
        { 28,  0xffffffa, 7, 0x71 },   { 28,  0xffffffa, 7, 0x6f },
        { 28,  0xffffffa, 7, 0x6d },   { 28,  0xffffffa, 7, 0x6b },
        { 28,  0xffffffa, 7, 0x69 },   { 28,  0xffffffa, 7, 0x67 },
        { 28,  0xffffffa, 7, 0x65 },   { 28,  0xffffffa, 7, 0x63 },
        { 28,  0xffffffa, 7, 0x61 },   { 28,  0xffffffa, 7, 0x5f },
        { 28,  0xffffffa, 7, 0x5d },   { 28,  0xffffffa, 7, 0x5b },
        { 28,  0xffffffa, 7, 0x59 },   { 28,  0xffffffa, 7, 0x57 },
        { 28,  0xffffffa, 7, 0x55 },   { 28,  0xffffffa, 7, 0x53 },
        { 28,  0xffffffa, 7, 0x51 },   { 28,  0xffffffa, 7, 0x4f },
        { 28,  0xffffffa, 7, 0x4d },   { 28,  0xffffffa, 7, 0x4b },
        { 28,  0xffffffa, 7, 0x49 },   { 28,  0xffffffa, 7, 0x47 },
        { 28,  0xffffffa, 7, 0x45 },   { 28,  0xffffffa, 7, 0x43 },
        { 28,  0xffffffa, 7, 0x41 },   { 28,  0xffffffa, 7, 0x3f },
        { 28,  0xffffffa, 7, 0x3d },   { 28,  0xffffffa, 7, 0x3b },
        { 28,  0xffffffa, 7, 0x39 },   { 28,  0xffffffa, 7, 0x37 },
        { 28,  0xffffffa, 7, 0x35 },   { 28,  0xffffffa, 7, 0x33 },
        { 28,  0xffffffa, 7, 0x31 },   { 28,  0xffffffa, 7, 0x2f },
        { 28,  0xffffffa, 7, 0x2d },   { 28,  0xffffffa, 7, 0x2b },
        { 28,  0xffffffa, 7, 0x29 },   { 28,  0xffffffa, 7, 0x27 },
        { 28,  0xffffffa, 7, 0x25 },   { 28,  0xffffffa, 7, 0x23 },
        { 28,  0xffffffa, 7, 0x21 },   { 28,  0xffffffa, 7, 0x1f },
        { 28,  0xffffffa, 7, 0x1d },   { 28,  0xffffffa, 7, 0x1b },
        { 28,  0xffffffa, 7, 0x19 },   { 28,  0xffffffa, 7, 0x17 },
        { 28,  0xffffffa, 7, 0x15 },   { 28,  0xffffffa, 7, 0x13 },
        { 28,  0xffffffa, 7, 0x11 },   { 28,  0xffffffa, 7,  0xf },
        { 28,  0xffffffa, 7,  0xd },   { 28,  0xffffffa, 7,  0xb },
        { 28,  0xffffffa, 7,  0x9 },   { 28,  0xffffffa, 7,  0x7 },
        { 28,  0xffffffa, 7,  0x5 },   { 28,  0xffffffa, 7,  0x3 },
        { 28,  0xffffffa, 7,  0x1 },   {  0,          0, 0,    0 }
    },

    /*
     * prefixed with 7 zeroes
     */
    {
        {  9,      0x1f3, 0,    0 },   { 14,     0x3fef, 0,    0 },
        { 14,     0x3fed, 0,    0 },   { 18,    0x3ffdf, 0,    0 },
        { 18,    0x3ffdd, 0,    0 },   { 18,    0x3ffdb, 0,    0 },
        { 18,    0x3ffd9, 0,    0 },   { 22,   0x3fffbf, 0,    0 },
        { 22,   0x3fffbd, 0,    0 },   { 22,   0x3fffbb, 0,    0 },
        { 22,   0x3fffb9, 0,    0 },   { 22,   0x3fffb7, 0,    0 },
        { 22,   0x3fffb5, 0,    0 },   { 22,   0x3fffb3, 0,    0 },
        { 22,   0x3fffb1, 0,    0 },   { 27,  0x7ffff1f, 0,    0 },
        { 27,  0x7ffff1d, 0,    0 },   { 27,  0x7ffff1b, 0,    0 },
        { 27,  0x7ffff19, 0,    0 },   { 27,  0x7ffff17, 0,    0 },
        { 27,  0x7ffff15, 0,    0 },   { 27,  0x7ffff13, 0,    0 },
        { 27,  0x7ffff11, 0,    0 },   { 27,  0x7ffff0f, 0,    0 },
        { 27,  0x7ffff0d, 0,    0 },   { 27,  0x7ffff0b, 0,    0 },
        { 27,  0x7ffff09, 0,    0 },   { 27,  0x7ffff07, 0,    0 },
        { 27,  0x7ffff05, 0,    0 },   { 27,  0x7ffff03, 0,    0 },
        { 27,  0x7ffff01, 0,    0 },   { 31, 0x7ffffe7f, 0,    0 },
        { 31, 0x7ffffe7d, 0,    0 },   { 31, 0x7ffffe7b, 0,    0 },
        { 31, 0x7ffffe79, 0,    0 },   { 31, 0x7ffffe77, 0,    0 },
        { 31, 0x7ffffe75, 0,    0 },   { 31, 0x7ffffe73, 0,    0 },
        { 31, 0x7ffffe71, 0,    0 },   { 31, 0x7ffffe6f, 0,    0 },
        { 31, 0x7ffffe6d, 0,    0 },   { 31, 0x7ffffe6b, 0,    0 },
        { 31, 0x7ffffe69, 0,    0 },   { 31, 0x7ffffe67, 0,    0 },
        { 31, 0x7ffffe65, 0,    0 },   { 31, 0x7ffffe63, 0,    0 },
        { 31, 0x7ffffe61, 0,    0 },   { 31, 0x7ffffe5f, 0,    0 },
        { 31, 0x7ffffe5d, 0,    0 },   { 31, 0x7ffffe5b, 0,    0 },
        { 31, 0x7ffffe59, 0,    0 },   { 31, 0x7ffffe57, 0,    0 },
        { 31, 0x7ffffe55, 0,    0 },   { 31, 0x7ffffe53, 0,    0 },
        { 31, 0x7ffffe51, 0,    0 },   { 31, 0x7ffffe4f, 0,    0 },
        { 31, 0x7ffffe4d, 0,    0 },   { 31, 0x7ffffe4b, 0,    0 },
        { 31, 0x7ffffe49, 0,    0 },   { 31, 0x7ffffe47, 0,    0 },
        { 31, 0x7ffffe45, 0,    0 },   { 31, 0x7ffffe43, 0,    0 },
        { 31, 0x7ffffe41, 0,    0 },   { 28,  0xffffffb, 7, 0x7f },
        { 28,  0xffffffb, 7, 0x7d },   { 28,  0xffffffb, 7, 0x7b },
        { 28,  0xffffffb, 7, 0x79 },   { 28,  0xffffffb, 7, 0x77 },
        { 28,  0xffffffb, 7, 0x75 },   { 28,  0xffffffb, 7, 0x73 },
        { 28,  0xffffffb, 7, 0x71 },   { 28,  0xffffffb, 7, 0x6f },
        { 28,  0xffffffb, 7, 0x6d },   { 28,  0xffffffb, 7, 0x6b },
        { 28,  0xffffffb, 7, 0x69 },   { 28,  0xffffffb, 7, 0x67 },
        { 28,  0xffffffb, 7, 0x65 },   { 28,  0xffffffb, 7, 0x63 },
        { 28,  0xffffffb, 7, 0x61 },   { 28,  0xffffffb, 7, 0x5f },
        { 28,  0xffffffb, 7, 0x5d },   { 28,  0xffffffb, 7, 0x5b },
        { 28,  0xffffffb, 7, 0x59 },   { 28,  0xffffffb, 7, 0x57 },
        { 28,  0xffffffb, 7, 0x55 },   { 28,  0xffffffb, 7, 0x53 },
        { 28,  0xffffffb, 7, 0x51 },   { 28,  0xffffffb, 7, 0x4f },
        { 28,  0xffffffb, 7, 0x4d },   { 28,  0xffffffb, 7, 0x4b },
        { 28,  0xffffffb, 7, 0x49 },   { 28,  0xffffffb, 7, 0x47 },
        { 28,  0xffffffb, 7, 0x45 },   { 28,  0xffffffb, 7, 0x43 },
        { 28,  0xffffffb, 7, 0x41 },   { 28,  0xffffffb, 7, 0x3f },
        { 28,  0xffffffb, 7, 0x3d },   { 28,  0xffffffb, 7, 0x3b },
        { 28,  0xffffffb, 7, 0x39 },   { 28,  0xffffffb, 7, 0x37 },
        { 28,  0xffffffb, 7, 0x35 },   { 28,  0xffffffb, 7, 0x33 },
        { 28,  0xffffffb, 7, 0x31 },   { 28,  0xffffffb, 7, 0x2f },
        { 28,  0xffffffb, 7, 0x2d },   { 28,  0xffffffb, 7, 0x2b },
        { 28,  0xffffffb, 7, 0x29 },   { 28,  0xffffffb, 7, 0x27 },
        { 28,  0xffffffb, 7, 0x25 },   { 28,  0xffffffb, 7, 0x23 },
        { 28,  0xffffffb, 7, 0x21 },   { 28,  0xffffffb, 7, 0x1f },
        { 28,  0xffffffb, 7, 0x1d },   { 28,  0xffffffb, 7, 0x1b },
        { 28,  0xffffffb, 7, 0x19 },   { 28,  0xffffffb, 7, 0x17 },
        { 28,  0xffffffb, 7, 0x15 },   { 28,  0xffffffb, 7, 0x13 },
        { 28,  0xffffffb, 7, 0x11 },   { 28,  0xffffffb, 7,  0xf },
        { 28,  0xffffffb, 7,  0xd },   { 28,  0xffffffb, 7,  0xb },
        { 28,  0xffffffb, 7,  0x9 },   { 28,  0xffffffb, 7,  0x7 },
        { 28,  0xffffffb, 7,  0x5 },   { 28,  0xffffffb, 7,  0x3 },
        { 28,  0xffffffb, 7,  0x1 },   {  0,          0, 0,    0 }
    },

    /*
     * prefixed with 8 zeroes
     */
    {
        {  9,      0x1f5, 0,    0 },   { 15,     0x7fe3, 0,    0 },
        { 15,     0x7fe1, 0,    0 },   { 19,    0x7ffc7, 0,    0 },
        { 19,    0x7ffc5, 0,    0 },   { 19,    0x7ffc3, 0,    0 },
        { 19,    0x7ffc1, 0,    0 },   { 23,   0x7fff8f, 0,    0 },
        { 23,   0x7fff8d, 0,    0 },   { 23,   0x7fff8b, 0,    0 },
        { 23,   0x7fff89, 0,    0 },   { 23,   0x7fff87, 0,    0 },
        { 23,   0x7fff85, 0,    0 },   { 23,   0x7fff83, 0,    0 },
        { 23,   0x7fff81, 0,    0 },   { 27,  0x7ffff3f, 0,    0 },
        { 27,  0x7ffff3d, 0,    0 },   { 27,  0x7ffff3b, 0,    0 },
        { 27,  0x7ffff39, 0,    0 },   { 27,  0x7ffff37, 0,    0 },
        { 27,  0x7ffff35, 0,    0 },   { 27,  0x7ffff33, 0,    0 },
        { 27,  0x7ffff31, 0,    0 },   { 27,  0x7ffff2f, 0,    0 },
        { 27,  0x7ffff2d, 0,    0 },   { 27,  0x7ffff2b, 0,    0 },
        { 27,  0x7ffff29, 0,    0 },   { 27,  0x7ffff27, 0,    0 },
        { 27,  0x7ffff25, 0,    0 },   { 27,  0x7ffff23, 0,    0 },
        { 27,  0x7ffff21, 0,    0 },   { 31, 0x7ffffebf, 0,    0 },
        { 31, 0x7ffffebd, 0,    0 },   { 31, 0x7ffffebb, 0,    0 },
        { 31, 0x7ffffeb9, 0,    0 },   { 31, 0x7ffffeb7, 0,    0 },
        { 31, 0x7ffffeb5, 0,    0 },   { 31, 0x7ffffeb3, 0,    0 },
        { 31, 0x7ffffeb1, 0,    0 },   { 31, 0x7ffffeaf, 0,    0 },
        { 31, 0x7ffffead, 0,    0 },   { 31, 0x7ffffeab, 0,    0 },
        { 31, 0x7ffffea9, 0,    0 },   { 31, 0x7ffffea7, 0,    0 },
        { 31, 0x7ffffea5, 0,    0 },   { 31, 0x7ffffea3, 0,    0 },
        { 31, 0x7ffffea1, 0,    0 },   { 31, 0x7ffffe9f, 0,    0 },
        { 31, 0x7ffffe9d, 0,    0 },   { 31, 0x7ffffe9b, 0,    0 },
        { 31, 0x7ffffe99, 0,    0 },   { 31, 0x7ffffe97, 0,    0 },
        { 31, 0x7ffffe95, 0,    0 },   { 31, 0x7ffffe93, 0,    0 },
        { 31, 0x7ffffe91, 0,    0 },   { 31, 0x7ffffe8f, 0,    0 },
        { 31, 0x7ffffe8d, 0,    0 },   { 31, 0x7ffffe8b, 0,    0 },
        { 31, 0x7ffffe89, 0,    0 },   { 31, 0x7ffffe87, 0,    0 },
        { 31, 0x7ffffe85, 0,    0 },   { 31, 0x7ffffe83, 0,    0 },
        { 31, 0x7ffffe81, 0,    0 },   { 29, 0x1ffffff8, 7, 0x7f },
        { 29, 0x1ffffff8, 7, 0x7d },   { 29, 0x1ffffff8, 7, 0x7b },
        { 29, 0x1ffffff8, 7, 0x79 },   { 29, 0x1ffffff8, 7, 0x77 },
        { 29, 0x1ffffff8, 7, 0x75 },   { 29, 0x1ffffff8, 7, 0x73 },
        { 29, 0x1ffffff8, 7, 0x71 },   { 29, 0x1ffffff8, 7, 0x6f },
        { 29, 0x1ffffff8, 7, 0x6d },   { 29, 0x1ffffff8, 7, 0x6b },
        { 29, 0x1ffffff8, 7, 0x69 },   { 29, 0x1ffffff8, 7, 0x67 },
        { 29, 0x1ffffff8, 7, 0x65 },   { 29, 0x1ffffff8, 7, 0x63 },
        { 29, 0x1ffffff8, 7, 0x61 },   { 29, 0x1ffffff8, 7, 0x5f },
        { 29, 0x1ffffff8, 7, 0x5d },   { 29, 0x1ffffff8, 7, 0x5b },
        { 29, 0x1ffffff8, 7, 0x59 },   { 29, 0x1ffffff8, 7, 0x57 },
        { 29, 0x1ffffff8, 7, 0x55 },   { 29, 0x1ffffff8, 7, 0x53 },
        { 29, 0x1ffffff8, 7, 0x51 },   { 29, 0x1ffffff8, 7, 0x4f },
        { 29, 0x1ffffff8, 7, 0x4d },   { 29, 0x1ffffff8, 7, 0x4b },
        { 29, 0x1ffffff8, 7, 0x49 },   { 29, 0x1ffffff8, 7, 0x47 },
        { 29, 0x1ffffff8, 7, 0x45 },   { 29, 0x1ffffff8, 7, 0x43 },
        { 29, 0x1ffffff8, 7, 0x41 },   { 29, 0x1ffffff8, 7, 0x3f },
        { 29, 0x1ffffff8, 7, 0x3d },   { 29, 0x1ffffff8, 7, 0x3b },
        { 29, 0x1ffffff8, 7, 0x39 },   { 29, 0x1ffffff8, 7, 0x37 },
        { 29, 0x1ffffff8, 7, 0x35 },   { 29, 0x1ffffff8, 7, 0x33 },
        { 29, 0x1ffffff8, 7, 0x31 },   { 29, 0x1ffffff8, 7, 0x2f },
        { 29, 0x1ffffff8, 7, 0x2d },   { 29, 0x1ffffff8, 7, 0x2b },
        { 29, 0x1ffffff8, 7, 0x29 },   { 29, 0x1ffffff8, 7, 0x27 },
        { 29, 0x1ffffff8, 7, 0x25 },   { 29, 0x1ffffff8, 7, 0x23 },
        { 29, 0x1ffffff8, 7, 0x21 },   { 29, 0x1ffffff8, 7, 0x1f },
        { 29, 0x1ffffff8, 7, 0x1d },   { 29, 0x1ffffff8, 7, 0x1b },
        { 29, 0x1ffffff8, 7, 0x19 },   { 29, 0x1ffffff8, 7, 0x17 },
        { 29, 0x1ffffff8, 7, 0x15 },   { 29, 0x1ffffff8, 7, 0x13 },
        { 29, 0x1ffffff8, 7, 0x11 },   { 29, 0x1ffffff8, 7,  0xf },
        { 29, 0x1ffffff8, 7,  0xd },   { 29, 0x1ffffff8, 7,  0xb },
        { 29, 0x1ffffff8, 7,  0x9 },   { 29, 0x1ffffff8, 7,  0x7 },
        { 29, 0x1ffffff8, 7,  0x5 },   { 29, 0x1ffffff8, 7,  0x3 },
        { 29, 0x1ffffff8, 7,  0x1 },   {  0,          0, 0,    0 }
    },

    /*
     * prefixed with 9 zeroes
     */
    {
        { 11,      0x7f7, 0,    0 },   { 15,     0x7fe7, 0,    0 },
        { 15,     0x7fe5, 0,    0 },   { 19,    0x7ffcf, 0,    0 },
        { 19,    0x7ffcd, 0,    0 },   { 19,    0x7ffcb, 0,    0 },
        { 19,    0x7ffc9, 0,    0 },   { 23,   0x7fff9f, 0,    0 },
        { 23,   0x7fff9d, 0,    0 },   { 23,   0x7fff9b, 0,    0 },
        { 23,   0x7fff99, 0,    0 },   { 23,   0x7fff97, 0,    0 },
        { 23,   0x7fff95, 0,    0 },   { 23,   0x7fff93, 0,    0 },
        { 23,   0x7fff91, 0,    0 },   { 27,  0x7ffff5f, 0,    0 },
        { 27,  0x7ffff5d, 0,    0 },   { 27,  0x7ffff5b, 0,    0 },
        { 27,  0x7ffff59, 0,    0 },   { 27,  0x7ffff57, 0,    0 },
        { 27,  0x7ffff55, 0,    0 },   { 27,  0x7ffff53, 0,    0 },
        { 27,  0x7ffff51, 0,    0 },   { 27,  0x7ffff4f, 0,    0 },
        { 27,  0x7ffff4d, 0,    0 },   { 27,  0x7ffff4b, 0,    0 },
        { 27,  0x7ffff49, 0,    0 },   { 27,  0x7ffff47, 0,    0 },
        { 27,  0x7ffff45, 0,    0 },   { 27,  0x7ffff43, 0,    0 },
        { 27,  0x7ffff41, 0,    0 },   { 31, 0x7ffffeff, 0,    0 },
        { 31, 0x7ffffefd, 0,    0 },   { 31, 0x7ffffefb, 0,    0 },
        { 31, 0x7ffffef9, 0,    0 },   { 31, 0x7ffffef7, 0,    0 },
        { 31, 0x7ffffef5, 0,    0 },   { 31, 0x7ffffef3, 0,    0 },
        { 31, 0x7ffffef1, 0,    0 },   { 31, 0x7ffffeef, 0,    0 },
        { 31, 0x7ffffeed, 0,    0 },   { 31, 0x7ffffeeb, 0,    0 },
        { 31, 0x7ffffee9, 0,    0 },   { 31, 0x7ffffee7, 0,    0 },
        { 31, 0x7ffffee5, 0,    0 },   { 31, 0x7ffffee3, 0,    0 },
        { 31, 0x7ffffee1, 0,    0 },   { 31, 0x7ffffedf, 0,    0 },
        { 31, 0x7ffffedd, 0,    0 },   { 31, 0x7ffffedb, 0,    0 },
        { 31, 0x7ffffed9, 0,    0 },   { 31, 0x7ffffed7, 0,    0 },
        { 31, 0x7ffffed5, 0,    0 },   { 31, 0x7ffffed3, 0,    0 },
        { 31, 0x7ffffed1, 0,    0 },   { 31, 0x7ffffecf, 0,    0 },
        { 31, 0x7ffffecd, 0,    0 },   { 31, 0x7ffffecb, 0,    0 },
        { 31, 0x7ffffec9, 0,    0 },   { 31, 0x7ffffec7, 0,    0 },
        { 31, 0x7ffffec5, 0,    0 },   { 31, 0x7ffffec3, 0,    0 },
        { 31, 0x7ffffec1, 0,    0 },   { 29, 0x1ffffff9, 7, 0x7f },
        { 29, 0x1ffffff9, 7, 0x7d },   { 29, 0x1ffffff9, 7, 0x7b },
        { 29, 0x1ffffff9, 7, 0x79 },   { 29, 0x1ffffff9, 7, 0x77 },
        { 29, 0x1ffffff9, 7, 0x75 },   { 29, 0x1ffffff9, 7, 0x73 },
        { 29, 0x1ffffff9, 7, 0x71 },   { 29, 0x1ffffff9, 7, 0x6f },
        { 29, 0x1ffffff9, 7, 0x6d },   { 29, 0x1ffffff9, 7, 0x6b },
        { 29, 0x1ffffff9, 7, 0x69 },   { 29, 0x1ffffff9, 7, 0x67 },
        { 29, 0x1ffffff9, 7, 0x65 },   { 29, 0x1ffffff9, 7, 0x63 },
        { 29, 0x1ffffff9, 7, 0x61 },   { 29, 0x1ffffff9, 7, 0x5f },
        { 29, 0x1ffffff9, 7, 0x5d },   { 29, 0x1ffffff9, 7, 0x5b },
        { 29, 0x1ffffff9, 7, 0x59 },   { 29, 0x1ffffff9, 7, 0x57 },
        { 29, 0x1ffffff9, 7, 0x55 },   { 29, 0x1ffffff9, 7, 0x53 },
        { 29, 0x1ffffff9, 7, 0x51 },   { 29, 0x1ffffff9, 7, 0x4f },
        { 29, 0x1ffffff9, 7, 0x4d },   { 29, 0x1ffffff9, 7, 0x4b },
        { 29, 0x1ffffff9, 7, 0x49 },   { 29, 0x1ffffff9, 7, 0x47 },
        { 29, 0x1ffffff9, 7, 0x45 },   { 29, 0x1ffffff9, 7, 0x43 },
        { 29, 0x1ffffff9, 7, 0x41 },   { 29, 0x1ffffff9, 7, 0x3f },
        { 29, 0x1ffffff9, 7, 0x3d },   { 29, 0x1ffffff9, 7, 0x3b },
        { 29, 0x1ffffff9, 7, 0x39 },   { 29, 0x1ffffff9, 7, 0x37 },
        { 29, 0x1ffffff9, 7, 0x35 },   { 29, 0x1ffffff9, 7, 0x33 },
        { 29, 0x1ffffff9, 7, 0x31 },   { 29, 0x1ffffff9, 7, 0x2f },
        { 29, 0x1ffffff9, 7, 0x2d },   { 29, 0x1ffffff9, 7, 0x2b },
        { 29, 0x1ffffff9, 7, 0x29 },   { 29, 0x1ffffff9, 7, 0x27 },
        { 29, 0x1ffffff9, 7, 0x25 },   { 29, 0x1ffffff9, 7, 0x23 },
        { 29, 0x1ffffff9, 7, 0x21 },   { 29, 0x1ffffff9, 7, 0x1f },
        { 29, 0x1ffffff9, 7, 0x1d },   { 29, 0x1ffffff9, 7, 0x1b },
        { 29, 0x1ffffff9, 7, 0x19 },   { 29, 0x1ffffff9, 7, 0x17 },
        { 29, 0x1ffffff9, 7, 0x15 },   { 29, 0x1ffffff9, 7, 0x13 },
        { 29, 0x1ffffff9, 7, 0x11 },   { 29, 0x1ffffff9, 7,  0xf },
        { 29, 0x1ffffff9, 7,  0xd },   { 29, 0x1ffffff9, 7,  0xb },
        { 29, 0x1ffffff9, 7,  0x9 },   { 29, 0x1ffffff9, 7,  0x7 },
        { 29, 0x1ffffff9, 7,  0x5 },   { 29, 0x1ffffff9, 7,  0x3 },
        { 29, 0x1ffffff9, 7,  0x1 },   {  0,          0, 0,    0 }
    },

    /*
     * prefixed with 10 zeroes
     */
    {
        { 12,      0xff1, 0,    0 },   { 15,     0x7feb, 0,    0 },
        { 15,     0x7fe9, 0,    0 },   { 19,    0x7ffd7, 0,    0 },
        { 19,    0x7ffd5, 0,    0 },   { 19,    0x7ffd3, 0,    0 },
        { 19,    0x7ffd1, 0,    0 },   { 23,   0x7fffaf, 0,    0 },
        { 23,   0x7fffad, 0,    0 },   { 23,   0x7fffab, 0,    0 },
        { 23,   0x7fffa9, 0,    0 },   { 23,   0x7fffa7, 0,    0 },
        { 23,   0x7fffa5, 0,    0 },   { 23,   0x7fffa3, 0,    0 },
        { 23,   0x7fffa1, 0,    0 },   { 27,  0x7ffff7f, 0,    0 },
        { 27,  0x7ffff7d, 0,    0 },   { 27,  0x7ffff7b, 0,    0 },
        { 27,  0x7ffff79, 0,    0 },   { 27,  0x7ffff77, 0,    0 },
        { 27,  0x7ffff75, 0,    0 },   { 27,  0x7ffff73, 0,    0 },
        { 27,  0x7ffff71, 0,    0 },   { 27,  0x7ffff6f, 0,    0 },
        { 27,  0x7ffff6d, 0,    0 },   { 27,  0x7ffff6b, 0,    0 },
        { 27,  0x7ffff69, 0,    0 },   { 27,  0x7ffff67, 0,    0 },
        { 27,  0x7ffff65, 0,    0 },   { 27,  0x7ffff63, 0,    0 },
        { 27,  0x7ffff61, 0,    0 },   { 32, 0xfffffe3f, 0,    0 },
        { 32, 0xfffffe3d, 0,    0 },   { 32, 0xfffffe3b, 0,    0 },
        { 32, 0xfffffe39, 0,    0 },   { 32, 0xfffffe37, 0,    0 },
        { 32, 0xfffffe35, 0,    0 },   { 32, 0xfffffe33, 0,    0 },
        { 32, 0xfffffe31, 0,    0 },   { 32, 0xfffffe2f, 0,    0 },
        { 32, 0xfffffe2d, 0,    0 },   { 32, 0xfffffe2b, 0,    0 },
        { 32, 0xfffffe29, 0,    0 },   { 32, 0xfffffe27, 0,    0 },
        { 32, 0xfffffe25, 0,    0 },   { 32, 0xfffffe23, 0,    0 },
        { 32, 0xfffffe21, 0,    0 },   { 32, 0xfffffe1f, 0,    0 },
        { 32, 0xfffffe1d, 0,    0 },   { 32, 0xfffffe1b, 0,    0 },
        { 32, 0xfffffe19, 0,    0 },   { 32, 0xfffffe17, 0,    0 },
        { 32, 0xfffffe15, 0,    0 },   { 32, 0xfffffe13, 0,    0 },
        { 32, 0xfffffe11, 0,    0 },   { 32, 0xfffffe0f, 0,    0 },
        { 32, 0xfffffe0d, 0,    0 },   { 32, 0xfffffe0b, 0,    0 },
        { 32, 0xfffffe09, 0,    0 },   { 32, 0xfffffe07, 0,    0 },
        { 32, 0xfffffe05, 0,    0 },   { 32, 0xfffffe03, 0,    0 },
        { 32, 0xfffffe01, 0,    0 },   { 29, 0x1ffffffa, 7, 0x7f },
        { 29, 0x1ffffffa, 7, 0x7d },   { 29, 0x1ffffffa, 7, 0x7b },
        { 29, 0x1ffffffa, 7, 0x79 },   { 29, 0x1ffffffa, 7, 0x77 },
        { 29, 0x1ffffffa, 7, 0x75 },   { 29, 0x1ffffffa, 7, 0x73 },
        { 29, 0x1ffffffa, 7, 0x71 },   { 29, 0x1ffffffa, 7, 0x6f },
        { 29, 0x1ffffffa, 7, 0x6d },   { 29, 0x1ffffffa, 7, 0x6b },
        { 29, 0x1ffffffa, 7, 0x69 },   { 29, 0x1ffffffa, 7, 0x67 },
        { 29, 0x1ffffffa, 7, 0x65 },   { 29, 0x1ffffffa, 7, 0x63 },
        { 29, 0x1ffffffa, 7, 0x61 },   { 29, 0x1ffffffa, 7, 0x5f },
        { 29, 0x1ffffffa, 7, 0x5d },   { 29, 0x1ffffffa, 7, 0x5b },
        { 29, 0x1ffffffa, 7, 0x59 },   { 29, 0x1ffffffa, 7, 0x57 },
        { 29, 0x1ffffffa, 7, 0x55 },   { 29, 0x1ffffffa, 7, 0x53 },
        { 29, 0x1ffffffa, 7, 0x51 },   { 29, 0x1ffffffa, 7, 0x4f },
        { 29, 0x1ffffffa, 7, 0x4d },   { 29, 0x1ffffffa, 7, 0x4b },
        { 29, 0x1ffffffa, 7, 0x49 },   { 29, 0x1ffffffa, 7, 0x47 },
        { 29, 0x1ffffffa, 7, 0x45 },   { 29, 0x1ffffffa, 7, 0x43 },
        { 29, 0x1ffffffa, 7, 0x41 },   { 29, 0x1ffffffa, 7, 0x3f },
        { 29, 0x1ffffffa, 7, 0x3d },   { 29, 0x1ffffffa, 7, 0x3b },
        { 29, 0x1ffffffa, 7, 0x39 },   { 29, 0x1ffffffa, 7, 0x37 },
        { 29, 0x1ffffffa, 7, 0x35 },   { 29, 0x1ffffffa, 7, 0x33 },
        { 29, 0x1ffffffa, 7, 0x31 },   { 29, 0x1ffffffa, 7, 0x2f },
        { 29, 0x1ffffffa, 7, 0x2d },   { 29, 0x1ffffffa, 7, 0x2b },
        { 29, 0x1ffffffa, 7, 0x29 },   { 29, 0x1ffffffa, 7, 0x27 },
        { 29, 0x1ffffffa, 7, 0x25 },   { 29, 0x1ffffffa, 7, 0x23 },
        { 29, 0x1ffffffa, 7, 0x21 },   { 29, 0x1ffffffa, 7, 0x1f },
        { 29, 0x1ffffffa, 7, 0x1d },   { 29, 0x1ffffffa, 7, 0x1b },
        { 29, 0x1ffffffa, 7, 0x19 },   { 29, 0x1ffffffa, 7, 0x17 },
        { 29, 0x1ffffffa, 7, 0x15 },   { 29, 0x1ffffffa, 7, 0x13 },
        { 29, 0x1ffffffa, 7, 0x11 },   { 29, 0x1ffffffa, 7,  0xf },
        { 29, 0x1ffffffa, 7,  0xd },   { 29, 0x1ffffffa, 7,  0xb },
        { 29, 0x1ffffffa, 7,  0x9 },   { 29, 0x1ffffffa, 7,  0x7 },
        { 29, 0x1ffffffa, 7,  0x5 },   { 29, 0x1ffffffa, 7,  0x3 },
        { 29, 0x1ffffffa, 7,  0x1 },   {  0,          0, 0,    0 }
    },

    /*
     * prefixed with 11 zeroes
     */
    {
        { 12,      0xff3, 0,    0 },   { 15,     0x7fef, 0,    0 },
        { 15,     0x7fed, 0,    0 },   { 19,    0x7ffdf, 0,    0 },
        { 19,    0x7ffdd, 0,    0 },   { 19,    0x7ffdb, 0,    0 },
        { 19,    0x7ffd9, 0,    0 },   { 23,   0x7fffbf, 0,    0 },
        { 23,   0x7fffbd, 0,    0 },   { 23,   0x7fffbb, 0,    0 },
        { 23,   0x7fffb9, 0,    0 },   { 23,   0x7fffb7, 0,    0 },
        { 23,   0x7fffb5, 0,    0 },   { 23,   0x7fffb3, 0,    0 },
        { 23,   0x7fffb1, 0,    0 },   { 28,  0xfffff1f, 0,    0 },
        { 28,  0xfffff1d, 0,    0 },   { 28,  0xfffff1b, 0,    0 },
        { 28,  0xfffff19, 0,    0 },   { 28,  0xfffff17, 0,    0 },
        { 28,  0xfffff15, 0,    0 },   { 28,  0xfffff13, 0,    0 },
        { 28,  0xfffff11, 0,    0 },   { 28,  0xfffff0f, 0,    0 },
        { 28,  0xfffff0d, 0,    0 },   { 28,  0xfffff0b, 0,    0 },
        { 28,  0xfffff09, 0,    0 },   { 28,  0xfffff07, 0,    0 },
        { 28,  0xfffff05, 0,    0 },   { 28,  0xfffff03, 0,    0 },
        { 28,  0xfffff01, 0,    0 },   { 32, 0xfffffe7f, 0,    0 },
        { 32, 0xfffffe7d, 0,    0 },   { 32, 0xfffffe7b, 0,    0 },
        { 32, 0xfffffe79, 0,    0 },   { 32, 0xfffffe77, 0,    0 },
        { 32, 0xfffffe75, 0,    0 },   { 32, 0xfffffe73, 0,    0 },
        { 32, 0xfffffe71, 0,    0 },   { 32, 0xfffffe6f, 0,    0 },
        { 32, 0xfffffe6d, 0,    0 },   { 32, 0xfffffe6b, 0,    0 },
        { 32, 0xfffffe69, 0,    0 },   { 32, 0xfffffe67, 0,    0 },
        { 32, 0xfffffe65, 0,    0 },   { 32, 0xfffffe63, 0,    0 },
        { 32, 0xfffffe61, 0,    0 },   { 32, 0xfffffe5f, 0,    0 },
        { 32, 0xfffffe5d, 0,    0 },   { 32, 0xfffffe5b, 0,    0 },
        { 32, 0xfffffe59, 0,    0 },   { 32, 0xfffffe57, 0,    0 },
        { 32, 0xfffffe55, 0,    0 },   { 32, 0xfffffe53, 0,    0 },
        { 32, 0xfffffe51, 0,    0 },   { 32, 0xfffffe4f, 0,    0 },
        { 32, 0xfffffe4d, 0,    0 },   { 32, 0xfffffe4b, 0,    0 },
        { 32, 0xfffffe49, 0,    0 },   { 32, 0xfffffe47, 0,    0 },
        { 32, 0xfffffe45, 0,    0 },   { 32, 0xfffffe43, 0,    0 },
        { 32, 0xfffffe41, 0,    0 },   { 29, 0x1ffffffb, 7, 0x7f },
        { 29, 0x1ffffffb, 7, 0x7d },   { 29, 0x1ffffffb, 7, 0x7b },
        { 29, 0x1ffffffb, 7, 0x79 },   { 29, 0x1ffffffb, 7, 0x77 },
        { 29, 0x1ffffffb, 7, 0x75 },   { 29, 0x1ffffffb, 7, 0x73 },
        { 29, 0x1ffffffb, 7, 0x71 },   { 29, 0x1ffffffb, 7, 0x6f },
        { 29, 0x1ffffffb, 7, 0x6d },   { 29, 0x1ffffffb, 7, 0x6b },
        { 29, 0x1ffffffb, 7, 0x69 },   { 29, 0x1ffffffb, 7, 0x67 },
        { 29, 0x1ffffffb, 7, 0x65 },   { 29, 0x1ffffffb, 7, 0x63 },
        { 29, 0x1ffffffb, 7, 0x61 },   { 29, 0x1ffffffb, 7, 0x5f },
        { 29, 0x1ffffffb, 7, 0x5d },   { 29, 0x1ffffffb, 7, 0x5b },
        { 29, 0x1ffffffb, 7, 0x59 },   { 29, 0x1ffffffb, 7, 0x57 },
        { 29, 0x1ffffffb, 7, 0x55 },   { 29, 0x1ffffffb, 7, 0x53 },
        { 29, 0x1ffffffb, 7, 0x51 },   { 29, 0x1ffffffb, 7, 0x4f },
        { 29, 0x1ffffffb, 7, 0x4d },   { 29, 0x1ffffffb, 7, 0x4b },
        { 29, 0x1ffffffb, 7, 0x49 },   { 29, 0x1ffffffb, 7, 0x47 },
        { 29, 0x1ffffffb, 7, 0x45 },   { 29, 0x1ffffffb, 7, 0x43 },
        { 29, 0x1ffffffb, 7, 0x41 },   { 29, 0x1ffffffb, 7, 0x3f },
        { 29, 0x1ffffffb, 7, 0x3d },   { 29, 0x1ffffffb, 7, 0x3b },
        { 29, 0x1ffffffb, 7, 0x39 },   { 29, 0x1ffffffb, 7, 0x37 },
        { 29, 0x1ffffffb, 7, 0x35 },   { 29, 0x1ffffffb, 7, 0x33 },
        { 29, 0x1ffffffb, 7, 0x31 },   { 29, 0x1ffffffb, 7, 0x2f },
        { 29, 0x1ffffffb, 7, 0x2d },   { 29, 0x1ffffffb, 7, 0x2b },
        { 29, 0x1ffffffb, 7, 0x29 },   { 29, 0x1ffffffb, 7, 0x27 },
        { 29, 0x1ffffffb, 7, 0x25 },   { 29, 0x1ffffffb, 7, 0x23 },
        { 29, 0x1ffffffb, 7, 0x21 },   { 29, 0x1ffffffb, 7, 0x1f },
        { 29, 0x1ffffffb, 7, 0x1d },   { 29, 0x1ffffffb, 7, 0x1b },
        { 29, 0x1ffffffb, 7, 0x19 },   { 29, 0x1ffffffb, 7, 0x17 },
        { 29, 0x1ffffffb, 7, 0x15 },   { 29, 0x1ffffffb, 7, 0x13 },
        { 29, 0x1ffffffb, 7, 0x11 },   { 29, 0x1ffffffb, 7,  0xf },
        { 29, 0x1ffffffb, 7,  0xd },   { 29, 0x1ffffffb, 7,  0xb },
        { 29, 0x1ffffffb, 7,  0x9 },   { 29, 0x1ffffffb, 7,  0x7 },
        { 29, 0x1ffffffb, 7,  0x5 },   { 29, 0x1ffffffb, 7,  0x3 },
        { 29, 0x1ffffffb, 7,  0x1 },   {  0,          0, 0,    0 }
    },

    /*
     * prefixed with 12 zeroes
     */
    {
        { 12,      0xff5, 0,    0 },   { 16,     0xffe3, 0,    0 },
        { 16,     0xffe1, 0,    0 },   { 20,    0xfffc7, 0,    0 },
        { 20,    0xfffc5, 0,    0 },   { 20,    0xfffc3, 0,    0 },
        { 20,    0xfffc1, 0,    0 },   { 24,   0xffff8f, 0,    0 },
        { 24,   0xffff8d, 0,    0 },   { 24,   0xffff8b, 0,    0 },
        { 24,   0xffff89, 0,    0 },   { 24,   0xffff87, 0,    0 },
        { 24,   0xffff85, 0,    0 },   { 24,   0xffff83, 0,    0 },
        { 24,   0xffff81, 0,    0 },   { 28,  0xfffff3f, 0,    0 },
        { 28,  0xfffff3d, 0,    0 },   { 28,  0xfffff3b, 0,    0 },
        { 28,  0xfffff39, 0,    0 },   { 28,  0xfffff37, 0,    0 },
        { 28,  0xfffff35, 0,    0 },   { 28,  0xfffff33, 0,    0 },
        { 28,  0xfffff31, 0,    0 },   { 28,  0xfffff2f, 0,    0 },
        { 28,  0xfffff2d, 0,    0 },   { 28,  0xfffff2b, 0,    0 },
        { 28,  0xfffff29, 0,    0 },   { 28,  0xfffff27, 0,    0 },
        { 28,  0xfffff25, 0,    0 },   { 28,  0xfffff23, 0,    0 },
        { 28,  0xfffff21, 0,    0 },   { 32, 0xfffffebf, 0,    0 },
        { 32, 0xfffffebd, 0,    0 },   { 32, 0xfffffebb, 0,    0 },
        { 32, 0xfffffeb9, 0,    0 },   { 32, 0xfffffeb7, 0,    0 },
        { 32, 0xfffffeb5, 0,    0 },   { 32, 0xfffffeb3, 0,    0 },
        { 32, 0xfffffeb1, 0,    0 },   { 32, 0xfffffeaf, 0,    0 },
        { 32, 0xfffffead, 0,    0 },   { 32, 0xfffffeab, 0,    0 },
        { 32, 0xfffffea9, 0,    0 },   { 32, 0xfffffea7, 0,    0 },
        { 32, 0xfffffea5, 0,    0 },   { 32, 0xfffffea3, 0,    0 },
        { 32, 0xfffffea1, 0,    0 },   { 32, 0xfffffe9f, 0,    0 },
        { 32, 0xfffffe9d, 0,    0 },   { 32, 0xfffffe9b, 0,    0 },
        { 32, 0xfffffe99, 0,    0 },   { 32, 0xfffffe97, 0,    0 },
        { 32, 0xfffffe95, 0,    0 },   { 32, 0xfffffe93, 0,    0 },
        { 32, 0xfffffe91, 0,    0 },   { 32, 0xfffffe8f, 0,    0 },
        { 32, 0xfffffe8d, 0,    0 },   { 32, 0xfffffe8b, 0,    0 },
        { 32, 0xfffffe89, 0,    0 },   { 32, 0xfffffe87, 0,    0 },
        { 32, 0xfffffe85, 0,    0 },   { 32, 0xfffffe83, 0,    0 },
        { 32, 0xfffffe81, 0,    0 },   { 30, 0x1fff7400, 7, 0x7f },
        { 30, 0x1fff7400, 7, 0x7d },   { 30, 0x1fff7400, 7, 0x7b },
        { 30, 0x1fff7400, 7, 0x79 },   { 30, 0x1fff7400, 7, 0x77 },
        { 30, 0x1fff7400, 7, 0x75 },   { 30, 0x1fff7400, 7, 0x73 },
        { 30, 0x1fff7400, 7, 0x71 },   { 30, 0x1fff7400, 7, 0x6f },
        { 30, 0x1fff7400, 7, 0x6d },   { 30, 0x1fff7400, 7, 0x6b },
        { 30, 0x1fff7400, 7, 0x69 },   { 30, 0x1fff7400, 7, 0x67 },
        { 30, 0x1fff7400, 7, 0x65 },   { 30, 0x1fff7400, 7, 0x63 },
        { 30, 0x1fff7400, 7, 0x61 },   { 30, 0x1fff7400, 7, 0x5f },
        { 30, 0x1fff7400, 7, 0x5d },   { 30, 0x1fff7400, 7, 0x5b },
        { 30, 0x1fff7400, 7, 0x59 },   { 30, 0x1fff7400, 7, 0x57 },
        { 30, 0x1fff7400, 7, 0x55 },   { 30, 0x1fff7400, 7, 0x53 },
        { 30, 0x1fff7400, 7, 0x51 },   { 30, 0x1fff7400, 7, 0x4f },
        { 30, 0x1fff7400, 7, 0x4d },   { 30, 0x1fff7400, 7, 0x4b },
        { 30, 0x1fff7400, 7, 0x49 },   { 30, 0x1fff7400, 7, 0x47 },
        { 30, 0x1fff7400, 7, 0x45 },   { 30, 0x1fff7400, 7, 0x43 },
        { 30, 0x1fff7400, 7, 0x41 },   { 30, 0x1fff7400, 7, 0x3f },
        { 30, 0x1fff7400, 7, 0x3d },   { 30, 0x1fff7400, 7, 0x3b },
        { 30, 0x1fff7400, 7, 0x39 },   { 30, 0x1fff7400, 7, 0x37 },
        { 30, 0x1fff7400, 7, 0x35 },   { 30, 0x1fff7400, 7, 0x33 },
        { 30, 0x1fff7400, 7, 0x31 },   { 30, 0x1fff7400, 7, 0x2f },
        { 30, 0x1fff7400, 7, 0x2d },   { 30, 0x1fff7400, 7, 0x2b },
        { 30, 0x1fff7400, 7, 0x29 },   { 30, 0x1fff7400, 7, 0x27 },
        { 30, 0x1fff7400, 7, 0x25 },   { 30, 0x1fff7400, 7, 0x23 },
        { 30, 0x1fff7400, 7, 0x21 },   { 30, 0x1fff7400, 7, 0x1f },
        { 30, 0x1fff7400, 7, 0x1d },   { 30, 0x1fff7400, 7, 0x1b },
        { 30, 0x1fff7400, 7, 0x19 },   { 30, 0x1fff7400, 7, 0x17 },
        { 30, 0x1fff7400, 7, 0x15 },   { 30, 0x1fff7400, 7, 0x13 },
        { 30, 0x1fff7400, 7, 0x11 },   { 30, 0x1fff7400, 7,  0xf },
        { 30, 0x1fff7400, 7,  0xd },   { 30, 0x1fff7400, 7,  0xb },
        { 30, 0x1fff7400, 7,  0x9 },   { 30, 0x1fff7400, 7,  0x7 },
        { 30, 0x1fff7400, 7,  0x5 },   { 30, 0x1fff7400, 7,  0x3 },
        { 30, 0x1fff7400, 7,  0x1 },   {  0,          0, 0,    0 }
    },

    /*
     * prefixed with 13 zeroes
     */
    {
        { 12,      0xff7, 0,    0 },   { 16,     0xffe7, 0,    0 },
        { 16,     0xffe5, 0,    0 },   { 20,    0xfffcf, 0,    0 },
        { 20,    0xfffcd, 0,    0 },   { 20,    0xfffcb, 0,    0 },
        { 20,    0xfffc9, 0,    0 },   { 24,   0xffff9f, 0,    0 },
        { 24,   0xffff9d, 0,    0 },   { 24,   0xffff9b, 0,    0 },
        { 24,   0xffff99, 0,    0 },   { 24,   0xffff97, 0,    0 },
        { 24,   0xffff95, 0,    0 },   { 24,   0xffff93, 0,    0 },
        { 24,   0xffff91, 0,    0 },   { 28,  0xfffff5f, 0,    0 },
        { 28,  0xfffff5d, 0,    0 },   { 28,  0xfffff5b, 0,    0 },
        { 28,  0xfffff59, 0,    0 },   { 28,  0xfffff57, 0,    0 },
        { 28,  0xfffff55, 0,    0 },   { 28,  0xfffff53, 0,    0 },
        { 28,  0xfffff51, 0,    0 },   { 28,  0xfffff4f, 0,    0 },
        { 28,  0xfffff4d, 0,    0 },   { 28,  0xfffff4b, 0,    0 },
        { 28,  0xfffff49, 0,    0 },   { 28,  0xfffff47, 0,    0 },
        { 28,  0xfffff45, 0,    0 },   { 28,  0xfffff43, 0,    0 },
        { 28,  0xfffff41, 0,    0 },   { 32, 0xfffffeff, 0,    0 },
        { 32, 0xfffffefd, 0,    0 },   { 32, 0xfffffefb, 0,    0 },
        { 32, 0xfffffef9, 0,    0 },   { 32, 0xfffffef7, 0,    0 },
        { 32, 0xfffffef5, 0,    0 },   { 32, 0xfffffef3, 0,    0 },
        { 32, 0xfffffef1, 0,    0 },   { 32, 0xfffffeef, 0,    0 },
        { 32, 0xfffffeed, 0,    0 },   { 32, 0xfffffeeb, 0,    0 },
        { 32, 0xfffffee9, 0,    0 },   { 32, 0xfffffee7, 0,    0 },
        { 32, 0xfffffee5, 0,    0 },   { 32, 0xfffffee3, 0,    0 },
        { 32, 0xfffffee1, 0,    0 },   { 32, 0xfffffedf, 0,    0 },
        { 32, 0xfffffedd, 0,    0 },   { 32, 0xfffffedb, 0,    0 },
        { 32, 0xfffffed9, 0,    0 },   { 32, 0xfffffed7, 0,    0 },
        { 32, 0xfffffed5, 0,    0 },   { 32, 0xfffffed3, 0,    0 },
        { 32, 0xfffffed1, 0,    0 },   { 32, 0xfffffecf, 0,    0 },
        { 32, 0xfffffecd, 0,    0 },   { 32, 0xfffffecb, 0,    0 },
        { 32, 0xfffffec9, 0,    0 },   { 32, 0xfffffec7, 0,    0 },
        { 32, 0xfffffec5, 0,    0 },   { 32, 0xfffffec3, 0,    0 },
        { 32, 0xfffffec1, 0,    0 },   { 30, 0x3ffffff9, 7, 0x7f },
        { 30, 0x3ffffff9, 7, 0x7d },   { 30, 0x3ffffff9, 7, 0x7b },
        { 30, 0x3ffffff9, 7, 0x79 },   { 30, 0x3ffffff9, 7, 0x77 },
        { 30, 0x3ffffff9, 7, 0x75 },   { 30, 0x3ffffff9, 7, 0x73 },
        { 30, 0x3ffffff9, 7, 0x71 },   { 30, 0x3ffffff9, 7, 0x6f },
        { 30, 0x3ffffff9, 7, 0x6d },   { 30, 0x3ffffff9, 7, 0x6b },
        { 30, 0x3ffffff9, 7, 0x69 },   { 30, 0x3ffffff9, 7, 0x67 },
        { 30, 0x3ffffff9, 7, 0x65 },   { 30, 0x3ffffff9, 7, 0x63 },
        { 30, 0x3ffffff9, 7, 0x61 },   { 30, 0x3ffffff9, 7, 0x5f },
        { 30, 0x3ffffff9, 7, 0x5d },   { 30, 0x3ffffff9, 7, 0x5b },
        { 30, 0x3ffffff9, 7, 0x59 },   { 30, 0x3ffffff9, 7, 0x57 },
        { 30, 0x3ffffff9, 7, 0x55 },   { 30, 0x3ffffff9, 7, 0x53 },
        { 30, 0x3ffffff9, 7, 0x51 },   { 30, 0x3ffffff9, 7, 0x4f },
        { 30, 0x3ffffff9, 7, 0x4d },   { 30, 0x3ffffff9, 7, 0x4b },
        { 30, 0x3ffffff9, 7, 0x49 },   { 30, 0x3ffffff9, 7, 0x47 },
        { 30, 0x3ffffff9, 7, 0x45 },   { 30, 0x3ffffff9, 7, 0x43 },
        { 30, 0x3ffffff9, 7, 0x41 },   { 30, 0x3ffffff9, 7, 0x3f },
        { 30, 0x3ffffff9, 7, 0x3d },   { 30, 0x3ffffff9, 7, 0x3b },
        { 30, 0x3ffffff9, 7, 0x39 },   { 30, 0x3ffffff9, 7, 0x37 },
        { 30, 0x3ffffff9, 7, 0x35 },   { 30, 0x3ffffff9, 7, 0x33 },
        { 30, 0x3ffffff9, 7, 0x31 },   { 30, 0x3ffffff9, 7, 0x2f },
        { 30, 0x3ffffff9, 7, 0x2d },   { 30, 0x3ffffff9, 7, 0x2b },
        { 30, 0x3ffffff9, 7, 0x29 },   { 30, 0x3ffffff9, 7, 0x27 },
        { 30, 0x3ffffff9, 7, 0x25 },   { 30, 0x3ffffff9, 7, 0x23 },
        { 30, 0x3ffffff9, 7, 0x21 },   { 30, 0x3ffffff9, 7, 0x1f },
        { 30, 0x3ffffff9, 7, 0x1d },   { 30, 0x3ffffff9, 7, 0x1b },
        { 30, 0x3ffffff9, 7, 0x19 },   { 30, 0x3ffffff9, 7, 0x17 },
        { 30, 0x3ffffff9, 7, 0x15 },   { 30, 0x3ffffff9, 7, 0x13 },
        { 30, 0x3ffffff9, 7, 0x11 },   { 30, 0x3ffffff9, 7,  0xf },
        { 30, 0x3ffffff9, 7,  0xd },   { 30, 0x3ffffff9, 7,  0xb },
        { 30, 0x3ffffff9, 7,  0x9 },   { 30, 0x3ffffff9, 7,  0x7 },
        { 30, 0x3ffffff9, 7,  0x5 },   { 30, 0x3ffffff9, 7,  0x3 },
        { 30, 0x3ffffff9, 7,  0x1 },   {  0,          0, 0,    0 }
    },

    /*
     * prefixed with 14 zeroes
     */
    {
        { 13,     0x1ff1, 0,    0 },   { 16,     0xffeb, 0,    0 },
        { 16,     0xffe9, 0,    0 },   { 20,    0xfffd7, 0,    0 },
        { 20,    0xfffd5, 0,    0 },   { 20,    0xfffd3, 0,    0 },
        { 20,    0xfffd1, 0,    0 },   { 24,   0xffffaf, 0,    0 },
        { 24,   0xffffad, 0,    0 },   { 24,   0xffffab, 0,    0 },
        { 24,   0xffffa9, 0,    0 },   { 24,   0xffffa7, 0,    0 },
        { 24,   0xffffa5, 0,    0 },   { 24,   0xffffa3, 0,    0 },
        { 24,   0xffffa1, 0,    0 },   { 28,  0xfffff7f, 0,    0 },
        { 28,  0xfffff7d, 0,    0 },   { 28,  0xfffff7b, 0,    0 },
        { 28,  0xfffff79, 0,    0 },   { 28,  0xfffff77, 0,    0 },
        { 28,  0xfffff75, 0,    0 },   { 28,  0xfffff73, 0,    0 },
        { 28,  0xfffff71, 0,    0 },   { 28,  0xfffff6f, 0,    0 },
        { 28,  0xfffff6d, 0,    0 },   { 28,  0xfffff6b, 0,    0 },
        { 28,  0xfffff69, 0,    0 },   { 28,  0xfffff67, 0,    0 },
        { 28,  0xfffff65, 0,    0 },   { 28,  0xfffff63, 0,    0 },
        { 28,  0xfffff61, 0,    0 },   { 27,  0x7fffff8, 6, 0x3f },
        { 27,  0x7fffff8, 6, 0x3d },   { 27,  0x7fffff8, 6, 0x3b },
        { 27,  0x7fffff8, 6, 0x39 },   { 27,  0x7fffff8, 6, 0x37 },
        { 27,  0x7fffff8, 6, 0x35 },   { 27,  0x7fffff8, 6, 0x33 },
        { 27,  0x7fffff8, 6, 0x31 },   { 27,  0x7fffff8, 6, 0x2f },
        { 27,  0x7fffff8, 6, 0x2d },   { 27,  0x7fffff8, 6, 0x2b },
        { 27,  0x7fffff8, 6, 0x29 },   { 27,  0x7fffff8, 6, 0x27 },
        { 27,  0x7fffff8, 6, 0x25 },   { 27,  0x7fffff8, 6, 0x23 },
        { 27,  0x7fffff8, 6, 0x21 },   { 27,  0x7fffff8, 6, 0x1f },
        { 27,  0x7fffff8, 6, 0x1d },   { 27,  0x7fffff8, 6, 0x1b },
        { 27,  0x7fffff8, 6, 0x19 },   { 27,  0x7fffff8, 6, 0x17 },
        { 27,  0x7fffff8, 6, 0x15 },   { 27,  0x7fffff8, 6, 0x13 },
        { 27,  0x7fffff8, 6, 0x11 },   { 27,  0x7fffff8, 6,  0xf },
        { 27,  0x7fffff8, 6,  0xd },   { 27,  0x7fffff8, 6,  0xb },
        { 27,  0x7fffff8, 6,  0x9 },   { 27,  0x7fffff8, 6,  0x7 },
        { 27,  0x7fffff8, 6,  0x5 },   { 27,  0x7fffff8, 6,  0x3 },
        { 27,  0x7fffff8, 6,  0x1 },   { 30, 0x3ffffffa, 7, 0x7f },
        { 30, 0x3ffffffa, 7, 0x7d },   { 30, 0x3ffffffa, 7, 0x7b },
        { 30, 0x3ffffffa, 7, 0x79 },   { 30, 0x3ffffffa, 7, 0x77 },
        { 30, 0x3ffffffa, 7, 0x75 },   { 30, 0x3ffffffa, 7, 0x73 },
        { 30, 0x3ffffffa, 7, 0x71 },   { 30, 0x3ffffffa, 7, 0x6f },
        { 30, 0x3ffffffa, 7, 0x6d },   { 30, 0x3ffffffa, 7, 0x6b },
        { 30, 0x3ffffffa, 7, 0x69 },   { 30, 0x3ffffffa, 7, 0x67 },
        { 30, 0x3ffffffa, 7, 0x65 },   { 30, 0x3ffffffa, 7, 0x63 },
        { 30, 0x3ffffffa, 7, 0x61 },   { 30, 0x3ffffffa, 7, 0x5f },
        { 30, 0x3ffffffa, 7, 0x5d },   { 30, 0x3ffffffa, 7, 0x5b },
        { 30, 0x3ffffffa, 7, 0x59 },   { 30, 0x3ffffffa, 7, 0x57 },
        { 30, 0x3ffffffa, 7, 0x55 },   { 30, 0x3ffffffa, 7, 0x53 },
        { 30, 0x3ffffffa, 7, 0x51 },   { 30, 0x3ffffffa, 7, 0x4f },
        { 30, 0x3ffffffa, 7, 0x4d },   { 30, 0x3ffffffa, 7, 0x4b },
        { 30, 0x3ffffffa, 7, 0x49 },   { 30, 0x3ffffffa, 7, 0x47 },
        { 30, 0x3ffffffa, 7, 0x45 },   { 30, 0x3ffffffa, 7, 0x43 },
        { 30, 0x3ffffffa, 7, 0x41 },   { 30, 0x3ffffffa, 7, 0x3f },
        { 30, 0x3ffffffa, 7, 0x3d },   { 30, 0x3ffffffa, 7, 0x3b },
        { 30, 0x3ffffffa, 7, 0x39 },   { 30, 0x3ffffffa, 7, 0x37 },
        { 30, 0x3ffffffa, 7, 0x35 },   { 30, 0x3ffffffa, 7, 0x33 },
        { 30, 0x3ffffffa, 7, 0x31 },   { 30, 0x3ffffffa, 7, 0x2f },
        { 30, 0x3ffffffa, 7, 0x2d },   { 30, 0x3ffffffa, 7, 0x2b },
        { 30, 0x3ffffffa, 7, 0x29 },   { 30, 0x3ffffffa, 7, 0x27 },
        { 30, 0x3ffffffa, 7, 0x25 },   { 30, 0x3ffffffa, 7, 0x23 },
        { 30, 0x3ffffffa, 7, 0x21 },   { 30, 0x3ffffffa, 7, 0x1f },
        { 30, 0x3ffffffa, 7, 0x1d },   { 30, 0x3ffffffa, 7, 0x1b },
        { 30, 0x3ffffffa, 7, 0x19 },   { 30, 0x3ffffffa, 7, 0x17 },
        { 30, 0x3ffffffa, 7, 0x15 },   { 30, 0x3ffffffa, 7, 0x13 },
        { 30, 0x3ffffffa, 7, 0x11 },   { 30, 0x3ffffffa, 7,  0xf },
        { 30, 0x3ffffffa, 7,  0xd },   { 30, 0x3ffffffa, 7,  0xb },
        { 30, 0x3ffffffa, 7,  0x9 },   { 30, 0x3ffffffa, 7,  0x7 },
        { 30, 0x3ffffffa, 7,  0x5 },   { 30, 0x3ffffffa, 7,  0x3 },
        { 30, 0x3ffffffa, 7,  0x1 },   {  0,          0, 0,    0 }
    },

    /*
     * prefixed with 15 zeroes
     */
    {
        { 13,     0x1ff3, 0,    0 },   {  2,        0x3, 0,    0 },
        {  2,        0x1, 0,    0 },   {  3,        0x7, 0,    0 },
        {  3,        0x5, 0,    0 },   {  3,        0x3, 0,    0 },
        {  3,        0x1, 0,    0 },   { 31, 0x7ffffffb, 4,  0xf },
        { 31, 0x7ffffffb, 4,  0xd },   { 31, 0x7ffffffb, 4,  0xb },
        { 31, 0x7ffffffb, 4,  0x9 },   { 31, 0x7ffffffb, 4,  0x7 },
        { 31, 0x7ffffffb, 4,  0x5 },   { 31, 0x7ffffffb, 4,  0x3 },
        { 31, 0x7ffffffb, 4,  0x1 },   {  5,       0x1f, 0,    0 },
        {  5,       0x1d, 0,    0 },   {  5,       0x1b, 0,    0 },
        {  5,       0x19, 0,    0 },   {  5,       0x17, 0,    0 },
        {  5,       0x15, 0,    0 },   {  5,       0x13, 0,    0 },
        {  5,       0x11, 0,    0 },   {  5,        0xf, 0,    0 },
        {  5,        0xd, 0,    0 },   {  5,        0xb, 0,    0 },
        {  5,        0x9, 0,    0 },   {  5,        0x7, 0,    0 },
        {  5,        0x5, 0,    0 },   {  5,        0x3, 0,    0 },
        {  5,        0x1, 0,    0 },   {  6,       0x3f, 0,    0 },
        {  6,       0x3d, 0,    0 },   {  6,       0x3b, 0,    0 },
        {  6,       0x39, 0,    0 },   {  6,       0x37, 0,    0 },
        {  6,       0x35, 0,    0 },   {  6,       0x33, 0,    0 },
        {  6,       0x31, 0,    0 },   {  6,       0x2f, 0,    0 },
        {  6,       0x2d, 0,    0 },   {  6,       0x2b, 0,    0 },
        {  6,       0x29, 0,    0 },   {  6,       0x27, 0,    0 },
        {  6,       0x25, 0,    0 },   {  6,       0x23, 0,    0 },
        {  6,       0x21, 0,    0 },   {  6,       0x1f, 0,    0 },
        {  6,       0x1d, 0,    0 },   {  6,       0x1b, 0,    0 },
        {  6,       0x19, 0,    0 },   {  6,       0x17, 0,    0 },
        {  6,       0x15, 0,    0 },   {  6,       0x13, 0,    0 },
        {  6,       0x11, 0,    0 },   {  6,        0xf, 0,    0 },
        {  6,        0xd, 0,    0 },   {  6,        0xb, 0,    0 },
        {  6,        0x9, 0,    0 },   {  6,        0x7, 0,    0 },
        {  6,        0x5, 0,    0 },   {  6,        0x3, 0,    0 },
        {  6,        0x1, 0,    0 },   {  7,       0x7f, 0,    0 },
        {  7,       0x7d, 0,    0 },   {  7,       0x7b, 0,    0 },
        {  7,       0x79, 0,    0 },   {  7,       0x77, 0,    0 },
        {  7,       0x75, 0,    0 },   {  7,       0x73, 0,    0 },
        {  7,       0x71, 0,    0 },   {  7,       0x6f, 0,    0 },
        {  7,       0x6d, 0,    0 },   {  7,       0x6b, 0,    0 },
        {  7,       0x69, 0,    0 },   {  7,       0x67, 0,    0 },
        {  7,       0x65, 0,    0 },   {  7,       0x63, 0,    0 },
        {  7,       0x61, 0,    0 },   {  7,       0x5f, 0,    0 },
        {  7,       0x5d, 0,    0 },   {  7,       0x5b, 0,    0 },
        {  7,       0x59, 0,    0 },   {  7,       0x57, 0,    0 },
        {  7,       0x55, 0,    0 },   {  7,       0x53, 0,    0 },
        {  7,       0x51, 0,    0 },   {  7,       0x4f, 0,    0 },
        {  7,       0x4d, 0,    0 },   {  7,       0x4b, 0,    0 },
        {  7,       0x49, 0,    0 },   {  7,       0x47, 0,    0 },
        {  7,       0x45, 0,    0 },   {  7,       0x43, 0,    0 },
        {  7,       0x41, 0,    0 },   {  7,       0x3f, 0,    0 },
        {  7,       0x3d, 0,    0 },   {  7,       0x3b, 0,    0 },
        {  7,       0x39, 0,    0 },   {  7,       0x37, 0,    0 },
        {  7,       0x35, 0,    0 },   {  7,       0x33, 0,    0 },
        {  7,       0x31, 0,    0 },   {  7,       0x2f, 0,    0 },
        {  7,       0x2d, 0,    0 },   {  7,       0x2b, 0,    0 },
        {  7,       0x29, 0,    0 },   {  7,       0x27, 0,    0 },
        {  7,       0x25, 0,    0 },   {  7,       0x23, 0,    0 },
        {  7,       0x21, 0,    0 },   {  7,       0x1f, 0,    0 },
        {  7,       0x1d, 0,    0 },   {  7,       0x1b, 0,    0 },
        {  7,       0x19, 0,    0 },   {  7,       0x17, 0,    0 },
        {  7,       0x15, 0,    0 },   {  7,       0x13, 0,    0 },
        {  7,       0x11, 0,    0 },   {  7,        0xf, 0,    0 },
        {  7,        0xd, 0,    0 },   {  7,        0xb, 0,    0 },
        {  7,        0x9, 0,    0 },   {  7,        0x7, 0,    0 },
        {  7,        0x5, 0,    0 },   {  7,        0x3, 0,    0 },
        {  7,        0x1, 0,    0 },   {  0,          0, 0,    0 }
    }
};

VlcMagic _magic_values[] = {
    { 0x0, 0, 1 },
    { 0x1, 0, 2 },
    { 0x4, 0, 3 },
    { 0xB, 1, 1 },
    { 0xC, 0, 4 },
    { 0x1A, 0, 5 },
    { 0x1B, 2, 1 },
    { 0x38, 3, 1 },
    { 0x39, 1, 2 },
    { 0x3A, 1, 3 },
    { 0x3B, 0, 6 },
    { 0x78, 4, 1 },
    { 0x79, 5, 1 },
    { 0x7A, 6, 1 },
    { 0x7B, 2, 2 },
    { 0xF8, 1, 4 },
    { 0xF9, 7, 1 },
    { 0xFA, 8, 1 },
    { 0xFB, 3, 2 },
    { 0x1F8, 4, 2 },
    { 0x1F9, 5, 2 },
    { 0x1FA, 2, 3 },
    { 0x1FB, 2, 4 },
    { 0x3F8, 1, 5 },
    { 0x3F9, 1, 6 },
    { 0x3FA, 0, 7 },
    { 0x3FB, 9, 1 },
    { 0x7F8, 10, 1 },
    { 0x7F9, 11, 1 },
    { 0x7FA, 12, 1 },
    { 0x7FB, 13, 1 },
    { 0xFF8, 14, 1 },
    { 0xFF9, 15, 1 },
    { 0xFFA, 6, 2 },
    { 0xFFB, 7, 2 },
    { 0x1FF8, 8, 2 },
    { 0x1FF9, 9, 2 },
    { 0x1FFA, 10, 2 },
    { 0x1FFB, 11, 2 },
    { 0x3FF8, 12, 2 },
    { 0x3FF9, 13, 2 },
    { 0x3FFA, 14, 2 },
    { 0x3FFB, 3, 3 },
    { 0x7FF8, 4, 3 },
    { 0x7FF9, 5, 3 },
    { 0x7FFA, 6, 3 },
    { 0x7FFB, 7, 3 },
    { 0xFFF8, 8, 3 },
    { 0xFFF9, 9, 3 },
    { 0xFFFA, 10, 3 },
    { 0xFFFB, 11, 3 },
    { 0x1FFF8, 12, 3 },
    { 0x1FFF9, 13, 3 },
    { 0x1FFFA, 14, 3 },
    { 0x1FFFB, 3, 4 },
    { 0x3FFF8, 4, 4 },
    { 0x3FFF9, 5, 4 },
    { 0x3FFFA, 6, 4 },
    { 0x3FFFB, 7, 4 },
    { 0x7FFF8, 8, 4 },
    { 0x7FFF9, 9, 4 },
    { 0x7FFFA, 10, 4 },
    { 0x7FFFB, 11, 4 },
    { 0xFFFF8, 12, 4 },
    { 0xFFFF9, 13, 4 },
    { 0xFFFFA, 14, 4 },
    { 0xFFFFB, 2, 5 },
    { 0x1FFFF8, 3, 5 },
    { 0x1FFFF9, 4, 5 },
    { 0x1FFFFA, 5, 5 },
    { 0x1FFFFB, 6, 5 },
    { 0x3FFFF8, 7, 5 },
    { 0x3FFFF9, 8, 5 },
    { 0x3FFFFA, 9, 5 },
    { 0x3FFFFB, 10, 5 },
    { 0x7FFFF8, 11, 5 },
    { 0x7FFFF9, 12, 5 },
    { 0x7FFFFA, 13, 5 },
    { 0x7FFFFB, 14, 5 },
    { 0xFFFFF8, 2, 6 },
    { 0xFFFFF9, 3, 6 },
    { 0xFFFFFA, 4, 6 },
    { 0xFFFFFB, 5, 6 },
    { 0x1FFFFF8, 6, 6 },
    { 0x1FFFFF9, 7, 6 },
    { 0x1FFFFFA, 8, 6 },
    { 0x1FFFFFB, 9, 6 },
    { 0x3FFFFF8, 10, 6 },
    { 0x3FFFFF9, 11, 6 },
    { 0x3FFFFFA, 12, 6 },
    { 0x3FFFFFB, 13, 6 },
    { 0x7FFFFF8, 14, 6 },
    { 0x7FFFFF9, 1, 7 },
    { 0x7FFFFFA, 2, 7 },
    { 0x7FFFFFB, 3, 7 },
    { 0xFFFFFF8, 4, 7 },
    { 0xFFFFFF9, 5, 7 },
    { 0xFFFFFFA, 6, 7 },
    { 0xFFFFFFB, 7, 7 },
    { 0x1FFFFFF8, 8, 7 },
    { 0x1FFFFFF9, 9, 7 },
    { 0x1FFFFFFA, 10, 7 },
    { 0x1FFFFFFB, 11, 7 },
    { 0x3FFFFFF8, 12, 7 },
    { 0x3FFFFFF9, 13, 7 },
    { 0x3FFFFFFA, 14, 7 }
};

/*
 * _find_magic
 *
 * Internal helper-function used to locate a given
 * VlcMagic entry.
 */
VlcMagic *_find_magic(guint magic)
{
    gint low = 0;
    gint high = sizeof(_magic_values) / sizeof(VlcMagic) - 1;
    gint mid;

    while (low <= high) {
        mid = (low + high) / 2;

        if (_magic_values[mid].magic < magic)
            low = mid + 1;
        else if (_magic_values[mid].magic > magic)
            high = mid - 1;
        else
            return &_magic_values[mid];
    }

    return NULL;
}

/*
 * _initialize_vlcdec_lookup
 *
 * Internal helper-function used to initialize
 * the lookup-table used by the VLC-decoder.
 */
void _initialize_vlcdec_lookup(gint8 *lookup_tbl)
{
    gint8 util_buf[3072];
    gint v1_start, v1_end, v1_dec, util_buf_offset;
    gint util_buf_offset_inc, buf1_val, samples_offset;
    gint v1, v2;
    gint8 *p, *p1, *p2, *p3;

    util_buf[0] = 0;
    util_buf[1] = 0;
    util_buf[2] = 0;
    util_buf[3] = 1;
    util_buf[4] = 1;
    util_buf[5] = 1;
    util_buf[765] = 1;
    util_buf[766] = 0;
    util_buf[767] = 1;
    lookup_tbl[255] = 255;
    lookup_tbl[256] = 1;

    v1_start = -3;
    v1_dec = 4;

    util_buf_offset = 11;
    util_buf_offset_inc = 12;
    buf1_val = 2;

    samples_offset = 509;

    do {
        v1 = v1_start;
        v1_end = -(abs(v1_start) + 1) / 2;
        v2 = 0;

        p2 = util_buf + util_buf_offset - 3;

        do {
            p1 = util_buf + ((v1 & 0xff) * 3);
            p1[0] = buf1_val;
            p1[1] = v2;
            p1[2] = buf1_val;

            p2[1] = buf1_val;
            p2[2] = v2 + 1;
            p2[3] = buf1_val;

            p3 = lookup_tbl + samples_offset + v2 + 1;
            p3[0] = v1 & 0xff;
            p3[1] = -(v1 & 0xff);

            v1++;
            v2 += 2;
            p2 -= 3;
        } while (v1 <= v1_end);

        v1_start -= v1_dec;
        v1_dec *= 2;

        util_buf_offset += util_buf_offset_inc;
        util_buf_offset_inc *= 2;
        buf1_val++;

        samples_offset += 255;
    } while (buf1_val <= 7);

    p = lookup_tbl + 1785 + util_buf[388];
    p[0] = 129;
}

