#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Vampire: the Masquerade - Coteries of New York
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220401.4

# Set game-specific variables

GAME_ID='vampire-the-masquerade-coteries-of-new-york'
GAME_NAME='Vampire: The Masquerade - Coteries of New York'

ARCHIVE_BASE_2='vampire_the_masquerade_coteries_of_new_york_1_0_12_52098.sh'
ARCHIVE_BASE_2_MD5='035735d7a7717c4c31cce156511ec8b0'
ARCHIVE_BASE_2_TYPE='mojosetup'
ARCHIVE_BASE_2_SIZE='3300000'
ARCHIVE_BASE_2_VERSION='1.0.12-gog52098'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/vampire_the_masquerade_coteries_of_new_york'

ARCHIVE_BASE_1='vampire_the_masquerade_coteries_of_new_york_1_0_9_45543.sh'
ARCHIVE_BASE_1_MD5='6310c15fabd1768d00faa57f83f2de5e'
ARCHIVE_BASE_1_TYPE='mojosetup'
ARCHIVE_BASE_1_SIZE='3300000'
ARCHIVE_BASE_1_VERSION='1.0.9-gog45543'

ARCHIVE_BASE_0='vampire_the_masquerade_coteries_of_new_york_1_0_7_40980.sh'
ARCHIVE_BASE_0_MD5='146113ea6b7295104413d8ce2b1fbf4e'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='3200000'
ARCHIVE_BASE_0_VERSION='1.0.7-gog40980'

UNITY3D_NAME='VtM Coteries of New York'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN_FILES='
VtM?Coteries?of?New?York.x86_64
VtM?Coteries?of?New?York_Data/MonoBleedingEdge
VtM?Coteries?of?New?York_Data/Plugins
UnityPlayer.so'
ARCHIVE_GAME_DATA_FILES='
VtM?Coteries?of?New?York_Data'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6"

# Default to windowed mode on first launch

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Default to windowed mode on first launch
config_file="${XDG_CONFIG_HOME:="$HOME/.config"}/unity3d/DrawDistance/VtM Coteries of New York/Saves/Settings.save"
if [ ! -e "$config_file" ]; then
	mkdir --parents "$(dirname "$config_file")"
	cat > "$config_file" <<- EOF
	{"FullScreenMode":false}
	EOF
fi'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
