/*###############################################################################
# Linux Management Providers (LMP), EthernetPort provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_ETHERNETPORTCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_ETHERNETPORTCONFORMSTOPROFILEACCESS_H_

#include "EthernetPort_Common.h"

#include "OpenDRIM_EthernetPortConformsToProfile.h"
#include "assocOpenDRIM_EthernetPortConformsToProfile.h"

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_unload(string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_EthernetPortConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_EthernetPortConformsToProfile& instance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPortConformsToProfile& newInstance, const OpenDRIM_EthernetPortConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPortConformsToProfile& instance, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_EthernetPortConformsToProfile& instance, string& errorMessage);

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_EthernetPortConformsToProfile>& OpenDRIM_EthernetPortConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_EthernetPortConformsToProfile>& OpenDRIM_EthernetPortConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int EthernetPort_OpenDRIM_EthernetPortConformsToProfile_populate(OpenDRIM_EthernetPortConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_ETHERNETPORTCONFORMSTOPROFILEACCESS_H_*/
