/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.internal.rdt.sync.ui.SynchronizePropertiesDescriptor;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeProperties;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizePropertiesDescriptor;

public class SynchronizePropertiesRegistry {
    public static final String SYNCHRONIZE_PROPERTIES_EXTENSION = "synchronizeProperties";
    private static List<ISynchronizePropertiesDescriptor> fAllDescriptors;

    public static ISynchronizePropertiesDescriptor[] getDescriptors() {
        SynchronizePropertiesRegistry.loadDescriptors();
        if (fAllDescriptors != null) {
            return fAllDescriptors.toArray(new ISynchronizePropertiesDescriptor[fAllDescriptors.size()]);
        }
        return new ISynchronizePropertiesDescriptor[0];
    }

    public static ISynchronizeProperties getSynchronizePropertiesForProject(IProject project) {
        ISynchronizePropertiesDescriptor[] iSynchronizePropertiesDescriptorArray = SynchronizePropertiesRegistry.getDescriptors();
        int n = iSynchronizePropertiesDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISynchronizePropertiesDescriptor descriptor = iSynchronizePropertiesDescriptorArray[n2];
            try {
                if (project.hasNature(descriptor.getNature())) {
                    return descriptor.getProperties();
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return null;
    }

    private static void loadDescriptors() {
        IExtensionPoint point;
        if (fAllDescriptors == null && (point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.sync.ui", SYNCHRONIZE_PROPERTIES_EXTENSION)) != null) {
            fAllDescriptors = new ArrayList<ISynchronizePropertiesDescriptor>();
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    fAllDescriptors.add(new SynchronizePropertiesDescriptor(configElement));
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

