/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor.config;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class CudaWordRule
implements IRule {
    protected static final int UNDEFINED = -1;
    protected IWordDetector fDetector;
    protected IToken fDefaultToken;
    protected int fColumn = -1;
    protected Map<String, IToken> fWords = new HashMap<String, IToken>();
    private StringBuffer fBuffer = new StringBuffer();

    public CudaWordRule(IWordDetector detector) {
        this(detector, Token.UNDEFINED);
    }

    public CudaWordRule(IWordDetector detector, IToken defaultToken) {
        this.fDetector = detector;
        this.fDefaultToken = defaultToken;
    }

    public void addWord(String word, IToken token) {
        this.fWords.put(word, token);
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (Character.isJavaIdentifierStart((char)c) || c == 35 && scanner.getColumn() == 1) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while (Character.isJavaIdentifierPart((char)(c = scanner.read())));
            scanner.unread();
            IToken token = this.fWords.get(this.fBuffer.toString());
            if (token != null) {
                return token;
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

