/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;

public class AnalysisResultKernelGridSize
extends AnalysisResult {
    private TimelineDevice device;
    private TimelineIntervalKernel kernel;

    public AnalysisResultKernelGridSize(TimelineDevice device, TimelineIntervalKernel kernel) {
        super(AnalysisDescriptor.KERNEL_LATENCY_GRID_SIZE);
        this.device = device;
        this.kernel = kernel;
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        String desc = super.getDescription(otpt);
        desc = desc.replace("%DEVICE%", "\"" + this.device.getName() + "\"");
        int sms = this.device.getNumMultiprocessors();
        desc = desc.replace("%SMS%", String.valueOf(sms) + (sms > 1 ? " SMs" : " SM"));
        OccupancyCalculator oc = new OccupancyCalculator(this.kernel, this.device);
        int blocksPerSM = oc.getBlocksPerSM();
        desc = desc.replace("%BLOCKSPERSM%", String.valueOf(blocksPerSM) + (blocksPerSM > 1 ? " blocks" : " block"));
        int totalBlocks = blocksPerSM * sms;
        desc = desc.replace("%TOTALBLOCKS%", String.valueOf(totalBlocks) + (totalBlocks > 1 ? " blocks" : " block"));
        return desc;
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(1);
        TimelineIntervalPair pair = new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel);
        pairs.add(pair);
        return pairs;
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                ViperHelp.displayHelp(ViperHelp.OCCUPANCY_GRID_SIZE);
            }
        };
    }
}

