/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSWizardHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Composite;

public class STDWizardHandler
extends MBSWizardHandler {
    public STDWizardHandler(Composite p, IWizard w) {
        super(Messages.StdBuildWizard_0, p, w);
    }

    @Override
    public void addTc(IToolChain tc) {
        if (tc == null) {
            this.full_tcs.put(Messages.StdProjectTypeHandler_0, null);
        } else {
            if (tc.isAbstract() || tc.isSystemObject()) {
                return;
            }
            this.full_tcs.put(tc.getUniqueRealName(), tc);
        }
    }

    @Override
    public void createProject(IProject project, boolean defaults, boolean onFinish, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 100);
            this.setProjectDescription(project, defaults, onFinish, monitor);
            this.doTemplatesPostProcess(project);
            this.doCustom(project);
            monitor.worked(30);
        }
        finally {
            monitor.done();
        }
    }

    private void setProjectDescription(IProject project, boolean defaults, boolean onFinish, IProgressMonitor monitor) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.createProjectDescription(project, false, !onFinish);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        ManagedProject mProj = new ManagedProject(des);
        info.setManagedProject((IManagedProject)mProj);
        monitor.worked(20);
        this.cfgs = CfgHolder.unique(this.getCfgItems(false));
        this.cfgs = CfgHolder.reorder(this.cfgs);
        int work = 50 / this.cfgs.length;
        int i = 0;
        while (i < this.cfgs.length) {
            String s = this.cfgs[i].getToolChain() == null ? "0" : ((ToolChain)this.cfgs[i].getToolChain()).getId();
            Configuration cfg = new Configuration(mProj, (ToolChain)this.cfgs[i].getToolChain(), ManagedBuildManager.calculateChildId((String)s, null), this.cfgs[i].getName());
            this.cfgs[i].setConfiguration((IConfiguration)cfg);
            IBuilder bld = cfg.getEditableBuilder();
            if (bld != null) {
                if (bld.isInternalBuilder()) {
                    IConfiguration prefCfg = ManagedBuildManager.getPreferenceConfiguration((boolean)false);
                    IBuilder prefBuilder = prefCfg.getBuilder();
                    cfg.changeBuilder(prefBuilder, ManagedBuildManager.calculateChildId((String)cfg.getId(), null), prefBuilder.getName());
                    bld = cfg.getEditableBuilder();
                    bld.setBuildPath(null);
                }
                bld.setManagedBuildOn(false);
            } else {
                System.out.println(Messages.StdProjectTypeHandler_3);
            }
            cfg.setArtifactName(mProj.getDefaultArtifactName());
            CConfigurationData data = cfg.getConfigurationData();
            des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
            monitor.worked(work);
            ++i;
        }
        mngr.setProjectDescription(project, des);
    }

    public boolean canCreateWithoutToolchain() {
        return true;
    }

    @Override
    public void convertProject(IProject proj, IProgressMonitor monitor) throws CoreException {
        this.setProjectDescription(proj, true, true, monitor);
    }

    @Override
    public IToolChain[] getSelectedToolChains() {
        if (this.full_tcs.size() == 0 || this.table.getSelection().length == 0) {
            return new IToolChain[1];
        }
        return super.getSelectedToolChains();
    }
}

